/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.annotation.IntDef;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppOpsManager;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.ProfilerInfo;
import android.app.ResultInfo;
import android.app.WaitResult;
import android.app.admin.IDevicePolicyManager;
import android.content.ComponentName;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.DisplayManagerInternal;
import android.hardware.display.VirtualDisplay;
import android.hardware.input.InputManagerInternal;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.Trace;
import android.os.TransactionTooLargeException;
import android.os.UserManager;
import android.os.WorkSource;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.IntArray;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.InputEvent;
import android.view.Surface;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.TransferPipe;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityMetricsLogger;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.ConfigurationContainer;
import com.android.server.am.EventLogTags;
import com.android.server.am.KeyguardController;
import com.android.server.am.LockTaskNotify;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.PinnedActivityStack;
import com.android.server.am.ProcessRecord;
import com.android.server.am.RecentTasks;
import com.android.server.am.TaskRecord;
import com.android.server.am.UserState;
import com.android.server.wm.PinnedStackWindowController;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ActivityStackSupervisor
extends ConfigurationContainer
implements DisplayManager.DisplayListener {
    private static final String TAG = "ActivityManager";
    private static final String TAG_CONTAINERS = "ActivityManager";
    private static final String TAG_FOCUS = "ActivityManager";
    private static final String TAG_IDLE = "ActivityManager";
    private static final String TAG_LOCKTASK = "ActivityManager";
    private static final String TAG_PAUSE = "ActivityManager";
    private static final String TAG_RECENTS = "ActivityManager";
    private static final String TAG_RELEASE = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    static final String TAG_TASKS = "ActivityManager";
    private static final String TAG_VISIBLE_BEHIND = "ActivityManager";
    static final int IDLE_TIMEOUT = 10000;
    static final int SLEEP_TIMEOUT = 5000;
    static final int LAUNCH_TIMEOUT = 10000;
    static final int IDLE_TIMEOUT_MSG = 100;
    static final int IDLE_NOW_MSG = 101;
    static final int RESUME_TOP_ACTIVITY_MSG = 102;
    static final int SLEEP_TIMEOUT_MSG = 103;
    static final int LAUNCH_TIMEOUT_MSG = 104;
    static final int HANDLE_DISPLAY_ADDED = 105;
    static final int HANDLE_DISPLAY_CHANGED = 106;
    static final int HANDLE_DISPLAY_REMOVED = 107;
    static final int CONTAINER_CALLBACK_VISIBILITY = 108;
    static final int LOCK_TASK_START_MSG = 109;
    static final int LOCK_TASK_END_MSG = 110;
    static final int CONTAINER_CALLBACK_TASK_LIST_EMPTY = 111;
    static final int LAUNCH_TASK_BEHIND_COMPLETE = 112;
    static final int SHOW_LOCK_TASK_ESCAPE_MESSAGE_MSG = 113;
    static final int REPORT_MULTI_WINDOW_MODE_CHANGED_MSG = 114;
    static final int REPORT_PIP_MODE_CHANGED_MSG = 115;
    private static final String VIRTUAL_DISPLAY_BASE_NAME = "ActivityViewVirtualDisplay";
    private static final String LOCK_TASK_TAG = "Lock-to-App";
    static final boolean CREATE_IF_NEEDED = true;
    static final boolean PRESERVE_WINDOWS = true;
    static final boolean ON_TOP = true;
    static final boolean MOVING = true;
    static final boolean FORCE_FOCUS = true;
    static final boolean DEFER_RESUME = true;
    static final boolean REMOVE_FROM_RECENTS = true;
    static final boolean PAUSE_IMMEDIATELY = true;
    static final int MATCH_TASK_IN_STACKS_ONLY = 0;
    static final int MATCH_TASK_IN_STACKS_OR_RECENT_TASKS = 1;
    static final int MATCH_TASK_IN_STACKS_OR_RECENT_TASKS_AND_RESTORE = 2;
    private static final ArrayMap<String, String> ACTION_TO_RUNTIME_PERMISSION = new ArrayMap();
    private static final int ACTIVITY_RESTRICTION_NONE = 0;
    private static final int ACTIVITY_RESTRICTION_PERMISSION = 1;
    private static final int ACTIVITY_RESTRICTION_APPOP = 2;
    private IBinder mToken = new Binder();
    private IStatusBarService mStatusBarService;
    private IDevicePolicyManager mDevicePolicyManager;
    static final boolean VALIDATE_WAKE_LOCK_CALLER = false;
    private static final int MAX_TASK_IDS_PER_USER = 100000;
    final ActivityManagerService mService;
    private RecentTasks mRecentTasks;
    final ActivityStackSupervisorHandler mHandler;
    WindowManagerService mWindowManager;
    DisplayManager mDisplayManager;
    private int mNextFreeStackId = 7;
    private final SparseIntArray mCurTaskIdForUser = new SparseIntArray(20);
    int mCurrentUser;
    ActivityStack mHomeStack;
    ActivityStack mFocusedStack;
    private ActivityStack mLastFocusedStack;
    final ArrayList<ActivityRecord> mActivitiesWaitingForVisibleActivity = new ArrayList();
    private final ArrayList<WaitInfo> mWaitingForActivityVisible = new ArrayList();
    final ArrayList<WaitResult> mWaitingActivityLaunched = new ArrayList();
    final ArrayList<ActivityRecord> mStoppingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mFinishingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mGoingToSleepActivities = new ArrayList();
    final ArrayList<ActivityRecord> mMultiWindowModeChangedActivities = new ArrayList();
    final ArrayList<ActivityRecord> mPipModeChangedActivities = new ArrayList();
    Rect mPipModeChangedTargetStackBounds;
    final ArrayList<UserState> mStartingUsers = new ArrayList();
    boolean mUserLeaving = false;
    boolean mSleepTimeout = false;
    PowerManager.WakeLock mLaunchingActivity;
    PowerManager.WakeLock mGoingToSleep;
    SparseIntArray mUserStackInFront = new SparseIntArray(2);
    SparseArray<ActivityContainer> mActivityContainers = new SparseArray();
    private final SparseArray<ActivityDisplay> mActivityDisplays = new SparseArray();
    private final SparseArray<IntArray> mDisplayAccessUIDs = new SparseArray();
    private DisplayManagerInternal mDisplayManagerInternal;
    private InputManagerInternal mInputManagerInternal;
    ArrayList<TaskRecord> mLockTaskModeTasks = new ArrayList();
    private int mLockTaskModeState;
    private LockTaskNotify mLockTaskNotify;
    boolean inResumeTopActivity;
    private final Rect tempRect = new Rect();
    int mDefaultMinSizeOfResizeableTask = -1;
    private boolean mTaskLayersChanged = true;
    final ActivityMetricsLogger mActivityMetricsLogger;
    private final FindTaskResult mTmpFindTaskResult = new FindTaskResult();
    private SparseIntArray mTmpOrderedDisplayIds = new SparseIntArray();
    boolean mAppVisibilitiesChangedSinceLastPause;
    private final ArraySet<Integer> mResizingTasksDuringAnimation = new ArraySet();
    private boolean mAllowDockedStackResize = true;
    boolean mIsDockMinimized;
    final KeyguardController mKeyguardController;

    @Override
    protected int getChildCount() {
        return this.mActivityDisplays.size();
    }

    protected ActivityDisplay getChildAt(int index) {
        return this.mActivityDisplays.valueAt(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return null;
    }

    Configuration getDisplayOverrideConfiguration(int displayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        return activityDisplay.getOverrideConfiguration();
    }

    void setDisplayOverrideConfiguration(Configuration overrideConfiguration, int displayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        activityDisplay.onOverrideConfigurationChanged(overrideConfiguration);
    }

    boolean canPlaceEntityOnDisplay(int displayId, boolean resizeable) {
        return displayId == 0 || this.mService.mSupportsMultiDisplay && (resizeable || this.displayConfigMatchesGlobal(displayId));
    }

    private boolean displayConfigMatchesGlobal(int displayId) {
        if (displayId == 0) {
            return true;
        }
        if (displayId == -1) {
            return false;
        }
        ActivityDisplay targetDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (targetDisplay == null) {
            throw new IllegalArgumentException("No display found with id: " + displayId);
        }
        return this.getConfiguration().equals(targetDisplay.getConfiguration());
    }

    public ActivityStackSupervisor(ActivityManagerService service, Looper looper) {
        this.mService = service;
        this.mHandler = new ActivityStackSupervisorHandler(looper);
        this.mActivityMetricsLogger = new ActivityMetricsLogger(this, this.mService.mContext);
        this.mKeyguardController = new KeyguardController(service, this);
    }

    void setRecentTasks(RecentTasks recentTasks) {
        this.mRecentTasks = recentTasks;
    }

    void initPowerManagement() {
        PowerManager pm = (PowerManager)this.mService.mContext.getSystemService("power");
        this.mGoingToSleep = pm.newWakeLock(1, "ActivityManager-Sleep");
        this.mLaunchingActivity = pm.newWakeLock(1, "*launch*");
        this.mLaunchingActivity.setReferenceCounted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatusBarService getStatusBarService() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mStatusBarService == null) {
                this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.checkService("statusbar"));
                if (this.mStatusBarService == null) {
                    Slog.w("StatusBarManager", "warning: no STATUS_BAR_SERVICE");
                }
            }
            return this.mStatusBarService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDevicePolicyManager getDevicePolicyManager() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mDevicePolicyManager == null) {
                this.mDevicePolicyManager = IDevicePolicyManager.Stub.asInterface(ServiceManager.checkService("device_policy"));
                if (this.mDevicePolicyManager == null) {
                    Slog.w("ActivityManager", "warning: no DEVICE_POLICY_SERVICE");
                }
            }
            return this.mDevicePolicyManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWindowManager(WindowManagerService wm) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            this.mWindowManager = wm;
            this.mKeyguardController.setWindowManager(wm);
            this.mDisplayManager = (DisplayManager)this.mService.mContext.getSystemService("display");
            this.mDisplayManager.registerDisplayListener(this, null);
            this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
            Display[] displays = this.mDisplayManager.getDisplays();
            for (int displayNdx = displays.length - 1; displayNdx >= 0; --displayNdx) {
                int displayId = displays[displayNdx].getDisplayId();
                ActivityDisplay activityDisplay = new ActivityDisplay(displayId);
                if (activityDisplay.mDisplay == null) {
                    throw new IllegalStateException("Default Display does not exist");
                }
                this.mActivityDisplays.put(displayId, activityDisplay);
                this.calculateDefaultMinimalSizeOfResizeableTasks(activityDisplay);
            }
            this.mFocusedStack = this.mLastFocusedStack = this.getStack(0, true, true);
            this.mHomeStack = this.mLastFocusedStack;
            this.mInputManagerInternal = LocalServices.getService(InputManagerInternal.class);
        }
    }

    ActivityStack getFocusedStack() {
        return this.mFocusedStack;
    }

    ActivityStack getLastStack() {
        return this.mLastFocusedStack;
    }

    boolean isFocusedStack(ActivityStack stack) {
        if (stack == null) {
            return false;
        }
        ActivityRecord parent = stack.mActivityContainer.mParentActivity;
        if (parent != null) {
            stack = parent.getStack();
        }
        return stack == this.mFocusedStack;
    }

    boolean isFrontStackOnDisplay(ActivityStack stack) {
        return this.isFrontOfStackList(stack, stack.mActivityContainer.mActivityDisplay.mStacks);
    }

    private boolean isFrontOfStackList(ActivityStack stack, List<ActivityStack> stackList) {
        if (stack == null) {
            return false;
        }
        ActivityRecord parent = stack.mActivityContainer.mParentActivity;
        if (parent != null) {
            stack = parent.getStack();
        }
        return stack == stackList.get(stackList.size() - 1);
    }

    void setFocusStackUnchecked(String reason, ActivityStack focusCandidate) {
        if (!focusCandidate.isFocusable()) {
            focusCandidate = this.getNextFocusableStackLocked(focusCandidate);
        }
        if (focusCandidate != this.mFocusedStack) {
            this.mLastFocusedStack = this.mFocusedStack;
            this.mFocusedStack = focusCandidate;
            EventLogTags.writeAmFocusedStack(this.mCurrentUser, this.mFocusedStack == null ? -1 : this.mFocusedStack.getStackId(), this.mLastFocusedStack == null ? -1 : this.mLastFocusedStack.getStackId(), reason);
        }
        ActivityRecord r = this.topRunningActivityLocked();
        if ((this.mService.mBooting || !this.mService.mBooted) && r != null && r.idle) {
            this.checkFinishBootingLocked();
        }
    }

    void moveHomeStackToFront(String reason) {
        this.mHomeStack.moveToFront(reason);
    }

    void moveRecentsStackToFront(String reason) {
        Object recentsStack = this.getStack(5);
        if (recentsStack != null) {
            ((ActivityStack)recentsStack).moveToFront(reason);
        }
    }

    boolean moveHomeStackTaskToTop(String reason) {
        this.mHomeStack.moveHomeStackTaskToTop();
        ActivityRecord top = this.getHomeActivity();
        if (top == null) {
            return false;
        }
        this.moveFocusableActivityStackToFrontLocked(top, reason);
        return true;
    }

    boolean resumeHomeStackTask(ActivityRecord prev, String reason) {
        if (!this.mService.mBooting && !this.mService.mBooted) {
            return false;
        }
        if (prev != null) {
            prev.getTask().setTaskToReturnTo(0);
        }
        this.mHomeStack.moveHomeStackTaskToTop();
        ActivityRecord r = this.getHomeActivity();
        String myReason = reason + " resumeHomeStackTask";
        if (r != null && !r.finishing) {
            this.moveFocusableActivityStackToFrontLocked(r, myReason);
            return this.resumeFocusedStackTopActivityLocked(this.mHomeStack, prev, null);
        }
        return this.mService.startHomeActivityLocked(this.mCurrentUser, myReason);
    }

    TaskRecord anyTaskForIdLocked(int id2) {
        return this.anyTaskForIdLocked(id2, 2, -1);
    }

    TaskRecord anyTaskForIdLocked(int id2, int matchMode, int stackId) {
        if (matchMode != 2 && stackId != -1) {
            throw new IllegalArgumentException("Should not specify stackId for non-restore lookup");
        }
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                TaskRecord task = stack.taskForIdLocked(id2);
                if (task == null) continue;
                return task;
            }
        }
        if (matchMode == 0) {
            return null;
        }
        TaskRecord task = this.mRecentTasks.taskForIdLocked(id2);
        if (task == null) {
            return null;
        }
        if (matchMode == 1) {
            return task;
        }
        if (!this.restoreRecentTaskLocked(task, stackId)) {
            return null;
        }
        return task;
    }

    ActivityRecord isInAnyStackLocked(IBinder token) {
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord r = stacks.get(stackNdx).isInStackLocked(token);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    private boolean taskTopActivityIsUser(TaskRecord task, int userId) {
        ActivityRecord activityRecord = task.getTopActivity();
        ActivityRecord resultTo = activityRecord != null ? activityRecord.resultTo : null;
        return activityRecord != null && activityRecord.userId == userId || resultTo != null && resultTo.userId == userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockAllProfileTasks(int userId) {
        this.mWindowManager.deferSurfaceLayout();
        try {
            ArrayList<ActivityStack> stacks = this.getStacks();
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ArrayList<TaskRecord> tasks = ((ActivityStack)stacks.get(stackNdx)).getAllTasks();
                for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                    TaskRecord task = (TaskRecord)tasks.get(taskNdx);
                    if (!this.taskTopActivityIsUser(task, userId)) continue;
                    this.mService.mTaskChangeNotificationController.notifyTaskProfileLocked(task.taskId, userId);
                }
            }
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    void setNextTaskIdForUserLocked(int taskId, int userId) {
        int currentTaskId = this.mCurTaskIdForUser.get(userId, -1);
        if (taskId > currentTaskId) {
            this.mCurTaskIdForUser.put(userId, taskId);
        }
    }

    static int nextTaskIdForUser(int taskId, int userId) {
        int nextTaskId = taskId + 1;
        if (nextTaskId == (userId + 1) * 100000) {
            nextTaskId -= 100000;
        }
        return nextTaskId;
    }

    int getNextTaskIdForUserLocked(int userId) {
        int currentTaskId = this.mCurTaskIdForUser.get(userId, userId * 100000);
        int candidateTaskId = ActivityStackSupervisor.nextTaskIdForUser(currentTaskId, userId);
        while (this.mRecentTasks.taskIdTakenForUserLocked(candidateTaskId, userId) || this.anyTaskForIdLocked(candidateTaskId, 1, -1) != null) {
            if ((candidateTaskId = ActivityStackSupervisor.nextTaskIdForUser(candidateTaskId, userId)) != currentTaskId) continue;
            throw new IllegalStateException("Cannot get an available task id. Reached limit of 100000 running tasks per user.");
        }
        this.mCurTaskIdForUser.put(userId, candidateTaskId);
        return candidateTaskId;
    }

    ActivityRecord getResumedActivityLocked() {
        ActivityStack stack = this.mFocusedStack;
        if (stack == null) {
            return null;
        }
        ActivityRecord resumedActivity = stack.mResumedActivity;
        if (!(resumedActivity != null && resumedActivity.app != null || (resumedActivity = stack.mPausingActivity) != null && resumedActivity.app != null)) {
            resumedActivity = stack.topRunningActivityLocked();
        }
        return resumedActivity;
    }

    boolean attachApplicationLocked(ProcessRecord app) throws RemoteException {
        String processName = app.processName;
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord hr;
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFocusedStack(stack) || (hr = stack.topRunningActivityLocked()) == null || hr.app != null || app.uid != hr.info.applicationInfo.uid || !processName.equals(hr.processName)) continue;
                try {
                    if (!this.realStartActivityLocked(hr, app, true, true)) continue;
                    didSomething = true;
                    continue;
                }
                catch (RemoteException e) {
                    Slog.w("ActivityManager", "Exception in new application when starting activity " + hr.intent.getComponent().flattenToShortString(), e);
                    throw e;
                }
            }
        }
        if (!didSomething) {
            this.ensureActivitiesVisibleLocked(null, 0, false);
        }
        return didSomething;
    }

    boolean allResumedActivitiesIdle() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord resumedActivity;
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFocusedStack(stack) || stack.numActivities() == 0 || (resumedActivity = stack.mResumedActivity) != null && resumedActivity.idle) continue;
                return false;
            }
        }
        this.mService.mActivityStarter.sendPowerHintForLaunchEndIfNeeded();
        return true;
    }

    boolean allResumedActivitiesComplete() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord r;
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFocusedStack(stack) || (r = stack.mResumedActivity) == null || r.state == ActivityStack.ActivityState.RESUMED) continue;
                return false;
            }
        }
        this.mLastFocusedStack = this.mFocusedStack;
        return true;
    }

    boolean allResumedActivitiesVisible() {
        boolean foundResumed = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                ActivityRecord r = stack.mResumedActivity;
                if (r == null) continue;
                if (!r.nowVisible || this.mActivitiesWaitingForVisibleActivity.contains(r)) {
                    return false;
                }
                foundResumed = true;
            }
        }
        return foundResumed;
    }

    boolean pauseBackStacks(boolean userLeaving, ActivityRecord resuming, boolean dontWait) {
        boolean someActivityPaused = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (this.isFocusedStack(stack) || stack.mResumedActivity == null) continue;
                someActivityPaused |= stack.startPausingLocked(userLeaving, false, resuming, dontWait);
            }
        }
        return someActivityPaused;
    }

    boolean allPausedActivitiesComplete() {
        boolean pausing = true;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                ActivityRecord r = stack.mPausingActivity;
                if (r == null || r.state == ActivityStack.ActivityState.PAUSED || r.state == ActivityStack.ActivityState.STOPPED || r.state == ActivityStack.ActivityState.STOPPING) continue;
                return false;
            }
        }
        return pausing;
    }

    void pauseChildStacks(ActivityRecord parent, boolean userLeaving, boolean uiSleeping, ActivityRecord resuming, boolean dontWait) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (stack.mResumedActivity == null || stack.mActivityContainer.mParentActivity != parent) continue;
                stack.startPausingLocked(userLeaving, uiSleeping, resuming, dontWait);
            }
        }
    }

    void cancelInitializingActivities() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).cancelInitializingActivities();
            }
        }
    }

    void waitActivityVisible(ComponentName name, WaitResult result) {
        WaitInfo waitInfo = new WaitInfo(name, result);
        this.mWaitingForActivityVisible.add(waitInfo);
    }

    void cleanupActivity(ActivityRecord r) {
        this.mFinishingActivities.remove(r);
        this.mActivitiesWaitingForVisibleActivity.remove(r);
        for (int i = this.mWaitingForActivityVisible.size() - 1; i >= 0; --i) {
            if (!this.mWaitingForActivityVisible.get(i).matches(r.realActivity)) continue;
            this.mWaitingForActivityVisible.remove(i);
        }
    }

    void reportActivityVisibleLocked(ActivityRecord r) {
        this.sendWaitingVisibleReportLocked(r);
    }

    void sendWaitingVisibleReportLocked(ActivityRecord r) {
        boolean changed = false;
        for (int i = this.mWaitingForActivityVisible.size() - 1; i >= 0; --i) {
            WaitInfo w = this.mWaitingForActivityVisible.get(i);
            if (!w.matches(r.realActivity)) continue;
            WaitResult result = w.getResult();
            changed = true;
            result.timeout = false;
            result.who = w.getComponent();
            result.thisTime = result.totalTime = SystemClock.uptimeMillis() - result.thisTime;
            this.mWaitingForActivityVisible.remove(w);
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    void reportTaskToFrontNoLaunch(ActivityRecord r) {
        boolean changed = false;
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            WaitResult w = this.mWaitingActivityLaunched.remove(i);
            if (w.who != null) continue;
            changed = true;
            w.result = 2;
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    void reportActivityLaunchedLocked(boolean timeout, ActivityRecord r, long thisTime, long totalTime) {
        boolean changed = false;
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            WaitResult w = this.mWaitingActivityLaunched.remove(i);
            if (w.who != null) continue;
            changed = true;
            w.timeout = timeout;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = thisTime;
            w.totalTime = totalTime;
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    ActivityRecord topRunningActivityLocked() {
        ActivityStack focusedStack = this.mFocusedStack;
        ActivityRecord r = focusedStack.topRunningActivityLocked();
        if (r != null) {
            return r;
        }
        this.mWindowManager.getDisplaysInFocusOrder(this.mTmpOrderedDisplayIds);
        for (int i = this.mTmpOrderedDisplayIds.size() - 1; i >= 0; --i) {
            int displayId = this.mTmpOrderedDisplayIds.get(i);
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.get((int)displayId).mStacks;
            if (stacks == null) continue;
            for (int j = stacks.size() - 1; j >= 0; --j) {
                ActivityStack stack = (ActivityStack)stacks.get(j);
                if (stack == focusedStack || !this.isFrontStackOnDisplay(stack) || !stack.isFocusable() || (r = stack.topRunningActivityLocked()) == null) continue;
                return r;
            }
        }
        return null;
    }

    void getTasksLocked(int maxNum, List<ActivityManager.RunningTaskInfo> list, int callingUid, boolean allowed) {
        ArrayList<ArrayList<ActivityManager.RunningTaskInfo>> runningTaskLists = new ArrayList<ArrayList<ActivityManager.RunningTaskInfo>>();
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                ArrayList<ActivityManager.RunningTaskInfo> stackTaskList = new ArrayList<ActivityManager.RunningTaskInfo>();
                runningTaskLists.add(stackTaskList);
                stack.getTasksLocked(stackTaskList, callingUid, allowed);
            }
        }
        while (maxNum > 0) {
            long mostRecentActiveTime = Long.MIN_VALUE;
            ArrayList selectedStackList = null;
            int numTaskLists = runningTaskLists.size();
            for (int stackNdx = 0; stackNdx < numTaskLists; ++stackNdx) {
                long lastActiveTime;
                ArrayList stackTaskList = (ArrayList)runningTaskLists.get(stackNdx);
                if (stackTaskList.isEmpty() || (lastActiveTime = ((ActivityManager.RunningTaskInfo)stackTaskList.get((int)0)).lastActiveTime) <= mostRecentActiveTime) continue;
                mostRecentActiveTime = lastActiveTime;
                selectedStackList = stackTaskList;
            }
            if (selectedStackList == null) break;
            list.add((ActivityManager.RunningTaskInfo)selectedStackList.remove(0));
            --maxNum;
        }
    }

    ActivityInfo resolveActivity(Intent intent, ResolveInfo rInfo, int startFlags, ProfilerInfo profilerInfo) {
        ActivityInfo aInfo;
        ActivityInfo activityInfo = aInfo = rInfo != null ? rInfo.activityInfo : null;
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            if (!aInfo.processName.equals("system")) {
                if ((startFlags & 2) != 0) {
                    this.mService.setDebugApp(aInfo.processName, true, false);
                }
                if ((startFlags & 8) != 0) {
                    this.mService.setNativeDebuggingAppLocked(aInfo.applicationInfo, aInfo.processName);
                }
                if ((startFlags & 4) != 0) {
                    this.mService.setTrackAllocationApp(aInfo.applicationInfo, aInfo.processName);
                }
                if (profilerInfo != null) {
                    this.mService.setProfileApp(aInfo.applicationInfo, aInfo.processName, profilerInfo);
                }
            }
            String intentLaunchToken = intent.getLaunchToken();
            if (aInfo.launchToken == null && intentLaunchToken != null) {
                aInfo.launchToken = intentLaunchToken;
            }
        }
        return aInfo;
    }

    ResolveInfo resolveIntent(Intent intent, String resolvedType, int userId) {
        return this.resolveIntent(intent, resolvedType, userId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolveInfo resolveIntent(Intent intent, String resolvedType, int userId, int flags) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            return this.mService.getPackageManagerInternalLocked().resolveIntent(intent, resolvedType, 0x810000 | flags | 0x400, userId);
        }
    }

    ActivityInfo resolveActivity(Intent intent, String resolvedType, int startFlags, ProfilerInfo profilerInfo, int userId) {
        ResolveInfo rInfo = this.resolveIntent(intent, resolvedType, userId);
        return this.resolveActivity(intent, rInfo, startFlags, profilerInfo);
    }

    final boolean realStartActivityLocked(ActivityRecord r, ProcessRecord app, boolean andResume, boolean checkConfig) throws RemoteException {
        int applicationInfoUid;
        if (!this.allPausedActivitiesComplete()) {
            return false;
        }
        r.startFreezingScreenLocked(app, 0);
        if (((ActivityStack)r.getStack()).checkKeyguardVisibility(r, true, true)) {
            r.setVisibility(true);
        }
        r.startLaunchTickingLocked();
        if (checkConfig) {
            int displayId = r.getDisplayId();
            Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.getDisplayOverrideConfiguration(displayId), r.mayFreezeScreenLocked(app) ? r.appToken : null, displayId);
            this.mService.updateDisplayOverrideConfigurationLocked(config, r, true, displayId);
        }
        if (this.mKeyguardController.isKeyguardLocked()) {
            r.notifyUnknownVisibilityLaunched();
        }
        int n = applicationInfoUid = r.info.applicationInfo != null ? r.info.applicationInfo.uid : -1;
        if (r.userId != app.userId || r.appInfo.uid != applicationInfoUid) {
            Slog.wtf("ActivityManager", "User ID for activity changing for " + r + " appInfo.uid=" + r.appInfo.uid + " info.ai.uid=" + applicationInfoUid + " old=" + r.app + " new=" + app);
        }
        r.app = app;
        app.waitingToKill = null;
        ++r.launchCount;
        r.lastLaunchTime = SystemClock.uptimeMillis();
        int idx = app.activities.indexOf(r);
        if (idx < 0) {
            app.activities.add(r);
        }
        this.mService.updateLruProcessLocked(app, true, null);
        this.mService.updateOomAdjLocked();
        TaskRecord task = r.getTask();
        if (task.mLockTaskAuth == 2 || task.mLockTaskAuth == 4) {
            this.setLockTaskModeLocked(task, 1, "mLockTaskAuth==LAUNCHABLE", false);
        }
        ActivityStack stack = task.getStack();
        try {
            if (app.thread == null) {
                throw new RemoteException();
            }
            ArrayList<ResultInfo> results = null;
            ArrayList<ReferrerIntent> newIntents = null;
            if (andResume) {
                results = r.results;
                newIntents = r.newIntents;
            }
            EventLog.writeEvent(30006, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName);
            if (r.isHomeActivity()) {
                this.mService.mHomeProcess = task.mActivities.get((int)0).app;
            }
            this.mService.notifyPackageUse(r.intent.getComponent().getPackageName(), 0);
            r.sleeping = false;
            r.forceNewConfig = false;
            this.mService.showUnsupportedZoomDialogIfNeededLocked(r);
            this.mService.showAskCompatModeDialogLocked(r);
            r.compat = this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo);
            ProfilerInfo profilerInfo = null;
            if (this.mService.mProfileApp != null && this.mService.mProfileApp.equals(app.processName) && (this.mService.mProfileProc == null || this.mService.mProfileProc == app)) {
                this.mService.mProfileProc = app;
                String profileFile = this.mService.mProfileFile;
                if (profileFile != null) {
                    ParcelFileDescriptor profileFd;
                    block27: {
                        profileFd = this.mService.mProfileFd;
                        if (profileFd != null) {
                            try {
                                profileFd = profileFd.dup();
                            }
                            catch (IOException e) {
                                if (profileFd == null) break block27;
                                try {
                                    profileFd.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                profileFd = null;
                            }
                        }
                    }
                    profilerInfo = new ProfilerInfo(profileFile, profileFd, this.mService.mSamplingInterval, this.mService.mAutoStopProfiler, this.mService.mStreamingOutput);
                }
            }
            app.hasShownUi = true;
            app.pendingUiClean = true;
            app.forceProcessStateUpTo(this.mService.mTopProcessState);
            MergedConfiguration mergedConfiguration = new MergedConfiguration(this.mService.getGlobalConfiguration(), r.getMergedOverrideConfiguration());
            r.setLastReportedConfiguration(mergedConfiguration);
            app.thread.scheduleLaunchActivity(new Intent(r.intent), r.appToken, System.identityHashCode(r), r.info, mergedConfiguration.getGlobalConfiguration(), mergedConfiguration.getOverrideConfiguration(), r.compat, r.launchedFromPackage, task.voiceInteractor, app.repProcState, r.icicle, r.persistentState, results, newIntents, !andResume, this.mService.isNextTransitionForward(), profilerInfo);
            if ((app.info.privateFlags & 2) != 0 && app.processName.equals(app.info.packageName)) {
                if (this.mService.mHeavyWeightProcess != null && this.mService.mHeavyWeightProcess != app) {
                    Slog.w("ActivityManager", "Starting new heavy weight process " + app + " when already running " + this.mService.mHeavyWeightProcess);
                }
                this.mService.mHeavyWeightProcess = app;
                Message msg = this.mService.mHandler.obtainMessage(24);
                msg.obj = r;
                this.mService.mHandler.sendMessage(msg);
            }
        }
        catch (RemoteException e) {
            if (r.launchFailed) {
                Slog.e("ActivityManager", "Second failure launching " + r.intent.getComponent().flattenToShortString() + ", giving up", e);
                this.mService.appDiedLocked(app);
                stack.requestFinishActivityLocked(r.appToken, 0, null, "2nd-crash", false);
                return false;
            }
            r.launchFailed = true;
            app.activities.remove(r);
            throw e;
        }
        r.launchFailed = false;
        if (stack.updateLRUListLocked(r)) {
            Slog.w("ActivityManager", "Activity " + r + " being launched, but already in LRU list");
        }
        if (andResume) {
            stack.minimalResumeActivityLocked(r);
        } else {
            r.state = ActivityStack.ActivityState.PAUSED;
        }
        if (this.isFocusedStack(stack)) {
            this.mService.startSetupActivityLocked();
        }
        if (r.app != null) {
            this.mService.mServices.updateServiceConnectionActivitiesLocked(r.app);
        }
        return true;
    }

    void startSpecificActivityLocked(ActivityRecord r, boolean andResume, boolean checkConfig) {
        ProcessRecord app = this.mService.getProcessRecordLocked(r.processName, r.info.applicationInfo.uid, true);
        ((ActivityStack)r.getStack()).setLaunchTime(r);
        if (app != null && app.thread != null) {
            try {
                if ((r.info.flags & 1) == 0 || !"android".equals(r.info.packageName)) {
                    app.addPackage(r.info.packageName, r.info.applicationInfo.versionCode, this.mService.mProcessStats);
                }
                this.realStartActivityLocked(r, app, andResume, checkConfig);
                return;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception when starting activity " + r.intent.getComponent().flattenToShortString(), e);
            }
        }
        this.mService.startProcessLocked(r.processName, r.info.applicationInfo, true, 0, "activity", r.intent.getComponent(), false, false, true);
    }

    boolean checkStartAnyActivityPermission(Intent intent, ActivityInfo aInfo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, boolean ignoreTargetSecurity, ProcessRecord callerApp, ActivityRecord resultRecord, ActivityStack resultStack, ActivityOptions options) {
        int startAnyPerm = this.mService.checkPermission("android.permission.START_ANY_ACTIVITY", callingPid, callingUid);
        if (startAnyPerm == 0) {
            return true;
        }
        int componentRestriction = this.getComponentRestrictionForCallingPackage(aInfo, callingPackage, callingPid, callingUid, ignoreTargetSecurity);
        int actionRestriction = this.getActionRestrictionForCallingPackage(intent.getAction(), callingPackage, callingPid, callingUid);
        if (componentRestriction == 1 || actionRestriction == 1) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            String msg = actionRestriction == 1 ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " with revoked permission " + ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()) : (!aInfo.exported ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " not exported from uid " + aInfo.applicationInfo.uid : "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + aInfo.permission);
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        if (actionRestriction == 2) {
            String message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + AppOpsManager.permissionToOp(ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()));
            Slog.w("ActivityManager", message);
            return false;
        }
        if (componentRestriction == 2) {
            String message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires appop " + AppOpsManager.permissionToOp(aInfo.permission);
            Slog.w("ActivityManager", message);
            return false;
        }
        if (options != null) {
            int startInTaskPerm;
            if (options.getLaunchTaskId() != -1 && (startInTaskPerm = this.mService.checkPermission("android.permission.START_TASKS_FROM_RECENTS", callingPid, callingUid)) != 0) {
                String msg = "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with launchTaskId=" + options.getLaunchTaskId();
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            int launchDisplayId = options.getLaunchDisplayId();
            if (launchDisplayId != -1 && !this.isCallerAllowedToLaunchOnDisplay(callingPid, callingUid, launchDisplayId)) {
                String msg = "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with launchDisplayId=" + launchDisplayId;
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
        }
        return true;
    }

    boolean isCallerAllowedToLaunchOnDisplay(int callingPid, int callingUid, int launchDisplayId) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(launchDisplayId);
        if (activityDisplay == null) {
            Slog.w("ActivityManager", "Launch on display check: display not found");
            return false;
        }
        int startAnyPerm = this.mService.checkPermission("android.permission.INTERNAL_SYSTEM_WINDOW", callingPid, callingUid);
        if (startAnyPerm == 0) {
            return true;
        }
        if (activityDisplay.mDisplay.getType() == 5 && activityDisplay.mDisplay.getOwnerUid() != 1000) {
            return false;
        }
        if (!activityDisplay.isPrivate()) {
            return true;
        }
        if (activityDisplay.mDisplay.getOwnerUid() == callingUid) {
            return true;
        }
        if (activityDisplay.isUidPresent(callingUid)) {
            return true;
        }
        Slog.w("ActivityManager", "Launch on display check: denied");
        return false;
    }

    void updateUIDsPresentOnDisplay() {
        this.mDisplayAccessUIDs.clear();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(displayNdx);
            if (!activityDisplay.isPrivate()) continue;
            this.mDisplayAccessUIDs.append(activityDisplay.mDisplayId, activityDisplay.getPresentUIDs());
        }
        this.mDisplayManagerInternal.setDisplayAccessUIDs(this.mDisplayAccessUIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserInfo getUserInfo(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = UserManager.get(this.mService.mContext).getUserInfo(userId);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private int getComponentRestrictionForCallingPackage(ActivityInfo activityInfo, String callingPackage, int callingPid, int callingUid, boolean ignoreTargetSecurity) {
        if (!ignoreTargetSecurity && this.mService.checkComponentPermission(activityInfo.permission, callingPid, callingUid, activityInfo.applicationInfo.uid, activityInfo.exported) == -1) {
            return 1;
        }
        if (activityInfo.permission == null) {
            return 0;
        }
        int opCode = AppOpsManager.permissionToOpCode(activityInfo.permission);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.mAppOpsService.noteOperation(opCode, callingUid, callingPackage) != 0 && !ignoreTargetSecurity) {
            return 2;
        }
        return 0;
    }

    private int getActionRestrictionForCallingPackage(String action, String callingPackage, int callingPid, int callingUid) {
        PackageInfo packageInfo;
        if (action == null) {
            return 0;
        }
        String permission2 = ACTION_TO_RUNTIME_PERMISSION.get(action);
        if (permission2 == null) {
            return 0;
        }
        try {
            packageInfo = this.mService.mContext.getPackageManager().getPackageInfo(callingPackage, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.i("ActivityManager", "Cannot find package info for " + callingPackage);
            return 0;
        }
        if (!ArrayUtils.contains(packageInfo.requestedPermissions, permission2)) {
            return 0;
        }
        if (this.mService.checkPermission(permission2, callingPid, callingUid) == -1) {
            return 1;
        }
        int opCode = AppOpsManager.permissionToOpCode(permission2);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.mAppOpsService.noteOperation(opCode, callingUid, callingPackage) != 0) {
            return 2;
        }
        return 0;
    }

    void setLaunchSource(int uid) {
        this.mLaunchingActivity.setWorkSource(new WorkSource(uid));
    }

    void acquireLaunchWakelock() {
        this.mLaunchingActivity.acquire();
        if (!this.mHandler.hasMessages(104)) {
            this.mHandler.sendEmptyMessageDelayed(104, 10000L);
        }
    }

    private boolean checkFinishBootingLocked() {
        boolean booting = this.mService.mBooting;
        boolean enableScreen = false;
        this.mService.mBooting = false;
        if (!this.mService.mBooted) {
            this.mService.mBooted = true;
            enableScreen = true;
        }
        if (booting || enableScreen) {
            this.mService.postFinishBooting(booting, enableScreen);
        }
        return booting;
    }

    final ActivityRecord activityIdleInternalLocked(IBinder token, boolean fromTimeout, boolean processPausingActivities, Configuration config) {
        Object stack;
        int i;
        ArrayList<ActivityRecord> stops;
        ArrayList<ActivityRecord> finishes = null;
        ArrayList<UserState> startingUsers = null;
        int NS = 0;
        int NF = 0;
        boolean booting = false;
        boolean activityRemoved = false;
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(100, r);
            r.finishLaunchTickingLocked();
            if (fromTimeout) {
                this.reportActivityLaunchedLocked(fromTimeout, r, -1L, -1L);
            }
            if (config != null) {
                r.setLastReportedGlobalConfiguration(config);
            }
            r.idle = true;
            if (this.isFocusedStack((ActivityStack)r.getStack()) || fromTimeout) {
                booting = this.checkFinishBootingLocked();
            }
        }
        if (this.allResumedActivitiesIdle()) {
            if (r != null) {
                this.mService.scheduleAppGcsLocked();
            }
            if (this.mLaunchingActivity.isHeld()) {
                this.mHandler.removeMessages(104);
                this.mLaunchingActivity.release();
            }
            this.ensureActivitiesVisibleLocked(null, 0, false);
        }
        NS = (stops = this.processStoppingActivitiesLocked(r, true, processPausingActivities)) != null ? stops.size() : 0;
        NF = this.mFinishingActivities.size();
        if (NF > 0) {
            finishes = new ArrayList<ActivityRecord>(this.mFinishingActivities);
            this.mFinishingActivities.clear();
        }
        if (this.mStartingUsers.size() > 0) {
            startingUsers = new ArrayList<UserState>(this.mStartingUsers);
            this.mStartingUsers.clear();
        }
        for (i = 0; i < NS; ++i) {
            r = stops.get(i);
            stack = r.getStack();
            if (stack == null) continue;
            if (r.finishing) {
                ((ActivityStack)stack).finishCurrentActivityLocked(r, 0, false);
                continue;
            }
            ((ActivityStack)stack).stopActivityLocked(r);
        }
        for (i = 0; i < NF; ++i) {
            r = finishes.get(i);
            stack = r.getStack();
            if (stack == null) continue;
            activityRemoved |= ((ActivityStack)stack).destroyActivityLocked(r, true, "finish-idle");
        }
        if (!booting && startingUsers != null) {
            for (i = 0; i < startingUsers.size(); ++i) {
                this.mService.mUserController.finishUserSwitch(startingUsers.get(i));
            }
        }
        this.mService.trimApplications();
        if (activityRemoved) {
            this.resumeFocusedStackTopActivityLocked();
        }
        return r;
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        boolean hasVisibleActivities = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                hasVisibleActivities |= stacks.get(stackNdx).handleAppDiedLocked(app);
            }
        }
        return hasVisibleActivities;
    }

    void closeSystemDialogsLocked() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).closeSystemDialogsLocked();
            }
        }
    }

    void removeUserLocked(int userId) {
        this.mUserStackInFront.delete(userId);
    }

    void updateUserStackLocked(int userId, ActivityStack stack) {
        if (userId != this.mCurrentUser) {
            this.mUserStackInFront.put(userId, stack != null ? stack.getStackId() : 0);
        }
    }

    boolean finishDisabledPackageActivitiesLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (!stack.finishDisabledPackageActivitiesLocked(packageName, filterByClasses, doit, evenPersistent, userId)) continue;
                didSomething = true;
            }
        }
        return didSomething;
    }

    void updatePreviousProcessLocked(ActivityRecord r) {
        ProcessRecord fgApp = null;
        block0: for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFocusedStack(stack)) continue;
                if (stack.mResumedActivity != null) {
                    fgApp = stack.mResumedActivity.app;
                    continue block0;
                }
                if (stack.mPausingActivity == null) continue block0;
                fgApp = stack.mPausingActivity.app;
                continue block0;
            }
        }
        if (r.app != null && fgApp != null && r.app != fgApp && r.lastVisibleTime > this.mService.mPreviousProcessVisibleTime && r.app != this.mService.mHomeProcess) {
            this.mService.mPreviousProcess = r.app;
            this.mService.mPreviousProcessVisibleTime = r.lastVisibleTime;
        }
    }

    boolean resumeFocusedStackTopActivityLocked() {
        return this.resumeFocusedStackTopActivityLocked(null, null, null);
    }

    boolean resumeFocusedStackTopActivityLocked(ActivityStack targetStack, ActivityRecord target, ActivityOptions targetOptions) {
        if (targetStack != null && this.isFocusedStack(targetStack)) {
            return targetStack.resumeTopActivityUncheckedLocked(target, targetOptions);
        }
        ActivityRecord r = this.mFocusedStack.topRunningActivityLocked();
        if (r == null || r.state != ActivityStack.ActivityState.RESUMED) {
            this.mFocusedStack.resumeTopActivityUncheckedLocked(null, null);
        } else if (r.state == ActivityStack.ActivityState.RESUMED) {
            this.mFocusedStack.executeAppTransition(targetOptions);
        }
        return false;
    }

    void updateActivityApplicationInfoLocked(ApplicationInfo aInfo) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).updateActivityApplicationInfoLocked(aInfo);
            }
        }
    }

    TaskRecord finishTopRunningActivityLocked(ProcessRecord app, String reason) {
        TaskRecord finishedTask = null;
        ActivityStack focusedStack = this.getFocusedStack();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int numStacks = stacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                TaskRecord t = stack.finishTopRunningActivityLocked(app, reason);
                if (stack != focusedStack && finishedTask != null) continue;
                finishedTask = t;
            }
        }
        return finishedTask;
    }

    void finishVoiceTask(IVoiceInteractionSession session) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int numStacks = stacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.finishVoiceTask(session);
            }
        }
    }

    void findTaskToMoveToFrontLocked(TaskRecord task, int flags, ActivityOptions options, String reason, boolean forceNonResizeable) {
        ActivityRecord r;
        int stackId;
        ActivityStack currentStack;
        if ((flags & 2) == 0) {
            this.mUserLeaving = true;
        }
        if ((flags & 1) != 0) {
            task.setTaskToReturnTo(1);
        }
        if ((currentStack = task.getStack()) == null) {
            Slog.e("ActivityManager", "findTaskToMoveToFrontLocked: can't move task=" + task + " to front. Stack is null");
            return;
        }
        if (task.isResizeable() && options != null && this.canUseActivityOptionsLaunchBounds(options, stackId = options.getLaunchStackId())) {
            Rect bounds = TaskRecord.validateBounds(options.getLaunchBounds());
            task.updateOverrideConfiguration(bounds);
            if (stackId == -1) {
                stackId = task.getLaunchStackId();
            }
            if (stackId != currentStack.mStackId) {
                task.reparent(stackId, true, 1, false, true, "findTaskToMoveToFrontLocked");
                stackId = currentStack.mStackId;
            }
            if (ActivityManager.StackId.resizeStackWithLaunchBounds(stackId)) {
                this.resizeStackLocked(stackId, bounds, null, null, false, true, false);
            } else {
                task.resizeWindowContainer();
            }
        }
        currentStack.moveTaskToFrontLocked(task, false, options, (r = task.getTopActivity()) == null ? null : r.appTimeTracker, reason);
        this.handleNonResizableTaskIfNeeded(task, -1, 0, currentStack.mStackId, forceNonResizeable);
    }

    boolean canUseActivityOptionsLaunchBounds(ActivityOptions options, int launchStackId) {
        if (options.getLaunchBounds() == null) {
            return false;
        }
        return this.mService.mSupportsPictureInPicture && launchStackId == 4 || this.mService.mSupportsFreeformWindowManagement;
    }

    protected <T extends ActivityStack> T getStack(int stackId) {
        return this.getStack(stackId, false, false);
    }

    protected <T extends ActivityStack> T getStack(int stackId, boolean createStaticStackIfNeeded, boolean createOnTop) {
        ActivityContainer activityContainer = this.mActivityContainers.get(stackId);
        if (activityContainer != null) {
            return (T)activityContainer.mStack;
        }
        if (!createStaticStackIfNeeded || !ActivityManager.StackId.isStaticStack(stackId)) {
            return null;
        }
        if (stackId == 3) {
            this.getStack(5, true, createOnTop);
        }
        return (T)this.createStackOnDisplay(stackId, 0, createOnTop);
    }

    ActivityStack getValidLaunchStackOnDisplay(int displayId, ActivityRecord r) {
        int newDynamicStackId;
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("Display with displayId=" + displayId + " not found.");
        }
        for (int i = activityDisplay.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack stack = activityDisplay.mStacks.get(i);
            if (!this.mService.mActivityStarter.isValidLaunchStackId(stack.mStackId, displayId, r)) continue;
            return stack;
        }
        if (displayId != 0 && this.mService.mActivityStarter.isValidLaunchStackId(newDynamicStackId = this.getNextStackId(), displayId, r)) {
            return this.createStackOnDisplay(newDynamicStackId, displayId, true);
        }
        Slog.w("ActivityManager", "getValidLaunchStackOnDisplay: can't launch on displayId " + displayId);
        return null;
    }

    ArrayList<ActivityStack> getStacks() {
        ArrayList<ActivityStack> allStacks = new ArrayList<ActivityStack>();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            allStacks.addAll(this.mActivityDisplays.valueAt((int)displayNdx).mStacks);
        }
        return allStacks;
    }

    ArrayList<ActivityStack> getStacksOnDefaultDisplay() {
        return this.mActivityDisplays.valueAt((int)0).mStacks;
    }

    ActivityStack getNextFocusableStackLocked(ActivityStack currentFocus) {
        this.mWindowManager.getDisplaysInFocusOrder(this.mTmpOrderedDisplayIds);
        for (int i = this.mTmpOrderedDisplayIds.size() - 1; i >= 0; --i) {
            int displayId = this.mTmpOrderedDisplayIds.get(i);
            ArrayList<ActivityStack> stacks = this.getActivityDisplayOrCreateLocked((int)displayId).mStacks;
            for (int j = stacks.size() - 1; j >= 0; --j) {
                ActivityStack stack = (ActivityStack)stacks.get(j);
                if (stack == currentFocus || !stack.isFocusable() || stack.shouldBeVisible(null) == 0) continue;
                return stack;
            }
        }
        return null;
    }

    ActivityStack getNextValidLaunchStackLocked(ActivityRecord r, int currentFocus) {
        this.mWindowManager.getDisplaysInFocusOrder(this.mTmpOrderedDisplayIds);
        for (int i = this.mTmpOrderedDisplayIds.size() - 1; i >= 0; --i) {
            ActivityStack stack;
            int displayId = this.mTmpOrderedDisplayIds.get(i);
            if (displayId == currentFocus || (stack = this.getValidLaunchStackOnDisplay(displayId, r)) == null) continue;
            return stack;
        }
        return null;
    }

    ActivityRecord getHomeActivity() {
        return this.getHomeActivityForUser(this.mCurrentUser);
    }

    ActivityRecord getHomeActivityForUser(int userId) {
        ArrayList<TaskRecord> tasks = this.mHomeStack.getAllTasks();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            if (!task.isHomeTask()) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isHomeActivity() || userId != -1 && r.userId != userId) continue;
                return r;
            }
        }
        return null;
    }

    boolean isStackDockedInEffect(int stackId) {
        return stackId == 3 || ActivityManager.StackId.isResizeableByDockedStack(stackId) && this.getStack(3) != null;
    }

    ActivityContainer createVirtualActivityContainer(ActivityRecord parentActivity, IActivityContainerCallback callback) {
        VirtualActivityContainer activityContainer = new VirtualActivityContainer(parentActivity, callback);
        this.mActivityContainers.put(activityContainer.mStackId, activityContainer);
        parentActivity.mChildContainers.add(activityContainer);
        return activityContainer;
    }

    void removeChildActivityContainers(ActivityRecord parentActivity) {
        ArrayList<ActivityContainer> childStacks = parentActivity.mChildContainers;
        for (int containerNdx = childStacks.size() - 1; containerNdx >= 0; --containerNdx) {
            ActivityContainer container = childStacks.remove(containerNdx);
            container.release();
        }
    }

    void deleteActivityContainerRecord(int stackId) {
        this.mActivityContainers.remove(stackId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizeStackLocked(int stackId, Rect bounds, Rect tempTaskBounds, Rect tempTaskInsetBounds, boolean preserveWindows, boolean allowResizeInDockedMode, boolean deferResume) {
        if (stackId == 3) {
            this.resizeDockedStackLocked(bounds, tempTaskBounds, tempTaskInsetBounds, null, null, preserveWindows, deferResume);
            return;
        }
        Object stack = this.getStack(stackId);
        if (stack == null) {
            Slog.w("ActivityManager", "resizeStack: stackId " + stackId + " not found.");
            return;
        }
        if (!allowResizeInDockedMode && !ActivityManager.StackId.tasksAreFloating(stackId) && this.getStack(3) != null) {
            return;
        }
        Trace.traceBegin(64L, "am.resizeStack_" + stackId);
        this.mWindowManager.deferSurfaceLayout();
        try {
            ((ActivityStack)stack).resize(bounds, tempTaskBounds, tempTaskInsetBounds);
            if (!deferResume) {
                ((ActivityStack)stack).ensureVisibleActivitiesConfigurationLocked(((ActivityStack)stack).topRunningActivityLocked(), preserveWindows);
            }
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    void deferUpdateBounds(int stackId) {
        Object stack = this.getStack(stackId);
        if (stack != null) {
            ((ActivityStack)stack).deferUpdateBounds();
        }
    }

    void continueUpdateBounds(int stackId) {
        Object stack = this.getStack(stackId);
        if (stack != null) {
            ((ActivityStack)stack).continueUpdateBounds();
        }
    }

    void notifyAppTransitionDone() {
        this.continueUpdateBounds(5);
        for (int i = this.mResizingTasksDuringAnimation.size() - 1; i >= 0; --i) {
            int taskId = this.mResizingTasksDuringAnimation.valueAt(i);
            TaskRecord task = this.anyTaskForIdLocked(taskId, 0, -1);
            if (task == null) continue;
            task.setTaskDockedResizing(false);
        }
        this.mResizingTasksDuringAnimation.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTasksToFullscreenStackInSurfaceTransaction(int fromStackId, boolean onTop) {
        Object stack = this.getStack(fromStackId);
        if (stack == null) {
            return;
        }
        this.mWindowManager.deferSurfaceLayout();
        try {
            if (fromStackId == 3) {
                for (int i = 0; i <= 6; ++i) {
                    Object otherStack;
                    if (!ActivityManager.StackId.isResizeableByDockedStack(i) || (otherStack = this.getStack(i)) == null) continue;
                    this.resizeStackLocked(i, null, null, null, true, true, true);
                }
                this.mAllowDockedStackResize = false;
            } else if (fromStackId == 4 && onTop) {
                MetricsLogger.action(this.mService.mContext, 820);
            }
            Object fullscreenStack = this.getStack(1);
            boolean isFullscreenStackVisible = fullscreenStack != null && ((ActivityStack)fullscreenStack).shouldBeVisible(null) == 1;
            boolean schedulePictureInPictureModeChange = fromStackId == 4;
            ArrayList<TaskRecord> tasks = ((ActivityStack)stack).getAllTasks();
            int size = tasks.size();
            if (onTop) {
                for (int i = 0; i < size; ++i) {
                    boolean isTopTask;
                    TaskRecord task = tasks.get(i);
                    boolean bl = isTopTask = i == size - 1;
                    if (fromStackId == 4) {
                        task.setTaskToReturnTo(isFullscreenStackVisible && onTop ? 0 : 1);
                    }
                    task.reparent(1, true, 0, isTopTask, true, schedulePictureInPictureModeChange, "moveTasksToFullscreenStack - onTop");
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    TaskRecord task = tasks.get(i);
                    task.reparent(1, i, 2, false, true, schedulePictureInPictureModeChange, "moveTasksToFullscreenStack - NOT_onTop");
                }
            }
            this.ensureActivitiesVisibleLocked(null, 0, true);
            this.resumeFocusedStackTopActivityLocked();
        }
        finally {
            this.mAllowDockedStackResize = true;
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    void moveTasksToFullscreenStackLocked(int fromStackId, boolean onTop) {
        this.mWindowManager.inSurfaceTransaction(() -> this.moveTasksToFullscreenStackInSurfaceTransaction(fromStackId, onTop));
    }

    void resizeDockedStackLocked(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds, boolean preserveWindows) {
        this.resizeDockedStackLocked(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds, tempOtherTaskBounds, tempOtherTaskInsetBounds, preserveWindows, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizeDockedStackLocked(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds, boolean preserveWindows, boolean deferResume) {
        if (!this.mAllowDockedStackResize) {
            return;
        }
        Object stack = this.getStack(3);
        if (stack == null) {
            Slog.w("ActivityManager", "resizeDockedStackLocked: docked stack not found");
            return;
        }
        Trace.traceBegin(64L, "am.resizeDockedStack");
        this.mWindowManager.deferSurfaceLayout();
        try {
            this.mAllowDockedStackResize = false;
            ActivityRecord r = ((ActivityStack)stack).topRunningActivityLocked();
            ((ActivityStack)stack).resize(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds);
            if (((ActivityStack)stack).mFullscreen || dockedBounds == null && !((ActivityStack)stack).isAttached()) {
                this.moveTasksToFullscreenStackLocked(3, true);
                r = null;
            } else {
                Rect otherTaskRect = new Rect();
                for (int i = 0; i <= 6; ++i) {
                    Object current = this.getStack(i);
                    if (current == null || !ActivityManager.StackId.isResizeableByDockedStack(i)) continue;
                    ((ActivityStack)current).getStackDockedModeBounds(tempOtherTaskBounds, this.tempRect, otherTaskRect, true);
                    this.resizeStackLocked(i, !this.tempRect.isEmpty() ? this.tempRect : null, !otherTaskRect.isEmpty() ? otherTaskRect : tempOtherTaskBounds, tempOtherTaskInsetBounds, preserveWindows, true, deferResume);
                }
            }
            if (!deferResume) {
                ((ActivityStack)stack).ensureVisibleActivitiesConfigurationLocked(r, preserveWindows);
            }
        }
        finally {
            this.mAllowDockedStackResize = true;
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizePinnedStackLocked(Rect pinnedBounds, Rect tempPinnedTaskBounds) {
        PinnedActivityStack stack = (PinnedActivityStack)this.getStack(4);
        if (stack == null) {
            Slog.w("ActivityManager", "resizePinnedStackLocked: pinned stack not found");
            return;
        }
        PinnedStackWindowController stackController = (PinnedStackWindowController)stack.getWindowContainerController();
        if (stackController.pinnedStackResizeDisallowed()) {
            return;
        }
        Trace.traceBegin(64L, "am.resizePinnedStack");
        this.mWindowManager.deferSurfaceLayout();
        try {
            ActivityRecord r = stack.topRunningActivityLocked();
            Rect insetBounds = null;
            if (tempPinnedTaskBounds != null) {
                insetBounds = this.tempRect;
                insetBounds.top = 0;
                insetBounds.left = 0;
                insetBounds.right = tempPinnedTaskBounds.width();
                insetBounds.bottom = tempPinnedTaskBounds.height();
            }
            stack.resize(pinnedBounds, tempPinnedTaskBounds, insetBounds);
            stack.ensureVisibleActivitiesConfigurationLocked(r, false);
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    ActivityStack createStackOnDisplay(int stackId, int displayId, boolean onTop) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            return null;
        }
        ActivityContainer activityContainer = new ActivityContainer(stackId, activityDisplay, onTop);
        return activityContainer.mStack;
    }

    void removeStackInSurfaceTransaction(int stackId) {
        Object stack = this.getStack(stackId);
        if (stack == null) {
            return;
        }
        ArrayList<TaskRecord> tasks = ((ActivityStack)stack).getAllTasks();
        if (((ActivityStack)stack).getStackId() == 4) {
            PinnedActivityStack pinnedStack = (PinnedActivityStack)stack;
            pinnedStack.mForceHidden = true;
            pinnedStack.ensureActivitiesVisibleLocked(null, 0, true);
            pinnedStack.mForceHidden = false;
            this.activityIdleInternalLocked(null, false, true, null);
            this.moveTasksToFullscreenStackLocked(4, false);
        } else {
            for (int i = tasks.size() - 1; i >= 0; --i) {
                this.removeTaskByIdLocked(tasks.get((int)i).taskId, true, true);
            }
        }
    }

    void removeStackLocked(int stackId) {
        this.mWindowManager.inSurfaceTransaction(() -> this.removeStackInSurfaceTransaction(stackId));
    }

    boolean removeTaskByIdLocked(int taskId, boolean killProcess, boolean removeFromRecents) {
        return this.removeTaskByIdLocked(taskId, killProcess, removeFromRecents, false);
    }

    boolean removeTaskByIdLocked(int taskId, boolean killProcess, boolean removeFromRecents, boolean pauseImmediately) {
        TaskRecord tr = this.anyTaskForIdLocked(taskId, 1, -1);
        if (tr != null) {
            tr.removeTaskActivitiesLocked(pauseImmediately);
            this.cleanUpRemovedTaskLocked(tr, killProcess, removeFromRecents);
            if (tr.isPersistable) {
                this.mService.notifyTaskPersisterLocked(null, true);
            }
            return true;
        }
        Slog.w("ActivityManager", "Request to remove task ignored for non-existent task " + taskId);
        return false;
    }

    void cleanUpRemovedTaskLocked(TaskRecord tr, boolean killProcess, boolean removeFromRecents) {
        int i;
        ComponentName component;
        if (removeFromRecents) {
            this.mRecentTasks.remove(tr);
            tr.removedFromRecents();
        }
        if ((component = tr.getBaseIntent().getComponent()) == null) {
            Slog.w("ActivityManager", "No component for base intent of task: " + tr);
            return;
        }
        this.mService.mServices.cleanUpRemovedTaskLocked(tr, component, new Intent(tr.getBaseIntent()));
        if (!killProcess) {
            return;
        }
        String pkg = component.getPackageName();
        ArrayList<ProcessRecord> procsToKill = new ArrayList<ProcessRecord>();
        ArrayMap<String, SparseArray<ProcessRecord>> pmap = this.mService.mProcessNames.getMap();
        for (i = 0; i < pmap.size(); ++i) {
            SparseArray<ProcessRecord> uids = pmap.valueAt(i);
            for (int j = 0; j < uids.size(); ++j) {
                ProcessRecord proc = uids.valueAt(j);
                if (proc.userId != tr.userId || proc == this.mService.mHomeProcess || !proc.pkgList.containsKey(pkg)) continue;
                for (int k = 0; k < proc.activities.size(); ++k) {
                    TaskRecord otherTask = proc.activities.get(k).getTask();
                    if (tr.taskId == otherTask.taskId || !otherTask.inRecents) continue;
                    return;
                }
                if (proc.foregroundServices) {
                    return;
                }
                procsToKill.add(proc);
            }
        }
        for (i = 0; i < procsToKill.size(); ++i) {
            ProcessRecord pr = (ProcessRecord)procsToKill.get(i);
            if (pr.setSchedGroup == 0 && pr.curReceivers.isEmpty()) {
                pr.kill("remove task", true);
                continue;
            }
            pr.waitingToKill = "remove task";
        }
    }

    int getNextStackId() {
        while (this.mNextFreeStackId < 7 || this.getStack(this.mNextFreeStackId) != null) {
            ++this.mNextFreeStackId;
        }
        return this.mNextFreeStackId;
    }

    boolean restoreRecentTaskLocked(TaskRecord task, int stackId) {
        Object stack;
        if (!ActivityManager.StackId.isStaticStack(stackId)) {
            stackId = task.getLaunchStackId();
        } else if (stackId == 3 && !task.supportsSplitScreen()) {
            stackId = 1;
        }
        ActivityStack currentStack = task.getStack();
        if (currentStack != null) {
            if (currentStack.mStackId == stackId) {
                return true;
            }
            currentStack.removeTask(task, "restoreRecentTaskLocked", 1);
        }
        if ((stack = this.getStack(stackId, true, false)) == null) {
            return false;
        }
        ((ActivityStack)stack).addTask(task, false, "restoreRecentTask");
        task.createWindowContainer(false, true);
        ArrayList<ActivityRecord> activities = task.mActivities;
        for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
            activities.get(activityNdx).createWindowContainer();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void moveStackToDisplayLocked(int stackId, int displayId, boolean onTop) {
        ActivityDisplay activityDisplay = this.getActivityDisplayOrCreateLocked(displayId);
        if (activityDisplay == null) {
            throw new IllegalArgumentException("moveStackToDisplayLocked: Unknown displayId=" + displayId);
        }
        ActivityContainer activityContainer = this.mActivityContainers.get(stackId);
        if (activityContainer == null) throw new IllegalArgumentException("moveStackToDisplayLocked: Unknown stackId=" + stackId);
        if (!activityContainer.isAttachedLocked()) throw new IllegalStateException("moveStackToDisplayLocked: Stack with stackId=" + stackId + " is not attached to any display.");
        if (activityContainer.getDisplayId() == displayId) {
            throw new IllegalArgumentException("Trying to move stackId=" + stackId + " to its current displayId=" + displayId);
        }
        activityContainer.moveToDisplayLocked(activityDisplay, onTop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActivityStack getReparentTargetStack(TaskRecord task, int stackId, boolean toTop) {
        ActivityStack prevStack = task.getStack();
        if (prevStack != null && prevStack.mStackId == stackId) {
            Slog.w("ActivityManager", "Can not reparent to same stack, task=" + task + " already in stackId=" + stackId);
            return prevStack;
        }
        if (ActivityManager.StackId.isMultiWindowStack(stackId) && !this.mService.mSupportsMultiWindow) {
            throw new IllegalArgumentException("Device doesn't support multi-window, can not reparent task=" + task + " to stackId=" + stackId);
        }
        if (ActivityManager.StackId.isDynamicStack(stackId) && !this.mService.mSupportsMultiDisplay) {
            throw new IllegalArgumentException("Device doesn't support multi-display, can not reparent task=" + task + " to stackId=" + stackId);
        }
        if (stackId == 2 && !this.mService.mSupportsFreeformWindowManagement) {
            throw new IllegalArgumentException("Device doesn't support freeform, can not reparent task=" + task);
        }
        if (stackId == 3 && !task.isResizeable()) {
            stackId = prevStack != null ? prevStack.mStackId : 1;
            Slog.w("ActivityManager", "Can not move unresizeable task=" + task + " to docked stack." + " Moving to stackId=" + stackId + " instead.");
        }
        try {
            task.mTemporarilyUnresizable = true;
            Object t = this.getStack(stackId, true, toTop);
            return t;
        }
        finally {
            task.mTemporarilyUnresizable = false;
        }
    }

    boolean moveTopStackActivityToPinnedStackLocked(int stackId, Rect destBounds) {
        Object stack = this.getStack(stackId, false, false);
        if (stack == null) {
            throw new IllegalArgumentException("moveTopStackActivityToPinnedStackLocked: Unknown stackId=" + stackId);
        }
        ActivityRecord r = ((ActivityStack)stack).topRunningActivityLocked();
        if (r == null) {
            Slog.w("ActivityManager", "moveTopStackActivityToPinnedStackLocked: No top running activity in stack=" + stack);
            return false;
        }
        if (!this.mService.mForceResizableActivities && !r.supportsPictureInPicture()) {
            Slog.w("ActivityManager", "moveTopStackActivityToPinnedStackLocked: Picture-In-Picture not supported for  r=" + r);
            return false;
        }
        this.moveActivityToPinnedStackLocked(r, null, 0.0f, true, "moveTopActivityToPinnedStack");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveActivityToPinnedStackLocked(ActivityRecord r, Rect sourceHintBounds, float aspectRatio, boolean moveHomeStackToFront, String reason) {
        this.mWindowManager.deferSurfaceLayout();
        this.moveTasksToFullscreenStackLocked(4, false);
        PinnedActivityStack stack = (PinnedActivityStack)this.getStack(4, true, true);
        try {
            TaskRecord task = r.getTask();
            if (r == task.getStack().getVisibleBehindActivity()) {
                this.requestVisibleBehindLocked(r, false);
            }
            this.resizeStackLocked(4, task.mBounds, null, null, false, true, false);
            if (task.mActivities.size() == 1) {
                if (moveHomeStackToFront && task.getTaskToReturnTo() == 1 && (r.state == ActivityStack.ActivityState.RESUMED || !r.supportsPictureInPictureWhilePausing)) {
                    this.moveHomeStackToFront(reason);
                }
                task.reparent(4, true, 0, false, true, false, reason);
            } else {
                TaskRecord newTask = task.getStack().createTaskRecord(this.getNextTaskIdForUserLocked(r.userId), r.info, r.intent, null, null, true, r.mActivityType);
                r.reparent(newTask, Integer.MAX_VALUE, "moveActivityToStack");
                newTask.reparent(4, true, 0, false, true, false, reason);
            }
            r.supportsPictureInPictureWhilePausing = false;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
        Rect destBounds = stack.getDefaultPictureInPictureBounds(aspectRatio);
        stack.animateResizePinnedStack(sourceHintBounds, destBounds, -1, true);
        this.ensureActivitiesVisibleLocked(null, 0, false);
        this.resumeFocusedStackTopActivityLocked();
        this.mService.mTaskChangeNotificationController.notifyActivityPinned(r.packageName, r.getTask().taskId);
    }

    boolean moveFocusableActivityStackToFrontLocked(ActivityRecord r, String reason) {
        if (r == null || !r.isFocusable()) {
            return false;
        }
        TaskRecord task = r.getTask();
        Object stack = r.getStack();
        if (stack == null) {
            Slog.w("ActivityManager", "moveActivityStackToFront: invalid task or stack: r=" + r + " task=" + task);
            return false;
        }
        if (stack == this.mFocusedStack && ((ActivityStack)stack).topRunningActivityLocked() == r) {
            return false;
        }
        ((ActivityStack)stack).moveToFront(reason, task);
        return true;
    }

    ActivityRecord findTaskLocked(ActivityRecord r, int displayId) {
        this.mTmpFindTaskResult.r = null;
        this.mTmpFindTaskResult.matchedByRootAffinity = false;
        ActivityRecord affinityMatch = null;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.checkActivityBelongsInStack(r, stack) || !stack.mActivityContainer.isEligibleForNewTasks()) continue;
                stack.findTaskLocked(r, this.mTmpFindTaskResult);
                if (this.mTmpFindTaskResult.r == null) continue;
                if (!this.mTmpFindTaskResult.matchedByRootAffinity) {
                    return this.mTmpFindTaskResult.r;
                }
                if (this.mTmpFindTaskResult.r.getDisplayId() != displayId) continue;
                affinityMatch = this.mTmpFindTaskResult.r;
            }
        }
        return affinityMatch;
    }

    private boolean checkActivityBelongsInStack(ActivityRecord r, ActivityStack stack) {
        if (r.isHomeActivity()) {
            return stack.isHomeStack();
        }
        if (r.isRecentsActivity()) {
            return stack.isRecentsStack();
        }
        if (r.isAssistantActivity()) {
            return stack.isAssistantStack();
        }
        return true;
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info, boolean compareIntentFilters) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord ar = stacks.get(stackNdx).findActivityLocked(intent, info, compareIntentFilters);
                if (ar == null) continue;
                return ar;
            }
        }
        return null;
    }

    void goingToSleepLocked() {
        this.scheduleSleepTimeout();
        if (!this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.acquire();
            if (this.mLaunchingActivity.isHeld()) {
                this.mLaunchingActivity.release();
                this.mService.mHandler.removeMessages(104);
            }
        }
        this.checkReadyForSleepLocked();
    }

    boolean shutdownLocked(int timeout) {
        boolean timedout;
        block5: {
            this.goingToSleepLocked();
            timedout = false;
            long endTime = System.currentTimeMillis() + (long)timeout;
            while (true) {
                boolean cantShutdown = false;
                for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                    ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
                    for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                        cantShutdown |= stacks.get(stackNdx).checkReadyForSleepLocked();
                    }
                }
                if (!cantShutdown) break block5;
                long timeRemaining = endTime - System.currentTimeMillis();
                if (timeRemaining <= 0L) break;
                try {
                    this.mService.wait(timeRemaining);
                }
                catch (InterruptedException interruptedException) {}
            }
            Slog.w("ActivityManager", "Activity manager shutdown timed out");
            timedout = true;
        }
        this.mSleepTimeout = true;
        this.checkReadyForSleepLocked();
        return timedout;
    }

    void comeOutOfSleepIfNeededLocked() {
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.awakeFromSleepingLocked();
                if (!this.isFocusedStack(stack)) continue;
                this.resumeFocusedStackTopActivityLocked();
            }
        }
        this.mGoingToSleepActivities.clear();
    }

    void activitySleptLocked(ActivityRecord r) {
        this.mGoingToSleepActivities.remove(r);
        this.checkReadyForSleepLocked();
    }

    void checkReadyForSleepLocked() {
        if (!this.mService.isSleepingOrShuttingDownLocked()) {
            return;
        }
        if (!this.mSleepTimeout) {
            boolean dontSleep = false;
            for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
                for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                    dontSleep |= stacks.get(stackNdx).checkReadyForSleepLocked();
                }
            }
            if (this.mStoppingActivities.size() > 0) {
                this.scheduleIdleLocked();
                dontSleep = true;
            }
            if (this.mGoingToSleepActivities.size() > 0) {
                dontSleep = true;
            }
            if (dontSleep) {
                return;
            }
        }
        this.mService.mActivityStarter.sendPowerHintForLaunchEndIfNeeded();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).goToSleep();
            }
        }
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        if (this.mService.mShuttingDown) {
            this.mService.notifyAll();
        }
    }

    boolean reportResumedActivityLocked(ActivityRecord r) {
        Object stack = r.getStack();
        if (this.isFocusedStack((ActivityStack)stack)) {
            this.mService.updateUsageStats(r, true);
        }
        if (this.allResumedActivitiesComplete()) {
            this.ensureActivitiesVisibleLocked(null, 0, false);
            this.mWindowManager.executeAppTransition();
            return true;
        }
        return false;
    }

    void handleAppCrashLocked(ProcessRecord app) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).handleAppCrashLocked(app);
            }
        }
    }

    boolean requestVisibleBehindLocked(ActivityRecord r, boolean visible) {
        ActivityRecord next;
        Object stack = r.getStack();
        if (stack == null) {
            return false;
        }
        if (visible && !ActivityManager.StackId.activitiesCanRequestVisibleBehind(((ActivityStack)stack).mStackId)) {
            return false;
        }
        boolean isVisible = ((ActivityStack)stack).hasVisibleBehindActivity();
        ActivityRecord top = this.topRunningActivityLocked();
        if (top == null || top == r || visible == isVisible) {
            ((ActivityStack)stack).setVisibleBehindActivity(visible ? r : null);
            return true;
        }
        if (visible && top.fullscreen) {
            return false;
        }
        if (!visible && ((ActivityStack)stack).getVisibleBehindActivity() != r) {
            return false;
        }
        ((ActivityStack)stack).setVisibleBehindActivity(visible ? r : null);
        if (!visible && (next = ((ActivityStack)stack).findNextTranslucentActivity(r)) != null && next.isHomeActivity()) {
            this.mService.convertFromTranslucent(next.appToken);
        }
        if (top.app != null && top.app.thread != null) {
            try {
                top.app.thread.scheduleBackgroundVisibleBehindChanged(top.appToken, visible);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return true;
    }

    private void handleLaunchTaskBehindCompleteLocked(ActivityRecord r) {
        TaskRecord task = r.getTask();
        ActivityStack stack = task.getStack();
        r.mLaunchTaskBehind = false;
        task.setLastThumbnailLocked(r.screenshotActivityLocked());
        this.mRecentTasks.addLocked(task);
        this.mService.mTaskChangeNotificationController.notifyTaskStackChanged();
        r.setVisibility(false);
        ActivityRecord top = stack.topActivity();
        if (top != null) {
            top.getTask().touchActiveTime();
        }
    }

    void scheduleLaunchTaskBehindComplete(IBinder token) {
        this.mHandler.obtainMessage(112, token).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges, boolean preserveWindows) {
        this.mKeyguardController.beginActivityVisibilityUpdate();
        try {
            for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                int topStackNdx;
                ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
                for (int stackNdx = topStackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                    ActivityStack stack = stacks.get(stackNdx);
                    stack.ensureActivitiesVisibleLocked(starting, configChanges, preserveWindows);
                }
            }
        }
        finally {
            this.mKeyguardController.endActivityVisibilityUpdate();
        }
    }

    void addStartingWindowsForVisibleActivities(boolean taskSwitch) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            int topStackNdx;
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = topStackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.addStartingWindowsForVisibleActivities(taskSwitch);
            }
        }
    }

    void invalidateTaskLayers() {
        this.mTaskLayersChanged = true;
    }

    void rankTaskLayersIfNeeded() {
        if (!this.mTaskLayersChanged) {
            return;
        }
        this.mTaskLayersChanged = false;
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int baseLayer = 0;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                baseLayer += stacks.get(stackNdx).rankTaskLayers(baseLayer);
            }
        }
    }

    void clearOtherAppTimeTrackers(AppTimeTracker except) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            int topStackNdx;
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = topStackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.clearOtherAppTimeTrackers(except);
            }
        }
    }

    void scheduleDestroyAllActivities(ProcessRecord app, String reason) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int numStacks = stacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.scheduleDestroyActivities(app, reason);
            }
        }
    }

    void releaseSomeActivitiesLocked(ProcessRecord app, String reason) {
        TaskRecord firstTask = null;
        ArraySet<TaskRecord> tasks = null;
        for (int i = 0; i < app.activities.size(); ++i) {
            TaskRecord task;
            ActivityRecord r = app.activities.get(i);
            if (r.finishing || r.state == ActivityStack.ActivityState.DESTROYING || r.state == ActivityStack.ActivityState.DESTROYED) {
                return;
            }
            if (r.visible || !r.stopped || !r.haveState || r.state == ActivityStack.ActivityState.RESUMED || r.state == ActivityStack.ActivityState.PAUSING || r.state == ActivityStack.ActivityState.PAUSED || r.state == ActivityStack.ActivityState.STOPPING || (task = r.getTask()) == null) continue;
            if (firstTask == null) {
                firstTask = task;
                continue;
            }
            if (firstTask == task) continue;
            if (tasks == null) {
                tasks = new ArraySet<TaskRecord>();
                tasks.add(firstTask);
            }
            tasks.add(task);
        }
        if (tasks == null) {
            return;
        }
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = 0; stackNdx < stacks.size(); ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (stack.releaseSomeActivitiesLocked(app, tasks, reason) <= 0) continue;
                return;
            }
        }
    }

    boolean switchUserLocked(int userId, UserState uss) {
        int focusStackId = this.mFocusedStack.getStackId();
        this.moveTasksToFullscreenStackLocked(3, focusStackId == 3);
        this.removeStackLocked(4);
        this.mUserStackInFront.put(this.mCurrentUser, focusStackId);
        int restoreStackId = this.mUserStackInFront.get(userId, 0);
        this.mCurrentUser = userId;
        this.mStartingUsers.add(uss);
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.switchUserLocked(userId);
                TaskRecord task = stack.topTask();
                if (task == null) continue;
                stack.positionChildWindowContainerAtTop(task);
            }
        }
        Object stack = this.getStack(restoreStackId);
        if (stack == null) {
            stack = this.mHomeStack;
        }
        boolean homeInFront = ((ActivityStack)stack).isHomeStack();
        if (((ActivityStack)stack).isOnHomeDisplay()) {
            ((ActivityStack)stack).moveToFront("switchUserOnHomeDisplay");
        } else {
            this.resumeHomeStackTask(null, "switchUserOnOtherDisplay");
        }
        return homeInFront;
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUser) {
            return true;
        }
        return this.mService.mUserController.isCurrentProfileLocked(userId);
    }

    boolean isStoppingNoHistoryActivity() {
        for (ActivityRecord record : this.mStoppingActivities) {
            if (!record.isNoHistory()) continue;
            return true;
        }
        return false;
    }

    final ArrayList<ActivityRecord> processStoppingActivitiesLocked(ActivityRecord idleActivity, boolean remove, boolean processPausingActivities) {
        ArrayList<ActivityRecord> stops = null;
        boolean nowVisible = this.allResumedActivitiesVisible();
        for (int activityNdx = this.mStoppingActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord s = this.mStoppingActivities.get(activityNdx);
            boolean waitingVisible = this.mActivitiesWaitingForVisibleActivity.contains(s);
            if (waitingVisible && nowVisible) {
                this.mActivitiesWaitingForVisibleActivity.remove(s);
                waitingVisible = false;
                if (s.finishing) {
                    s.setVisibility(false);
                }
            }
            if (waitingVisible && !this.mService.isSleepingOrShuttingDownLocked() || !remove) continue;
            if (!processPausingActivities && s.state == ActivityStack.ActivityState.PAUSING) {
                this.removeTimeoutsForActivityLocked(idleActivity);
                this.scheduleIdleTimeoutLocked(idleActivity);
                continue;
            }
            if (stops == null) {
                stops = new ArrayList<ActivityRecord>();
            }
            stops.add(s);
            this.mStoppingActivities.remove(activityNdx);
        }
        return stops;
    }

    void validateTopActivitiesLocked() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack.ActivityState state;
                ActivityStack stack = stacks.get(stackNdx);
                ActivityRecord r = stack.topRunningActivityLocked();
                ActivityStack.ActivityState activityState = state = r == null ? ActivityStack.ActivityState.DESTROYED : r.state;
                if (this.isFocusedStack(stack)) {
                    if (r == null) {
                        Slog.e("ActivityManager", "validateTop...: null top activity, stack=" + stack);
                        continue;
                    }
                    ActivityRecord pausing = stack.mPausingActivity;
                    if (pausing != null && pausing == r) {
                        Slog.e("ActivityManager", "validateTop...: top stack has pausing activity r=" + r + " state=" + (Object)((Object)state));
                    }
                    if (state == ActivityStack.ActivityState.INITIALIZING || state == ActivityStack.ActivityState.RESUMED) continue;
                    Slog.e("ActivityManager", "validateTop...: activity in front not resumed r=" + r + " state=" + (Object)((Object)state));
                    continue;
                }
                ActivityRecord resumed = stack.mResumedActivity;
                if (resumed != null && resumed == r) {
                    Slog.e("ActivityManager", "validateTop...: back stack has resumed activity r=" + r + " state=" + (Object)((Object)state));
                }
                if (r == null || state != ActivityStack.ActivityState.INITIALIZING && state != ActivityStack.ActivityState.RESUMED) continue;
                Slog.e("ActivityManager", "validateTop...: activity in back resumed r=" + r + " state=" + (Object)((Object)state));
            }
        }
    }

    private String lockTaskModeToString() {
        switch (this.mLockTaskModeState) {
            case 1: {
                return "LOCKED";
            }
            case 2: {
                return "PINNED";
            }
            case 0: {
                return "NONE";
            }
        }
        return "unknown=" + this.mLockTaskModeState;
    }

    public void dump(PrintWriter pw, String prefix) {
        int i;
        pw.print(prefix);
        pw.print("mFocusedStack=" + this.mFocusedStack);
        pw.print(" mLastFocusedStack=");
        pw.println(this.mLastFocusedStack);
        pw.print(prefix);
        pw.println("mSleepTimeout=" + this.mSleepTimeout);
        pw.print(prefix);
        pw.println("mCurTaskIdForUser=" + this.mCurTaskIdForUser);
        pw.print(prefix);
        pw.println("mUserStackInFront=" + this.mUserStackInFront);
        pw.print(prefix);
        pw.println("mActivityContainers=" + this.mActivityContainers);
        pw.print(prefix);
        pw.print("mLockTaskModeState=" + this.lockTaskModeToString());
        SparseArray<String[]> packages = this.mService.mLockTaskPackages;
        if (packages.size() > 0) {
            pw.print(prefix);
            pw.println("mLockTaskPackages (userId:packages)=");
            for (i = 0; i < packages.size(); ++i) {
                pw.print(prefix);
                pw.print(prefix);
                pw.print(packages.keyAt(i));
                pw.print(":");
                pw.println(Arrays.toString(packages.valueAt(i)));
            }
        }
        if (!this.mWaitingForActivityVisible.isEmpty()) {
            pw.print(prefix);
            pw.println("mWaitingForActivityVisible=");
            for (i = 0; i < this.mWaitingForActivityVisible.size(); ++i) {
                pw.print(prefix);
                pw.print(prefix);
                this.mWaitingForActivityVisible.get(i).dump(pw, prefix);
            }
        }
        pw.println(" mLockTaskModeTasks" + this.mLockTaskModeTasks);
        this.mKeyguardController.dump(pw, prefix);
    }

    void dumpDisplayConfigs(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("Display override configurations:");
        int displayCount = this.mActivityDisplays.size();
        for (int i = 0; i < displayCount; ++i) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(i);
            pw.print(prefix);
            pw.print("  ");
            pw.print(activityDisplay.mDisplayId);
            pw.print(": ");
            pw.println(activityDisplay.getOverrideConfiguration());
        }
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name, boolean dumpVisibleStacksOnly, boolean dumpFocusedStackOnly) {
        if (dumpFocusedStackOnly) {
            return this.mFocusedStack.getDumpActivitiesLocked(name);
        }
        ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>();
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (dumpVisibleStacksOnly && stack.shouldBeVisible(null) != 1) continue;
                activities.addAll(stack.getDumpActivitiesLocked(name));
            }
        }
        return activities;
    }

    static boolean printThisActivity(PrintWriter pw, ActivityRecord activity, String dumpPackage, boolean needSep, String prefix) {
        if (activity != null && (dumpPackage == null || dumpPackage.equals(activity.packageName))) {
            if (needSep) {
                pw.println();
            }
            pw.print(prefix);
            pw.println(activity);
            return true;
        }
        return false;
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printed = false;
        boolean needSep = false;
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(displayNdx);
            pw.print("Display #");
            pw.print(activityDisplay.mDisplayId);
            pw.println(" (activities from top to bottom):");
            ArrayList<ActivityStack> stacks = activityDisplay.mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                boolean pr;
                ActivityStack stack = stacks.get(stackNdx);
                StringBuilder stackHeader = new StringBuilder(128);
                stackHeader.append("  Stack #");
                stackHeader.append(stack.mStackId);
                stackHeader.append(":");
                stackHeader.append("\n");
                stackHeader.append("  mFullscreen=" + stack.mFullscreen);
                stackHeader.append("\n");
                stackHeader.append("  mBounds=" + stack.mBounds);
                boolean printedStackHeader = stack.dumpActivitiesLocked(fd, pw, dumpAll, dumpClient, dumpPackage, needSep, stackHeader.toString());
                printed |= printedStackHeader;
                if (!printedStackHeader) {
                    pw.println();
                    pw.println(stackHeader);
                }
                if (pr = ActivityStackSupervisor.printThisActivity(pw, stack.mPausingActivity, dumpPackage, needSep = (printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, stack.mLRUActivities, "    ", "Run", false, !dumpAll, false, dumpPackage, true, "    Running activities (most recent first):", null)), "    mPausingActivity: ")) {
                    printed = true;
                    needSep = false;
                }
                if (pr = ActivityStackSupervisor.printThisActivity(pw, stack.mResumedActivity, dumpPackage, needSep, "    mResumedActivity: ")) {
                    printed = true;
                    needSep = false;
                }
                if (dumpAll) {
                    pr = ActivityStackSupervisor.printThisActivity(pw, stack.mLastPausedActivity, dumpPackage, needSep, "    mLastPausedActivity: ");
                    if (pr) {
                        printed = true;
                        needSep = true;
                    }
                    printed |= ActivityStackSupervisor.printThisActivity(pw, stack.mLastNoHistoryActivity, dumpPackage, needSep, "    mLastNoHistoryActivity: ");
                }
                needSep = printed;
            }
        }
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mFinishingActivities, "  ", "Fin", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to finish:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mStoppingActivities, "  ", "Stop", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to stop:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mActivitiesWaitingForVisibleActivity, "  ", "Wait", false, !dumpAll, false, dumpPackage, true, "  Activities waiting for another to become visible:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
        return printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dumpHistoryList(FileDescriptor fd, PrintWriter pw, List<ActivityRecord> list, String prefix, String label, boolean complete, boolean brief, boolean client, String dumpPackage, boolean needNL, String header1, String header2) {
        TaskRecord lastTask = null;
        String innerPrefix = null;
        String[] args = null;
        boolean printed = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean full;
            ActivityRecord r = list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.packageName)) continue;
            if (innerPrefix == null) {
                innerPrefix = prefix + "      ";
                args = new String[]{};
            }
            printed = true;
            boolean bl = full = !brief && (complete || !r.isInHistory());
            if (needNL) {
                pw.println("");
                needNL = false;
            }
            if (header1 != null) {
                pw.println(header1);
                header1 = null;
            }
            if (header2 != null) {
                pw.println(header2);
                header2 = null;
            }
            if (lastTask != r.getTask()) {
                lastTask = r.getTask();
                pw.print(prefix);
                pw.print(full ? "* " : "  ");
                pw.println(lastTask);
                if (full) {
                    lastTask.dump(pw, prefix + "  ");
                } else if (complete && lastTask.intent != null) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(lastTask.intent.toInsecureStringWithClip());
                }
            }
            pw.print(prefix);
            pw.print(full ? "  * " : "    ");
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            if (full) {
                r.dump(pw, innerPrefix);
            } else if (complete) {
                pw.print(innerPrefix);
                pw.println(r.intent.toInsecureString());
                if (r.app != null) {
                    pw.print(innerPrefix);
                    pw.println(r.app);
                }
            }
            if (!client || r.app == null || r.app.thread == null) continue;
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd(), r.appToken, innerPrefix, args);
                    tp.go(fd, 2000L);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
            needNL = true;
        }
        return printed;
    }

    void scheduleIdleTimeoutLocked(ActivityRecord next) {
        Message msg = this.mHandler.obtainMessage(100, next);
        this.mHandler.sendMessageDelayed(msg, 10000L);
    }

    final void scheduleIdleLocked() {
        this.mHandler.sendEmptyMessage(101);
    }

    void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mHandler.removeMessages(100, r);
    }

    final void scheduleResumeTopActivities() {
        if (!this.mHandler.hasMessages(102)) {
            this.mHandler.sendEmptyMessage(102);
        }
    }

    void removeSleepTimeouts() {
        this.mSleepTimeout = false;
        this.mHandler.removeMessages(103);
    }

    final void scheduleSleepTimeout() {
        this.removeSleepTimeouts();
        this.mHandler.sendEmptyMessageDelayed(103, 5000L);
    }

    @Override
    public void onDisplayAdded(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(105, displayId, 0));
    }

    @Override
    public void onDisplayRemoved(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(107, displayId, 0));
    }

    @Override
    public void onDisplayChanged(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(106, displayId, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayAdded(int displayId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            this.getActivityDisplayOrCreateLocked(displayId);
        }
    }

    boolean isDisplayAdded(int displayId) {
        return this.getActivityDisplayOrCreateLocked(displayId) != null;
    }

    private ActivityDisplay getActivityDisplayOrCreateLocked(int displayId) {
        ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
        if (activityDisplay != null) {
            return activityDisplay;
        }
        if (this.mDisplayManager == null) {
            return null;
        }
        Display display = this.mDisplayManager.getDisplay(displayId);
        if (display == null) {
            return null;
        }
        activityDisplay = new ActivityDisplay(displayId);
        if (activityDisplay.mDisplay == null) {
            Slog.w("ActivityManager", "Display " + displayId + " gone before initialization complete");
            return null;
        }
        this.mActivityDisplays.put(displayId, activityDisplay);
        this.calculateDefaultMinimalSizeOfResizeableTasks(activityDisplay);
        this.mWindowManager.onDisplayAdded(displayId);
        return activityDisplay;
    }

    private void calculateDefaultMinimalSizeOfResizeableTasks(ActivityDisplay display) {
        this.mDefaultMinSizeOfResizeableTask = this.mService.mContext.getResources().getDimensionPixelSize(17104998);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayRemoved(int displayId) {
        if (displayId == 0) {
            throw new IllegalArgumentException("Can't remove the primary display.");
        }
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
            if (activityDisplay != null) {
                boolean destroyContentOnRemoval = activityDisplay.shouldDestroyContentOnRemove();
                ArrayList<ActivityStack> stacks = activityDisplay.mStacks;
                while (!stacks.isEmpty()) {
                    ActivityStack stack = stacks.get(0);
                    if (destroyContentOnRemoval) {
                        this.moveStackToDisplayLocked(stack.mStackId, 0, false);
                        stack.finishAllActivitiesLocked(true);
                        continue;
                    }
                    this.moveTasksToFullscreenStackLocked(stack.getStackId(), true);
                }
                this.mActivityDisplays.remove(displayId);
                this.mWindowManager.onDisplayRemoved(displayId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayChanged(int displayId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
            if (activityDisplay != null) {
                // empty if block
            }
            this.mWindowManager.onDisplayChanged(displayId);
        }
    }

    private ActivityManager.StackInfo getStackInfoLocked(ActivityStack stack) {
        int displayId = stack.mDisplayId;
        ActivityDisplay display = this.mActivityDisplays.get(displayId);
        ActivityManager.StackInfo info = new ActivityManager.StackInfo();
        stack.getWindowContainerBounds(info.bounds);
        info.displayId = displayId;
        info.stackId = stack.mStackId;
        info.userId = stack.mCurrentUser;
        info.visible = stack.shouldBeVisible(null) == 1;
        info.position = display != null ? display.mStacks.indexOf(stack) : 0;
        ArrayList<TaskRecord> tasks = stack.getAllTasks();
        int numTasks = tasks.size();
        int[] taskIds = new int[numTasks];
        String[] taskNames = new String[numTasks];
        Rect[] taskBounds = new Rect[numTasks];
        int[] taskUserIds = new int[numTasks];
        for (int i = 0; i < numTasks; ++i) {
            TaskRecord task = tasks.get(i);
            taskIds[i] = task.taskId;
            taskNames[i] = task.origActivity != null ? task.origActivity.flattenToString() : (task.realActivity != null ? task.realActivity.flattenToString() : (task.getTopActivity() != null ? task.getTopActivity().packageName : "unknown"));
            taskBounds[i] = new Rect();
            task.getWindowContainerBounds(taskBounds[i]);
            taskUserIds[i] = task.userId;
        }
        info.taskIds = taskIds;
        info.taskNames = taskNames;
        info.taskBounds = taskBounds;
        info.taskUserIds = taskUserIds;
        ActivityRecord top = stack.topRunningActivityLocked();
        info.topActivity = top != null ? top.intent.getComponent() : null;
        return info;
    }

    ActivityManager.StackInfo getStackInfoLocked(int stackId) {
        Object stack = this.getStack(stackId);
        if (stack != null) {
            return this.getStackInfoLocked((ActivityStack)stack);
        }
        return null;
    }

    ArrayList<ActivityManager.StackInfo> getAllStackInfosLocked() {
        ArrayList<ActivityManager.StackInfo> list = new ArrayList<ActivityManager.StackInfo>();
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int ndx = stacks.size() - 1; ndx >= 0; --ndx) {
                list.add(this.getStackInfoLocked(stacks.get(ndx)));
            }
        }
        return list;
    }

    TaskRecord getLockedTaskLocked() {
        int top = this.mLockTaskModeTasks.size() - 1;
        if (top >= 0) {
            return this.mLockTaskModeTasks.get(top);
        }
        return null;
    }

    boolean isLockedTask(TaskRecord task) {
        return this.mLockTaskModeTasks.contains(task);
    }

    boolean isLastLockedTask(TaskRecord task) {
        return this.mLockTaskModeTasks.size() == 1 && this.mLockTaskModeTasks.contains(task);
    }

    void removeLockedTaskLocked(TaskRecord task) {
        if (!this.mLockTaskModeTasks.remove(task)) {
            return;
        }
        if (this.mLockTaskModeTasks.isEmpty()) {
            Message lockTaskMsg = Message.obtain();
            lockTaskMsg.arg1 = task.userId;
            lockTaskMsg.what = 110;
            this.mHandler.sendMessage(lockTaskMsg);
        }
    }

    void handleNonResizableTaskIfNeeded(TaskRecord task, int preferredStackId, int preferredDisplayId, int actualStackId) {
        this.handleNonResizableTaskIfNeeded(task, preferredStackId, preferredDisplayId, actualStackId, false);
    }

    private void handleNonResizableTaskIfNeeded(TaskRecord task, int preferredStackId, int preferredDisplayId, int actualStackId, boolean forceNonResizable) {
        boolean launchOnSecondaryDisplayFailed;
        boolean isSecondaryDisplayPreferred;
        boolean bl = isSecondaryDisplayPreferred = preferredDisplayId != 0 && preferredDisplayId != -1 || ActivityManager.StackId.isDynamicStack(preferredStackId);
        if (!this.isStackDockedInEffect(actualStackId) && preferredStackId != 3 && !isSecondaryDisplayPreferred || task.isHomeTask()) {
            return;
        }
        if (isSecondaryDisplayPreferred) {
            int actualDisplayId = task.getStack().mDisplayId;
            if (!task.canBeLaunchedOnDisplay(actualDisplayId)) {
                this.mService.moveTaskToStack(task.taskId, 1, true);
                launchOnSecondaryDisplayFailed = true;
            } else {
                launchOnSecondaryDisplayFailed = actualDisplayId == 0 || preferredDisplayId != -1 && preferredDisplayId != actualDisplayId;
            }
        } else {
            launchOnSecondaryDisplayFailed = false;
        }
        ActivityRecord topActivity = task.getTopActivity();
        if (launchOnSecondaryDisplayFailed || !task.supportsSplitScreen() || forceNonResizable) {
            if (launchOnSecondaryDisplayFailed) {
                this.mService.mTaskChangeNotificationController.notifyActivityLaunchOnSecondaryDisplayFailed();
            } else {
                this.mService.mTaskChangeNotificationController.notifyActivityDismissingDockedStack();
            }
            this.moveTasksToFullscreenStackLocked(3, actualStackId == 3);
        } else if (topActivity != null && topActivity.isNonResizableOrForcedResizable() && !topActivity.noDisplay) {
            String packageName = topActivity.appInfo.packageName;
            int reason = isSecondaryDisplayPreferred ? 2 : 1;
            this.mService.mTaskChangeNotificationController.notifyActivityForcedResizable(task.taskId, reason, packageName);
        }
    }

    void showLockTaskToast() {
        if (this.mLockTaskNotify != null) {
            this.mLockTaskNotify.showToast(this.mLockTaskModeState);
        }
    }

    void showLockTaskEscapeMessageLocked(TaskRecord task) {
        if (this.mLockTaskModeTasks.contains(task)) {
            this.mHandler.sendEmptyMessage(113);
        }
    }

    void setLockTaskModeLocked(TaskRecord task, int lockTaskModeState, String reason, boolean andResume) {
        if (task == null) {
            TaskRecord lockedTask = this.getLockedTaskLocked();
            if (lockedTask != null) {
                this.removeLockedTaskLocked(lockedTask);
                if (!this.mLockTaskModeTasks.isEmpty()) {
                    lockedTask.performClearTaskLocked();
                    this.resumeFocusedStackTopActivityLocked();
                    return;
                }
            }
            return;
        }
        if (task.mLockTaskAuth == 0) {
            return;
        }
        if (this.isLockTaskModeViolation(task)) {
            Slog.e("ActivityManager", "setLockTaskMode: Attempt to start an unauthorized lock task.");
            return;
        }
        if (this.mLockTaskModeTasks.isEmpty()) {
            Message lockTaskMsg = Message.obtain();
            lockTaskMsg.obj = task.intent.getComponent().getPackageName();
            lockTaskMsg.arg1 = task.userId;
            lockTaskMsg.what = 109;
            lockTaskMsg.arg2 = lockTaskModeState;
            this.mHandler.sendMessage(lockTaskMsg);
        }
        this.mLockTaskModeTasks.remove(task);
        this.mLockTaskModeTasks.add(task);
        if (task.mLockTaskUid == -1) {
            task.mLockTaskUid = task.effectiveUid;
        }
        if (andResume) {
            this.findTaskToMoveToFrontLocked(task, 0, null, reason, lockTaskModeState != 0);
            this.resumeFocusedStackTopActivityLocked();
            this.mWindowManager.executeAppTransition();
        } else if (lockTaskModeState != 0) {
            this.handleNonResizableTaskIfNeeded(task, -1, 0, task.getStackId(), true);
        }
    }

    boolean isLockTaskModeViolation(TaskRecord task) {
        return this.isLockTaskModeViolation(task, false);
    }

    boolean isLockTaskModeViolation(TaskRecord task, boolean isNewClearTask) {
        if (this.getLockedTaskLocked() == task && !isNewClearTask) {
            return false;
        }
        int lockTaskAuth = task.mLockTaskAuth;
        switch (lockTaskAuth) {
            case 0: {
                return !this.mLockTaskModeTasks.isEmpty();
            }
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
            case 1: {
                return !this.mLockTaskModeTasks.isEmpty();
            }
        }
        Slog.w("ActivityManager", "isLockTaskModeViolation: invalid lockTaskAuth value=" + lockTaskAuth);
        return true;
    }

    void onLockTaskPackagesUpdatedLocked() {
        TaskRecord task;
        boolean didSomething = false;
        for (int taskNdx = this.mLockTaskModeTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            boolean isWhitelisted;
            TaskRecord lockedTask = this.mLockTaskModeTasks.get(taskNdx);
            boolean wasWhitelisted = lockedTask.mLockTaskAuth == 2 || lockedTask.mLockTaskAuth == 3;
            lockedTask.setLockTaskAuth();
            boolean bl = isWhitelisted = lockedTask.mLockTaskAuth == 2 || lockedTask.mLockTaskAuth == 3;
            if (!wasWhitelisted || isWhitelisted) continue;
            this.removeLockedTaskLocked(lockedTask);
            lockedTask.performClearTaskLocked();
            didSomething = true;
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.onLockTaskPackagesUpdatedLocked();
            }
        }
        ActivityRecord r = this.topRunningActivityLocked();
        TaskRecord taskRecord = task = r != null ? r.getTask() : null;
        if (this.mLockTaskModeTasks.isEmpty() && task != null && task.mLockTaskAuth == 2) {
            this.setLockTaskModeLocked(task, 1, "package updated", false);
            didSomething = true;
        }
        if (didSomething) {
            this.resumeFocusedStackTopActivityLocked();
        }
    }

    int getLockTaskModeState() {
        return this.mLockTaskModeState;
    }

    void activityRelaunchedLocked(IBinder token) {
        ActivityRecord r;
        this.mWindowManager.notifyAppRelaunchingFinished(token);
        if (this.mService.isSleepingOrShuttingDownLocked() && (r = ActivityRecord.isInStackLocked(token)) != null) {
            r.setSleeping(true, true);
        }
    }

    void activityRelaunchingLocked(ActivityRecord r) {
        this.mWindowManager.notifyAppRelaunching(r.appToken);
    }

    void logStackState() {
        this.mActivityMetricsLogger.logWindowState();
    }

    void scheduleUpdateMultiWindowMode(TaskRecord task) {
        if (task.getStack().deferScheduleMultiWindowModeChanged()) {
            return;
        }
        for (int i = task.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = task.mActivities.get(i);
            if (r.app == null || r.app.thread == null) continue;
            this.mMultiWindowModeChangedActivities.add(r);
        }
        if (!this.mHandler.hasMessages(114)) {
            this.mHandler.sendEmptyMessage(114);
        }
    }

    void scheduleUpdatePictureInPictureModeIfNeeded(TaskRecord task, ActivityStack prevStack) {
        ActivityStack stack = task.getStack();
        if (prevStack == null || prevStack == stack || prevStack.mStackId != 4 && stack.mStackId != 4) {
            return;
        }
        this.scheduleUpdatePictureInPictureModeIfNeeded(task, stack.mBounds, false);
    }

    void scheduleUpdatePictureInPictureModeIfNeeded(TaskRecord task, Rect targetStackBounds, boolean immediate) {
        if (immediate) {
            this.mHandler.removeMessages(115);
            for (int i = task.mActivities.size() - 1; i >= 0; --i) {
                ActivityRecord r = task.mActivities.get(i);
                if (r.app == null || r.app.thread == null) continue;
                r.updatePictureInPictureMode(targetStackBounds);
            }
        } else {
            for (int i = task.mActivities.size() - 1; i >= 0; --i) {
                ActivityRecord r = task.mActivities.get(i);
                if (r.app == null || r.app.thread == null) continue;
                this.mPipModeChangedActivities.add(r);
            }
            this.mPipModeChangedTargetStackBounds = targetStackBounds;
            if (!this.mHandler.hasMessages(115)) {
                this.mHandler.sendEmptyMessage(115);
            }
        }
    }

    void setDockedStackMinimized(boolean minimized) {
        this.mIsDockMinimized = minimized;
    }

    ActivityStack findStackBehind(ActivityStack stack) {
        ActivityDisplay display = this.mActivityDisplays.get(0);
        if (display == null) {
            return null;
        }
        ArrayList<ActivityStack> stacks = display.mStacks;
        for (int i = stacks.size() - 1; i >= 0; --i) {
            if (stacks.get(i) != stack || i <= 0) continue;
            return stacks.get(i - 1);
        }
        throw new IllegalStateException("Failed to find a stack behind stack=" + stack + " in=" + stacks);
    }

    private void setResizingDuringAnimation(TaskRecord task) {
        this.mResizingTasksDuringAnimation.add(task.taskId);
        task.setTaskDockedResizing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityFromRecentsInner(int taskId, Bundle bOptions) {
        int launchStackId;
        ActivityOptions activityOptions = bOptions != null ? new ActivityOptions(bOptions) : null;
        int n = launchStackId = activityOptions != null ? activityOptions.getLaunchStackId() : -1;
        if (ActivityManager.StackId.isHomeOrRecentsStack(launchStackId)) {
            throw new IllegalArgumentException("startActivityFromRecentsInner: Task " + taskId + " can't be launch in the home/recents stack.");
        }
        this.mWindowManager.deferSurfaceLayout();
        try {
            ActivityRecord sourceRecord;
            TaskRecord task;
            if (launchStackId == 3) {
                this.mWindowManager.setDockedStackCreateState(activityOptions.getDockCreateMode(), null);
                this.deferUpdateBounds(5);
                this.mWindowManager.prepareAppTransition(19, false);
            }
            if ((task = this.anyTaskForIdLocked(taskId, 2, launchStackId)) == null) {
                this.continueUpdateBounds(5);
                this.mWindowManager.executeAppTransition();
                throw new IllegalArgumentException("startActivityFromRecentsInner: Task " + taskId + " not found.");
            }
            ActivityStack focusedStack = this.getFocusedStack();
            ActivityRecord activityRecord = sourceRecord = focusedStack != null ? focusedStack.topActivity() : null;
            if (launchStackId != -1 && task.getStackId() != launchStackId) {
                task.reparent(launchStackId, true, 0, true, true, "startActivityFromRecents");
            }
            if (!this.mService.mUserController.shouldConfirmCredentials(task.userId) && task.getRootActivity() != null) {
                this.mService.mActivityStarter.sendPowerHintForLaunchStartIfNeeded(true);
                this.mActivityMetricsLogger.notifyActivityLaunching();
                this.mService.moveTaskToFrontLocked(task.taskId, 0, bOptions, true);
                this.mActivityMetricsLogger.notifyActivityLaunched(2, task.getTopActivity());
                if (launchStackId == 3) {
                    this.setResizingDuringAnimation(task);
                }
                this.mService.mActivityStarter.postStartActivityProcessing(task.getTopActivity(), 2, sourceRecord != null ? sourceRecord.getTask().getStackId() : -1, sourceRecord, task.getStack());
                int n2 = 2;
                return n2;
            }
            int callingUid = task.mCallingUid;
            String callingPackage = task.mCallingPackage;
            Intent intent = task.intent;
            intent.addFlags(0x100000);
            int userId = task.userId;
            int result = this.mService.startActivityInPackage(callingUid, callingPackage, intent, null, null, null, 0, 0, bOptions, userId, null, task, "startActivityFromRecents");
            if (launchStackId == 3) {
                this.setResizingDuringAnimation(task);
            }
            int n3 = result;
            return n3;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    List<IBinder> getTopVisibleActivities() {
        ArrayList<IBinder> topActivityTokens = new ArrayList<IBinder>();
        for (int i = this.mActivityDisplays.size() - 1; i >= 0; --i) {
            ActivityDisplay display = this.mActivityDisplays.valueAt(i);
            for (int j = display.mStacks.size() - 1; j >= 0; --j) {
                ActivityRecord top;
                ActivityStack stack = display.mStacks.get(j);
                if (stack.shouldBeVisible(null) != 1 || (top = stack.topActivity()) == null) continue;
                if (stack == this.mFocusedStack) {
                    topActivityTokens.add(0, top.appToken);
                    continue;
                }
                topActivityTokens.add(top.appToken);
            }
        }
        return topActivityTokens;
    }

    static {
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.IMAGE_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.VIDEO_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.intent.action.CALL", "android.permission.CALL_PHONE");
    }

    static class WaitInfo {
        private final ComponentName mTargetComponent;
        private final WaitResult mResult;

        public WaitInfo(ComponentName targetComponent, WaitResult result) {
            this.mTargetComponent = targetComponent;
            this.mResult = result;
        }

        public boolean matches(ComponentName targetComponent) {
            return this.mTargetComponent == null || this.mTargetComponent.equals(targetComponent);
        }

        public WaitResult getResult() {
            return this.mResult;
        }

        public ComponentName getComponent() {
            return this.mTargetComponent;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "WaitInfo:");
            pw.println(prefix + "  mTargetComponent=" + this.mTargetComponent);
            pw.println(prefix + "  mResult=");
            this.mResult.dump(pw, prefix);
        }
    }

    class VirtualActivityDisplay
    extends ActivityDisplay {
        VirtualDisplay mVirtualDisplay;

        VirtualActivityDisplay(int width, int height, int density) {
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            this.mVirtualDisplay = dm.createVirtualDisplay(ActivityStackSupervisor.this.mService.mContext, null, ActivityStackSupervisor.VIRTUAL_DISPLAY_BASE_NAME, width, height, density, null, 9, null, null, null);
            this.init(this.mVirtualDisplay.getDisplay());
            ActivityStackSupervisor.this.mWindowManager.onDisplayAdded(this.mDisplayId);
        }

        void setSurface(Surface surface) {
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.setSurface(surface);
            }
        }

        @Override
        void detachStack(ActivityStack stack) {
            super.detachStack(stack);
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.release();
                this.mVirtualDisplay = null;
            }
        }

        @Override
        public String toString() {
            return "VirtualActivityDisplay={" + this.mDisplayId + "}";
        }
    }

    class ActivityDisplay
    extends ConfigurationContainer {
        int mDisplayId;
        Display mDisplay;
        final ArrayList<ActivityStack> mStacks = new ArrayList();
        ActivityRecord mVisibleBehindActivity;
        private IntArray mDisplayAccessUIDs = new IntArray();

        ActivityDisplay() {
        }

        ActivityDisplay(int displayId) {
            Display display = ActivityStackSupervisor.this.mDisplayManager.getDisplay(displayId);
            if (display == null) {
                return;
            }
            this.init(display);
        }

        void init(Display display) {
            this.mDisplay = display;
            this.mDisplayId = display.getDisplayId();
        }

        void attachStack(ActivityStack stack, int position) {
            this.mStacks.add(position, stack);
        }

        void detachStack(ActivityStack stack) {
            this.mStacks.remove(stack);
        }

        void setVisibleBehindActivity(ActivityRecord r) {
            this.mVisibleBehindActivity = r;
        }

        boolean hasVisibleBehindActivity() {
            return this.mVisibleBehindActivity != null;
        }

        public String toString() {
            return "ActivityDisplay={" + this.mDisplayId + " numStacks=" + this.mStacks.size() + "}";
        }

        @Override
        protected int getChildCount() {
            return this.mStacks.size();
        }

        protected ConfigurationContainer getChildAt(int index) {
            return this.mStacks.get(index);
        }

        @Override
        protected ConfigurationContainer getParent() {
            return ActivityStackSupervisor.this;
        }

        boolean isPrivate() {
            return (this.mDisplay.getFlags() & 4) != 0;
        }

        boolean isUidPresent(int uid) {
            for (ActivityStack stack : this.mStacks) {
                if (!stack.isUidPresent(uid)) continue;
                return true;
            }
            return false;
        }

        private IntArray getPresentUIDs() {
            this.mDisplayAccessUIDs.clear();
            for (ActivityStack stack : this.mStacks) {
                stack.getPresentUIDs(this.mDisplayAccessUIDs);
            }
            return this.mDisplayAccessUIDs;
        }

        boolean shouldDestroyContentOnRemove() {
            return this.mDisplay.getRemoveMode() == 1;
        }
    }

    private class VirtualActivityContainer
    extends ActivityContainer {
        Surface mSurface;
        boolean mDrawn;

        VirtualActivityContainer(ActivityRecord parent, IActivityContainerCallback callback) {
            super(ActivityStackSupervisor.this.getNextStackId(), ((ActivityStack)parent.getStack()).mActivityContainer.mActivityDisplay, true);
            this.mDrawn = false;
            this.mParentActivity = parent;
            this.mCallback = callback;
            this.mContainerState = 1;
            this.mIdString = "VirtualActivityContainer{" + this.mStackId + ", parent=" + this.mParentActivity + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSurface(Surface surface, int width, int height, int density) {
            super.setSurface(surface, width, height, density);
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                long origId = Binder.clearCallingIdentity();
                try {
                    this.setSurfaceLocked(surface, width, height, density);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }

        private void setSurfaceLocked(Surface surface, int width, int height, int density) {
            if (this.mContainerState == 2) {
                return;
            }
            VirtualActivityDisplay virtualActivityDisplay = (VirtualActivityDisplay)this.mActivityDisplay;
            if (virtualActivityDisplay == null) {
                virtualActivityDisplay = new VirtualActivityDisplay(width, height, density);
                this.mActivityDisplay = virtualActivityDisplay;
                ActivityStackSupervisor.this.mActivityDisplays.put(virtualActivityDisplay.mDisplayId, virtualActivityDisplay);
                this.addToDisplayLocked(virtualActivityDisplay);
            }
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
            if (surface != null) {
                ActivityStackSupervisor.this.resumeFocusedStackTopActivityLocked();
            } else {
                this.mContainerState = 1;
                ((VirtualActivityDisplay)this.mActivityDisplay).setSurface(null);
                if (this.mStack.mPausingActivity == null && this.mStack.mResumedActivity != null) {
                    this.mStack.startPausingLocked(false, true, null, false);
                }
            }
            this.setSurfaceIfReadyLocked();
        }

        @Override
        boolean isAttachedLocked() {
            return this.mSurface != null && super.isAttachedLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setDrawn() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                this.mDrawn = true;
                this.setSurfaceIfReadyLocked();
            }
        }

        @Override
        boolean isEligibleForNewTasks() {
            return false;
        }

        private void setSurfaceIfReadyLocked() {
            if (this.mDrawn && this.mSurface != null && this.mContainerState == 1) {
                ((VirtualActivityDisplay)this.mActivityDisplay).setSurface(this.mSurface);
                this.mContainerState = 0;
            }
        }
    }

    class ActivityContainer
    extends IActivityContainer.Stub {
        static final int FORCE_NEW_TASK_FLAGS = 0x18010000;
        final int mStackId;
        IActivityContainerCallback mCallback = null;
        ActivityStack mStack;
        ActivityRecord mParentActivity = null;
        String mIdString;
        boolean mVisible = true;
        ActivityDisplay mActivityDisplay;
        static final int CONTAINER_STATE_HAS_SURFACE = 0;
        static final int CONTAINER_STATE_NO_SURFACE = 1;
        static final int CONTAINER_STATE_FINISHING = 2;
        int mContainerState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ActivityContainer(int stackId, ActivityDisplay activityDisplay, boolean onTop) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                this.mStackId = stackId;
                this.mActivityDisplay = activityDisplay;
                this.mIdString = "ActivtyContainer{" + this.mStackId + "}";
                this.createStack(stackId, onTop);
            }
        }

        protected void createStack(int stackId, boolean onTop) {
            switch (stackId) {
                case 4: {
                    new PinnedActivityStack(this, ActivityStackSupervisor.this.mRecentTasks, onTop);
                    break;
                }
                default: {
                    new ActivityStack(this, ActivityStackSupervisor.this.mRecentTasks, onTop);
                }
            }
        }

        void addToDisplayLocked(ActivityDisplay activityDisplay) {
            if (this.mActivityDisplay != null) {
                throw new IllegalStateException("ActivityContainer is already attached, displayId=" + this.mActivityDisplay.mDisplayId);
            }
            this.mActivityDisplay = activityDisplay;
            this.mStack.reparent(activityDisplay, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addToDisplay(int displayId) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                ActivityDisplay activityDisplay = ActivityStackSupervisor.this.getActivityDisplayOrCreateLocked(displayId);
                if (activityDisplay == null) {
                    return;
                }
                this.addToDisplayLocked(activityDisplay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDisplayId() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                if (this.mActivityDisplay != null) {
                    return this.mActivityDisplay.mDisplayId;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getStackId() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                return this.mStackId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean injectEvent(InputEvent event) {
            long origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                synchronized (activityManagerService) {
                    if (this.mActivityDisplay != null) {
                        boolean bl = ActivityStackSupervisor.this.mInputManagerInternal.injectInputEvent(event, this.mActivityDisplay.mDisplayId, 0);
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                if (this.mContainerState == 2) {
                    return;
                }
                this.mContainerState = 2;
                long origId = Binder.clearCallingIdentity();
                try {
                    this.mStack.finishAllActivitiesLocked(false);
                    ActivityStackSupervisor.this.mService.mActivityStarter.removePendingActivityLaunchesLocked(this.mStack);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }

        void removeLocked() {
            if (this.mActivityDisplay != null) {
                this.removeFromDisplayLocked();
            }
            this.mStack.remove();
        }

        private void removeFromDisplayLocked() {
            this.mActivityDisplay.detachStack(this.mStack);
            this.mActivityDisplay = null;
        }

        void moveToDisplayLocked(ActivityDisplay activityDisplay, boolean onTop) {
            this.removeFromDisplayLocked();
            this.mActivityDisplay = activityDisplay;
            this.mStack.reparent(activityDisplay, onTop);
        }

        @Override
        public final int startActivity(Intent intent) {
            return ActivityStackSupervisor.this.mService.startActivity(intent, this);
        }

        @Override
        public final int startActivityIntentSender(IIntentSender intentSender) throws TransactionTooLargeException {
            ActivityStackSupervisor.this.mService.enforceNotIsolatedCaller("ActivityContainer.startActivityIntentSender");
            if (!(intentSender instanceof PendingIntentRecord)) {
                throw new IllegalArgumentException("Bad PendingIntent object");
            }
            int userId = ActivityStackSupervisor.this.mService.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), ActivityStackSupervisor.this.mCurrentUser, false, 2, "ActivityContainer", null);
            PendingIntentRecord pendingIntent = (PendingIntentRecord)intentSender;
            this.checkEmbeddedAllowedInner(userId, pendingIntent.key.requestIntent, pendingIntent.key.requestResolvedType);
            return pendingIntent.sendInner(0, null, null, null, null, null, null, null, 0, 0x18010000, 0x18010000, null, this);
        }

        void checkEmbeddedAllowedInner(int userId, Intent intent, String resolvedType) {
            ActivityInfo aInfo = ActivityStackSupervisor.this.resolveActivity(intent, resolvedType, 0, null, userId);
            if (aInfo != null && (aInfo.flags & Integer.MIN_VALUE) == 0) {
                throw new SecurityException("Attempt to embed activity that has not set allowEmbedded=\"true\"");
            }
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public void setSurface(Surface surface, int width, int height, int density) {
            ActivityStackSupervisor.this.mService.enforceNotIsolatedCaller("ActivityContainer.attachToSurface");
        }

        ActivityStackSupervisor getOuter() {
            return ActivityStackSupervisor.this;
        }

        boolean isAttachedLocked() {
            return this.mActivityDisplay != null;
        }

        void setVisible(boolean visible) {
            if (this.mVisible != visible) {
                this.mVisible = visible;
                if (this.mCallback != null) {
                    ActivityStackSupervisor.this.mHandler.obtainMessage(108, visible ? 1 : 0, 0, this).sendToTarget();
                }
            }
        }

        void setDrawn() {
        }

        boolean isEligibleForNewTasks() {
            return true;
        }

        void onTaskListEmptyLocked() {
            this.removeLocked();
            ActivityStackSupervisor.this.mHandler.obtainMessage(111, this).sendToTarget();
        }

        public String toString() {
            return this.mIdString + (this.mActivityDisplay == null ? "N" : "A");
        }
    }

    private final class ActivityStackSupervisorHandler
    extends Handler {
        public ActivityStackSupervisorHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activityIdleInternal(ActivityRecord r, boolean processPausingActivities) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                ActivityStackSupervisor.this.activityIdleInternalLocked(r != null ? r.appToken : null, true, processPausingActivities, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 114: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        for (int i = ActivityStackSupervisor.this.mMultiWindowModeChangedActivities.size() - 1; i >= 0; --i) {
                            ActivityRecord r = ActivityStackSupervisor.this.mMultiWindowModeChangedActivities.remove(i);
                            r.updateMultiWindowMode();
                        }
                        break;
                    }
                }
                case 115: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        for (int i = ActivityStackSupervisor.this.mPipModeChangedActivities.size() - 1; i >= 0; --i) {
                            ActivityRecord r = ActivityStackSupervisor.this.mPipModeChangedActivities.remove(i);
                            r.updatePictureInPictureMode(ActivityStackSupervisor.this.mPipModeChangedTargetStackBounds);
                        }
                        break;
                    }
                }
                case 100: {
                    if (ActivityStackSupervisor.this.mService.mDidDexOpt) {
                        ActivityStackSupervisor.this.mService.mDidDexOpt = false;
                        Message nmsg = ActivityStackSupervisor.this.mHandler.obtainMessage(100);
                        nmsg.obj = msg.obj;
                        ActivityStackSupervisor.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    this.activityIdleInternal((ActivityRecord)msg.obj, true);
                    break;
                }
                case 101: {
                    this.activityIdleInternal((ActivityRecord)msg.obj, false);
                    break;
                }
                case 102: {
                    ActivityManagerService nmsg = ActivityStackSupervisor.this.mService;
                    synchronized (nmsg) {
                        ActivityStackSupervisor.this.resumeFocusedStackTopActivityLocked();
                        break;
                    }
                }
                case 103: {
                    ActivityManagerService nmsg = ActivityStackSupervisor.this.mService;
                    synchronized (nmsg) {
                        if (ActivityStackSupervisor.this.mService.isSleepingOrShuttingDownLocked()) {
                            Slog.w("ActivityManager", "Sleep timeout!  Sleeping now.");
                            ActivityStackSupervisor.this.mSleepTimeout = true;
                            ActivityStackSupervisor.this.checkReadyForSleepLocked();
                        }
                        break;
                    }
                }
                case 104: {
                    if (ActivityStackSupervisor.this.mService.mDidDexOpt) {
                        ActivityStackSupervisor.this.mService.mDidDexOpt = false;
                        ActivityStackSupervisor.this.mHandler.sendEmptyMessageDelayed(104, 10000L);
                        return;
                    }
                    ActivityManagerService nmsg = ActivityStackSupervisor.this.mService;
                    synchronized (nmsg) {
                        if (ActivityStackSupervisor.this.mLaunchingActivity.isHeld()) {
                            Slog.w("ActivityManager", "Launch timeout has expired, giving up wake lock!");
                            ActivityStackSupervisor.this.mLaunchingActivity.release();
                        }
                        break;
                    }
                }
                case 105: {
                    ActivityStackSupervisor.this.handleDisplayAdded(msg.arg1);
                    break;
                }
                case 106: {
                    ActivityStackSupervisor.this.handleDisplayChanged(msg.arg1);
                    break;
                }
                case 107: {
                    ActivityStackSupervisor.this.handleDisplayRemoved(msg.arg1);
                    break;
                }
                case 108: {
                    ActivityContainer container = (ActivityContainer)msg.obj;
                    IActivityContainerCallback callback = container.mCallback;
                    if (callback == null) break;
                    try {
                        callback.setVisible(container.asBinder(), msg.arg1 == 1);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 109: {
                    try {
                        if (ActivityStackSupervisor.this.mLockTaskNotify == null) {
                            ActivityStackSupervisor.this.mLockTaskNotify = new LockTaskNotify(ActivityStackSupervisor.this.mService.mContext);
                        }
                        ActivityStackSupervisor.this.mLockTaskNotify.show(true);
                        ActivityStackSupervisor.this.mLockTaskModeState = msg.arg2;
                        if (ActivityStackSupervisor.this.getStatusBarService() != null) {
                            int flags = 0;
                            if (ActivityStackSupervisor.this.mLockTaskModeState == 1) {
                                flags = 62849024;
                            } else if (ActivityStackSupervisor.this.mLockTaskModeState == 2) {
                                flags = 43974656;
                            }
                            ActivityStackSupervisor.this.getStatusBarService().disable(flags, ActivityStackSupervisor.this.mToken, ActivityStackSupervisor.this.mService.mContext.getPackageName());
                        }
                        ActivityStackSupervisor.this.mWindowManager.disableKeyguard(ActivityStackSupervisor.this.mToken, ActivityStackSupervisor.LOCK_TASK_TAG);
                        if (ActivityStackSupervisor.this.getDevicePolicyManager() == null) break;
                        ActivityStackSupervisor.this.getDevicePolicyManager().notifyLockTaskModeChanged(true, (String)msg.obj, msg.arg1);
                        break;
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                case 110: {
                    try {
                        if (ActivityStackSupervisor.this.getStatusBarService() != null) {
                            ActivityStackSupervisor.this.getStatusBarService().disable(0, ActivityStackSupervisor.this.mToken, ActivityStackSupervisor.this.mService.mContext.getPackageName());
                        }
                        ActivityStackSupervisor.this.mWindowManager.reenableKeyguard(ActivityStackSupervisor.this.mToken);
                        if (ActivityStackSupervisor.this.getDevicePolicyManager() != null) {
                            ActivityStackSupervisor.this.getDevicePolicyManager().notifyLockTaskModeChanged(false, null, msg.arg1);
                        }
                        if (ActivityStackSupervisor.this.mLockTaskNotify == null) {
                            ActivityStackSupervisor.this.mLockTaskNotify = new LockTaskNotify(ActivityStackSupervisor.this.mService.mContext);
                        }
                        ActivityStackSupervisor.this.mLockTaskNotify.show(false);
                        try {
                            boolean shouldLockKeyguard;
                            boolean bl = shouldLockKeyguard = Settings.Secure.getInt(ActivityStackSupervisor.this.mService.mContext.getContentResolver(), "lock_to_app_exit_locked") != 0;
                            if (ActivityStackSupervisor.this.mLockTaskModeState != 2 || !shouldLockKeyguard) break;
                            ActivityStackSupervisor.this.mWindowManager.lockNow(null);
                            ActivityStackSupervisor.this.mWindowManager.dismissKeyguard(null);
                            new LockPatternUtils(ActivityStackSupervisor.this.mService.mContext).requireCredentialEntry(-1);
                        }
                        catch (Settings.SettingNotFoundException shouldLockKeyguard) {
                            // empty catch block
                        }
                        break;
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        ActivityStackSupervisor.this.mLockTaskModeState = 0;
                    }
                }
                case 113: {
                    if (ActivityStackSupervisor.this.mLockTaskNotify == null) {
                        ActivityStackSupervisor.this.mLockTaskNotify = new LockTaskNotify(ActivityStackSupervisor.this.mService.mContext);
                    }
                    ActivityStackSupervisor.this.mLockTaskNotify.showToast(2);
                    break;
                }
                case 111: {
                    ActivityContainer container = (ActivityContainer)msg.obj;
                    IActivityContainerCallback callback = container.mCallback;
                    if (callback == null) break;
                    try {
                        callback.onAllActivitiesComplete(container.asBinder());
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 112: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        ActivityRecord r = ActivityRecord.forTokenLocked((IBinder)msg.obj);
                        if (r != null) {
                            ActivityStackSupervisor.this.handleLaunchTaskBehindCompleteLocked(r);
                        }
                        break;
                    }
                }
            }
        }
    }

    static class PendingActivityLaunch {
        final ActivityRecord r;
        final ActivityRecord sourceRecord;
        final int startFlags;
        final ActivityStack stack;
        final ProcessRecord callerApp;

        PendingActivityLaunch(ActivityRecord _r, ActivityRecord _sourceRecord, int _startFlags, ActivityStack _stack, ProcessRecord _callerApp) {
            this.r = _r;
            this.sourceRecord = _sourceRecord;
            this.startFlags = _startFlags;
            this.stack = _stack;
            this.callerApp = _callerApp;
        }

        void sendErrorResult(String message) {
            try {
                if (this.callerApp.thread != null) {
                    this.callerApp.thread.scheduleCrash(message);
                }
            }
            catch (RemoteException e) {
                Slog.e("ActivityManager", "Exception scheduling crash of failed activity launcher sourceRecord=" + this.sourceRecord, e);
            }
        }
    }

    static class FindTaskResult {
        ActivityRecord r;
        boolean matchedByRootAffinity;

        FindTaskResult() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface AnyTaskForIdMatchTaskMode {
    }
}

