/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityContainer;
import android.app.IApplicationThread;
import android.app.ProfilerInfo;
import android.app.WaitResult;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.AuxiliaryResolveInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.voice.IVoiceInteractionSession;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.app.HeavyWeightSwitcherActivity;
import com.android.internal.app.IVoiceInteractor;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ActivityStartInterceptor;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import com.android.server.pm.InstantAppResolver;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

class ActivityStarter {
    private static final String TAG = "ActivityManager";
    private static final String TAG_RESULTS = "ActivityManager";
    private static final String TAG_FOCUS = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_USER_LEAVING = "ActivityManager";
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mSupervisor;
    private ActivityStartInterceptor mInterceptor;
    private WindowManagerService mWindowManager;
    final ArrayList<ActivityStackSupervisor.PendingActivityLaunch> mPendingActivityLaunches = new ArrayList();
    private ActivityRecord mStartActivity;
    private Intent mIntent;
    private int mCallingUid;
    private ActivityOptions mOptions;
    private boolean mLaunchSingleTop;
    private boolean mLaunchSingleInstance;
    private boolean mLaunchSingleTask;
    private boolean mLaunchTaskBehind;
    private int mLaunchFlags;
    private Rect mLaunchBounds;
    private ActivityRecord mNotTop;
    private boolean mDoResume;
    private int mStartFlags;
    private ActivityRecord mSourceRecord;
    private int mSourceDisplayId;
    private TaskRecord mInTask;
    private boolean mAddingToTask;
    private TaskRecord mReuseTask;
    private ActivityInfo mNewTaskInfo;
    private Intent mNewTaskIntent;
    private ActivityStack mSourceStack;
    private ActivityStack mTargetStack;
    private boolean mMovedOtherTask;
    private boolean mMovedToFront;
    private boolean mNoAnimation;
    private boolean mKeepCurTransition;
    private boolean mAvoidMoveToFront;
    private boolean mPowerHintSent;
    private IVoiceInteractionSession mVoiceSession;
    private IVoiceInteractor mVoiceInteractor;
    private boolean mUsingVr2dDisplay;
    private final ActivityRecord[] mLastHomeActivityStartRecord = new ActivityRecord[1];
    private int mLastHomeActivityStartResult;
    private final ActivityRecord[] mLastStartActivityRecord = new ActivityRecord[1];
    private int mLastStartActivityResult;
    private long mLastStartActivityTimeMs;
    private String mLastStartReason;

    private void reset() {
        this.mStartActivity = null;
        this.mIntent = null;
        this.mCallingUid = -1;
        this.mOptions = null;
        this.mLaunchSingleTop = false;
        this.mLaunchSingleInstance = false;
        this.mLaunchSingleTask = false;
        this.mLaunchTaskBehind = false;
        this.mLaunchFlags = 0;
        this.mLaunchBounds = null;
        this.mNotTop = null;
        this.mDoResume = false;
        this.mStartFlags = 0;
        this.mSourceRecord = null;
        this.mSourceDisplayId = -1;
        this.mInTask = null;
        this.mAddingToTask = false;
        this.mReuseTask = null;
        this.mNewTaskInfo = null;
        this.mNewTaskIntent = null;
        this.mSourceStack = null;
        this.mTargetStack = null;
        this.mMovedOtherTask = false;
        this.mMovedToFront = false;
        this.mNoAnimation = false;
        this.mKeepCurTransition = false;
        this.mAvoidMoveToFront = false;
        this.mVoiceSession = null;
        this.mVoiceInteractor = null;
        this.mUsingVr2dDisplay = false;
    }

    ActivityStarter(ActivityManagerService service, ActivityStackSupervisor supervisor) {
        this.mService = service;
        this.mSupervisor = supervisor;
        this.mInterceptor = new ActivityStartInterceptor(this.mService, this.mSupervisor);
        this.mUsingVr2dDisplay = false;
    }

    int startActivityLocked(IApplicationThread caller, Intent intent, Intent ephemeralIntent, String resolvedType, ActivityInfo aInfo, ResolveInfo rInfo, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, int realCallingPid, int realCallingUid, int startFlags, ActivityOptions options, boolean ignoreTargetSecurity, boolean componentSpecified, ActivityRecord[] outActivity, ActivityStackSupervisor.ActivityContainer container, TaskRecord inTask, String reason) {
        if (TextUtils.isEmpty(reason)) {
            throw new IllegalArgumentException("Need to specify a reason.");
        }
        this.mLastStartReason = reason;
        this.mLastStartActivityTimeMs = System.currentTimeMillis();
        this.mLastStartActivityRecord[0] = null;
        this.mLastStartActivityResult = this.startActivity(caller, intent, ephemeralIntent, resolvedType, aInfo, rInfo, voiceSession, voiceInteractor, resultTo, resultWho, requestCode, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, startFlags, options, ignoreTargetSecurity, componentSpecified, this.mLastStartActivityRecord, container, inTask);
        if (outActivity != null) {
            outActivity[0] = this.mLastStartActivityRecord[0];
        }
        return this.mLastStartActivityResult;
    }

    private int startActivity(IApplicationThread caller, Intent intent, Intent ephemeralIntent, String resolvedType, ActivityInfo aInfo, ResolveInfo rInfo, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, int realCallingPid, int realCallingUid, int startFlags, ActivityOptions options, boolean ignoreTargetSecurity, boolean componentSpecified, ActivityRecord[] outActivity, ActivityStackSupervisor.ActivityContainer container, TaskRecord inTask) {
        ActivityStack resultStack;
        int launchFlags;
        int userId;
        int err = 0;
        Bundle verificationBundle = options != null ? options.popAppVerificationBundle() : null;
        ProcessRecord callerApp = null;
        if (caller != null) {
            callerApp = this.mService.getRecordForAppLocked(caller);
            if (callerApp != null) {
                callingPid = callerApp.pid;
                callingUid = callerApp.info.uid;
            } else {
                Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                err = -94;
            }
        }
        int n = userId = aInfo != null ? UserHandle.getUserId(aInfo.applicationInfo.uid) : 0;
        if (err == 0) {
            Slog.i("ActivityManager", "START u" + userId + " {" + intent.toShortString(true, true, true, false) + "} from uid " + callingUid);
        }
        ActivityRecord sourceRecord = null;
        ActivityRecord resultRecord = null;
        if (resultTo != null && (sourceRecord = this.mSupervisor.isInAnyStackLocked(resultTo)) != null && requestCode >= 0 && !sourceRecord.finishing) {
            resultRecord = sourceRecord;
        }
        if (((launchFlags = intent.getFlags()) & 0x2000000) != 0 && sourceRecord != null) {
            if (requestCode >= 0) {
                ActivityOptions.abort(options);
                return -93;
            }
            resultRecord = sourceRecord.resultTo;
            if (resultRecord != null && !resultRecord.isInStackLocked()) {
                resultRecord = null;
            }
            resultWho = sourceRecord.resultWho;
            requestCode = sourceRecord.requestCode;
            sourceRecord.resultTo = null;
            if (resultRecord != null) {
                resultRecord.removeResultsLocked(sourceRecord, resultWho, requestCode);
            }
            if (sourceRecord.launchedFromUid == callingUid) {
                callingPackage = sourceRecord.launchedFromPackage;
            }
        }
        if (err == 0 && intent.getComponent() == null) {
            err = -91;
        }
        if (err == 0 && aInfo == null) {
            err = -92;
        }
        if (err == 0 && sourceRecord != null && sourceRecord.getTask().voiceSession != null && (launchFlags & 0x10000000) == 0 && sourceRecord.info.applicationInfo.uid != aInfo.applicationInfo.uid) {
            try {
                intent.addCategory("android.intent.category.VOICE");
                if (!AppGlobals.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityManager", "Activity being started in current voice task does not support voice: " + intent);
                    err = -97;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Failure checking voice capabilities", e);
                err = -97;
            }
        }
        if (err == 0 && voiceSession != null) {
            try {
                if (!AppGlobals.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityManager", "Activity being started in new voice task does not support: " + intent);
                    err = -97;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Failure checking voice capabilities", e);
                err = -97;
            }
        }
        ActivityStack activityStack = resultStack = resultRecord == null ? null : (ActivityStack)resultRecord.getStack();
        if (err != 0) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            return err;
        }
        boolean abort = !this.mSupervisor.checkStartAnyActivityPermission(intent, aInfo, resultWho, requestCode, callingPid, callingUid, callingPackage, ignoreTargetSecurity, callerApp, resultRecord, resultStack, options);
        abort |= !this.mService.mIntentFirewall.checkStartActivity(intent, callingUid, callingPid, resolvedType, aInfo.applicationInfo);
        if (this.mService.mController != null) {
            try {
                Intent watchIntent = intent.cloneFilter();
                abort |= !this.mService.mController.activityStarting(watchIntent, aInfo.applicationInfo.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
            }
        }
        this.mInterceptor.setStates(userId, realCallingPid, realCallingUid, startFlags, callingPackage);
        this.mInterceptor.intercept(intent, rInfo, aInfo, resolvedType, inTask, callingPid, callingUid, options);
        intent = this.mInterceptor.mIntent;
        rInfo = this.mInterceptor.mRInfo;
        aInfo = this.mInterceptor.mAInfo;
        resolvedType = this.mInterceptor.mResolvedType;
        inTask = this.mInterceptor.mInTask;
        callingPid = this.mInterceptor.mCallingPid;
        callingUid = this.mInterceptor.mCallingUid;
        options = this.mInterceptor.mActivityOptions;
        if (abort) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            return 0;
        }
        if (this.mService.mPermissionReviewRequired && aInfo != null && this.mService.getPackageManagerInternalLocked().isPermissionsReviewRequired(aInfo.packageName, userId)) {
            IIntentSender target = this.mService.getIntentSenderLocked(2, callingPackage, callingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
            int flags = intent.getFlags();
            Intent newIntent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            newIntent.setFlags(flags | 0x800000);
            newIntent.putExtra("android.intent.extra.PACKAGE_NAME", aInfo.packageName);
            newIntent.putExtra("android.intent.extra.INTENT", new IntentSender(target));
            if (resultRecord != null) {
                newIntent.putExtra("android.intent.extra.RESULT_NEEDED", true);
            }
            intent = newIntent;
            resolvedType = null;
            callingUid = realCallingUid;
            callingPid = realCallingPid;
            rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId);
            aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, null);
        }
        if (rInfo != null && rInfo.auxiliaryInfo != null) {
            intent = this.createLaunchIntent(rInfo.auxiliaryInfo, ephemeralIntent, callingPackage, verificationBundle, resolvedType, userId);
            resolvedType = null;
            callingUid = realCallingUid;
            callingPid = realCallingPid;
            aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, null);
        }
        ActivityRecord r = new ActivityRecord(this.mService, callerApp, callingPid, callingUid, callingPackage, intent, resolvedType, aInfo, this.mService.getGlobalConfiguration(), resultRecord, resultWho, requestCode, componentSpecified, voiceSession != null, this.mSupervisor, container, options, sourceRecord);
        if (outActivity != null) {
            outActivity[0] = r;
        }
        if (r.appTimeTracker == null && sourceRecord != null) {
            r.appTimeTracker = sourceRecord.appTimeTracker;
        }
        ActivityStack stack = this.mSupervisor.mFocusedStack;
        if (!(voiceSession != null || stack.mResumedActivity != null && stack.mResumedActivity.info.applicationInfo.uid == callingUid || this.mService.checkAppSwitchAllowedLocked(callingPid, callingUid, realCallingPid, realCallingUid, "Activity start"))) {
            ActivityStackSupervisor.PendingActivityLaunch pal = new ActivityStackSupervisor.PendingActivityLaunch(r, sourceRecord, startFlags, stack, callerApp);
            this.mPendingActivityLaunches.add(pal);
            ActivityOptions.abort(options);
            return 100;
        }
        if (this.mService.mDidAppSwitch) {
            this.mService.mAppSwitchesAllowedTime = 0L;
        } else {
            this.mService.mDidAppSwitch = true;
        }
        this.doPendingActivityLaunchesLocked(false);
        return this.startActivity(r, sourceRecord, voiceSession, voiceInteractor, startFlags, true, options, inTask, outActivity);
    }

    private Intent createLaunchIntent(AuxiliaryResolveInfo auxiliaryResponse, Intent originalIntent, String callingPackage, Bundle verificationBundle, String resolvedType, int userId) {
        if (auxiliaryResponse.needsPhaseTwo) {
            this.mService.getPackageManagerInternalLocked().requestInstantAppResolutionPhaseTwo(auxiliaryResponse, originalIntent, resolvedType, callingPackage, verificationBundle, userId);
        }
        return InstantAppResolver.buildEphemeralInstallerIntent("android.intent.action.INSTALL_INSTANT_APP_PACKAGE", originalIntent, auxiliaryResponse.failureIntent, callingPackage, verificationBundle, resolvedType, userId, auxiliaryResponse.packageName, auxiliaryResponse.splitName, auxiliaryResponse.versionCode, auxiliaryResponse.token, auxiliaryResponse.needsPhaseTwo);
    }

    void postStartActivityProcessing(ActivityRecord r, int result, int prevFocusedStackId, ActivityRecord sourceRecord, ActivityStack targetStack) {
        boolean clearedTask;
        if (ActivityManager.isStartResultFatalError(result)) {
            return;
        }
        if (result == 2 && !this.mSupervisor.mWaitingActivityLaunched.isEmpty()) {
            this.mSupervisor.reportTaskToFrontNoLaunch(this.mStartActivity);
        }
        int startedActivityStackId = -1;
        Object currentStack = r.getStack();
        if (currentStack != null) {
            startedActivityStackId = ((ActivityStack)currentStack).mStackId;
        } else if (this.mTargetStack != null) {
            startedActivityStackId = targetStack.mStackId;
        }
        if (startedActivityStackId == 3) {
            boolean homeStackVisible;
            Object homeStack = this.mSupervisor.getStack(0);
            boolean bl = homeStackVisible = homeStack != null && ((ActivityStack)homeStack).isVisible();
            if (homeStackVisible) {
                this.mWindowManager.showRecentApps(true);
            }
            return;
        }
        boolean bl = clearedTask = (this.mLaunchFlags & 0x10008000) == 0x10008000 && this.mReuseTask != null;
        if (startedActivityStackId == 4 && (result == 2 || result == 3 || clearedTask)) {
            this.mService.mTaskChangeNotificationController.notifyPinnedActivityRestartAttempt(clearedTask);
            return;
        }
    }

    void startHomeActivityLocked(Intent intent, ActivityInfo aInfo, String reason) {
        this.mSupervisor.moveHomeStackTaskToTop(reason);
        this.mLastHomeActivityStartResult = this.startActivityLocked(null, intent, null, null, aInfo, null, null, null, null, null, 0, 0, 0, null, 0, 0, 0, null, false, false, this.mLastHomeActivityStartRecord, null, null, "startHomeActivity: " + reason);
        if (this.mSupervisor.inResumeTopActivity) {
            this.mSupervisor.scheduleResumeTopActivities();
        }
    }

    void startConfirmCredentialIntent(Intent intent, Bundle optionsBundle) {
        intent.addFlags(276840448);
        ActivityOptions options = optionsBundle != null ? new ActivityOptions(optionsBundle) : ActivityOptions.makeBasic();
        options.setLaunchTaskId(this.mSupervisor.getHomeActivity().getTask().taskId);
        this.mService.mContext.startActivityAsUser(intent, options.toBundle(), UserHandle.CURRENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityMayWait(IApplicationThread caller, int callingUid, String callingPackage, Intent intent, String resolvedType, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, WaitResult outResult, Configuration globalConfig, Bundle bOptions, boolean ignoreTargetSecurity, int userId, IActivityContainer iContainer, TaskRecord inTask, String reason) {
        UserInfo userInfo;
        ResolveInfo rInfo;
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        this.mSupervisor.mActivityMetricsLogger.notifyActivityLaunching();
        boolean componentSpecified = intent.getComponent() != null;
        Intent ephemeralIntent = new Intent(intent);
        intent = new Intent(intent);
        if (componentSpecified && intent.getData() != null && "android.intent.action.VIEW".equals(intent.getAction()) && this.mService.getPackageManagerInternalLocked().isInstantAppInstallerComponent(intent.getComponent())) {
            intent.setComponent(null);
            componentSpecified = false;
        }
        if ((rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId)) == null && (userInfo = this.mSupervisor.getUserInfo(userId)) != null && userInfo.isManagedProfile()) {
            UserManager userManager = UserManager.get(this.mService.mContext);
            boolean profileLockedAndParentUnlockingOrUnlocked = false;
            long token = Binder.clearCallingIdentity();
            try {
                UserInfo parent = userManager.getProfileParent(userId);
                profileLockedAndParentUnlockingOrUnlocked = parent != null && userManager.isUserUnlockingOrUnlocked(parent.id) && !userManager.isUserUnlockingOrUnlocked(userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (profileLockedAndParentUnlockingOrUnlocked) {
                rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId, 786432);
            }
        }
        ActivityInfo aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, profilerInfo);
        ActivityOptions options = ActivityOptions.fromBundle(bOptions);
        ActivityStackSupervisor.ActivityContainer container = (ActivityStackSupervisor.ActivityContainer)iContainer;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            ProcessRecord heavy;
            int callingPid;
            if (container != null && container.mParentActivity != null && container.mParentActivity.state != ActivityStack.ActivityState.RESUMED) {
                return -96;
            }
            int realCallingPid = Binder.getCallingPid();
            int realCallingUid = Binder.getCallingUid();
            if (callingUid >= 0) {
                callingPid = -1;
            } else if (caller == null) {
                callingPid = realCallingPid;
                callingUid = realCallingUid;
            } else {
                callingUid = -1;
                callingPid = -1;
            }
            ActivityStack stack = container == null || container.mStack.isOnHomeDisplay() ? this.mSupervisor.mFocusedStack : container.mStack;
            stack.mConfigWillChange = globalConfig != null && this.mService.getGlobalConfiguration().diff(globalConfig) != 0;
            long origId = Binder.clearCallingIdentity();
            if (aInfo != null && (aInfo.applicationInfo.privateFlags & 2) != 0 && aInfo.processName.equals(aInfo.applicationInfo.packageName) && (heavy = this.mService.mHeavyWeightProcess) != null && (heavy.info.uid != aInfo.applicationInfo.uid || !heavy.processName.equals(aInfo.processName))) {
                int appCallingUid = callingUid;
                if (caller != null) {
                    ProcessRecord callerApp = this.mService.getRecordForAppLocked(caller);
                    if (callerApp != null) {
                        appCallingUid = callerApp.info.uid;
                    } else {
                        Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                        ActivityOptions.abort(options);
                        return -94;
                    }
                }
                IIntentSender target = this.mService.getIntentSenderLocked(2, "android", appCallingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
                Intent newIntent = new Intent();
                if (requestCode >= 0) {
                    newIntent.putExtra("has_result", true);
                }
                newIntent.putExtra("intent", new IntentSender(target));
                if (heavy.activities.size() > 0) {
                    ActivityRecord hist = heavy.activities.get(0);
                    newIntent.putExtra("cur_app", hist.packageName);
                    newIntent.putExtra("cur_task", hist.getTask().taskId);
                }
                newIntent.putExtra("new_app", aInfo.packageName);
                newIntent.setFlags(intent.getFlags());
                newIntent.setClassName("android", HeavyWeightSwitcherActivity.class.getName());
                intent = newIntent;
                resolvedType = null;
                caller = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
                componentSpecified = true;
                rInfo = this.mSupervisor.resolveIntent(intent, null, userId);
                ActivityInfo activityInfo = aInfo = rInfo != null ? rInfo.activityInfo : null;
                if (aInfo != null) {
                    aInfo = this.mService.getActivityInfoForUser(aInfo, userId);
                }
            }
            ActivityRecord[] outRecord = new ActivityRecord[1];
            int res = this.startActivityLocked(caller, intent, ephemeralIntent, resolvedType, aInfo, rInfo, voiceSession, voiceInteractor, resultTo, resultWho, requestCode, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, startFlags, options, ignoreTargetSecurity, componentSpecified, outRecord, container, inTask, reason);
            Binder.restoreCallingIdentity(origId);
            if (stack.mConfigWillChange) {
                this.mService.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
                stack.mConfigWillChange = false;
                this.mService.updateConfigurationLocked(globalConfig, null, false);
            }
            if (outResult != null) {
                outResult.result = res;
                if (res == 0) {
                    this.mSupervisor.mWaitingActivityLaunched.add(outResult);
                    do {
                        try {
                            this.mService.wait();
                        }
                        catch (InterruptedException target) {
                            // empty catch block
                        }
                    } while (outResult.result != 2 && !outResult.timeout && outResult.who == null);
                    if (outResult.result == 2) {
                        res = 2;
                    }
                }
                if (res == 2) {
                    ActivityRecord r = outRecord[0];
                    if (r.nowVisible && r.state == ActivityStack.ActivityState.RESUMED) {
                        outResult.timeout = false;
                        outResult.who = r.realActivity;
                        outResult.totalTime = 0L;
                        outResult.thisTime = 0L;
                    } else {
                        outResult.thisTime = SystemClock.uptimeMillis();
                        this.mSupervisor.waitActivityVisible(r.realActivity, outResult);
                        do {
                            try {
                                this.mService.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (!outResult.timeout && outResult.who == null);
                    }
                }
            }
            this.mSupervisor.mActivityMetricsLogger.notifyActivityLaunched(res, outRecord[0]);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivities(IApplicationThread caller, int callingUid, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle bOptions, int userId, String reason) {
        int callingPid;
        if (intents == null) {
            throw new NullPointerException("intents is null");
        }
        if (resolvedTypes == null) {
            throw new NullPointerException("resolvedTypes is null");
        }
        if (intents.length != resolvedTypes.length) {
            throw new IllegalArgumentException("intents are length different than resolvedTypes");
        }
        int realCallingPid = Binder.getCallingPid();
        int realCallingUid = Binder.getCallingUid();
        if (callingUid >= 0) {
            callingPid = -1;
        } else if (caller == null) {
            callingPid = realCallingPid;
            callingUid = realCallingUid;
        } else {
            callingUid = -1;
            callingPid = -1;
        }
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                ActivityRecord[] outActivity = new ActivityRecord[1];
                for (int i = 0; i < intents.length; ++i) {
                    Intent intent = intents[i];
                    if (intent == null) continue;
                    if (intent != null && intent.hasFileDescriptors()) {
                        throw new IllegalArgumentException("File descriptors passed in Intent");
                    }
                    boolean componentSpecified = intent.getComponent() != null;
                    intent = new Intent(intent);
                    ActivityInfo aInfo = this.mSupervisor.resolveActivity(intent, resolvedTypes[i], 0, null, userId);
                    if ((aInfo = this.mService.getActivityInfoForUser(aInfo, userId)) != null && (aInfo.applicationInfo.privateFlags & 2) != 0) {
                        throw new IllegalArgumentException("FLAG_CANT_SAVE_STATE not supported here");
                    }
                    ActivityOptions options = ActivityOptions.fromBundle(i == intents.length - 1 ? bOptions : null);
                    int res = this.startActivityLocked(caller, intent, null, resolvedTypes[i], aInfo, null, null, null, resultTo, null, -1, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, 0, options, false, componentSpecified, outActivity, null, null, reason);
                    if (res < 0) {
                        int n = res;
                        return n;
                    }
                    resultTo = outActivity[0] != null ? outActivity[0].appToken : null;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        {
            return 0;
        }
    }

    void sendPowerHintForLaunchStartIfNeeded(boolean forceSend) {
        boolean sendHint = forceSend;
        if (!sendHint) {
            ActivityRecord resumedActivity = this.mSupervisor.getResumedActivityLocked();
            boolean bl = sendHint = resumedActivity == null || resumedActivity.app == null || !resumedActivity.app.equals(this.mStartActivity.app);
        }
        if (sendHint && this.mService.mLocalPowerManager != null) {
            this.mService.mLocalPowerManager.powerHint(8, 1);
            this.mPowerHintSent = true;
        }
    }

    void sendPowerHintForLaunchEndIfNeeded() {
        if (this.mPowerHintSent && this.mService.mLocalPowerManager != null) {
            this.mService.mLocalPowerManager.powerHint(8, 0);
            this.mPowerHintSent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startActivity(ActivityRecord r, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, int startFlags, boolean doResume, ActivityOptions options, TaskRecord inTask, ActivityRecord[] outActivity) {
        int result = -96;
        try {
            this.mService.mWindowManager.deferSurfaceLayout();
            result = this.startActivityUnchecked(r, sourceRecord, voiceSession, voiceInteractor, startFlags, doResume, options, inTask, outActivity);
        }
        finally {
            if (!ActivityManager.isStartResultSuccessful(result) && this.mStartActivity.getTask() != null) {
                this.mStartActivity.getTask().removeActivity(this.mStartActivity);
            }
            this.mService.mWindowManager.continueSurfaceLayout();
        }
        this.postStartActivityProcessing(r, result, this.mSupervisor.getLastStack().mStackId, this.mSourceRecord, this.mTargetStack);
        return result;
    }

    private int startActivityUnchecked(ActivityRecord r, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, int startFlags, boolean doResume, ActivityOptions options, TaskRecord inTask, ActivityRecord[] outActivity) {
        boolean dontStart;
        int preferredLaunchDisplayId;
        this.setInitialState(r, options, inTask, doResume, startFlags, sourceRecord, voiceSession, voiceInteractor);
        this.computeLaunchingTaskFlags();
        this.computeSourceStack();
        this.mIntent.setFlags(this.mLaunchFlags);
        ActivityRecord reusedActivity = this.getReusableIntentActivity();
        int preferredLaunchStackId = this.mOptions != null ? this.mOptions.getLaunchStackId() : -1;
        int n = preferredLaunchDisplayId = this.mOptions != null ? this.mOptions.getLaunchDisplayId() : 0;
        if (reusedActivity != null) {
            ActivityRecord outResult;
            if (this.mSupervisor.isLockTaskModeViolation(reusedActivity.getTask(), (this.mLaunchFlags & 0x10008000) == 0x10008000)) {
                this.mSupervisor.showLockTaskToast();
                Slog.e("ActivityManager", "startActivityUnchecked: Attempt to violate Lock Task Mode");
                return 101;
            }
            if (this.mStartActivity.getTask() == null) {
                this.mStartActivity.setTask(reusedActivity.getTask());
            }
            if (reusedActivity.getTask().intent == null) {
                reusedActivity.getTask().setIntent(this.mStartActivity);
            }
            if ((this.mLaunchFlags & 0x4000000) != 0 || ActivityStarter.isDocumentLaunchesIntoExisting(this.mLaunchFlags) || this.mLaunchSingleInstance || this.mLaunchSingleTask) {
                TaskRecord task = reusedActivity.getTask();
                ActivityRecord top = task.performClearTaskForReuseLocked(this.mStartActivity, this.mLaunchFlags);
                if (reusedActivity.getTask() == null) {
                    reusedActivity.setTask(task);
                }
                if (top != null) {
                    if (top.frontOfTask) {
                        top.getTask().setIntent(this.mStartActivity);
                    }
                    ActivityStack.logStartActivity(30003, this.mStartActivity, top.getTask());
                    top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
                }
            }
            this.sendPowerHintForLaunchStartIfNeeded(false);
            reusedActivity = this.setTargetStackAndMoveToFrontIfNeeded(reusedActivity);
            ActivityRecord activityRecord = outResult = outActivity != null && outActivity.length > 0 ? outActivity[0] : null;
            if (outResult != null && (outResult.finishing || outResult.noDisplay)) {
                outActivity[0] = reusedActivity;
            }
            if ((this.mStartFlags & 1) != 0) {
                this.resumeTargetStackIfNeeded();
                return 1;
            }
            this.setTaskFromIntentActivity(reusedActivity);
            if (!this.mAddingToTask && this.mReuseTask == null) {
                this.resumeTargetStackIfNeeded();
                if (outActivity != null && outActivity.length > 0) {
                    outActivity[0] = reusedActivity;
                }
                return 2;
            }
        }
        if (this.mStartActivity.packageName == null) {
            ActivityStack sourceStack;
            ActivityStack activityStack = sourceStack = this.mStartActivity.resultTo != null ? (ActivityStack)this.mStartActivity.resultTo.getStack() : null;
            if (sourceStack != null) {
                sourceStack.sendActivityResultLocked(-1, this.mStartActivity.resultTo, this.mStartActivity.resultWho, this.mStartActivity.requestCode, 0, null);
            }
            ActivityOptions.abort(this.mOptions);
            return -92;
        }
        ActivityStack topStack = this.mSupervisor.mFocusedStack;
        ActivityRecord topFocused = topStack.topActivity();
        ActivityRecord top = topStack.topRunningNonDelayedActivityLocked(this.mNotTop);
        boolean bl = dontStart = top != null && this.mStartActivity.resultTo == null && top.realActivity.equals(this.mStartActivity.realActivity) && top.userId == this.mStartActivity.userId && top.app != null && top.app.thread != null && ((this.mLaunchFlags & 0x20000000) != 0 || this.mLaunchSingleTop || this.mLaunchSingleTask);
        if (dontStart) {
            ActivityStack.logStartActivity(30003, top, top.getTask());
            topStack.mLastPausedActivity = null;
            if (this.mDoResume) {
                this.mSupervisor.resumeFocusedStackTopActivityLocked();
            }
            ActivityOptions.abort(this.mOptions);
            if ((this.mStartFlags & 1) != 0) {
                return 1;
            }
            top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            this.mSupervisor.handleNonResizableTaskIfNeeded(top.getTask(), preferredLaunchStackId, preferredLaunchDisplayId, topStack.mStackId);
            return 3;
        }
        boolean newTask = false;
        TaskRecord taskToAffiliate = this.mLaunchTaskBehind && this.mSourceRecord != null ? this.mSourceRecord.getTask() : null;
        int result = 0;
        if (this.mStartActivity.resultTo == null && this.mInTask == null && !this.mAddingToTask && (this.mLaunchFlags & 0x10000000) != 0) {
            newTask = true;
            result = this.setTaskFromReuseOrCreateNewTask(taskToAffiliate, preferredLaunchStackId, topStack);
        } else if (this.mSourceRecord != null) {
            result = this.setTaskFromSourceRecord();
        } else if (this.mInTask != null) {
            result = this.setTaskFromInTask();
        } else {
            this.setTaskToCurrentTopOrCreateNewTask();
        }
        if (result != 0) {
            return result;
        }
        this.mService.grantUriPermissionFromIntentLocked(this.mCallingUid, this.mStartActivity.packageName, this.mIntent, this.mStartActivity.getUriPermissionsLocked(), this.mStartActivity.userId);
        this.mService.grantEphemeralAccessLocked(this.mStartActivity.userId, this.mIntent, this.mStartActivity.appInfo.uid, UserHandle.getAppId(this.mCallingUid));
        if (this.mSourceRecord != null) {
            this.mStartActivity.getTask().setTaskToReturnTo(this.mSourceRecord);
        }
        if (newTask) {
            EventLog.writeEvent(30004, this.mStartActivity.userId, this.mStartActivity.getTask().taskId);
        }
        ActivityStack.logStartActivity(30005, this.mStartActivity, this.mStartActivity.getTask());
        this.mTargetStack.mLastPausedActivity = null;
        this.sendPowerHintForLaunchStartIfNeeded(false);
        this.mTargetStack.startActivityLocked(this.mStartActivity, topFocused, newTask, this.mKeepCurTransition, this.mOptions);
        if (this.mDoResume) {
            ActivityRecord topTaskActivity = this.mStartActivity.getTask().topRunningActivityLocked();
            if (!this.mTargetStack.isFocusable() || topTaskActivity != null && topTaskActivity.mTaskOverlay && this.mStartActivity != topTaskActivity) {
                this.mTargetStack.ensureActivitiesVisibleLocked(null, 0, false);
                this.mWindowManager.executeAppTransition();
            } else {
                if (this.mTargetStack.isFocusable() && !this.mSupervisor.isFocusedStack(this.mTargetStack)) {
                    this.mTargetStack.moveToFront("startActivityUnchecked");
                }
                this.mSupervisor.resumeFocusedStackTopActivityLocked(this.mTargetStack, this.mStartActivity, this.mOptions);
            }
        } else {
            this.mTargetStack.addRecentActivityLocked(this.mStartActivity);
        }
        this.mSupervisor.updateUserStackLocked(this.mStartActivity.userId, this.mTargetStack);
        this.mSupervisor.handleNonResizableTaskIfNeeded(this.mStartActivity.getTask(), preferredLaunchStackId, preferredLaunchDisplayId, this.mTargetStack.mStackId);
        return 0;
    }

    private void setInitialState(ActivityRecord r, ActivityOptions options, TaskRecord inTask, boolean doResume, int startFlags, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor) {
        this.reset();
        this.mStartActivity = r;
        this.mIntent = r.intent;
        this.mOptions = options;
        this.mCallingUid = r.launchedFromUid;
        this.mSourceRecord = sourceRecord;
        this.mVoiceSession = voiceSession;
        this.mVoiceInteractor = voiceInteractor;
        this.mSourceDisplayId = this.getSourceDisplayId(this.mSourceRecord, this.mStartActivity);
        this.mLaunchBounds = this.getOverrideBounds(r, options, inTask);
        this.mLaunchSingleTop = r.launchMode == 1;
        this.mLaunchSingleInstance = r.launchMode == 3;
        this.mLaunchSingleTask = r.launchMode == 2;
        this.mLaunchFlags = this.adjustLaunchFlagsToDocumentMode(r, this.mLaunchSingleInstance, this.mLaunchSingleTask, this.mIntent.getFlags());
        this.mLaunchTaskBehind = r.mLaunchTaskBehind && !this.mLaunchSingleTask && !this.mLaunchSingleInstance && (this.mLaunchFlags & 0x80000) != 0;
        this.sendNewTaskResultRequestIfNeeded();
        if ((this.mLaunchFlags & 0x80000) != 0 && r.resultTo == null) {
            this.mLaunchFlags |= 0x10000000;
        }
        if ((this.mLaunchFlags & 0x10000000) != 0 && (this.mLaunchTaskBehind || r.info.documentLaunchMode == 2)) {
            this.mLaunchFlags |= 0x8000000;
        }
        this.mSupervisor.mUserLeaving = (this.mLaunchFlags & 0x40000) == 0;
        this.mDoResume = doResume;
        if (!doResume || !r.okToShowLocked()) {
            r.delayedResume = true;
            this.mDoResume = false;
        }
        if (this.mOptions != null && this.mOptions.getLaunchTaskId() != -1 && this.mOptions.getTaskOverlay()) {
            r.mTaskOverlay = true;
            if (!this.mOptions.canTaskOverlayResume()) {
                ActivityRecord top;
                TaskRecord task = this.mSupervisor.anyTaskForIdLocked(this.mOptions.getLaunchTaskId());
                ActivityRecord activityRecord = top = task != null ? task.getTopActivity() : null;
                if (top != null && top.state != ActivityStack.ActivityState.RESUMED) {
                    this.mDoResume = false;
                    this.mAvoidMoveToFront = true;
                }
            }
        }
        this.mNotTop = (this.mLaunchFlags & 0x1000000) != 0 ? r : null;
        this.mInTask = inTask;
        if (inTask != null && !inTask.inRecents) {
            Slog.w("ActivityManager", "Starting activity in task not in recents: " + inTask);
            this.mInTask = null;
        }
        this.mStartFlags = startFlags;
        if ((startFlags & 1) != 0) {
            ActivityRecord checkedCaller = sourceRecord;
            if (checkedCaller == null) {
                checkedCaller = this.mSupervisor.mFocusedStack.topRunningNonDelayedActivityLocked(this.mNotTop);
            }
            if (!checkedCaller.realActivity.equals(r.realActivity)) {
                this.mStartFlags &= 0xFFFFFFFE;
            }
        }
        this.mNoAnimation = (this.mLaunchFlags & 0x10000) != 0;
    }

    private void sendNewTaskResultRequestIfNeeded() {
        ActivityStack sourceStack;
        ActivityStack activityStack = sourceStack = this.mStartActivity.resultTo != null ? (ActivityStack)this.mStartActivity.resultTo.getStack() : null;
        if (sourceStack != null && (this.mLaunchFlags & 0x10000000) != 0) {
            Slog.w("ActivityManager", "Activity is launching as a new task, so cancelling activity result.");
            sourceStack.sendActivityResultLocked(-1, this.mStartActivity.resultTo, this.mStartActivity.resultWho, this.mStartActivity.requestCode, 0, null);
            this.mStartActivity.resultTo = null;
        }
    }

    private void computeLaunchingTaskFlags() {
        if (this.mSourceRecord == null && this.mInTask != null && this.mInTask.getStack() != null) {
            Intent baseIntent = this.mInTask.getBaseIntent();
            ActivityRecord root = this.mInTask.getRootActivity();
            if (baseIntent == null) {
                ActivityOptions.abort(this.mOptions);
                throw new IllegalArgumentException("Launching into task without base intent: " + this.mInTask);
            }
            if (this.mLaunchSingleInstance || this.mLaunchSingleTask) {
                if (!baseIntent.getComponent().equals(this.mStartActivity.intent.getComponent())) {
                    ActivityOptions.abort(this.mOptions);
                    throw new IllegalArgumentException("Trying to launch singleInstance/Task " + this.mStartActivity + " into different task " + this.mInTask);
                }
                if (root != null) {
                    ActivityOptions.abort(this.mOptions);
                    throw new IllegalArgumentException("Caller with mInTask " + this.mInTask + " has root " + root + " but target is singleInstance/Task");
                }
            }
            if (root == null) {
                int flagsOfInterest = 403185664;
                this.mLaunchFlags = this.mLaunchFlags & 0xE7F7DFFF | baseIntent.getFlags() & 0x18082000;
                this.mIntent.setFlags(this.mLaunchFlags);
                this.mInTask.setIntent(this.mStartActivity);
                this.mAddingToTask = true;
            } else {
                this.mAddingToTask = (this.mLaunchFlags & 0x10000000) == 0;
            }
            this.mReuseTask = this.mInTask;
        } else {
            this.mInTask = null;
            if ((this.mStartActivity.isResolverActivity() || this.mStartActivity.noDisplay) && this.mSourceRecord != null && this.mSourceRecord.isFreeform()) {
                this.mAddingToTask = true;
            }
        }
        if (this.mInTask == null) {
            if (this.mSourceRecord == null) {
                if ((this.mLaunchFlags & 0x10000000) == 0 && this.mInTask == null) {
                    Slog.w("ActivityManager", "startActivity called from non-Activity context; forcing Intent.FLAG_ACTIVITY_NEW_TASK for: " + this.mIntent);
                    this.mLaunchFlags |= 0x10000000;
                }
            } else if (this.mSourceRecord.launchMode == 3) {
                this.mLaunchFlags |= 0x10000000;
            } else if (this.mLaunchSingleInstance || this.mLaunchSingleTask) {
                this.mLaunchFlags |= 0x10000000;
            }
        }
    }

    private void computeSourceStack() {
        if (this.mSourceRecord == null) {
            this.mSourceStack = null;
            return;
        }
        if (!this.mSourceRecord.finishing) {
            this.mSourceStack = this.mSourceRecord.getStack();
            return;
        }
        if ((this.mLaunchFlags & 0x10000000) == 0) {
            Slog.w("ActivityManager", "startActivity called from finishing " + this.mSourceRecord + "; forcing " + "Intent.FLAG_ACTIVITY_NEW_TASK for: " + this.mIntent);
            this.mLaunchFlags |= 0x10000000;
            this.mNewTaskInfo = this.mSourceRecord.info;
            TaskRecord sourceTask = this.mSourceRecord.getTask();
            this.mNewTaskIntent = sourceTask != null ? sourceTask.intent : null;
        }
        this.mSourceRecord = null;
        this.mSourceStack = null;
    }

    private ActivityRecord getReusableIntentActivity() {
        boolean putIntoExistingTask = (this.mLaunchFlags & 0x10000000) != 0 && (this.mLaunchFlags & 0x8000000) == 0 || this.mLaunchSingleInstance || this.mLaunchSingleTask;
        putIntoExistingTask &= this.mInTask == null && this.mStartActivity.resultTo == null;
        ActivityRecord intentActivity = null;
        if (this.mOptions != null && this.mOptions.getLaunchTaskId() != -1) {
            TaskRecord task = this.mSupervisor.anyTaskForIdLocked(this.mOptions.getLaunchTaskId());
            intentActivity = task != null ? task.getTopActivity() : null;
        } else if (putIntoExistingTask) {
            intentActivity = this.mLaunchSingleInstance ? this.mSupervisor.findActivityLocked(this.mIntent, this.mStartActivity.info, false) : ((this.mLaunchFlags & 0x1000) != 0 ? this.mSupervisor.findActivityLocked(this.mIntent, this.mStartActivity.info, !this.mLaunchSingleTask) : this.mSupervisor.findTaskLocked(this.mStartActivity, this.mSourceDisplayId));
        }
        return intentActivity;
    }

    private int getSourceDisplayId(ActivityRecord sourceRecord, ActivityRecord startingActivity) {
        if (startingActivity != null && startingActivity.requestedVrComponent != null) {
            return 0;
        }
        int displayId = this.mService.mVr2dDisplayId;
        if (displayId != -1) {
            this.mUsingVr2dDisplay = true;
            return displayId;
        }
        int n = displayId = sourceRecord != null ? sourceRecord.getDisplayId() : -1;
        if (displayId != -1) {
            return displayId;
        }
        return 0;
    }

    private ActivityRecord setTargetStackAndMoveToFrontIfNeeded(ActivityRecord intentActivity) {
        TaskRecord topTask;
        this.mTargetStack = intentActivity.getStack();
        this.mTargetStack.mLastPausedActivity = null;
        ActivityStack focusStack = this.mSupervisor.getFocusedStack();
        ActivityRecord curTop = focusStack == null ? null : focusStack.topRunningNonDelayedActivityLocked(this.mNotTop);
        TaskRecord taskRecord = topTask = curTop != null ? curTop.getTask() : null;
        if (!(topTask == null || topTask == intentActivity.getTask() && topTask == focusStack.topTask() || this.mAvoidMoveToFront)) {
            this.mStartActivity.intent.addFlags(0x400000);
            if (this.mSourceRecord == null || this.mSourceStack.topActivity() != null && this.mSourceStack.topActivity().getTask() == this.mSourceRecord.getTask()) {
                boolean willClearTask;
                if (this.mLaunchTaskBehind && this.mSourceRecord != null) {
                    intentActivity.setTaskToAffiliateWith(this.mSourceRecord.getTask());
                }
                this.mMovedOtherTask = true;
                boolean bl = willClearTask = (this.mLaunchFlags & 0x10008000) == 0x10008000;
                if (!willClearTask) {
                    ActivityStack launchStack = this.getLaunchStack(this.mStartActivity, this.mLaunchFlags, this.mStartActivity.getTask(), this.mOptions);
                    TaskRecord intentTask = intentActivity.getTask();
                    if (launchStack == null || launchStack == this.mTargetStack) {
                        this.mTargetStack.moveTaskToFrontLocked(intentTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "bringingFoundTaskToFront");
                        this.mMovedToFront = true;
                    } else if (launchStack.mStackId == 3 || launchStack.mStackId == 1) {
                        if ((this.mLaunchFlags & 0x1000) != 0) {
                            intentTask.reparent(launchStack.mStackId, true, 0, true, true, "launchToSide");
                        } else {
                            this.mTargetStack.moveTaskToFrontLocked(intentTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "bringToFrontInsteadOfAdjacentLaunch");
                        }
                        this.mMovedToFront = true;
                    } else if (launchStack.mDisplayId != this.mTargetStack.mDisplayId) {
                        intentActivity.getTask().reparent(launchStack.mStackId, true, 0, true, true, "reparentToDisplay");
                        this.mMovedToFront = true;
                    }
                    this.mOptions = null;
                    intentActivity.showStartingWindow(null, false, true);
                }
                this.updateTaskReturnToType(intentActivity.getTask(), this.mLaunchFlags, focusStack);
            }
        }
        if (!this.mMovedToFront && this.mDoResume) {
            this.mTargetStack.moveToFront("intentActivityFound");
        }
        this.mSupervisor.handleNonResizableTaskIfNeeded(intentActivity.getTask(), -1, 0, this.mTargetStack.mStackId);
        if ((this.mLaunchFlags & 0x200000) != 0) {
            return this.mTargetStack.resetTaskIfNeededLocked(intentActivity, this.mStartActivity);
        }
        return intentActivity;
    }

    private void updateTaskReturnToType(TaskRecord task, int launchFlags, ActivityStack focusedStack) {
        if ((launchFlags & 0x10004000) == 0x10004000) {
            task.setTaskToReturnTo(1);
            return;
        }
        if (focusedStack == null || focusedStack.isHomeStack()) {
            task.setTaskToReturnTo(1);
            return;
        }
        if (focusedStack != null && focusedStack != task.getStack() && focusedStack.isAssistantStack()) {
            task.setTaskToReturnTo(3);
            return;
        }
        task.setTaskToReturnTo(0);
    }

    private void setTaskFromIntentActivity(ActivityRecord intentActivity) {
        if ((this.mLaunchFlags & 0x10008000) == 0x10008000) {
            TaskRecord task = intentActivity.getTask();
            task.performClearTaskLocked();
            this.mReuseTask = task;
            this.mReuseTask.setIntent(this.mStartActivity);
            this.mMovedOtherTask = true;
        } else if ((this.mLaunchFlags & 0x4000000) != 0 || this.mLaunchSingleInstance || this.mLaunchSingleTask) {
            ActivityRecord top = intentActivity.getTask().performClearTaskLocked(this.mStartActivity, this.mLaunchFlags);
            if (top == null) {
                this.mAddingToTask = true;
                this.mStartActivity.setTask(null);
                this.mSourceRecord = intentActivity;
                TaskRecord task = this.mSourceRecord.getTask();
                if (task != null && task.getStack() == null) {
                    this.mTargetStack = this.computeStackFocus(this.mSourceRecord, false, null, this.mLaunchFlags, this.mOptions);
                    this.mTargetStack.addTask(task, !this.mLaunchTaskBehind, "startActivityUnchecked");
                }
            }
        } else if (this.mStartActivity.realActivity.equals(intentActivity.getTask().realActivity)) {
            if (((this.mLaunchFlags & 0x20000000) != 0 || this.mLaunchSingleTop) && intentActivity.realActivity.equals(this.mStartActivity.realActivity)) {
                ActivityStack.logStartActivity(30003, this.mStartActivity, intentActivity.getTask());
                if (intentActivity.frontOfTask) {
                    intentActivity.getTask().setIntent(this.mStartActivity);
                }
                intentActivity.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            } else if (!intentActivity.getTask().isSameIntentFilter(this.mStartActivity)) {
                this.mAddingToTask = true;
                this.mSourceRecord = intentActivity;
            }
        } else if ((this.mLaunchFlags & 0x200000) == 0) {
            this.mAddingToTask = true;
            this.mSourceRecord = intentActivity;
        } else if (!intentActivity.getTask().rootWasReset) {
            intentActivity.getTask().setIntent(this.mStartActivity);
        }
    }

    private void resumeTargetStackIfNeeded() {
        if (this.mDoResume) {
            this.mSupervisor.resumeFocusedStackTopActivityLocked(this.mTargetStack, null, this.mOptions);
        } else {
            ActivityOptions.abort(this.mOptions);
        }
        this.mSupervisor.updateUserStackLocked(this.mStartActivity.userId, this.mTargetStack);
    }

    private int setTaskFromReuseOrCreateNewTask(TaskRecord taskToAffiliate, int preferredLaunchStackId, ActivityStack topStack) {
        this.mTargetStack = this.computeStackFocus(this.mStartActivity, true, this.mLaunchBounds, this.mLaunchFlags, this.mOptions);
        if (this.mReuseTask == null) {
            TaskRecord task = this.mTargetStack.createTaskRecord(this.mSupervisor.getNextTaskIdForUserLocked(this.mStartActivity.userId), this.mNewTaskInfo != null ? this.mNewTaskInfo : this.mStartActivity.info, this.mNewTaskIntent != null ? this.mNewTaskIntent : this.mIntent, this.mVoiceSession, this.mVoiceInteractor, !this.mLaunchTaskBehind, this.mStartActivity.mActivityType);
            this.addOrReparentStartingActivity(task, "setTaskFromReuseOrCreateNewTask - mReuseTask");
            if (this.mLaunchBounds != null) {
                int stackId = this.mTargetStack.mStackId;
                if (ActivityManager.StackId.resizeStackWithLaunchBounds(stackId)) {
                    this.mService.resizeStack(stackId, this.mLaunchBounds, true, false, true, -1);
                } else {
                    this.mStartActivity.getTask().updateOverrideConfiguration(this.mLaunchBounds);
                }
            }
        } else {
            this.addOrReparentStartingActivity(this.mReuseTask, "setTaskFromReuseOrCreateNewTask");
        }
        if (taskToAffiliate != null) {
            this.mStartActivity.setTaskToAffiliateWith(taskToAffiliate);
        }
        if (this.mSupervisor.isLockTaskModeViolation(this.mStartActivity.getTask())) {
            Slog.e("ActivityManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
            return 101;
        }
        if (!this.mMovedOtherTask) {
            this.updateTaskReturnToType(this.mStartActivity.getTask(), this.mLaunchFlags, preferredLaunchStackId != -1 ? this.mTargetStack : topStack);
        }
        if (this.mDoResume) {
            this.mTargetStack.moveToFront("reuseOrNewTask");
        }
        return 0;
    }

    private int setTaskFromSourceRecord() {
        ActivityRecord top;
        boolean moveStackAllowed;
        if (this.mSupervisor.isLockTaskModeViolation(this.mSourceRecord.getTask())) {
            Slog.e("ActivityManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
            return 101;
        }
        TaskRecord sourceTask = this.mSourceRecord.getTask();
        Object sourceStack = this.mSourceRecord.getStack();
        boolean bl = moveStackAllowed = ((ActivityStack)sourceStack).topTask() != sourceTask;
        if (moveStackAllowed) {
            this.mTargetStack = this.getLaunchStack(this.mStartActivity, this.mLaunchFlags, this.mStartActivity.getTask(), this.mOptions);
        }
        if (this.mTargetStack == null) {
            this.mTargetStack = sourceStack;
        } else if (this.mTargetStack != sourceStack) {
            sourceTask.reparent(this.mTargetStack.mStackId, true, 0, false, true, "launchToSide");
        }
        TaskRecord topTask = this.mTargetStack.topTask();
        if (topTask != sourceTask && !this.mAvoidMoveToFront) {
            this.mTargetStack.moveTaskToFrontLocked(sourceTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "sourceTaskToFront");
        } else if (this.mDoResume) {
            this.mTargetStack.moveToFront("sourceStackToFront");
        }
        if (!this.mAddingToTask && (this.mLaunchFlags & 0x4000000) != 0) {
            ActivityRecord top2 = sourceTask.performClearTaskLocked(this.mStartActivity, this.mLaunchFlags);
            this.mKeepCurTransition = true;
            if (top2 != null) {
                ActivityStack.logStartActivity(30003, this.mStartActivity, top2.getTask());
                top2.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
                this.mTargetStack.mLastPausedActivity = null;
                if (this.mDoResume) {
                    this.mSupervisor.resumeFocusedStackTopActivityLocked();
                }
                ActivityOptions.abort(this.mOptions);
                return 3;
            }
        } else if (!this.mAddingToTask && (this.mLaunchFlags & 0x20000) != 0 && (top = sourceTask.findActivityInHistoryLocked(this.mStartActivity)) != null) {
            TaskRecord task = top.getTask();
            task.moveActivityToFrontLocked(top);
            top.updateOptionsLocked(this.mOptions);
            ActivityStack.logStartActivity(30003, this.mStartActivity, task);
            top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            this.mTargetStack.mLastPausedActivity = null;
            if (this.mDoResume) {
                this.mSupervisor.resumeFocusedStackTopActivityLocked();
            }
            return 3;
        }
        this.addOrReparentStartingActivity(sourceTask, "setTaskFromSourceRecord");
        return 0;
    }

    private int setTaskFromInTask() {
        if (this.mSupervisor.isLockTaskModeViolation(this.mInTask)) {
            Slog.e("ActivityManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
            return 101;
        }
        this.mTargetStack = this.mInTask.getStack();
        ActivityRecord top = this.mInTask.getTopActivity();
        if (top != null && top.realActivity.equals(this.mStartActivity.realActivity) && top.userId == this.mStartActivity.userId && ((this.mLaunchFlags & 0x20000000) != 0 || this.mLaunchSingleTop || this.mLaunchSingleTask)) {
            this.mTargetStack.moveTaskToFrontLocked(this.mInTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "inTaskToFront");
            ActivityStack.logStartActivity(30003, top, top.getTask());
            if ((this.mStartFlags & 1) != 0) {
                return 1;
            }
            top.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
            return 3;
        }
        if (!this.mAddingToTask) {
            this.mTargetStack.moveTaskToFrontLocked(this.mInTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "inTaskToFront");
            ActivityOptions.abort(this.mOptions);
            return 2;
        }
        if (this.mLaunchBounds != null) {
            this.mInTask.updateOverrideConfiguration(this.mLaunchBounds);
            int stackId = this.mInTask.getLaunchStackId();
            if (stackId != this.mInTask.getStackId()) {
                this.mInTask.reparent(stackId, true, 1, false, true, "inTaskToFront");
                stackId = this.mInTask.getStackId();
                this.mTargetStack = this.mInTask.getStack();
            }
            if (ActivityManager.StackId.resizeStackWithLaunchBounds(stackId)) {
                this.mService.resizeStack(stackId, this.mLaunchBounds, true, false, true, -1);
            }
        }
        this.mTargetStack.moveTaskToFrontLocked(this.mInTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "inTaskToFront");
        this.addOrReparentStartingActivity(this.mInTask, "setTaskFromInTask");
        return 0;
    }

    private void setTaskToCurrentTopOrCreateNewTask() {
        ActivityRecord prev;
        this.mTargetStack = this.computeStackFocus(this.mStartActivity, false, null, this.mLaunchFlags, this.mOptions);
        if (this.mDoResume) {
            this.mTargetStack.moveToFront("addingToTopTask");
        }
        TaskRecord task = (prev = this.mTargetStack.topActivity()) != null ? prev.getTask() : this.mTargetStack.createTaskRecord(this.mSupervisor.getNextTaskIdForUserLocked(this.mStartActivity.userId), this.mStartActivity.info, this.mIntent, null, null, true, this.mStartActivity.mActivityType);
        this.addOrReparentStartingActivity(task, "setTaskToCurrentTopOrCreateNewTask");
        this.mTargetStack.positionChildWindowContainerAtTop(task);
    }

    private void addOrReparentStartingActivity(TaskRecord parent, String reason) {
        if (this.mStartActivity.getTask() == null || this.mStartActivity.getTask() == parent) {
            parent.addActivityToTop(this.mStartActivity);
        } else {
            this.mStartActivity.reparent(parent, parent.mActivities.size(), reason);
        }
    }

    private int adjustLaunchFlagsToDocumentMode(ActivityRecord r, boolean launchSingleInstance, boolean launchSingleTask, int launchFlags) {
        if ((launchFlags & 0x80000) != 0 && (launchSingleInstance || launchSingleTask)) {
            Slog.i("ActivityManager", "Ignoring FLAG_ACTIVITY_NEW_DOCUMENT, launchMode is \"singleInstance\" or \"singleTask\"");
            launchFlags &= 0xF7F7FFFF;
        } else {
            switch (r.info.documentLaunchMode) {
                case 0: {
                    break;
                }
                case 1: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 2: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 3: {
                    launchFlags &= 0xF7FFFFFF;
                }
            }
        }
        return launchFlags;
    }

    final void doPendingActivityLaunchesLocked(boolean doResume) {
        while (!this.mPendingActivityLaunches.isEmpty()) {
            ActivityStackSupervisor.PendingActivityLaunch pal = this.mPendingActivityLaunches.remove(0);
            boolean resume = doResume && this.mPendingActivityLaunches.isEmpty();
            try {
                this.startActivity(pal.r, pal.sourceRecord, null, null, pal.startFlags, resume, null, null, null);
            }
            catch (Exception e) {
                Slog.e("ActivityManager", "Exception during pending activity launch pal=" + pal, e);
                pal.sendErrorResult(e.getMessage());
            }
        }
    }

    private ActivityStack computeStackFocus(ActivityRecord r, boolean newTask, Rect bounds, int launchFlags, ActivityOptions aOptions) {
        ActivityStack currentStack;
        TaskRecord task = r.getTask();
        ActivityStack stack = this.getLaunchStack(r, launchFlags, task, aOptions);
        if (stack != null) {
            return stack;
        }
        ActivityStack activityStack = currentStack = task != null ? task.getStack() : null;
        if (currentStack != null) {
            if (this.mSupervisor.mFocusedStack != currentStack) {
                // empty if block
            }
            return currentStack;
        }
        ActivityStackSupervisor.ActivityContainer container = r.mInitialActivityContainer;
        if (container != null) {
            r.mInitialActivityContainer = null;
            return container.mStack;
        }
        if (this.canLaunchIntoFocusedStack(r, newTask)) {
            return this.mSupervisor.mFocusedStack;
        }
        if (this.mSourceDisplayId != 0 && (stack = this.mSupervisor.getValidLaunchStackOnDisplay(this.mSourceDisplayId, r)) == null) {
            stack = this.mSupervisor.getNextValidLaunchStackLocked(r, this.mSourceDisplayId);
        }
        if (stack == null) {
            ArrayList<ActivityStack> homeDisplayStacks = this.mSupervisor.mHomeStack.mStacks;
            for (int stackNdx = homeDisplayStacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stack = homeDisplayStacks.get(stackNdx);
                if (!ActivityManager.StackId.isDynamicStack(stack.mStackId)) continue;
                return stack;
            }
            int stackId = task != null ? task.getLaunchStackId() : (bounds != null ? 2 : 1);
            stack = this.mSupervisor.getStack(stackId, true, true);
        }
        return stack;
    }

    private boolean canLaunchIntoFocusedStack(ActivityRecord r, boolean newTask) {
        boolean canUseFocusedStack;
        ActivityStack focusedStack = this.mSupervisor.mFocusedStack;
        int focusedStackId = this.mSupervisor.mFocusedStack.mStackId;
        switch (focusedStackId) {
            case 1: {
                canUseFocusedStack = true;
                break;
            }
            case 6: {
                canUseFocusedStack = r.isAssistantActivity();
                break;
            }
            case 3: {
                canUseFocusedStack = r.supportsSplitScreen();
                break;
            }
            case 2: {
                canUseFocusedStack = r.supportsFreeform();
                break;
            }
            default: {
                canUseFocusedStack = ActivityManager.StackId.isDynamicStack(focusedStackId) && r.canBeLaunchedOnDisplay(focusedStack.mDisplayId);
            }
        }
        return canUseFocusedStack && (!newTask || focusedStack.mActivityContainer.isEligibleForNewTasks()) && this.mSourceDisplayId == focusedStack.mDisplayId;
    }

    private ActivityStack getLaunchStack(ActivityRecord r, int launchFlags, TaskRecord task, ActivityOptions aOptions) {
        ActivityStack parentStack;
        int launchStackId;
        if (this.mReuseTask != null) {
            return this.mReuseTask.getStack();
        }
        if (r.isHomeActivity()) {
            return this.mSupervisor.mHomeStack;
        }
        if (r.isRecentsActivity()) {
            return this.mSupervisor.getStack(5, true, true);
        }
        if (r.isAssistantActivity()) {
            return this.mSupervisor.getStack(6, true, true);
        }
        int launchDisplayId = aOptions != null ? aOptions.getLaunchDisplayId() : -1;
        int n = launchStackId = aOptions != null ? aOptions.getLaunchStackId() : -1;
        if (launchStackId != -1 && launchDisplayId != -1) {
            throw new IllegalArgumentException("Stack and display id can't be set at the same time.");
        }
        if (this.isValidLaunchStackId(launchStackId, launchDisplayId, r)) {
            return this.mSupervisor.getStack(launchStackId, true, true);
        }
        if (launchStackId == 3) {
            return this.mSupervisor.getStack(1, true, true);
        }
        if (launchDisplayId != -1) {
            return this.mSupervisor.getValidLaunchStackOnDisplay(launchDisplayId, r);
        }
        if (this.mUsingVr2dDisplay) {
            ActivityStack as = this.mSupervisor.getValidLaunchStackOnDisplay(this.mSourceDisplayId, r);
            return as;
        }
        if ((launchFlags & 0x1000) == 0 || this.mSourceDisplayId != 0) {
            return null;
        }
        ActivityStack activityStack = task != null ? task.getStack() : (parentStack = r.mInitialActivityContainer != null ? r.mInitialActivityContainer.mStack : this.mSupervisor.mFocusedStack);
        if (parentStack != this.mSupervisor.mFocusedStack) {
            return parentStack;
        }
        if (this.mSupervisor.mFocusedStack != null && task == this.mSupervisor.mFocusedStack.topTask()) {
            return this.mSupervisor.mFocusedStack;
        }
        if (parentStack != null && parentStack.isDockedStack()) {
            return this.mSupervisor.getStack(1, true, true);
        }
        Object dockedStack = this.mSupervisor.getStack(3);
        if (dockedStack != null && ((ActivityStack)dockedStack).shouldBeVisible(r) == 0) {
            return null;
        }
        return dockedStack;
    }

    boolean isValidLaunchStackId(int stackId, int displayId, ActivityRecord r) {
        switch (stackId) {
            case -1: 
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return r.supportsFreeform();
            }
            case 3: {
                return r.supportsSplitScreen();
            }
            case 4: {
                return r.supportsPictureInPicture();
            }
            case 5: {
                return r.isRecentsActivity();
            }
            case 6: {
                return r.isAssistantActivity();
            }
        }
        if (ActivityManager.StackId.isDynamicStack(stackId)) {
            return r.canBeLaunchedOnDisplay(displayId);
        }
        Slog.e("ActivityManager", "isValidLaunchStackId: Unexpected stackId=" + stackId);
        return false;
    }

    Rect getOverrideBounds(ActivityRecord r, ActivityOptions options, TaskRecord inTask) {
        Rect newBounds = null;
        if (options != null && (r.isResizeable() || inTask != null && inTask.isResizeable()) && this.mSupervisor.canUseActivityOptionsLaunchBounds(options, options.getLaunchStackId())) {
            newBounds = TaskRecord.validateBounds(options.getLaunchBounds());
        }
        return newBounds;
    }

    void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
    }

    void removePendingActivityLaunchesLocked(ActivityStack stack) {
        for (int palNdx = this.mPendingActivityLaunches.size() - 1; palNdx >= 0; --palNdx) {
            ActivityStackSupervisor.PendingActivityLaunch pal = this.mPendingActivityLaunches.get(palNdx);
            if (pal.stack != stack) continue;
            this.mPendingActivityLaunches.remove(palNdx);
        }
    }

    static boolean isDocumentLaunchesIntoExisting(int flags) {
        return (flags & 0x80000) != 0 && (flags & 0x8000000) == 0;
    }

    boolean clearPendingActivityLaunchesLocked(String packageName) {
        boolean didSomething = false;
        for (int palNdx = this.mPendingActivityLaunches.size() - 1; palNdx >= 0; --palNdx) {
            ActivityStackSupervisor.PendingActivityLaunch pal = this.mPendingActivityLaunches.get(palNdx);
            ActivityRecord r = pal.r;
            if (r == null || !r.packageName.equals(packageName)) continue;
            this.mPendingActivityLaunches.remove(palNdx);
            didSomething = true;
        }
        return didSomething;
    }

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "ActivityStarter:");
        prefix = prefix + "  ";
        pw.println(prefix + "mCurrentUser=" + this.mSupervisor.mCurrentUser);
        pw.println(prefix + "mLastStartReason=" + this.mLastStartReason);
        pw.println(prefix + "mLastStartActivityTimeMs=" + DateFormat.getDateTimeInstance().format(new Date(this.mLastStartActivityTimeMs)));
        pw.println(prefix + "mLastStartActivityResult=" + this.mLastStartActivityResult);
        ActivityRecord r = this.mLastStartActivityRecord[0];
        if (r != null) {
            pw.println(prefix + "mLastStartActivityRecord:");
            r.dump(pw, prefix + " ");
        }
        pw.println(prefix + "mLastHomeActivityStartResult=" + this.mLastHomeActivityStartResult);
        r = this.mLastHomeActivityStartRecord[0];
        if (r != null) {
            pw.println(prefix + "mLastHomeActivityStartRecord:");
            r.dump(pw, prefix + " ");
        }
        if (this.mStartActivity != null) {
            pw.println(prefix + "mStartActivity:");
            this.mStartActivity.dump(pw, prefix + " ");
        }
        if (this.mIntent != null) {
            pw.println(prefix + "mIntent=" + this.mIntent);
        }
        if (this.mOptions != null) {
            pw.println(prefix + "mOptions=" + this.mOptions);
        }
        pw.println(prefix + "mLaunchSingleTop=" + this.mLaunchSingleTop + " mLaunchSingleInstance=" + this.mLaunchSingleInstance + " mLaunchSingleTask=" + this.mLaunchSingleTask + " mLaunchFlags=0x" + Integer.toHexString(this.mLaunchFlags) + " mDoResume=" + this.mDoResume + " mAddingToTask=" + this.mAddingToTask);
    }
}

