/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.BidiFormatter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.AppErrorResult;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;

final class AppErrorDialog
extends BaseErrorDialog
implements View.OnClickListener {
    private final ActivityManagerService mService;
    private final AppErrorResult mResult;
    private final ProcessRecord mProc;
    private final boolean mRepeating;
    private final boolean mIsRestartable;
    private CharSequence mName;
    static int CANT_SHOW = -1;
    static int BACKGROUND_USER = -2;
    static int ALREADY_SHOWING = -3;
    static final int FORCE_QUIT = 1;
    static final int FORCE_QUIT_AND_REPORT = 2;
    static final int RESTART = 3;
    static final int MUTE = 5;
    static final int TIMEOUT = 6;
    static final int CANCEL = 7;
    static final long DISMISS_TIMEOUT = 300000L;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            AppErrorDialog.this.setResult(msg.what);
            AppErrorDialog.this.dismiss();
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(intent.getAction())) {
                AppErrorDialog.this.cancel();
            }
        }
    };

    public AppErrorDialog(Context context, ActivityManagerService service, Data data) {
        super(context);
        Resources res = context.getResources();
        this.mService = service;
        this.mProc = data.proc;
        this.mResult = data.result;
        this.mRepeating = data.repeating;
        this.mIsRestartable = data.task != null || data.isRestartableForService;
        BidiFormatter bidi = BidiFormatter.getInstance();
        if (this.mProc.pkgList.size() == 1 && (this.mName = context.getPackageManager().getApplicationLabel(this.mProc.info)) != null) {
            this.setTitle(res.getString(this.mRepeating ? 17039446 : 17039445, bidi.unicodeWrap(this.mName.toString()), bidi.unicodeWrap(this.mProc.info.processName)));
        } else {
            this.mName = this.mProc.processName;
            this.setTitle(res.getString(this.mRepeating ? 17039451 : 17039450, bidi.unicodeWrap(this.mName.toString())));
        }
        this.setCancelable(true);
        this.setCancelMessage(this.mHandler.obtainMessage(7));
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.setTitle("Application Error: " + this.mProc.info.processName);
        attrs.privateFlags |= 0x110;
        this.getWindow().setAttributes(attrs);
        if (this.mProc.persistent) {
            this.getWindow().setType(2010);
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(6), 300000L);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FrameLayout frame = (FrameLayout)this.findViewById(16908331);
        Context context = this.getContext();
        LayoutInflater.from(context).inflate(17367093, (ViewGroup)frame, true);
        boolean hasRestart = !this.mRepeating && this.mIsRestartable;
        boolean hasReceiver = this.mProc.errorReportReceiver != null;
        TextView restart = (TextView)this.findViewById(16908692);
        restart.setOnClickListener(this);
        restart.setVisibility(hasRestart ? 0 : 8);
        TextView report = (TextView)this.findViewById(16908691);
        report.setOnClickListener(this);
        report.setVisibility(hasReceiver ? 0 : 8);
        TextView close = (TextView)this.findViewById(16908689);
        close.setVisibility(!hasRestart ? 0 : 8);
        close.setOnClickListener(this);
        boolean showMute = !ActivityManagerService.IS_USER_BUILD && Settings.Global.getInt(context.getContentResolver(), "development_settings_enabled", 0) != 0;
        TextView mute = (TextView)this.findViewById(16908690);
        mute.setOnClickListener(this);
        mute.setVisibility(showMute ? 0 : 8);
        ((View)this.findViewById(16908807)).setVisibility(0);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.getContext().registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.getContext().unregisterReceiver(this.mReceiver);
    }

    @Override
    public void dismiss() {
        if (!this.mResult.mHasResult) {
            this.setResult(1);
        }
        super.dismiss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(int result) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mProc != null && this.mProc.crashDialog == this) {
                this.mProc.crashDialog = null;
            }
        }
        this.mResult.set(result);
        this.mHandler.removeMessages(6);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case 16908692: {
                this.mHandler.obtainMessage(3).sendToTarget();
                break;
            }
            case 16908691: {
                this.mHandler.obtainMessage(2).sendToTarget();
                break;
            }
            case 16908689: {
                this.mHandler.obtainMessage(1).sendToTarget();
                break;
            }
            case 16908690: {
                this.mHandler.obtainMessage(5).sendToTarget();
                break;
            }
        }
    }

    static class Data {
        AppErrorResult result;
        TaskRecord task;
        boolean repeating;
        ProcessRecord proc;
        boolean isRestartableForService;

        Data() {
        }
    }
}

