/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.res.Configuration;

abstract class ConfigurationContainer<E extends ConfigurationContainer> {
    private Configuration mOverrideConfiguration = new Configuration();
    private Configuration mFullConfiguration = new Configuration();
    private Configuration mMergedOverrideConfiguration = new Configuration();

    ConfigurationContainer() {
    }

    Configuration getConfiguration() {
        return this.mFullConfiguration;
    }

    void onConfigurationChanged(Configuration newParentConfig) {
        this.mFullConfiguration.setTo(newParentConfig);
        this.mFullConfiguration.updateFrom(this.mOverrideConfiguration);
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            E child = this.getChildAt(i);
            ((ConfigurationContainer)child).onConfigurationChanged(this.mFullConfiguration);
        }
    }

    Configuration getOverrideConfiguration() {
        return this.mOverrideConfiguration;
    }

    void onOverrideConfigurationChanged(Configuration overrideConfiguration) {
        this.mOverrideConfiguration.setTo(overrideConfiguration);
        ConfigurationContainer parent = this.getParent();
        this.onConfigurationChanged(parent != null ? parent.getConfiguration() : Configuration.EMPTY);
        this.onMergedOverrideConfigurationChanged();
    }

    Configuration getMergedOverrideConfiguration() {
        return this.mMergedOverrideConfiguration;
    }

    private void onMergedOverrideConfigurationChanged() {
        ConfigurationContainer parent = this.getParent();
        if (parent != null) {
            this.mMergedOverrideConfiguration.setTo(parent.getMergedOverrideConfiguration());
            this.mMergedOverrideConfiguration.updateFrom(this.mOverrideConfiguration);
        } else {
            this.mMergedOverrideConfiguration.setTo(this.mOverrideConfiguration);
        }
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            E child = this.getChildAt(i);
            super.onMergedOverrideConfigurationChanged();
        }
    }

    void onParentChanged() {
        ConfigurationContainer parent = this.getParent();
        if (parent != null) {
            this.onConfigurationChanged(parent.mFullConfiguration);
            this.onMergedOverrideConfigurationChanged();
        }
    }

    protected abstract int getChildCount();

    protected abstract E getChildAt(int var1);

    protected abstract ConfigurationContainer getParent();
}

