/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.Trampoline;
import java.util.Random;

public class KeyValueBackupJob
extends JobService {
    private static final String TAG = "KeyValueBackupJob";
    private static ComponentName sKeyValueJobService = new ComponentName("android", KeyValueBackupJob.class.getName());
    private static final int JOB_ID = 20537;
    static final long BATCH_INTERVAL = 14400000L;
    private static final int FUZZ_MILLIS = 600000;
    private static final long MAX_DEFERRAL = 86400000L;
    private static boolean sScheduled = false;
    private static long sNextScheduled = 0L;

    public static void schedule(Context ctx) {
        KeyValueBackupJob.schedule(ctx, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Context ctx, long delay) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            if (!sScheduled) {
                if (delay <= 0L) {
                    delay = 14400000L + (long)new Random().nextInt(600000);
                }
                Slog.v(TAG, "Scheduling k/v pass in " + delay / 1000L / 60L + " minutes");
                JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
                JobInfo.Builder builder = new JobInfo.Builder(20537, sKeyValueJobService).setMinimumLatency(delay).setRequiredNetworkType(1).setRequiresCharging(true).setOverrideDeadline(86400000L);
                js.schedule(builder.build());
                sNextScheduled = System.currentTimeMillis() + delay;
                sScheduled = true;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel(Context ctx) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
            js.cancel(20537);
            sNextScheduled = 0L;
            sScheduled = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextScheduled() {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sNextScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            sNextScheduled = 0L;
            sScheduled = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Trampoline service = BackupManagerService.getInstance();
            try {
                service.backupNow();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return false;
    }
}

