/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.net.ConnectivityMetricsEvent;
import android.net.metrics.ApfProgramEvent;
import android.net.metrics.ApfStats;
import android.net.metrics.ConnectStats;
import android.net.metrics.DefaultNetworkEvent;
import android.net.metrics.DhcpClientEvent;
import android.net.metrics.DhcpErrorEvent;
import android.net.metrics.DnsEvent;
import android.net.metrics.IpManagerEvent;
import android.net.metrics.IpReachabilityEvent;
import android.net.metrics.NetworkEvent;
import android.net.metrics.RaEvent;
import android.net.metrics.ValidationProbeEvent;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.server.connectivity.metrics.nano.IpConnectivityLogClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class IpConnectivityEventBuilder {
    private static final int[] TRANSPORT_LINKLAYER_MAP = new int[6];
    private static final SparseArray<String> IFNAME_LINKLAYER_MAP;

    private IpConnectivityEventBuilder() {
    }

    public static byte[] serialize(int dropped, List<IpConnectivityLogClass.IpConnectivityEvent> events) throws IOException {
        IpConnectivityLogClass.IpConnectivityLog log = new IpConnectivityLogClass.IpConnectivityLog();
        log.events = events.toArray(new IpConnectivityLogClass.IpConnectivityEvent[events.size()]);
        log.droppedEvents = dropped;
        if (log.events.length > 0 || dropped > 0) {
            log.version = 2;
        }
        return IpConnectivityLogClass.IpConnectivityLog.toByteArray(log);
    }

    public static List<IpConnectivityLogClass.IpConnectivityEvent> toProto(List<ConnectivityMetricsEvent> eventsIn) {
        ArrayList<IpConnectivityLogClass.IpConnectivityEvent> eventsOut = new ArrayList<IpConnectivityLogClass.IpConnectivityEvent>(eventsIn.size());
        for (ConnectivityMetricsEvent in : eventsIn) {
            IpConnectivityLogClass.IpConnectivityEvent out = IpConnectivityEventBuilder.toProto(in);
            if (out == null) continue;
            eventsOut.add(out);
        }
        return eventsOut;
    }

    public static IpConnectivityLogClass.IpConnectivityEvent toProto(ConnectivityMetricsEvent ev) {
        IpConnectivityLogClass.IpConnectivityEvent out = IpConnectivityEventBuilder.buildEvent(ev.netId, ev.transports, ev.ifname);
        out.timeMs = ev.timestamp;
        if (!IpConnectivityEventBuilder.setEvent(out, ev.data)) {
            return null;
        }
        return out;
    }

    public static IpConnectivityLogClass.IpConnectivityEvent toProto(ConnectStats in) {
        IpConnectivityLogClass.ConnectStatistics stats = new IpConnectivityLogClass.ConnectStatistics();
        stats.connectCount = in.connectCount;
        stats.connectBlockingCount = in.connectBlockingCount;
        stats.ipv6AddrCount = in.ipv6ConnectCount;
        stats.latenciesMs = in.latencies.toArray();
        stats.errnosCounters = IpConnectivityEventBuilder.toPairArray(in.errnos);
        IpConnectivityLogClass.IpConnectivityEvent out = IpConnectivityEventBuilder.buildEvent(in.netId, in.transports, null);
        out.setConnectStatistics(stats);
        return out;
    }

    public static IpConnectivityLogClass.IpConnectivityEvent toProto(DnsEvent in) {
        IpConnectivityLogClass.DNSLookupBatch dnsLookupBatch = new IpConnectivityLogClass.DNSLookupBatch();
        in.resize(in.eventCount);
        dnsLookupBatch.eventTypes = IpConnectivityEventBuilder.bytesToInts(in.eventTypes);
        dnsLookupBatch.returnCodes = IpConnectivityEventBuilder.bytesToInts(in.returnCodes);
        dnsLookupBatch.latenciesMs = in.latenciesMs;
        IpConnectivityLogClass.IpConnectivityEvent out = IpConnectivityEventBuilder.buildEvent(in.netId, in.transports, null);
        out.setDnsLookupBatch(dnsLookupBatch);
        return out;
    }

    private static IpConnectivityLogClass.IpConnectivityEvent buildEvent(int netId, long transports, String ifname) {
        IpConnectivityLogClass.IpConnectivityEvent ev = new IpConnectivityLogClass.IpConnectivityEvent();
        ev.networkId = netId;
        ev.transports = transports;
        if (ifname != null) {
            ev.ifName = ifname;
        }
        IpConnectivityEventBuilder.inferLinkLayer(ev);
        return ev;
    }

    private static boolean setEvent(IpConnectivityLogClass.IpConnectivityEvent out, Parcelable in) {
        if (in instanceof DhcpErrorEvent) {
            IpConnectivityEventBuilder.setDhcpErrorEvent(out, (DhcpErrorEvent)in);
            return true;
        }
        if (in instanceof DhcpClientEvent) {
            IpConnectivityEventBuilder.setDhcpClientEvent(out, (DhcpClientEvent)in);
            return true;
        }
        if (in instanceof IpManagerEvent) {
            IpConnectivityEventBuilder.setIpManagerEvent(out, (IpManagerEvent)in);
            return true;
        }
        if (in instanceof IpReachabilityEvent) {
            IpConnectivityEventBuilder.setIpReachabilityEvent(out, (IpReachabilityEvent)in);
            return true;
        }
        if (in instanceof DefaultNetworkEvent) {
            IpConnectivityEventBuilder.setDefaultNetworkEvent(out, (DefaultNetworkEvent)in);
            return true;
        }
        if (in instanceof NetworkEvent) {
            IpConnectivityEventBuilder.setNetworkEvent(out, (NetworkEvent)in);
            return true;
        }
        if (in instanceof ValidationProbeEvent) {
            IpConnectivityEventBuilder.setValidationProbeEvent(out, (ValidationProbeEvent)in);
            return true;
        }
        if (in instanceof ApfProgramEvent) {
            IpConnectivityEventBuilder.setApfProgramEvent(out, (ApfProgramEvent)in);
            return true;
        }
        if (in instanceof ApfStats) {
            IpConnectivityEventBuilder.setApfStats(out, (ApfStats)in);
            return true;
        }
        if (in instanceof RaEvent) {
            IpConnectivityEventBuilder.setRaEvent(out, (RaEvent)in);
            return true;
        }
        return false;
    }

    private static void setDhcpErrorEvent(IpConnectivityLogClass.IpConnectivityEvent out, DhcpErrorEvent in) {
        IpConnectivityLogClass.DHCPEvent dhcpEvent = new IpConnectivityLogClass.DHCPEvent();
        dhcpEvent.setErrorCode(in.errorCode);
        out.setDhcpEvent(dhcpEvent);
    }

    private static void setDhcpClientEvent(IpConnectivityLogClass.IpConnectivityEvent out, DhcpClientEvent in) {
        IpConnectivityLogClass.DHCPEvent dhcpEvent = new IpConnectivityLogClass.DHCPEvent();
        dhcpEvent.setStateTransition(in.msg);
        dhcpEvent.durationMs = in.durationMs;
        out.setDhcpEvent(dhcpEvent);
    }

    private static void setIpManagerEvent(IpConnectivityLogClass.IpConnectivityEvent out, IpManagerEvent in) {
        IpConnectivityLogClass.IpProvisioningEvent ipProvisioningEvent = new IpConnectivityLogClass.IpProvisioningEvent();
        ipProvisioningEvent.eventType = in.eventType;
        ipProvisioningEvent.latencyMs = (int)in.durationMs;
        out.setIpProvisioningEvent(ipProvisioningEvent);
    }

    private static void setIpReachabilityEvent(IpConnectivityLogClass.IpConnectivityEvent out, IpReachabilityEvent in) {
        IpConnectivityLogClass.IpReachabilityEvent ipReachabilityEvent = new IpConnectivityLogClass.IpReachabilityEvent();
        ipReachabilityEvent.eventType = in.eventType;
        out.setIpReachabilityEvent(ipReachabilityEvent);
    }

    private static void setDefaultNetworkEvent(IpConnectivityLogClass.IpConnectivityEvent out, DefaultNetworkEvent in) {
        IpConnectivityLogClass.DefaultNetworkEvent defaultNetworkEvent = new IpConnectivityLogClass.DefaultNetworkEvent();
        defaultNetworkEvent.networkId = IpConnectivityEventBuilder.netIdOf(in.netId);
        defaultNetworkEvent.previousNetworkId = IpConnectivityEventBuilder.netIdOf(in.prevNetId);
        defaultNetworkEvent.transportTypes = in.transportTypes;
        defaultNetworkEvent.previousNetworkIpSupport = IpConnectivityEventBuilder.ipSupportOf(in);
        out.setDefaultNetworkEvent(defaultNetworkEvent);
    }

    private static void setNetworkEvent(IpConnectivityLogClass.IpConnectivityEvent out, NetworkEvent in) {
        IpConnectivityLogClass.NetworkEvent networkEvent = new IpConnectivityLogClass.NetworkEvent();
        networkEvent.networkId = IpConnectivityEventBuilder.netIdOf(in.netId);
        networkEvent.eventType = in.eventType;
        networkEvent.latencyMs = (int)in.durationMs;
        out.setNetworkEvent(networkEvent);
    }

    private static void setValidationProbeEvent(IpConnectivityLogClass.IpConnectivityEvent out, ValidationProbeEvent in) {
        IpConnectivityLogClass.ValidationProbeEvent validationProbeEvent = new IpConnectivityLogClass.ValidationProbeEvent();
        validationProbeEvent.latencyMs = (int)in.durationMs;
        validationProbeEvent.probeType = in.probeType;
        validationProbeEvent.probeResult = in.returnCode;
        out.setValidationProbeEvent(validationProbeEvent);
    }

    private static void setApfProgramEvent(IpConnectivityLogClass.IpConnectivityEvent out, ApfProgramEvent in) {
        IpConnectivityLogClass.ApfProgramEvent apfProgramEvent = new IpConnectivityLogClass.ApfProgramEvent();
        apfProgramEvent.lifetime = in.lifetime;
        apfProgramEvent.effectiveLifetime = in.actualLifetime;
        apfProgramEvent.filteredRas = in.filteredRas;
        apfProgramEvent.currentRas = in.currentRas;
        apfProgramEvent.programLength = in.programLength;
        if (IpConnectivityEventBuilder.isBitSet(in.flags, 0)) {
            apfProgramEvent.dropMulticast = true;
        }
        if (IpConnectivityEventBuilder.isBitSet(in.flags, 1)) {
            apfProgramEvent.hasIpv4Addr = true;
        }
        out.setApfProgramEvent(apfProgramEvent);
    }

    private static void setApfStats(IpConnectivityLogClass.IpConnectivityEvent out, ApfStats in) {
        IpConnectivityLogClass.ApfStatistics apfStatistics = new IpConnectivityLogClass.ApfStatistics();
        apfStatistics.durationMs = in.durationMs;
        apfStatistics.receivedRas = in.receivedRas;
        apfStatistics.matchingRas = in.matchingRas;
        apfStatistics.droppedRas = in.droppedRas;
        apfStatistics.zeroLifetimeRas = in.zeroLifetimeRas;
        apfStatistics.parseErrors = in.parseErrors;
        apfStatistics.programUpdates = in.programUpdates;
        apfStatistics.programUpdatesAll = in.programUpdatesAll;
        apfStatistics.programUpdatesAllowingMulticast = in.programUpdatesAllowingMulticast;
        apfStatistics.maxProgramSize = in.maxProgramSize;
        out.setApfStatistics(apfStatistics);
    }

    private static void setRaEvent(IpConnectivityLogClass.IpConnectivityEvent out, RaEvent in) {
        IpConnectivityLogClass.RaEvent raEvent = new IpConnectivityLogClass.RaEvent();
        raEvent.routerLifetime = in.routerLifetime;
        raEvent.prefixValidLifetime = in.prefixValidLifetime;
        raEvent.prefixPreferredLifetime = in.prefixPreferredLifetime;
        raEvent.routeInfoLifetime = in.routeInfoLifetime;
        raEvent.rdnssLifetime = in.rdnssLifetime;
        raEvent.dnsslLifetime = in.dnsslLifetime;
        out.setRaEvent(raEvent);
    }

    private static int[] bytesToInts(byte[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i] & 0xFF;
        }
        return out;
    }

    private static IpConnectivityLogClass.Pair[] toPairArray(SparseIntArray counts) {
        int s = counts.size();
        IpConnectivityLogClass.Pair[] pairs = new IpConnectivityLogClass.Pair[s];
        for (int i = 0; i < s; ++i) {
            IpConnectivityLogClass.Pair p = new IpConnectivityLogClass.Pair();
            p.key = counts.keyAt(i);
            p.value = counts.valueAt(i);
            pairs[i] = p;
        }
        return pairs;
    }

    private static IpConnectivityLogClass.NetworkId netIdOf(int netid) {
        IpConnectivityLogClass.NetworkId ni = new IpConnectivityLogClass.NetworkId();
        ni.networkId = netid;
        return ni;
    }

    private static int ipSupportOf(DefaultNetworkEvent in) {
        if (in.prevIPv4 && in.prevIPv6) {
            return 3;
        }
        if (in.prevIPv6) {
            return 2;
        }
        if (in.prevIPv4) {
            return 1;
        }
        return 0;
    }

    private static boolean isBitSet(int flags, int bit) {
        return (flags & 1 << bit) != 0;
    }

    private static void inferLinkLayer(IpConnectivityLogClass.IpConnectivityEvent ev) {
        int linkLayer = 0;
        if (ev.transports != 0L) {
            linkLayer = IpConnectivityEventBuilder.transportsToLinkLayer(ev.transports);
        } else if (ev.ifName != null) {
            linkLayer = IpConnectivityEventBuilder.ifnameToLinkLayer(ev.ifName);
        }
        if (linkLayer == 0) {
            return;
        }
        ev.linkLayer = linkLayer;
        ev.ifName = "";
    }

    private static int transportsToLinkLayer(long transports) {
        switch (Long.bitCount(transports)) {
            case 0: {
                return 0;
            }
            case 1: {
                int t = Long.numberOfTrailingZeros(transports);
                return IpConnectivityEventBuilder.transportToLinkLayer(t);
            }
        }
        return 6;
    }

    private static int transportToLinkLayer(int transport) {
        if (0 <= transport && transport < TRANSPORT_LINKLAYER_MAP.length) {
            return TRANSPORT_LINKLAYER_MAP[transport];
        }
        return 0;
    }

    private static int ifnameToLinkLayer(String ifname) {
        for (int i = 0; i < IFNAME_LINKLAYER_MAP.size(); ++i) {
            String pattern = IFNAME_LINKLAYER_MAP.valueAt(i);
            if (!ifname.startsWith(pattern)) continue;
            return IFNAME_LINKLAYER_MAP.keyAt(i);
        }
        return 0;
    }

    static {
        IpConnectivityEventBuilder.TRANSPORT_LINKLAYER_MAP[0] = 2;
        IpConnectivityEventBuilder.TRANSPORT_LINKLAYER_MAP[1] = 4;
        IpConnectivityEventBuilder.TRANSPORT_LINKLAYER_MAP[2] = 1;
        IpConnectivityEventBuilder.TRANSPORT_LINKLAYER_MAP[3] = 3;
        IpConnectivityEventBuilder.TRANSPORT_LINKLAYER_MAP[4] = 0;
        IpConnectivityEventBuilder.TRANSPORT_LINKLAYER_MAP[5] = 0;
        IFNAME_LINKLAYER_MAP = new SparseArray();
        IFNAME_LINKLAYER_MAP.put(2, "rmnet");
        IFNAME_LINKLAYER_MAP.put(4, "wlan");
        IFNAME_LINKLAYER_MAP.put(1, "bt-pan");
        IFNAME_LINKLAYER_MAP.put(3, "usb");
    }
}

