/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiPortInfo;
import android.hardware.hdmi.HdmiRecordSources;
import android.hardware.hdmi.HdmiTimerRecordSources;
import android.hardware.hdmi.IHdmiControlCallback;
import android.media.tv.TvInputInfo;
import android.media.tv.TvInputManager;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.hdmi.ActiveSourceHandler;
import com.android.server.hdmi.DelayedMessageBuffer;
import com.android.server.hdmi.DeviceDiscoveryAction;
import com.android.server.hdmi.DeviceSelectAction;
import com.android.server.hdmi.HdmiAnnotations;
import com.android.server.hdmi.HdmiCecKeycode;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiCecStandbyModeHandler;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.HotplugDetectionAction;
import com.android.server.hdmi.NewDeviceAction;
import com.android.server.hdmi.OneTouchRecordAction;
import com.android.server.hdmi.PowerStatusMonitorAction;
import com.android.server.hdmi.RequestArcInitiationAction;
import com.android.server.hdmi.RequestArcTerminationAction;
import com.android.server.hdmi.RoutingControlAction;
import com.android.server.hdmi.SelectRequestBuffer;
import com.android.server.hdmi.SetArcTransmissionStateAction;
import com.android.server.hdmi.SystemAudioActionFromAvr;
import com.android.server.hdmi.SystemAudioActionFromTv;
import com.android.server.hdmi.SystemAudioAutoInitiationAction;
import com.android.server.hdmi.SystemAudioStatusAction;
import com.android.server.hdmi.TimerRecordingAction;
import com.android.server.hdmi.VolumeControlAction;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

final class HdmiCecLocalDeviceTv
extends HdmiCecLocalDevice {
    private static final String TAG = "HdmiCecLocalDeviceTv";
    @HdmiAnnotations.ServiceThreadOnly
    private boolean mArcEstablished = false;
    private final SparseBooleanArray mArcFeatureEnabled = new SparseBooleanArray();
    @GuardedBy(value="mLock")
    private boolean mSystemAudioActivated = false;
    @GuardedBy(value="mLock")
    private boolean mSystemAudioControlFeatureEnabled;
    @GuardedBy(value="mLock")
    private int mPrevPortId = -1;
    @GuardedBy(value="mLock")
    private int mSystemAudioVolume = -1;
    @GuardedBy(value="mLock")
    private boolean mSystemAudioMute = false;
    @GuardedBy(value="mLock")
    private List<HdmiDeviceInfo> mSafeAllDeviceInfos = Collections.emptyList();
    @GuardedBy(value="mLock")
    private List<HdmiDeviceInfo> mSafeExternalInputs = Collections.emptyList();
    private final SparseArray<HdmiDeviceInfo> mDeviceInfos = new SparseArray();
    private boolean mAutoDeviceOff;
    private boolean mAutoWakeup;
    private List<Integer> mLocalDeviceAddresses;
    private final HdmiCecStandbyModeHandler mStandbyHandler;
    private boolean mSkipRoutingControl;
    private final ArraySet<Integer> mCecSwitches = new ArraySet();
    private final DelayedMessageBuffer mDelayedMessageBuffer = new DelayedMessageBuffer(this);
    private final TvInputManager.TvInputCallback mTvInputCallback = new TvInputManager.TvInputCallback(){

        @Override
        public void onInputAdded(String inputId) {
            TvInputInfo tvInfo = HdmiCecLocalDeviceTv.this.mService.getTvInputManager().getTvInputInfo(inputId);
            if (tvInfo == null) {
                return;
            }
            HdmiDeviceInfo info = tvInfo.getHdmiDeviceInfo();
            if (info == null) {
                return;
            }
            HdmiCecLocalDeviceTv.this.addTvInput(inputId, info.getId());
            if (info.isCecDevice()) {
                HdmiCecLocalDeviceTv.this.processDelayedActiveSource(info.getLogicalAddress());
            }
        }

        @Override
        public void onInputRemoved(String inputId) {
            HdmiCecLocalDeviceTv.this.removeTvInput(inputId);
        }
    };
    private final HashMap<String, Integer> mTvInputs = new HashMap();
    private SelectRequestBuffer mSelectRequestBuffer;

    @HdmiAnnotations.ServiceThreadOnly
    private void addTvInput(String inputId, int deviceId) {
        this.assertRunOnServiceThread();
        this.mTvInputs.put(inputId, deviceId);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void removeTvInput(String inputId) {
        this.assertRunOnServiceThread();
        this.mTvInputs.remove(inputId);
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean isInputReady(int deviceId) {
        this.assertRunOnServiceThread();
        return this.mTvInputs.containsValue(deviceId);
    }

    HdmiCecLocalDeviceTv(HdmiControlService service) {
        super(service, 0);
        this.mAutoDeviceOff = this.mService.readBooleanSetting("hdmi_control_auto_device_off_enabled", true);
        this.mAutoWakeup = this.mService.readBooleanSetting("hdmi_control_auto_wakeup_enabled", true);
        this.mSystemAudioControlFeatureEnabled = this.mService.readBooleanSetting("hdmi_system_audio_control_enabled", true);
        this.mStandbyHandler = new HdmiCecStandbyModeHandler(service, this);
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void onAddressAllocated(int logicalAddress, int reason) {
        this.assertRunOnServiceThread();
        List<HdmiPortInfo> ports = this.mService.getPortInfo();
        for (HdmiPortInfo port : ports) {
            this.mArcFeatureEnabled.put(port.getId(), port.isArcSupported());
        }
        this.mService.registerTvInputCallback(this.mTvInputCallback);
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildReportPhysicalAddressCommand(this.mAddress, this.mService.getPhysicalAddress(), this.mDeviceType));
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildDeviceVendorIdCommand(this.mAddress, this.mService.getVendorId()));
        this.mCecSwitches.add(this.mService.getPhysicalAddress());
        this.mTvInputs.clear();
        this.mSkipRoutingControl = reason == 3;
        this.launchRoutingControl(reason != 0 && reason != 1);
        this.mLocalDeviceAddresses = this.initLocalDeviceAddresses();
        this.resetSelectRequestBuffer();
        this.launchDeviceDiscovery();
    }

    @HdmiAnnotations.ServiceThreadOnly
    private List<Integer> initLocalDeviceAddresses() {
        this.assertRunOnServiceThread();
        ArrayList<Integer> addresses = new ArrayList<Integer>();
        for (HdmiCecLocalDevice device : this.mService.getAllLocalDevices()) {
            addresses.add(device.getDeviceInfo().getLogicalAddress());
        }
        return Collections.unmodifiableList(addresses);
    }

    @HdmiAnnotations.ServiceThreadOnly
    public void setSelectRequestBuffer(SelectRequestBuffer requestBuffer) {
        this.assertRunOnServiceThread();
        this.mSelectRequestBuffer = requestBuffer;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void resetSelectRequestBuffer() {
        this.assertRunOnServiceThread();
        this.setSelectRequestBuffer(SelectRequestBuffer.EMPTY_BUFFER);
    }

    @Override
    protected int getPreferredAddress() {
        return 0;
    }

    @Override
    protected void setPreferredAddress(int addr) {
        Slog.w(TAG, "Preferred addres will not be stored for TV");
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    boolean dispatchMessage(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.mService.isPowerStandby() && !this.mService.isWakeUpMessageReceived() && this.mStandbyHandler.handleCommand(message)) {
            return true;
        }
        return super.onMessage(message);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void deviceSelect(int id2, IHdmiControlCallback callback) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo targetDevice = this.mDeviceInfos.get(id2);
        if (targetDevice == null) {
            HdmiCecLocalDeviceTv.invokeCallback(callback, 3);
            return;
        }
        int targetAddress = targetDevice.getLogicalAddress();
        HdmiCecLocalDevice.ActiveSource active = this.getActiveSource();
        if (targetDevice.getDevicePowerStatus() == 0 && active.isValid() && targetAddress == active.logicalAddress) {
            HdmiCecLocalDeviceTv.invokeCallback(callback, 0);
            return;
        }
        if (targetAddress == 0) {
            this.handleSelectInternalSource();
            this.setActiveSource(targetAddress, this.mService.getPhysicalAddress());
            this.setActivePath(this.mService.getPhysicalAddress());
            HdmiCecLocalDeviceTv.invokeCallback(callback, 0);
            return;
        }
        if (!this.mService.isControlEnabled()) {
            this.setActiveSource(targetDevice);
            HdmiCecLocalDeviceTv.invokeCallback(callback, 6);
            return;
        }
        this.removeAction(DeviceSelectAction.class);
        this.addAndStartAction(new DeviceSelectAction(this, targetDevice, callback));
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void handleSelectInternalSource() {
        this.assertRunOnServiceThread();
        if (this.mService.isControlEnabled() && this.mActiveSource.logicalAddress != this.mAddress) {
            this.updateActiveSource(this.mAddress, this.mService.getPhysicalAddress());
            if (this.mSkipRoutingControl) {
                this.mSkipRoutingControl = false;
                return;
            }
            HdmiCecMessage activeSource = HdmiCecMessageBuilder.buildActiveSource(this.mAddress, this.mService.getPhysicalAddress());
            this.mService.sendCecCommand(activeSource);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void updateActiveSource(int logicalAddress, int physicalAddress) {
        this.assertRunOnServiceThread();
        this.updateActiveSource(HdmiCecLocalDevice.ActiveSource.of(logicalAddress, physicalAddress));
    }

    @HdmiAnnotations.ServiceThreadOnly
    void updateActiveSource(HdmiCecLocalDevice.ActiveSource newActive) {
        this.assertRunOnServiceThread();
        if (this.mActiveSource.equals(newActive)) {
            return;
        }
        this.setActiveSource(newActive);
        int logicalAddress = newActive.logicalAddress;
        if (this.getCecDeviceInfo(logicalAddress) != null && logicalAddress != this.mAddress && this.mService.pathToPortId(newActive.physicalAddress) == this.getActivePortId()) {
            this.setPrevPortId(this.getActivePortId());
        }
    }

    int getPortId(int physicalAddress) {
        return this.mService.pathToPortId(physicalAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPrevPortId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrevPortId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrevPortId(int portId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPrevPortId = portId;
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void updateActiveInput(int path, boolean notifyInputChange) {
        this.assertRunOnServiceThread();
        this.setActivePath(path);
        if (notifyInputChange) {
            HdmiCecLocalDevice.ActiveSource activeSource = this.getActiveSource();
            HdmiDeviceInfo info = this.getCecDeviceInfo(activeSource.logicalAddress);
            if (info == null && (info = this.mService.getDeviceInfoByPort(this.getActivePortId())) == null) {
                info = new HdmiDeviceInfo(path, this.getActivePortId());
            }
            this.mService.invokeInputChangeListener(info);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void doManualPortSwitching(int portId, IHdmiControlCallback callback) {
        this.assertRunOnServiceThread();
        if (!this.mService.isValidPortId(portId)) {
            HdmiCecLocalDeviceTv.invokeCallback(callback, 6);
            return;
        }
        if (portId == this.getActivePortId()) {
            HdmiCecLocalDeviceTv.invokeCallback(callback, 0);
            return;
        }
        this.mActiveSource.invalidate();
        if (!this.mService.isControlEnabled()) {
            this.setActivePortId(portId);
            HdmiCecLocalDeviceTv.invokeCallback(callback, 6);
            return;
        }
        int oldPath = this.getActivePortId() != -1 ? this.mService.portIdToPath(this.getActivePortId()) : this.getDeviceInfo().getPhysicalAddress();
        this.setActivePath(oldPath);
        if (this.mSkipRoutingControl) {
            this.mSkipRoutingControl = false;
            return;
        }
        int newPath = this.mService.portIdToPath(portId);
        this.startRoutingControl(oldPath, newPath, true, callback);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void startRoutingControl(int oldPath, int newPath, boolean queryDevicePowerStatus, IHdmiControlCallback callback) {
        this.assertRunOnServiceThread();
        if (oldPath == newPath) {
            return;
        }
        HdmiCecMessage routingChange = HdmiCecMessageBuilder.buildRoutingChange(this.mAddress, oldPath, newPath);
        this.mService.sendCecCommand(routingChange);
        this.removeAction(RoutingControlAction.class);
        this.addAndStartAction(new RoutingControlAction(this, newPath, queryDevicePowerStatus, callback));
    }

    @HdmiAnnotations.ServiceThreadOnly
    int getPowerStatus() {
        this.assertRunOnServiceThread();
        return this.mService.getPowerStatus();
    }

    @Override
    protected int findKeyReceiverAddress() {
        if (this.getActiveSource().isValid()) {
            return this.getActiveSource().logicalAddress;
        }
        HdmiDeviceInfo info = this.getDeviceInfoByPath(this.getActivePath());
        if (info != null) {
            return info.getLogicalAddress();
        }
        return -1;
    }

    private static void invokeCallback(IHdmiControlCallback callback, int result) {
        if (callback == null) {
            return;
        }
        try {
            callback.onComplete(result);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Invoking callback failed:" + e);
        }
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleActiveSource(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        int logicalAddress = message.getSource();
        int physicalAddress = HdmiUtils.twoBytesToInt(message.getParams());
        HdmiDeviceInfo info = this.getCecDeviceInfo(logicalAddress);
        if (info == null) {
            if (!this.handleNewDeviceAtTheTailOfActivePath(physicalAddress)) {
                HdmiLogger.debug("Device info %X not found; buffering the command", logicalAddress);
                this.mDelayedMessageBuffer.add(message);
            }
        } else if (this.isInputReady(info.getId()) || info.getDeviceType() == 5) {
            this.updateDevicePowerStatus(logicalAddress, 0);
            HdmiCecLocalDevice.ActiveSource activeSource = HdmiCecLocalDevice.ActiveSource.of(logicalAddress, physicalAddress);
            ActiveSourceHandler.create(this, null).process(activeSource, info.getDeviceType());
        } else {
            HdmiLogger.debug("Input not ready for device: %X; buffering the command", info.getId());
            this.mDelayedMessageBuffer.add(message);
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleInactiveSource(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.getActiveSource().logicalAddress != message.getSource()) {
            return true;
        }
        if (this.isProhibitMode()) {
            return true;
        }
        int portId = this.getPrevPortId();
        if (portId != -1) {
            HdmiDeviceInfo inactiveSource = this.getCecDeviceInfo(message.getSource());
            if (inactiveSource == null) {
                return true;
            }
            if (this.mService.pathToPortId(inactiveSource.getPhysicalAddress()) == portId) {
                return true;
            }
            this.doManualPortSwitching(portId, null);
            this.setPrevPortId(-1);
        } else {
            this.mActiveSource.invalidate();
            this.setActivePath(65535);
            this.mService.invokeInputChangeListener(HdmiDeviceInfo.INACTIVE_DEVICE);
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRequestActiveSource(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.mAddress == this.getActiveSource().logicalAddress) {
            this.mService.sendCecCommand(HdmiCecMessageBuilder.buildActiveSource(this.mAddress, this.getActivePath()));
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGetMenuLanguage(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.broadcastMenuLanguage(this.mService.getLanguage())) {
            Slog.w(TAG, "Failed to respond to <Get Menu Language>: " + message.toString());
        }
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean broadcastMenuLanguage(String language) {
        this.assertRunOnServiceThread();
        HdmiCecMessage command = HdmiCecMessageBuilder.buildSetMenuLanguageCommand(this.mAddress, language);
        if (command != null) {
            this.mService.sendCecCommand(command);
            return true;
        }
        return false;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleReportPhysicalAddress(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        int path = HdmiUtils.twoBytesToInt(message.getParams());
        int address = message.getSource();
        byte type = message.getParams()[2];
        if (this.updateCecSwitchInfo(address, type, path)) {
            return true;
        }
        if (this.hasAction(DeviceDiscoveryAction.class)) {
            Slog.i(TAG, "Ignored while Device Discovery Action is in progress: " + message);
            return true;
        }
        if (!this.isInDeviceList(address, path)) {
            this.handleNewDeviceAtTheTailOfActivePath(path);
        }
        HdmiDeviceInfo deviceInfo = new HdmiDeviceInfo(address, path, this.getPortId(path), type, 0xFFFFFF, HdmiUtils.getDefaultDeviceName(address));
        this.addCecDevice(deviceInfo);
        this.startNewDeviceAction(HdmiCecLocalDevice.ActiveSource.of(address, path), type);
        return true;
    }

    @Override
    protected boolean handleReportPowerStatus(HdmiCecMessage command) {
        int newStatus = command.getParams()[0] & 0xFF;
        this.updateDevicePowerStatus(command.getSource(), newStatus);
        return true;
    }

    @Override
    protected boolean handleTimerStatus(HdmiCecMessage message) {
        return true;
    }

    @Override
    protected boolean handleRecordStatus(HdmiCecMessage message) {
        return true;
    }

    boolean updateCecSwitchInfo(int address, int type, int path) {
        if (address == 15 && type == 6) {
            this.mCecSwitches.add(path);
            this.updateSafeDeviceInfoList();
            return true;
        }
        if (type == 5) {
            this.mCecSwitches.add(path);
        }
        return false;
    }

    void startNewDeviceAction(HdmiCecLocalDevice.ActiveSource activeSource, int deviceType) {
        for (NewDeviceAction action : this.getActions(NewDeviceAction.class)) {
            if (!action.isActionOf(activeSource)) continue;
            return;
        }
        this.addAndStartAction(new NewDeviceAction(this, activeSource.logicalAddress, activeSource.physicalAddress, deviceType));
    }

    private boolean handleNewDeviceAtTheTailOfActivePath(int path) {
        if (HdmiCecLocalDeviceTv.isTailOfActivePath(path, this.getActivePath())) {
            int newPath = this.mService.portIdToPath(this.getActivePortId());
            this.setActivePath(newPath);
            this.startRoutingControl(this.getActivePath(), newPath, false, null);
            return true;
        }
        return false;
    }

    static boolean isTailOfActivePath(int path, int activePath) {
        if (activePath == 0) {
            return false;
        }
        for (int i = 12; i >= 0; i -= 4) {
            int curActivePath = activePath >> i & 0xF;
            if (curActivePath == 0) {
                return true;
            }
            int curPath = path >> i & 0xF;
            if (curPath == curActivePath) continue;
            return false;
        }
        return false;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRoutingChange(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        byte[] params = message.getParams();
        int currentPath = HdmiUtils.twoBytesToInt(params);
        if (HdmiUtils.isAffectingActiveRoutingPath(this.getActivePath(), currentPath)) {
            this.mActiveSource.invalidate();
            this.removeAction(RoutingControlAction.class);
            int newPath = HdmiUtils.twoBytesToInt(params, 2);
            this.addAndStartAction(new RoutingControlAction(this, newPath, true, null));
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleReportAudioStatus(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        byte[] params = message.getParams();
        int mute = params[0] & 0x80;
        int volume = params[0] & 0x7F;
        this.setAudioStatus(mute == 128, volume);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleTextViewOn(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.mService.isPowerStandbyOrTransient() && this.mAutoWakeup) {
            this.mService.wakeUp();
        }
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleImageViewOn(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        return this.handleTextViewOn(message);
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSetOsdName(HdmiCecMessage message) {
        int source = message.getSource();
        HdmiDeviceInfo deviceInfo = this.getCecDeviceInfo(source);
        if (deviceInfo == null) {
            Slog.e(TAG, "No source device info for <Set Osd Name>." + message);
            return true;
        }
        String osdName = null;
        try {
            osdName = new String(message.getParams(), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            Slog.e(TAG, "Invalid <Set Osd Name> request:" + message, e);
            return true;
        }
        if (deviceInfo.getDisplayName().equals(osdName)) {
            Slog.i(TAG, "Ignore incoming <Set Osd Name> having same osd name:" + message);
            return true;
        }
        this.addCecDevice(new HdmiDeviceInfo(deviceInfo.getLogicalAddress(), deviceInfo.getPhysicalAddress(), deviceInfo.getPortId(), deviceInfo.getDeviceType(), deviceInfo.getVendorId(), osdName));
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void launchDeviceDiscovery() {
        this.assertRunOnServiceThread();
        this.clearDeviceInfoList();
        DeviceDiscoveryAction action = new DeviceDiscoveryAction(this, new DeviceDiscoveryAction.DeviceDiscoveryCallback(){

            @Override
            public void onDeviceDiscoveryDone(List<HdmiDeviceInfo> deviceInfos) {
                for (HdmiDeviceInfo info : deviceInfos) {
                    HdmiCecLocalDeviceTv.this.addCecDevice(info);
                }
                for (HdmiCecLocalDevice device : HdmiCecLocalDeviceTv.this.mService.getAllLocalDevices()) {
                    HdmiCecLocalDeviceTv.this.addCecDevice(device.getDeviceInfo());
                }
                HdmiCecLocalDeviceTv.this.mSelectRequestBuffer.process();
                HdmiCecLocalDeviceTv.this.resetSelectRequestBuffer();
                HdmiCecLocalDeviceTv.this.addAndStartAction(new HotplugDetectionAction(HdmiCecLocalDeviceTv.this));
                HdmiCecLocalDeviceTv.this.addAndStartAction(new PowerStatusMonitorAction(HdmiCecLocalDeviceTv.this));
                HdmiDeviceInfo avr = HdmiCecLocalDeviceTv.this.getAvrDeviceInfo();
                if (avr != null) {
                    HdmiCecLocalDeviceTv.this.onNewAvrAdded(avr);
                } else {
                    HdmiCecLocalDeviceTv.this.setSystemAudioMode(false);
                }
            }
        });
        this.addAndStartAction(action);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void onNewAvrAdded(HdmiDeviceInfo avr) {
        this.assertRunOnServiceThread();
        this.addAndStartAction(new SystemAudioAutoInitiationAction(this, avr.getLogicalAddress()));
        if (this.isConnected(avr.getPortId()) && this.isArcFeatureEnabled(avr.getPortId()) && !this.hasAction(SetArcTransmissionStateAction.class)) {
            this.startArcAction(true);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void clearDeviceInfoList() {
        this.assertRunOnServiceThread();
        for (HdmiDeviceInfo info : this.mSafeExternalInputs) {
            this.invokeDeviceEventListener(info, 2);
        }
        this.mDeviceInfos.clear();
        this.updateSafeDeviceInfoList();
    }

    @HdmiAnnotations.ServiceThreadOnly
    void changeSystemAudioMode(boolean enabled, IHdmiControlCallback callback) {
        this.assertRunOnServiceThread();
        if (!this.mService.isControlEnabled() || this.hasAction(DeviceDiscoveryAction.class)) {
            this.setSystemAudioMode(false);
            HdmiCecLocalDeviceTv.invokeCallback(callback, 6);
            return;
        }
        HdmiDeviceInfo avr = this.getAvrDeviceInfo();
        if (avr == null) {
            this.setSystemAudioMode(false);
            HdmiCecLocalDeviceTv.invokeCallback(callback, 3);
            return;
        }
        this.addAndStartAction(new SystemAudioActionFromTv(this, avr.getLogicalAddress(), enabled, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSystemAudioMode(boolean on) {
        if (!this.isSystemAudioControlFeatureEnabled() && on) {
            HdmiLogger.debug("Cannot turn on system audio mode because the System Audio Control feature is disabled.", new Object[0]);
            return;
        }
        HdmiLogger.debug("System Audio Mode change[old:%b new:%b]", this.mSystemAudioActivated, on);
        this.updateAudioManagerForSystemAudio(on);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSystemAudioActivated != on) {
                this.mSystemAudioActivated = on;
                this.mService.announceSystemAudioModeChange(on);
            }
        }
    }

    private void updateAudioManagerForSystemAudio(boolean on) {
        int device = this.mService.getAudioManager().setHdmiSystemAudioSupported(on);
        HdmiLogger.debug("[A]UpdateSystemAudio mode[on=%b] output=[%X]", on, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSystemAudioActivated() {
        if (!this.hasSystemAudioDevice()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.mSystemAudioActivated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    void setSystemAudioControlFeatureEnabled(boolean enabled) {
        this.assertRunOnServiceThread();
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemAudioControlFeatureEnabled = enabled;
        }
        if (this.hasSystemAudioDevice()) {
            this.changeSystemAudioMode(enabled, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSystemAudioControlFeatureEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSystemAudioControlFeatureEnabled;
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean setArcStatus(boolean enabled) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("Set Arc Status[old:%b new:%b]", this.mArcEstablished, enabled);
        boolean oldStatus = this.mArcEstablished;
        this.enableAudioReturnChannel(enabled);
        this.notifyArcStatusToAudioService(enabled);
        this.mArcEstablished = enabled;
        return oldStatus;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void enableAudioReturnChannel(boolean enabled) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo avr = this.getAvrDeviceInfo();
        if (avr != null) {
            this.mService.enableAudioReturnChannel(avr.getPortId(), enabled);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isConnected(int portId) {
        this.assertRunOnServiceThread();
        return this.mService.isConnected(portId);
    }

    private void notifyArcStatusToAudioService(boolean enabled) {
        this.mService.getAudioManager().setWiredDeviceConnectionState(262144, enabled ? 1 : 0, "", "");
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isArcEstablished() {
        this.assertRunOnServiceThread();
        if (this.mArcEstablished) {
            for (int i = 0; i < this.mArcFeatureEnabled.size(); ++i) {
                if (!this.mArcFeatureEnabled.valueAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void changeArcFeatureEnabled(int portId, boolean enabled) {
        this.assertRunOnServiceThread();
        if (this.mArcFeatureEnabled.get(portId) == enabled) {
            return;
        }
        this.mArcFeatureEnabled.put(portId, enabled);
        HdmiDeviceInfo avr = this.getAvrDeviceInfo();
        if (avr == null || avr.getPortId() != portId) {
            return;
        }
        if (enabled && !this.mArcEstablished) {
            this.startArcAction(true);
        } else if (!enabled && this.mArcEstablished) {
            this.startArcAction(false);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isArcFeatureEnabled(int portId) {
        this.assertRunOnServiceThread();
        return this.mArcFeatureEnabled.get(portId);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void startArcAction(boolean enabled) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo info = this.getAvrDeviceInfo();
        if (info == null) {
            Slog.w(TAG, "Failed to start arc action; No AVR device.");
            return;
        }
        if (!this.canStartArcUpdateAction(info.getLogicalAddress(), enabled)) {
            Slog.w(TAG, "Failed to start arc action; ARC configuration check failed.");
            if (enabled && !this.isConnectedToArcPort(info.getPhysicalAddress())) {
                this.displayOsd(1);
            }
            return;
        }
        if (enabled) {
            this.removeAction(RequestArcTerminationAction.class);
            if (!this.hasAction(RequestArcInitiationAction.class)) {
                this.addAndStartAction(new RequestArcInitiationAction(this, info.getLogicalAddress()));
            }
        } else {
            this.removeAction(RequestArcInitiationAction.class);
            if (!this.hasAction(RequestArcTerminationAction.class)) {
                this.addAndStartAction(new RequestArcTerminationAction(this, info.getLogicalAddress()));
            }
        }
    }

    private boolean isDirectConnectAddress(int physicalAddress) {
        return (physicalAddress & 0xF000) == physicalAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAudioStatus(boolean mute, int volume) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemAudioMute = mute;
            this.mSystemAudioVolume = volume;
            int maxVolume = this.mService.getAudioManager().getStreamMaxVolume(3);
            this.mService.setAudioStatus(mute, VolumeControlAction.scaleToCustomVolume(volume, maxVolume));
            this.displayOsd(2, mute ? 101 : volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    void changeVolume(int curVolume, int delta, int maxVolume) {
        this.assertRunOnServiceThread();
        if (delta == 0 || !this.isSystemAudioActivated()) {
            return;
        }
        int targetVolume = curVolume + delta;
        int cecVolume = VolumeControlAction.scaleToCecVolume(targetVolume, maxVolume);
        Object object = this.mLock;
        synchronized (object) {
            if (cecVolume == this.mSystemAudioVolume) {
                this.mService.setAudioStatus(false, VolumeControlAction.scaleToCustomVolume(this.mSystemAudioVolume, maxVolume));
                return;
            }
        }
        List<VolumeControlAction> actions = this.getActions(VolumeControlAction.class);
        if (actions.isEmpty()) {
            this.addAndStartAction(new VolumeControlAction(this, this.getAvrDeviceInfo().getLogicalAddress(), delta > 0));
        } else {
            actions.get(0).handleVolumeChange(delta > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    void changeMute(boolean mute) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("[A]:Change mute:%b", mute);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSystemAudioMute == mute) {
                HdmiLogger.debug("No need to change mute.", new Object[0]);
                return;
            }
        }
        if (!this.isSystemAudioActivated()) {
            HdmiLogger.debug("[A]:System audio is not activated.", new Object[0]);
            return;
        }
        this.removeAction(VolumeControlAction.class);
        this.sendUserControlPressedAndReleased(this.getAvrDeviceInfo().getLogicalAddress(), HdmiCecKeycode.getMuteKey(mute));
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleInitiateArc(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.canStartArcUpdateAction(message.getSource(), true)) {
            if (this.getAvrDeviceInfo() == null) {
                this.mDelayedMessageBuffer.add(message);
                return true;
            }
            this.mService.maySendFeatureAbortCommand(message, 4);
            if (!this.isConnectedToArcPort(message.getSource())) {
                this.displayOsd(1);
            }
            return true;
        }
        this.removeAction(RequestArcInitiationAction.class);
        SetArcTransmissionStateAction action = new SetArcTransmissionStateAction(this, message.getSource(), true);
        this.addAndStartAction(action);
        return true;
    }

    private boolean canStartArcUpdateAction(int avrAddress, boolean enabled) {
        HdmiDeviceInfo avr = this.getAvrDeviceInfo();
        if (avr != null && avrAddress == avr.getLogicalAddress() && this.isConnectedToArcPort(avr.getPhysicalAddress()) && this.isDirectConnectAddress(avr.getPhysicalAddress())) {
            if (enabled) {
                return this.isConnected(avr.getPortId()) && this.isArcFeatureEnabled(avr.getPortId());
            }
            return true;
        }
        return false;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleTerminateArc(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.mService.isPowerStandbyOrTransient()) {
            this.setArcStatus(false);
            return true;
        }
        this.removeAction(RequestArcTerminationAction.class);
        SetArcTransmissionStateAction action = new SetArcTransmissionStateAction(this, message.getSource(), false);
        this.addAndStartAction(action);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSetSystemAudioMode(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        boolean systemAudioStatus = HdmiUtils.parseCommandParamSystemAudioStatus(message);
        if (!this.isMessageForSystemAudio(message)) {
            if (this.getAvrDeviceInfo() == null) {
                this.mDelayedMessageBuffer.add(message);
            } else {
                HdmiLogger.warning("Invalid <Set System Audio Mode> message:" + message, new Object[0]);
                this.mService.maySendFeatureAbortCommand(message, 4);
            }
            return true;
        }
        if (systemAudioStatus && !this.isSystemAudioControlFeatureEnabled()) {
            HdmiLogger.debug("Ignoring <Set System Audio Mode> message because the System Audio Control feature is disabled: %s", message);
            this.mService.maySendFeatureAbortCommand(message, 4);
            return true;
        }
        this.removeAction(SystemAudioAutoInitiationAction.class);
        SystemAudioActionFromAvr action = new SystemAudioActionFromAvr(this, message.getSource(), systemAudioStatus, null);
        this.addAndStartAction(action);
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSystemAudioModeStatus(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.isMessageForSystemAudio(message)) {
            HdmiLogger.warning("Invalid <System Audio Mode Status> message:" + message, new Object[0]);
            return true;
        }
        this.setSystemAudioMode(HdmiUtils.parseCommandParamSystemAudioStatus(message));
        return true;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRecordTvScreen(HdmiCecMessage message) {
        byte[] recordSource;
        List<OneTouchRecordAction> actions = this.getActions(OneTouchRecordAction.class);
        if (!actions.isEmpty()) {
            OneTouchRecordAction action = actions.get(0);
            if (action.getRecorderAddress() != message.getSource()) {
                this.announceOneTouchRecordResult(message.getSource(), 48);
            }
            return super.handleRecordTvScreen(message);
        }
        int recorderAddress = message.getSource();
        int reason = this.startOneTouchRecord(recorderAddress, recordSource = this.mService.invokeRecordRequestListener(recorderAddress));
        if (reason != -1) {
            this.mService.maySendFeatureAbortCommand(message, reason);
        }
        return true;
    }

    @Override
    protected boolean handleTimerClearedStatus(HdmiCecMessage message) {
        byte[] params = message.getParams();
        int timerClearedStatusData = params[0] & 0xFF;
        this.announceTimerRecordingResult(message.getSource(), timerClearedStatusData);
        return true;
    }

    void announceOneTouchRecordResult(int recorderAddress, int result) {
        this.mService.invokeOneTouchRecordResult(recorderAddress, result);
    }

    void announceTimerRecordingResult(int recorderAddress, int result) {
        this.mService.invokeTimerRecordingResult(recorderAddress, result);
    }

    void announceClearTimerRecordingResult(int recorderAddress, int result) {
        this.mService.invokeClearTimerRecordingResult(recorderAddress, result);
    }

    private boolean isMessageForSystemAudio(HdmiCecMessage message) {
        return this.mService.isControlEnabled() && message.getSource() == 5 && (message.getDestination() == 0 || message.getDestination() == 15) && this.getAvrDeviceInfo() != null;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private HdmiDeviceInfo addDeviceInfo(HdmiDeviceInfo deviceInfo) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo oldDeviceInfo = this.getCecDeviceInfo(deviceInfo.getLogicalAddress());
        if (oldDeviceInfo != null) {
            this.removeDeviceInfo(deviceInfo.getId());
        }
        this.mDeviceInfos.append(deviceInfo.getId(), deviceInfo);
        this.updateSafeDeviceInfoList();
        return oldDeviceInfo;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private HdmiDeviceInfo removeDeviceInfo(int id2) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo deviceInfo = this.mDeviceInfos.get(id2);
        if (deviceInfo != null) {
            this.mDeviceInfos.remove(id2);
        }
        this.updateSafeDeviceInfoList();
        return deviceInfo;
    }

    @HdmiAnnotations.ServiceThreadOnly
    List<HdmiDeviceInfo> getDeviceInfoList(boolean includeLocalDevice) {
        this.assertRunOnServiceThread();
        if (includeLocalDevice) {
            return HdmiUtils.sparseArrayToList(this.mDeviceInfos);
        }
        ArrayList<HdmiDeviceInfo> infoList = new ArrayList<HdmiDeviceInfo>();
        for (int i = 0; i < this.mDeviceInfos.size(); ++i) {
            HdmiDeviceInfo info = this.mDeviceInfos.valueAt(i);
            if (this.isLocalDeviceAddress(info.getLogicalAddress())) continue;
            infoList.add(info);
        }
        return infoList;
    }

    List<HdmiDeviceInfo> getSafeExternalInputsLocked() {
        return this.mSafeExternalInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    private void updateSafeDeviceInfoList() {
        this.assertRunOnServiceThread();
        List<HdmiDeviceInfo> copiedDevices = HdmiUtils.sparseArrayToList(this.mDeviceInfos);
        List<HdmiDeviceInfo> externalInputs = this.getInputDevices();
        Object object = this.mLock;
        synchronized (object) {
            this.mSafeAllDeviceInfos = copiedDevices;
            this.mSafeExternalInputs = externalInputs;
        }
    }

    private List<HdmiDeviceInfo> getInputDevices() {
        ArrayList<HdmiDeviceInfo> infoList = new ArrayList<HdmiDeviceInfo>();
        for (int i = 0; i < this.mDeviceInfos.size(); ++i) {
            HdmiDeviceInfo info = this.mDeviceInfos.valueAt(i);
            if (this.isLocalDeviceAddress(info.getLogicalAddress()) || !info.isSourceType() || this.hideDevicesBehindLegacySwitch(info)) continue;
            infoList.add(info);
        }
        return infoList;
    }

    private boolean hideDevicesBehindLegacySwitch(HdmiDeviceInfo info) {
        return !HdmiCecLocalDeviceTv.isConnectedToCecSwitch(info.getPhysicalAddress(), this.mCecSwitches);
    }

    private static boolean isConnectedToCecSwitch(int path, Collection<Integer> switches) {
        for (int switchPath : switches) {
            if (!HdmiCecLocalDeviceTv.isParentPath(switchPath, path)) continue;
            return true;
        }
        return false;
    }

    private static boolean isParentPath(int parentPath, int childPath) {
        for (int i = 0; i <= 12; i += 4) {
            int nibble = childPath >> i & 0xF;
            if (nibble == 0) continue;
            int parentNibble = parentPath >> i & 0xF;
            return parentNibble == 0 && childPath >> i + 4 == parentPath >> i + 4;
        }
        return false;
    }

    private void invokeDeviceEventListener(HdmiDeviceInfo info, int status) {
        if (!this.hideDevicesBehindLegacySwitch(info)) {
            this.mService.invokeDeviceEventListeners(info, status);
        }
    }

    private boolean isLocalDeviceAddress(int address) {
        return this.mLocalDeviceAddresses.contains(address);
    }

    @HdmiAnnotations.ServiceThreadOnly
    HdmiDeviceInfo getAvrDeviceInfo() {
        this.assertRunOnServiceThread();
        return this.getCecDeviceInfo(5);
    }

    @HdmiAnnotations.ServiceThreadOnly
    HdmiDeviceInfo getCecDeviceInfo(int logicalAddress) {
        this.assertRunOnServiceThread();
        return this.mDeviceInfos.get(HdmiDeviceInfo.idForCecDevice(logicalAddress));
    }

    boolean hasSystemAudioDevice() {
        return this.getSafeAvrDeviceInfo() != null;
    }

    HdmiDeviceInfo getSafeAvrDeviceInfo() {
        return this.getSafeCecDeviceInfo(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdmiDeviceInfo getSafeCecDeviceInfo(int logicalAddress) {
        Object object = this.mLock;
        synchronized (object) {
            for (HdmiDeviceInfo info : this.mSafeAllDeviceInfos) {
                if (!info.isCecDevice() || info.getLogicalAddress() != logicalAddress) continue;
                return info;
            }
            return null;
        }
    }

    List<HdmiDeviceInfo> getSafeCecDevicesLocked() {
        ArrayList<HdmiDeviceInfo> infoList = new ArrayList<HdmiDeviceInfo>();
        for (HdmiDeviceInfo info : this.mSafeAllDeviceInfos) {
            if (this.isLocalDeviceAddress(info.getLogicalAddress())) continue;
            infoList.add(info);
        }
        return infoList;
    }

    @HdmiAnnotations.ServiceThreadOnly
    final void addCecDevice(HdmiDeviceInfo info) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo old = this.addDeviceInfo(info);
        if (info.getLogicalAddress() == this.mAddress) {
            return;
        }
        if (old == null) {
            this.invokeDeviceEventListener(info, 1);
        } else if (!old.equals(info)) {
            this.invokeDeviceEventListener(old, 2);
            this.invokeDeviceEventListener(info, 1);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    final void removeCecDevice(int address) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo info = this.removeDeviceInfo(HdmiDeviceInfo.idForCecDevice(address));
        this.mCecMessageCache.flushMessagesFrom(address);
        this.invokeDeviceEventListener(info, 2);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void handleRemoveActiveRoutingPath(int path) {
        this.assertRunOnServiceThread();
        if (HdmiCecLocalDeviceTv.isTailOfActivePath(path, this.getActivePath())) {
            int newPath = this.mService.portIdToPath(this.getActivePortId());
            this.startRoutingControl(this.getActivePath(), newPath, true, null);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void launchRoutingControl(boolean routingForBootup) {
        this.assertRunOnServiceThread();
        if (this.getActivePortId() != -1) {
            if (!routingForBootup && !this.isProhibitMode()) {
                int newPath = this.mService.portIdToPath(this.getActivePortId());
                this.setActivePath(newPath);
                this.startRoutingControl(this.getActivePath(), newPath, routingForBootup, null);
            }
        } else {
            int activePath = this.mService.getPhysicalAddress();
            this.setActivePath(activePath);
            if (!routingForBootup && !this.mDelayedMessageBuffer.isBuffered(130)) {
                this.mService.sendCecCommand(HdmiCecMessageBuilder.buildActiveSource(this.mAddress, activePath));
            }
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    final HdmiDeviceInfo getDeviceInfoByPath(int path) {
        this.assertRunOnServiceThread();
        for (HdmiDeviceInfo info : this.getDeviceInfoList(false)) {
            if (info.getPhysicalAddress() != path) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdmiDeviceInfo getSafeDeviceInfoByPath(int path) {
        Object object = this.mLock;
        synchronized (object) {
            for (HdmiDeviceInfo info : this.mSafeAllDeviceInfos) {
                if (info.getPhysicalAddress() != path) continue;
                return info;
            }
            return null;
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isInDeviceList(int logicalAddress, int physicalAddress) {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo device = this.getCecDeviceInfo(logicalAddress);
        if (device == null) {
            return false;
        }
        return device.getPhysicalAddress() == physicalAddress;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    void onHotplug(int portId, boolean connected) {
        List<HotplugDetectionAction> hotplugActions;
        this.assertRunOnServiceThread();
        if (!connected) {
            this.removeCecSwitches(portId);
        }
        if (!(hotplugActions = this.getActions(HotplugDetectionAction.class)).isEmpty()) {
            hotplugActions.get(0).pollAllDevicesNow();
        }
    }

    private void removeCecSwitches(int portId) {
        Iterator<Integer> it = this.mCecSwitches.iterator();
        while (!it.hasNext()) {
            int path = it.next();
            if (this.pathToPortId(path) != portId) continue;
            it.remove();
        }
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    void setAutoDeviceOff(boolean enabled) {
        this.assertRunOnServiceThread();
        this.mAutoDeviceOff = enabled;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setAutoWakeup(boolean enabled) {
        this.assertRunOnServiceThread();
        this.mAutoWakeup = enabled;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean getAutoWakeup() {
        this.assertRunOnServiceThread();
        return this.mAutoWakeup;
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void disableDevice(boolean initiatedByCec, HdmiCecLocalDevice.PendingActionClearedCallback callback) {
        this.assertRunOnServiceThread();
        this.mService.unregisterTvInputCallback(this.mTvInputCallback);
        this.removeAction(DeviceDiscoveryAction.class);
        this.removeAction(HotplugDetectionAction.class);
        this.removeAction(PowerStatusMonitorAction.class);
        this.removeAction(OneTouchRecordAction.class);
        this.removeAction(TimerRecordingAction.class);
        this.disableSystemAudioIfExist();
        this.disableArcIfExist();
        super.disableDevice(initiatedByCec, callback);
        this.clearDeviceInfoList();
        this.getActiveSource().invalidate();
        this.setActivePath(65535);
        this.checkIfPendingActionsCleared();
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void disableSystemAudioIfExist() {
        this.assertRunOnServiceThread();
        if (this.getAvrDeviceInfo() == null) {
            return;
        }
        this.removeAction(SystemAudioActionFromAvr.class);
        this.removeAction(SystemAudioActionFromTv.class);
        this.removeAction(SystemAudioAutoInitiationAction.class);
        this.removeAction(SystemAudioStatusAction.class);
        this.removeAction(VolumeControlAction.class);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void disableArcIfExist() {
        this.assertRunOnServiceThread();
        HdmiDeviceInfo avr = this.getAvrDeviceInfo();
        if (avr == null) {
            return;
        }
        this.removeAction(RequestArcInitiationAction.class);
        if (!this.hasAction(RequestArcTerminationAction.class) && this.isArcEstablished()) {
            this.addAndStartAction(new RequestArcTerminationAction(this, avr.getLogicalAddress()));
        }
    }

    @Override
    @HdmiAnnotations.ServiceThreadOnly
    protected void onStandby(boolean initiatedByCec, int standbyAction) {
        this.assertRunOnServiceThread();
        if (!this.mService.isControlEnabled()) {
            return;
        }
        if (!initiatedByCec && this.mAutoDeviceOff) {
            this.mService.sendCecCommand(HdmiCecMessageBuilder.buildStandby(this.mAddress, 15));
        }
    }

    boolean isProhibitMode() {
        return this.mService.isProhibitMode();
    }

    boolean isPowerStandbyOrTransient() {
        return this.mService.isPowerStandbyOrTransient();
    }

    @HdmiAnnotations.ServiceThreadOnly
    void displayOsd(int messageId) {
        this.assertRunOnServiceThread();
        this.mService.displayOsd(messageId);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void displayOsd(int messageId, int extra) {
        this.assertRunOnServiceThread();
        this.mService.displayOsd(messageId, extra);
    }

    @HdmiAnnotations.ServiceThreadOnly
    int startOneTouchRecord(int recorderAddress, byte[] recordSource) {
        this.assertRunOnServiceThread();
        if (!this.mService.isControlEnabled()) {
            Slog.w(TAG, "Can not start one touch record. CEC control is disabled.");
            this.announceOneTouchRecordResult(recorderAddress, 51);
            return 1;
        }
        if (!this.checkRecorder(recorderAddress)) {
            Slog.w(TAG, "Invalid recorder address:" + recorderAddress);
            this.announceOneTouchRecordResult(recorderAddress, 49);
            return 1;
        }
        if (!this.checkRecordSource(recordSource)) {
            Slog.w(TAG, "Invalid record source." + Arrays.toString(recordSource));
            this.announceOneTouchRecordResult(recorderAddress, 50);
            return 2;
        }
        this.addAndStartAction(new OneTouchRecordAction(this, recorderAddress, recordSource));
        Slog.i(TAG, "Start new [One Touch Record]-Target:" + recorderAddress + ", recordSource:" + Arrays.toString(recordSource));
        return -1;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void stopOneTouchRecord(int recorderAddress) {
        this.assertRunOnServiceThread();
        if (!this.mService.isControlEnabled()) {
            Slog.w(TAG, "Can not stop one touch record. CEC control is disabled.");
            this.announceOneTouchRecordResult(recorderAddress, 51);
            return;
        }
        if (!this.checkRecorder(recorderAddress)) {
            Slog.w(TAG, "Invalid recorder address:" + recorderAddress);
            this.announceOneTouchRecordResult(recorderAddress, 49);
            return;
        }
        this.removeAction(OneTouchRecordAction.class);
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildRecordOff(this.mAddress, recorderAddress));
        Slog.i(TAG, "Stop [One Touch Record]-Target:" + recorderAddress);
    }

    private boolean checkRecorder(int recorderAddress) {
        HdmiDeviceInfo device = this.getCecDeviceInfo(recorderAddress);
        return device != null && HdmiUtils.getTypeFromAddress(recorderAddress) == 1;
    }

    private boolean checkRecordSource(byte[] recordSource) {
        return recordSource != null && HdmiRecordSources.checkRecordSource(recordSource);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void startTimerRecording(int recorderAddress, int sourceType, byte[] recordSource) {
        this.assertRunOnServiceThread();
        if (!this.mService.isControlEnabled()) {
            Slog.w(TAG, "Can not start one touch record. CEC control is disabled.");
            this.announceTimerRecordingResult(recorderAddress, 3);
            return;
        }
        if (!this.checkRecorder(recorderAddress)) {
            Slog.w(TAG, "Invalid recorder address:" + recorderAddress);
            this.announceTimerRecordingResult(recorderAddress, 1);
            return;
        }
        if (!this.checkTimerRecordingSource(sourceType, recordSource)) {
            Slog.w(TAG, "Invalid record source." + Arrays.toString(recordSource));
            this.announceTimerRecordingResult(recorderAddress, 2);
            return;
        }
        this.addAndStartAction(new TimerRecordingAction(this, recorderAddress, sourceType, recordSource));
        Slog.i(TAG, "Start [Timer Recording]-Target:" + recorderAddress + ", SourceType:" + sourceType + ", RecordSource:" + Arrays.toString(recordSource));
    }

    private boolean checkTimerRecordingSource(int sourceType, byte[] recordSource) {
        return recordSource != null && HdmiTimerRecordSources.checkTimerRecordSource(sourceType, recordSource);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void clearTimerRecording(int recorderAddress, int sourceType, byte[] recordSource) {
        this.assertRunOnServiceThread();
        if (!this.mService.isControlEnabled()) {
            Slog.w(TAG, "Can not start one touch record. CEC control is disabled.");
            this.announceClearTimerRecordingResult(recorderAddress, 162);
            return;
        }
        if (!this.checkRecorder(recorderAddress)) {
            Slog.w(TAG, "Invalid recorder address:" + recorderAddress);
            this.announceClearTimerRecordingResult(recorderAddress, 160);
            return;
        }
        if (!this.checkTimerRecordingSource(sourceType, recordSource)) {
            Slog.w(TAG, "Invalid record source." + Arrays.toString(recordSource));
            this.announceClearTimerRecordingResult(recorderAddress, 161);
            return;
        }
        this.sendClearTimerMessage(recorderAddress, sourceType, recordSource);
    }

    private void sendClearTimerMessage(final int recorderAddress, int sourceType, byte[] recordSource) {
        HdmiCecMessage message = null;
        switch (sourceType) {
            case 1: {
                message = HdmiCecMessageBuilder.buildClearDigitalTimer(this.mAddress, recorderAddress, recordSource);
                break;
            }
            case 2: {
                message = HdmiCecMessageBuilder.buildClearAnalogueTimer(this.mAddress, recorderAddress, recordSource);
                break;
            }
            case 3: {
                message = HdmiCecMessageBuilder.buildClearExternalTimer(this.mAddress, recorderAddress, recordSource);
                break;
            }
            default: {
                Slog.w(TAG, "Invalid source type:" + recorderAddress);
                this.announceClearTimerRecordingResult(recorderAddress, 161);
                return;
            }
        }
        this.mService.sendCecCommand(message, new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    HdmiCecLocalDeviceTv.this.announceClearTimerRecordingResult(recorderAddress, 161);
                }
            }
        });
    }

    void updateDevicePowerStatus(int logicalAddress, int newPowerStatus) {
        HdmiDeviceInfo info = this.getCecDeviceInfo(logicalAddress);
        if (info == null) {
            Slog.w(TAG, "Can not update power status of non-existing device:" + logicalAddress);
            return;
        }
        if (info.getDevicePowerStatus() == newPowerStatus) {
            return;
        }
        HdmiDeviceInfo newInfo = HdmiUtils.cloneHdmiDeviceInfo(info, newPowerStatus);
        this.addDeviceInfo(newInfo);
        this.invokeDeviceEventListener(newInfo, 3);
    }

    @Override
    protected boolean handleMenuStatus(HdmiCecMessage message) {
        return true;
    }

    @Override
    protected void sendStandby(int deviceId) {
        HdmiDeviceInfo targetDevice = this.mDeviceInfos.get(deviceId);
        if (targetDevice == null) {
            return;
        }
        int targetAddress = targetDevice.getLogicalAddress();
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildStandby(this.mAddress, targetAddress));
    }

    @HdmiAnnotations.ServiceThreadOnly
    void processAllDelayedMessages() {
        this.assertRunOnServiceThread();
        this.mDelayedMessageBuffer.processAllMessages();
    }

    @HdmiAnnotations.ServiceThreadOnly
    void processDelayedMessages(int address) {
        this.assertRunOnServiceThread();
        this.mDelayedMessageBuffer.processMessagesForDevice(address);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void processDelayedActiveSource(int address) {
        this.assertRunOnServiceThread();
        this.mDelayedMessageBuffer.processActiveSource(address);
    }

    @Override
    protected void dump(IndentingPrintWriter pw) {
        super.dump(pw);
        pw.println("mArcEstablished: " + this.mArcEstablished);
        pw.println("mArcFeatureEnabled: " + this.mArcFeatureEnabled);
        pw.println("mSystemAudioActivated: " + this.mSystemAudioActivated);
        pw.println("mSystemAudioMute: " + this.mSystemAudioMute);
        pw.println("mSystemAudioControlFeatureEnabled: " + this.mSystemAudioControlFeatureEnabled);
        pw.println("mAutoDeviceOff: " + this.mAutoDeviceOff);
        pw.println("mAutoWakeup: " + this.mAutoWakeup);
        pw.println("mSkipRoutingControl: " + this.mSkipRoutingControl);
        pw.println("mPrevPortId: " + this.mPrevPortId);
        pw.println("CEC devices:");
        pw.increaseIndent();
        for (HdmiDeviceInfo info : this.mSafeAllDeviceInfos) {
            pw.println(info);
        }
        pw.decreaseIndent();
    }
}

