/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetworkPolicyListener;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkPolicyManager;
import android.os.UserHandle;
import android.util.ArraySet;
import com.android.internal.annotations.GuardedBy;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;

public final class ConnectivityController
extends StateController
implements ConnectivityManager.OnNetworkActiveListener {
    private static final String TAG = "JobScheduler.Conn";
    private static final boolean DEBUG = false;
    private final ConnectivityManager mConnManager;
    private final NetworkPolicyManager mNetPolicyManager;
    private boolean mConnected = false;
    private boolean mValidated = false;
    @GuardedBy(value="mLock")
    private final ArraySet<JobStatus> mTrackedJobs = new ArraySet();
    private static ConnectivityController mSingleton;
    private static Object sCreationLock;
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            ConnectivityController.this.updateTrackedJobs(-1, networkCapabilities);
        }

        @Override
        public void onLost(Network network) {
            ConnectivityController.this.updateTrackedJobs(-1, null);
        }
    };
    private final INetworkPolicyListener mNetPolicyListener = new INetworkPolicyListener.Stub(){

        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            ConnectivityController.this.updateTrackedJobs(uid, null);
        }

        @Override
        public void onMeteredIfacesChanged(String[] meteredIfaces) {
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            ConnectivityController.this.updateTrackedJobs(-1, null);
        }

        @Override
        public void onUidPoliciesChanged(int uid, int uidPolicies) {
            ConnectivityController.this.updateTrackedJobs(uid, null);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectivityController get(JobSchedulerService jms) {
        Object object = sCreationLock;
        synchronized (object) {
            if (mSingleton == null) {
                mSingleton = new ConnectivityController(jms, jms.getContext(), jms.getLock());
            }
            return mSingleton;
        }
    }

    private ConnectivityController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.mConnManager = this.mContext.getSystemService(ConnectivityManager.class);
        this.mNetPolicyManager = this.mContext.getSystemService(NetworkPolicyManager.class);
        this.mConnManager.registerDefaultNetworkCallback(this.mNetworkCallback);
        this.mNetPolicyManager.registerListener(this.mNetPolicyListener);
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        if (jobStatus.hasConnectivityConstraint()) {
            this.updateConstraintsSatisfied(jobStatus, null);
            this.mTrackedJobs.add(jobStatus);
            jobStatus.setTrackingController(2);
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean forUpdate) {
        if (jobStatus.clearTrackingController(2)) {
            this.mTrackedJobs.remove(jobStatus);
        }
    }

    private boolean updateConstraintsSatisfied(JobStatus jobStatus, NetworkCapabilities capabilities) {
        int jobUid = jobStatus.getSourceUid();
        boolean ignoreBlocked = (jobStatus.getFlags() & 1) != 0;
        NetworkInfo info = this.mConnManager.getActiveNetworkInfoForUid(jobUid, ignoreBlocked);
        if (capabilities == null) {
            Network network = this.mConnManager.getActiveNetworkForUid(jobUid, ignoreBlocked);
            capabilities = this.mConnManager.getNetworkCapabilities(network);
        }
        boolean validated = capabilities != null && capabilities.hasCapability(16);
        boolean connected = info != null && info.isConnected();
        boolean connectionUsable = connected && validated;
        boolean metered = connected && info.isMetered();
        boolean unmetered = connected && !info.isMetered();
        boolean notRoaming = connected && !info.isRoaming();
        boolean changed = false;
        changed |= jobStatus.setConnectivityConstraintSatisfied(connectionUsable);
        changed |= jobStatus.setMeteredConstraintSatisfied(metered);
        changed |= jobStatus.setUnmeteredConstraintSatisfied(unmetered);
        changed |= jobStatus.setNotRoamingConstraintSatisfied(notRoaming);
        if (jobUid == 1000) {
            this.mConnected = connected;
            this.mValidated = validated;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTrackedJobs(int uid, NetworkCapabilities capabilities) {
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                JobStatus js = this.mTrackedJobs.valueAt(i);
                if (uid != -1 && uid != js.getSourceUid()) continue;
                changed |= this.updateConstraintsSatisfied(js, capabilities);
            }
            if (changed) {
                this.mStateChangedListener.onControllerStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNetworkActive() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mTrackedJobs.size() - 1; i >= 0; --i) {
                JobStatus js = this.mTrackedJobs.valueAt(i);
                if (!js.isReady()) continue;
                this.mStateChangedListener.onRunJobNow(js);
            }
        }
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.print("Connectivity: connected=");
        pw.print(this.mConnected);
        pw.print(" validated=");
        pw.println(this.mValidated);
        pw.print("Tracking ");
        pw.print(this.mTrackedJobs.size());
        pw.println(":");
        for (int i = 0; i < this.mTrackedJobs.size(); ++i) {
            JobStatus js = this.mTrackedJobs.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            pw.print("  #");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.print(": C=");
            pw.print(js.needsAnyConnectivity());
            pw.print(": M=");
            pw.print(js.needsMeteredConnectivity());
            pw.print(": UM=");
            pw.print(js.needsUnmeteredConnectivity());
            pw.print(": NR=");
            pw.println(js.needsNonRoamingConnectivity());
        }
    }

    static {
        sCreationLock = new Object();
    }
}

