/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.UserHandle;
import android.util.ArraySet;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;

public final class StorageController
extends StateController {
    private static final String TAG = "JobScheduler.Stor";
    private static final Object sCreationLock = new Object();
    private static volatile StorageController sController;
    private final ArraySet<JobStatus> mTrackedTasks = new ArraySet();
    private StorageTracker mStorageTracker = new StorageTracker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageController get(JobSchedulerService taskManagerService) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new StorageController(taskManagerService, taskManagerService.getContext(), taskManagerService.getLock());
            }
        }
        return sController;
    }

    public StorageTracker getTracker() {
        return this.mStorageTracker;
    }

    public static StorageController getForTesting(StateChangedListener stateChangedListener, Context context) {
        return new StorageController(stateChangedListener, context, new Object());
    }

    private StorageController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.mStorageTracker.startTracking();
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus taskStatus, JobStatus lastJob) {
        if (taskStatus.hasStorageNotLowConstraint()) {
            this.mTrackedTasks.add(taskStatus);
            taskStatus.setTrackingController(16);
            taskStatus.setStorageNotLowConstraintSatisfied(this.mStorageTracker.isStorageNotLow());
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus taskStatus, JobStatus incomingJob, boolean forUpdate) {
        if (taskStatus.clearTrackingController(16)) {
            this.mTrackedTasks.remove(taskStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReportNewStorageState() {
        boolean storageNotLow = this.mStorageTracker.isStorageNotLow();
        boolean reportChange = false;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mTrackedTasks.size() - 1; i >= 0; --i) {
                JobStatus ts = this.mTrackedTasks.valueAt(i);
                boolean previous = ts.setStorageNotLowConstraintSatisfied(storageNotLow);
                if (previous == storageNotLow) continue;
                reportChange = true;
            }
        }
        if (reportChange) {
            this.mStateChangedListener.onControllerStateChanged();
        }
        if (storageNotLow) {
            this.mStateChangedListener.onRunJobNow(null);
        }
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        pw.print("Storage: not low = ");
        pw.print(this.mStorageTracker.isStorageNotLow());
        pw.print(", seq=");
        pw.println(this.mStorageTracker.getSeq());
        pw.print("Tracking ");
        pw.print(this.mTrackedTasks.size());
        pw.println(":");
        for (int i = 0; i < this.mTrackedTasks.size(); ++i) {
            JobStatus js = this.mTrackedTasks.valueAt(i);
            if (!js.shouldDump(filterUid)) continue;
            pw.print("  #");
            js.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, js.getSourceUid());
            pw.println();
        }
    }

    public final class StorageTracker
    extends BroadcastReceiver {
        private boolean mStorageLow;
        private int mLastBatterySeq = -1;

        public void startTracking() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.DEVICE_STORAGE_LOW");
            filter.addAction("android.intent.action.DEVICE_STORAGE_OK");
            StorageController.this.mContext.registerReceiver(this, filter);
        }

        public boolean isStorageNotLow() {
            return !this.mStorageLow;
        }

        public int getSeq() {
            return this.mLastBatterySeq;
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.onReceiveInternal(intent);
        }

        public void onReceiveInternal(Intent intent) {
            String action = intent.getAction();
            this.mLastBatterySeq = intent.getIntExtra("seq", this.mLastBatterySeq);
            if ("android.intent.action.DEVICE_STORAGE_LOW".equals(action)) {
                this.mStorageLow = true;
            } else if ("android.intent.action.DEVICE_STORAGE_OK".equals(action)) {
                this.mStorageLow = false;
                StorageController.this.maybeReportNewStorageState();
            }
        }
    }
}

