/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.AlarmManager;
import android.content.Context;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.TimeUtils;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class TimeController
extends StateController {
    private static final String TAG = "JobScheduler.Time";
    private final String DEADLINE_TAG = "*job.deadline*";
    private final String DELAY_TAG = "*job.delay*";
    private long mNextJobExpiredElapsedMillis;
    private long mNextDelayExpiredElapsedMillis;
    private AlarmManager mAlarmService = null;
    private final List<JobStatus> mTrackedJobs = new LinkedList<JobStatus>();
    private static TimeController mSingleton;
    private final AlarmManager.OnAlarmListener mDeadlineExpiredListener = new AlarmManager.OnAlarmListener(){

        @Override
        public void onAlarm() {
            TimeController.this.checkExpiredDeadlinesAndResetAlarm();
        }
    };
    private final AlarmManager.OnAlarmListener mNextDelayExpiredListener = new AlarmManager.OnAlarmListener(){

        @Override
        public void onAlarm() {
            TimeController.this.checkExpiredDelaysAndResetAlarm();
        }
    };

    public static synchronized TimeController get(JobSchedulerService jms) {
        if (mSingleton == null) {
            mSingleton = new TimeController(jms, jms.getContext(), jms.getLock());
        }
        return mSingleton;
    }

    private TimeController(StateChangedListener stateChangedListener, Context context, Object lock) {
        super(stateChangedListener, context, lock);
        this.mNextJobExpiredElapsedMillis = Long.MAX_VALUE;
        this.mNextDelayExpiredElapsedMillis = Long.MAX_VALUE;
    }

    @Override
    public void maybeStartTrackingJobLocked(JobStatus job, JobStatus lastJob) {
        if (job.hasTimingDelayConstraint() || job.hasDeadlineConstraint()) {
            this.maybeStopTrackingJobLocked(job, null, false);
            long nowElapsedMillis = SystemClock.elapsedRealtime();
            if (job.hasDeadlineConstraint() && this.evaluateDeadlineConstraint(job, nowElapsedMillis)) {
                return;
            }
            if (job.hasTimingDelayConstraint() && this.evaluateTimingDelayConstraint(job, nowElapsedMillis)) {
                return;
            }
            boolean isInsert = false;
            ListIterator<JobStatus> it = this.mTrackedJobs.listIterator(this.mTrackedJobs.size());
            while (it.hasPrevious()) {
                JobStatus ts = it.previous();
                if (ts.getLatestRunTimeElapsed() >= job.getLatestRunTimeElapsed()) continue;
                isInsert = true;
                break;
            }
            if (isInsert) {
                it.next();
            }
            it.add(job);
            job.setTrackingController(32);
            this.maybeUpdateAlarmsLocked(job.hasTimingDelayConstraint() ? job.getEarliestRunTime() : Long.MAX_VALUE, job.hasDeadlineConstraint() ? job.getLatestRunTimeElapsed() : Long.MAX_VALUE, job.getSourceUid());
        }
    }

    @Override
    public void maybeStopTrackingJobLocked(JobStatus job, JobStatus incomingJob, boolean forUpdate) {
        if (job.clearTrackingController(32) && this.mTrackedJobs.remove(job)) {
            this.checkExpiredDelaysAndResetAlarm();
            this.checkExpiredDeadlinesAndResetAlarm();
        }
    }

    private boolean canStopTrackingJobLocked(JobStatus job) {
        return !(job.hasTimingDelayConstraint() && (job.satisfiedConstraints & Integer.MIN_VALUE) == 0 || job.hasDeadlineConstraint() && (job.satisfiedConstraints & 0x40000000) == 0);
    }

    private void ensureAlarmServiceLocked() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpiredDeadlinesAndResetAlarm() {
        Object object = this.mLock;
        synchronized (object) {
            long nextExpiryTime = Long.MAX_VALUE;
            int nextExpiryUid = 0;
            long nowElapsedMillis = SystemClock.elapsedRealtime();
            Iterator<JobStatus> it = this.mTrackedJobs.iterator();
            while (it.hasNext()) {
                JobStatus job = it.next();
                if (!job.hasDeadlineConstraint()) continue;
                if (this.evaluateDeadlineConstraint(job, nowElapsedMillis)) {
                    this.mStateChangedListener.onRunJobNow(job);
                    it.remove();
                    continue;
                }
                nextExpiryTime = job.getLatestRunTimeElapsed();
                nextExpiryUid = job.getSourceUid();
                break;
            }
            this.setDeadlineExpiredAlarmLocked(nextExpiryTime, nextExpiryUid);
        }
    }

    private boolean evaluateDeadlineConstraint(JobStatus job, long nowElapsedMillis) {
        long jobDeadline = job.getLatestRunTimeElapsed();
        if (jobDeadline <= nowElapsedMillis) {
            if (job.hasTimingDelayConstraint()) {
                job.setTimingDelayConstraintSatisfied(true);
            }
            job.setDeadlineConstraintSatisfied(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpiredDelaysAndResetAlarm() {
        Object object = this.mLock;
        synchronized (object) {
            long nowElapsedMillis = SystemClock.elapsedRealtime();
            long nextDelayTime = Long.MAX_VALUE;
            int nextDelayUid = 0;
            boolean ready = false;
            Iterator<JobStatus> it = this.mTrackedJobs.iterator();
            while (it.hasNext()) {
                long jobDelayTime;
                JobStatus job = it.next();
                if (!job.hasTimingDelayConstraint()) continue;
                if (this.evaluateTimingDelayConstraint(job, nowElapsedMillis)) {
                    if (this.canStopTrackingJobLocked(job)) {
                        it.remove();
                    }
                    if (!job.isReady()) continue;
                    ready = true;
                    continue;
                }
                if (job.isConstraintSatisfied(Integer.MIN_VALUE) || nextDelayTime <= (jobDelayTime = job.getEarliestRunTime())) continue;
                nextDelayTime = jobDelayTime;
                nextDelayUid = job.getSourceUid();
            }
            if (ready) {
                this.mStateChangedListener.onControllerStateChanged();
            }
            this.setDelayExpiredAlarmLocked(nextDelayTime, nextDelayUid);
        }
    }

    private boolean evaluateTimingDelayConstraint(JobStatus job, long nowElapsedMillis) {
        long jobDelayTime = job.getEarliestRunTime();
        if (jobDelayTime <= nowElapsedMillis) {
            job.setTimingDelayConstraintSatisfied(true);
            return true;
        }
        return false;
    }

    private void maybeUpdateAlarmsLocked(long delayExpiredElapsed, long deadlineExpiredElapsed, int uid) {
        if (delayExpiredElapsed < this.mNextDelayExpiredElapsedMillis) {
            this.setDelayExpiredAlarmLocked(delayExpiredElapsed, uid);
        }
        if (deadlineExpiredElapsed < this.mNextJobExpiredElapsedMillis) {
            this.setDeadlineExpiredAlarmLocked(deadlineExpiredElapsed, uid);
        }
    }

    private void setDelayExpiredAlarmLocked(long alarmTimeElapsedMillis, int uid) {
        this.mNextDelayExpiredElapsedMillis = alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis);
        this.updateAlarmWithListenerLocked("*job.delay*", this.mNextDelayExpiredListener, this.mNextDelayExpiredElapsedMillis, uid);
    }

    private void setDeadlineExpiredAlarmLocked(long alarmTimeElapsedMillis, int uid) {
        this.mNextJobExpiredElapsedMillis = alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis);
        this.updateAlarmWithListenerLocked("*job.deadline*", this.mDeadlineExpiredListener, this.mNextJobExpiredElapsedMillis, uid);
    }

    private long maybeAdjustAlarmTime(long proposedAlarmTimeElapsedMillis) {
        long earliestWakeupTimeElapsed = SystemClock.elapsedRealtime();
        if (proposedAlarmTimeElapsedMillis < earliestWakeupTimeElapsed) {
            return earliestWakeupTimeElapsed;
        }
        return proposedAlarmTimeElapsedMillis;
    }

    private void updateAlarmWithListenerLocked(String tag, AlarmManager.OnAlarmListener listener, long alarmTimeElapsed, int uid) {
        this.ensureAlarmServiceLocked();
        if (alarmTimeElapsed == Long.MAX_VALUE) {
            this.mAlarmService.cancel(listener);
        } else {
            this.mAlarmService.set(2, alarmTimeElapsed, -1L, 0L, tag, listener, null, new WorkSource(uid));
        }
    }

    @Override
    public void dumpControllerStateLocked(PrintWriter pw, int filterUid) {
        long nowElapsed = SystemClock.elapsedRealtime();
        pw.print("Alarms: now=");
        pw.print(SystemClock.elapsedRealtime());
        pw.println();
        pw.print("Next delay alarm in ");
        TimeUtils.formatDuration(this.mNextDelayExpiredElapsedMillis, nowElapsed, pw);
        pw.println();
        pw.print("Next deadline alarm in ");
        TimeUtils.formatDuration(this.mNextJobExpiredElapsedMillis, nowElapsed, pw);
        pw.println();
        pw.print("Tracking ");
        pw.print(this.mTrackedJobs.size());
        pw.println(":");
        for (JobStatus ts : this.mTrackedJobs) {
            if (!ts.shouldDump(filterUid)) continue;
            pw.print("  #");
            ts.printUniqueId(pw);
            pw.print(" from ");
            UserHandle.formatUid(pw, ts.getSourceUid());
            pw.print(": Delay=");
            if (ts.hasTimingDelayConstraint()) {
                TimeUtils.formatDuration(ts.getEarliestRunTime(), nowElapsed, pw);
            } else {
                pw.print("N/A");
            }
            pw.print(", Deadline=");
            if (ts.hasDeadlineConstraint()) {
                TimeUtils.formatDuration(ts.getLatestRunTimeElapsed(), nowElapsed, pw);
            } else {
                pw.print("N/A");
            }
            pw.println();
        }
    }
}

