/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.ComponentName;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.util.Slog;
import com.android.server.notification.NotificationRecord;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ZenLog {
    private static final String TAG = "ZenLog";
    private static final boolean DEBUG = Build.IS_DEBUGGABLE;
    private static final int SIZE = Build.IS_DEBUGGABLE ? 100 : 20;
    private static final long[] TIMES = new long[SIZE];
    private static final int[] TYPES = new int[SIZE];
    private static final String[] MSGS = new String[SIZE];
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
    private static final int TYPE_INTERCEPTED = 1;
    private static final int TYPE_ALLOW_DISABLE = 2;
    private static final int TYPE_SET_RINGER_MODE_EXTERNAL = 3;
    private static final int TYPE_SET_RINGER_MODE_INTERNAL = 4;
    private static final int TYPE_DOWNTIME = 5;
    private static final int TYPE_SET_ZEN_MODE = 6;
    private static final int TYPE_UPDATE_ZEN_MODE = 7;
    private static final int TYPE_EXIT_CONDITION = 8;
    private static final int TYPE_SUBSCRIBE = 9;
    private static final int TYPE_UNSUBSCRIBE = 10;
    private static final int TYPE_CONFIG = 11;
    private static final int TYPE_NOT_INTERCEPTED = 12;
    private static final int TYPE_DISABLE_EFFECTS = 13;
    private static final int TYPE_SUPPRESSOR_CHANGED = 14;
    private static final int TYPE_LISTENER_HINTS_CHANGED = 15;
    private static int sNext;
    private static int sSize;

    public static void traceIntercepted(NotificationRecord record, String reason) {
        if (record != null && record.isIntercepted()) {
            return;
        }
        ZenLog.append(1, record.getKey() + "," + reason);
    }

    public static void traceNotIntercepted(NotificationRecord record, String reason) {
        if (record != null && record.isUpdate) {
            return;
        }
        ZenLog.append(12, record.getKey() + "," + reason);
    }

    public static void traceSetRingerModeExternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeInternalIn, int ringerModeInternalOut) {
        ZenLog.append(3, caller + ",e:" + ZenLog.ringerModeToString(ringerModeOld) + "->" + ZenLog.ringerModeToString(ringerModeNew) + ",i:" + ZenLog.ringerModeToString(ringerModeInternalIn) + "->" + ZenLog.ringerModeToString(ringerModeInternalOut));
    }

    public static void traceSetRingerModeInternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeExternalIn, int ringerModeExternalOut) {
        ZenLog.append(4, caller + ",i:" + ZenLog.ringerModeToString(ringerModeOld) + "->" + ZenLog.ringerModeToString(ringerModeNew) + ",e:" + ZenLog.ringerModeToString(ringerModeExternalIn) + "->" + ZenLog.ringerModeToString(ringerModeExternalOut));
    }

    public static void traceDowntimeAutotrigger(String result) {
        ZenLog.append(5, result);
    }

    public static void traceSetZenMode(int zenMode, String reason) {
        ZenLog.append(6, ZenLog.zenModeToString(zenMode) + "," + reason);
    }

    public static void traceUpdateZenMode(int fromMode, int toMode) {
        ZenLog.append(7, ZenLog.zenModeToString(fromMode) + " -> " + ZenLog.zenModeToString(toMode));
    }

    public static void traceExitCondition(Condition c, ComponentName component, String reason) {
        ZenLog.append(8, c + "," + ZenLog.componentToString(component) + "," + reason);
    }

    public static void traceSubscribe(Uri uri, IConditionProvider provider, RemoteException e) {
        ZenLog.append(9, uri + "," + ZenLog.subscribeResult(provider, e));
    }

    public static void traceUnsubscribe(Uri uri, IConditionProvider provider, RemoteException e) {
        ZenLog.append(10, uri + "," + ZenLog.subscribeResult(provider, e));
    }

    public static void traceConfig(String reason, ZenModeConfig oldConfig, ZenModeConfig newConfig) {
        ZenLog.append(11, reason + "," + (newConfig != null ? newConfig.toString() : null) + "," + ZenModeConfig.diff(oldConfig, newConfig));
    }

    public static void traceDisableEffects(NotificationRecord record, String reason) {
        ZenLog.append(13, record.getKey() + "," + reason);
    }

    public static void traceEffectsSuppressorChanged(List<ComponentName> oldSuppressors, List<ComponentName> newSuppressors, long suppressedEffects) {
        ZenLog.append(14, "suppressed effects:" + suppressedEffects + "," + ZenLog.componentListToString(oldSuppressors) + "->" + ZenLog.componentListToString(newSuppressors));
    }

    public static void traceListenerHintsChanged(int oldHints, int newHints, int listenerCount) {
        ZenLog.append(15, ZenLog.hintsToString(oldHints) + "->" + ZenLog.hintsToString(newHints) + ",listeners=" + listenerCount);
    }

    private static String subscribeResult(IConditionProvider provider, RemoteException e) {
        return provider == null ? "no provider" : (e != null ? e.getMessage() : "ok");
    }

    private static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "intercepted";
            }
            case 2: {
                return "allow_disable";
            }
            case 3: {
                return "set_ringer_mode_external";
            }
            case 4: {
                return "set_ringer_mode_internal";
            }
            case 5: {
                return "downtime";
            }
            case 6: {
                return "set_zen_mode";
            }
            case 7: {
                return "update_zen_mode";
            }
            case 8: {
                return "exit_condition";
            }
            case 9: {
                return "subscribe";
            }
            case 10: {
                return "unsubscribe";
            }
            case 11: {
                return "config";
            }
            case 12: {
                return "not_intercepted";
            }
            case 13: {
                return "disable_effects";
            }
            case 14: {
                return "suppressor_changed";
            }
            case 15: {
                return "listener_hints_changed";
            }
        }
        return "unknown";
    }

    private static String ringerModeToString(int ringerMode) {
        switch (ringerMode) {
            case 0: {
                return "silent";
            }
            case 1: {
                return "vibrate";
            }
            case 2: {
                return "normal";
            }
        }
        return "unknown";
    }

    private static String zenModeToString(int zenMode) {
        switch (zenMode) {
            case 0: {
                return "off";
            }
            case 1: {
                return "important_interruptions";
            }
            case 3: {
                return "alarms";
            }
            case 2: {
                return "no_interruptions";
            }
        }
        return "unknown";
    }

    private static String hintsToString(int hints) {
        switch (hints) {
            case 0: {
                return "none";
            }
            case 1: {
                return "disable_effects";
            }
        }
        return Integer.toString(hints);
    }

    private static String componentToString(ComponentName component) {
        return component != null ? component.toShortString() : null;
    }

    private static String componentListToString(List<ComponentName> components) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < components.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(ZenLog.componentToString(components.get(i)));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void append(int type, String msg) {
        String[] stringArray = MSGS;
        synchronized (MSGS) {
            ZenLog.TIMES[ZenLog.sNext] = System.currentTimeMillis();
            ZenLog.TYPES[ZenLog.sNext] = type;
            ZenLog.MSGS[ZenLog.sNext] = msg;
            sNext = (sNext + 1) % SIZE;
            if (sSize < SIZE) {
                ++sSize;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (DEBUG) {
                Slog.d(TAG, ZenLog.typeToString(type) + ": " + msg);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(PrintWriter pw, String prefix) {
        String[] stringArray = MSGS;
        synchronized (MSGS) {
            int start = (sNext - sSize + SIZE) % SIZE;
            for (int i = 0; i < sSize; ++i) {
                int j = (start + i) % SIZE;
                pw.print(prefix);
                pw.print(FORMAT.format(new Date(TIMES[j])));
                pw.print(' ');
                pw.print(ZenLog.typeToString(TYPES[j]));
                pw.print(": ");
                pw.println(MSGS[j]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

