/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.OverlayInfo;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.om.IdmapManager;
import com.android.server.om.OverlayManagerSettings;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class OverlayManagerServiceImpl {
    private final PackageManagerHelper mPackageManager;
    private final IdmapManager mIdmapManager;
    private final OverlayManagerSettings mSettings;
    private final Set<String> mDefaultOverlays;
    private final OverlayChangeListener mListener;

    OverlayManagerServiceImpl(PackageManagerHelper packageManager, IdmapManager idmapManager, OverlayManagerSettings settings, Set<String> defaultOverlays, OverlayChangeListener listener) {
        this.mPackageManager = packageManager;
        this.mIdmapManager = idmapManager;
        this.mSettings = settings;
        this.mDefaultOverlays = defaultOverlays;
        this.mListener = listener;
    }

    ArrayList<String> updateOverlaysForUser(int newUserId) {
        OverlayInfo oi;
        ArraySet<String> packagesToUpdateAssets = new ArraySet<String>();
        ArrayMap<String, List<OverlayInfo>> tmp = this.mSettings.getOverlaysForUser(newUserId);
        int tmpSize = tmp.size();
        ArrayMap<String, OverlayInfo> storedOverlayInfos = new ArrayMap<String, OverlayInfo>(tmpSize);
        for (int i = 0; i < tmpSize; ++i) {
            List<OverlayInfo> chunk = tmp.valueAt(i);
            int chunkSize = chunk.size();
            for (int j = 0; j < chunkSize; ++j) {
                oi = chunk.get(j);
                storedOverlayInfos.put(oi.packageName, oi);
            }
        }
        List<PackageInfo> overlayPackages = this.mPackageManager.getOverlayPackages(newUserId);
        int overlayPackagesSize = overlayPackages.size();
        for (int i = 0; i < overlayPackagesSize; ++i) {
            PackageInfo overlayPackage = overlayPackages.get(i);
            oi = (OverlayInfo)storedOverlayInfos.get(overlayPackage.packageName);
            if (oi == null || !oi.targetPackageName.equals(overlayPackage.overlayTarget)) {
                this.mSettings.init(overlayPackage.packageName, newUserId, overlayPackage.overlayTarget, overlayPackage.applicationInfo.getBaseCodePath(), overlayPackage.isStaticOverlay, overlayPackage.overlayPriority);
                if (oi == null) {
                    if (overlayPackage.isStaticOverlay || this.mDefaultOverlays.contains(overlayPackage.packageName)) {
                        this.mSettings.setEnabled(overlayPackage.packageName, newUserId, true);
                    }
                } else {
                    packagesToUpdateAssets.add(oi.targetPackageName);
                }
            }
            try {
                PackageInfo targetPackage = this.mPackageManager.getPackageInfo(overlayPackage.overlayTarget, newUserId);
                this.updateState(targetPackage, overlayPackage, newUserId);
            }
            catch (OverlayManagerSettings.BadKeyException e) {
                Slog.e("OverlayManager", "failed to update settings", e);
                this.mSettings.remove(overlayPackage.packageName, newUserId);
            }
            packagesToUpdateAssets.add(overlayPackage.overlayTarget);
            storedOverlayInfos.remove(overlayPackage.packageName);
        }
        int storedOverlayInfosSize = storedOverlayInfos.size();
        for (int i = 0; i < storedOverlayInfosSize; ++i) {
            oi = (OverlayInfo)storedOverlayInfos.valueAt(i);
            this.mSettings.remove(oi.packageName, oi.userId);
            this.removeIdmapIfPossible(oi);
            packagesToUpdateAssets.add(oi.targetPackageName);
        }
        Iterator iter = packagesToUpdateAssets.iterator();
        while (iter.hasNext()) {
            String targetPackageName = (String)iter.next();
            if (this.mPackageManager.getPackageInfo(targetPackageName, newUserId) != null) continue;
            iter.remove();
        }
        return new ArrayList<String>(packagesToUpdateAssets);
    }

    void onUserRemoved(int userId) {
        this.mSettings.removeUser(userId);
    }

    void onTargetPackageAdded(String packageName, int userId) {
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        this.updateAllOverlaysForTarget(packageName, userId, targetPackage);
        this.mListener.onOverlaysChanged(packageName, userId);
    }

    void onTargetPackageChanged(String packageName, int userId) {
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (this.updateAllOverlaysForTarget(packageName, userId, targetPackage)) {
            this.mListener.onOverlaysChanged(packageName, userId);
        }
    }

    void onTargetPackageUpgrading(String packageName, int userId) {
        if (this.updateAllOverlaysForTarget(packageName, userId, null)) {
            this.mListener.onOverlaysChanged(packageName, userId);
        }
    }

    void onTargetPackageUpgraded(String packageName, int userId) {
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (this.updateAllOverlaysForTarget(packageName, userId, targetPackage)) {
            this.mListener.onOverlaysChanged(packageName, userId);
        }
    }

    void onTargetPackageRemoved(String packageName, int userId) {
        this.updateAllOverlaysForTarget(packageName, userId, null);
    }

    private boolean updateAllOverlaysForTarget(String packageName, int userId, PackageInfo targetPackage) {
        boolean modified = false;
        List<OverlayInfo> ois = this.mSettings.getOverlaysForTarget(packageName, userId);
        int N = ois.size();
        for (int i = 0; i < N; ++i) {
            OverlayInfo oi = ois.get(i);
            PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(oi.packageName, userId);
            if (overlayPackage == null) {
                modified |= this.mSettings.remove(oi.packageName, oi.userId);
                this.removeIdmapIfPossible(oi);
                continue;
            }
            try {
                modified |= this.updateState(targetPackage, overlayPackage, userId);
                continue;
            }
            catch (OverlayManagerSettings.BadKeyException e) {
                Slog.e("OverlayManager", "failed to update settings", e);
                modified |= this.mSettings.remove(oi.packageName, userId);
            }
        }
        return modified;
    }

    void onOverlayPackageAdded(String packageName, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            Slog.w("OverlayManager", "overlay package " + packageName + " was added, but couldn't be found");
            this.onOverlayPackageRemoved(packageName, userId);
            return;
        }
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(overlayPackage.overlayTarget, userId);
        this.mSettings.init(packageName, userId, overlayPackage.overlayTarget, overlayPackage.applicationInfo.getBaseCodePath(), overlayPackage.isStaticOverlay, overlayPackage.overlayPriority);
        try {
            if (this.updateState(targetPackage, overlayPackage, userId)) {
                this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
            }
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            Slog.e("OverlayManager", "failed to update settings", e);
            this.mSettings.remove(packageName, userId);
        }
    }

    void onOverlayPackageChanged(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageChanged called, but only pre-installed overlays supported");
    }

    void onOverlayPackageUpgrading(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageUpgrading called, but only pre-installed overlays supported");
    }

    void onOverlayPackageUpgraded(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageUpgraded called, but only pre-installed overlays supported");
    }

    void onOverlayPackageRemoved(String packageName, int userId) {
        Slog.wtf("OverlayManager", "onOverlayPackageRemoved called, but only pre-installed overlays supported");
    }

    OverlayInfo getOverlayInfo(String packageName, int userId) {
        try {
            return this.mSettings.getOverlayInfo(packageName, userId);
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return null;
        }
    }

    List<OverlayInfo> getOverlayInfosForTarget(String targetPackageName, int userId) {
        return this.mSettings.getOverlaysForTarget(targetPackageName, userId);
    }

    Map<String, List<OverlayInfo>> getOverlaysForUser(int userId) {
        return this.mSettings.getOverlaysForUser(userId);
    }

    boolean setEnabled(String packageName, boolean enable, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (overlayPackage.isStaticOverlay) {
            return false;
        }
        try {
            OverlayInfo oi = this.mSettings.getOverlayInfo(packageName, userId);
            PackageInfo targetPackage = this.mPackageManager.getPackageInfo(oi.targetPackageName, userId);
            boolean modified = this.mSettings.setEnabled(packageName, userId, enable);
            if (modified |= this.updateState(targetPackage, overlayPackage, userId)) {
                this.mListener.onOverlaysChanged(oi.targetPackageName, userId);
            }
            return true;
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return false;
        }
    }

    boolean setEnabledExclusive(String packageName, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        try {
            OverlayInfo oi = this.mSettings.getOverlayInfo(packageName, userId);
            PackageInfo targetPackage = this.mPackageManager.getPackageInfo(oi.targetPackageName, userId);
            List<OverlayInfo> allOverlays = this.getOverlayInfosForTarget(oi.targetPackageName, userId);
            boolean modified = false;
            allOverlays.remove(oi);
            for (int i = 0; i < allOverlays.size(); ++i) {
                String disabledOverlayPackageName = allOverlays.get((int)i).packageName;
                PackageInfo disabledOverlayPackageInfo = this.mPackageManager.getPackageInfo(disabledOverlayPackageName, userId);
                if (disabledOverlayPackageInfo == null) {
                    modified |= this.mSettings.remove(disabledOverlayPackageName, userId);
                    continue;
                }
                if (disabledOverlayPackageInfo.isStaticOverlay) continue;
                modified |= this.mSettings.setEnabled(disabledOverlayPackageName, userId, false);
                modified |= this.updateState(targetPackage, disabledOverlayPackageInfo, userId);
            }
            modified |= this.mSettings.setEnabled(packageName, userId, true);
            if (modified |= this.updateState(targetPackage, overlayPackage, userId)) {
                this.mListener.onOverlaysChanged(oi.targetPackageName, userId);
            }
            return true;
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return false;
        }
    }

    private boolean isPackageUpdatableOverlay(String packageName, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        return overlayPackage != null && !overlayPackage.isStaticOverlay;
    }

    boolean setPriority(String packageName, String newParentPackageName, int userId) {
        if (!this.isPackageUpdatableOverlay(packageName, userId)) {
            return false;
        }
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (this.mSettings.setPriority(packageName, newParentPackageName, userId)) {
            this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
        }
        return true;
    }

    boolean setHighestPriority(String packageName, int userId) {
        if (!this.isPackageUpdatableOverlay(packageName, userId)) {
            return false;
        }
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (this.mSettings.setHighestPriority(packageName, userId)) {
            this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
        }
        return true;
    }

    boolean setLowestPriority(String packageName, int userId) {
        if (!this.isPackageUpdatableOverlay(packageName, userId)) {
            return false;
        }
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (this.mSettings.setLowestPriority(packageName, userId)) {
            this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
        }
        return true;
    }

    void onDump(PrintWriter pw) {
        this.mSettings.dump(pw);
        pw.println("Default overlays: " + TextUtils.join((CharSequence)";", this.mDefaultOverlays));
    }

    List<String> getEnabledOverlayPackageNames(String targetPackageName, int userId) {
        List<OverlayInfo> overlays = this.mSettings.getOverlaysForTarget(targetPackageName, userId);
        ArrayList<String> paths = new ArrayList<String>(overlays.size());
        int N = overlays.size();
        for (int i = 0; i < N; ++i) {
            OverlayInfo oi = overlays.get(i);
            if (!oi.isEnabled()) continue;
            paths.add(oi.packageName);
        }
        return paths;
    }

    private boolean updateState(PackageInfo targetPackage, PackageInfo overlayPackage, int userId) throws OverlayManagerSettings.BadKeyException {
        int newState;
        if (!(targetPackage == null || "android".equals(targetPackage.packageName) && overlayPackage.isStaticOverlay)) {
            this.mIdmapManager.createIdmap(targetPackage, overlayPackage, userId);
        }
        boolean modified = this.mSettings.setBaseCodePath(overlayPackage.packageName, userId, overlayPackage.applicationInfo.getBaseCodePath());
        int currentState = this.mSettings.getState(overlayPackage.packageName, userId);
        if (currentState != (newState = this.calculateNewState(targetPackage, overlayPackage, userId))) {
            modified |= this.mSettings.setState(overlayPackage.packageName, userId, newState);
        }
        return modified;
    }

    private int calculateNewState(PackageInfo targetPackage, PackageInfo overlayPackage, int userId) throws OverlayManagerSettings.BadKeyException {
        if (targetPackage == null) {
            return 0;
        }
        if (!this.mIdmapManager.idmapExists(overlayPackage, userId)) {
            return 1;
        }
        boolean enabled = this.mSettings.getEnabled(overlayPackage.packageName, userId);
        return enabled ? 3 : 2;
    }

    private void removeIdmapIfPossible(OverlayInfo oi) {
        int[] userIds;
        if (!this.mIdmapManager.idmapExists(oi)) {
            return;
        }
        for (int userId : userIds = this.mSettings.getUsers()) {
            try {
                OverlayInfo tmp = this.mSettings.getOverlayInfo(oi.packageName, userId);
                if (tmp == null || !tmp.isEnabled()) continue;
                return;
            }
            catch (OverlayManagerSettings.BadKeyException badKeyException) {
                // empty catch block
            }
        }
        this.mIdmapManager.removeIdmap(oi, oi.userId);
    }

    static interface PackageManagerHelper {
        public PackageInfo getPackageInfo(String var1, int var2);

        public boolean signaturesMatching(String var1, String var2, int var3);

        public List<PackageInfo> getOverlayPackages(int var1);
    }

    static interface OverlayChangeListener {
        public void onOverlaysChanged(String var1, int var2);
    }
}

