/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.annotation.IntDef;
import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.ResourcesManager;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.SecurityLog;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.AppsQueryHelper;
import android.content.pm.AuxiliaryResolveInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.FallbackCategoryProvider;
import android.content.pm.FeatureInfo;
import android.content.pm.IOnPermissionsChangeListener;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageDeleteObserver2;
import android.content.pm.IPackageInstallObserver2;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstantAppInfo;
import android.content.pm.InstantAppRequest;
import android.content.pm.InstantAppResolveInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.KeySet;
import android.content.pm.PackageCleanItem;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInfoLite;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PackageUserState;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VerifierInfo;
import android.content.pm.VersionedPackage;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.os.storage.IStorageManager;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.os.storage.StorageManagerInternal;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.security.KeyStore;
import android.security.SystemKeyStore;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.LogPrinter;
import android.util.MathUtils;
import android.util.PackageUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.Xml;
import android.util.jar.StrictJarFile;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.IParcelFileDescriptorFactory;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.os.SomeArgs;
import com.android.internal.telephony.CarrierAppUtils;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.AttributeCache;
import com.android.server.DeviceIdleController;
import com.android.server.EventLogTags;
import com.android.server.FgThread;
import com.android.server.IntentResolver;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.Watchdog;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.pm.BackgroundDexOptService;
import com.android.server.pm.BasePermission;
import com.android.server.pm.CompilerStats;
import com.android.server.pm.CrossProfileIntentFilter;
import com.android.server.pm.CrossProfileIntentResolver;
import com.android.server.pm.DefaultPermissionGrantPolicy;
import com.android.server.pm.EphemeralResolverConnection;
import com.android.server.pm.Installer;
import com.android.server.pm.InstantAppRegistry;
import com.android.server.pm.InstantAppResolver;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.IntentFilterVerificationResponse;
import com.android.server.pm.IntentFilterVerificationState;
import com.android.server.pm.KeySetHandle;
import com.android.server.pm.KeySetManagerService;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.PackageManagerServiceUtils;
import com.android.server.pm.PackageManagerShellCommand;
import com.android.server.pm.PackageSender;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSettingBase;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.PackageUsage;
import com.android.server.pm.PackageVerificationResponse;
import com.android.server.pm.PackageVerificationState;
import com.android.server.pm.ParallelPackageParser;
import com.android.server.pm.PermissionsState;
import com.android.server.pm.PersistentPreferredActivity;
import com.android.server.pm.PersistentPreferredIntentResolver;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.PreferredIntentResolver;
import com.android.server.pm.ProcessLoggingHandler;
import com.android.server.pm.ProtectedPackages;
import com.android.server.pm.SELinuxMMAC;
import com.android.server.pm.SettingBase;
import com.android.server.pm.Settings;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserDataPreparer;
import com.android.server.pm.UserManagerService;
import com.android.server.pm.dex.DexManager;
import com.android.server.storage.DeviceStorageMonitorInternal;
import dalvik.system.CloseGuard;
import dalvik.system.DexFile;
import dalvik.system.VMRuntime;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PackageManagerService
extends IPackageManager.Stub
implements PackageSender {
    static final String TAG = "PackageManager";
    static final boolean DEBUG_SETTINGS = false;
    static final boolean DEBUG_PREFERRED = false;
    static final boolean DEBUG_UPGRADE = false;
    static final boolean DEBUG_DOMAIN_VERIFICATION = false;
    private static final boolean DEBUG_BACKUP = false;
    private static final boolean DEBUG_INSTALL = false;
    private static final boolean DEBUG_REMOVE = false;
    private static final boolean DEBUG_BROADCASTS = false;
    private static final boolean DEBUG_SHOW_INFO = false;
    private static final boolean DEBUG_PACKAGE_INFO = false;
    private static final boolean DEBUG_INTENT_MATCHING = false;
    private static final boolean DEBUG_PACKAGE_SCANNING = false;
    private static final boolean DEBUG_VERIFY = false;
    private static final boolean DEBUG_FILTERS = false;
    private static final boolean DEBUG_PERMISSIONS = false;
    private static final boolean DEBUG_SHARED_LIBRARIES = false;
    public static final boolean DEBUG_DEXOPT = false;
    private static final boolean DEBUG_ABI_SELECTION = false;
    private static final boolean DEBUG_EPHEMERAL = Build.IS_DEBUGGABLE;
    private static final boolean DEBUG_TRIAGED_MISSING = false;
    private static final boolean DEBUG_APP_DATA = false;
    static final boolean CLEAR_RUNTIME_PERMISSIONS_ON_UPGRADE = false;
    private static final boolean HIDE_EPHEMERAL_APIS = false;
    private static final boolean ENABLE_FREE_CACHE_V2 = SystemProperties.getBoolean("fw.free_cache_v2", true);
    private static final int RADIO_UID = 1001;
    private static final int LOG_UID = 1007;
    private static final int NFC_UID = 1027;
    private static final int BLUETOOTH_UID = 1002;
    private static final int SHELL_UID = 2000;
    private static final int MAX_PERMISSION_TREE_FOOTPRINT = 32768;
    private static final String INSTALL_PACKAGE_SUFFIX = "-";
    static final int SCAN_NO_DEX = 2;
    static final int SCAN_FORCE_DEX = 4;
    static final int SCAN_UPDATE_SIGNATURE = 8;
    static final int SCAN_NEW_INSTALL = 16;
    static final int SCAN_UPDATE_TIME = 32;
    static final int SCAN_BOOTING = 64;
    static final int SCAN_TRUSTED_OVERLAY = 128;
    static final int SCAN_DELETE_DATA_ON_FAILURES = 256;
    static final int SCAN_REPLACING = 512;
    static final int SCAN_REQUIRE_KNOWN = 1024;
    static final int SCAN_MOVE = 2048;
    static final int SCAN_INITIAL = 4096;
    static final int SCAN_CHECK_ONLY = 8192;
    static final int SCAN_DONT_KILL_APP = 16384;
    static final int SCAN_IGNORE_FROZEN = 32768;
    static final int SCAN_FIRST_BOOT_OR_UPGRADE = 65536;
    static final int SCAN_AS_INSTANT_APP = 131072;
    static final int SCAN_AS_FULL_APP = 262144;
    static final int FLAGS_REMOVE_CHATTY = Integer.MIN_VALUE;
    private static final String STATIC_SHARED_LIB_DELIMITER = "_";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_ACTIVITY = 1;
    private static final int TYPE_RECEIVER = 2;
    private static final int TYPE_SERVICE = 3;
    private static final int TYPE_PROVIDER = 4;
    static final long WATCHDOG_TIMEOUT = 600000L;
    private static final long DEFAULT_MANDATORY_FSTRIM_INTERVAL = 259200000L;
    private static final boolean DEFAULT_VERIFY_ENABLE = true;
    private static final long DEFAULT_VERIFICATION_TIMEOUT = 10000L;
    private static final int DEFAULT_VERIFICATION_RESPONSE = 1;
    static final String PLATFORM_PACKAGE_NAME = "android";
    static final String DEFAULT_CONTAINER_PACKAGE = "com.android.defcontainer";
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private static final String KILL_APP_REASON_GIDS_CHANGED = "permission grant or revoke changed gids";
    private static final String KILL_APP_REASON_PERMISSIONS_REVOKED = "permissions revoked";
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String PACKAGE_SCHEME = "package";
    private static final String VENDOR_OVERLAY_DIR = "/vendor/overlay";
    private static final int GRANT_DENIED = 1;
    private static final int GRANT_INSTALL = 2;
    private static final int GRANT_RUNTIME = 3;
    private static final int GRANT_UPGRADE = 4;
    private static final Intent sBrowserIntent = new Intent();
    private static final Set<String> PROTECTED_ACTIONS;
    public static final int REASON_FIRST_BOOT = 0;
    public static final int REASON_BOOT = 1;
    public static final int REASON_INSTALL = 2;
    public static final int REASON_BACKGROUND_DEXOPT = 3;
    public static final int REASON_AB_OTA = 4;
    public static final int REASON_LAST = 4;
    private static final List<String> ALL_DANGEROUS_PERMISSIONS;
    private static final String PACKAGE_PARSER_CACHE_VERSION = "1";
    private static final boolean DEFAULT_PACKAGE_PARSER_CACHE_ENABLED = true;
    final ServiceThread mHandlerThread;
    final PackageHandler mHandler;
    private final ProcessLoggingHandler mProcessLoggingHandler;
    private ArrayList<Message> mPostSystemReadyMessages;
    final int mSdkVersion = Build.VERSION.SDK_INT;
    final Context mContext;
    final boolean mFactoryTest;
    final boolean mOnlyCore;
    final DisplayMetrics mMetrics;
    final int mDefParseFlags;
    final String[] mSeparateProcesses;
    final boolean mIsUpgrade;
    final boolean mIsPreNUpgrade;
    final boolean mIsPreNMR1Upgrade;
    @GuardedBy(value="mPackages")
    boolean mDefaultContainerWhitelisted = false;
    @GuardedBy(value="mPackages")
    private boolean mDexOptDialogShown;
    final String mAsecInternalPath;
    @GuardedBy(value="mInstallLock")
    final Installer mInstaller;
    final File mAppInstallDir;
    private File mAppLib32InstallDir;
    final File mDrmAppPrivateInstallDir;
    final Object mInstallLock = new Object();
    @GuardedBy(value="mPackages")
    final ArrayMap<String, PackageParser.Package> mPackages = new ArrayMap();
    final ArrayMap<String, Set<String>> mKnownCodebase = new ArrayMap();
    @GuardedBy(value="mPackages")
    final SparseIntArray mIsolatedOwners = new SparseIntArray();
    private final ArrayMap<String, File> mExpectingBetter = new ArrayMap();
    private final List<PackageParser.ActivityIntentInfo> mProtectedFilters = new ArrayList<PackageParser.ActivityIntentInfo>();
    private boolean mDeferProtectedFilters = true;
    private final ArraySet<String> mExistingSystemPackages = new ArraySet();
    boolean mPromoteSystemApps;
    @GuardedBy(value="mPackages")
    final Settings mSettings;
    @GuardedBy(value="mPackages")
    final ArraySet<String> mFrozenPackages = new ArraySet();
    final ProtectedPackages mProtectedPackages;
    boolean mFirstBoot;
    PackageManagerInternal.ExternalSourcesPolicy mExternalSourcesPolicy;
    final int[] mGlobalGids;
    final SparseArray<ArraySet<String>> mSystemPermissions;
    @GuardedBy(value="mAvailableFeatures")
    final ArrayMap<String, FeatureInfo> mAvailableFeatures;
    boolean mFoundPolicyFile;
    private final InstantAppRegistry mInstantAppRegistry;
    @GuardedBy(value="mPackages")
    int mChangedPackagesSequenceNumber;
    @GuardedBy(value="mPackages")
    final SparseArray<SparseArray<String>> mChangedPackages = new SparseArray();
    @GuardedBy(value="mPackages")
    final SparseArray<Map<String, Integer>> mChangedPackagesSequenceNumbers = new SparseArray();
    final PackageParser.Callback mPackageParserCallback = new PackageParserCallback();
    final ParallelPackageParserCallback mParallelPackageParserCallback = new ParallelPackageParserCallback();
    final ArrayMap<String, SparseArray<SharedLibraryEntry>> mSharedLibraries = new ArrayMap();
    final ArrayMap<String, SparseArray<SharedLibraryEntry>> mStaticLibsByDeclaringPackage = new ArrayMap();
    final ActivityIntentResolver mActivities = new ActivityIntentResolver();
    final ActivityIntentResolver mReceivers = new ActivityIntentResolver();
    final ServiceIntentResolver mServices = new ServiceIntentResolver();
    final ProviderIntentResolver mProviders = new ProviderIntentResolver();
    final ArrayMap<String, PackageParser.Provider> mProvidersByAuthority = new ArrayMap();
    final ArrayMap<ComponentName, PackageParser.Instrumentation> mInstrumentation = new ArrayMap();
    final ArrayMap<String, PackageParser.PermissionGroup> mPermissionGroups = new ArrayMap();
    final ArraySet<String> mTransferedPackages = new ArraySet();
    final ArraySet<String> mProtectedBroadcasts = new ArraySet();
    final SparseArray<PackageVerificationState> mPendingVerification = new SparseArray();
    final ArrayMap<String, ArraySet<String>> mAppOpPermissionPackages = new ArrayMap();
    final PackageInstallerService mInstallerService;
    private final PackageDexOptimizer mPackageDexOptimizer;
    private final DexManager mDexManager;
    private AtomicInteger mNextMoveId = new AtomicInteger();
    private final MoveCallbacks mMoveCallbacks;
    private final OnPermissionChangeListeners mOnPermissionChangeListeners;
    SparseBooleanArray mUserNeedsBadging = new SparseBooleanArray();
    private int mPendingVerificationToken = 0;
    volatile boolean mSystemReady;
    volatile boolean mSafeMode;
    volatile boolean mHasSystemUidErrors;
    private volatile boolean mEphemeralAppsDisabled;
    ApplicationInfo mAndroidApplication;
    final ActivityInfo mResolveActivity = new ActivityInfo();
    final ResolveInfo mResolveInfo = new ResolveInfo();
    ComponentName mResolveComponentName;
    PackageParser.Package mPlatformPackage;
    ComponentName mCustomResolverComponentName;
    boolean mResolverReplaced = false;
    private final ComponentName mIntentFilterVerifierComponent;
    private final IntentFilterVerifier<PackageParser.ActivityIntentInfo> mIntentFilterVerifier;
    private int mIntentFilterVerificationToken = 0;
    final EphemeralResolverConnection mInstantAppResolverConnection;
    final ComponentName mInstantAppResolverSettingsComponent;
    ActivityInfo mInstantAppInstallerActivity;
    final ResolveInfo mInstantAppInstallerInfo = new ResolveInfo();
    final SparseArray<IntentFilterVerificationState> mIntentFilterVerificationStates = new SparseArray();
    final DefaultPermissionGrantPolicy mDefaultPermissionPolicy;
    private List<String> mKeepUninstalledPackages;
    private UserManagerInternal mUserManagerInternal;
    private DeviceIdleController.LocalService mDeviceIdleController;
    private File mCacheDir;
    private ArraySet<String> mPrivappPermissionsViolations;
    private Future<?> mPrepareAppDataFuture;
    final PendingPackageBroadcasts mPendingBroadcasts = new PendingPackageBroadcasts();
    private IMediaContainerService mContainerService = null;
    static final int SEND_PENDING_BROADCAST = 1;
    static final int MCS_BOUND = 3;
    static final int END_COPY = 4;
    static final int INIT_COPY = 5;
    static final int MCS_UNBIND = 6;
    static final int START_CLEANING_PACKAGE = 7;
    static final int FIND_INSTALL_LOC = 8;
    static final int POST_INSTALL = 9;
    static final int MCS_RECONNECT = 10;
    static final int MCS_GIVE_UP = 11;
    static final int UPDATED_MEDIA_STATUS = 12;
    static final int WRITE_SETTINGS = 13;
    static final int WRITE_PACKAGE_RESTRICTIONS = 14;
    static final int PACKAGE_VERIFIED = 15;
    static final int CHECK_PENDING_VERIFICATION = 16;
    static final int START_INTENT_FILTER_VERIFICATIONS = 17;
    static final int INTENT_FILTER_VERIFIED = 18;
    static final int WRITE_PACKAGE_LIST = 19;
    static final int INSTANT_APP_RESOLUTION_PHASE_TWO = 20;
    static final int WRITE_SETTINGS_DELAY = 10000;
    static final int BROADCAST_DELAY = 10000;
    private static final long DEFAULT_UNUSED_STATIC_SHARED_LIB_MIN_CACHE_PERIOD = 0x6DDD00L;
    static UserManagerService sUserManager;
    private ArraySet<Integer> mDirtyUsers = new ArraySet();
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    final SparseArray<PostInstallData> mRunningInstalls = new SparseArray();
    int mNextInstallToken = 1;
    private static final String TAG_PREFERRED_BACKUP = "pa";
    private static final String TAG_DEFAULT_APPS = "da";
    private static final String TAG_INTENT_FILTER_VERIFICATION = "iv";
    private static final String TAG_PERMISSION_BACKUP = "perm-grant-backup";
    private static final String TAG_ALL_GRANTS = "rt-grants";
    private static final String TAG_GRANT = "grant";
    private static final String ATTR_PACKAGE_NAME = "pkg";
    private static final String TAG_PERMISSION = "perm";
    private static final String ATTR_PERMISSION_NAME = "name";
    private static final String ATTR_IS_GRANTED = "g";
    private static final String ATTR_USER_SET = "set";
    private static final String ATTR_USER_FIXED = "fixed";
    private static final String ATTR_REVOKE_ON_UPGRADE = "rou";
    private static final int SYSTEM_RUNTIME_GRANT_MASK = 52;
    private static final int USER_RUNTIME_GRANT_MASK = 11;
    final String mRequiredVerifierPackage;
    final String mRequiredInstallerPackage;
    final String mRequiredUninstallerPackage;
    final String mSetupWizardPackage;
    final String mStorageManagerPackage;
    final String mServicesSystemSharedLibraryPackageName;
    final String mSharedSystemSharedLibraryPackageName;
    final boolean mPermissionReviewRequired;
    private final PackageUsage mPackageUsage = new PackageUsage();
    private final CompilerStats mCompilerStats = new CompilerStats();
    private StorageEventListener mStorageListener = new StorageEventListener(){

        @Override
        public void onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) {
            if (vol.type == 1) {
                if (vol.state == 2) {
                    String volumeUuid = vol.getFsUuid();
                    sUserManager.reconcileUsers(volumeUuid);
                    PackageManagerService.this.reconcileApps(volumeUuid);
                    PackageManagerService.this.mInstallerService.onPrivateVolumeMounted(volumeUuid);
                    PackageManagerService.this.loadPrivatePackages(vol);
                } else if (vol.state == 5) {
                    PackageManagerService.this.unloadPrivatePackages(vol);
                }
            }
            if (vol.type == 0 && vol.isPrimary()) {
                if (vol.state == 2) {
                    PackageManagerService.this.updateExternalMediaStatus(true, false);
                } else if (vol.state == 5) {
                    PackageManagerService.this.updateExternalMediaStatus(false, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeForgotten(String fsUuid) {
            if (TextUtils.isEmpty(fsUuid)) {
                Slog.e(PackageManagerService.TAG, "Forgetting internal storage is probably a mistake; ignoring");
                return;
            }
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                List<PackageSetting> packages = PackageManagerService.this.mSettings.getVolumePackagesLPr(fsUuid);
                for (PackageSetting ps : packages) {
                    Slog.d(PackageManagerService.TAG, "Destroying " + ps.name + " because volume was forgotten");
                    PackageManagerService.this.deletePackageVersioned(new VersionedPackage(ps.name, -1), new PackageManager.LegacyPackageDeleteObserver(null).getBinder(), 0, 2);
                    AttributeCache.instance().removePackage(ps.name);
                }
                PackageManagerService.this.mSettings.onVolumeForgotten(fsUuid);
                PackageManagerService.this.mSettings.writeLPr();
            }
        }
    };
    static final int UPDATE_PERMISSIONS_ALL = 1;
    static final int UPDATE_PERMISSIONS_REPLACE_PKG = 2;
    static final int UPDATE_PERMISSIONS_REPLACE_ALL = 4;
    private static final Comparator<ResolveInfo> mResolvePrioritySorter;
    private static final Comparator<ProviderInfo> mProviderInitOrderSorter;
    static final boolean DEBUG_SD_INSTALL = false;
    private static final String SD_ENCRYPTION_KEYSTORE_NAME = "AppsOnSD";
    private static final String SD_ENCRYPTION_ALGORITHM = "AES";
    private boolean mMediaMounted = false;

    private static boolean hasValidDomains(PackageParser.ActivityIntentInfo filter) {
        return filter.hasCategory("android.intent.category.BROWSABLE") && (filter.hasDataScheme("http") || filter.hasDataScheme("https"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackagePostInstall(PackageInstalledInfo res, boolean grantPermissions, boolean killApp, String[] grantedPermissions, boolean launchedForRestore, String installerPackage, IPackageInstallObserver2 installObserver) {
        if (res.returnCode == 1) {
            int n;
            ArrayMap<String, PackageParser.Package> arrayMap;
            String origInstallerPackageName;
            if (res.removedInfo != null) {
                res.removedInfo.sendPackageRemovedBroadcasts(killApp);
            }
            if (grantPermissions) {
                this.grantRequestedRuntimePermissions(res.pkg, res.newUsers, grantedPermissions);
            }
            boolean update = res.removedInfo != null && res.removedInfo.removedPackage != null;
            String string2 = origInstallerPackageName = res.removedInfo != null ? res.removedInfo.installerPackageName : null;
            if (res.pkg.parentPackage != null) {
                arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.grantRuntimePermissionsGrantedToDisabledPrivSysPackageParentLPw(res.pkg);
                }
            }
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mInstantAppRegistry.onPackageInstalledLPw(res.pkg, res.newUsers);
            }
            String packageName = res.pkg.applicationInfo.packageName;
            int[] firstUsers = EMPTY_INT_ARRAY;
            int[] updateUsers = EMPTY_INT_ARRAY;
            boolean allNewUsers = res.origUsers == null || res.origUsers.length == 0;
            PackageSetting ps = (PackageSetting)res.pkg.mExtras;
            int[] nArray = res.newUsers;
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int newUser = nArray[n];
                if (ps.getInstantApp(newUser)) continue;
                if (allNewUsers) {
                    firstUsers = ArrayUtils.appendInt(firstUsers, newUser);
                    continue;
                }
                boolean isNew = true;
                for (int origUser : res.origUsers) {
                    if (origUser != newUser) continue;
                    isNew = false;
                    break;
                }
                if (isNew) {
                    firstUsers = ArrayUtils.appendInt(firstUsers, newUser);
                    continue;
                }
                updateUsers = ArrayUtils.appendInt(updateUsers, newUser);
            }
            if (res.pkg.staticSharedLibName == null) {
                this.mProcessLoggingHandler.invalidateProcessLoggingBaseApkHash(res.pkg.baseCodePath);
                int n3 = UserHandle.getAppId(res.uid);
                boolean isSystem = res.pkg.applicationInfo.isSystemApp();
                this.sendPackageAddedForNewUsers(packageName, isSystem, n3, firstUsers);
                Bundle extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", res.uid);
                if (update) {
                    extras.putBoolean("android.intent.extra.REPLACING", true);
                }
                this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0, null, null, updateUsers);
                if (origInstallerPackageName != null) {
                    this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0, origInstallerPackageName, null, updateUsers);
                }
                if (update) {
                    this.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, 0, null, null, updateUsers);
                    if (origInstallerPackageName != null) {
                        this.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, 0, origInstallerPackageName, null, updateUsers);
                    }
                    this.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, 0, packageName, null, updateUsers);
                } else if (launchedForRestore && !PackageManagerService.isSystemApp(res.pkg)) {
                    this.sendFirstLaunchBroadcast(packageName, installerPackage, firstUsers);
                }
                if (res.pkg.isForwardLocked() || PackageManagerService.isExternal(res.pkg)) {
                    int[] uidArray = new int[]{res.pkg.applicationInfo.uid};
                    ArrayList<String> pkgList = new ArrayList<String>(1);
                    pkgList.add(packageName);
                    this.sendResourcesChangedBroadcast(true, true, pkgList, uidArray, null);
                }
            }
            if (firstUsers != null && firstUsers.length > 0) {
                ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
                synchronized (arrayMap2) {
                    int[] nArray2 = firstUsers;
                    n = nArray2.length;
                    for (int uidArray = 0; uidArray < n; ++uidArray) {
                        int userId = nArray2[uidArray];
                        if (this.packageIsBrowser(packageName, userId)) {
                            this.mSettings.setDefaultBrowserPackageNameLPw(null, userId);
                        }
                        this.mSettings.applyPendingPermissionGrantsLPw(packageName, userId);
                    }
                }
            }
            EventLog.writeEvent(3110, this.getUnknownSourcesSettings());
            if (res.removedInfo != null && res.removedInfo.args != null) {
                Runtime.getRuntime().gc();
                Object object = this.mInstallLock;
                synchronized (object) {
                    res.removedInfo.args.doPostDeleteLI(true);
                }
            } else {
                VMRuntime.getRuntime().requestConcurrentGC();
            }
            for (int userId : firstUsers) {
                PackageInfo info = this.getPackageInfo(packageName, 0, userId);
                if (info == null) continue;
                this.mDexManager.notifyPackageInstalled(info, userId);
            }
        }
        if (installObserver != null) {
            try {
                Bundle extras = this.extrasForInstallResult(res);
                installObserver.onPackageInstalled(res.name, res.returnCode, res.returnMsg, extras);
            }
            catch (RemoteException e) {
                Slog.i(TAG, "Observer no longer exists.");
            }
        }
    }

    private void grantRuntimePermissionsGrantedToDisabledPrivSysPackageParentLPw(PackageParser.Package pkg) {
        if (pkg.parentPackage == null) {
            return;
        }
        if (pkg.requestedPermissions == null) {
            return;
        }
        PackageSetting disabledSysParentPs = this.mSettings.getDisabledSystemPkgLPr(pkg.parentPackage.packageName);
        if (disabledSysParentPs == null || disabledSysParentPs.pkg == null || !disabledSysParentPs.isPrivileged() || disabledSysParentPs.childPackageNames != null && !disabledSysParentPs.childPackageNames.isEmpty()) {
            return;
        }
        int[] allUserIds = sUserManager.getUserIds();
        int permCount = pkg.requestedPermissions.size();
        for (int i = 0; i < permCount; ++i) {
            String permission2 = pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(permission2);
            if (bp == null || !bp.isRuntime() && !bp.isDevelopment()) continue;
            for (int userId : allUserIds) {
                if (!disabledSysParentPs.getPermissionsState().hasRuntimePermission(permission2, userId)) continue;
                this.grantRuntimePermission(pkg.packageName, permission2, userId);
            }
        }
    }

    private void grantRequestedRuntimePermissions(PackageParser.Package pkg, int[] userIds, String[] grantedPermissions) {
        for (int userId : userIds) {
            this.grantRequestedRuntimePermissionsForUser(pkg, userId, grantedPermissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantRequestedRuntimePermissionsForUser(PackageParser.Package pkg, int userId, String[] grantedPermissions) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        PermissionsState permissionsState = ps.getPermissionsState();
        int immutableFlags = 20;
        boolean supportsRuntimePermissions = pkg.applicationInfo.targetSdkVersion >= 23;
        boolean instantApp = this.isInstantApp(pkg.packageName, userId);
        for (String permission2 : pkg.requestedPermissions) {
            BasePermission bp;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                bp = this.mSettings.mPermissions.get(permission2);
            }
            if (bp == null || !bp.isRuntime() && !bp.isDevelopment() || instantApp && !bp.isInstant() || !supportsRuntimePermissions && bp.isRuntimeOnly() || grantedPermissions != null && !ArrayUtils.contains(grantedPermissions, permission2)) continue;
            int flags = permissionsState.getPermissionFlags(permission2, userId);
            if (supportsRuntimePermissions) {
                if ((flags & 0x14) != 0) continue;
                this.grantRuntimePermission(pkg.packageName, permission2, userId);
                continue;
            }
            if (!this.mPermissionReviewRequired || (flags & 0x40) == 0) continue;
            this.updatePermissionFlags(permission2, pkg.packageName, 64, 0, userId);
        }
    }

    Bundle extrasForInstallResult(PackageInstalledInfo res) {
        Bundle extras = null;
        switch (res.returnCode) {
            case -112: {
                extras = new Bundle();
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PERMISSION", res.origPermission);
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PACKAGE", res.origPackage);
                break;
            }
            case 1: {
                extras = new Bundle();
                extras.putBoolean("android.intent.extra.REPLACING", res.removedInfo != null && res.removedInfo.removedPackage != null);
            }
        }
        return extras;
    }

    void scheduleWriteSettingsLocked() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessageDelayed(13, 10000L);
        }
    }

    void scheduleWritePackageListLocked(int userId) {
        if (!this.mHandler.hasMessages(19)) {
            Message msg = this.mHandler.obtainMessage(19);
            msg.arg1 = userId;
            this.mHandler.sendMessageDelayed(msg, 10000L);
        }
    }

    void scheduleWritePackageRestrictionsLocked(UserHandle user) {
        int userId = user == null ? -1 : user.getIdentifier();
        this.scheduleWritePackageRestrictionsLocked(userId);
    }

    void scheduleWritePackageRestrictionsLocked(int userId) {
        int[] userIds;
        int[] nArray;
        if (userId == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        for (int nextUserId : userIds = nArray) {
            if (!sUserManager.exists(nextUserId)) {
                return;
            }
            this.mDirtyUsers.add(nextUserId);
            if (this.mHandler.hasMessages(14)) continue;
            this.mHandler.sendEmptyMessageDelayed(14, 10000L);
        }
    }

    public static PackageManagerService main(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        PackageManagerServiceCompilerMapping.checkProperties();
        PackageManagerService m = new PackageManagerService(context, installer, factoryTest, onlyCore);
        m.enableSystemUserPackages();
        ServiceManager.addService(PACKAGE_SCHEME, m);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableSystemUserPackages() {
        if (!UserManager.isSplitSystemUser()) {
            return;
        }
        AppsQueryHelper queryHelper = new AppsQueryHelper(this);
        ArraySet<String> enableApps = new ArraySet<String>();
        enableApps.addAll(queryHelper.queryApps(AppsQueryHelper.GET_NON_LAUNCHABLE_APPS | AppsQueryHelper.GET_APPS_WITH_INTERACT_ACROSS_USERS_PERM | AppsQueryHelper.GET_IMES, true, UserHandle.SYSTEM));
        ArraySet<String> wlApps = SystemConfig.getInstance().getSystemUserWhitelistedApps();
        enableApps.addAll((Collection<String>)wlApps);
        enableApps.addAll(queryHelper.queryApps(AppsQueryHelper.GET_REQUIRED_FOR_SYSTEM_USER, false, UserHandle.SYSTEM));
        ArraySet<String> blApps = SystemConfig.getInstance().getSystemUserBlacklistedApps();
        enableApps.removeAll((Collection<?>)blApps);
        Log.i(TAG, "Applications installed for system user: " + enableApps);
        List<String> allAps = queryHelper.queryApps(0, false, UserHandle.SYSTEM);
        int allAppsSize = allAps.size();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = 0; i < allAppsSize; ++i) {
                String pName = allAps.get(i);
                PackageSetting pkgSetting = this.mSettings.mPackages.get(pName);
                if (pkgSetting == null) continue;
                boolean install = enableApps.contains(pName);
                if (pkgSetting.getInstalled(0) == install) continue;
                Log.i(TAG, (install ? "Installing " : "Uninstalling ") + pName + " for system user");
                pkgSetting.setInstalled(install, 0);
            }
            this.scheduleWritePackageRestrictionsLocked(0);
        }
    }

    private static void getDefaultDisplayMetrics(Context context, DisplayMetrics metrics) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        displayManager.getDisplay(0).getMetrics(metrics);
    }

    private static void requestCopyPreoptedFiles() {
        int WAIT_TIME_MS = 100;
        String CP_PREOPT_PROPERTY = "sys.cppreopt";
        if (SystemProperties.getInt("ro.cp_system_other_odex", 0) == 1) {
            SystemProperties.set("sys.cppreopt", "requested");
            long timeStart = SystemClock.uptimeMillis();
            long timeEnd = timeStart + 100000L;
            long timeNow = timeStart;
            while (!SystemProperties.get("sys.cppreopt").equals("finished")) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((timeNow = SystemClock.uptimeMillis()) <= timeEnd) continue;
                SystemProperties.set("sys.cppreopt", "timed-out");
                Slog.wtf(TAG, "cppreopt did not finish!");
                break;
            }
            Slog.i(TAG, "cppreopts took " + (timeNow - timeStart) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public PackageManagerService(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        LockGuard.installLock(this.mPackages, 3);
        Trace.traceBegin(262144L, "create package manager");
        EventLog.writeEvent(3060, SystemClock.uptimeMillis());
        if (this.mSdkVersion <= 0) {
            Slog.w(TAG, "**** ro.build.version.sdk not set!");
        }
        this.mContext = context;
        this.mPermissionReviewRequired = context.getResources().getBoolean(17956980);
        this.mFactoryTest = factoryTest;
        this.mOnlyCore = onlyCore;
        this.mMetrics = new DisplayMetrics();
        this.mSettings = new Settings(this.mPackages);
        this.mSettings.addSharedUserLPw("android.uid.system", 1000, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.phone", 1001, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.log", 1007, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.nfc", 1027, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.bluetooth", 1002, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.shell", 2000, 1, 8);
        String separateProcesses = SystemProperties.get("debug.separate_processes");
        if (separateProcesses != null && separateProcesses.length() > 0) {
            if ("*".equals(separateProcesses)) {
                this.mDefParseFlags = 8;
                this.mSeparateProcesses = null;
                Slog.w(TAG, "Running with debug.separate_processes: * (ALL)");
            } else {
                this.mDefParseFlags = 0;
                this.mSeparateProcesses = separateProcesses.split(",");
                Slog.w(TAG, "Running with debug.separate_processes: " + separateProcesses);
            }
        } else {
            this.mDefParseFlags = 0;
            this.mSeparateProcesses = null;
        }
        this.mInstaller = installer;
        this.mPackageDexOptimizer = new PackageDexOptimizer(installer, this.mInstallLock, context, "*dexopt*");
        this.mDexManager = new DexManager(this, this.mPackageDexOptimizer, installer, this.mInstallLock);
        this.mMoveCallbacks = new MoveCallbacks(FgThread.get().getLooper());
        this.mOnPermissionChangeListeners = new OnPermissionChangeListeners(FgThread.get().getLooper());
        PackageManagerService.getDefaultDisplayMetrics(context, this.mMetrics);
        Trace.traceBegin(262144L, "get system config");
        SystemConfig systemConfig = SystemConfig.getInstance();
        this.mGlobalGids = systemConfig.getGlobalGids();
        this.mSystemPermissions = systemConfig.getSystemPermissions();
        this.mAvailableFeatures = systemConfig.getAvailableFeatures();
        Trace.traceEnd(262144L);
        this.mProtectedPackages = new ProtectedPackages(this.mContext);
        Object object = this.mInstallLock;
        synchronized (object) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                int[] currentUserIds;
                void var30_56;
                int i;
                Object disabledPs;
                String customResolverActivity;
                this.mHandlerThread = new ServiceThread(TAG, 10, true);
                this.mHandlerThread.start();
                this.mHandler = new PackageHandler(this.mHandlerThread.getLooper());
                this.mProcessLoggingHandler = new ProcessLoggingHandler();
                Watchdog.getInstance().addThread(this.mHandler, 600000L);
                this.mDefaultPermissionPolicy = new DefaultPermissionGrantPolicy(this);
                this.mInstantAppRegistry = new InstantAppRegistry(this);
                File dataDir = Environment.getDataDirectory();
                this.mAppInstallDir = new File(dataDir, "app");
                this.mAppLib32InstallDir = new File(dataDir, "app-lib");
                this.mAsecInternalPath = new File(dataDir, "app-asec").getPath();
                this.mDrmAppPrivateInstallDir = new File(dataDir, "app-private");
                sUserManager = new UserManagerService(context, this, new UserDataPreparer(this.mInstaller, this.mInstallLock, this.mContext, this.mOnlyCore), this.mPackages);
                ArrayMap<String, SystemConfig.PermissionEntry> permConfig = systemConfig.getPermissions();
                for (int i2 = 0; i2 < permConfig.size(); ++i2) {
                    SystemConfig.PermissionEntry perm = permConfig.valueAt(i2);
                    BasePermission bp = this.mSettings.mPermissions.get(perm.name);
                    if (bp == null) {
                        bp = new BasePermission(perm.name, PLATFORM_PACKAGE_NAME, 1);
                        this.mSettings.mPermissions.put(perm.name, bp);
                    }
                    if (perm.gids == null) continue;
                    bp.setGids(perm.gids, perm.perUser);
                }
                ArrayMap<String, String> libConfig = systemConfig.getSharedLibraries();
                int builtInLibCount = libConfig.size();
                for (int i3 = 0; i3 < builtInLibCount; ++i3) {
                    String name = libConfig.keyAt(i3);
                    String path = libConfig.valueAt(i3);
                    this.addSharedLibraryLPw(path, null, name, -1, 0, PLATFORM_PACKAGE_NAME, 0);
                }
                this.mFoundPolicyFile = SELinuxMMAC.readInstallPolicy();
                Trace.traceBegin(262144L, "read user settings");
                this.mFirstBoot = !this.mSettings.readLPw(sUserManager.getUsers(false));
                Trace.traceEnd(262144L);
                int packageSettingCount = this.mSettings.mPackages.size();
                for (int i4 = packageSettingCount - 1; i4 >= 0; --i4) {
                    PackageSetting ps = this.mSettings.mPackages.valueAt(i4);
                    if (PackageManagerService.isExternal(ps) || ps.codePath != null && ps.codePath.exists() || this.mSettings.getDisabledSystemPkgLPr(ps.name) == null) continue;
                    this.mSettings.mPackages.removeAt(i4);
                    this.mSettings.enableSystemPackageLPw(ps.name);
                }
                if (this.mFirstBoot) {
                    PackageManagerService.requestCopyPreoptedFiles();
                }
                if (TextUtils.isEmpty(customResolverActivity = Resources.getSystem().getString(0x1040110))) {
                    customResolverActivity = null;
                } else {
                    this.mCustomResolverComponentName = ComponentName.unflattenFromString(customResolverActivity);
                }
                long startTime = SystemClock.uptimeMillis();
                EventLog.writeEvent(3070, startTime);
                String bootClassPath = System.getenv("BOOTCLASSPATH");
                String systemServerClassPath = System.getenv("SYSTEMSERVERCLASSPATH");
                if (bootClassPath == null) {
                    Slog.w(TAG, "No BOOTCLASSPATH found!");
                }
                if (systemServerClassPath == null) {
                    Slog.w(TAG, "No SYSTEMSERVERCLASSPATH found!");
                }
                File frameworkDir = new File(Environment.getRootDirectory(), "framework");
                Settings.VersionInfo ver = this.mSettings.getInternalVersion();
                boolean bl = this.mIsUpgrade = !Build.FINGERPRINT.equals(ver.fingerprint);
                if (this.mIsUpgrade) {
                    PackageManagerService.logCriticalInfo(4, "Upgrading from " + ver.fingerprint + " to " + Build.FINGERPRINT);
                }
                this.mPromoteSystemApps = this.mIsUpgrade && ver.sdkVersion <= 22;
                this.mIsPreNUpgrade = this.mIsUpgrade && ver.sdkVersion < 24;
                boolean bl2 = this.mIsPreNMR1Upgrade = this.mIsUpgrade && ver.sdkVersion < 25;
                if (this.mPromoteSystemApps) {
                    for (PackageSetting ps : this.mSettings.mPackages.values()) {
                        if (!PackageManagerService.isSystemApp(ps)) continue;
                        this.mExistingSystemPackages.add(ps.name);
                    }
                }
                this.mCacheDir = PackageManagerService.preparePackageParserCache(this.mIsUpgrade);
                int scanFlags = 4160;
                if (this.mIsUpgrade || this.mFirstBoot) {
                    scanFlags |= 0x10000;
                }
                this.scanDirTracedLI(new File(VENDOR_OVERLAY_DIR), this.mDefParseFlags | 1 | 0x40 | 0x200, scanFlags | 0x80, 0L);
                this.mParallelPackageParserCallback.findStaticOverlayPackages();
                this.scanDirTracedLI(frameworkDir, this.mDefParseFlags | 1 | 0x40 | 0x80, scanFlags | 2, 0L);
                File privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app");
                this.scanDirTracedLI(privilegedAppDir, this.mDefParseFlags | 1 | 0x40 | 0x80, scanFlags, 0L);
                File systemAppDir = new File(Environment.getRootDirectory(), "app");
                this.scanDirTracedLI(systemAppDir, this.mDefParseFlags | 1 | 0x40, scanFlags, 0L);
                File vendorAppDir = new File("/vendor/app");
                try {
                    vendorAppDir = vendorAppDir.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.scanDirTracedLI(vendorAppDir, this.mDefParseFlags | 1 | 0x40, scanFlags, 0L);
                File oemAppDir = new File(Environment.getOemDirectory(), "app");
                this.scanDirTracedLI(oemAppDir, this.mDefParseFlags | 1 | 0x40, scanFlags, 0L);
                ArrayList<String> possiblyDeletedUpdatedSystemApps = new ArrayList<String>();
                if (!this.mOnlyCore) {
                    Iterator<PackageSetting> psit = this.mSettings.mPackages.values().iterator();
                    while (psit.hasNext()) {
                        PackageSetting ps = psit.next();
                        if ((ps.pkgFlags & 1) == 0) continue;
                        PackageParser.Package package_ = this.mPackages.get(ps.name);
                        if (package_ != null) {
                            if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) continue;
                            PackageManagerService.logCriticalInfo(5, "Expecting better updated system app for " + ps.name + "; removing system app.  Last known codePath=" + ps.codePathString + ", installStatus=" + ps.installStatus + ", versionCode=" + ps.versionCode + "; scanned versionCode=" + package_.mVersionCode);
                            this.removePackageLI(package_, true);
                            this.mExpectingBetter.put(ps.name, ps.codePath);
                            continue;
                        }
                        if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) {
                            psit.remove();
                            PackageManagerService.logCriticalInfo(5, "System package " + ps.name + " no longer exists; it's data will be wiped");
                            continue;
                        }
                        disabledPs = this.mSettings.getDisabledSystemPkgLPr(ps.name);
                        if (((PackageSetting)disabledPs).codePath != null && ((PackageSetting)disabledPs).codePath.exists()) continue;
                        possiblyDeletedUpdatedSystemApps.add(ps.name);
                    }
                }
                ArrayList<PackageSetting> deletePkgsList = this.mSettings.getListOfIncompleteInstallPackagesLPr();
                for (i = 0; i < deletePkgsList.size(); ++i) {
                    String string2 = deletePkgsList.get((int)i).name;
                    PackageManagerService.logCriticalInfo(5, "Cleaning up incompletely installed app: " + string2);
                    disabledPs = this.mPackages;
                    synchronized (disabledPs) {
                        this.mSettings.removePackageLPw(string2);
                        continue;
                    }
                }
                this.deleteTempPackageFiles();
                this.mSettings.pruneSharedUsersLPw();
                if (!this.mOnlyCore) {
                    EventLog.writeEvent(3080, SystemClock.uptimeMillis());
                    this.scanDirTracedLI(this.mAppInstallDir, 0, scanFlags | 0x400, 0L);
                    this.scanDirTracedLI(this.mDrmAppPrivateInstallDir, this.mDefParseFlags | 0x10, scanFlags | 0x400, 0L);
                    for (String string3 : possiblyDeletedUpdatedSystemApps) {
                        String msg;
                        PackageParser.Package deletedPkg = this.mPackages.get(string3);
                        this.mSettings.removeDisabledSystemPackageLPw(string3);
                        if (deletedPkg == null) {
                            msg = "Updated system package " + string3 + " no longer exists; it's data will be wiped";
                        } else {
                            msg = "Updated system app + " + string3 + " no longer present; removing system privileges for " + string3;
                            deletedPkg.applicationInfo.flags &= 0xFFFFFFFE;
                            PackageSetting deletedPs = this.mSettings.mPackages.get(string3);
                            deletedPs.pkgFlags &= 0xFFFFFFFE;
                        }
                        PackageManagerService.logCriticalInfo(5, msg);
                    }
                    for (i = 0; i < this.mExpectingBetter.size(); ++i) {
                        String string4 = this.mExpectingBetter.keyAt(i);
                        if (this.mPackages.containsKey(string4)) continue;
                        File scanFile = this.mExpectingBetter.valueAt(i);
                        PackageManagerService.logCriticalInfo(5, "Expected better " + string4 + " but never showed up; reverting to system");
                        int reparseFlags = this.mDefParseFlags;
                        if (FileUtils.contains(privilegedAppDir, scanFile)) {
                            reparseFlags = 193;
                        } else if (FileUtils.contains(systemAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else if (FileUtils.contains(vendorAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else if (FileUtils.contains(oemAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else {
                            Slog.e(TAG, "Ignoring unexpected fallback path " + scanFile);
                            continue;
                        }
                        this.mSettings.enableSystemPackageLPw(string4);
                        try {
                            this.scanPackageTracedLI(scanFile, reparseFlags, scanFlags, 0L, null);
                            continue;
                        }
                        catch (PackageManagerException e) {
                            Slog.e(TAG, "Failed to parse original system package: " + e.getMessage());
                        }
                    }
                }
                this.mExpectingBetter.clear();
                this.mStorageManagerPackage = this.getStorageManagerPackageName();
                this.mSetupWizardPackage = this.getSetupWizardPackageName();
                if (this.mProtectedFilters.size() > 0) {
                    for (PackageParser.ActivityIntentInfo activityIntentInfo : this.mProtectedFilters) {
                        if (activityIntentInfo.activity.info.packageName.equals(this.mSetupWizardPackage)) continue;
                        activityIntentInfo.setPriority(0);
                    }
                }
                this.mDeferProtectedFilters = false;
                this.mProtectedFilters.clear();
                this.updateAllSharedLibrariesLPw(null);
                for (SharedUserSetting sharedUserSetting : this.mSettings.getAllSharedUsersLPw()) {
                    this.adjustCpuAbisForSharedUserLPw(sharedUserSetting.packages, null);
                }
                this.mPackageUsage.read(this.mPackages);
                this.mCompilerStats.read();
                EventLog.writeEvent(3090, SystemClock.uptimeMillis());
                Slog.i(TAG, "Time to scan packages: " + (float)(SystemClock.uptimeMillis() - startTime) / 1000.0f + " seconds");
                int updateFlags = 1;
                if (ver.sdkVersion != this.mSdkVersion) {
                    Slog.i(TAG, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for internal storage");
                    updateFlags |= 6;
                }
                this.updatePermissionsLPw(null, null, StorageManager.UUID_PRIVATE_INTERNAL, updateFlags);
                ver.sdkVersion = this.mSdkVersion;
                if (!onlyCore && (this.mPromoteSystemApps || this.mFirstBoot)) {
                    for (UserInfo user : sUserManager.getUsers(true)) {
                        this.mSettings.applyDefaultPreferredAppsLPw(this, user.id);
                        this.applyFactoryDefaultBrowserLPw(user.id);
                        this.primeDomainVerificationsLPw(user.id);
                    }
                }
                if (StorageManager.isFileEncryptedNativeOrEmulated()) {
                    boolean bl3 = true;
                } else {
                    int n = 3;
                }
                List<String> deferPackages = this.reconcileAppsDataLI(StorageManager.UUID_PRIVATE_INTERNAL, 0, (int)var30_56, true, true);
                this.mPrepareAppDataFuture = SystemServerInitThreadPool.get().submit(() -> this.lambda$new$105(deferPackages, (int)var30_56), "prepareAppData");
                if (this.mIsUpgrade && !onlyCore) {
                    Slog.i(TAG, "Build fingerprint changed; clearing code caches");
                    for (int i5 = 0; i5 < this.mSettings.mPackages.size(); ++i5) {
                        PackageSetting ps = this.mSettings.mPackages.valueAt(i5);
                        if (!Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, ps.volumeUuid)) continue;
                        this.clearAppDataLIF(ps.pkg, -1, 515);
                    }
                    ver.fingerprint = Build.FINGERPRINT;
                }
                this.checkDefaultBrowser();
                this.mExistingSystemPackages.clear();
                this.mPromoteSystemApps = false;
                ver.databaseVersion = 3;
                Trace.traceBegin(262144L, "write settings");
                this.mSettings.writeLPr();
                Trace.traceEnd(262144L);
                EventLog.writeEvent(3100, SystemClock.uptimeMillis());
                if (!this.mOnlyCore) {
                    this.mRequiredVerifierPackage = this.getRequiredButNotReallyRequiredVerifierLPr();
                    this.mRequiredInstallerPackage = this.getRequiredInstallerLPr();
                    this.mRequiredUninstallerPackage = this.getRequiredUninstallerLPr();
                    this.mIntentFilterVerifierComponent = this.getIntentFilterVerifierComponentNameLPr();
                    this.mIntentFilterVerifier = this.mIntentFilterVerifierComponent != null ? new IntentVerifierProxy(this.mContext, this.mIntentFilterVerifierComponent) : null;
                    this.mServicesSystemSharedLibraryPackageName = this.getRequiredSharedLibraryLPr("android.ext.services", -1);
                    this.mSharedSystemSharedLibraryPackageName = this.getRequiredSharedLibraryLPr("android.ext.shared", -1);
                } else {
                    this.mRequiredVerifierPackage = null;
                    this.mRequiredInstallerPackage = null;
                    this.mRequiredUninstallerPackage = null;
                    this.mIntentFilterVerifierComponent = null;
                    this.mIntentFilterVerifier = null;
                    this.mServicesSystemSharedLibraryPackageName = null;
                    this.mSharedSystemSharedLibraryPackageName = null;
                }
                this.mInstallerService = new PackageInstallerService(context, this);
                Pair<ComponentName, String> instantAppResolverComponent = this.getInstantAppResolverLPr();
                if (instantAppResolverComponent != null) {
                    if (DEBUG_EPHEMERAL) {
                        Slog.d(TAG, "Set ephemeral resolver: " + instantAppResolverComponent);
                    }
                    this.mInstantAppResolverConnection = new EphemeralResolverConnection(this.mContext, (ComponentName)instantAppResolverComponent.first, (String)instantAppResolverComponent.second);
                    this.mInstantAppResolverSettingsComponent = this.getInstantAppResolverSettingsLPr((ComponentName)instantAppResolverComponent.first);
                } else {
                    this.mInstantAppResolverConnection = null;
                    this.mInstantAppResolverSettingsComponent = null;
                }
                this.updateInstantAppInstallerLocked(null);
                HashMap<Integer, List<PackageInfo>> userPackages = new HashMap<Integer, List<PackageInfo>>();
                for (int userId : currentUserIds = UserManagerService.getInstance().getUserIds()) {
                    userPackages.put(userId, this.getInstalledPackages(0, userId).getList());
                }
                this.mDexManager.load(userPackages);
            }
        }
        Trace.traceBegin(262144L, "GC");
        Runtime.getRuntime().gc();
        Trace.traceEnd(262144L);
        Trace.traceBegin(262144L, "loadFallbacks");
        FallbackCategoryProvider.loadFallbacks();
        Trace.traceEnd(262144L);
        this.mInstaller.setWarnIfHeld(this.mPackages);
        LocalServices.addService(PackageManagerInternal.class, new PackageManagerInternalImpl());
        Trace.traceEnd(262144L);
    }

    private void updateInstantAppInstallerLocked(String modifiedPackage) {
        if (this.mInstantAppInstallerActivity != null && !this.mInstantAppInstallerActivity.getComponentName().getPackageName().equals(modifiedPackage)) {
            return;
        }
        this.setUpInstantAppInstallerActivityLP(this.getInstantAppInstallerLPr());
    }

    private static File preparePackageParserCache(boolean isUpgrade) {
        if ("eng".equals(Build.TYPE)) {
            return null;
        }
        if (SystemProperties.getBoolean("pm.boot.disable_package_cache", false)) {
            Slog.i(TAG, "Disabling package parser cache due to system property.");
            return null;
        }
        File cacheBaseDir = FileUtils.createDir(Environment.getDataSystemDirectory(), "package_cache");
        if (cacheBaseDir == null) {
            return null;
        }
        if (isUpgrade) {
            FileUtils.deleteContents(cacheBaseDir);
        }
        File cacheDir = FileUtils.createDir(cacheBaseDir, PACKAGE_PARSER_CACHE_VERSION);
        if ("userdebug".equals(Build.TYPE) && Build.VERSION.INCREMENTAL.startsWith("eng.")) {
            Slog.w(TAG, "Wiping cache directory because the system partition changed.");
            File frameworkDir = new File(Environment.getRootDirectory(), "framework");
            if (cacheDir.lastModified() < frameworkDir.lastModified()) {
                FileUtils.deleteContents(cacheBaseDir);
                cacheDir = FileUtils.createDir(cacheBaseDir, PACKAGE_PARSER_CACHE_VERSION);
            }
        }
        return cacheDir;
    }

    @Override
    public boolean isFirstBoot() {
        return this.mFirstBoot;
    }

    @Override
    public boolean isOnlyCoreApps() {
        return this.mOnlyCore;
    }

    @Override
    public boolean isUpgrade() {
        return this.mIsUpgrade;
    }

    private String getRequiredButNotReallyRequiredVerifierLPr() {
        Intent intent = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> matches = this.queryIntentReceiversInternal(intent, PACKAGE_MIME_TYPE, 0x1C0000, 0);
        if (matches.size() == 1) {
            return matches.get((int)0).getComponentInfo().packageName;
        }
        if (matches.size() == 0) {
            Log.e(TAG, "There should probably be a verifier, but, none were found");
            return null;
        }
        throw new RuntimeException("There must be exactly one verifier; found " + matches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequiredSharedLibraryLPr(String name, int version) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedLibraryEntry libraryEntry = this.getSharedLibraryEntryLPr(name, version);
            if (libraryEntry == null) {
                throw new IllegalStateException("Missing required shared library:" + name);
            }
            return libraryEntry.apk;
        }
    }

    private String getRequiredInstallerLPr() {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.fromFile(new File("foo.apk")), PACKAGE_MIME_TYPE);
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, PACKAGE_MIME_TYPE, 0x1C0000, 0);
        if (matches.size() == 1) {
            ResolveInfo resolveInfo = matches.get(0);
            if (!resolveInfo.activityInfo.applicationInfo.isPrivilegedApp()) {
                throw new RuntimeException("The installer must be a privileged app");
            }
            return matches.get((int)0).getComponentInfo().packageName;
        }
        throw new RuntimeException("There must be exactly one installer; found " + matches);
    }

    private String getRequiredUninstallerLPr() {
        Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setData(Uri.fromParts(PACKAGE_SCHEME, "foo.bar", null));
        ResolveInfo resolveInfo = this.resolveIntent(intent, null, 0x1C0000, 0);
        if (resolveInfo == null || this.mResolveActivity.name.equals(resolveInfo.getComponentInfo().name)) {
            throw new RuntimeException("There must be exactly one uninstaller; found " + resolveInfo);
        }
        return resolveInfo.getComponentInfo().packageName;
    }

    private ComponentName getIntentFilterVerifierComponentNameLPr() {
        Intent intent = new Intent("android.intent.action.INTENT_FILTER_NEEDS_VERIFICATION");
        List<ResolveInfo> matches = this.queryIntentReceiversInternal(intent, PACKAGE_MIME_TYPE, 0x1C0000, 0);
        ResolveInfo best = null;
        int N = matches.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo cur = matches.get(i);
            String packageName = cur.getComponentInfo().packageName;
            if (this.checkPermission("android.permission.INTENT_FILTER_VERIFICATION_AGENT", packageName, 0) != 0 || best != null && cur.priority <= best.priority) continue;
            best = cur;
        }
        if (best != null) {
            return best.getComponentInfo().getComponentName();
        }
        Slog.w(TAG, "Intent filter verifier not found");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getInstantAppResolverComponent() {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Pair<ComponentName, String> instantAppResolver = this.getInstantAppResolverLPr();
            if (instantAppResolver == null) {
                return null;
            }
            return (ComponentName)instantAppResolver.first;
        }
    }

    private Pair<ComponentName, String> getInstantAppResolverLPr() {
        int N;
        int callingUid;
        String[] packageArray = this.mContext.getResources().getStringArray(17236005);
        if (packageArray.length == 0 && !Build.IS_DEBUGGABLE) {
            if (DEBUG_EPHEMERAL) {
                Slog.d(TAG, "Ephemeral resolver NOT found; empty package list");
            }
            return null;
        }
        String actionName = "android.intent.action.RESOLVE_INSTANT_APP_PACKAGE";
        Intent resolverIntent = new Intent(actionName);
        int resolveFlags = 0xC0000 | (!Build.IS_DEBUGGABLE ? 0x100000 : 0);
        List<ResolveInfo> resolvers = this.queryIntentServicesInternal(resolverIntent, null, resolveFlags, 0, callingUid = Binder.getCallingUid(), false);
        if (resolvers.size() == 0) {
            if (DEBUG_EPHEMERAL) {
                Slog.d(TAG, "Ephemeral resolver not found with new action; try old one");
            }
            actionName = "android.intent.action.RESOLVE_EPHEMERAL_PACKAGE";
            resolverIntent.setAction(actionName);
            resolvers = this.queryIntentServicesInternal(resolverIntent, null, resolveFlags, 0, callingUid, false);
        }
        if ((N = resolvers.size()) == 0) {
            if (DEBUG_EPHEMERAL) {
                Slog.d(TAG, "Ephemeral resolver NOT found; no matching intent filters");
            }
            return null;
        }
        ArraySet<String> possiblePackages = new ArraySet<String>(Arrays.asList(packageArray));
        for (int i = 0; i < N; ++i) {
            ResolveInfo info = resolvers.get(i);
            if (info.serviceInfo == null) continue;
            String packageName = info.serviceInfo.packageName;
            if (!possiblePackages.contains(packageName) && !Build.IS_DEBUGGABLE) {
                if (!DEBUG_EPHEMERAL) continue;
                Slog.d(TAG, "Ephemeral resolver not in allowed package list; pkg: " + packageName + ", info:" + info);
                continue;
            }
            if (DEBUG_EPHEMERAL) {
                Slog.v(TAG, "Ephemeral resolver found; pkg: " + packageName + ", info:" + info);
            }
            return new Pair<ComponentName, String>(new ComponentName(packageName, info.serviceInfo.name), actionName);
        }
        if (DEBUG_EPHEMERAL) {
            Slog.v(TAG, "Ephemeral resolver NOT found");
        }
        return null;
    }

    private ActivityInfo getInstantAppInstallerLPr() {
        Intent intent = new Intent("android.intent.action.INSTALL_INSTANT_APP_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.fromFile(new File("foo.apk")), PACKAGE_MIME_TYPE);
        int resolveFlags = 0xC0000 | (!Build.IS_DEBUGGABLE ? 0x100000 : 0);
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, PACKAGE_MIME_TYPE, resolveFlags, 0);
        if (matches.isEmpty()) {
            if (DEBUG_EPHEMERAL) {
                Slog.d(TAG, "Ephemeral installer not found with new action; try old one");
            }
            intent.setAction("android.intent.action.INSTALL_EPHEMERAL_PACKAGE");
            matches = this.queryIntentActivitiesInternal(intent, PACKAGE_MIME_TYPE, resolveFlags, 0);
        }
        Iterator<ResolveInfo> iter = matches.iterator();
        while (iter.hasNext()) {
            PermissionsState permissionsState;
            ResolveInfo rInfo = iter.next();
            PackageSetting ps = this.mSettings.mPackages.get(rInfo.activityInfo.packageName);
            if (ps != null && (permissionsState = ps.getPermissionsState()).hasPermission("android.permission.INSTALL_PACKAGES", 0)) continue;
            iter.remove();
        }
        if (matches.size() == 0) {
            return null;
        }
        if (matches.size() == 1) {
            return (ActivityInfo)matches.get(0).getComponentInfo();
        }
        throw new RuntimeException("There must be at most one ephemeral installer; found " + matches);
    }

    private ComponentName getInstantAppResolverSettingsLPr(ComponentName resolver) {
        Intent intent = new Intent("android.intent.action.INSTANT_APP_RESOLVER_SETTINGS").addCategory("android.intent.category.DEFAULT").setPackage(resolver.getPackageName());
        int resolveFlags = 786432;
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, null, 786432, 0);
        if (matches.isEmpty()) {
            if (DEBUG_EPHEMERAL) {
                Slog.d(TAG, "Ephemeral resolver settings not found with new action; try old one");
            }
            intent.setAction("android.intent.action.EPHEMERAL_RESOLVER_SETTINGS");
            matches = this.queryIntentActivitiesInternal(intent, null, 786432, 0);
        }
        if (matches.isEmpty()) {
            return null;
        }
        return matches.get(0).getComponentInfo().getComponentName();
    }

    private void primeDomainVerificationsLPw(int userId) {
        SystemConfig systemConfig = SystemConfig.getInstance();
        ArraySet<String> packages = systemConfig.getLinkedApps();
        for (String packageName : packages) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg != null) {
                if (!pkg.isSystemApp()) {
                    Slog.w(TAG, "Non-system app '" + packageName + "' in sysconfig <app-link>");
                    continue;
                }
                ArraySet<String> domains = null;
                for (PackageParser.Activity a : pkg.activities) {
                    for (PackageParser.ActivityIntentInfo filter : a.intents) {
                        if (!PackageManagerService.hasValidDomains(filter)) continue;
                        if (domains == null) {
                            domains = new ArraySet<String>();
                        }
                        domains.addAll(filter.getHostsList());
                    }
                }
                if (domains != null && domains.size() > 0) {
                    IntentFilterVerificationInfo ivi = this.mSettings.createIntentFilterVerificationIfNeededLPw(packageName, domains);
                    ivi.setStatus(0);
                    this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, 2, userId);
                    continue;
                }
                Slog.w(TAG, "Sysconfig <app-link> package '" + packageName + "' does not handle web links");
                continue;
            }
            Slog.w(TAG, "Unknown package " + packageName + " in sysconfig <app-link>");
        }
        this.scheduleWritePackageRestrictionsLocked(userId);
        this.scheduleWriteSettingsLocked();
    }

    private void applyFactoryDefaultBrowserLPw(int userId) {
        String browserPkg = this.mContext.getResources().getString(17039745);
        if (!TextUtils.isEmpty(browserPkg)) {
            PackageSetting ps = this.mSettings.mPackages.get(browserPkg);
            if (ps == null) {
                Slog.e(TAG, "Product default browser app does not exist: " + browserPkg);
                browserPkg = null;
            } else {
                this.mSettings.setDefaultBrowserPackageNameLPw(browserPkg, userId);
            }
        }
        if (browserPkg == null) {
            this.calculateDefaultBrowserLPw(userId);
        }
    }

    private void calculateDefaultBrowserLPw(int userId) {
        List<String> allBrowsers = this.resolveAllBrowserApps(userId);
        String browserPkg = allBrowsers.size() == 1 ? allBrowsers.get(0) : null;
        this.mSettings.setDefaultBrowserPackageNameLPw(browserPkg, userId);
    }

    private List<String> resolveAllBrowserApps(int userId) {
        List<ResolveInfo> list = this.queryIntentActivitiesInternal(sBrowserIntent, null, 131072, userId);
        int count = list.size();
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            ResolveInfo info = list.get(i);
            if (info.activityInfo == null || !info.handleAllWebDataURI || (info.activityInfo.applicationInfo.flags & 1) == 0 || result.contains(info.activityInfo.packageName)) continue;
            result.add(info.activityInfo.packageName);
        }
        return result;
    }

    private boolean packageIsBrowser(String packageName, int userId) {
        List<ResolveInfo> list = this.queryIntentActivitiesInternal(sBrowserIntent, null, 131072, userId);
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo info = list.get(i);
            if (!packageName.equals(info.activityInfo.packageName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDefaultBrowser() {
        PackageInfo info;
        int myUserId = UserHandle.myUserId();
        String packageName = this.getDefaultBrowserPackageName(myUserId);
        if (packageName != null && (info = this.getPackageInfo(packageName, 0, myUserId)) == null) {
            Slog.w(TAG, "Default browser no longer installed: " + packageName);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.applyFactoryDefaultBrowserLPw(myUserId);
            }
        }
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException) && !(e instanceof IllegalArgumentException)) {
                Slog.wtf(TAG, "Package Manager Crash", e);
            }
            throw e;
        }
    }

    static int[] appendInts(int[] cur, int[] add) {
        if (add == null) {
            return cur;
        }
        if (cur == null) {
            return add;
        }
        int N = add.length;
        for (int i = 0; i < N; ++i) {
            cur = ArrayUtils.appendInt(cur, add[i]);
        }
        return cur;
    }

    private boolean canViewInstantApps(int callingUid, int userId) {
        ComponentName homeComponent;
        if (callingUid == 1000 || callingUid == 2000 || callingUid == 0) {
            return true;
        }
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS") == 0) {
            return true;
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.VIEW_INSTANT_APPS") == 0 && (homeComponent = this.getDefaultHomeActivity(userId)) != null && this.isCallerSameApp(homeComponent.getPackageName(), callingUid);
    }

    private PackageInfo generatePackageInfo(PackageSetting ps, int flags, int userId) {
        PackageInfo packageInfo;
        if (!sUserManager.exists(userId)) {
            return null;
        }
        if (ps == null) {
            return null;
        }
        PackageParser.Package p = ps.pkg;
        if (p == null) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        if (this.filterAppAccessLPr(ps, callingUid, userId)) {
            return null;
        }
        PermissionsState permissionsState = ps.getPermissionsState();
        int[] gids = (flags & 0x100) == 0 ? EMPTY_INT_ARRAY : permissionsState.computeGids(userId);
        Set<String> permissions = ArrayUtils.isEmpty(p.requestedPermissions) ? Collections.emptySet() : permissionsState.getPermissions(userId);
        PackageUserState state = ps.readUserState(userId);
        if ((flags & 0x2000) != 0 && ps.isSystem()) {
            flags |= 0x400000;
        }
        if ((packageInfo = PackageParser.generatePackageInfo(p, gids, flags, ps.firstInstallTime, ps.lastUpdateTime, permissions, state, userId)) == null) {
            return null;
        }
        packageInfo.packageName = packageInfo.applicationInfo.packageName = this.resolveExternalPackageNameLPr(p);
        return packageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPackageStartable(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        boolean userKeyUnlocked = StorageManager.isUserKeyUnlocked(userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                throw new SecurityException("Package " + packageName + " was not found!");
            }
            if (!ps.getInstalled(userId)) {
                throw new SecurityException("Package " + packageName + " was not installed for user " + userId + "!");
            }
            if (this.mSafeMode && !ps.isSystem()) {
                throw new SecurityException("Package " + packageName + " not a system app!");
            }
            if (this.mFrozenPackages.contains(packageName)) {
                throw new SecurityException("Package " + packageName + " is currently frozen!");
            }
            if (!(userKeyUnlocked || ps.pkg.applicationInfo.isDirectBootAware() || ps.pkg.applicationInfo.isPartiallyDirectBootAware())) {
                throw new SecurityException("Package " + packageName + " is not encryption aware!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageAvailable(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return false;
        }
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, false, false, "is package available");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageUserState state;
                PackageSetting ps = (PackageSetting)p.mExtras;
                if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                    return false;
                }
                if (ps != null && (state = ps.readUserState(userId)) != null) {
                    return PackageParser.isAvailable(state);
                }
            }
        }
        return false;
    }

    @Override
    public PackageInfo getPackageInfo(String packageName, int flags, int userId) {
        return this.getPackageInfoInternal(packageName, -1, flags, Binder.getCallingUid(), userId);
    }

    @Override
    public PackageInfo getPackageInfoVersioned(VersionedPackage versionedPackage, int flags, int userId) {
        return this.getPackageInfoInternal(versionedPackage.getPackageName(), versionedPackage.getVersionCode(), flags, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageInfo getPackageInfoInternal(String packageName, int versionCode, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForPackage(flags, userId, packageName);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get package info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            boolean matchFactoryOnly;
            packageName = this.resolveInternalPackageNameLPr(packageName, versionCode);
            boolean bl = matchFactoryOnly = (flags & 0x200000) != 0;
            if (matchFactoryOnly && (ps = this.mSettings.getDisabledSystemPkgLPr(packageName)) != null) {
                if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                    return null;
                }
                return this.generatePackageInfo(ps, flags, userId);
            }
            PackageParser.Package p = this.mPackages.get(packageName);
            if (matchFactoryOnly && p != null && !PackageManagerService.isSystemApp(p)) {
                return null;
            }
            if (p != null) {
                PackageSetting ps2 = (PackageSetting)p.mExtras;
                if (this.filterSharedLibPackageLPr(ps2, filterCallingUid, userId, flags)) {
                    return null;
                }
                if (ps2 != null && this.filterAppAccessLPr(ps2, filterCallingUid, userId)) {
                    return null;
                }
                return this.generatePackageInfo((PackageSetting)p.mExtras, flags, userId);
            }
            if (!matchFactoryOnly && (flags & 0x402000) != 0) {
                PackageSetting ps3 = this.mSettings.mPackages.get(packageName);
                if (ps3 == null) {
                    return null;
                }
                if (this.filterSharedLibPackageLPr(ps3, filterCallingUid, userId, flags)) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps3, filterCallingUid, userId)) {
                    return null;
                }
                return this.generatePackageInfo(ps3, flags, userId);
            }
        }
        return null;
    }

    private boolean isComponentVisibleToInstantApp(ComponentName component) {
        if (this.isComponentVisibleToInstantApp(component, 1)) {
            return true;
        }
        if (this.isComponentVisibleToInstantApp(component, 3)) {
            return true;
        }
        return this.isComponentVisibleToInstantApp(component, 4);
    }

    private boolean isComponentVisibleToInstantApp(ComponentName component, int type) {
        if (type == 1) {
            PackageParser.Activity activity = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            return activity != null ? (activity.info.flags & 0x100000) != 0 : false;
        }
        if (type == 2) {
            PackageParser.Activity activity = (PackageParser.Activity)this.mReceivers.mActivities.get(component);
            return activity != null ? (activity.info.flags & 0x100000) != 0 : false;
        }
        if (type == 3) {
            PackageParser.Service service = (PackageParser.Service)this.mServices.mServices.get(component);
            return service != null ? (service.info.flags & 0x100000) != 0 : false;
        }
        if (type == 4) {
            PackageParser.Provider provider = (PackageParser.Provider)this.mProviders.mProviders.get(component);
            return provider != null ? (provider.info.flags & 0x100000) != 0 : false;
        }
        if (type == 0) {
            return this.isComponentVisibleToInstantApp(component);
        }
        return false;
    }

    private boolean filterAppAccessLPr(PackageSetting ps, int callingUid, ComponentName component, int componentType, int userId) {
        String instantAppPkgName;
        boolean callerIsInstantApp;
        if (Process.isIsolated(callingUid)) {
            callingUid = this.mIsolatedOwners.get(callingUid);
        }
        boolean bl = callerIsInstantApp = (instantAppPkgName = this.getInstantAppPackageName(callingUid)) != null;
        if (ps == null) {
            return callerIsInstantApp;
        }
        if (this.isCallerSameApp(ps.name, callingUid)) {
            return false;
        }
        if (callerIsInstantApp) {
            if (component != null) {
                return !this.isComponentVisibleToInstantApp(component, componentType);
            }
            return ps.getInstantApp(userId) || !ps.pkg.visibleToInstantApps;
        }
        if (ps.getInstantApp(userId)) {
            if (this.canViewInstantApps(callingUid, userId)) {
                return false;
            }
            if (component != null) {
                return true;
            }
            return !this.mInstantAppRegistry.isInstantAccessGranted(userId, UserHandle.getAppId(callingUid), ps.appId);
        }
        return false;
    }

    private boolean filterAppAccessLPr(PackageSetting ps, int callingUid, int userId) {
        return this.filterAppAccessLPr(ps, callingUid, null, 0, userId);
    }

    private boolean filterSharedLibPackageLPr(PackageSetting ps, int uid, int userId, int flags) {
        int appId;
        if ((flags & 0x4000000) != 0 && ((appId = UserHandle.getAppId(uid)) == 1000 || appId == 2000 || appId == 0)) {
            return false;
        }
        if (ps == null || ps.pkg == null || !ps.pkg.applicationInfo.isStaticSharedLibrary()) {
            return false;
        }
        SharedLibraryEntry libEntry = this.getSharedLibraryEntryLPr(ps.pkg.staticSharedLibName, ps.pkg.staticSharedLibVersion);
        if (libEntry == null) {
            return false;
        }
        int resolvedUid = UserHandle.getUid(userId, UserHandle.getAppId(uid));
        String[] uidPackageNames = this.getPackagesForUid(resolvedUid);
        if (uidPackageNames == null) {
            return true;
        }
        for (String uidPackageName : uidPackageNames) {
            int index;
            if (ps.name.equals(uidPackageName)) {
                return false;
            }
            PackageSetting uidPs = this.mSettings.getPackageLPr(uidPackageName);
            if (uidPs == null || (index = ArrayUtils.indexOf(uidPs.usesStaticLibraries, libEntry.info.getName())) < 0 || uidPs.pkg.usesStaticLibrariesVersions[index] != libEntry.info.getVersion()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] currentToCanonicalPackageNames(String[] names) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return names;
        }
        String[] out = new String[names.length];
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUserId = UserHandle.getUserId(callingUid);
            boolean canViewInstantApps = this.canViewInstantApps(callingUid, callingUserId);
            for (int i = names.length - 1; i >= 0; --i) {
                PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                boolean translateName = false;
                if (ps != null && ps.realName != null) {
                    boolean targetIsInstantApp = ps.getInstantApp(callingUserId);
                    translateName = !targetIsInstantApp || canViewInstantApps || this.mInstantAppRegistry.isInstantAccessGranted(callingUserId, UserHandle.getAppId(callingUid), ps.appId);
                }
                out[i] = translateName ? ps.realName : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] canonicalToCurrentPackageNames(String[] names) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return names;
        }
        String[] out = new String[names.length];
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUserId = UserHandle.getUserId(callingUid);
            boolean canViewInstantApps = this.canViewInstantApps(callingUid, callingUserId);
            for (int i = names.length - 1; i >= 0; --i) {
                String cur = this.mSettings.getRenamedPackageLPr(names[i]);
                boolean translateName = false;
                if (cur != null) {
                    PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                    boolean targetIsInstantApp = ps != null && ps.getInstantApp(callingUserId);
                    translateName = !targetIsInstantApp || canViewInstantApps || this.mInstantAppRegistry.isInstantAccessGranted(callingUserId, UserHandle.getAppId(callingUid), ps.appId);
                }
                out[i] = translateName ? cur : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageUid(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForPackage(flags, userId, packageName);
        this.enforceCrossUserPermission(callingUid, userId, false, false, "getPackageUid");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null && p.isMatch(flags)) {
                PackageSetting ps2 = (PackageSetting)p.mExtras;
                if (this.filterAppAccessLPr(ps2, callingUid, userId)) {
                    return -1;
                }
                return UserHandle.getUid(userId, p.applicationInfo.uid);
            }
            if ((flags & 0x402000) != 0 && (ps = this.mSettings.mPackages.get(packageName)) != null && ps.isMatch(flags) && !this.filterAppAccessLPr(ps, callingUid, userId)) {
                return UserHandle.getUid(userId, ps.appId);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPackageGids(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForPackage(flags, userId, packageName);
        this.enforceCrossUserPermission(callingUid, userId, false, false, "getPackageGids");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null && p.isMatch(flags)) {
                PackageSetting ps2 = (PackageSetting)p.mExtras;
                if (this.filterAppAccessLPr(ps2, callingUid, userId)) {
                    return null;
                }
                return ps2.getPermissionsState().computeGids(userId);
            }
            if ((flags & 0x402000) != 0 && (ps = this.mSettings.mPackages.get(packageName)) != null && ps.isMatch(flags) && !this.filterAppAccessLPr(ps, callingUid, userId)) {
                return ps.getPermissionsState().computeGids(userId);
            }
        }
        return null;
    }

    static PermissionInfo generatePermissionInfo(BasePermission bp, int flags) {
        if (bp.perm != null) {
            return PackageParser.generatePermissionInfo(bp.perm, flags);
        }
        PermissionInfo pi = new PermissionInfo();
        pi.name = bp.name;
        pi.packageName = bp.sourcePackage;
        pi.nonLocalizedLabel = bp.name;
        pi.protectionLevel = bp.protectionLevel;
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo getPermissionInfo(String name, String packageName, int flags) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            BasePermission p = this.mSettings.mPermissions.get(name);
            if (p == null) {
                return null;
            }
            PermissionInfo permissionInfo = PackageManagerService.generatePermissionInfo(p, flags);
            if (permissionInfo != null) {
                permissionInfo.protectionLevel = this.adjustPermissionProtectionFlagsLPr(permissionInfo.protectionLevel, packageName, callingUid);
            }
            return permissionInfo;
        }
    }

    private int adjustPermissionProtectionFlagsLPr(int protectionLevel, String packageName, int uid) {
        int protectionLevelMasked = protectionLevel & 3;
        if (protectionLevelMasked == 2) {
            return protectionLevel;
        }
        int appId = UserHandle.getAppId(uid);
        if (appId == 1000 || appId == 0 || appId == 2000) {
            return protectionLevel;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName = this.resolveInternalPackageNameLPr(packageName, -1));
        if (ps == null) {
            return protectionLevel;
        }
        if (ps.appId != appId) {
            return protectionLevel;
        }
        PackageParser.Package pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            return protectionLevel;
        }
        if (pkg.applicationInfo.targetSdkVersion < 26) {
            return protectionLevelMasked;
        }
        return protectionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PermissionInfo> queryPermissionsByGroup(String group, int flags) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (group != null && !this.mPermissionGroups.containsKey(group)) {
                return null;
            }
            ArrayList<PermissionInfo> out = new ArrayList<PermissionInfo>(10);
            for (BasePermission p : this.mSettings.mPermissions.values()) {
                if (group == null) {
                    if (p.perm != null && p.perm.info.group != null) continue;
                    out.add(PackageManagerService.generatePermissionInfo(p, flags));
                    continue;
                }
                if (p.perm == null || !group.equals(p.perm.info.group)) continue;
                out.add(PackageParser.generatePermissionInfo(p.perm, flags));
            }
            return new ParceledListSlice<PermissionInfo>(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return PackageParser.generatePermissionGroupInfo(this.mPermissionGroups.get(name), flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return ParceledListSlice.emptyList();
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int N = this.mPermissionGroups.size();
            ArrayList<PermissionGroupInfo> out = new ArrayList<PermissionGroupInfo>(N);
            for (PackageParser.PermissionGroup pg : this.mPermissionGroups.values()) {
                out.add(PackageParser.generatePermissionGroupInfo(pg, flags));
            }
            return new ParceledListSlice<PermissionGroupInfo>(out);
        }
    }

    private ApplicationInfo generateApplicationInfoFromSettingsLPw(String packageName, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                return null;
            }
            if (this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                return null;
            }
            if (ps.pkg == null) {
                PackageInfo pInfo = this.generatePackageInfo(ps, flags, userId);
                if (pInfo != null) {
                    return pInfo.applicationInfo;
                }
                return null;
            }
            ApplicationInfo ai = PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId);
            if (ai != null) {
                ai.packageName = this.resolveExternalPackageNameLPr(ps.pkg);
            }
            return ai;
        }
        return null;
    }

    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) {
        return this.getApplicationInfoInternal(packageName, flags, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationInfo getApplicationInfoInternal(String packageName, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForApplication(flags, userId, packageName);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get application info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            packageName = this.resolveInternalPackageNameLPr(packageName, -1);
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) {
                    return null;
                }
                if (this.filterSharedLibPackageLPr(ps, filterCallingUid, userId, flags)) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, filterCallingUid, userId)) {
                    return null;
                }
                ApplicationInfo ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId);
                if (ai != null) {
                    ai.packageName = this.resolveExternalPackageNameLPr(p);
                }
                return ai;
            }
            if (PLATFORM_PACKAGE_NAME.equals(packageName) || "system".equals(packageName)) {
                return this.mAndroidApplication;
            }
            if ((flags & 0x402000) != 0) {
                return this.generateApplicationInfoFromSettingsLPw(packageName, flags, filterCallingUid, userId);
            }
        }
        return null;
    }

    private String normalizePackageNameLPr(String packageName) {
        String normalizedPackageName = this.mSettings.getRenamedPackageLPr(packageName);
        return normalizedPackageName != null ? normalizedPackageName : packageName;
    }

    @Override
    public void deletePreloadsFileCache() {
        if (!UserHandle.isSameApp(Binder.getCallingUid(), 1000)) {
            throw new SecurityException("Only system or settings may call deletePreloadsFileCache");
        }
        File dir = Environment.getDataPreloadsFileCacheDirectory();
        Slog.i(TAG, "Deleting preloaded file cache " + dir);
        FileUtils.deleteContents(dir);
    }

    @Override
    public void freeStorageAndNotify(String volumeUuid, long freeStorageSize, int storageFlags, IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(() -> {
            boolean success = false;
            try {
                this.freeStorage(volumeUuid, freeStorageSize, storageFlags);
                success = true;
            }
            catch (IOException e) {
                Slog.w(TAG, e);
            }
            if (observer != null) {
                try {
                    observer.onRemoveCompleted(null, success);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, e);
                }
            }
        });
    }

    @Override
    public void freeStorage(String volumeUuid, long freeStorageSize, int storageFlags, IntentSender pi) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", TAG);
        this.mHandler.post(() -> {
            boolean success = false;
            try {
                this.freeStorage(volumeUuid, freeStorageSize, storageFlags);
                success = true;
            }
            catch (IOException e) {
                Slog.w(TAG, e);
            }
            if (pi != null) {
                try {
                    pi.sendIntent(null, success ? 1 : 0, null, null, null);
                }
                catch (IntentSender.SendIntentException e) {
                    Slog.w(TAG, e);
                }
            }
        });
    }

    public void freeStorage(String volumeUuid, long bytes, int storageFlags) throws IOException {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        File file = storage.findPathForUuid(volumeUuid);
        if (file.getUsableSpace() >= bytes) {
            return;
        }
        if (ENABLE_FREE_CACHE_V2) {
            long reservedBytes;
            boolean internalVolume = Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, volumeUuid);
            boolean aggressive = (storageFlags & 1) != 0;
            boolean defyReserved = (storageFlags & 2) != 0;
            long l = reservedBytes = aggressive || defyReserved ? 0L : storage.getStorageCacheBytes(file);
            if (internalVolume && (aggressive || SystemProperties.getBoolean("persist.sys.preloads.file_cache_expired", false))) {
                this.deletePreloadsFileCache();
                if (file.getUsableSpace() >= bytes) {
                    return;
                }
            }
            if (internalVolume && aggressive) {
                FileUtils.deleteContents(this.mCacheDir);
                if (file.getUsableSpace() >= bytes) {
                    return;
                }
            }
            try {
                this.mInstaller.freeCache(volumeUuid, bytes, reservedBytes, 8192);
            }
            catch (Installer.InstallerException installerException) {
                // empty catch block
            }
            if (file.getUsableSpace() >= bytes) {
                return;
            }
            if (internalVolume && this.pruneUnusedStaticSharedLibraries(bytes, Settings.Global.getLong(this.mContext.getContentResolver(), "unused_static_shared_lib_min_cache_period", 0x6DDD00L))) {
                return;
            }
            if (internalVolume && this.mInstantAppRegistry.pruneInstalledInstantApps(bytes, Settings.Global.getLong(this.mContext.getContentResolver(), "installed_instant_app_min_cache_period", 604800000L))) {
                return;
            }
            try {
                this.mInstaller.freeCache(volumeUuid, bytes, reservedBytes, 24576);
            }
            catch (Installer.InstallerException installerException) {
                // empty catch block
            }
            if (file.getUsableSpace() >= bytes) {
                return;
            }
            if (internalVolume && this.mInstantAppRegistry.pruneUninstalledInstantApps(bytes, Settings.Global.getLong(this.mContext.getContentResolver(), "uninstalled_instant_app_min_cache_period", 604800000L))) {
                return;
            }
        } else {
            try {
                this.mInstaller.freeCache(volumeUuid, bytes, 0L, 0);
            }
            catch (Installer.InstallerException installerException) {
                // empty catch block
            }
            if (file.getUsableSpace() >= bytes) {
                return;
            }
        }
        throw new IOException("Failed to free " + bytes + " on storage device at " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pruneUnusedStaticSharedLibraries(long neededSpace, long maxCachePeriod) throws IOException {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        File volume = storage.findPathForUuid(StorageManager.UUID_PRIVATE_INTERNAL);
        ArrayList<VersionedPackage> packagesToDelete = null;
        long now = System.currentTimeMillis();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int[] allUsers = sUserManager.getUserIds();
            int libCount = this.mSharedLibraries.size();
            for (int i = 0; i < libCount; ++i) {
                SharedLibraryInfo libInfo;
                SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.valueAt(i);
                if (versionedLib == null) continue;
                int versionCount = versionedLib.size();
                for (int j = 0; j < versionCount && (libInfo = versionedLib.valueAt((int)j).info).isStatic(); ++j) {
                    VersionedPackage declaringPackage = libInfo.getDeclaringPackage();
                    String internalPackageName = this.resolveInternalPackageNameLPr(declaringPackage.getPackageName(), declaringPackage.getVersionCode());
                    PackageSetting ps = this.mSettings.getPackageLPr(internalPackageName);
                    if (ps == null || now - ps.lastUpdateTime < maxCachePeriod) continue;
                    if (packagesToDelete == null) {
                        packagesToDelete = new ArrayList<VersionedPackage>();
                    }
                    packagesToDelete.add(new VersionedPackage(internalPackageName, declaringPackage.getVersionCode()));
                }
            }
        }
        if (packagesToDelete != null) {
            int packageCount = packagesToDelete.size();
            for (int i = 0; i < packageCount; ++i) {
                VersionedPackage pkgToDelete = (VersionedPackage)packagesToDelete.get(i);
                if (this.deletePackageX(pkgToDelete.getPackageName(), pkgToDelete.getVersionCode(), 0, 2) != 1 || volume.getUsableSpace() < neededSpace) continue;
                return true;
            }
        }
        return false;
    }

    private int updateFlags(int flags, int userId) {
        if ((flags & 0xC0000) == 0) {
            flags = this.getUserManagerInternal().isUserUnlockingOrUnlocked(userId) ? (flags |= 0xC0000) : (flags |= 0x80000);
        }
        return flags;
    }

    private UserManagerInternal getUserManagerInternal() {
        if (this.mUserManagerInternal == null) {
            this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
        }
        return this.mUserManagerInternal;
    }

    private DeviceIdleController.LocalService getDeviceIdleController() {
        if (this.mDeviceIdleController == null) {
            this.mDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
        }
        return this.mDeviceIdleController;
    }

    private int updateFlagsForPackage(int flags, int userId, Object cookie) {
        boolean isCallerSystemUser = UserHandle.getCallingUserId() == 0;
        boolean triaged = true;
        if ((flags & 0xF) != 0 && (flags & 0x100C0000) == 0) {
            triaged = false;
        }
        if ((flags & 0x10102000) == 0) {
            triaged = false;
        }
        if ((flags & 0x400000) != 0) {
            this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "MATCH_ANY_USER flag requires INTERACT_ACROSS_USERS permission at " + Debug.getCallers(5));
        } else if ((flags & 0x2000) != 0 && isCallerSystemUser && sUserManager.hasManagedProfile(0)) {
            flags |= 0x400000;
        }
        return this.updateFlags(flags, userId);
    }

    private int updateFlagsForApplication(int flags, int userId, Object cookie) {
        return this.updateFlagsForPackage(flags, userId, cookie);
    }

    private int updateFlagsForComponent(int flags, int userId, Object cookie) {
        if (cookie instanceof Intent && (((Intent)cookie).getFlags() & 0x100) != 0) {
            flags |= 0x10000000;
        }
        boolean triaged = true;
        if ((flags & 0x100C0000) == 0) {
            triaged = false;
        }
        return this.updateFlags(flags, userId);
    }

    private Intent updateIntentForResolve(Intent intent) {
        if (intent.getSelector() != null) {
            intent = intent.getSelector();
        }
        return intent;
    }

    int updateFlagsForResolve(int flags, int userId, Intent intent, int callingUid) {
        return this.updateFlagsForResolve(flags, userId, intent, callingUid, false, false);
    }

    int updateFlagsForResolve(int flags, int userId, Intent intent, int callingUid, boolean wantInstantApps) {
        return this.updateFlagsForResolve(flags, userId, intent, callingUid, wantInstantApps, false);
    }

    int updateFlagsForResolve(int flags, int userId, Intent intent, int callingUid, boolean wantInstantApps, boolean onlyExposedExplicitly) {
        if (this.mSafeMode) {
            flags |= 0x100000;
        }
        if (this.getInstantAppPackageName(callingUid) != null) {
            if (onlyExposedExplicitly) {
                flags |= 0x2000000;
            }
            flags |= 0x1000000;
            flags |= 0x800000;
        } else {
            boolean wantMatchInstant = (flags & 0x800000) != 0;
            boolean allowMatchInstant = wantInstantApps && "android.intent.action.VIEW".equals(intent.getAction()) && PackageManagerService.hasWebURI(intent) || wantMatchInstant && this.canViewInstantApps(callingUid, userId);
            flags &= 0xFCFFFFFF;
            if (!allowMatchInstant) {
                flags &= 0xFF7FFFFF;
            }
        }
        return this.updateFlagsForComponent(flags, userId, intent);
    }

    @Override
    public ActivityInfo getActivityInfo(ComponentName component, int flags, int userId) {
        return this.getActivityInfoInternal(component, flags, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityInfo getActivityInfoInternal(ComponentName component, int flags, int filterCallingUid, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForComponent(flags, userId, component);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get activity info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledAndMatchLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, filterCallingUid, component, 1, userId)) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
            if (this.mResolveComponentName.equals(component)) {
                return PackageParser.generateActivityInfo(this.mResolveActivity, flags, new PackageUserState(), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activitySupportsIntent(ComponentName component, Intent intent, String resolvedType) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (component.equals(this.mResolveComponentName)) {
                return true;
            }
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a == null) {
                return false;
            }
            PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
            if (ps == null) {
                return false;
            }
            if (this.filterAppAccessLPr(ps, callingUid, component, 1, callingUserId)) {
                return false;
            }
            for (int i = 0; i < a.intents.size(); ++i) {
                if (((PackageParser.ActivityIntentInfo)a.intents.get(i)).match(intent.getAction(), resolvedType, intent.getScheme(), intent.getData(), intent.getCategories(), TAG) < 0) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getReceiverInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForComponent(flags, userId, component);
        this.enforceCrossUserPermission(callingUid, userId, false, false, "get receiver info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mReceivers.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledAndMatchLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, callingUid, component, 2, userId)) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<SharedLibraryInfo> getSharedLibraries(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        Preconditions.checkArgumentNonnegative(userId, "userId must be >= 0");
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        flags = this.updateFlagsForPackage(flags, userId, null);
        boolean canSeeStaticLibraries = this.mContext.checkCallingOrSelfPermission("android.permission.INSTALL_PACKAGES") == 0 || this.mContext.checkCallingOrSelfPermission("android.permission.DELETE_PACKAGES") == 0 || this.canRequestPackageInstallsInternal(packageName, 0x4000000, userId, false) || this.mContext.checkCallingOrSelfPermission("android.permission.REQUEST_DELETE_PACKAGES") == 0;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<SharedLibraryInfo> result = null;
            int libCount = this.mSharedLibraries.size();
            block6: for (int i = 0; i < libCount; ++i) {
                SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.valueAt(i);
                if (versionedLib == null) continue;
                int versionCount = versionedLib.size();
                for (int j = 0; j < versionCount; ++j) {
                    SharedLibraryInfo libInfo = versionedLib.valueAt((int)j).info;
                    if (!canSeeStaticLibraries && libInfo.isStatic()) continue block6;
                    long identity = Binder.clearCallingIdentity();
                    try {
                        PackageInfo packageInfo = this.getPackageInfoVersioned(libInfo.getDeclaringPackage(), flags | 0x4000000, userId);
                        if (packageInfo == null) {
                            continue;
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    SharedLibraryInfo resLibInfo = new SharedLibraryInfo(libInfo.getName(), libInfo.getVersion(), libInfo.getType(), libInfo.getDeclaringPackage(), this.getPackagesUsingSharedLibraryLPr(libInfo, flags, userId));
                    if (result == null) {
                        result = new ArrayList<SharedLibraryInfo>();
                    }
                    result.add(resLibInfo);
                }
            }
            return result != null ? new ParceledListSlice<SharedLibraryInfo>(result) : null;
        }
    }

    private List<VersionedPackage> getPackagesUsingSharedLibraryLPr(SharedLibraryInfo libInfo, int flags, int userId) {
        ArrayList<VersionedPackage> versionedPackages = null;
        int packageCount = this.mSettings.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageSetting ps = this.mSettings.mPackages.valueAt(i);
            if (ps == null || !ps.getUserState().get(userId).isAvailable(flags)) continue;
            String libName = libInfo.getName();
            if (libInfo.isStatic()) {
                int libIdx = ArrayUtils.indexOf(ps.usesStaticLibraries, libName);
                if (libIdx < 0 || ps.usesStaticLibrariesVersions[libIdx] != libInfo.getVersion()) continue;
                if (versionedPackages == null) {
                    versionedPackages = new ArrayList();
                }
                String dependentPackageName = ps.name;
                if (ps.pkg != null && ps.pkg.applicationInfo.isStaticSharedLibrary()) {
                    dependentPackageName = ps.pkg.manifestPackageName;
                }
                versionedPackages.add(new VersionedPackage(dependentPackageName, ps.versionCode));
                continue;
            }
            if (ps.pkg == null || !ArrayUtils.contains(ps.pkg.usesLibraries, libName) && !ArrayUtils.contains(ps.pkg.usesOptionalLibraries, libName)) continue;
            if (versionedPackages == null) {
                versionedPackages = new ArrayList<VersionedPackage>();
            }
            versionedPackages.add(new VersionedPackage(ps.name, ps.versionCode));
        }
        return versionedPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo getServiceInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForComponent(flags, userId, component);
        this.enforceCrossUserPermission(callingUid, userId, false, false, "get service info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Service s = (PackageParser.Service)this.mServices.mServices.get(component);
            if (s != null && this.mSettings.isEnabledAndMatchLPr(s.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, callingUid, component, 3, userId)) {
                    return null;
                }
                return PackageParser.generateServiceInfo(s, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo getProviderInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForComponent(flags, userId, component);
        this.enforceCrossUserPermission(callingUid, userId, false, false, "get provider info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Provider p = (PackageParser.Provider)this.mProviders.mProviders.get(component);
            if (p != null && this.mSettings.isEnabledAndMatchLPr(p.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                if (this.filterAppAccessLPr(ps, callingUid, component, 4, userId)) {
                    return null;
                }
                return PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSystemSharedLibraryNames() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArraySet<String> libs = null;
            int libCount = this.mSharedLibraries.size();
            block3: for (int i = 0; i < libCount; ++i) {
                SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.valueAt(i);
                if (versionedLib == null) continue;
                int versionCount = versionedLib.size();
                for (int j = 0; j < versionCount; ++j) {
                    SharedLibraryEntry libEntry = versionedLib.valueAt(j);
                    if (!libEntry.info.isStatic()) {
                        if (libs == null) {
                            libs = new ArraySet<String>();
                        }
                        libs.add(libEntry.info.getName());
                        continue block3;
                    }
                    PackageSetting ps = this.mSettings.getPackageLPr(libEntry.apk);
                    if (ps == null || this.filterSharedLibPackageLPr(ps, Binder.getCallingUid(), UserHandle.getUserId(Binder.getCallingUid()), 0x4000000)) continue;
                    if (libs == null) {
                        libs = new ArraySet();
                    }
                    libs.add(libEntry.info.getName());
                    continue block3;
                }
            }
            if (libs != null) {
                String[] libsArray = new String[libs.size()];
                libs.toArray(libsArray);
                return libsArray;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServicesSystemSharedLibraryPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mServicesSystemSharedLibraryPackageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSharedSystemSharedLibraryPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSharedSystemSharedLibraryPackageName;
        }
    }

    private void updateSequenceNumberLP(PackageSetting pkgSetting, int[] userList) {
        for (int i = userList.length - 1; i >= 0; --i) {
            Integer sequenceNumber;
            Map<String, Integer> sequenceNumbers;
            int userId = userList[i];
            if (pkgSetting.getInstantApp(userId)) continue;
            SparseArray<String> changedPackages = this.mChangedPackages.get(userId);
            if (changedPackages == null) {
                changedPackages = new SparseArray();
                this.mChangedPackages.put(userId, changedPackages);
            }
            if ((sequenceNumbers = this.mChangedPackagesSequenceNumbers.get(userId)) == null) {
                sequenceNumbers = new HashMap<String, Integer>();
                this.mChangedPackagesSequenceNumbers.put(userId, sequenceNumbers);
            }
            if ((sequenceNumber = sequenceNumbers.get(pkgSetting.name)) != null) {
                changedPackages.remove(sequenceNumber);
            }
            changedPackages.put(this.mChangedPackagesSequenceNumber, pkgSetting.name);
            sequenceNumbers.put(pkgSetting.name, this.mChangedPackagesSequenceNumber);
        }
        ++this.mChangedPackagesSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangedPackages getChangedPackages(int sequenceNumber, int userId) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (sequenceNumber >= this.mChangedPackagesSequenceNumber) {
                return null;
            }
            SparseArray<String> changedPackages = this.mChangedPackages.get(userId);
            if (changedPackages == null) {
                return null;
            }
            ArrayList<String> packageNames = new ArrayList<String>(this.mChangedPackagesSequenceNumber - sequenceNumber);
            for (int i = sequenceNumber; i < this.mChangedPackagesSequenceNumber; ++i) {
                String packageName = changedPackages.get(i);
                if (packageName == null) continue;
                packageNames.add(packageName);
            }
            return packageNames.isEmpty() ? null : new ChangedPackages(this.mChangedPackagesSequenceNumber, packageNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<FeatureInfo> getSystemAvailableFeatures() {
        ArrayList<FeatureInfo> res;
        ArrayMap<String, FeatureInfo> arrayMap = this.mAvailableFeatures;
        synchronized (arrayMap) {
            res = new ArrayList<FeatureInfo>(this.mAvailableFeatures.size() + 1);
            res.addAll(this.mAvailableFeatures.values());
        }
        FeatureInfo fi = new FeatureInfo();
        fi.reqGlEsVersion = SystemProperties.getInt("ro.opengles.version", 0);
        res.add(fi);
        return new ParceledListSlice<FeatureInfo>(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSystemFeature(String name, int version) {
        ArrayMap<String, FeatureInfo> arrayMap = this.mAvailableFeatures;
        synchronized (arrayMap) {
            FeatureInfo feat = this.mAvailableFeatures.get(name);
            if (feat == null) {
                return false;
            }
            return feat.version >= version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPermission(String permName, String pkgName, int userId) {
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        int callingUid = Binder.getCallingUid();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(pkgName);
            if (p != null && p.mExtras != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                    return -1;
                }
                boolean instantApp = ps.getInstantApp(userId);
                PermissionsState permissionsState = ps.getPermissionsState();
                if (permissionsState.hasPermission(permName, userId)) {
                    if (instantApp) {
                        BasePermission bp = this.mSettings.mPermissions.get(permName);
                        if (bp != null && bp.isInstant()) {
                            return 0;
                        }
                    } else {
                        return 0;
                    }
                }
                if ("android.permission.ACCESS_COARSE_LOCATION".equals(permName) && permissionsState.hasPermission("android.permission.ACCESS_FINE_LOCATION", userId)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUidPermission(String permName, int uid) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        boolean isCallerInstantApp = this.getInstantAppPackageName(callingUid) != null;
        boolean isUidInstantApp = this.getInstantAppPackageName(uid) != null;
        int userId = UserHandle.getUserId(uid);
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj != null) {
                SettingBase settingBase;
                PermissionsState permissionsState;
                PackageSetting ps;
                if (obj instanceof SharedUserSetting) {
                    if (isCallerInstantApp) {
                        return -1;
                    }
                } else if (obj instanceof PackageSetting && this.filterAppAccessLPr(ps = (PackageSetting)obj, callingUid, callingUserId)) {
                    return -1;
                }
                if ((permissionsState = (settingBase = (SettingBase)obj).getPermissionsState()).hasPermission(permName, userId)) {
                    if (isUidInstantApp) {
                        BasePermission bp = this.mSettings.mPermissions.get(permName);
                        if (bp != null && bp.isInstant()) {
                            return 0;
                        }
                    } else {
                        return 0;
                    }
                }
                if ("android.permission.ACCESS_COARSE_LOCATION".equals(permName) && permissionsState.hasPermission("android.permission.ACCESS_FINE_LOCATION", userId)) {
                    return 0;
                }
            } else {
                ArraySet<String> perms = this.mSystemPermissions.get(uid);
                if (perms != null) {
                    if (perms.contains(permName)) {
                        return 0;
                    }
                    if ("android.permission.ACCESS_COARSE_LOCATION".equals(permName) && perms.contains("android.permission.ACCESS_FINE_LOCATION")) {
                        return 0;
                    }
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPermissionRevokedByPolicy(String permission2, String packageName, int userId) {
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "isPermissionRevokedByPolicy for user " + userId);
        }
        if (this.checkPermission(permission2, packageName, userId) == 0) {
            return false;
        }
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null ? !this.isCallerSameApp(packageName, callingUid) : this.isInstantApp(packageName, userId)) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int flags = this.getPermissionFlags(permission2, packageName, userId);
            boolean bl = (flags & 4) != 0;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPermissionControllerPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mRequiredInstallerPackage;
        }
    }

    void enforceCrossUserPermission(int callingUid, int userId, boolean requireFullPermission, boolean checkShell, String message) {
        if (userId < 0) {
            throw new IllegalArgumentException("Invalid userId " + userId);
        }
        if (checkShell) {
            this.enforceShellRestriction("no_debugging_features", callingUid, userId);
        }
        if (userId == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            if (requireFullPermission) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
            } else {
                try {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
                }
                catch (SecurityException se) {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", message);
                }
            }
        }
    }

    void enforceShellRestriction(String restriction, int callingUid, int userHandle) {
        if (callingUid == 2000) {
            if (userHandle >= 0 && sUserManager.hasUserRestriction(restriction, userHandle)) {
                throw new SecurityException("Shell does not have permission to access user " + userHandle);
            }
            if (userHandle < 0) {
                Slog.e(TAG, "Unable to check shell permission for user " + userHandle + "\n\t" + Debug.getCallers(3));
            }
        }
    }

    private BasePermission findPermissionTreeLP(String permName) {
        for (BasePermission bp : this.mSettings.mPermissionTrees.values()) {
            if (!permName.startsWith(bp.name) || permName.length() <= bp.name.length() || permName.charAt(bp.name.length()) != '.') continue;
            return bp;
        }
        return null;
    }

    private BasePermission checkPermissionTreeLP(String permName) {
        BasePermission bp;
        if (permName != null && (bp = this.findPermissionTreeLP(permName)) != null) {
            if (bp.uid == UserHandle.getAppId(Binder.getCallingUid())) {
                return bp;
            }
            throw new SecurityException("Calling uid " + Binder.getCallingUid() + " is not allowed to add to permission tree " + bp.name + " owned by uid " + bp.uid);
        }
        throw new SecurityException("No permission tree found for " + permName);
    }

    static boolean compareStrings(CharSequence s1, CharSequence s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.getClass() != s2.getClass()) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean comparePermissionInfos(PermissionInfo pi1, PermissionInfo pi2) {
        if (pi1.icon != pi2.icon) {
            return false;
        }
        if (pi1.logo != pi2.logo) {
            return false;
        }
        if (pi1.protectionLevel != pi2.protectionLevel) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.name, pi2.name)) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.nonLocalizedLabel, pi2.nonLocalizedLabel)) {
            return false;
        }
        return PackageManagerService.compareStrings(pi1.packageName, pi2.packageName);
    }

    int permissionInfoFootprint(PermissionInfo info) {
        int size = info.name.length();
        if (info.nonLocalizedLabel != null) {
            size += info.nonLocalizedLabel.length();
        }
        if (info.nonLocalizedDescription != null) {
            size += info.nonLocalizedDescription.length();
        }
        return size;
    }

    int calculateCurrentPermissionFootprintLocked(BasePermission tree) {
        int size = 0;
        for (BasePermission perm : this.mSettings.mPermissions.values()) {
            if (perm.uid != tree.uid) continue;
            size += perm.name.length() + this.permissionInfoFootprint(perm.perm.info);
        }
        return size;
    }

    void enforcePermissionCapLocked(PermissionInfo info, BasePermission tree) {
        int curTreeSize;
        if (tree.uid != 1000 && (curTreeSize = this.calculateCurrentPermissionFootprintLocked(tree)) + this.permissionInfoFootprint(info) > 32768) {
            throw new SecurityException("Permission tree size cap exceeded");
        }
    }

    boolean addPermissionLocked(PermissionInfo info, boolean async) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            throw new SecurityException("Instant apps can't add permissions");
        }
        if (info.labelRes == 0 && info.nonLocalizedLabel == null) {
            throw new SecurityException("Label must be specified in permission");
        }
        BasePermission tree = this.checkPermissionTreeLP(info.name);
        BasePermission bp = this.mSettings.mPermissions.get(info.name);
        boolean added = bp == null;
        boolean changed = true;
        int fixedLevel = PermissionInfo.fixProtectionLevel(info.protectionLevel);
        if (added) {
            this.enforcePermissionCapLocked(info, tree);
            bp = new BasePermission(info.name, tree.sourcePackage, 2);
        } else {
            if (bp.type != 2) {
                throw new SecurityException("Not allowed to modify non-dynamic permission " + info.name);
            }
            if (bp.protectionLevel == fixedLevel && bp.perm.owner.equals(tree.perm.owner) && bp.uid == tree.uid && PackageManagerService.comparePermissionInfos(bp.perm.info, info)) {
                changed = false;
            }
        }
        bp.protectionLevel = fixedLevel;
        info = new PermissionInfo(info);
        info.protectionLevel = fixedLevel;
        bp.perm = new PackageParser.Permission(tree.perm.owner, info);
        bp.perm.info.packageName = tree.perm.info.packageName;
        bp.uid = tree.uid;
        if (added) {
            this.mSettings.mPermissions.put(info.name, bp);
        }
        if (changed) {
            if (!async) {
                this.mSettings.writeLPr();
            } else {
                this.scheduleWriteSettingsLocked();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermission(PermissionInfo info) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.addPermissionLocked(info, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionAsync(PermissionInfo info) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.addPermissionLocked(info, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(String name) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.checkPermissionTreeLP(name);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp != null) {
                if (bp.type != 2) {
                    throw new SecurityException("Not allowed to modify non-dynamic permission " + name);
                }
                this.mSettings.mPermissions.remove(name);
                this.mSettings.writeLPr();
            }
        }
    }

    private static void enforceDeclaredAsUsedAndRuntimeOrDevelopmentPermission(PackageParser.Package pkg, BasePermission bp) {
        int index = pkg.requestedPermissions.indexOf(bp.name);
        if (index == -1) {
            throw new SecurityException("Package " + pkg.packageName + " has not requested permission " + bp.name);
        }
        if (!bp.isRuntime() && !bp.isDevelopment()) {
            throw new SecurityException("Permission " + bp.name + " is not a changeable permission type");
        }
    }

    @Override
    public void grantRuntimePermission(String packageName, String name, int userId) {
        this.grantRuntimePermission(packageName, name, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantRuntimePermission(String packageName, String name, final int userId, boolean overridePolicy) {
        int uid;
        if (!sUserManager.exists(userId)) {
            Log.e(TAG, "No such user:" + userId);
            return;
        }
        int callingUid = Binder.getCallingUid();
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", "grantRuntimePermission");
        this.enforceCrossUserPermission(callingUid, userId, true, true, "grantRuntimePermission");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + name);
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PackageManagerService.enforceDeclaredAsUsedAndRuntimeOrDevelopmentPermission(pkg, bp);
            if (this.mPermissionReviewRequired && pkg.applicationInfo.targetSdkVersion < 23 && bp.isRuntime()) {
                return;
            }
            uid = UserHandle.getUid(userId, pkg.applicationInfo.uid);
            PermissionsState permissionsState = ps.getPermissionsState();
            int flags = permissionsState.getPermissionFlags(name, userId);
            if ((flags & 0x10) != 0) {
                throw new SecurityException("Cannot grant system fixed permission " + name + " for package " + packageName);
            }
            if (!overridePolicy && (flags & 4) != 0) {
                throw new SecurityException("Cannot grant policy fixed permission " + name + " for package " + packageName);
            }
            if (bp.isDevelopment()) {
                if (permissionsState.grantInstallPermission(bp) != -1) {
                    this.scheduleWriteSettingsLocked();
                }
                return;
            }
            if (ps.getInstantApp(userId) && !bp.isInstant()) {
                throw new SecurityException("Cannot grant non-ephemeral permission" + name + " for package " + packageName);
            }
            if (pkg.applicationInfo.targetSdkVersion < 23) {
                Slog.w(TAG, "Cannot grant runtime permission to a legacy app");
                return;
            }
            int result = permissionsState.grantRuntimePermission(bp, userId);
            switch (result) {
                case -1: {
                    return;
                }
                case 1: {
                    final int appId = UserHandle.getAppId(pkg.applicationInfo.uid);
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PackageManagerService.this.killUid(appId, userId, PackageManagerService.KILL_APP_REASON_GIDS_CHANGED);
                        }
                    });
                }
            }
            if (bp.isRuntime()) {
                PackageManagerService.logPermissionGranted(this.mContext, name, packageName);
            }
            this.mOnPermissionChangeListeners.onPermissionsChanged(uid);
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
        }
        if ("android.permission.READ_EXTERNAL_STORAGE".equals(name) || "android.permission.WRITE_EXTERNAL_STORAGE".equals(name)) {
            long token = Binder.clearCallingIdentity();
            try {
                if (sUserManager.isInitialized(userId)) {
                    StorageManagerInternal storageManagerInternal = LocalServices.getService(StorageManagerInternal.class);
                    storageManagerInternal.onExternalStoragePolicyChanged(uid, packageName);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @Override
    public void revokeRuntimePermission(String packageName, String name, int userId) {
        this.revokeRuntimePermission(packageName, name, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeRuntimePermission(String packageName, String name, int userId, boolean overridePolicy) {
        int appId;
        if (!sUserManager.exists(userId)) {
            Log.e(TAG, "No such user:" + userId);
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", "revokeRuntimePermission");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, true, "revokeRuntimePermission");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null || this.filterAppAccessLPr(ps, Binder.getCallingUid(), userId)) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + name);
            }
            PackageManagerService.enforceDeclaredAsUsedAndRuntimeOrDevelopmentPermission(pkg, bp);
            if (this.mPermissionReviewRequired && pkg.applicationInfo.targetSdkVersion < 23 && bp.isRuntime()) {
                return;
            }
            PermissionsState permissionsState = ps.getPermissionsState();
            int flags = permissionsState.getPermissionFlags(name, userId);
            if ((flags & 0x10) != 0) {
                throw new SecurityException("Cannot revoke system fixed permission " + name + " for package " + packageName);
            }
            if (!overridePolicy && (flags & 4) != 0) {
                throw new SecurityException("Cannot revoke policy fixed permission " + name + " for package " + packageName);
            }
            if (bp.isDevelopment()) {
                if (permissionsState.revokeInstallPermission(bp) != -1) {
                    this.scheduleWriteSettingsLocked();
                }
                return;
            }
            if (permissionsState.revokeRuntimePermission(bp, userId) == -1) {
                return;
            }
            if (bp.isRuntime()) {
                PackageManagerService.logPermissionRevoked(this.mContext, name, packageName);
            }
            this.mOnPermissionChangeListeners.onPermissionsChanged(pkg.applicationInfo.uid);
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, true);
            appId = UserHandle.getAppId(pkg.applicationInfo.uid);
        }
        this.killUid(appId, userId, KILL_APP_REASON_PERMISSIONS_REVOKED);
    }

    private static int getBaseEventId(String name) {
        int eventIdIndex = ALL_DANGEROUS_PERMISSIONS.indexOf(name);
        if (eventIdIndex == -1) {
            if (AppOpsManager.permissionToOpCode(name) == -1 || "user".equals(Build.TYPE)) {
                Log.i(TAG, "Unknown permission " + name);
                return 630;
            }
            throw new IllegalStateException("Unknown permission " + name);
        }
        return 634 + eventIdIndex * 4;
    }

    private static void logPermissionRevoked(Context context, String name, String packageName) {
        MetricsLogger.action(context, PackageManagerService.getBaseEventId(name) + 3, packageName);
    }

    private static void logPermissionGranted(Context context, String name, String packageName) {
        MetricsLogger.action(context, PackageManagerService.getBaseEventId(name) + 1, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRuntimePermissions() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", "revokeRuntimePermission");
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000 && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "resetRuntimePermissions");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.updatePermissionsLPw(null, null, 1);
            for (int userId : UserManagerService.getInstance().getUserIds()) {
                int packageCount = this.mPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    PackageParser.Package pkg = this.mPackages.valueAt(i);
                    if (!(pkg.mExtras instanceof PackageSetting)) continue;
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPermissionFlags(String name, String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 0;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("getPermissionFlags");
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "getPermissionFlags");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                return 0;
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                return 0;
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                return 0;
            }
            PermissionsState permissionsState = ps.getPermissionsState();
            return permissionsState.getPermissionFlags(name, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissionFlags(String name, String packageName, int flagMask, int flagValues, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("updatePermissionFlags");
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, true, "updatePermissionFlags");
        if (PackageManagerService.getCallingUid() != 1000) {
            flagMask &= 0xFFFFFFEF;
            flagValues &= 0xFFFFFFEF;
            flagMask &= 0xFFFFFFDF;
            flagValues &= 0xFFFFFFDF;
            flagValues &= 0xFFFFFFBF;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean hadState;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + name);
            }
            PermissionsState permissionsState = ps.getPermissionsState();
            boolean bl = hadState = permissionsState.getRuntimePermissionState(name, userId) != null;
            if (permissionsState.updatePermissionFlags(bp, userId, flagMask, flagValues)) {
                if (permissionsState.getInstallPermissionState(name) != null) {
                    this.scheduleWriteSettingsLocked();
                } else if (permissionsState.getRuntimePermissionState(name, userId) != null || hadState) {
                    this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissionFlagsForAllApps(int flagMask, int flagValues, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("updatePermissionFlagsForAllApps");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, true, "updatePermissionFlagsForAllApps");
        if (PackageManagerService.getCallingUid() != 1000) {
            flagMask &= 0xFFFFFFEF;
            flagValues &= 0xFFFFFFEF;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean changed = false;
            int packageCount = this.mPackages.size();
            for (int pkgIndex = 0; pkgIndex < packageCount; ++pkgIndex) {
                PackageParser.Package pkg = this.mPackages.valueAt(pkgIndex);
                PackageSetting ps = (PackageSetting)pkg.mExtras;
                if (ps == null) continue;
                PermissionsState permissionsState = ps.getPermissionsState();
                changed |= permissionsState.updatePermissionFlagsForAllPermissions(userId, flagMask, flagValues);
            }
            if (changed) {
                this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
            }
        }
    }

    private void enforceGrantRevokeRuntimePermissionPermissions(String message) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS") != 0) {
            throw new SecurityException(message + " requires " + "android.permission.GRANT_RUNTIME_PERMISSIONS" + " or " + "android.permission.REVOKE_RUNTIME_PERMISSIONS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldShowRequestPermissionRationale(String permissionName, String packageName, int userId) {
        int flags;
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "canShowRequestPermissionRationale for user " + userId);
        }
        int uid = this.getPackageUid(packageName, 0x10000000, userId);
        if (UserHandle.getAppId(PackageManagerService.getCallingUid()) != UserHandle.getAppId(uid)) {
            return false;
        }
        if (this.checkPermission(permissionName, packageName, userId) == 0) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            flags = this.getPermissionFlags(permissionName, packageName, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        int fixedFlags = 22;
        if ((flags & 0x16) != 0) {
            return false;
        }
        return (flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnPermissionsChangeListener(IOnPermissionsChangeListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS", "addOnPermissionsChangeListener");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mOnPermissionChangeListeners.addListenerLocked(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnPermissionsChangeListener(IOnPermissionsChangeListener listener) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mOnPermissionChangeListeners.removeListenerLocked(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtectedBroadcast(String actionName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mProtectedBroadcasts.contains(actionName)) {
                return true;
            }
            if (actionName != null && (actionName.startsWith("android.net.netmon.lingerExpired") || actionName.startsWith("com.android.server.sip.SipWakeupTimer") || actionName.startsWith("com.android.internal.telephony.data-reconnect") || actionName.startsWith("android.net.netmon.launchCaptivePortalApp"))) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkSignatures(String pkg1, String pkg2) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p1 = this.mPackages.get(pkg1);
            PackageParser.Package p2 = this.mPackages.get(pkg2);
            if (p1 == null || p1.mExtras == null || p2 == null || p2.mExtras == null) {
                return -4;
            }
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageSetting ps1 = (PackageSetting)p1.mExtras;
            PackageSetting ps2 = (PackageSetting)p2.mExtras;
            if (this.filterAppAccessLPr(ps1, callingUid, callingUserId) || this.filterAppAccessLPr(ps2, callingUid, callingUserId)) {
                return -4;
            }
            return PackageManagerService.compareSignatures(p1.mSignatures, p2.mSignatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkUidSignatures(int uid1, int uid2) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        boolean isCallerInstantApp = this.getInstantAppPackageName(callingUid) != null;
        uid1 = UserHandle.getAppId(uid1);
        uid2 = UserHandle.getAppId(uid2);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Signature[] s2;
            PackageSetting ps;
            Signature[] s1;
            Object obj = this.mSettings.getUserIdLPr(uid1);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                if (isCallerInstantApp) {
                    return -4;
                }
                s1 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                    return -4;
                }
                s1 = ps.signatures.mSignatures;
            }
            obj = this.mSettings.getUserIdLPr(uid2);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                if (isCallerInstantApp) {
                    return -4;
                }
                s2 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                    return -4;
                }
                s2 = ps.signatures.mSignatures;
            }
            return PackageManagerService.compareSignatures(s1, s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killUid(int appId, int userId, String reason) {
        long identity = Binder.clearCallingIdentity();
        try {
            IActivityManager am = ActivityManager.getService();
            if (am != null) {
                try {
                    am.killUid(appId, userId, reason);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    static int compareSignatures(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null ? 1 : -1;
        }
        if (s2 == null) {
            return -2;
        }
        if (s1.length != s2.length) {
            return -3;
        }
        if (s1.length == 1) {
            return s1[0].equals(s2[0]) ? 0 : -3;
        }
        ArraySet<Signature> set1 = new ArraySet<Signature>();
        for (Signature sig : s1) {
            set1.add(sig);
        }
        ArraySet<Signature> set2 = new ArraySet<Signature>();
        for (Signature sig : s2) {
            set2.add(sig);
        }
        if (set1.equals(set2)) {
            return 0;
        }
        return -3;
    }

    private boolean isCompatSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        Settings.VersionInfo ver = this.getSettingsVersionForPackage(scannedPkg);
        return ver.databaseVersion < 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compareSignaturesCompat(PackageSignatures existingSigs, PackageParser.Package scannedPkg) {
        if (!this.isCompatSignatureUpdateNeeded(scannedPkg)) {
            return -3;
        }
        ArraySet<Signature> existingSet = new ArraySet<Signature>();
        for (Signature sig : existingSigs.mSignatures) {
            existingSet.add(sig);
        }
        ArraySet<Signature> scannedCompatSet = new ArraySet<Signature>();
        for (Signature sig : scannedPkg.mSignatures) {
            try {
                Signature[] chainSignatures;
                for (Signature chainSig : chainSignatures = sig.getChainSignatures()) {
                    scannedCompatSet.add(chainSig);
                }
            }
            catch (CertificateEncodingException e) {
                scannedCompatSet.add(sig);
            }
        }
        if (scannedCompatSet.equals(existingSet)) {
            existingSigs.assignSignatures(scannedPkg.mSignatures);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.mKeySetManagerService.removeAppKeySetDataLPw(scannedPkg.packageName);
            }
            return 0;
        }
        return -3;
    }

    private boolean isRecoverSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        Settings.VersionInfo ver = this.getSettingsVersionForPackage(scannedPkg);
        return ver.databaseVersion < 3;
    }

    private int compareSignaturesRecover(PackageSignatures existingSigs, PackageParser.Package scannedPkg) {
        if (!this.isRecoverSignatureUpdateNeeded(scannedPkg)) {
            return -3;
        }
        String msg = null;
        try {
            if (Signature.areEffectiveMatch(existingSigs.mSignatures, scannedPkg.mSignatures)) {
                PackageManagerService.logCriticalInfo(4, "Recovered effectively matching certificates for " + scannedPkg.packageName);
                return 0;
            }
        }
        catch (CertificateException e) {
            msg = e.getMessage();
        }
        PackageManagerService.logCriticalInfo(4, "Failed to recover certificates for " + scannedPkg.packageName + ": " + msg);
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllPackages() {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.canViewInstantApps(callingUid, callingUserId)) {
                return new ArrayList<String>(this.mPackages.keySet());
            }
            String instantAppPkgName = this.getInstantAppPackageName(callingUid);
            ArrayList<String> result = new ArrayList<String>();
            if (instantAppPkgName != null) {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    if (!pkg.visibleToInstantApps) continue;
                    result.add(pkg.packageName);
                }
            } else {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    PackageSetting ps;
                    PackageSetting packageSetting = ps = pkg.mExtras != null ? (PackageSetting)pkg.mExtras : null;
                    if (ps != null && ps.getInstantApp(callingUserId) && !this.mInstantAppRegistry.isInstantAccessGranted(callingUserId, UserHandle.getAppId(callingUid), ps.appId)) continue;
                    result.add(pkg.packageName);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPackagesForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        boolean isCallerInstantApp = this.getInstantAppPackageName(callingUid) != null;
        int userId = UserHandle.getUserId(uid);
        uid = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                if (isCallerInstantApp) {
                    return null;
                }
                SharedUserSetting sus = (SharedUserSetting)obj;
                int N = sus.packages.size();
                String[] res = new String[N];
                Iterator<PackageSetting> it = sus.packages.iterator();
                int i = 0;
                while (it.hasNext()) {
                    PackageSetting ps2 = it.next();
                    if (ps2.getInstalled(userId)) {
                        res[i++] = ps2.name;
                        continue;
                    }
                    res = ArrayUtils.removeElement(String.class, res, res[i]);
                }
                return res;
            }
            if (obj instanceof PackageSetting && (ps = (PackageSetting)obj).getInstalled(userId) && !this.filterAppAccessLPr(ps, callingUid, userId)) {
                return new String[]{ps.name};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.name + ":" + sus.userId;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                    return null;
                }
                return ps.name;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidForSharedUser(String sharedUserName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return -1;
        }
        if (sharedUserName == null) {
            return -1;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            try {
                SharedUserSetting suid = this.mSettings.getSharedUserLPw(sharedUserName, 0, 0, false);
                if (suid != null) {
                    return suid.userId;
                }
            }
            catch (PackageManagerException packageManagerException) {
                // empty catch block
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFlagsForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return 0;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                    return 0;
                }
                return ps.pkgFlags;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrivateFlagsForUid(int uid) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return 0;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgPrivateFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                    return 0;
                }
                return ps.pkgPrivateFlags;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUidPrivileged(int uid) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        uid = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                Iterator<PackageSetting> it = sus.packages.iterator();
                while (it.hasNext()) {
                    if (!it.next().isPrivileged()) continue;
                    return true;
                }
            } else if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.isPrivileged();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAppOpPermissionPackages(String permissionName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArraySet<String> pkgs = this.mAppOpPermissionPackages.get(permissionName);
            if (pkgs == null) {
                return null;
            }
            return pkgs.toArray(new String[pkgs.size()]);
        }
    }

    @Override
    public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) {
        return this.resolveIntentInternal(intent, resolvedType, flags, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveInfo resolveIntentInternal(Intent intent, String resolvedType, int flags, int userId, boolean resolveForStart) {
        try {
            ResolveInfo bestChoice;
            Trace.traceBegin(262144L, "resolveIntent");
            if (!sUserManager.exists(userId)) {
                ResolveInfo resolveInfo = null;
                return resolveInfo;
            }
            int callingUid = Binder.getCallingUid();
            flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, resolveForStart);
            this.enforceCrossUserPermission(callingUid, userId, false, false, "resolve intent");
            Trace.traceBegin(262144L, "queryIntentActivities");
            List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, callingUid, userId, resolveForStart);
            Trace.traceEnd(262144L);
            ResolveInfo resolveInfo = bestChoice = this.chooseBestActivity(intent, resolvedType, flags, query, userId);
            return resolveInfo;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolveInfo findPersistentPreferredActivity(Intent intent, int userId) {
        if (!UserHandle.isSameApp(Binder.getCallingUid(), 1000)) {
            throw new SecurityException("findPersistentPreferredActivity can only be run by the system");
        }
        if (!sUserManager.exists(userId)) {
            return null;
        }
        int callingUid = Binder.getCallingUid();
        intent = this.updateIntentForResolve(intent);
        String resolvedType = intent.resolveTypeIfNeeded(this.mContext.getContentResolver());
        int flags = this.updateFlagsForResolve(0, userId, intent, callingUid, false);
        List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.findPersistentPreferredActivityLP(intent, resolvedType, flags, query, false, userId);
        }
    }

    @Override
    public void setLastChosenActivity(Intent intent, String resolvedType, int flags, IntentFilter filter, int match, ComponentName activity) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        int userId = UserHandle.getCallingUserId();
        intent.setComponent(null);
        List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId);
        this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, true, false, userId);
        this.addPreferredActivityInternal(filter, match, null, activity, false, userId, "Setting last chosen");
    }

    @Override
    public ResolveInfo getLastChosenActivity(Intent intent, String resolvedType, int flags) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        int userId = UserHandle.getCallingUserId();
        List<ResolveInfo> query = this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId);
        return this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, false, false, userId);
    }

    private boolean isEphemeralDisabled() {
        return this.mEphemeralAppsDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInstantAppAllowed(Intent intent, List<ResolveInfo> resolvedActivities, int userId, boolean skipPackageCheck) {
        if (this.mInstantAppResolverConnection == null) {
            return false;
        }
        if (this.mInstantAppInstallerActivity == null) {
            return false;
        }
        if (intent.getComponent() != null) {
            return false;
        }
        if ((intent.getFlags() & 0x200) != 0) {
            return false;
        }
        if (!skipPackageCheck && intent.getPackage() != null) {
            return false;
        }
        boolean isWebUri = PackageManagerService.hasWebURI(intent);
        if (!isWebUri || intent.getData().getHost() == null) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int count = resolvedActivities == null ? 0 : resolvedActivities.size();
            for (int n = 0; n < count; ++n) {
                long packedStatus;
                int status;
                ResolveInfo info = resolvedActivities.get(n);
                String packageName = info.activityInfo.packageName;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) continue;
                if (!(info.handleAllWebDataURI || (status = (int)((packedStatus = this.getDomainVerificationStatusLPr(ps, userId)) >> 32)) != 2 && status != 4)) {
                    if (DEBUG_EPHEMERAL) {
                        Slog.v(TAG, "DENY instant app; pkg: " + packageName + ", status: " + status);
                    }
                    return false;
                }
                if (!ps.getInstantApp(userId)) continue;
                if (DEBUG_EPHEMERAL) {
                    Slog.v(TAG, "DENY instant app installed; pkg: " + packageName);
                }
                return false;
            }
        }
        return true;
    }

    private void requestInstantAppResolutionPhaseTwo(AuxiliaryResolveInfo responseObj, Intent origIntent, String resolvedType, String callingPackage, Bundle verificationBundle, int userId) {
        Message msg = this.mHandler.obtainMessage(20, new InstantAppRequest(responseObj, origIntent, resolvedType, callingPackage, userId, verificationBundle));
        this.mHandler.sendMessage(msg);
    }

    private ResolveInfo chooseBestActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int userId) {
        if (query != null) {
            int N = query.size();
            if (N == 1) {
                return query.get(0);
            }
            if (N > 1) {
                boolean debug = (intent.getFlags() & 8) != 0;
                ResolveInfo r0 = query.get(0);
                ResolveInfo r1 = query.get(1);
                if (debug) {
                    Slog.v(TAG, r0.activityInfo.name + "=" + r0.priority + " vs " + r1.activityInfo.name + "=" + r1.priority);
                }
                if (r0.priority != r1.priority || r0.preferredOrder != r1.preferredOrder || r0.isDefault != r1.isDefault) {
                    return query.get(0);
                }
                ResolveInfo ri = this.findPreferredActivity(intent, resolvedType, flags, query, r0.priority, true, false, debug, userId);
                if (ri != null) {
                    return ri;
                }
                for (int i = 0; i < N; ++i) {
                    String packageName;
                    PackageSetting ps;
                    long packedStatus;
                    int status;
                    ri = query.get(i);
                    if (!ri.activityInfo.applicationInfo.isInstantApp() || (status = (int)((packedStatus = this.getDomainVerificationStatusLPr(ps = this.mSettings.mPackages.get(packageName = ri.activityInfo.packageName), userId)) >> 32)) == 4) continue;
                    return ri;
                }
                ri = new ResolveInfo(this.mResolveInfo);
                ri.activityInfo = new ActivityInfo(ri.activityInfo);
                ri.activityInfo.labelRes = ResolverActivity.getLabelRes(intent.getAction());
                String intentPackage = intent.getPackage();
                if (!TextUtils.isEmpty(intentPackage) && this.allHavePackage(query, intentPackage)) {
                    ApplicationInfo appi = query.get((int)0).activityInfo.applicationInfo;
                    ri.resolvePackageName = intentPackage;
                    if (this.userNeedsBadging(userId)) {
                        ri.noResourceId = true;
                    } else {
                        ri.icon = appi.icon;
                    }
                    ri.iconResourceId = appi.icon;
                    ri.labelRes = appi.labelRes;
                }
                ri.activityInfo.applicationInfo = new ApplicationInfo(ri.activityInfo.applicationInfo);
                if (userId != 0) {
                    ri.activityInfo.applicationInfo.uid = UserHandle.getUid(userId, UserHandle.getAppId(ri.activityInfo.applicationInfo.uid));
                }
                if (ri.activityInfo.metaData == null) {
                    ri.activityInfo.metaData = new Bundle();
                }
                ri.activityInfo.metaData.putBoolean("android.dock_home", true);
                return ri;
            }
        }
        return null;
    }

    private boolean allHavePackage(List<ResolveInfo> list, String packageName) {
        if (ArrayUtils.isEmpty(list)) {
            return false;
        }
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ActivityInfo ai;
            ResolveInfo ri = list.get(i);
            ActivityInfo activityInfo = ai = ri != null ? ri.activityInfo : null;
            if (ai != null && packageName.equals(ai.packageName)) continue;
            return false;
        }
        return true;
    }

    private ResolveInfo findPersistentPreferredActivityLP(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, boolean debug, int userId) {
        List pprefs;
        int N = query.size();
        PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.get(userId);
        if (debug) {
            Slog.v(TAG, "Looking for presistent preferred activities...");
        }
        List list = ppir != null ? ppir.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId) : (pprefs = null);
        if (pprefs != null && pprefs.size() > 0) {
            int M = pprefs.size();
            for (int i = 0; i < M; ++i) {
                PersistentPreferredActivity ppa = (PersistentPreferredActivity)pprefs.get(i);
                if (debug) {
                    Slog.v(TAG, "Checking PersistentPreferredActivity ds=" + (ppa.countDataSchemes() > 0 ? ppa.getDataScheme(0) : "<none>") + "\n  component=" + ppa.mComponent);
                    ppa.dump(new LogPrinter(2, TAG, 3), "  ");
                }
                ActivityInfo ai = this.getActivityInfo(ppa.mComponent, flags | 0x200, userId);
                if (debug) {
                    Slog.v(TAG, "Found persistent preferred activity:");
                    if (ai != null) {
                        ai.dump(new LogPrinter(2, TAG, 3), "  ");
                    } else {
                        Slog.v(TAG, "  null");
                    }
                }
                if (ai == null) continue;
                for (int j = 0; j < N; ++j) {
                    ResolveInfo ri = query.get(j);
                    if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                    if (debug) {
                        Slog.v(TAG, "Returning persistent preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                    }
                    return ri;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResolveInfo findPreferredActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int priority, boolean always, boolean removeMatches, boolean debug, int userId) {
        if (!PackageManagerService.sUserManager.exists(userId)) {
            return null;
        }
        callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        intent = this.updateIntentForResolve(intent);
        var11_11 = this.mPackages;
        synchronized (var11_11) {
            pri = this.findPersistentPreferredActivityLP(intent, resolvedType, flags, query, debug, userId);
            if (pri != null) {
                return pri;
            }
            pir = this.mSettings.mPreferredActivities.get(userId);
            if (debug) {
                Slog.v("PackageManager", "Looking for preferred activities...");
            }
            v0 = pir != null ? pir.queryIntent(intent, resolvedType, (flags & 65536) != 0, userId) : (prefs = null);
            if (prefs != null && prefs.size() > 0) {
                changed = false;
                try {
                    match = 0;
                    if (debug) {
                        Slog.v("PackageManager", "Figuring out best match...");
                    }
                    N = query.size();
                    for (j = 0; j < N; ++j) {
                        ri = query.get(j);
                        if (debug) {
                            Slog.v("PackageManager", "Match for " + ri.activityInfo + ": 0x" + Integer.toHexString(match));
                        }
                        if (ri.match <= match) continue;
                        match = ri.match;
                    }
                    if (debug) {
                        Slog.v("PackageManager", "Best match: 0x" + Integer.toHexString(match));
                    }
                    match &= 0xFFF0000;
                    M = prefs.size();
                    block8: for (i = 0; i < M; ++i) {
                        pa = (PreferredActivity)prefs.get(i);
                        if (debug) {
                            Slog.v("PackageManager", "Checking PreferredActivity ds=" + (pa.countDataSchemes() > 0 ? pa.getDataScheme(0) : "<none>") + "\n  component=" + pa.mPref.mComponent);
                            pa.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                        }
                        if (pa.mPref.mMatch != match) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping bad match " + Integer.toHexString(pa.mPref.mMatch));
                            continue;
                        }
                        if (always && !pa.mPref.mAlways) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping mAlways=false entry");
                            continue;
                        }
                        ai = this.getActivityInfo(pa.mPref.mComponent, flags | 512 | 524288 | 262144, userId);
                        if (debug) {
                            Slog.v("PackageManager", "Found preferred activity:");
                            if (ai != null) {
                                ai.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                            } else {
                                Slog.v("PackageManager", "  null");
                            }
                        }
                        if (ai == null) {
                            Slog.w("PackageManager", "Removing dangling preferred activity: " + pa.mPref.mComponent);
                            pir.removeFilter(pa);
                            changed = true;
                            continue;
                        }
                        for (j = 0; j < N; ++j) {
                            ri = query.get(j);
                            if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                            if (removeMatches) {
                                pir.removeFilter(pa);
                                changed = true;
                                continue block8;
                            }
                            if (always && !pa.mPref.sameSet(query)) {
                                Slog.i("PackageManager", "Result set changed, dropping preferred activity for " + intent + " type " + resolvedType);
                                pir.removeFilter(pa);
                                lastChosen = new PreferredActivity(pa, pa.mPref.mMatch, null, pa.mPref.mComponent, false);
                                pir.addFilter(lastChosen);
                                changed = true;
                                var25_27 = null;
                                return var25_27;
                            }
                            if (debug) {
                                Slog.v("PackageManager", "Returning preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                            }
                            var24_26 = ri;
                            return var24_26;
                        }
                    }
                }
                finally {
                    if (changed) {
                        this.scheduleWritePackageRestrictionsLocked(userId);
                    }
                }
            }
            ** if (!debug) goto lbl99
        }
lbl-1000:
        // 1 sources

        {
            Slog.v("PackageManager", "No preferred activity to return");
        }
lbl99:
        // 2 sources

        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canForwardTo(Intent intent, String resolvedType, int sourceUserId, int targetUserId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        List<CrossProfileIntentFilter> matches = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, sourceUserId);
        if (matches != null) {
            int size = matches.size();
            for (int i = 0; i < size; ++i) {
                if (matches.get(i).getTargetUserId() != targetUserId) continue;
                return true;
            }
        }
        if (PackageManagerService.hasWebURI(intent)) {
            int callingUid = Binder.getCallingUid();
            UserInfo parent = this.getProfileParent(sourceUserId);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                int flags = this.updateFlagsForResolve(0, parent.id, intent, callingUid, false);
                CrossProfileDomainInfo xpDomainInfo = this.getCrossProfileDomainPreferredLpr(intent, resolvedType, flags, sourceUserId, parent.id);
                return xpDomainInfo != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getProfileParent(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = sUserManager.getProfileParent(userId);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private List<CrossProfileIntentFilter> getMatchingCrossProfileIntentFilters(Intent intent, String resolvedType, int userId) {
        CrossProfileIntentResolver resolver = this.mSettings.mCrossProfileIntentResolvers.get(userId);
        if (resolver != null) {
            return resolver.queryIntent(intent, resolvedType, false, userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ResolveInfo> queryIntentActivities(Intent intent, String resolvedType, int flags, int userId) {
        try {
            Trace.traceBegin(262144L, "queryIntentActivities");
            ParceledListSlice<ResolveInfo> parceledListSlice = new ParceledListSlice<ResolveInfo>(this.queryIntentActivitiesInternal(intent, resolvedType, flags, userId));
            return parceledListSlice;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstantAppPackageName(int callingUid) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int appId;
            Object obj;
            if (Process.isIsolated(callingUid)) {
                callingUid = this.mIsolatedOwners.get(callingUid);
            }
            if ((obj = this.mSettings.getUserIdLPr(appId = UserHandle.getAppId(callingUid))) instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                boolean isInstantApp = ps.getInstantApp(UserHandle.getUserId(callingUid));
                String string2 = isInstantApp ? ps.pkg.packageName : null;
                return string2;
            }
        }
        return null;
    }

    private List<ResolveInfo> queryIntentActivitiesInternal(Intent intent, String resolvedType, int flags, int userId) {
        return this.queryIntentActivitiesInternal(intent, resolvedType, flags, Binder.getCallingUid(), userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentActivitiesInternal(Intent intent, String resolvedType, int flags, int filterCallingUid, int userId, boolean resolveForStart) {
        List<ResolveInfo> result;
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        String instantAppPkgName = this.getInstantAppPackageName(filterCallingUid);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "query intent activities");
        String pkgName = intent.getPackage();
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        flags = this.updateFlagsForResolve(flags, userId, intent, filterCallingUid, resolveForStart, comp != null || pkgName != null);
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getActivityInfo(comp, flags, userId);
            if (ai != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean matchExplicitlyVisibleOnly = (flags & 0x2000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (ai.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetVisibleToInstantApp = (ai.flags & 0x100000) != 0;
                boolean isTargetExplicitlyVisibleToInstantApp = isTargetVisibleToInstantApp && (ai.flags & 0x200000) == 0;
                boolean isTargetHiddenFromInstantApp = !isTargetVisibleToInstantApp || matchExplicitlyVisibleOnly && !isTargetExplicitlyVisibleToInstantApp;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.activityInfo = ai;
                    list.add(ri);
                }
            }
            return this.applyPostResolutionFilter(list, instantAppPkgName);
        }
        boolean sortResult = false;
        boolean addEphemeral = false;
        boolean ephemeralDisabled = this.isEphemeralDisabled();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (pkgName == null) {
                List<CrossProfileIntentFilter> matchingFilters = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, userId);
                ResolveInfo xpResolveInfo = this.querySkipCurrentProfileIntents(matchingFilters, intent, resolvedType, flags, userId);
                if (xpResolveInfo != null) {
                    ArrayList<ResolveInfo> xpResult = new ArrayList<ResolveInfo>(1);
                    xpResult.add(xpResolveInfo);
                    return this.applyPostResolutionFilter(this.filterIfNotSystemUser(xpResult, userId), instantAppPkgName);
                }
                result = this.filterIfNotSystemUser(this.mActivities.queryIntent(intent, resolvedType, flags, userId), userId);
                addEphemeral = !ephemeralDisabled && this.isInstantAppAllowed(intent, result, userId, false);
                boolean hasNonNegativePriorityResult = this.hasNonNegativePriority(result);
                xpResolveInfo = this.queryCrossProfileIntents(matchingFilters, intent, resolvedType, flags, userId, hasNonNegativePriorityResult);
                if (xpResolveInfo != null && this.isUserEnabled(xpResolveInfo.targetUserId)) {
                    boolean isVisibleToUser;
                    boolean bl = isVisibleToUser = this.filterIfNotSystemUser(Collections.singletonList(xpResolveInfo), userId).size() > 0;
                    if (isVisibleToUser) {
                        result.add(xpResolveInfo);
                        sortResult = true;
                    }
                }
                if (PackageManagerService.hasWebURI(intent)) {
                    CrossProfileDomainInfo xpDomainInfo = null;
                    UserInfo parent = this.getProfileParent(userId);
                    if (parent != null) {
                        xpDomainInfo = this.getCrossProfileDomainPreferredLpr(intent, resolvedType, flags, userId, parent.id);
                    }
                    if (xpDomainInfo != null) {
                        if (xpResolveInfo != null) {
                            result.remove(xpResolveInfo);
                        }
                        if (result.size() == 0 && !addEphemeral) {
                            result.add(xpDomainInfo.resolveInfo);
                            return this.applyPostResolutionFilter(result, instantAppPkgName);
                        }
                    } else if (result.size() <= 1 && !addEphemeral) {
                        return this.applyPostResolutionFilter(result, instantAppPkgName);
                    }
                    result = this.filterCandidatesWithDomainPreferredActivitiesLPr(intent, flags, result, xpDomainInfo, userId);
                    sortResult = true;
                }
            } else {
                PackageParser.Package pkg = this.mPackages.get(pkgName);
                result = null;
                if (pkg != null) {
                    result = this.filterIfNotSystemUser(this.mActivities.queryIntentForPackage(intent, resolvedType, flags, pkg.activities, userId), userId);
                }
                if (result == null || result.size() == 0) {
                    boolean bl = addEphemeral = !ephemeralDisabled && this.isInstantAppAllowed(intent, null, userId, true);
                    if (result == null) {
                        result = new ArrayList<ResolveInfo>();
                    }
                }
            }
        }
        if (addEphemeral) {
            result = this.maybeAddInstantAppInstaller(result, intent, resolvedType, flags, userId);
        }
        if (sortResult) {
            Collections.sort(result, mResolvePrioritySorter);
        }
        return this.applyPostResolutionFilter(result, instantAppPkgName);
    }

    private List<ResolveInfo> maybeAddInstantAppInstaller(List<ResolveInfo> result, Intent intent, String resolvedType, int flags, int userId) {
        boolean alreadyResolvedLocally = (flags & 0x800000) != 0;
        ResolveInfo localInstantApp = null;
        boolean blockResolution = false;
        if (!alreadyResolvedLocally) {
            List<ResolveInfo> instantApps = this.mActivities.queryIntent(intent, resolvedType, flags | 0x40 | 0x800000 | 0x1000000, userId);
            for (int i = instantApps.size() - 1; i >= 0; --i) {
                ResolveInfo info = instantApps.get(i);
                String packageName = info.activityInfo.packageName;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (!ps.getInstantApp(userId)) continue;
                long packedStatus = this.getDomainVerificationStatusLPr(ps, userId);
                int status = (int)(packedStatus >> 32);
                int linkGeneration = (int)(packedStatus & 0xFFFFFFFFFFFFFFFFL);
                if (status == 3) {
                    if (DEBUG_EPHEMERAL) {
                        Slog.v(TAG, "Instant app marked to never run; pkg: " + packageName);
                    }
                    blockResolution = true;
                    break;
                }
                if (DEBUG_EPHEMERAL) {
                    Slog.v(TAG, "Found installed instant app; pkg: " + packageName);
                }
                localInstantApp = info;
                break;
            }
        }
        AuxiliaryResolveInfo auxiliaryResponse = null;
        if (!blockResolution) {
            if (localInstantApp == null) {
                Trace.traceBegin(262144L, "resolveEphemeral");
                InstantAppRequest requestObject = new InstantAppRequest(null, intent, resolvedType, null, userId, null);
                auxiliaryResponse = InstantAppResolver.doInstantAppResolutionPhaseOne(this.mContext, this.mInstantAppResolverConnection, requestObject);
                Trace.traceEnd(262144L);
            } else {
                ApplicationInfo ai = localInstantApp.activityInfo.applicationInfo;
                auxiliaryResponse = new AuxiliaryResolveInfo(ai.packageName, null, ai.versionCode, null);
            }
        }
        if (auxiliaryResponse != null) {
            if (DEBUG_EPHEMERAL) {
                Slog.v(TAG, "Adding ephemeral installer to the ResolveInfo list");
            }
            ResolveInfo ephemeralInstaller = new ResolveInfo(this.mInstantAppInstallerInfo);
            PackageSetting ps = this.mSettings.mPackages.get(this.mInstantAppInstallerActivity.packageName);
            if (ps != null) {
                ephemeralInstaller.activityInfo = PackageParser.generateActivityInfo(this.mInstantAppInstallerActivity, 0, ps.readUserState(userId), userId);
                ephemeralInstaller.activityInfo.launchToken = auxiliaryResponse.token;
                ephemeralInstaller.auxiliaryInfo = auxiliaryResponse;
                ephemeralInstaller.isDefault = true;
                ephemeralInstaller.match = 0x588000;
                ephemeralInstaller.filter = new IntentFilter(intent.getAction());
                ephemeralInstaller.filter.addDataPath(intent.getData().getPath(), 0);
                ephemeralInstaller.isInstantAppAvailable = true;
                result.add(ephemeralInstaller);
            }
        }
        return result;
    }

    private CrossProfileDomainInfo getCrossProfileDomainPreferredLpr(Intent intent, String resolvedType, int flags, int sourceUserId, int parentUserId) {
        if (!sUserManager.hasUserRestriction("allow_parent_profile_app_linking", sourceUserId)) {
            return null;
        }
        List<ResolveInfo> resultTargetUser = this.mActivities.queryIntent(intent, resolvedType, flags, parentUserId);
        if (resultTargetUser == null || resultTargetUser.isEmpty()) {
            return null;
        }
        CrossProfileDomainInfo result = null;
        int size = resultTargetUser.size();
        for (int i = 0; i < size; ++i) {
            String packageName;
            PackageSetting ps;
            ResolveInfo riTargetUser = resultTargetUser.get(i);
            if (riTargetUser.handleAllWebDataURI || (ps = this.mSettings.mPackages.get(packageName = riTargetUser.activityInfo.packageName)) == null) continue;
            long verificationState = this.getDomainVerificationStatusLPr(ps, parentUserId);
            int status = (int)(verificationState >> 32);
            if (result == null) {
                result = new CrossProfileDomainInfo();
                result.resolveInfo = this.createForwardingResolveInfoUnchecked(new IntentFilter(), sourceUserId, parentUserId);
                result.bestDomainVerificationStatus = status;
                continue;
            }
            result.bestDomainVerificationStatus = this.bestDomainVerificationStatus(status, result.bestDomainVerificationStatus);
        }
        if (result != null && result.bestDomainVerificationStatus == 3) {
            return null;
        }
        return result;
    }

    private int bestDomainVerificationStatus(int status1, int status2) {
        if (status1 == 3) {
            return status2;
        }
        if (status2 == 3) {
            return status1;
        }
        return (int)MathUtils.max(status1, status2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserEnabled(int userId) {
        long callingId = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = sUserManager.getUserInfo(userId);
            boolean bl = userInfo != null && userInfo.isEnabled();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private List<ResolveInfo> filterIfNotSystemUser(List<ResolveInfo> resolveInfos, int userId) {
        if (userId == 0) {
            return resolveInfos;
        }
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            if ((info.activityInfo.flags & 0x20000000) == 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    private List<ResolveInfo> applyPostResolutionFilter(List<ResolveInfo> resolveInfos, String ephemeralPkgName) {
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            boolean isEphemeralApp = info.activityInfo.applicationInfo.isInstantApp();
            if (isEphemeralApp && info.activityInfo.splitName != null && !ArrayUtils.contains(info.activityInfo.applicationInfo.splitNames, info.activityInfo.splitName)) {
                if (DEBUG_EPHEMERAL) {
                    Slog.v(TAG, "Adding ephemeral installer to the ResolveInfo list");
                }
                ResolveInfo installerInfo = new ResolveInfo(this.mInstantAppInstallerInfo);
                installerInfo.auxiliaryInfo = new AuxiliaryResolveInfo(info.activityInfo.packageName, info.activityInfo.splitName, info.activityInfo.applicationInfo.versionCode, null);
                installerInfo.isDefault = true;
                installerInfo.match = 0x588000;
                installerInfo.filter = new IntentFilter();
                installerInfo.resolvePackageName = info.getComponentInfo().packageName;
                resolveInfos.set(i, installerInfo);
                continue;
            }
            if (ephemeralPkgName == null || ephemeralPkgName.equals(info.activityInfo.packageName) || !isEphemeralApp && (info.activityInfo.flags & 0x100000) != 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    private boolean hasNonNegativePriority(List<ResolveInfo> resolveInfos) {
        return resolveInfos.size() > 0 && resolveInfos.get((int)0).priority >= 0;
    }

    private static boolean hasWebURI(Intent intent) {
        if (intent.getData() == null) {
            return false;
        }
        String scheme = intent.getScheme();
        if (TextUtils.isEmpty(scheme)) {
            return false;
        }
        return scheme.equals("http") || scheme.equals("https");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> filterCandidatesWithDomainPreferredActivitiesLPr(Intent intent, int matchFlags, List<ResolveInfo> candidates, CrossProfileDomainInfo xpDomainInfo, int userId) {
        boolean debug = (intent.getFlags() & 8) != 0;
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        ArrayList<Object> alwaysList = new ArrayList<Object>();
        ArrayList<Object> undefinedList = new ArrayList<Object>();
        ArrayList<Object> alwaysAskList = new ArrayList<Object>();
        ArrayList<Object> neverList = new ArrayList<Object>();
        ArrayList<Object> matchAllList = new ArrayList<Object>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int count = candidates.size();
            for (int n = 0; n < count; ++n) {
                ResolveInfo info = candidates.get(n);
                String packageName = info.activityInfo.packageName;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) continue;
                if (info.handleAllWebDataURI) {
                    matchAllList.add(info);
                    continue;
                }
                long packedStatus = this.getDomainVerificationStatusLPr(ps, userId);
                int status = (int)(packedStatus >> 32);
                int linkGeneration = (int)(packedStatus & 0xFFFFFFFFFFFFFFFFL);
                if (status == 2) {
                    if (debug) {
                        Slog.i(TAG, "  + always: " + info.activityInfo.packageName + " : linkgen=" + linkGeneration);
                    }
                    info.preferredOrder = linkGeneration;
                    alwaysList.add(info);
                    continue;
                }
                if (status == 3) {
                    if (debug) {
                        Slog.i(TAG, "  + never: " + info.activityInfo.packageName);
                    }
                    neverList.add(info);
                    continue;
                }
                if (status == 4) {
                    if (debug) {
                        Slog.i(TAG, "  + always-ask: " + info.activityInfo.packageName);
                    }
                    alwaysAskList.add(info);
                    continue;
                }
                if (status != 0 && status != 1) continue;
                if (debug) {
                    Slog.i(TAG, "  + ask: " + info.activityInfo.packageName);
                }
                undefinedList.add(info);
            }
            boolean includeBrowser = false;
            if (alwaysList.size() > 0) {
                result.addAll(alwaysList);
            } else {
                result.addAll(undefinedList);
                if (xpDomainInfo != null && xpDomainInfo.bestDomainVerificationStatus != 3) {
                    result.add(xpDomainInfo.resolveInfo);
                }
                includeBrowser = true;
            }
            if (alwaysAskList.size() > 0) {
                for (ResolveInfo i : result) {
                    i.preferredOrder = 0;
                }
                result.addAll(alwaysAskList);
                includeBrowser = true;
            }
            if (includeBrowser) {
                if ((matchFlags & 0x20000) != 0) {
                    result.addAll(matchAllList);
                } else {
                    String defaultBrowserPackageName = this.getDefaultBrowserPackageName(userId);
                    int maxMatchPrio = 0;
                    ResolveInfo defaultBrowserMatch = null;
                    int numCandidates = matchAllList.size();
                    for (int n = 0; n < numCandidates; ++n) {
                        ResolveInfo info = (ResolveInfo)matchAllList.get(n);
                        if (info.priority > maxMatchPrio) {
                            maxMatchPrio = info.priority;
                        }
                        if (!info.activityInfo.packageName.equals(defaultBrowserPackageName) || defaultBrowserMatch != null && defaultBrowserMatch.priority >= info.priority) continue;
                        if (debug) {
                            Slog.v(TAG, "Considering default browser match " + info);
                        }
                        defaultBrowserMatch = info;
                    }
                    if (defaultBrowserMatch != null && defaultBrowserMatch.priority >= maxMatchPrio && !TextUtils.isEmpty(defaultBrowserPackageName)) {
                        if (debug) {
                            Slog.v(TAG, "Default browser match " + defaultBrowserMatch);
                        }
                        result.add(defaultBrowserMatch);
                    } else {
                        result.addAll(matchAllList);
                    }
                }
                if (result.size() == 0) {
                    result.addAll(candidates);
                    result.removeAll(neverList);
                }
            }
        }
        return result;
    }

    private long getDomainVerificationStatusLPr(PackageSetting ps, int userId) {
        long result = ps.getDomainVerificationStatusForUser(userId);
        if (result >> 32 == 0L && ps.getIntentFilterVerificationInfo() != null) {
            result = (long)ps.getIntentFilterVerificationInfo().getStatus() << 32;
        }
        return result;
    }

    private ResolveInfo querySkipCurrentProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId) {
        if (matchingFilters != null) {
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                ResolveInfo resolveInfo;
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                if ((filter.getFlags() & 2) == 0 || (resolveInfo = this.createForwardingResolveInfo(filter, intent, resolvedType, flags, sourceUserId)) == null) continue;
                return resolveInfo;
            }
        }
        return null;
    }

    private ResolveInfo queryCrossProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId, boolean matchInCurrentProfile) {
        if (matchingFilters != null) {
            SparseBooleanArray alreadyTriedUserIds = new SparseBooleanArray();
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                boolean skipCurrentProfileIfNoMatchFound;
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                int targetUserId = filter.getTargetUserId();
                boolean skipCurrentProfile = (filter.getFlags() & 2) != 0;
                boolean bl = skipCurrentProfileIfNoMatchFound = (filter.getFlags() & 4) != 0;
                if (skipCurrentProfile || alreadyTriedUserIds.get(targetUserId) || skipCurrentProfileIfNoMatchFound && matchInCurrentProfile) continue;
                ResolveInfo resolveInfo = this.createForwardingResolveInfo(filter, intent, resolvedType, flags, sourceUserId);
                if (resolveInfo != null) {
                    return resolveInfo;
                }
                alreadyTriedUserIds.put(targetUserId, true);
            }
        }
        return null;
    }

    private ResolveInfo createForwardingResolveInfo(CrossProfileIntentFilter filter, Intent intent, String resolvedType, int flags, int sourceUserId) {
        int targetUserId = filter.getTargetUserId();
        List<ResolveInfo> resultTargetUser = this.mActivities.queryIntent(intent, resolvedType, flags, targetUserId);
        if (resultTargetUser != null && this.isUserEnabled(targetUserId)) {
            for (int i = resultTargetUser.size() - 1; i >= 0; --i) {
                if ((resultTargetUser.get((int)i).activityInfo.applicationInfo.flags & 0x40000000) != 0) continue;
                return this.createForwardingResolveInfoUnchecked(filter, sourceUserId, targetUserId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveInfo createForwardingResolveInfoUnchecked(IntentFilter filter, int sourceUserId, int targetUserId) {
        boolean targetIsProfile;
        ResolveInfo forwardingResolveInfo = new ResolveInfo();
        long ident = Binder.clearCallingIdentity();
        try {
            targetIsProfile = sUserManager.getUserInfo(targetUserId).isManagedProfile();
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        String className = targetIsProfile ? IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE : IntentForwarderActivity.FORWARD_INTENT_TO_PARENT;
        ComponentName forwardingActivityComponentName = new ComponentName(this.mAndroidApplication.packageName, className);
        ActivityInfo forwardingActivityInfo = this.getActivityInfo(forwardingActivityComponentName, 0, sourceUserId);
        if (!targetIsProfile) {
            forwardingActivityInfo.showUserIcon = targetUserId;
            forwardingResolveInfo.noResourceId = true;
        }
        forwardingResolveInfo.activityInfo = forwardingActivityInfo;
        forwardingResolveInfo.priority = 0;
        forwardingResolveInfo.preferredOrder = 0;
        forwardingResolveInfo.match = 0;
        forwardingResolveInfo.isDefault = true;
        forwardingResolveInfo.filter = filter;
        forwardingResolveInfo.targetUserId = targetUserId;
        return forwardingResolveInfo;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) {
        return new ParceledListSlice<ResolveInfo>(this.queryIntentActivityOptionsInternal(caller, specifics, specificTypes, intent, resolvedType, flags, userId));
    }

    private List<ResolveInfo> queryIntentActivityOptionsInternal(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) {
        int N;
        int i;
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        this.enforceCrossUserPermission(callingUid, userId, false, false, "query intent activity options");
        String resultsAction = intent.getAction();
        List<ResolveInfo> results = this.queryIntentActivitiesInternal(intent, resolvedType, flags | 0x40, userId);
        int specificsPos = 0;
        if (specifics != null) {
            for (i = 0; i < specifics.length; ++i) {
                Intent sintent = specifics[i];
                if (sintent == null) continue;
                String action = sintent.getAction();
                if (resultsAction != null && resultsAction.equals(action)) {
                    action = null;
                }
                ResolveInfo ri = null;
                ActivityInfo ai = null;
                ComponentName comp = sintent.getComponent();
                if (comp == null) {
                    ri = this.resolveIntent(sintent, specificTypes != null ? specificTypes[i] : null, flags, userId);
                    if (ri == null) continue;
                    if (ri == this.mResolveInfo) {
                        // empty if block
                    }
                    ai = ri.activityInfo;
                    comp = new ComponentName(ai.applicationInfo.packageName, ai.name);
                } else {
                    ai = this.getActivityInfo(comp, flags, userId);
                    if (ai == null) continue;
                }
                N = results.size();
                for (int j = specificsPos; j < N; ++j) {
                    ResolveInfo sri = results.get(j);
                    if ((!sri.activityInfo.name.equals(comp.getClassName()) || !sri.activityInfo.applicationInfo.packageName.equals(comp.getPackageName())) && (action == null || !sri.filter.matchAction(action))) continue;
                    results.remove(j);
                    if (ri == null) {
                        ri = sri;
                    }
                    --j;
                    --N;
                }
                if (ri == null) {
                    ri = new ResolveInfo();
                    ri.activityInfo = ai;
                }
                results.add(specificsPos, ri);
                ri.specificIndex = i;
                ++specificsPos;
            }
        }
        N = results.size();
        for (i = specificsPos; i < N - 1; ++i) {
            Iterator<String> it;
            ResolveInfo rii = results.get(i);
            if (rii.filter == null || (it = rii.filter.actionsIterator()) == null) continue;
            while (it.hasNext()) {
                String action = it.next();
                if (resultsAction != null && resultsAction.equals(action)) continue;
                for (int j = i + 1; j < N; ++j) {
                    ResolveInfo rij = results.get(j);
                    if (rij.filter == null || !rij.filter.hasAction(action)) continue;
                    results.remove(j);
                    --j;
                    --N;
                }
            }
            if ((flags & 0x40) != 0) continue;
            rii.filter = null;
        }
        if (caller != null) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                ActivityInfo ainfo = results.get((int)i).activityInfo;
                if (!caller.getPackageName().equals(ainfo.applicationInfo.packageName) || !caller.getClassName().equals(ainfo.name)) continue;
                results.remove(i);
                break;
            }
        }
        if ((flags & 0x40) == 0) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                results.get((int)i).filter = null;
            }
        }
        return results;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentReceivers(Intent intent, String resolvedType, int flags, int userId) {
        return new ParceledListSlice<ResolveInfo>(this.queryIntentReceiversInternal(intent, resolvedType, flags, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentReceiversInternal(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        String instantAppPkgName = this.getInstantAppPackageName(callingUid);
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getReceiverInfo(comp, flags, userId);
            if (ai != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean matchExplicitlyVisibleOnly = (flags & 0x2000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (ai.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetVisibleToInstantApp = (ai.flags & 0x100000) != 0;
                boolean isTargetExplicitlyVisibleToInstantApp = isTargetVisibleToInstantApp && (ai.flags & 0x200000) == 0;
                boolean isTargetHiddenFromInstantApp = !isTargetVisibleToInstantApp || matchExplicitlyVisibleOnly && !isTargetExplicitlyVisibleToInstantApp;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.activityInfo = ai;
                    list.add(ri);
                }
            }
            return this.applyPostResolutionFilter(list, instantAppPkgName);
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                List<ResolveInfo> result = this.mReceivers.queryIntent(intent, resolvedType, flags, userId);
                return this.applyPostResolutionFilter(result, instantAppPkgName);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                List<ResolveInfo> result = this.mReceivers.queryIntentForPackage(intent, resolvedType, flags, pkg.receivers, userId);
                return this.applyPostResolutionFilter(result, instantAppPkgName);
            }
            return Collections.emptyList();
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        return this.resolveServiceInternal(intent, resolvedType, flags, userId, callingUid);
    }

    private ResolveInfo resolveServiceInternal(Intent intent, String resolvedType, int flags, int userId, int callingUid) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        List<ResolveInfo> query = this.queryIntentServicesInternal(intent, resolvedType, flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false), userId, callingUid, false);
        if (query != null && query.size() >= 1) {
            return query.get(0);
        }
        return null;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentServices(Intent intent, String resolvedType, int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        return new ParceledListSlice<ResolveInfo>(this.queryIntentServicesInternal(intent, resolvedType, flags, userId, callingUid, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentServicesInternal(Intent intent, String resolvedType, int flags, int userId, int callingUid, boolean includeInstantApps) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        String instantAppPkgName = this.getInstantAppPackageName(callingUid);
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, includeInstantApps);
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ServiceInfo si = this.getServiceInfo(comp, flags, userId);
            if (si != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (si.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetHiddenFromInstantApp = (si.flags & 0x100000) == 0;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.serviceInfo = si;
                    list.add(ri);
                }
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.applyPostServiceResolutionFilter(this.mServices.queryIntent(intent, resolvedType, flags, userId), instantAppPkgName);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.applyPostServiceResolutionFilter(this.mServices.queryIntentForPackage(intent, resolvedType, flags, pkg.services, userId), instantAppPkgName);
            }
            return Collections.emptyList();
        }
    }

    private List<ResolveInfo> applyPostServiceResolutionFilter(List<ResolveInfo> resolveInfos, String instantAppPkgName) {
        if (instantAppPkgName == null) {
            return resolveInfos;
        }
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            boolean isEphemeralApp = info.serviceInfo.applicationInfo.isInstantApp();
            if (isEphemeralApp && instantAppPkgName.equals(info.serviceInfo.packageName)) {
                if (info.serviceInfo.splitName == null || ArrayUtils.contains(info.serviceInfo.applicationInfo.splitNames, info.serviceInfo.splitName)) continue;
                if (DEBUG_EPHEMERAL) {
                    Slog.v(TAG, "Adding ephemeral installer to the ResolveInfo list");
                }
                ResolveInfo installerInfo = new ResolveInfo(this.mInstantAppInstallerInfo);
                installerInfo.auxiliaryInfo = new AuxiliaryResolveInfo(info.serviceInfo.packageName, info.serviceInfo.splitName, info.serviceInfo.applicationInfo.versionCode, null);
                installerInfo.isDefault = true;
                installerInfo.match = 0x588000;
                installerInfo.filter = new IntentFilter();
                installerInfo.resolvePackageName = info.getComponentInfo().packageName;
                resolveInfos.set(i, installerInfo);
                continue;
            }
            if (!isEphemeralApp && (info.serviceInfo.flags & 0x100000) != 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    @Override
    public ParceledListSlice<ResolveInfo> queryIntentContentProviders(Intent intent, String resolvedType, int flags, int userId) {
        return new ParceledListSlice<ResolveInfo>(this.queryIntentContentProvidersInternal(intent, resolvedType, flags, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> queryIntentContentProvidersInternal(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        String instantAppPkgName = this.getInstantAppPackageName(callingUid);
        flags = this.updateFlagsForResolve(flags, userId, intent, callingUid, false);
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ProviderInfo pi = this.getProviderInfo(comp, flags, userId);
            if (pi != null) {
                boolean blockResolution;
                boolean matchInstantApp = (flags & 0x800000) != 0;
                boolean matchVisibleToInstantAppOnly = (flags & 0x1000000) != 0;
                boolean isCallerInstantApp = instantAppPkgName != null;
                boolean isTargetSameInstantApp = comp.getPackageName().equals(instantAppPkgName);
                boolean isTargetInstantApp = (pi.applicationInfo.privateFlags & 0x80) != 0;
                boolean isTargetHiddenFromInstantApp = (pi.flags & 0x100000) == 0;
                boolean bl = blockResolution = !isTargetSameInstantApp && (!matchInstantApp && !isCallerInstantApp && isTargetInstantApp || matchVisibleToInstantAppOnly && isCallerInstantApp && isTargetHiddenFromInstantApp);
                if (!blockResolution) {
                    ResolveInfo ri = new ResolveInfo();
                    ri.providerInfo = pi;
                    list.add(ri);
                }
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.applyPostContentProviderResolutionFilter(this.mProviders.queryIntent(intent, resolvedType, flags, userId), instantAppPkgName);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.applyPostContentProviderResolutionFilter(this.mProviders.queryIntentForPackage(intent, resolvedType, flags, pkg.providers, userId), instantAppPkgName);
            }
            return Collections.emptyList();
        }
    }

    private List<ResolveInfo> applyPostContentProviderResolutionFilter(List<ResolveInfo> resolveInfos, String instantAppPkgName) {
        if (instantAppPkgName == null) {
            return resolveInfos;
        }
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            boolean isEphemeralApp = info.providerInfo.applicationInfo.isInstantApp();
            if (isEphemeralApp && instantAppPkgName.equals(info.providerInfo.packageName)) {
                if (info.providerInfo.splitName == null || ArrayUtils.contains(info.providerInfo.applicationInfo.splitNames, info.providerInfo.splitName)) continue;
                if (DEBUG_EPHEMERAL) {
                    Slog.v(TAG, "Adding ephemeral installer to the ResolveInfo list");
                }
                ResolveInfo installerInfo = new ResolveInfo(this.mInstantAppInstallerInfo);
                installerInfo.auxiliaryInfo = new AuxiliaryResolveInfo(info.providerInfo.packageName, info.providerInfo.splitName, info.providerInfo.applicationInfo.versionCode, null);
                installerInfo.isDefault = true;
                installerInfo.match = 0x588000;
                installerInfo.filter = new IntentFilter();
                installerInfo.resolvePackageName = info.getComponentInfo().packageName;
                resolveInfos.set(i, installerInfo);
                continue;
            }
            if (!isEphemeralApp && (info.providerInfo.flags & 0x100000) != 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getInstalledPackages(int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return ParceledListSlice.emptyList();
        }
        if (!sUserManager.exists(userId)) {
            return ParceledListSlice.emptyList();
        }
        boolean listUninstalled = ((flags = this.updateFlagsForPackage(flags, userId, null)) & 0x402000) != 0;
        this.enforceCrossUserPermission(callingUid, userId, true, false, "get installed packages");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PackageInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    if (this.filterSharedLibPackageLPr(ps, callingUid, userId, flags)) continue;
                    if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                        return null;
                    }
                    PackageInfo pi = this.generatePackageInfo(ps, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            } else {
                list = new ArrayList<PackageInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    PackageSetting ps = (PackageSetting)p.mExtras;
                    if (this.filterSharedLibPackageLPr(ps, callingUid, userId, flags)) continue;
                    if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                        return null;
                    }
                    PackageInfo pi = this.generatePackageInfo((PackageSetting)p.mExtras, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    private void addPackageHoldingPermissions(ArrayList<PackageInfo> list, PackageSetting ps, String[] permissions, boolean[] tmp, int flags, int userId) {
        int numMatch = 0;
        PermissionsState permissionsState = ps.getPermissionsState();
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            if (permissionsState.hasPermission(permission2, userId)) {
                tmp[i] = true;
                ++numMatch;
                continue;
            }
            tmp[i] = false;
        }
        if (numMatch == 0) {
            return;
        }
        PackageInfo pi = this.generatePackageInfo(ps, flags, userId);
        if (pi != null) {
            if ((flags & 0x1000) == 0) {
                if (numMatch == permissions.length) {
                    pi.requestedPermissions = permissions;
                } else {
                    pi.requestedPermissions = new String[numMatch];
                    numMatch = 0;
                    for (int i = 0; i < permissions.length; ++i) {
                        if (!tmp[i]) continue;
                        pi.requestedPermissions[numMatch] = permissions[i];
                        ++numMatch;
                    }
                }
            }
            list.add(pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return ParceledListSlice.emptyList();
        }
        flags = this.updateFlagsForPackage(flags, userId, permissions);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "get packages holding permissions");
        boolean listUninstalled = (flags & 0x402000) != 0;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
            boolean[] tmpBools = new boolean[permissions.length];
            if (listUninstalled) {
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            } else {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    if (ps == null) continue;
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ApplicationInfo> getInstalledApplications(int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return ParceledListSlice.emptyList();
        }
        if (!sUserManager.exists(userId)) {
            return ParceledListSlice.emptyList();
        }
        boolean listUninstalled = ((flags = this.updateFlagsForApplication(flags, userId, null)) & 0x402000) != 0;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<ApplicationInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    ApplicationInfo ai;
                    int effectiveFlags = flags;
                    if (ps.isSystem()) {
                        effectiveFlags |= 0x400000;
                    }
                    if (ps.pkg != null) {
                        if (this.filterSharedLibPackageLPr(ps, callingUid, userId, flags)) continue;
                        if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                            return null;
                        }
                        ai = PackageParser.generateApplicationInfo(ps.pkg, effectiveFlags, ps.readUserState(userId), userId);
                        if (ai != null) {
                            ai.packageName = this.resolveExternalPackageNameLPr(ps.pkg);
                        }
                    } else {
                        ai = this.generateApplicationInfoFromSettingsLPw(ps.name, callingUid, effectiveFlags, userId);
                    }
                    if (ai == null) continue;
                    list.add(ai);
                }
            } else {
                list = new ArrayList<ApplicationInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    PackageSetting ps;
                    if (p.mExtras == null || this.filterSharedLibPackageLPr(ps = (PackageSetting)p.mExtras, Binder.getCallingUid(), userId, flags)) continue;
                    if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                        return null;
                    }
                    ApplicationInfo ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId);
                    if (ai == null) continue;
                    ai.packageName = this.resolveExternalPackageNameLPr(p);
                    list.add(ai);
                }
            }
            return new ParceledListSlice<ApplicationInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<InstantAppInfo> getInstantApps(int userId) {
        if (this.isEphemeralDisabled()) {
            return null;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS", "getEphemeralApplications");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getEphemeralApplications");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            List<InstantAppInfo> instantApps = this.mInstantAppRegistry.getInstantAppsLPr(userId);
            if (instantApps != null) {
                return new ParceledListSlice<InstantAppInfo>(instantApps);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstantApp(String packageName, int userId) {
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "isInstantApp");
        if (this.isEphemeralDisabled()) {
            return false;
        }
        int callingUid = Binder.getCallingUid();
        if (Process.isIsolated(callingUid)) {
            callingUid = this.mIsolatedOwners.get(callingUid);
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean returnAllowed;
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            PackageParser.Package pkg = this.mPackages.get(packageName);
            boolean bl = returnAllowed = ps != null && (this.isCallerSameApp(packageName, callingUid) || this.canViewInstantApps(callingUid, userId) || this.mInstantAppRegistry.isInstantAccessGranted(userId, UserHandle.getAppId(callingUid), ps.appId));
            if (returnAllowed) {
                return ps.getInstantApp(userId);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getInstantAppCookie(String packageName, int userId) {
        if (this.isEphemeralDisabled()) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getInstantAppCookie");
        if (!this.isCallerSameApp(packageName, Binder.getCallingUid())) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.getInstantAppCookieLPw(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInstantAppCookie(String packageName, byte[] cookie, int userId) {
        if (this.isEphemeralDisabled()) {
            return true;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, true, "setInstantAppCookie");
        if (!this.isCallerSameApp(packageName, Binder.getCallingUid())) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.setInstantAppCookieLPw(packageName, cookie, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getInstantAppIcon(String packageName, int userId) {
        if (this.isEphemeralDisabled()) {
            return null;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS", "getInstantAppIcon");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getInstantAppIcon");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.getInstantAppIconLPw(packageName, userId);
        }
    }

    private boolean isCallerSameApp(String packageName, int uid) {
        PackageParser.Package pkg = this.mPackages.get(packageName);
        return pkg != null && UserHandle.getAppId(uid) == pkg.applicationInfo.uid;
    }

    @Override
    public ParceledListSlice<ApplicationInfo> getPersistentApplications(int flags) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return ParceledListSlice.emptyList();
        }
        return new ParceledListSlice<ApplicationInfo>(this.getPersistentApplicationsInternal(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ApplicationInfo> getPersistentApplicationsInternal(int flags) {
        ArrayList<ApplicationInfo> finalList = new ArrayList<ApplicationInfo>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Iterator<PackageParser.Package> i = this.mPackages.values().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ApplicationInfo ai;
                PackageSetting ps;
                boolean matchesAware;
                PackageParser.Package p = i.next();
                if (p.applicationInfo == null) continue;
                boolean matchesUnaware = (flags & 0x40000) != 0 && !p.applicationInfo.isDirectBootAware();
                boolean bl = matchesAware = (flags & 0x80000) != 0 && p.applicationInfo.isDirectBootAware();
                if ((p.applicationInfo.flags & 8) == 0 || this.mSafeMode && !PackageManagerService.isSystemApp(p) || !matchesUnaware && !matchesAware || (ps = this.mSettings.mPackages.get(p.packageName)) == null || (ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(ai);
            }
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo resolveContentProvider(String name, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        flags = this.updateFlagsForComponent(flags, userId, name);
        String instantAppPkgName = this.getInstantAppPackageName(Binder.getCallingUid());
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSettingBase ps;
            PackageParser.Provider provider = this.mProvidersByAuthority.get(name);
            PackageSettingBase packageSettingBase = ps = provider != null ? this.mSettings.mPackages.get(provider.owner.packageName) : null;
            if (ps != null) {
                boolean isInstantApp = ps.getInstantApp(userId);
                if (instantAppPkgName == null && isInstantApp) {
                    return null;
                }
                if (instantAppPkgName != null && isInstantApp && !provider.owner.packageName.equals(instantAppPkgName)) {
                    return null;
                }
                if (instantAppPkgName != null && !isInstantApp && (provider.info.flags & 0x100000) == 0) {
                    return null;
                }
                if (!this.mSettings.isEnabledAndMatchLPr(provider.info, flags, userId)) {
                    return null;
                }
                return PackageParser.generateProviderInfo(provider, flags, ps.readUserState(userId), userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Iterator<Map.Entry<String, PackageParser.Provider>> i = this.mProvidersByAuthority.entrySet().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ProviderInfo info;
                Map.Entry<String, PackageParser.Provider> entry = i.next();
                PackageParser.Provider p = entry.getValue();
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || !p.syncable || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0 || (info = PackageParser.generateProviderInfo(p, 0, ps.readUserState(userId), userId)) == null) continue;
                outNames.add(entry.getKey());
                outInfo.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ProviderInfo> queryContentProviders(String processName, int uid, int flags, String metaDataKey) {
        int userId;
        int callingUid = Binder.getCallingUid();
        int n = userId = processName != null ? UserHandle.getUserId(uid) : UserHandle.getCallingUserId();
        if (!sUserManager.exists(userId)) {
            return ParceledListSlice.emptyList();
        }
        flags = this.updateFlagsForComponent(flags, userId, processName);
        ArrayList<ProviderInfo> finalList = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Provider p : this.mProviders.mProviders.values()) {
                ProviderInfo info;
                ComponentName component;
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || p.info.authority == null || processName != null && (!p.info.processName.equals(processName) || !UserHandle.isSameApp(p.info.applicationInfo.uid, uid)) || !this.mSettings.isEnabledAndMatchLPr(p.info, flags, userId) || metaDataKey != null && (p.metaData == null || !p.metaData.containsKey(metaDataKey)) || this.filterAppAccessLPr(ps, callingUid, component = new ComponentName(p.info.packageName, p.info.name), 4, userId)) continue;
                if (finalList == null) {
                    finalList = new ArrayList<ProviderInfo>(3);
                }
                if ((info = PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(info);
            }
        }
        if (finalList != null) {
            Collections.sort(finalList, mProviderInitOrderSorter);
            return new ParceledListSlice<ProviderInfo>(finalList);
        }
        return ParceledListSlice.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName component, int flags) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
            if (ps == null) {
                return null;
            }
            if (this.filterAppAccessLPr(ps, callingUid, component, 0, callingUserId)) {
                return null;
            }
            PackageParser.Instrumentation i = this.mInstrumentation.get(component);
            return PackageParser.generateInstrumentationInfo(i, flags);
        }
    }

    @Override
    public ParceledListSlice<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        PackageSetting ps = this.mSettings.mPackages.get(targetPackage);
        if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
            return ParceledListSlice.emptyList();
        }
        return new ParceledListSlice<InstrumentationInfo>(this.queryInstrumentationInternal(targetPackage, flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InstrumentationInfo> queryInstrumentationInternal(String targetPackage, int flags) {
        ArrayList<InstrumentationInfo> finalList = new ArrayList<InstrumentationInfo>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Instrumentation p : this.mInstrumentation.values()) {
                InstrumentationInfo ii;
                if (targetPackage != null && !targetPackage.equals(p.info.targetPackage) || (ii = PackageParser.generateInstrumentationInfo(p, flags)) == null) continue;
                finalList.add(ii);
            }
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDirTracedLI(File dir, int parseFlags, int scanFlags, long currentTime) {
        Trace.traceBegin(262144L, "scanDir [" + dir.getAbsolutePath() + "]");
        try {
            this.scanDirLI(dir, parseFlags, scanFlags, currentTime);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    private void scanDirLI(File dir, int parseFlags, int scanFlags, long currentTime) {
        File[] files = dir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            Log.d(TAG, "No files in app dir " + dir);
            return;
        }
        ParallelPackageParser parallelPackageParser = new ParallelPackageParser(this.mSeparateProcesses, this.mOnlyCore, this.mMetrics, this.mCacheDir, this.mParallelPackageParserCallback);
        int fileCount = 0;
        for (File file : files) {
            boolean isPackage;
            boolean bl = isPackage = (PackageParser.isApkFile(file) || file.isDirectory()) && !PackageInstallerService.isStageName(file.getName());
            if (!isPackage) continue;
            parallelPackageParser.submit(file, parseFlags);
            ++fileCount;
        }
        while (fileCount > 0) {
            ParallelPackageParser.ParseResult parseResult = parallelPackageParser.take();
            Throwable throwable = parseResult.throwable;
            int errorCode = 1;
            if (throwable == null) {
                if (parseResult.pkg.applicationInfo.isStaticSharedLibrary()) {
                    this.renameStaticSharedLibraryPackage(parseResult.pkg);
                }
                try {
                    if (errorCode == 1) {
                        this.scanPackageLI(parseResult.pkg, parseResult.scanFile, parseFlags, scanFlags, currentTime, null);
                    }
                }
                catch (PackageManagerException e) {
                    errorCode = e.error;
                    Slog.w(TAG, "Failed to scan " + parseResult.scanFile + ": " + e.getMessage());
                }
            } else if (throwable instanceof PackageParser.PackageParserException) {
                PackageParser.PackageParserException e = (PackageParser.PackageParserException)throwable;
                errorCode = e.error;
                Slog.w(TAG, "Failed to parse " + parseResult.scanFile + ": " + e.getMessage());
            } else {
                throw new IllegalStateException("Unexpected exception occurred while parsing " + parseResult.scanFile, throwable);
            }
            if ((parseFlags & 1) == 0 && errorCode == -2) {
                PackageManagerService.logCriticalInfo(5, "Deleting invalid package at " + parseResult.scanFile);
                this.removeCodePathLI(parseResult.scanFile);
            }
            --fileCount;
        }
        parallelPackageParser.close();
    }

    private static File getSettingsProblemFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "uiderrors.txt");
        return fname;
    }

    static void reportSettingsProblem(int priority, String msg) {
        PackageManagerService.logCriticalInfo(priority, msg);
    }

    public static void logCriticalInfo(int priority, String msg) {
        Slog.println(priority, TAG, msg);
        EventLogTags.writePmCriticalInfo(msg);
        try {
            File fname = PackageManagerService.getSettingsProblemFile();
            FileOutputStream out = new FileOutputStream(fname, true);
            FastPrintWriter pw = new FastPrintWriter(out);
            SimpleDateFormat formatter = new SimpleDateFormat();
            String dateString = formatter.format(new Date(System.currentTimeMillis()));
            pw.println(dateString + ": " + msg);
            ((PrintWriter)pw).close();
            FileUtils.setPermissions(fname.toString(), 508, -1, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private long getLastModifiedTime(PackageParser.Package pkg, File srcFile) {
        if (srcFile.isDirectory()) {
            File baseFile = new File(pkg.baseCodePath);
            long maxModifiedTime = baseFile.lastModified();
            if (pkg.splitCodePaths != null) {
                for (int i = pkg.splitCodePaths.length - 1; i >= 0; --i) {
                    File splitFile = new File(pkg.splitCodePaths[i]);
                    maxModifiedTime = Math.max(maxModifiedTime, splitFile.lastModified());
                }
            }
            return maxModifiedTime;
        }
        return srcFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCertificatesLI(PackageSetting ps, PackageParser.Package pkg, File srcFile, int policyFlags) throws PackageManagerException {
        long lastModifiedTime;
        long l = lastModifiedTime = this.mIsPreNMR1Upgrade ? new File(pkg.codePath).lastModified() : this.getLastModifiedTime(pkg, srcFile);
        if (ps != null && ps.codePath.equals(srcFile) && ps.timeStamp == lastModifiedTime && !this.isCompatSignatureUpdateNeeded(pkg) && !this.isRecoverSignatureUpdateNeeded(pkg)) {
            ArraySet<PublicKey> signingKs;
            long mSigningKeySetId = ps.keySetData.getProperSigningKeySet();
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                signingKs = ksms.getPublicKeysFromKeySetLPr(mSigningKeySetId);
            }
            if (ps.signatures.mSignatures != null && ps.signatures.mSignatures.length != 0 && signingKs != null) {
                pkg.mSignatures = ps.signatures.mSignatures;
                pkg.mSigningKeys = signingKs;
                return;
            }
            Slog.w(TAG, "PackageSetting for " + ps.name + " is missing signatures.  Collecting certs again to recover them.");
        } else {
            Slog.i(TAG, srcFile.toString() + " changed; collecting certs");
        }
        try {
            Trace.traceBegin(262144L, "collectCertificates");
            PackageParser.collectCertificates(pkg, policyFlags);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageTracedLI(File scanFile, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        Trace.traceBegin(262144L, "scanPackage [" + scanFile.toString() + "]");
        try {
            PackageParser.Package package_ = this.scanPackageLI(scanFile, parseFlags, scanFlags, currentTime, user);
            return package_;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    private PackageParser.Package scanPackageLI(File scanFile, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        PackageParser.Package pkg;
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setOnlyCoreApps(this.mOnlyCore);
        pp.setDisplayMetrics(this.mMetrics);
        pp.setCallback(this.mPackageParserCallback);
        if ((scanFlags & 0x80) != 0) {
            parseFlags |= 0x200;
        }
        Trace.traceBegin(262144L, "parsePackage");
        try {
            pkg = pp.parsePackage(scanFile, parseFlags);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (pkg.applicationInfo.isStaticSharedLibrary()) {
            this.renameStaticSharedLibraryPackage(pkg);
        }
        return this.scanPackageLI(pkg, scanFile, parseFlags, scanFlags, currentTime, user);
    }

    private PackageParser.Package scanPackageLI(PackageParser.Package pkg, File scanFile, int policyFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        if ((scanFlags & 0x2000) == 0) {
            if (pkg.childPackages != null && pkg.childPackages.size() > 0) {
                scanFlags |= 0x2000;
            }
        } else {
            scanFlags &= 0xFFFFDFFF;
        }
        PackageParser.Package scannedPkg = this.scanPackageInternalLI(pkg, scanFile, policyFlags, scanFlags, currentTime, user);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPackage = pkg.childPackages.get(i);
            this.scanPackageInternalLI(childPackage, scanFile, policyFlags, scanFlags, currentTime, user);
        }
        if ((scanFlags & 0x2000) != 0) {
            return this.scanPackageLI(pkg, scanFile, policyFlags, scanFlags, currentTime, user);
        }
        return scannedPkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageInternalLI(PackageParser.Package pkg, File scanFile, int policyFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        int userId;
        PackageSetting updatedPkg;
        PackageSetting ps = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting disabledPs;
            String oldName = this.mSettings.getRenamedPackageLPr(pkg.packageName);
            if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName)) {
                ps = this.mSettings.getPackageLPr(oldName);
            }
            if (ps == null) {
                ps = this.mSettings.getPackageLPr(pkg.packageName);
            }
            updatedPkg = this.mSettings.getDisabledSystemPkgLPr(ps != null ? ps.name : pkg.packageName);
            if ((policyFlags & 1) != 0 && (disabledPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName)) != null) {
                int scannedChildCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
                int disabledChildCount = disabledPs.childPackageNames != null ? disabledPs.childPackageNames.size() : 0;
                for (int i = 0; i < disabledChildCount; ++i) {
                    String disabledChildPackageName = (String)disabledPs.childPackageNames.get(i);
                    boolean disabledPackageAvailable = false;
                    for (int j = 0; j < scannedChildCount; ++j) {
                        PackageParser.Package childPkg = pkg.childPackages.get(j);
                        if (!childPkg.packageName.equals(disabledChildPackageName)) continue;
                        disabledPackageAvailable = true;
                        break;
                    }
                    if (disabledPackageAvailable) continue;
                    this.mSettings.removeDisabledSystemPackageLPw(disabledChildPackageName);
                }
            }
        }
        boolean updatedPkgBetter = false;
        if (updatedPkg != null && (policyFlags & 1) != 0) {
            updatedPkg.pkgPrivateFlags = PackageManagerService.locationIsPrivileged(scanFile) ? (updatedPkg.pkgPrivateFlags |= 8) : (updatedPkg.pkgPrivateFlags &= 0xFFFFFFF7);
            if (ps != null && !ps.codePath.equals(scanFile)) {
                if (pkg.mVersionCode <= ps.versionCode) {
                    if (!updatedPkg.codePath.equals(scanFile)) {
                        Slog.w(TAG, "Code path for hidden system pkg " + ps.name + " changing from " + updatedPkg.codePathString + " to " + scanFile);
                        updatedPkg.codePath = scanFile;
                        updatedPkg.codePathString = scanFile.toString();
                        updatedPkg.resourcePath = scanFile;
                        updatedPkg.resourcePathString = scanFile.toString();
                    }
                    updatedPkg.pkg = pkg;
                    updatedPkg.versionCode = pkg.mVersionCode;
                    int childCount = updatedPkg.childPackageNames != null ? updatedPkg.childPackageNames.size() : 0;
                    for (int i = 0; i < childCount; ++i) {
                        String childPackageName = (String)updatedPkg.childPackageNames.get(i);
                        PackageSetting updatedChildPkg = this.mSettings.getDisabledSystemPkgLPr(childPackageName);
                        if (updatedChildPkg == null) continue;
                        updatedChildPkg.pkg = pkg;
                        updatedChildPkg.versionCode = pkg.mVersionCode;
                    }
                    throw new PackageManagerException(5, "Package " + ps.name + " at " + scanFile + " ignored: updated version " + ps.versionCode + " better than this " + pkg.mVersionCode);
                }
                ArrayMap<String, PackageParser.Package> childCount = this.mPackages;
                synchronized (childCount) {
                    this.mPackages.remove(ps.name);
                }
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " at " + scanFile + " reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
                InstallArgs args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, InstructionSets.getAppDexInstructionSets(ps));
                ArrayMap<String, PackageParser.Package> i = this.mInstallLock;
                synchronized (i) {
                    args.cleanUpResourcesLI();
                }
                i = this.mPackages;
                synchronized (i) {
                    this.mSettings.enableSystemPackageLPw(ps.name);
                }
                updatedPkgBetter = true;
            }
        }
        if (updatedPkg != null) {
            policyFlags |= 1;
            if ((updatedPkg.pkgPrivateFlags & 8) != 0) {
                policyFlags |= 0x80;
            }
        }
        this.collectCertificatesLI(ps, pkg, scanFile, policyFlags);
        boolean shouldHideSystemApp = false;
        if (updatedPkg == null && ps != null && (policyFlags & 0x40) != 0 && !PackageManagerService.isSystemApp(ps)) {
            if (PackageManagerService.compareSignatures(ps.signatures.mSignatures, pkg.mSignatures) != 0) {
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " appeared on system, but" + " signatures don't match existing userdata copy; removing");
                try (PackageFreezer freezer = this.freezePackage(pkg.packageName, "scanPackageInternalLI");){
                    this.deletePackageLIF(pkg.packageName, null, true, null, 0, null, false, null);
                }
                ps = null;
            } else if (pkg.mVersionCode <= ps.versionCode) {
                shouldHideSystemApp = true;
                PackageManagerService.logCriticalInfo(4, "Package " + ps.name + " appeared at " + scanFile + " but new version " + pkg.mVersionCode + " better than installed " + ps.versionCode + "; hiding system");
            } else {
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " at " + scanFile + " reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
                InstallArgs args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, InstructionSets.getAppDexInstructionSets(ps));
                Object childPackageName = this.mInstallLock;
                synchronized (childPackageName) {
                    args.cleanUpResourcesLI();
                }
            }
        }
        if ((policyFlags & 0x40) == 0 && ps != null && !ps.codePath.equals(ps.resourcePath)) {
            policyFlags |= 0x10;
        }
        String resourcePath = null;
        String baseResourcePath = null;
        if ((policyFlags & 0x10) != 0 && !updatedPkgBetter) {
            if (ps != null && ps.resourcePathString != null) {
                resourcePath = ps.resourcePathString;
                baseResourcePath = ps.resourcePathString;
            } else {
                Slog.e(TAG, "Resource path not set for package " + pkg.packageName);
            }
        } else {
            resourcePath = pkg.codePath;
            baseResourcePath = pkg.baseCodePath;
        }
        pkg.setApplicationVolumeUuid(pkg.volumeUuid);
        pkg.setApplicationInfoCodePath(pkg.codePath);
        pkg.setApplicationInfoBaseCodePath(pkg.baseCodePath);
        pkg.setApplicationInfoSplitCodePaths(pkg.splitCodePaths);
        pkg.setApplicationInfoResourcePath(resourcePath);
        pkg.setApplicationInfoBaseResourcePath(baseResourcePath);
        pkg.setApplicationInfoSplitResourcePaths(pkg.splitCodePaths);
        int n = userId = user == null ? 0 : user.getIdentifier();
        if (ps != null && ps.getInstantApp(userId)) {
            scanFlags |= 0x20000;
        }
        PackageParser.Package scannedPkg = this.scanPackageLI(pkg, policyFlags, scanFlags | 8, currentTime, user);
        if (shouldHideSystemApp) {
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                this.mSettings.disableSystemPackageLPw(pkg.packageName, true);
            }
        }
        return scannedPkg;
    }

    private void renameStaticSharedLibraryPackage(PackageParser.Package pkg) {
        pkg.setPackageName(pkg.packageName + STATIC_SHARED_LIB_DELIMITER + pkg.staticSharedLibVersion);
    }

    private static String fixProcessName(String defProcessName, String processName) {
        if (processName == null) {
            return defProcessName;
        }
        return processName;
    }

    private void verifySignaturesLP(PackageSetting pkgSetting, PackageParser.Package pkg) throws PackageManagerException {
        boolean match;
        if (pkgSetting.signatures.mSignatures != null) {
            boolean bl = match = PackageManagerService.compareSignatures(pkgSetting.signatures.mSignatures, pkg.mSignatures) == 0;
            if (!match) {
                boolean bl2 = match = this.compareSignaturesCompat(pkgSetting.signatures, pkg) == 0;
            }
            if (!match) {
                boolean bl3 = match = this.compareSignaturesRecover(pkgSetting.signatures, pkg) == 0;
            }
            if (!match) {
                throw new PackageManagerException(-7, "Package " + pkg.packageName + " signatures do not match the " + "previously installed version; ignoring!");
            }
        }
        if (pkgSetting.sharedUser != null && pkgSetting.sharedUser.signatures.mSignatures != null) {
            boolean bl = match = PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) == 0;
            if (!match) {
                boolean bl4 = match = this.compareSignaturesCompat(pkgSetting.sharedUser.signatures, pkg) == 0;
            }
            if (!match) {
                boolean bl5 = match = this.compareSignaturesRecover(pkgSetting.sharedUser.signatures, pkg) == 0;
            }
            if (!match) {
                throw new PackageManagerException(-8, "Package " + pkg.packageName + " has no signatures that match those in shared user " + pkgSetting.sharedUser.name + "; ignoring!");
            }
        }
    }

    private static final void enforceSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0) {
            throw new SecurityException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performFstrimIfNeeded() {
        block10: {
            PackageManagerService.enforceSystemOrRoot("Only the system can request fstrim");
            try {
                IStorageManager sm = PackageHelper.getStorageManager();
                if (sm != null) {
                    boolean dexOptDialogShown;
                    long timeSinceLast;
                    boolean doTrim = false;
                    long interval = Settings.Global.getLong(this.mContext.getContentResolver(), "fstrim_mandatory_interval", 259200000L);
                    if (interval > 0L && (timeSinceLast = System.currentTimeMillis() - sm.lastMaintenance()) > interval) {
                        doTrim = true;
                        Slog.w(TAG, "No disk maintenance in " + timeSinceLast + "; running immediately");
                    }
                    if (!doTrim) break block10;
                    ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                    synchronized (arrayMap) {
                        dexOptDialogShown = this.mDexOptDialogShown;
                    }
                    if (!this.isFirstBoot() && dexOptDialogShown) {
                        try {
                            ActivityManager.getService().showBootMessage(this.mContext.getResources().getString(17039468), true);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    sm.runMaintenance();
                    break block10;
                }
                Slog.e(TAG, "storageManager service unavailable!");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePackagesIfNeeded() {
        List<PackageParser.Package> pkgs;
        PackageManagerService.enforceSystemOrRoot("Only the system can request package update");
        boolean causeUpgrade = this.isUpgrade();
        boolean causeFirstBoot = this.isFirstBoot() || this.mIsPreNUpgrade;
        boolean causePrunedCache = VMRuntime.didPruneDalvikCache();
        if (!(causeUpgrade || causeFirstBoot || causePrunedCache)) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkgs = PackageManagerServiceUtils.getPackagesForDexopt(this.mPackages.values(), this);
        }
        long startTime = System.nanoTime();
        int[] stats = this.performDexOptUpgrade(pkgs, this.mIsPreNUpgrade, PackageManagerServiceCompilerMapping.getCompilerFilterForReason(causeFirstBoot ? 0 : 1));
        int elapsedTimeSeconds = (int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_dexopted", stats[0]);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_skipped", stats[1]);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_failed", stats[2]);
        MetricsLogger.histogram(this.mContext, "opt_dialog_num_total", this.getOptimizablePackages().size());
        MetricsLogger.histogram(this.mContext, "opt_dialog_time_s", elapsedTimeSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] performDexOptUpgrade(List<PackageParser.Package> pkgs, boolean showDialog, String compilerFilter) {
        int numberOfPackagesVisited = 0;
        int numberOfPackagesOptimized = 0;
        int numberOfPackagesSkipped = 0;
        int numberOfPackagesFailed = 0;
        int numberOfPackagesToDexopt = pkgs.size();
        block10: for (PackageParser.Package pkg : pkgs) {
            ++numberOfPackagesVisited;
            if (!PackageDexOptimizer.canOptimizePackage(pkg)) {
                ++numberOfPackagesSkipped;
                continue;
            }
            if (showDialog) {
                try {
                    ActivityManager.getService().showBootMessage(this.mContext.getResources().getString(17039466, numberOfPackagesVisited, numberOfPackagesToDexopt), true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.mDexOptDialogShown = true;
                }
            }
            if (PackageManagerService.isSystemApp(pkg) && DexFile.isProfileGuidedCompilerFilter(compilerFilter) && !Environment.getReferenceProfile(pkg.packageName).exists()) {
                compilerFilter = DexFile.getNonProfileGuidedCompilerFilter(compilerFilter);
            }
            int dexOptStatus = this.performDexOptTraced(pkg.packageName, false, compilerFilter, false);
            switch (dexOptStatus) {
                case 1: {
                    ++numberOfPackagesOptimized;
                    continue block10;
                }
                case 0: {
                    ++numberOfPackagesSkipped;
                    continue block10;
                }
                case -1: {
                    ++numberOfPackagesFailed;
                    continue block10;
                }
            }
            Log.e(TAG, "Unexpected dexopt return code " + dexOptStatus);
        }
        return new int[]{numberOfPackagesOptimized, numberOfPackagesSkipped, numberOfPackagesFailed};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPackageUse(String packageName, int reason) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p;
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            if (this.getInstantAppPackageName(callingUid) != null) {
                if (!this.isCallerSameApp(packageName, callingUid)) {
                    return;
                }
            } else if (this.isInstantApp(packageName, callingUserId)) {
                return;
            }
            if ((p = this.mPackages.get(packageName)) == null) {
                return;
            }
            p.mLastPackageUsageTimeInMills[reason] = System.currentTimeMillis();
        }
    }

    @Override
    public void notifyDexLoad(String loadingPackageName, List<String> dexPaths, String loaderIsa) {
        int userId = UserHandle.getCallingUserId();
        ApplicationInfo ai = this.getApplicationInfo(loadingPackageName, 0, userId);
        if (ai == null) {
            Slog.w(TAG, "Loading a package that does not exist for the calling user. package=" + loadingPackageName + ", user=" + userId);
            return;
        }
        this.mDexManager.notifyDexLoad(ai, dexPaths, loaderIsa, userId);
    }

    @Override
    public boolean performDexOpt(String packageName, boolean checkProfiles, int compileReason, boolean force) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        if (this.isInstantApp(packageName, UserHandle.getCallingUserId())) {
            return false;
        }
        return this.performDexOptWithStatus(packageName, checkProfiles, compileReason, force) != -1;
    }

    int performDexOptWithStatus(String packageName, boolean checkProfiles, int compileReason, boolean force) {
        return this.performDexOptTraced(packageName, checkProfiles, PackageManagerServiceCompilerMapping.getCompilerFilterForReason(compileReason), force);
    }

    @Override
    public boolean performDexOptMode(String packageName, boolean checkProfiles, String targetCompilerFilter, boolean force) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        if (this.isInstantApp(packageName, UserHandle.getCallingUserId())) {
            return false;
        }
        int dexOptStatus = this.performDexOptTraced(packageName, checkProfiles, targetCompilerFilter, force);
        return dexOptStatus != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performDexOptTraced(String packageName, boolean checkProfiles, String targetCompilerFilter, boolean force) {
        Trace.traceBegin(262144L, "dexopt");
        try {
            int n = this.performDexOptInternal(packageName, checkProfiles, targetCompilerFilter, force);
            return n;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performDexOptInternal(String packageName, boolean checkProfiles, String targetCompilerFilter, boolean force) {
        PackageParser.Package p;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            p = this.mPackages.get(packageName);
            if (p == null) {
                return -1;
            }
            this.mPackageUsage.maybeWriteAsync(this.mPackages);
            this.mCompilerStats.maybeWriteAsync();
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            Object object = this.mInstallLock;
            synchronized (object) {
                int n = this.performDexOptInternalWithDependenciesLI(p, checkProfiles, targetCompilerFilter, force);
                return n;
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArraySet<String> getOptimizablePackages() {
        ArraySet<String> pkgs = new ArraySet<String>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Package p : this.mPackages.values()) {
                if (!PackageDexOptimizer.canOptimizePackage(p)) continue;
                pkgs.add(p.packageName);
            }
        }
        return pkgs;
    }

    private int performDexOptInternalWithDependenciesLI(PackageParser.Package p, boolean checkProfiles, String targetCompilerFilter, boolean force) {
        PackageDexOptimizer pdo = force ? new PackageDexOptimizer.ForcedUpdatePackageDexOptimizer(this.mPackageDexOptimizer) : this.mPackageDexOptimizer;
        List<PackageParser.Package> deps = this.findSharedNonSystemLibraries(p);
        String[] instructionSets = InstructionSets.getAppDexInstructionSets(p.applicationInfo);
        if (!deps.isEmpty()) {
            for (PackageParser.Package depPackage : deps) {
                pdo.performDexOpt(depPackage, null, instructionSets, false, targetCompilerFilter, this.getOrCreateCompilerPackageStats(depPackage), true);
            }
        }
        return pdo.performDexOpt(p, p.usesLibraryFiles, instructionSets, checkProfiles, targetCompilerFilter, this.getOrCreateCompilerPackageStats(p), this.mDexManager.isUsedByOtherApps(p.packageName));
    }

    @Override
    public boolean performDexOptSecondary(String packageName, String compilerFilter, boolean force) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        if (this.isInstantApp(packageName, UserHandle.getCallingUserId())) {
            return false;
        }
        this.mDexManager.reconcileSecondaryDexFiles(packageName);
        return this.mDexManager.dexoptSecondaryDex(packageName, compilerFilter, force);
    }

    public boolean performDexOptSecondary(String packageName, int compileReason, boolean force) {
        return this.mDexManager.dexoptSecondaryDex(packageName, compileReason, force);
    }

    @Override
    public void reconcileSecondaryDexFiles(String packageName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        if (this.isInstantApp(packageName, UserHandle.getCallingUserId())) {
            return;
        }
        this.mDexManager.reconcileSecondaryDexFiles(packageName);
    }

    DexManager getDexManager() {
        return this.mDexManager;
    }

    @Override
    public boolean runBackgroundDexoptJob() {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return false;
        }
        return BackgroundDexOptService.runIdleOptimizationsNow(this, this.mContext);
    }

    List<PackageParser.Package> findSharedNonSystemLibraries(PackageParser.Package p) {
        if (p.usesLibraries != null || p.usesOptionalLibraries != null || p.usesStaticLibraries != null) {
            ArrayList<PackageParser.Package> retValue = new ArrayList<PackageParser.Package>();
            HashSet<String> collectedNames = new HashSet<String>();
            this.findSharedNonSystemLibrariesRecursive(p, retValue, collectedNames);
            retValue.remove(p);
            return retValue;
        }
        return Collections.emptyList();
    }

    private void findSharedNonSystemLibrariesRecursive(PackageParser.Package p, ArrayList<PackageParser.Package> collected, Set<String> collectedNames) {
        if (!collectedNames.contains(p.packageName)) {
            collectedNames.add(p.packageName);
            collected.add(p);
            if (p.usesLibraries != null) {
                this.findSharedNonSystemLibrariesRecursive(p.usesLibraries, null, collected, collectedNames);
            }
            if (p.usesOptionalLibraries != null) {
                this.findSharedNonSystemLibrariesRecursive(p.usesOptionalLibraries, null, collected, collectedNames);
            }
            if (p.usesStaticLibraries != null) {
                this.findSharedNonSystemLibrariesRecursive(p.usesStaticLibraries, p.usesStaticLibrariesVersions, collected, collectedNames);
            }
        }
    }

    private void findSharedNonSystemLibrariesRecursive(ArrayList<String> libs, int[] versions, ArrayList<PackageParser.Package> collected, Set<String> collectedNames) {
        int libNameCount = libs.size();
        for (int i = 0; i < libNameCount; ++i) {
            int version;
            String libName = libs.get(i);
            PackageParser.Package libPkg = this.findSharedNonSystemLibrary(libName, version = versions != null && versions.length == libNameCount ? versions[i] : -1);
            if (libPkg == null) continue;
            this.findSharedNonSystemLibrariesRecursive(libPkg, collected, collectedNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package findSharedNonSystemLibrary(String name, int version) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedLibraryEntry libEntry = this.getSharedLibraryEntryLPr(name, version);
            if (libEntry != null) {
                return this.mPackages.get(libEntry.apk);
            }
            return null;
        }
    }

    private SharedLibraryEntry getSharedLibraryEntryLPr(String name, int version) {
        SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.get(name);
        if (versionedLib == null) {
            return null;
        }
        return versionedLib.get(version);
    }

    private SharedLibraryEntry getLatestSharedLibraVersionLPr(PackageParser.Package pkg) {
        SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.get(pkg.staticSharedLibName);
        if (versionedLib == null) {
            return null;
        }
        int previousLibVersion = -1;
        int versionCount = versionedLib.size();
        for (int i = 0; i < versionCount; ++i) {
            int libVersion = versionedLib.keyAt(i);
            if (libVersion >= pkg.staticSharedLibVersion) continue;
            previousLibVersion = Math.max(previousLibVersion, libVersion);
        }
        if (previousLibVersion >= 0) {
            return versionedLib.get(previousLibVersion);
        }
        return null;
    }

    public void shutdown() {
        this.mPackageUsage.writeNow(this.mPackages);
        this.mCompilerStats.writeNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpProfiles(String packageName) {
        PackageParser.Package pkg;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
        }
        int callingUid = Binder.getCallingUid();
        if (callingUid != 2000 && callingUid != 0 && callingUid != pkg.applicationInfo.uid) {
            throw new SecurityException("dumpProfiles");
        }
        Object object = this.mInstallLock;
        synchronized (object) {
            Trace.traceBegin(262144L, "dump profiles");
            int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
            try {
                List<String> allCodePaths = pkg.getAllCodePathsExcludingResourceOnly();
                String codePaths = TextUtils.join((CharSequence)";", allCodePaths);
                this.mInstaller.dumpProfiles(sharedGid, packageName, codePaths);
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, "Failed to dump profiles", e);
            }
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceDexOpt(String packageName) {
        PackageParser.Package pkg;
        PackageManagerService.enforceSystemOrRoot("forceDexOpt");
        Object object = this.mPackages;
        synchronized (object) {
            pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            Trace.traceBegin(262144L, "dexopt");
            int res = this.performDexOptInternalWithDependenciesLI(pkg, false, PackageManagerServiceCompilerMapping.getDefaultCompilerFilter(), true);
            Trace.traceEnd(262144L);
            if (res != 1) {
                throw new IllegalStateException("Failed to dexopt: " + res);
            }
        }
    }

    private boolean verifyPackageUpdateLPr(PackageSetting oldPkg, PackageParser.Package newPkg) {
        if ((oldPkg.pkgFlags & 1) == 0) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package not in system partition");
            return false;
        }
        if (this.mPackages.get(oldPkg.name) != null) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package still exists");
            return false;
        }
        return true;
    }

    void removeCodePathLI(File codePath) {
        if (codePath.isDirectory()) {
            try {
                this.mInstaller.rmPackageDir(codePath.getAbsolutePath());
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, "Failed to remove code path", e);
            }
        } else {
            codePath.delete();
        }
    }

    private int[] resolveUserIds(int userId) {
        int[] nArray;
        if (userId == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        return nArray;
    }

    private void clearAppDataLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.clearAppDataLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.clearAppDataLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAppDataLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(pkg.packageName);
        }
        for (Object realUserId : (ArrayMap<String, PackageParser.Package>)this.resolveUserIds(userId)) {
            long ceDataInode = ps != null ? ps.getCeDataInode((int)realUserId) : 0L;
            try {
                this.mInstaller.clearAppData(pkg.volumeUuid, pkg.packageName, (int)realUserId, flags, ceDataInode);
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, String.valueOf(e));
            }
        }
    }

    private void destroyAppDataLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.destroyAppDataLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.destroyAppDataLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAppDataLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(pkg.packageName);
        }
        for (Object realUserId : (ArrayMap<String, PackageParser.Package>)this.resolveUserIds(userId)) {
            long ceDataInode = ps != null ? ps.getCeDataInode((int)realUserId) : 0L;
            try {
                this.mInstaller.destroyAppData(pkg.volumeUuid, pkg.packageName, (int)realUserId, flags, ceDataInode);
            }
            catch (Installer.InstallerException e) {
                Slog.w(TAG, String.valueOf(e));
            }
            this.mDexManager.notifyPackageDataDestroyed(pkg.packageName, userId);
        }
    }

    private void destroyAppProfilesLIF(PackageParser.Package pkg, int userId) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.destroyAppProfilesLeafLIF(pkg);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.destroyAppProfilesLeafLIF(pkg.childPackages.get(i));
        }
    }

    private void destroyAppProfilesLeafLIF(PackageParser.Package pkg) {
        try {
            this.mInstaller.destroyAppProfiles(pkg.packageName);
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, String.valueOf(e));
        }
    }

    private void clearAppProfilesLIF(PackageParser.Package pkg, int userId) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.clearAppProfilesLeafLIF(pkg);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.clearAppProfilesLeafLIF(pkg.childPackages.get(i));
        }
    }

    private void clearAppProfilesLeafLIF(PackageParser.Package pkg) {
        try {
            this.mInstaller.clearAppProfiles(pkg.packageName);
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, String.valueOf(e));
        }
    }

    private void setInstallAndUpdateTime(PackageParser.Package pkg, long firstInstallTime, long lastUpdateTime) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps != null) {
            ps.firstInstallTime = firstInstallTime;
            ps.lastUpdateTime = lastUpdateTime;
        }
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            ps = (PackageSetting)childPkg.mExtras;
            if (ps == null) continue;
            ps.firstInstallTime = firstInstallTime;
            ps.lastUpdateTime = lastUpdateTime;
        }
    }

    private void addSharedLibraryLPr(ArraySet<String> usesLibraryFiles, SharedLibraryEntry file, PackageParser.Package changingLib) {
        if (file.path != null) {
            usesLibraryFiles.add(file.path);
            return;
        }
        PackageParser.Package p = this.mPackages.get(file.apk);
        if (changingLib != null && changingLib.packageName.equals(file.apk) && (p == null || p.packageName.equals(changingLib.packageName))) {
            p = changingLib;
        }
        if (p != null) {
            usesLibraryFiles.addAll(p.getAllCodePaths());
            if (p.usesLibraryFiles != null) {
                Collections.addAll(usesLibraryFiles, p.usesLibraryFiles);
            }
        }
    }

    private void updateSharedLibrariesLPr(PackageParser.Package pkg, PackageParser.Package changingLib) throws PackageManagerException {
        if (pkg == null) {
            return;
        }
        ArraySet<String> usesLibraryFiles = null;
        if (pkg.usesLibraries != null) {
            usesLibraryFiles = this.addSharedLibrariesLPw(pkg.usesLibraries, null, null, pkg.packageName, changingLib, true, null);
        }
        if (pkg.usesStaticLibraries != null) {
            usesLibraryFiles = this.addSharedLibrariesLPw(pkg.usesStaticLibraries, pkg.usesStaticLibrariesVersions, pkg.usesStaticLibrariesCertDigests, pkg.packageName, changingLib, true, usesLibraryFiles);
        }
        if (pkg.usesOptionalLibraries != null) {
            usesLibraryFiles = this.addSharedLibrariesLPw(pkg.usesOptionalLibraries, null, null, pkg.packageName, changingLib, false, usesLibraryFiles);
        }
        pkg.usesLibraryFiles = !ArrayUtils.isEmpty(usesLibraryFiles) ? usesLibraryFiles.toArray(new String[usesLibraryFiles.size()]) : null;
    }

    private ArraySet<String> addSharedLibrariesLPw(List<String> requestedLibraries, int[] requiredVersions, String[] requiredCertDigests, String packageName, PackageParser.Package changingLib, boolean required, ArraySet<String> outUsedLibraries) throws PackageManagerException {
        int libCount = requestedLibraries.size();
        for (int i = 0; i < libCount; ++i) {
            int libVersion;
            String libName = requestedLibraries.get(i);
            SharedLibraryEntry libEntry = this.getSharedLibraryEntryLPr(libName, libVersion = requiredVersions != null ? requiredVersions[i] : -1);
            if (libEntry == null) {
                if (!required) continue;
                throw new PackageManagerException(-9, "Package " + packageName + " requires unavailable shared library " + libName + "; failing!");
            }
            if (requiredVersions != null && requiredCertDigests != null) {
                if (libEntry.info.getVersion() != requiredVersions[i]) {
                    throw new PackageManagerException(-9, "Package " + packageName + " requires unavailable static shared" + " library " + libName + " version " + libEntry.info.getVersion() + "; failing!");
                }
                PackageParser.Package libPkg = this.mPackages.get(libEntry.apk);
                if (libPkg == null) {
                    throw new PackageManagerException(-9, "Package " + packageName + " requires unavailable static shared" + " library; failing!");
                }
                String expectedCertDigest = requiredCertDigests[i];
                String libCertDigest = PackageUtils.computeCertSha256Digest(libPkg.mSignatures[0]);
                if (!libCertDigest.equalsIgnoreCase(expectedCertDigest)) {
                    throw new PackageManagerException(-9, "Package " + packageName + " requires differently signed" + " static shared library; failing!");
                }
            }
            if (outUsedLibraries == null) {
                outUsedLibraries = new ArraySet();
            }
            this.addSharedLibraryLPr(outUsedLibraries, libEntry, changingLib);
        }
        return outUsedLibraries;
    }

    private static boolean hasString(List<String> list, List<String> which) {
        if (list == null) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            for (int j = which.size() - 1; j >= 0; --j) {
                if (!which.get(j).equals(list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<PackageParser.Package> updateAllSharedLibrariesLPw(PackageParser.Package changingPkg) {
        ArrayList<PackageParser.Package> res = null;
        for (PackageParser.Package pkg : this.mPackages.values()) {
            if (!(changingPkg == null || PackageManagerService.hasString(pkg.usesLibraries, changingPkg.libraryNames) || PackageManagerService.hasString(pkg.usesOptionalLibraries, changingPkg.libraryNames) || ArrayUtils.contains(pkg.usesStaticLibraries, changingPkg.staticSharedLibName))) {
                return null;
            }
            if (res == null) {
                res = new ArrayList<PackageParser.Package>();
            }
            res.add(pkg);
            try {
                this.updateSharedLibrariesLPr(pkg, changingPkg);
            }
            catch (PackageManagerException e) {
                if (!pkg.isSystemApp() || pkg.isUpdatedSystemApp()) {
                    int flags = pkg.isUpdatedSystemApp() ? 1 : 0;
                    this.deletePackageLIF(pkg.packageName, null, true, sUserManager.getUserIds(), flags, null, true, null);
                }
                Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
            }
        }
        return res;
    }

    private static String deriveAbiOverride(String abiOverride, PackageSetting settings) {
        String cpuAbiOverride = null;
        if (INSTALL_PACKAGE_SUFFIX.equals(abiOverride)) {
            cpuAbiOverride = null;
        } else if (abiOverride != null) {
            cpuAbiOverride = abiOverride;
        } else if (settings != null) {
            cpuAbiOverride = settings.cpuAbiOverrideString;
        }
        return cpuAbiOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageTracedLI(PackageParser.Package pkg, int policyFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        PackageParser.Package scannedPkg;
        Trace.traceBegin(262144L, "scanPackage");
        if ((scanFlags & 0x2000) == 0) {
            if (pkg.childPackages != null && pkg.childPackages.size() > 0) {
                scanFlags |= 0x2000;
            }
        } else {
            scanFlags &= 0xFFFFDFFF;
        }
        try {
            scannedPkg = this.scanPackageLI(pkg, policyFlags, scanFlags, currentTime, user);
            int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageParser.Package childPkg = pkg.childPackages.get(i);
                this.scanPackageLI(childPkg, policyFlags, scanFlags, currentTime, user);
            }
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if ((scanFlags & 0x2000) != 0) {
            return this.scanPackageTracedLI(pkg, policyFlags, scanFlags, currentTime, user);
        }
        return scannedPkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(PackageParser.Package pkg, int policyFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        boolean success = false;
        try {
            PackageParser.Package res = this.scanPackageDirtyLI(pkg, policyFlags, scanFlags, currentTime, user);
            success = true;
            PackageParser.Package package_ = res;
            return package_;
        }
        finally {
            if (!success && (scanFlags & 0x100) != 0) {
                this.destroyAppDataLIF(pkg, -1, 3);
                this.destroyAppProfilesLIF(pkg, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean apkHasCode(String fileName) {
        StrictJarFile jarFile = null;
        try {
            jarFile = new StrictJarFile(fileName, false, false);
            boolean bl = jarFile.findEntry("classes.dex") != null;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private static void assertCodePolicy(PackageParser.Package pkg) throws PackageManagerException {
        boolean shouldHaveCode;
        boolean bl = shouldHaveCode = (pkg.applicationInfo.flags & 4) != 0;
        if (shouldHaveCode && !PackageManagerService.apkHasCode(pkg.baseCodePath)) {
            throw new PackageManagerException(-2, "Package " + pkg.baseCodePath + " code is missing");
        }
        if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
            for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                boolean splitShouldHaveCode;
                boolean bl2 = splitShouldHaveCode = (pkg.splitFlags[i] & 4) != 0;
                if (!splitShouldHaveCode || PackageManagerService.apkHasCode(pkg.splitCodePaths[i])) continue;
                throw new PackageManagerException(-2, "Package " + pkg.splitCodePaths[i] + " code is missing");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageDirtyLI(PackageParser.Package pkg, int policyFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        Object oldPkgSetting;
        this.applyPolicy(pkg, policyFlags);
        this.assertPackageIsValid(pkg, policyFlags, scanFlags);
        File scanFile = new File(pkg.codePath);
        File destCodeFile = new File(pkg.applicationInfo.getCodePath());
        File destResourceFile = new File(pkg.applicationInfo.getResourcePath());
        SharedUserSetting suid = null;
        PackageSetting pkgSetting = null;
        PackageSetting nonMutatedPs = null;
        String primaryCpuAbiFromSettings = null;
        String secondaryCpuAbiFromSettings = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedLibraryEntry libraryEntry;
            PackageSetting foundPs;
            if (pkg.mSharedUserId != null) {
                suid = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, 0, true);
            }
            PackageSetting origPackage = null;
            String realName = null;
            if (pkg.mOriginalPackages != null) {
                String renamed = this.mSettings.getRenamedPackageLPr(pkg.mRealPackage);
                if (pkg.mOriginalPackages.contains(renamed)) {
                    realName = pkg.mRealPackage;
                    if (!pkg.packageName.equals(renamed)) {
                        pkg.setPackageName(renamed);
                    }
                } else {
                    for (int i = pkg.mOriginalPackages.size() - 1; i >= 0; --i) {
                        origPackage = this.mSettings.getPackageLPr(pkg.mOriginalPackages.get(i));
                        if (origPackage == null) continue;
                        if (!this.verifyPackageUpdateLPr(origPackage, pkg)) {
                            origPackage = null;
                            continue;
                        }
                        if (origPackage.sharedUser == null || origPackage.sharedUser.name.equals(pkg.mSharedUserId)) break;
                        Slog.w(TAG, "Unable to migrate data from " + origPackage.name + " to " + pkg.packageName + ": old uid " + origPackage.sharedUser.name + " differs from " + pkg.mSharedUserId);
                        origPackage = null;
                    }
                }
            }
            if (this.mTransferedPackages.contains(pkg.packageName)) {
                Slog.w(TAG, "Package " + pkg.packageName + " was transferred to another, but its .apk remains");
            }
            if ((scanFlags & 0x2000) != 0 && (foundPs = this.mSettings.getPackageLPr(pkg.packageName)) != null) {
                nonMutatedPs = new PackageSetting(foundPs);
            }
            if ((scanFlags & 0x10000) == 0 && (foundPs = this.mSettings.getPackageLPr(pkg.packageName)) != null) {
                primaryCpuAbiFromSettings = foundPs.primaryCpuAbiString;
                secondaryCpuAbiFromSettings = foundPs.secondaryCpuAbiString;
            }
            if ((pkgSetting = this.mSettings.getPackageLPr(pkg.packageName)) != null && pkgSetting.sharedUser != suid) {
                PackageManagerService.reportSettingsProblem(5, "Package " + pkg.packageName + " shared user changed from " + (pkgSetting.sharedUser != null ? pkgSetting.sharedUser.name : "<nothing>") + " to " + (suid != null ? suid.name : "<nothing>") + "; replacing with new");
                pkgSetting = null;
            }
            oldPkgSetting = pkgSetting == null ? null : new PackageSetting(pkgSetting);
            PackageSetting disabledPkgSetting = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
            String[] usesStaticLibraries = null;
            if (pkg.usesStaticLibraries != null) {
                usesStaticLibraries = new String[pkg.usesStaticLibraries.size()];
                pkg.usesStaticLibraries.toArray(usesStaticLibraries);
            }
            if (pkgSetting == null) {
                String parentPackageName = pkg.parentPackage != null ? pkg.parentPackage.packageName : null;
                boolean instantApp = (scanFlags & 0x20000) != 0;
                pkgSetting = Settings.createNewSetting(pkg.packageName, origPackage, disabledPkgSetting, realName, suid, destCodeFile, destResourceFile, pkg.applicationInfo.nativeLibraryRootDir, pkg.applicationInfo.primaryCpuAbi, pkg.applicationInfo.secondaryCpuAbi, pkg.mVersionCode, pkg.applicationInfo.flags, pkg.applicationInfo.privateFlags, user, true, instantApp, parentPackageName, pkg.getChildPackageNames(), UserManagerService.getInstance(), usesStaticLibraries, pkg.usesStaticLibrariesVersions);
                if (origPackage != null) {
                    this.mSettings.addRenamedPackageLPw(pkg.packageName, origPackage.name);
                }
                this.mSettings.addUserToSettingLPw(pkgSetting);
            } else {
                Settings.updatePackageSetting(pkgSetting, disabledPkgSetting, suid, destCodeFile, pkg.applicationInfo.nativeLibraryDir, pkg.applicationInfo.primaryCpuAbi, pkg.applicationInfo.secondaryCpuAbi, pkg.applicationInfo.flags, pkg.applicationInfo.privateFlags, pkg.getChildPackageNames(), UserManagerService.getInstance(), usesStaticLibraries, pkg.usesStaticLibrariesVersions);
            }
            this.mSettings.writeUserRestrictionsLPw(pkgSetting, (PackageSetting)oldPkgSetting);
            if (pkgSetting.origPackage != null) {
                pkg.setPackageName(origPackage.name);
                String msg = "New package " + pkgSetting.realName + " renamed to replace old package " + pkgSetting.name;
                PackageManagerService.reportSettingsProblem(5, msg);
                if ((scanFlags & 0x2000) == 0) {
                    this.mTransferedPackages.add(origPackage.name);
                }
                pkgSetting.origPackage = null;
            }
            if ((scanFlags & 0x2000) == 0 && realName != null) {
                this.mTransferedPackages.add(pkg.packageName);
            }
            if (this.mSettings.isDisabledSystemPackageLPr(pkg.packageName)) {
                pkg.applicationInfo.flags |= 0x80;
            }
            if ((scanFlags & 0x40) == 0 && (policyFlags & 0x40) == 0) {
                this.updateSharedLibrariesLPr(pkg, null);
            }
            if (this.mFoundPolicyFile) {
                SELinuxMMAC.assignSeInfoValue(pkg);
            }
            pkg.applicationInfo.uid = pkgSetting.appId;
            pkg.mExtras = pkgSetting;
            PackageSetting signatureCheckPs = pkgSetting;
            if (pkg.applicationInfo.isStaticSharedLibrary() && (libraryEntry = this.getLatestSharedLibraVersionLPr(pkg)) != null) {
                signatureCheckPs = this.mSettings.getPackageLPr(libraryEntry.apk);
            }
            if (this.shouldCheckUpgradeKeySetLP(signatureCheckPs, scanFlags)) {
                if (this.checkUpgradeKeySetLP(signatureCheckPs, pkg)) {
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                } else {
                    if ((policyFlags & 0x40) == 0) {
                        throw new PackageManagerException(-7, "Package " + pkg.packageName + " upgrade keys do not match the " + "previously installed version");
                    }
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                    String msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
            } else {
                try {
                    this.verifySignaturesLP(signatureCheckPs, pkg);
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                }
                catch (PackageManagerException e) {
                    if ((policyFlags & 0x40) == 0) {
                        throw e;
                    }
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                    if (signatureCheckPs.sharedUser != null && PackageManagerService.compareSignatures(signatureCheckPs.sharedUser.signatures.mSignatures, pkg.mSignatures) != 0) {
                        throw new PackageManagerException(-104, "Signature mismatch for shared user: " + pkgSetting.sharedUser);
                    }
                    String msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
            }
            if ((scanFlags & 0x2000) == 0 && pkg.mAdoptPermissions != null) {
                for (int i = pkg.mAdoptPermissions.size() - 1; i >= 0; --i) {
                    String origName = pkg.mAdoptPermissions.get(i);
                    PackageSetting orig = this.mSettings.getPackageLPr(origName);
                    if (orig == null || !this.verifyPackageUpdateLPr(orig, pkg)) continue;
                    Slog.i(TAG, "Adopting permissions from " + origName + " to " + pkg.packageName);
                    this.mSettings.transferPermissionsLPw(origName, pkg.packageName);
                }
            }
        }
        pkg.applicationInfo.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.packageName, pkg.applicationInfo.processName);
        if (pkg != this.mPlatformPackage) {
            pkg.applicationInfo.initForUser(0);
        }
        String cpuAbiOverride = PackageManagerService.deriveAbiOverride(pkg.cpuAbiOverride, pkgSetting);
        if ((scanFlags & 0x10) == 0) {
            if ((scanFlags & 0x10000) != 0) {
                Trace.traceBegin(262144L, "derivePackageAbi");
                boolean extractNativeLibs = !pkg.isLibrary();
                PackageManagerService.derivePackageAbi(pkg, scanFile, cpuAbiOverride, extractNativeLibs, this.mAppLib32InstallDir);
                Trace.traceEnd(262144L);
                if (PackageManagerService.isSystemApp(pkg) && !pkg.isUpdatedSystemApp() && pkg.applicationInfo.primaryCpuAbi == null) {
                    PackageManagerService.setBundledAppAbisAndRoots(pkg, pkgSetting);
                    PackageManagerService.setNativeLibraryPaths(pkg, this.mAppLib32InstallDir);
                }
            } else {
                pkg.applicationInfo.primaryCpuAbi = primaryCpuAbiFromSettings;
                pkg.applicationInfo.secondaryCpuAbi = secondaryCpuAbiFromSettings;
                PackageManagerService.setNativeLibraryPaths(pkg, this.mAppLib32InstallDir);
            }
        } else {
            if ((scanFlags & 0x800) != 0) {
                pkg.applicationInfo.primaryCpuAbi = pkgSetting.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = pkgSetting.secondaryCpuAbiString;
            }
            PackageManagerService.setNativeLibraryPaths(pkg, this.mAppLib32InstallDir);
        }
        if (this.mPlatformPackage == pkg) {
            String string2 = pkg.applicationInfo.primaryCpuAbi = VMRuntime.getRuntime().is64Bit() ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        }
        if ((scanFlags & 2) == 0 && (scanFlags & 0x10) != 0 && cpuAbiOverride == null && pkgSetting.cpuAbiOverrideString != null) {
            Slog.w(TAG, "Ignoring persisted ABI override " + cpuAbiOverride + " for package " + pkg.packageName);
        }
        pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
        pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        pkgSetting.cpuAbiOverrideString = cpuAbiOverride;
        pkg.cpuAbiOverride = cpuAbiOverride;
        pkgSetting.legacyNativeLibraryPathString = pkg.applicationInfo.nativeLibraryRootDir;
        if ((scanFlags & 0x40) == 0 && pkgSetting.sharedUser != null) {
            this.adjustCpuAbisForSharedUserLPw(pkgSetting.sharedUser.packages, pkg);
        }
        if (this.mFactoryTest && pkg.requestedPermissions.contains("android.permission.FACTORY_TEST")) {
            pkg.applicationInfo.flags |= 0x10;
        }
        if (PackageManagerService.isSystemApp(pkg)) {
            pkgSetting.isOrphaned = true;
        }
        long scanFileTime = this.getLastModifiedTime(pkg, scanFile);
        if (currentTime != 0L) {
            if (pkgSetting.firstInstallTime == 0L) {
                pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = currentTime;
            } else if ((scanFlags & 0x20) != 0) {
                pkgSetting.lastUpdateTime = currentTime;
            }
        } else if (pkgSetting.firstInstallTime == 0L) {
            pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = scanFileTime;
        } else if ((policyFlags & 0x40) != 0 && scanFileTime != pkgSetting.timeStamp) {
            pkgSetting.lastUpdateTime = scanFileTime;
        }
        pkgSetting.setTimeStamp(scanFileTime);
        if ((scanFlags & 0x2000) != 0) {
            if (nonMutatedPs != null) {
                oldPkgSetting = this.mPackages;
                synchronized (oldPkgSetting) {
                    this.mSettings.mPackages.put(nonMutatedPs.name, nonMutatedPs);
                }
            }
        } else {
            int userId = user == null ? 0 : user.getIdentifier();
            this.commitPackageSettings(pkg, pkgSetting, user, scanFlags, (policyFlags & 2) != 0);
            if (pkgSetting.getInstantApp(userId)) {
                this.mInstantAppRegistry.addInstantAppLPw(userId, pkgSetting.appId);
            }
        }
        return pkg;
    }

    private void applyPolicy(PackageParser.Package pkg, int policyFlags) {
        if ((policyFlags & 1) != 0) {
            pkg.applicationInfo.flags |= 1;
            if (pkg.applicationInfo.isDirectBootAware()) {
                for (PackageParser.Service s : pkg.services) {
                    s.info.directBootAware = true;
                    s.info.encryptionAware = true;
                }
                for (PackageParser.Provider p : pkg.providers) {
                    p.info.directBootAware = true;
                    p.info.encryptionAware = true;
                }
                for (PackageParser.Activity a : pkg.activities) {
                    a.info.directBootAware = true;
                    a.info.encryptionAware = true;
                }
                for (PackageParser.Activity r : pkg.receivers) {
                    r.info.directBootAware = true;
                    r.info.encryptionAware = true;
                }
            }
        } else {
            pkg.coreApp = false;
            pkg.applicationInfo.privateFlags &= 0xFFFFFFDF;
            pkg.applicationInfo.privateFlags &= 0xFFFFFFBF;
        }
        boolean bl = pkg.mTrustedOverlay = (policyFlags & 0x200) != 0;
        if ((policyFlags & 0x80) != 0) {
            pkg.applicationInfo.privateFlags |= 8;
        }
        if (!PackageManagerService.isSystemApp(pkg)) {
            pkg.mOriginalPackages = null;
            pkg.mRealPackage = null;
            pkg.mAdoptPermissions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPackageIsValid(PackageParser.Package pkg, int policyFlags, int scanFlags) throws PackageManagerException {
        if ((policyFlags & 0x400) != 0) {
            PackageManagerService.assertCodePolicy(pkg);
        }
        if (pkg.applicationInfo.getCodePath() == null || pkg.applicationInfo.getResourcePath() == null) {
            throw new PackageManagerException(-2, "Code and resource paths haven't been set correctly");
        }
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        ksms.assertScannedPackageValid(pkg);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int i;
            if (pkg.packageName.equals(PLATFORM_PACKAGE_NAME) && this.mAndroidApplication != null) {
                Slog.w(TAG, "*************************************************");
                Slog.w(TAG, "Core android package being redefined.  Skipping.");
                Slog.w(TAG, " codePath=" + pkg.codePath);
                Slog.w(TAG, "*************************************************");
                throw new PackageManagerException(-5, "Core android package being redefined.  Skipping.");
            }
            if (this.mPackages.containsKey(pkg.packageName)) {
                throw new PackageManagerException(-5, "Application package " + pkg.packageName + " already installed.  Skipping duplicate.");
            }
            if (pkg.applicationInfo.isStaticSharedLibrary()) {
                if (this.mPackages.containsKey(pkg.manifestPackageName)) {
                    throw new PackageManagerException("Duplicate static shared lib provider package");
                }
                if (pkg.applicationInfo.targetSdkVersion < 26) {
                    throw new PackageManagerException("Packages declaring static-shared libs must target O SDK or higher");
                }
                if ((scanFlags & 0x20000) != 0) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot be instant apps");
                }
                if (!ArrayUtils.isEmpty(pkg.mOriginalPackages)) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot be renamed");
                }
                if (!ArrayUtils.isEmpty(pkg.childPackages)) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot have child packages");
                }
                if (!ArrayUtils.isEmpty(pkg.libraryNames)) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot declare dynamic libs");
                }
                if (pkg.mSharedUserId != null) {
                    throw new PackageManagerException("Packages declaring static-shared libs cannot declare shared users");
                }
                if (!pkg.activities.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare activities");
                }
                if (!pkg.services.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare services");
                }
                if (!pkg.providers.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare content providers");
                }
                if (!pkg.receivers.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare broadcast receivers");
                }
                if (!pkg.permissionGroups.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare permission groups");
                }
                if (!pkg.permissions.isEmpty()) {
                    throw new PackageManagerException("Static shared libs cannot declare permissions");
                }
                if (pkg.protectedBroadcasts != null) {
                    throw new PackageManagerException("Static shared libs cannot declare protected broadcasts");
                }
                if (pkg.mOverlayTarget != null) {
                    throw new PackageManagerException("Static shared libs cannot be overlay targets");
                }
                int minVersionCode = Integer.MIN_VALUE;
                int maxVersionCode = Integer.MAX_VALUE;
                SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.get(pkg.staticSharedLibName);
                if (versionedLib != null) {
                    int versionCount = versionedLib.size();
                    for (int i2 = 0; i2 < versionCount; ++i2) {
                        SharedLibraryInfo libInfo = versionedLib.valueAt((int)i2).info;
                        int libVersionCode = libInfo.getDeclaringPackage().getVersionCode();
                        if (libInfo.getVersion() < pkg.staticSharedLibVersion) {
                            minVersionCode = Math.max(minVersionCode, libVersionCode + 1);
                            continue;
                        }
                        if (libInfo.getVersion() > pkg.staticSharedLibVersion) {
                            maxVersionCode = Math.min(maxVersionCode, libVersionCode - 1);
                            continue;
                        }
                        minVersionCode = maxVersionCode = libVersionCode;
                        break;
                    }
                }
                if (pkg.mVersionCode < minVersionCode || pkg.mVersionCode > maxVersionCode) {
                    throw new PackageManagerException("Static shared lib version codes must be ordered as lib versions");
                }
            }
            if (pkg.childPackages != null && !pkg.childPackages.isEmpty()) {
                if ((policyFlags & 0x80) == 0) {
                    throw new PackageManagerException("Only privileged apps can add child packages. Ignoring package " + pkg.packageName);
                }
                int childCount = pkg.childPackages.size();
                for (i = 0; i < childCount; ++i) {
                    PackageParser.Package childPkg = pkg.childPackages.get(i);
                    if (!this.mSettings.hasOtherDisabledSystemPkgWithChildLPr(pkg.packageName, childPkg.packageName)) continue;
                    throw new PackageManagerException("Can't override child of another disabled app. Ignoring package " + pkg.packageName);
                }
            }
            if ((scanFlags & 0x400) != 0) {
                if (this.mExpectingBetter.containsKey(pkg.packageName)) {
                    PackageManagerService.logCriticalInfo(5, "Relax SCAN_REQUIRE_KNOWN requirement for package " + pkg.packageName);
                } else {
                    PackageSetting known = this.mSettings.getPackageLPr(pkg.packageName);
                    if (!(known == null || pkg.applicationInfo.getCodePath().equals(known.codePathString) && pkg.applicationInfo.getResourcePath().equals(known.resourcePathString))) {
                        throw new PackageManagerException(-23, "Application package " + pkg.packageName + " found at " + pkg.applicationInfo.getCodePath() + " but expected at " + known.codePathString + "; ignoring.");
                    }
                }
            }
            if ((scanFlags & 0x10) != 0) {
                int N = pkg.providers.size();
                for (i = 0; i < N; ++i) {
                    PackageParser.Provider p = pkg.providers.get(i);
                    if (p.info.authority == null) continue;
                    String[] names = p.info.authority.split(";");
                    for (int j = 0; j < names.length; ++j) {
                        if (!this.mProvidersByAuthority.containsKey(names[j])) continue;
                        PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                        String otherPackageName = other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?";
                        throw new PackageManagerException(-13, "Can't install because provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + ") is already used by " + otherPackageName);
                    }
                }
            }
        }
    }

    private boolean addSharedLibraryLPw(String path, String apk, String name, int version, int type, String declaringPackageName, int declaringVersionCode) {
        SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.get(name);
        if (versionedLib == null) {
            versionedLib = new SparseArray();
            this.mSharedLibraries.put(name, versionedLib);
            if (type == 2) {
                this.mStaticLibsByDeclaringPackage.put(declaringPackageName, versionedLib);
            }
        } else if (versionedLib.indexOfKey(version) >= 0) {
            return false;
        }
        SharedLibraryEntry libEntry = new SharedLibraryEntry(path, apk, name, version, type, declaringPackageName, declaringVersionCode);
        versionedLib.put(version, libEntry);
        return true;
    }

    private boolean removeSharedLibraryLPw(String name, int version) {
        SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.get(name);
        if (versionedLib == null) {
            return false;
        }
        int libIdx = versionedLib.indexOfKey(version);
        if (libIdx < 0) {
            return false;
        }
        SharedLibraryEntry libEntry = versionedLib.valueAt(libIdx);
        versionedLib.remove(version);
        if (versionedLib.size() <= 0) {
            this.mSharedLibraries.remove(name);
            if (libEntry.info.getType() == 2) {
                this.mStaticLibsByDeclaringPackage.remove(libEntry.info.getDeclaringPackage().getPackageName());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPackageSettings(PackageParser.Package pkg, PackageSetting pkgSetting, UserHandle user, int scanFlags, boolean chatty) throws PackageManagerException {
        String pkgName = pkg.packageName;
        if (this.mCustomResolverComponentName != null && this.mCustomResolverComponentName.getPackageName().equals(pkg.packageName)) {
            this.setUpCustomResolverActivity(pkg);
        }
        if (pkg.packageName.equals(PLATFORM_PACKAGE_NAME)) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if ((scanFlags & 0x2000) == 0) {
                    this.mPlatformPackage = pkg;
                    pkg.mVersionCode = this.mSdkVersion;
                    this.mAndroidApplication = pkg.applicationInfo;
                    if (!this.mResolverReplaced) {
                        this.mResolveActivity.applicationInfo = this.mAndroidApplication;
                        this.mResolveActivity.name = ResolverActivity.class.getName();
                        this.mResolveActivity.packageName = this.mAndroidApplication.packageName;
                        this.mResolveActivity.processName = "system:ui";
                        this.mResolveActivity.launchMode = 0;
                        this.mResolveActivity.documentLaunchMode = 3;
                        this.mResolveActivity.flags = 32;
                        this.mResolveActivity.theme = 16974374;
                        this.mResolveActivity.exported = true;
                        this.mResolveActivity.enabled = true;
                        this.mResolveActivity.resizeMode = 2;
                        this.mResolveActivity.configChanges = 3504;
                        this.mResolveInfo.activityInfo = this.mResolveActivity;
                        this.mResolveInfo.priority = 0;
                        this.mResolveInfo.preferredOrder = 0;
                        this.mResolveInfo.match = 0;
                        this.mResolveComponentName = new ComponentName(this.mAndroidApplication.packageName, this.mResolveActivity.name);
                    }
                }
            }
        }
        ArrayList<PackageParser.Package> clientLibPkgs = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean hasStaticSharedLibs = false;
            if (pkg.staticSharedLibName != null) {
                if (this.addSharedLibraryLPw(null, pkg.packageName, pkg.staticSharedLibName, pkg.staticSharedLibVersion, 2, pkg.manifestPackageName, pkg.mVersionCode)) {
                    hasStaticSharedLibs = true;
                } else {
                    Slog.w(TAG, "Package " + pkg.packageName + " library " + pkg.staticSharedLibName + " already exists; skipping");
                }
            }
            if (!hasStaticSharedLibs && (pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
                for (int i = 0; i < pkg.libraryNames.size(); ++i) {
                    String name = pkg.libraryNames.get(i);
                    boolean allowed = false;
                    if (pkg.isUpdatedSystemApp()) {
                        PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                        if (sysPs.pkg != null && sysPs.pkg.libraryNames != null) {
                            for (int j = 0; j < sysPs.pkg.libraryNames.size(); ++j) {
                                if (!name.equals(sysPs.pkg.libraryNames.get(j))) continue;
                                allowed = true;
                                break;
                            }
                        }
                    } else {
                        allowed = true;
                    }
                    if (allowed) {
                        if (this.addSharedLibraryLPw(null, pkg.packageName, name, -1, 1, pkg.packageName, pkg.mVersionCode)) continue;
                        Slog.w(TAG, "Package " + pkg.packageName + " library " + name + " already exists; skipping");
                        continue;
                    }
                    Slog.w(TAG, "Package " + pkg.packageName + " declares lib " + name + " that is not declared on system image; skipping");
                }
                if ((scanFlags & 0x40) == 0) {
                    clientLibPkgs = this.updateAllSharedLibrariesLPw(pkg);
                }
            }
        }
        if ((scanFlags & 0x40) == 0 && (scanFlags & 0x4000) == 0 && (scanFlags & 0x8000) == 0) {
            this.checkPackageFrozen(pkgName);
        }
        if (clientLibPkgs != null) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = (PackageParser.Package)clientLibPkgs.get(i);
                this.killApplication(clientPkg.applicationInfo.packageName, clientPkg.applicationInfo.uid, "update lib");
            }
        }
        Trace.traceBegin(262144L, "updateSettings");
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            int i;
            this.mSettings.insertPackageSettingLPw(pkgSetting, pkg);
            this.mPackages.put(pkg.applicationInfo.packageName, pkg);
            Iterator<PackageCleanItem> iter = this.mSettings.mPackagesToBeCleaned.iterator();
            while (iter.hasNext()) {
                PackageCleanItem item = iter.next();
                if (!pkgName.equals(item.packageName)) continue;
                iter.remove();
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            ksms.addScannedPackageLPw(pkg);
            int N = pkg.providers.size();
            StringBuilder r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Provider p = pkg.providers.get(i);
                p.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, p.info.processName);
                this.mProviders.addProvider(p);
                p.syncable = p.info.isSyncable;
                if (p.info.authority != null) {
                    String[] names = p.info.authority.split(";");
                    p.info.authority = null;
                    for (int j = 0; j < names.length; ++j) {
                        if (j == 1 && p.syncable) {
                            p = new PackageParser.Provider(p);
                            p.syncable = false;
                        }
                        if (!this.mProvidersByAuthority.containsKey(names[j])) {
                            this.mProvidersByAuthority.put(names[j], p);
                            if (p.info.authority == null) {
                                p.info.authority = names[j];
                                continue;
                            }
                            p.info.authority = p.info.authority + ";" + names[j];
                            continue;
                        }
                        PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                        Slog.w(TAG, "Skipping provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + "): name already used by " + (other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?"));
                    }
                }
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(p.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.services.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Service s = pkg.services.get(i);
                s.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, s.info.processName);
                this.mServices.addService(s);
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(s.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.receivers.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Activity a = pkg.receivers.get(i);
                a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName);
                this.mReceivers.addActivity(a, "receiver");
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.activities.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Activity a = pkg.activities.get(i);
                a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName);
                this.mActivities.addActivity(a, "activity");
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissionGroups.size();
            r = null;
            for (i = 0; i < N; ++i) {
                String curPackageName;
                PackageParser.PermissionGroup pg = pkg.permissionGroups.get(i);
                PackageParser.PermissionGroup cur = this.mPermissionGroups.get(pg.info.name);
                String string2 = curPackageName = cur == null ? null : cur.info.packageName;
                if ((scanFlags & 0x20000) != 0) {
                    Slog.w(TAG, "Permission group " + pg.info.name + " from package " + pg.info.packageName + " ignored: instant apps cannot define new permission groups.");
                    continue;
                }
                boolean isPackageUpdate = pg.info.packageName.equals(curPackageName);
                if (cur == null || isPackageUpdate) {
                    this.mPermissionGroups.put(pg.info.name, pg);
                    if (!chatty) continue;
                    if (r == null) {
                        r = new StringBuilder(256);
                    } else {
                        r.append(' ');
                    }
                    if (isPackageUpdate) {
                        r.append("UPD:");
                    }
                    r.append(pg.info.name);
                    continue;
                }
                Slog.w(TAG, "Permission group " + pg.info.name + " from package " + pg.info.packageName + " ignored: original from " + cur.info.packageName);
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append("DUP:");
                r.append(pg.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissions.size();
            r = null;
            for (i = 0; i < N; ++i) {
                ArrayMap<String, BasePermission> permissionMap;
                BasePermission bp;
                PackageParser.Permission p = pkg.permissions.get(i);
                if ((scanFlags & 0x20000) != 0) {
                    Slog.w(TAG, "Permission " + p.info.name + " from package " + p.info.packageName + " ignored: instant apps cannot define new permissions.");
                    continue;
                }
                p.info.flags &= 0xBFFFFFFF;
                if (pkg.applicationInfo.targetSdkVersion > 22) {
                    p.group = this.mPermissionGroups.get(p.info.group);
                }
                if ((bp = (permissionMap = p.tree ? this.mSettings.mPermissionTrees : this.mSettings.mPermissions).get(p.info.name)) != null && !Objects.equals(bp.sourcePackage, p.info.packageName)) {
                    boolean currentOwnerIsSystem;
                    boolean bl = currentOwnerIsSystem = bp.perm != null && PackageManagerService.isSystemApp(bp.perm.owner);
                    if (PackageManagerService.isSystemApp(p.owner)) {
                        if (bp.type == 1 && bp.perm == null) {
                            bp.packageSetting = pkgSetting;
                            bp.perm = p;
                            bp.uid = pkg.applicationInfo.uid;
                            bp.sourcePackage = p.info.packageName;
                            p.info.flags |= 0x40000000;
                        } else if (!currentOwnerIsSystem) {
                            String msg = "New decl " + p.owner + " of permission  " + p.info.name + " is system; overriding " + bp.sourcePackage;
                            PackageManagerService.reportSettingsProblem(5, msg);
                            bp = null;
                        }
                    }
                }
                if (bp == null) {
                    bp = new BasePermission(p.info.name, p.info.packageName, 0);
                    permissionMap.put(p.info.name, bp);
                }
                if (bp.perm == null) {
                    if (bp.sourcePackage == null || bp.sourcePackage.equals(p.info.packageName)) {
                        BasePermission tree = this.findPermissionTreeLP(p.info.name);
                        if (tree == null || tree.sourcePackage.equals(p.info.packageName)) {
                            bp.packageSetting = pkgSetting;
                            bp.perm = p;
                            bp.uid = pkg.applicationInfo.uid;
                            bp.sourcePackage = p.info.packageName;
                            p.info.flags |= 0x40000000;
                            if (chatty) {
                                if (r == null) {
                                    r = new StringBuilder(256);
                                } else {
                                    r.append(' ');
                                }
                                r.append(p.info.name);
                            }
                        } else {
                            Slog.w(TAG, "Permission " + p.info.name + " from package " + p.info.packageName + " ignored: base tree " + tree.name + " is from package " + tree.sourcePackage);
                        }
                    } else {
                        Slog.w(TAG, "Permission " + p.info.name + " from package " + p.info.packageName + " ignored: original from " + bp.sourcePackage);
                    }
                } else if (chatty) {
                    if (r == null) {
                        r = new StringBuilder(256);
                    } else {
                        r.append(' ');
                    }
                    r.append("DUP:");
                    r.append(p.info.name);
                }
                if (bp.perm != p) continue;
                bp.protectionLevel = p.info.protectionLevel;
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.instrumentation.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Instrumentation a = pkg.instrumentation.get(i);
                a.info.packageName = pkg.applicationInfo.packageName;
                a.info.sourceDir = pkg.applicationInfo.sourceDir;
                a.info.publicSourceDir = pkg.applicationInfo.publicSourceDir;
                a.info.splitNames = pkg.splitNames;
                a.info.splitSourceDirs = pkg.applicationInfo.splitSourceDirs;
                a.info.splitPublicSourceDirs = pkg.applicationInfo.splitPublicSourceDirs;
                a.info.splitDependencies = pkg.applicationInfo.splitDependencies;
                a.info.dataDir = pkg.applicationInfo.dataDir;
                a.info.deviceProtectedDataDir = pkg.applicationInfo.deviceProtectedDataDir;
                a.info.credentialProtectedDataDir = pkg.applicationInfo.credentialProtectedDataDir;
                a.info.nativeLibraryDir = pkg.applicationInfo.nativeLibraryDir;
                a.info.secondaryNativeLibraryDir = pkg.applicationInfo.secondaryNativeLibraryDir;
                this.mInstrumentation.put(a.getComponentName(), a);
                if (!chatty) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            if (pkg.protectedBroadcasts != null) {
                N = pkg.protectedBroadcasts.size();
                for (i = 0; i < N; ++i) {
                    this.mProtectedBroadcasts.add(pkg.protectedBroadcasts.get(i));
                }
            }
        }
        Trace.traceEnd(262144L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void derivePackageAbi(PackageParser.Package pkg, File scanFile, String cpuAbiOverride, boolean extractLibs, File appLib32InstallDir) throws PackageManagerException {
        PackageManagerService.setNativeLibraryPaths(pkg, appLib32InstallDir);
        if (pkg.isForwardLocked() || pkg.applicationInfo.isExternalAsec() || PackageManagerService.isSystemApp(pkg) && !pkg.isUpdatedSystemApp()) {
            extractLibs = false;
        }
        String nativeLibraryRootStr = pkg.applicationInfo.nativeLibraryRootDir;
        boolean useIsaSpecificSubdirs = pkg.applicationInfo.nativeLibraryRootRequiresIsa;
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(pkg);
            File nativeLibraryRoot = new File(nativeLibraryRootStr);
            pkg.applicationInfo.primaryCpuAbi = null;
            pkg.applicationInfo.secondaryCpuAbi = null;
            if (PackageManagerService.isMultiArch(pkg.applicationInfo)) {
                if (pkg.cpuAbiOverride != null && !INSTALL_PACKAGE_SUFFIX.equals(pkg.cpuAbiOverride)) {
                    Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
                }
                int abi32 = -114;
                int abi64 = -114;
                if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                    if (extractLibs) {
                        Trace.traceBegin(262144L, "copyNativeBinaries");
                        abi32 = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_32_BIT_ABIS, useIsaSpecificSubdirs);
                    } else {
                        Trace.traceBegin(262144L, "findSupportedAbi");
                        abi32 = NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_32_BIT_ABIS);
                    }
                    Trace.traceEnd(262144L);
                }
                if (abi32 >= 0 && pkg.isLibrary() && extractLibs) {
                    throw new PackageManagerException(-110, "Shared library native lib extraction not supported");
                }
                PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 32 bit native libs for multiarch app.", abi32);
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                    if (extractLibs) {
                        Trace.traceBegin(262144L, "copyNativeBinaries");
                        abi64 = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_64_BIT_ABIS, useIsaSpecificSubdirs);
                    } else {
                        Trace.traceBegin(262144L, "findSupportedAbi");
                        abi64 = NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_64_BIT_ABIS);
                    }
                    Trace.traceEnd(262144L);
                }
                PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 64 bit native libs for multiarch app.", abi64);
                if (abi64 >= 0) {
                    if (extractLibs && pkg.isLibrary()) {
                        throw new PackageManagerException(-110, "Shared library native lib extraction not supported");
                    }
                    pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[abi64];
                }
                if (abi32 >= 0) {
                    String abi = Build.SUPPORTED_32_BIT_ABIS[abi32];
                    if (abi64 >= 0) {
                        if (pkg.use32bitAbi) {
                            pkg.applicationInfo.secondaryCpuAbi = pkg.applicationInfo.primaryCpuAbi;
                            pkg.applicationInfo.primaryCpuAbi = abi;
                        } else {
                            pkg.applicationInfo.secondaryCpuAbi = abi;
                        }
                    } else {
                        pkg.applicationInfo.primaryCpuAbi = abi;
                    }
                }
            } else {
                int copyRet;
                String[] stringArray;
                if (cpuAbiOverride != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = cpuAbiOverride;
                } else {
                    stringArray = Build.SUPPORTED_ABIS;
                }
                String[] abiList = stringArray;
                boolean needsRenderScriptOverride = false;
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                    abiList = Build.SUPPORTED_32_BIT_ABIS;
                    needsRenderScriptOverride = true;
                }
                if (extractLibs) {
                    Trace.traceBegin(262144L, "copyNativeBinaries");
                    copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, abiList, useIsaSpecificSubdirs);
                } else {
                    Trace.traceBegin(262144L, "findSupportedAbi");
                    copyRet = NativeLibraryHelper.findSupportedAbi(handle, abiList);
                }
                Trace.traceEnd(262144L);
                if (copyRet < 0 && copyRet != -114) {
                    throw new PackageManagerException(-110, "Error unpackaging native libs for app, errorCode=" + copyRet);
                }
                if (copyRet >= 0) {
                    if (pkg.isLibrary()) {
                        throw new PackageManagerException(-110, "Shared library with native libs must be multiarch");
                    }
                    pkg.applicationInfo.primaryCpuAbi = abiList[copyRet];
                } else if (copyRet == -114 && cpuAbiOverride != null) {
                    pkg.applicationInfo.primaryCpuAbi = cpuAbiOverride;
                } else if (needsRenderScriptOverride) {
                    pkg.applicationInfo.primaryCpuAbi = abiList[0];
                }
            }
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Unable to get canonical file " + ioe.toString());
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
        PackageManagerService.setNativeLibraryPaths(pkg, appLib32InstallDir);
    }

    private void adjustCpuAbisForSharedUserLPw(Set<PackageSetting> packagesForUser, PackageParser.Package scannedPackage) {
        String requiredInstructionSet = null;
        if (scannedPackage != null && scannedPackage.applicationInfo.primaryCpuAbi != null) {
            requiredInstructionSet = VMRuntime.getInstructionSet(scannedPackage.applicationInfo.primaryCpuAbi);
        }
        PackageSetting requirer = null;
        for (PackageSetting ps : packagesForUser) {
            if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString == null) continue;
            String instructionSet = VMRuntime.getInstructionSet(ps.primaryCpuAbiString);
            if (requiredInstructionSet != null && !instructionSet.equals(requiredInstructionSet)) {
                String errorMessage = "Instruction set mismatch, " + (requirer == null ? "[caller]" : requirer) + " requires " + requiredInstructionSet + " whereas " + ps + " requires " + instructionSet;
                Slog.w(TAG, errorMessage);
            }
            if (requiredInstructionSet != null) continue;
            requiredInstructionSet = instructionSet;
            requirer = ps;
        }
        if (requiredInstructionSet != null) {
            String adjustedAbi;
            if (requirer != null) {
                adjustedAbi = requirer.primaryCpuAbiString;
                if (scannedPackage != null) {
                    scannedPackage.applicationInfo.primaryCpuAbi = adjustedAbi;
                }
            } else {
                adjustedAbi = scannedPackage.applicationInfo.primaryCpuAbi;
            }
            for (PackageSetting ps : packagesForUser) {
                if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString != null) continue;
                ps.primaryCpuAbiString = adjustedAbi;
                if (ps.pkg == null || ps.pkg.applicationInfo == null || TextUtils.equals(adjustedAbi, ps.pkg.applicationInfo.primaryCpuAbi)) continue;
                ps.pkg.applicationInfo.primaryCpuAbi = adjustedAbi;
                try {
                    this.mInstaller.rmdex(ps.codePathString, InstructionSets.getDexCodeInstructionSet(InstructionSets.getPreferredInstructionSet()));
                }
                catch (Installer.InstallerException installerException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpCustomResolverActivity(PackageParser.Package pkg) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mResolverReplaced = true;
            this.mResolveActivity.applicationInfo = pkg.applicationInfo;
            this.mResolveActivity.name = this.mCustomResolverComponentName.getClassName();
            this.mResolveActivity.packageName = pkg.applicationInfo.packageName;
            this.mResolveActivity.processName = pkg.applicationInfo.packageName;
            this.mResolveActivity.launchMode = 0;
            this.mResolveActivity.flags = 288;
            this.mResolveActivity.theme = 0;
            this.mResolveActivity.exported = true;
            this.mResolveActivity.enabled = true;
            this.mResolveInfo.activityInfo = this.mResolveActivity;
            this.mResolveInfo.priority = 0;
            this.mResolveInfo.preferredOrder = 0;
            this.mResolveInfo.match = 0;
            this.mResolveComponentName = this.mCustomResolverComponentName;
            Slog.i(TAG, "Replacing default ResolverActivity with custom activity: " + this.mResolveComponentName);
        }
    }

    private void setUpInstantAppInstallerActivityLP(ActivityInfo installerActivity) {
        if (installerActivity == null) {
            if (DEBUG_EPHEMERAL) {
                Slog.d(TAG, "Clear ephemeral installer activity");
            }
            this.mInstantAppInstallerActivity = null;
            return;
        }
        if (DEBUG_EPHEMERAL) {
            Slog.d(TAG, "Set ephemeral installer activity: " + installerActivity.getComponentName());
        }
        this.mInstantAppInstallerActivity = installerActivity;
        this.mInstantAppInstallerActivity.flags |= 0x120;
        this.mInstantAppInstallerActivity.exported = true;
        this.mInstantAppInstallerActivity.enabled = true;
        this.mInstantAppInstallerInfo.activityInfo = this.mInstantAppInstallerActivity;
        this.mInstantAppInstallerInfo.priority = 0;
        this.mInstantAppInstallerInfo.preferredOrder = 1;
        this.mInstantAppInstallerInfo.isDefault = true;
        this.mInstantAppInstallerInfo.match = 0x588000;
    }

    private static String calculateBundledApkRoot(String codePathString) {
        File codeRoot;
        File codePath = new File(codePathString);
        if (FileUtils.contains(Environment.getRootDirectory(), codePath)) {
            codeRoot = Environment.getRootDirectory();
        } else if (FileUtils.contains(Environment.getOemDirectory(), codePath)) {
            codeRoot = Environment.getOemDirectory();
        } else if (FileUtils.contains(Environment.getVendorDirectory(), codePath)) {
            codeRoot = Environment.getVendorDirectory();
        } else {
            try {
                File tmp;
                File f = codePath.getCanonicalFile();
                File parent = f.getParentFile();
                while ((tmp = parent.getParentFile()) != null) {
                    f = parent;
                    parent = tmp;
                }
                codeRoot = f;
                Slog.w(TAG, "Unrecognized code path " + codePath + " - using " + codeRoot);
            }
            catch (IOException e) {
                Slog.w(TAG, "Can't canonicalize code path " + codePath);
                return Environment.getRootDirectory().getPath();
            }
        }
        return codeRoot.getPath();
    }

    private static void setNativeLibraryPaths(PackageParser.Package pkg, File appLib32InstallDir) {
        ApplicationInfo info = pkg.applicationInfo;
        String codePath = pkg.codePath;
        File codeFile = new File(codePath);
        boolean bundledApp = info.isSystemApp() && !info.isUpdatedSystemApp();
        boolean asecApp = info.isForwardLocked() || info.isExternalAsec();
        info.nativeLibraryRootDir = null;
        info.nativeLibraryRootRequiresIsa = false;
        info.nativeLibraryDir = null;
        info.secondaryNativeLibraryDir = null;
        if (PackageParser.isApkFile(codeFile)) {
            if (bundledApp) {
                String apkRoot = PackageManagerService.calculateBundledApkRoot(info.sourceDir);
                boolean is64Bit = VMRuntime.is64BitInstructionSet(InstructionSets.getPrimaryInstructionSet(info));
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                String libDir = is64Bit ? "lib64" : "lib";
                info.nativeLibraryRootDir = Environment.buildPath(new File(apkRoot), libDir, apkName).getAbsolutePath();
                if (info.secondaryCpuAbi != null) {
                    String secondaryLibDir = is64Bit ? "lib" : "lib64";
                    info.secondaryNativeLibraryDir = Environment.buildPath(new File(apkRoot), secondaryLibDir, apkName).getAbsolutePath();
                }
            } else if (asecApp) {
                info.nativeLibraryRootDir = new File(codeFile.getParentFile(), "lib").getAbsolutePath();
            } else {
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                info.nativeLibraryRootDir = new File(appLib32InstallDir, apkName).getAbsolutePath();
            }
            info.nativeLibraryRootRequiresIsa = false;
            info.nativeLibraryDir = info.nativeLibraryRootDir;
        } else {
            info.nativeLibraryRootDir = new File(codeFile, "lib").getAbsolutePath();
            info.nativeLibraryRootRequiresIsa = true;
            info.nativeLibraryDir = new File(info.nativeLibraryRootDir, InstructionSets.getPrimaryInstructionSet(info)).getAbsolutePath();
            if (info.secondaryCpuAbi != null) {
                info.secondaryNativeLibraryDir = new File(info.nativeLibraryRootDir, VMRuntime.getInstructionSet(info.secondaryCpuAbi)).getAbsolutePath();
            }
        }
    }

    private static void setBundledAppAbisAndRoots(PackageParser.Package pkg, PackageSetting pkgSetting) {
        String apkName = PackageManagerService.deriveCodePathName(pkg.applicationInfo.getCodePath());
        String apkRoot = PackageManagerService.calculateBundledApkRoot(pkg.applicationInfo.sourceDir);
        PackageManagerService.setBundledAppAbi(pkg, apkRoot, apkName);
        if (pkgSetting != null) {
            pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
            pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        }
    }

    private static void setBundledAppAbi(PackageParser.Package pkg, String apkRoot, String apkName) {
        boolean has32BitLibs;
        boolean has64BitLibs;
        File codeFile = new File(pkg.codePath);
        if (PackageParser.isApkFile(codeFile)) {
            has64BitLibs = new File(apkRoot, new File("lib64", apkName).getPath()).exists();
            has32BitLibs = new File(apkRoot, new File("lib", apkName).getPath()).exists();
        } else {
            String isa;
            File rootDir = new File(codeFile, "lib");
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_64_BIT_ABIS[0]);
                has64BitLibs = new File(rootDir, isa).exists();
            } else {
                has64BitLibs = false;
            }
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_32_BIT_ABIS[0]);
                has32BitLibs = new File(rootDir, isa).exists();
            } else {
                has32BitLibs = false;
            }
        }
        if (has64BitLibs && !has32BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && !has64BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && has64BitLibs) {
            if ((pkg.applicationInfo.flags & Integer.MIN_VALUE) == 0) {
                Slog.e(TAG, "Package " + pkg + " has multiple bundled libs, but is not multiarch.");
            }
            if (VMRuntime.is64BitInstructionSet(InstructionSets.getPreferredInstructionSet())) {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            } else {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            }
        } else {
            pkg.applicationInfo.primaryCpuAbi = null;
            pkg.applicationInfo.secondaryCpuAbi = null;
        }
    }

    private void killApplication(String pkgName, int appId, String reason) {
        this.killApplication(pkgName, appId, -1, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killApplication(String pkgName, int appId, int userId, String reason) {
        long token = Binder.clearCallingIdentity();
        try {
            IActivityManager am = ActivityManager.getService();
            if (am != null) {
                try {
                    am.killApplication(pkgName, appId, userId, reason);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void removePackageLI(PackageParser.Package pkg, boolean chatty) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps != null) {
            this.removePackageLI(ps, chatty);
        }
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            ps = (PackageSetting)childPkg.mExtras;
            if (ps == null) continue;
            this.removePackageLI(ps, chatty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePackageLI(PackageSetting ps, boolean chatty) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPackages.remove(ps.name);
            PackageParser.Package pkg = ps.pkg;
            if (pkg != null) {
                this.cleanPackageDataStructuresLILPw(pkg, chatty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstalledPackageLI(PackageParser.Package pkg, boolean chatty) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPackages.remove(pkg.applicationInfo.packageName);
            this.cleanPackageDataStructuresLILPw(pkg, chatty);
            int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageParser.Package childPkg = pkg.childPackages.get(i);
                this.mPackages.remove(childPkg.applicationInfo.packageName);
                this.cleanPackageDataStructuresLILPw(childPkg, chatty);
            }
        }
    }

    void cleanPackageDataStructuresLILPw(PackageParser.Package pkg, boolean chatty) {
        BasePermission bp;
        PackageParser.Component a;
        PackageParser.Component p;
        int i;
        int N = pkg.providers.size();
        StringBuilder r = null;
        for (i = 0; i < N; ++i) {
            p = pkg.providers.get(i);
            this.mProviders.removeProvider((PackageParser.Provider)p);
            if (p.info.authority == null) continue;
            String[] names = p.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                if (this.mProvidersByAuthority.get(names[j]) != p) continue;
                this.mProvidersByAuthority.remove(names[j]);
            }
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.services.size();
        r = null;
        for (i = 0; i < N; ++i) {
            PackageParser.Service s = pkg.services.get(i);
            this.mServices.removeService(s);
            if (!chatty) continue;
            if (r == null) {
                r = new StringBuilder(256);
            } else {
                r.append(' ');
            }
            r.append(s.info.name);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.receivers.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.receivers.get(i);
            this.mReceivers.removeActivity((PackageParser.Activity)a, "receiver");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.activities.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.activities.get(i);
            this.mActivities.removeActivity((PackageParser.Activity)a, "activity");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.permissions.size();
        r = null;
        for (i = 0; i < N; ++i) {
            ArraySet<String> appOpPkgs;
            p = pkg.permissions.get(i);
            bp = this.mSettings.mPermissions.get(((PackageParser.Permission)p).info.name);
            if (bp == null) {
                bp = this.mSettings.mPermissionTrees.get(((PackageParser.Permission)p).info.name);
            }
            if (bp != null && bp.perm == p) {
                bp.perm = null;
            }
            if ((((PackageParser.Permission)p).info.protectionLevel & 0x40) == 0 || (appOpPkgs = this.mAppOpPermissionPackages.get(((PackageParser.Permission)p).info.name)) == null) continue;
            appOpPkgs.remove(pkg.packageName);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.requestedPermissions.size();
        r = null;
        for (i = 0; i < N; ++i) {
            ArraySet<String> appOpPkgs;
            String perm = pkg.requestedPermissions.get(i);
            bp = this.mSettings.mPermissions.get(perm);
            if (bp == null || (bp.protectionLevel & 0x40) == 0 || (appOpPkgs = this.mAppOpPermissionPackages.get(perm)) == null) continue;
            appOpPkgs.remove(pkg.packageName);
            if (!appOpPkgs.isEmpty()) continue;
            this.mAppOpPermissionPackages.remove(perm);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.instrumentation.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.instrumentation.get(i);
            this.mInstrumentation.remove(a.getComponentName());
        }
        if (r != null) {
            // empty if block
        }
        r = null;
        if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
            for (i = 0; i < pkg.libraryNames.size(); ++i) {
                String name = pkg.libraryNames.get(i);
                if (!this.removeSharedLibraryLPw(name, 0)) continue;
            }
        }
        r = null;
        if (pkg.staticSharedLibName == null || this.removeSharedLibraryLPw(pkg.staticSharedLibName, pkg.staticSharedLibVersion)) {
            // empty if block
        }
        if (r != null) {
            // empty if block
        }
    }

    private static boolean hasPermission(PackageParser.Package pkgInfo, String perm) {
        for (int i = pkgInfo.permissions.size() - 1; i >= 0; --i) {
            if (!pkgInfo.permissions.get((int)i).info.name.equals(perm)) continue;
            return true;
        }
        return false;
    }

    private void updatePermissionsLPw(PackageParser.Package pkg, int flags) {
        this.updatePermissionsLPw(pkg.packageName, pkg, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            this.updatePermissionsLPw(childPkg.packageName, childPkg, flags);
        }
    }

    private void updatePermissionsLPw(String changingPkg, PackageParser.Package pkgInfo, int flags) {
        String volumeUuid = pkgInfo != null ? this.getVolumeUuidForPackage(pkgInfo) : null;
        this.updatePermissionsLPw(changingPkg, pkgInfo, volumeUuid, flags);
    }

    private void updatePermissionsLPw(String changingPkg, PackageParser.Package pkgInfo, String replaceVolumeUuid, int flags) {
        Object bp;
        Iterator<BasePermission> it = this.mSettings.mPermissionTrees.values().iterator();
        while (it.hasNext()) {
            bp = it.next();
            if (((BasePermission)bp).packageSetting == null) {
                ((BasePermission)bp).packageSetting = this.mSettings.mPackages.get(((BasePermission)bp).sourcePackage);
            }
            if (((BasePermission)bp).packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission tree: " + ((BasePermission)bp).name + " from package " + ((BasePermission)bp).sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(((BasePermission)bp).sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, ((BasePermission)bp).name)) continue;
            Slog.i(TAG, "Removing old permission tree: " + ((BasePermission)bp).name + " from package " + ((BasePermission)bp).sourcePackage);
            flags |= 1;
            it.remove();
        }
        it = this.mSettings.mPermissions.values().iterator();
        while (it.hasNext()) {
            BasePermission tree;
            bp = it.next();
            if (((BasePermission)bp).type == 2 && ((BasePermission)bp).packageSetting == null && ((BasePermission)bp).pendingInfo != null && (tree = this.findPermissionTreeLP(((BasePermission)bp).name)) != null && tree.perm != null) {
                ((BasePermission)bp).packageSetting = tree.packageSetting;
                ((BasePermission)bp).perm = new PackageParser.Permission(tree.perm.owner, new PermissionInfo(((BasePermission)bp).pendingInfo));
                ((BasePermission)bp).perm.info.packageName = tree.perm.info.packageName;
                ((BasePermission)bp).perm.info.name = ((BasePermission)bp).name;
                ((BasePermission)bp).uid = tree.uid;
            }
            if (((BasePermission)bp).packageSetting == null) {
                ((BasePermission)bp).packageSetting = this.mSettings.mPackages.get(((BasePermission)bp).sourcePackage);
            }
            if (((BasePermission)bp).packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission: " + ((BasePermission)bp).name + " from package " + ((BasePermission)bp).sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(((BasePermission)bp).sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, ((BasePermission)bp).name)) continue;
            Slog.i(TAG, "Removing old permission: " + ((BasePermission)bp).name + " from package " + ((BasePermission)bp).sourcePackage);
            flags |= 1;
            it.remove();
        }
        Trace.traceBegin(262144L, "grantPermissions");
        if ((flags & 1) != 0) {
            for (PackageParser.Package pkg : this.mPackages.values()) {
                if (pkg == pkgInfo) continue;
                String volumeUuid = this.getVolumeUuidForPackage(pkg);
                boolean replace = (flags & 4) != 0 && Objects.equals(replaceVolumeUuid, volumeUuid);
                this.grantPermissionsLPw(pkg, replace, changingPkg);
            }
        }
        if (pkgInfo != null) {
            String volumeUuid = this.getVolumeUuidForPackage(pkgInfo);
            boolean replace = (flags & 2) != 0 && Objects.equals(replaceVolumeUuid, volumeUuid);
            this.grantPermissionsLPw(pkgInfo, replace, changingPkg);
        }
        Trace.traceEnd(262144L);
    }

    private void grantPermissionsLPw(PackageParser.Package pkg, boolean replace, String packageOfInterest) {
        PermissionsState permissionsState;
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        PermissionsState origPermissions = permissionsState = ps.getPermissionsState();
        int[] currentUserIds = UserManagerService.getInstance().getUserIds();
        boolean runtimePermissionsRevoked = false;
        int[] changedRuntimePermissionUserIds = EMPTY_INT_ARRAY;
        boolean changedInstallPermission = false;
        if (replace) {
            ps.installPermissionsFixed = false;
            if (!ps.isSharedUser()) {
                origPermissions = new PermissionsState(permissionsState);
                permissionsState.reset();
            } else {
                changedRuntimePermissionUserIds = this.revokeUnusedSharedUserPermissionsLPw(ps.sharedUser, UserManagerService.getInstance().getUserIds());
                if (!ArrayUtils.isEmpty(changedRuntimePermissionUserIds)) {
                    runtimePermissionsRevoked = true;
                }
            }
        }
        permissionsState.setGlobalGids(this.mGlobalGids);
        int N = pkg.requestedPermissions.size();
        block10: for (int i = 0; i < N; ++i) {
            boolean appSupportsRuntimePermissions;
            String name = pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            boolean bl = appSupportsRuntimePermissions = pkg.applicationInfo.targetSdkVersion >= 23;
            if (bp == null || bp.packageSetting == null) {
                if (packageOfInterest == null || !packageOfInterest.equals(pkg.packageName)) continue;
                continue;
            }
            if (pkg.applicationInfo.isInstantApp() && !bp.isInstant() || bp.isRuntimeOnly() && !appSupportsRuntimePermissions) continue;
            String perm = bp.name;
            boolean allowedSig = false;
            int grant = 1;
            if ((bp.protectionLevel & 0x40) != 0) {
                ArraySet<String> pkgs = this.mAppOpPermissionPackages.get(bp.name);
                if (pkgs == null) {
                    pkgs = new ArraySet();
                    this.mAppOpPermissionPackages.put(bp.name, pkgs);
                }
                pkgs.add(pkg.packageName);
            }
            int level = bp.protectionLevel & 0xF;
            switch (level) {
                case 0: {
                    grant = 2;
                    break;
                }
                case 1: {
                    if (!appSupportsRuntimePermissions && !this.mPermissionReviewRequired) {
                        grant = 2;
                        break;
                    }
                    if (origPermissions.hasInstallPermission(bp.name)) {
                        grant = 4;
                        break;
                    }
                    if (this.mPromoteSystemApps && PackageManagerService.isSystemApp(ps) && this.mExistingSystemPackages.contains(ps.name)) {
                        grant = 4;
                        break;
                    }
                    grant = 3;
                    break;
                }
                case 2: {
                    allowedSig = this.grantSignaturePermission(perm, pkg, bp, origPermissions);
                    if (!allowedSig) break;
                    grant = 2;
                }
            }
            if (grant != 1) {
                if (!(PackageManagerService.isSystemApp(ps) || !ps.installPermissionsFixed || allowedSig || origPermissions.hasInstallPermission(perm) || this.isNewPlatformPermissionForPackage(perm, pkg))) {
                    grant = 1;
                }
                switch (grant) {
                    case 2: {
                        for (int userId : UserManagerService.getInstance().getUserIds()) {
                            if (origPermissions.getRuntimePermissionState(bp.name, userId) == null) continue;
                            origPermissions.revokeRuntimePermission(bp, userId);
                            origPermissions.updatePermissionFlags(bp, userId, 255, 0);
                            changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                        }
                        if (permissionsState.grantInstallPermission(bp) == -1) continue block10;
                        changedInstallPermission = true;
                        break;
                    }
                    case 3: {
                        for (int userId : UserManagerService.getInstance().getUserIds()) {
                            int flags;
                            PermissionsState.PermissionState permissionState = origPermissions.getRuntimePermissionState(bp.name, userId);
                            int n = flags = permissionState != null ? permissionState.getFlags() : 0;
                            if (origPermissions.hasRuntimePermission(bp.name, userId)) {
                                boolean revokeOnUpgrade;
                                boolean bl2 = revokeOnUpgrade = (flags & 8) != 0;
                                if (revokeOnUpgrade) {
                                    flags &= 0xFFFFFFF7;
                                    changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                                }
                                if (!(this.mPermissionReviewRequired && revokeOnUpgrade || permissionsState.grantRuntimePermission(bp, userId) != -1)) {
                                    changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                                }
                                if (this.mPermissionReviewRequired && appSupportsRuntimePermissions && (flags & 0x40) != 0) {
                                    flags &= 0xFFFFFFBF;
                                    changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                                }
                            } else if (this.mPermissionReviewRequired && !appSupportsRuntimePermissions) {
                                if (PLATFORM_PACKAGE_NAME.equals(bp.sourcePackage) && (flags & 0x40) == 0) {
                                    flags |= 0x40;
                                    changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                                }
                                if (permissionsState.grantRuntimePermission(bp, userId) != -1) {
                                    changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                                }
                            }
                            permissionsState.updatePermissionFlags(bp, userId, flags, flags);
                        }
                        continue block10;
                    }
                    case 4: {
                        int flags;
                        PermissionsState.PermissionState permissionState = origPermissions.getInstallPermissionState(bp.name);
                        int n = flags = permissionState != null ? permissionState.getFlags() : 0;
                        if (origPermissions.revokeInstallPermission(bp) != -1) {
                            origPermissions.updatePermissionFlags(bp, -1, 255, 0);
                            changedInstallPermission = true;
                        }
                        if ((flags & 8) != 0) continue block10;
                        for (int userId : currentUserIds) {
                            if (permissionsState.grantRuntimePermission(bp, userId) == -1) continue;
                            permissionsState.updatePermissionFlags(bp, userId, flags, flags);
                            changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                        }
                        continue block10;
                    }
                    default: {
                        if (packageOfInterest == null || !packageOfInterest.equals(pkg.packageName)) continue block10;
                        break;
                    }
                }
                continue;
            }
            if (permissionsState.revokeInstallPermission(bp) != -1) {
                permissionsState.updatePermissionFlags(bp, -1, 255, 0);
                changedInstallPermission = true;
                Slog.i(TAG, "Un-granting permission " + perm + " from package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
                continue;
            }
            if ((bp.protectionLevel & 0x40) != 0) continue;
        }
        if ((changedInstallPermission || replace) && !ps.installPermissionsFixed && !PackageManagerService.isSystemApp(ps) || PackageManagerService.isUpdatedSystemApp(ps)) {
            ps.installPermissionsFixed = true;
        }
        for (int userId : changedRuntimePermissionUserIds) {
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, runtimePermissionsRevoked);
        }
    }

    private boolean isNewPlatformPermissionForPackage(String perm, PackageParser.Package pkg) {
        boolean allowed = false;
        for (PackageParser.NewPermissionInfo npi : PackageParser.NEW_PERMISSIONS) {
            if (!npi.name.equals(perm) || pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) continue;
            allowed = true;
            Log.i(TAG, "Auto-granting " + perm + " to old pkg " + pkg.packageName);
            break;
        }
        return allowed;
    }

    private boolean grantSignaturePermission(String perm, PackageParser.Package pkg, BasePermission bp, PermissionsState origPermissions) {
        boolean allowed;
        boolean privilegedPermission = (bp.protectionLevel & 0x10) != 0;
        boolean privappPermissionsDisable = RoSystemProperties.CONTROL_PRIVAPP_PERMISSIONS_DISABLE;
        boolean platformPermission = PLATFORM_PACKAGE_NAME.equals(bp.sourcePackage);
        boolean platformPackage = PLATFORM_PACKAGE_NAME.equals(pkg.packageName);
        if (!privappPermissionsDisable && privilegedPermission && pkg.isPrivilegedApp() && !platformPackage && platformPermission) {
            boolean whitelisted;
            ArraySet<String> wlPermissions = SystemConfig.getInstance().getPrivAppPermissions(pkg.packageName);
            boolean bl = whitelisted = wlPermissions != null && wlPermissions.contains(perm);
            if (!whitelisted) {
                Slog.w(TAG, "Privileged permission " + perm + " for package " + pkg.packageName + " - not in privapp-permissions whitelist");
                if (!this.mSystemReady && !pkg.isUpdatedSystemApp()) {
                    if (this.mPrivappPermissionsViolations == null) {
                        this.mPrivappPermissionsViolations = new ArraySet();
                    }
                    this.mPrivappPermissionsViolations.add(pkg.packageName + ": " + perm);
                }
                if (RoSystemProperties.CONTROL_PRIVAPP_PERMISSIONS_ENFORCE) {
                    return false;
                }
            }
        }
        boolean bl = allowed = PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0 || PackageManagerService.compareSignatures(this.mPlatformPackage.mSignatures, pkg.mSignatures) == 0;
        if (!allowed && privilegedPermission && PackageManagerService.isSystemApp(pkg)) {
            if (pkg.isUpdatedSystemApp()) {
                PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                if (sysPs != null && sysPs.getPermissionsState().hasInstallPermission(perm)) {
                    if (sysPs.isPrivileged()) {
                        allowed = true;
                    }
                } else {
                    PackageSetting disabledSysParentPs;
                    if (sysPs != null && sysPs.pkg != null && sysPs.isPrivileged()) {
                        for (int j = 0; j < sysPs.pkg.requestedPermissions.size(); ++j) {
                            if (!perm.equals(sysPs.pkg.requestedPermissions.get(j))) continue;
                            allowed = true;
                            break;
                        }
                    }
                    if (pkg.parentPackage != null && (disabledSysParentPs = this.mSettings.getDisabledSystemPkgLPr(pkg.parentPackage.packageName)) != null && disabledSysParentPs.pkg != null && disabledSysParentPs.isPrivileged()) {
                        if (this.isPackageRequestingPermission(disabledSysParentPs.pkg, perm)) {
                            allowed = true;
                        } else if (disabledSysParentPs.pkg.childPackages != null) {
                            int count = disabledSysParentPs.pkg.childPackages.size();
                            for (int i = 0; i < count; ++i) {
                                PackageParser.Package disabledSysChildPkg = disabledSysParentPs.pkg.childPackages.get(i);
                                if (!this.isPackageRequestingPermission(disabledSysChildPkg, perm)) continue;
                                allowed = true;
                                break;
                            }
                        }
                    }
                }
            } else {
                allowed = PackageManagerService.isPrivilegedApp(pkg);
            }
        }
        if (!allowed) {
            if (!allowed && (bp.protectionLevel & 0x80) != 0 && pkg.applicationInfo.targetSdkVersion < 23) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x100) != 0 && pkg.packageName.equals(this.mRequiredInstallerPackage)) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x200) != 0 && pkg.packageName.equals(this.mRequiredVerifierPackage)) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x400) != 0 && PackageManagerService.isSystemApp(pkg)) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x20) != 0) {
                allowed = origPermissions.hasInstallPermission(perm);
            }
            if (!allowed && (bp.protectionLevel & 0x800) != 0 && pkg.packageName.equals(this.mSetupWizardPackage)) {
                allowed = true;
            }
        }
        return allowed;
    }

    private boolean isPackageRequestingPermission(PackageParser.Package pkg, String permission2) {
        int permCount = pkg.requestedPermissions.size();
        for (int j = 0; j < permCount; ++j) {
            String requestedPermission = pkg.requestedPermissions.get(j);
            if (!permission2.equals(requestedPermission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sendPackageBroadcast(final String action, final String pkg, final Bundle extras, final int flags, final String targetPkg, final IIntentReceiver finishedReceiver, final int[] userIds) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    IActivityManager am = ActivityManager.getService();
                    if (am == null) {
                        return;
                    }
                    int[] resolvedUserIds = userIds == null ? am.getRunningUserIds() : userIds;
                    for (int id2 : resolvedUserIds) {
                        int uid;
                        Intent intent = new Intent(action, pkg != null ? Uri.fromParts(PackageManagerService.PACKAGE_SCHEME, pkg, null) : null);
                        if (extras != null) {
                            intent.putExtras(extras);
                        }
                        if (targetPkg != null) {
                            intent.setPackage(targetPkg);
                        }
                        if ((uid = intent.getIntExtra("android.intent.extra.UID", -1)) > 0 && UserHandle.getUserId(uid) != id2) {
                            uid = UserHandle.getUid(id2, UserHandle.getAppId(uid));
                            intent.putExtra("android.intent.extra.UID", uid);
                        }
                        intent.putExtra("android.intent.extra.user_handle", id2);
                        intent.addFlags(0x4000000 | flags);
                        am.broadcastIntent(null, intent, null, finishedReceiver, 0, null, null, null, -1, null, finishedReceiver != null, false, id2);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    private boolean isExternalMediaAvailable() {
        return this.mMediaMounted || Environment.isExternalStorageEmulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageCleanItem nextPackageToClean(PackageCleanItem lastPackage) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (!this.isExternalMediaAvailable()) {
                return null;
            }
            ArrayList<PackageCleanItem> pkgs = this.mSettings.mPackagesToBeCleaned;
            if (lastPackage != null) {
                pkgs.remove(lastPackage);
            }
            if (pkgs.size() > 0) {
                return pkgs.get(0);
            }
        }
        return null;
    }

    void schedulePackageCleaning(String packageName, int userId, boolean andCode) {
        Message msg = this.mHandler.obtainMessage(7, userId, andCode ? 1 : 0, packageName);
        if (this.mSystemReady) {
            msg.sendToTarget();
        } else {
            if (this.mPostSystemReadyMessages == null) {
                this.mPostSystemReadyMessages = new ArrayList();
            }
            this.mPostSystemReadyMessages.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleaningPackages() {
        if (!this.isExternalMediaAvailable()) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mSettings.mPackagesToBeCleaned.isEmpty()) {
                return;
            }
        }
        Intent intent = new Intent("android.content.pm.CLEAN_EXTERNAL_STORAGE");
        intent.setComponent(DEFAULT_CONTAINER_COMPONENT);
        IActivityManager am = ActivityManager.getService();
        if (am != null) {
            int dcsUid = -1;
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                if (!this.mDefaultContainerWhitelisted) {
                    this.mDefaultContainerWhitelisted = true;
                    PackageSetting ps = this.mSettings.mPackages.get(DEFAULT_CONTAINER_PACKAGE);
                    dcsUid = UserHandle.getUid(0, ps.appId);
                }
            }
            try {
                if (dcsUid > 0) {
                    am.backgroundWhitelistUid(dcsUid);
                }
                am.startService(null, intent, null, false, this.mContext.getOpPackageName(), 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void installPackageAsUser(String originPath, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, true, "installPackageAsUser");
        if (this.isUserRestricted(userId, "no_install_apps")) {
            try {
                if (observer != null) {
                    observer.onPackageInstalled("", -111, null, null);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        if (callingUid == 2000 || callingUid == 0) {
            installFlags |= 0x20;
        } else {
            installFlags &= 0xFFFFFFDF;
            installFlags &= 0xFFFFFFBF;
        }
        UserHandle user = (installFlags & 0x40) != 0 ? UserHandle.ALL : new UserHandle(userId);
        if ((installFlags & 0x100) != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.INSTALL_GRANT_RUNTIME_PERMISSIONS") == -1) {
            throw new SecurityException("You need the android.permission.INSTALL_GRANT_RUNTIME_PERMISSIONS permission to use the PackageManager.INSTALL_GRANT_RUNTIME_PERMISSIONS flag");
        }
        if ((installFlags & 1) != 0 || (installFlags & 8) != 0) {
            throw new IllegalArgumentException("New installs into ASEC containers no longer supported");
        }
        File originFile = new File(originPath);
        OriginInfo origin = OriginInfo.fromUntrustedFile(originFile);
        Message msg = this.mHandler.obtainMessage(5);
        VerificationInfo verificationInfo = new VerificationInfo(null, null, -1, callingUid);
        InstallParams params = new InstallParams(origin, null, observer, installFlags, installerPackageName, null, verificationInfo, user, null, null, null, 0);
        params.setTraceMethod("installAsUser").setTraceCookie(System.identityHashCode(params));
        msg.obj = params;
        Trace.asyncTraceBegin(262144L, "installAsUser", System.identityHashCode(msg.obj));
        Trace.asyncTraceBegin(262144L, "queueInstall", System.identityHashCode(msg.obj));
        this.mHandler.sendMessage(msg);
    }

    private int fixUpInstallReason(String installerPackageName, int installerUid, int installReason) {
        if (this.checkUidPermission("android.permission.INSTALL_PACKAGES", installerUid) == 0) {
            return installReason;
        }
        IDevicePolicyManager dpm = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
        if (dpm != null) {
            ComponentName owner = null;
            try {
                owner = dpm.getDeviceOwnerComponent(true);
                if (owner == null) {
                    owner = dpm.getProfileOwner(UserHandle.getUserId(installerUid));
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (owner != null && owner.getPackageName().equals(installerPackageName)) {
                return 1;
            }
        }
        if (installReason == 1) {
            return 0;
        }
        return installReason;
    }

    void installStage(String packageName, File stagedDir, String stagedCid, IPackageInstallObserver2 observer, PackageInstaller.SessionParams sessionParams, String installerPackageName, int installerUid, UserHandle user, Certificate[][] certificates) {
        if (DEBUG_EPHEMERAL && (sessionParams.installFlags & 0x800) != 0) {
            Slog.d(TAG, "Ephemeral install of " + packageName);
        }
        VerificationInfo verificationInfo = new VerificationInfo(sessionParams.originatingUri, sessionParams.referrerUri, sessionParams.originatingUid, installerUid);
        OriginInfo origin = stagedDir != null ? OriginInfo.fromStagedFile(stagedDir) : OriginInfo.fromStagedContainer(stagedCid);
        Message msg = this.mHandler.obtainMessage(5);
        int installReason = this.fixUpInstallReason(installerPackageName, installerUid, sessionParams.installReason);
        InstallParams params = new InstallParams(origin, null, observer, sessionParams.installFlags, installerPackageName, sessionParams.volumeUuid, verificationInfo, user, sessionParams.abiOverride, sessionParams.grantedRuntimePermissions, certificates, installReason);
        params.setTraceMethod("installStage").setTraceCookie(System.identityHashCode(params));
        msg.obj = params;
        Trace.asyncTraceBegin(262144L, "installStage", System.identityHashCode(msg.obj));
        Trace.asyncTraceBegin(262144L, "queueInstall", System.identityHashCode(msg.obj));
        this.mHandler.sendMessage(msg);
    }

    private void sendPackageAddedForUser(String packageName, PackageSetting pkgSetting, int userId) {
        boolean isSystem = PackageManagerService.isSystemApp(pkgSetting) || PackageManagerService.isUpdatedSystemApp(pkgSetting);
        this.sendPackageAddedForNewUsers(packageName, isSystem, pkgSetting.appId, userId);
        PackageInstaller.SessionInfo info = new PackageInstaller.SessionInfo();
        info.installReason = pkgSetting.getInstallReason(userId);
        info.appPackageName = packageName;
        this.sendSessionCommitBroadcast(info, userId);
    }

    @Override
    public void sendPackageAddedForNewUsers(String packageName, boolean isSystem, int appId, int ... userIds) {
        if (ArrayUtils.isEmpty(userIds)) {
            return;
        }
        Bundle extras = new Bundle(1);
        extras.putInt("android.intent.extra.UID", UserHandle.getUid(userIds[0], appId));
        this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, 0, null, null, userIds);
        if (isSystem) {
            this.mHandler.post(() -> {
                for (int userId : userIds) {
                    this.sendBootCompletedBroadcastToSystemApp(packageName, userId);
                }
            });
        }
    }

    private void sendBootCompletedBroadcastToSystemApp(String packageName, int userId) {
        if (!this.mUserManagerInternal.isUserRunning(userId)) {
            return;
        }
        IActivityManager am = ActivityManager.getService();
        try {
            Intent lockedBcIntent = new Intent("android.intent.action.LOCKED_BOOT_COMPLETED").setPackage(packageName);
            String[] requiredPermissions = new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"};
            am.broadcastIntent(null, lockedBcIntent, null, null, 0, null, null, requiredPermissions, -1, null, false, false, userId);
            if (this.mUserManagerInternal.isUserUnlockingOrUnlocked(userId)) {
                Intent bcIntent = new Intent("android.intent.action.BOOT_COMPLETED").setPackage(packageName);
                am.broadcastIntent(null, bcIntent, null, null, 0, null, null, requiredPermissions, -1, null, false, false, userId);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, int userId) {
        PackageSetting pkgSetting;
        boolean sendRemoved;
        boolean sendAdded;
        long callingId;
        int callingUid;
        block21: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
            callingUid = Binder.getCallingUid();
            this.enforceCrossUserPermission(callingUid, userId, true, true, "setApplicationHiddenSetting for user " + userId);
            if (hidden && this.isPackageDeviceAdmin(packageName, userId)) {
                Slog.w(TAG, "Not hiding package " + packageName + ": has active device admin");
                return false;
            }
            callingId = Binder.clearCallingIdentity();
            sendAdded = false;
            sendRemoved = false;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            // MONITORENTER : arrayMap
            pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting != null) break block21;
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (this.filterAppAccessLPr(pkgSetting, callingUid, userId)) {
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (PLATFORM_PACKAGE_NAME.equals(packageName)) {
            Slog.w(TAG, "Cannot hide package: android");
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        PackageParser.Package pkg = this.mPackages.get(packageName);
        if (pkg != null && pkg.staticSharedLibName != null) {
            Slog.w(TAG, "Cannot hide package: " + packageName + " providing static shared library: " + pkg.staticSharedLibName);
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (hidden && !UserHandle.isSameApp(callingUid, pkgSetting.appId) && this.mProtectedPackages.isPackageStateProtected(userId, packageName)) {
            Slog.w(TAG, "Not hiding protected package: " + packageName);
            boolean bl = false;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        try {
            if (pkgSetting.getHidden(userId) != hidden) {
                pkgSetting.setHidden(hidden, userId);
                this.mSettings.writePackageRestrictionsLPr(userId);
                if (hidden) {
                    sendRemoved = true;
                } else {
                    sendAdded = true;
                }
            }
            // MONITOREXIT : arrayMap
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
                boolean bl = true;
                return bl;
            }
            if (!sendRemoved) return false;
            this.killApplication(packageName, UserHandle.getUid(userId, pkgSetting.appId), "hiding pkg");
            this.sendApplicationHiddenForUser(packageName, pkgSetting, userId);
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private void sendApplicationHiddenForUser(String packageName, PackageSetting pkgSetting, int userId) {
        PackageRemovedInfo info = new PackageRemovedInfo(this);
        info.removedPackage = packageName;
        info.installerPackageName = pkgSetting.installerPackageName;
        info.removedUsers = new int[]{userId};
        info.broadcastUsers = new int[]{userId};
        info.uid = UserHandle.getUid(userId, pkgSetting.appId);
        info.sendPackageRemovedBroadcasts(true);
    }

    private void sendPackagesSuspendedForUser(String[] pkgList, int userId, boolean suspended) {
        if (pkgList.length > 0) {
            Bundle extras = new Bundle(1);
            extras.putStringArray("android.intent.extra.changed_package_list", pkgList);
            this.sendPackageBroadcast(suspended ? "android.intent.action.PACKAGES_SUSPENDED" : "android.intent.action.PACKAGES_UNSUSPENDED", null, extras, 0x40000000, null, null, new int[]{userId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean getApplicationHiddenSettingAsUser(String packageName, int userId) {
        PackageSetting ps;
        long callingId;
        int callingUid;
        block8: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
            callingUid = Binder.getCallingUid();
            this.enforceCrossUserPermission(callingUid, userId, true, false, "getApplicationHidden for user " + userId);
            callingId = Binder.clearCallingIdentity();
            try {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                // MONITORENTER : arrayMap
                ps = this.mSettings.mPackages.get(packageName);
                if (ps != null) break block8;
                bl = true;
                // MONITOREXIT : arrayMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(callingId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        if (this.filterAppAccessLPr(ps, callingUid, userId)) {
            boolean bl = true;
            // MONITOREXIT : arrayMap
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        boolean bl = ps.getHidden(userId);
        // MONITOREXIT : arrayMap
        Binder.restoreCallingIdentity(callingId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int installExistingPackageAsUser(String packageName, int userId, int installFlags, int installReason) {
        block23: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
            callingUid = Binder.getCallingUid();
            this.enforceCrossUserPermission(callingUid, userId, true, true, "installExistingPackage for user " + userId);
            if (this.isUserRestricted(userId, "no_install_apps")) {
                return -111;
            }
            callingId = Binder.clearCallingIdentity();
            installed = false;
            instantApp = (installFlags & 2048) != 0;
            fullApp = (installFlags & 16384) != 0;
            var11_10 = this.mPackages;
            synchronized (var11_10) {
                pkgSetting = this.mSettings.mPackages.get(packageName);
                if (pkgSetting != null) ** break block21
                var13_12 = -3;
            }
            Binder.restoreCallingIdentity(callingId);
            return var13_12;
            {
                if (this.canViewInstantApps(callingUid, UserHandle.getUserId(callingUid))) ** break block22
                installAllowed = false;
                for (int checkUserId : PackageManagerService.sUserManager.getUserIds()) {
                    v0 = installAllowed = pkgSetting.getInstantApp(checkUserId) == false;
                    if (installAllowed) break;
                }
                if (installAllowed) ** break block22
                var14_15 = -3;
            }
            Binder.restoreCallingIdentity(callingId);
            return var14_15;
            {
                if (!pkgSetting.getInstalled(userId)) {
                    pkgSetting.setInstalled(true, userId);
                    pkgSetting.setHidden(false, userId);
                    pkgSetting.setInstallReason(installReason, userId);
                    this.mSettings.writePackageRestrictionsLPr(userId);
                    this.mSettings.writeKernelMappingLPr(pkgSetting);
                    installed = true;
                } else if (fullApp && pkgSetting.getInstantApp(userId)) {
                    installed = true;
                }
                this.setInstantAppForUser(pkgSetting, userId, instantApp, fullApp);
                // MONITOREXIT @DISABLED, blocks:[3, 4, 7] lbl48 : MonitorExitStatement: MONITOREXIT : var11_10
                {
                    catch (Throwable var18_19) {
                        throw var18_19;
                    }
                }
                if (!installed) break block23;
                if (pkgSetting.pkg != null) {
                    var11_10 = this.mInstallLock;
                    synchronized (var11_10) {
                        this.prepareAppDataAfterInstallLIF(pkgSetting.pkg);
                    }
                }
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
                var11_10 = this.mPackages;
                synchronized (var11_10) {
                    this.updateSequenceNumberLP(pkgSetting, new int[]{userId});
                    break block23;
                }
            }
            {
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }
        return 1;
    }

    void setInstantAppForUser(PackageSetting pkgSetting, int userId, boolean instantApp, boolean fullApp) {
        block5: {
            block3: {
                block4: {
                    if (!instantApp && !fullApp) {
                        return;
                    }
                    if (userId == -1) break block3;
                    if (!instantApp || pkgSetting.getInstantApp(userId)) break block4;
                    pkgSetting.setInstantApp(true, userId);
                    break block5;
                }
                if (!fullApp || !pkgSetting.getInstantApp(userId)) break block5;
                pkgSetting.setInstantApp(false, userId);
                break block5;
            }
            for (int currentUserId : sUserManager.getUserIds()) {
                if (instantApp && !pkgSetting.getInstantApp(currentUserId)) {
                    pkgSetting.setInstantApp(true, currentUserId);
                    continue;
                }
                if (!fullApp || !pkgSetting.getInstantApp(currentUserId)) continue;
                pkgSetting.setInstantApp(false, currentUserId);
            }
        }
    }

    boolean isUserRestricted(int userId, String restrictionKey) {
        Bundle restrictions = sUserManager.getUserRestrictions(userId);
        if (restrictions.getBoolean(restrictionKey, false)) {
            Log.w(TAG, "User is restricted: " + restrictionKey);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, true, "setPackagesSuspended for user " + userId);
        if (ArrayUtils.isEmpty(packageNames)) {
            return packageNames;
        }
        ArrayList<String> changedPackages = new ArrayList<String>(packageNames.length);
        ArrayList<String> unactionedPackages = new ArrayList<String>(packageNames.length);
        long callingId = Binder.clearCallingIdentity();
        try {
            for (int i = 0; i < packageNames.length; ++i) {
                int appId;
                String packageName = packageNames[i];
                boolean changed = false;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
                    if (pkgSetting == null || this.filterAppAccessLPr(pkgSetting, callingUid, userId)) {
                        Slog.w(TAG, "Could not find package setting for package \"" + packageName + "\". Skipping suspending/un-suspending.");
                        unactionedPackages.add(packageName);
                        continue;
                    }
                    appId = pkgSetting.appId;
                    if (pkgSetting.getSuspended(userId) != suspended) {
                        if (!this.canSuspendPackageForUserLocked(packageName, userId)) {
                            unactionedPackages.add(packageName);
                            continue;
                        }
                        pkgSetting.setSuspended(suspended, userId);
                        this.mSettings.writePackageRestrictionsLPr(userId);
                        changed = true;
                        changedPackages.add(packageName);
                    }
                }
                if (!changed || !suspended) continue;
                this.killApplication(packageName, UserHandle.getUid(userId, appId), "suspending package");
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        if (!changedPackages.isEmpty()) {
            this.sendPackagesSuspendedForUser(changedPackages.toArray(new String[changedPackages.size()]), userId, suspended);
        }
        return unactionedPackages.toArray(new String[unactionedPackages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSuspendedForUser(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "isPackageSuspendedForUser for user " + userId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, userId)) {
                throw new IllegalArgumentException("Unknown target package: " + packageName);
            }
            return ps.getSuspended(userId);
        }
    }

    private boolean canSuspendPackageForUserLocked(String packageName, int userId) {
        if (this.isPackageDeviceAdmin(packageName, userId)) {
            Slog.w(TAG, "Cannot suspend/un-suspend package \"" + packageName + "\": has an active device admin");
            return false;
        }
        String activeLauncherPackageName = this.getActiveLauncherPackageName(userId);
        if (packageName.equals(activeLauncherPackageName)) {
            Slog.w(TAG, "Cannot suspend/un-suspend package \"" + packageName + "\": contains the active launcher");
            return false;
        }
        if (packageName.equals(this.mRequiredInstallerPackage)) {
            Slog.w(TAG, "Cannot suspend/un-suspend package \"" + packageName + "\": required for package installation");
            return false;
        }
        if (packageName.equals(this.mRequiredUninstallerPackage)) {
            Slog.w(TAG, "Cannot suspend/un-suspend package \"" + packageName + "\": required for package uninstallation");
            return false;
        }
        if (packageName.equals(this.mRequiredVerifierPackage)) {
            Slog.w(TAG, "Cannot suspend/un-suspend package \"" + packageName + "\": required for package verification");
            return false;
        }
        if (packageName.equals(this.getDefaultDialerPackageName(userId))) {
            Slog.w(TAG, "Cannot suspend/un-suspend package \"" + packageName + "\": is the default dialer");
            return false;
        }
        if (this.mProtectedPackages.isPackageStateProtected(userId, packageName)) {
            Slog.w(TAG, "Cannot suspend/un-suspend package \"" + packageName + "\": protected package");
            return false;
        }
        PackageParser.Package pkg = this.mPackages.get(packageName);
        if (pkg != null && pkg.applicationInfo.isStaticSharedLibrary()) {
            Slog.w(TAG, "Cannot suspend package: " + packageName + " providing static shared library: " + pkg.staticSharedLibName);
            return false;
        }
        return true;
    }

    private String getActiveLauncherPackageName(int userId) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = this.resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 65536, userId);
        return resolveInfo == null ? null : resolveInfo.activityInfo.packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultDialerPackageName(int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getDefaultDialerPackageNameLPw(userId);
        }
    }

    @Override
    public void verifyPendingInstall(int id2, int verificationCode) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(15);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCode, Binder.getCallingUid());
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can extend verification timeouts");
        PackageVerificationState state = this.mPendingVerification.get(id2);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCodeAtTimeout, Binder.getCallingUid());
        if (millisecondsToDelay > 3600000L) {
            millisecondsToDelay = 3600000L;
        }
        if (millisecondsToDelay < 0L) {
            millisecondsToDelay = 0L;
        }
        if (verificationCodeAtTimeout != 1 && verificationCodeAtTimeout != -1) {
            verificationCodeAtTimeout = -1;
        }
        if (state != null && !state.timeoutExtended()) {
            state.extendTimeout();
            Message msg = this.mHandler.obtainMessage(15);
            msg.arg1 = id2;
            msg.obj = response;
            this.mHandler.sendMessageDelayed(msg, millisecondsToDelay);
        }
    }

    private void broadcastPackageVerified(int verificationId, Uri packageUri, int verificationCode, UserHandle user) {
        Intent intent = new Intent("android.intent.action.PACKAGE_VERIFIED");
        intent.setDataAndType(packageUri, PACKAGE_MIME_TYPE);
        intent.addFlags(1);
        intent.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
        intent.putExtra("android.content.pm.extra.VERIFICATION_RESULT", verificationCode);
        this.mContext.sendBroadcastAsUser(intent, user, "android.permission.PACKAGE_VERIFICATION_AGENT");
    }

    private ComponentName matchComponentForVerifier(String packageName, List<ResolveInfo> receivers) {
        ActivityInfo targetReceiver = null;
        int NR = receivers.size();
        for (int i = 0; i < NR; ++i) {
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || !packageName.equals(info.activityInfo.packageName)) continue;
            targetReceiver = info.activityInfo;
            break;
        }
        if (targetReceiver == null) {
            return null;
        }
        return new ComponentName(targetReceiver.packageName, targetReceiver.name);
    }

    private List<ComponentName> matchVerifiers(PackageInfoLite pkgInfo, List<ResolveInfo> receivers, PackageVerificationState verificationState) {
        if (pkgInfo.verifiers.length == 0) {
            return null;
        }
        int N = pkgInfo.verifiers.length;
        ArrayList<ComponentName> sufficientVerifiers = new ArrayList<ComponentName>(N + 1);
        for (int i = 0; i < N; ++i) {
            int verifierUid;
            VerifierInfo verifierInfo = pkgInfo.verifiers[i];
            ComponentName comp = this.matchComponentForVerifier(verifierInfo.packageName, receivers);
            if (comp == null || (verifierUid = this.getUidForVerifier(verifierInfo)) == -1) continue;
            sufficientVerifiers.add(comp);
            verificationState.addSufficientVerifier(verifierUid);
        }
        return sufficientVerifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForVerifier(VerifierInfo verifierInfo) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            byte[] expectedPublicKey;
            PackageParser.Package pkg = this.mPackages.get(verifierInfo.packageName);
            if (pkg == null) {
                return -1;
            }
            if (pkg.mSignatures.length != 1) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " has more than one signature; ignoring");
                return -1;
            }
            try {
                Signature verifierSig = pkg.mSignatures[0];
                PublicKey publicKey = verifierSig.getPublicKey();
                expectedPublicKey = publicKey.getEncoded();
            }
            catch (CertificateException e) {
                return -1;
            }
            byte[] actualPublicKey = verifierInfo.publicKey.getEncoded();
            if (!Arrays.equals(actualPublicKey, expectedPublicKey)) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " does not have the expected public key; ignoring");
                return -1;
            }
            return pkg.applicationInfo.uid;
        }
    }

    @Override
    public void finishPackageInstall(int token, boolean didLaunch) {
        PackageManagerService.enforceSystemOrRoot("Only the system is allowed to finish installs");
        Trace.asyncTraceEnd(262144L, "restore", token);
        Message msg = this.mHandler.obtainMessage(9, token, didLaunch ? 1 : 0);
        this.mHandler.sendMessage(msg);
    }

    private long getVerificationTimeout() {
        return Settings.Global.getLong(this.mContext.getContentResolver(), "verifier_timeout", 10000L);
    }

    private int getDefaultVerificationResponse(UserHandle user) {
        if (sUserManager.hasUserRestriction("ensure_verify_apps", user.getIdentifier())) {
            return -1;
        }
        return Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_default_response", 1);
    }

    private boolean isVerificationEnabled(int userId, int installFlags, int installerUid) {
        boolean ensureVerifyAppsEnabled = this.isUserRestricted(userId, "ensure_verify_apps");
        if ((installFlags & 0x20) != 0) {
            if (ActivityManager.isRunningInTestHarness()) {
                return false;
            }
            if (ensureVerifyAppsEnabled) {
                return true;
            }
            if (Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_verify_adb_installs", 1) == 0) {
                return false;
            }
        } else if ((installFlags & 0x800) != 0 && this.mInstantAppInstallerActivity != null && this.mInstantAppInstallerActivity.packageName.equals(this.mRequiredVerifierPackage)) {
            try {
                this.mContext.getSystemService(AppOpsManager.class).checkPackage(installerUid, this.mRequiredVerifierPackage);
                return false;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (ensureVerifyAppsEnabled) {
            return true;
        }
        return Settings.Global.getInt(this.mContext.getContentResolver(), "package_verifier_enable", 1) == 1;
    }

    @Override
    public void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTENT_FILTER_VERIFICATION_AGENT", "Only intentfilter verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(18);
        IntentFilterVerificationResponse response = new IntentFilterVerificationResponse(Binder.getCallingUid(), verificationCode, failedDomains);
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIntentVerificationStatus(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return 0;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return 0;
            }
            return this.mSettings.getIntentFilterVerificationStatusLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateIntentVerificationStatus(String packageName, int status, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        boolean result = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                return false;
            }
            result = this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, status, userId);
        }
        if (result) {
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return ParceledListSlice.emptyList();
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return ParceledListSlice.emptyList();
            }
            return new ParceledListSlice<IntentFilterVerificationInfo>(this.mSettings.getIntentFilterVerificationsLPr(packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<IntentFilter> getAllIntentFilters(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return ParceledListSlice.emptyList();
        }
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null || pkg.activities == null) {
                return ParceledListSlice.emptyList();
            }
            if (pkg.mExtras == null) {
                return ParceledListSlice.emptyList();
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                return ParceledListSlice.emptyList();
            }
            int count = pkg.activities.size();
            ArrayList result = new ArrayList();
            for (int n = 0; n < count; ++n) {
                PackageParser.Activity activity = pkg.activities.get(n);
                if (activity.intents == null || activity.intents.size() <= 0) continue;
                result.addAll(activity.intents);
            }
            return new ParceledListSlice<IntentFilter>(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDefaultBrowserPackageName(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean result = this.mSettings.setDefaultBrowserPackageNameLPw(packageName, userId);
            if (packageName != null) {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultBrowserLPr(packageName, userId);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultBrowserPackageName(int userId) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getDefaultBrowserPackageNameLPw(userId);
        }
    }

    private int getUnknownSourcesSettings() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "install_non_market_apps", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting setting;
            Signature[] callerSignature;
            Object obj;
            PackageSetting installerPackageSetting;
            PackageSetting targetPackageSetting = this.mSettings.mPackages.get(targetPackage);
            if (targetPackageSetting == null || this.filterAppAccessLPr(targetPackageSetting, callingUid, UserHandle.getUserId(callingUid))) {
                throw new IllegalArgumentException("Unknown target package: " + targetPackage);
            }
            if (installerPackageName != null) {
                installerPackageSetting = this.mSettings.mPackages.get(installerPackageName);
                if (installerPackageSetting == null) {
                    throw new IllegalArgumentException("Unknown installer package: " + installerPackageName);
                }
            } else {
                installerPackageSetting = null;
            }
            if ((obj = this.mSettings.getUserIdLPr(callingUid)) == null) throw new SecurityException("Unknown calling UID: " + callingUid);
            if (obj instanceof SharedUserSetting) {
                callerSignature = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) throw new SecurityException("Bad object " + obj + " for uid " + callingUid);
                callerSignature = ((PackageSetting)obj).signatures.mSignatures;
            }
            if (installerPackageSetting != null && PackageManagerService.compareSignatures(callerSignature, installerPackageSetting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as new installer package " + installerPackageName);
            }
            if (targetPackageSetting.installerPackageName != null && (setting = this.mSettings.mPackages.get(targetPackageSetting.installerPackageName)) != null && PackageManagerService.compareSignatures(callerSignature, setting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as old installer package " + targetPackageSetting.installerPackageName);
            }
            targetPackageSetting.installerPackageName = installerPackageName;
            if (installerPackageName != null) {
                this.mSettings.mInstallerPackages.add(installerPackageName);
            }
            this.scheduleWriteSettingsLocked();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationCategoryHint(String packageName, int categoryHint, String callerPackageName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            throw new SecurityException("Instant applications don't have access to this method");
        }
        this.mContext.getSystemService(AppOpsManager.class).checkPackage(Binder.getCallingUid(), callerPackageName);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                throw new IllegalArgumentException("Unknown target package " + packageName);
            }
            if (this.filterAppAccessLPr(ps, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                throw new IllegalArgumentException("Unknown target package " + packageName);
            }
            if (!Objects.equals(callerPackageName, ps.installerPackageName)) {
                throw new IllegalArgumentException("Calling package " + callerPackageName + " is not installer for " + packageName);
            }
            if (ps.categoryHint != categoryHint) {
                ps.categoryHint = categoryHint;
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    private void processPendingInstall(final InstallArgs args, final int currentStatus) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int token;
                boolean doRestore;
                block13: {
                    PackageManagerService.this.mHandler.removeCallbacks(this);
                    PackageInstalledInfo res = new PackageInstalledInfo();
                    res.setReturnCode(currentStatus);
                    res.uid = -1;
                    res.pkg = null;
                    res.removedInfo = null;
                    if (res.returnCode == 1) {
                        args.doPreInstall(res.returnCode);
                        Object object = PackageManagerService.this.mInstallLock;
                        synchronized (object) {
                            PackageManagerService.this.installPackageTracedLI(args, res);
                        }
                        args.doPostInstall(res.returnCode, res.uid);
                    }
                    boolean update = res.removedInfo != null && res.removedInfo.removedPackage != null;
                    int flags = res.pkg == null ? 0 : res.pkg.applicationInfo.flags;
                    boolean bl = doRestore = !update && (flags & 0x8000) != 0;
                    if (PackageManagerService.this.mNextInstallToken < 0) {
                        PackageManagerService.this.mNextInstallToken = 1;
                    }
                    token = PackageManagerService.this.mNextInstallToken++;
                    PostInstallData data = new PostInstallData(args, res);
                    PackageManagerService.this.mRunningInstalls.put(token, data);
                    if (res.returnCode == 1 && doRestore) {
                        IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                        if (bm != null) {
                            Trace.asyncTraceBegin(262144L, "restore", token);
                            try {
                                if (bm.isBackupServiceActive(0)) {
                                    bm.restoreAtInstall(res.pkg.applicationInfo.packageName, token);
                                    break block13;
                                }
                                doRestore = false;
                            }
                            catch (RemoteException remoteException) {
                            }
                            catch (Exception e) {
                                Slog.e(PackageManagerService.TAG, "Exception trying to enqueue restore", e);
                                doRestore = false;
                            }
                        } else {
                            Slog.e(PackageManagerService.TAG, "Backup Manager not found!");
                            doRestore = false;
                        }
                    }
                }
                if (!doRestore) {
                    Trace.asyncTraceBegin(262144L, "postInstall", token);
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(9, token, 0);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            }
        });
    }

    void notifyFirstLaunch(final String pkgName, final String installerPackage, final int userId) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < PackageManagerService.this.mRunningInstalls.size(); ++i) {
                    PostInstallData data = PackageManagerService.this.mRunningInstalls.valueAt(i);
                    if (data.res.returnCode != 1 || !pkgName.equals(data.res.pkg.applicationInfo.packageName)) continue;
                    for (int uIndex = 0; uIndex < data.res.newUsers.length; ++uIndex) {
                        if (userId != data.res.newUsers[uIndex]) continue;
                        return;
                    }
                }
                PackageManagerService.this.sendFirstLaunchBroadcast(pkgName, installerPackage, new int[]{userId});
            }
        });
    }

    private void sendFirstLaunchBroadcast(String pkgName, String installerPkg, int[] userIds) {
        this.sendPackageBroadcast("android.intent.action.PACKAGE_FIRST_LAUNCH", pkgName, null, 0, installerPkg, null, userIds);
    }

    private static void clearDirectory(IMediaContainerService mcs, File[] paths) {
        for (File path : paths) {
            try {
                mcs.clearDirectory(path.getAbsolutePath());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private static boolean installOnExternalAsec(int installFlags) {
        if ((installFlags & 0x10) != 0) {
            return false;
        }
        return (installFlags & 8) != 0;
    }

    private static boolean installForwardLocked(int installFlags) {
        return (installFlags & 1) != 0;
    }

    private InstallArgs createInstallArgs(InstallParams params) {
        if (params.move != null) {
            return new MoveInstallArgs(params);
        }
        if (PackageManagerService.installOnExternalAsec(params.installFlags) || params.isForwardLocked()) {
            return new AsecInstallArgs(params);
        }
        return new FileInstallArgs(params);
    }

    private InstallArgs createInstallArgsForExisting(int installFlags, String codePath, String resourcePath, String[] instructionSets) {
        boolean isInAsec = PackageManagerService.installOnExternalAsec(installFlags) ? true : PackageManagerService.installForwardLocked(installFlags) && !codePath.startsWith(this.mDrmAppPrivateInstallDir.getAbsolutePath());
        if (isInAsec) {
            return new AsecInstallArgs(codePath, instructionSets, PackageManagerService.installOnExternalAsec(installFlags), PackageManagerService.installForwardLocked(installFlags));
        }
        return new FileInstallArgs(codePath, resourcePath, instructionSets);
    }

    private void removeDexFiles(List<String> allCodePaths, String[] instructionSets) {
        if (!allCodePaths.isEmpty()) {
            if (instructionSets == null) {
                throw new IllegalStateException("instructionSet == null");
            }
            String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
            for (String codePath : allCodePaths) {
                for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                    try {
                        this.mInstaller.rmdex(codePath, dexCodeInstructionSet);
                    }
                    catch (Installer.InstallerException installerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private boolean isAsecExternal(String cid) {
        String asecPath = PackageHelper.getSdFilesystem(cid);
        return !asecPath.startsWith(this.mAsecInternalPath);
    }

    private static void maybeThrowExceptionForMultiArchCopy(String message, int copyRet) throws PackageManagerException {
        if (copyRet < 0 && copyRet != -114 && copyRet != -113) {
            throw new PackageManagerException(copyRet, message);
        }
    }

    static String cidFromCodePath(String fullCodePath) {
        int eidx = fullCodePath.lastIndexOf("/");
        String subStr1 = fullCodePath.substring(0, eidx);
        int sidx = subStr1.lastIndexOf("/");
        return subStr1.substring(sidx + 1, eidx);
    }

    static String getAsecPackageName(String packageCid) {
        int idx = packageCid.lastIndexOf(INSTALL_PACKAGE_SUFFIX);
        if (idx == -1) {
            return packageCid;
        }
        return packageCid.substring(0, idx);
    }

    private static String getNextCodePath(String oldCodePath, String prefix, String suffix) {
        String idxStr = "";
        int idx = 1;
        if (oldCodePath != null) {
            int sidx;
            String subStr = oldCodePath;
            if (suffix != null && subStr.endsWith(suffix)) {
                subStr = subStr.substring(0, subStr.length() - suffix.length());
            }
            if ((sidx = subStr.lastIndexOf(prefix)) != -1 && (subStr = subStr.substring(sidx + prefix.length())) != null) {
                if (subStr.startsWith(INSTALL_PACKAGE_SUFFIX)) {
                    subStr = subStr.substring(INSTALL_PACKAGE_SUFFIX.length());
                }
                try {
                    idx = Integer.parseInt(subStr);
                    idx = idx <= 1 ? ++idx : --idx;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        idxStr = INSTALL_PACKAGE_SUFFIX + Integer.toString(idx);
        return prefix + idxStr;
    }

    private File getNextCodePath(File targetDir, String packageName) {
        String suffix;
        File result;
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[16];
        do {
            random.nextBytes(bytes);
            suffix = Base64.encodeToString(bytes, 10);
        } while ((result = new File(targetDir, packageName + INSTALL_PACKAGE_SUFFIX + suffix)).exists());
        return result;
    }

    static String deriveCodePathName(String codePath) {
        if (codePath == null) {
            return null;
        }
        File codeFile = new File(codePath);
        String name = codeFile.getName();
        if (codeFile.isDirectory()) {
            return name;
        }
        if (name.endsWith(".apk") || name.endsWith(".tmp")) {
            int lastDot = name.lastIndexOf(46);
            return name.substring(0, lastDot);
        }
        Slog.w(TAG, "Odd, " + codePath + " doesn't look like an APK");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNewPackageLIF(PackageParser.Package pkg, int policyFlags, int scanFlags, UserHandle user, String installerPackageName, String volumeUuid, PackageInstalledInfo res, int installReason) {
        Trace.traceBegin(262144L, "installNewPackage");
        String pkgName = pkg.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String renamedPackage = this.mSettings.getRenamedPackageLPr(pkgName);
            if (renamedPackage != null) {
                res.setError(-1, "Attempt to re-install " + pkgName + " without first uninstalling package running as " + renamedPackage);
                return;
            }
            if (this.mPackages.containsKey(pkgName)) {
                res.setError(-1, "Attempt to re-install " + pkgName + " without first uninstalling.");
                return;
            }
        }
        try {
            PackageParser.Package newPackage = this.scanPackageTracedLI(pkg, policyFlags, scanFlags, System.currentTimeMillis(), user);
            this.updateSettingsLI(newPackage, installerPackageName, null, res, user, installReason);
            if (res.returnCode == 1) {
                this.prepareAppDataAfterInstallLIF(newPackage);
            } else {
                this.deletePackageLIF(pkgName, UserHandle.ALL, false, null, 1, res.removedInfo, true, null);
            }
        }
        catch (PackageManagerException e) {
            res.setError("Package couldn't be installed in " + pkg.codePath, e);
        }
        Trace.traceEnd(262144L);
    }

    private boolean shouldCheckUpgradeKeySetLP(PackageSetting oldPs, int scanFlags) {
        if (oldPs == null || (scanFlags & 0x1000) != 0 || oldPs.sharedUser != null || !oldPs.keySetData.isUsingUpgradeKeySets()) {
            return false;
        }
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        long[] upgradeKeySets = oldPs.keySetData.getUpgradeKeySets();
        for (int i = 0; i < upgradeKeySets.length; ++i) {
            if (ksms.isIdValidKeySetId(upgradeKeySets[i])) continue;
            Slog.wtf(TAG, "Package " + (oldPs.name != null ? oldPs.name : "<null>") + " contains upgrade-key-set reference to unknown key-set: " + upgradeKeySets[i] + " reverting to signatures check.");
            return false;
        }
        return true;
    }

    private boolean checkUpgradeKeySetLP(PackageSetting oldPS, PackageParser.Package newPkg) {
        long[] upgradeKeySets = oldPS.keySetData.getUpgradeKeySets();
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        for (int i = 0; i < upgradeKeySets.length; ++i) {
            ArraySet<PublicKey> upgradeSet = ksms.getPublicKeysFromKeySetLPr(upgradeKeySets[i]);
            if (upgradeSet == null || !newPkg.mSigningKeys.containsAll(upgradeSet)) continue;
            return true;
        }
        return false;
    }

    private static void updateDigest(MessageDigest digest, File file) throws IOException {
        try (DigestInputStream digestStream = new DigestInputStream(new FileInputStream(file), digest);){
            while (digestStream.read() != -1) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replacePackageLIF(PackageParser.Package pkg, int policyFlags, int scanFlags, UserHandle user, String installerPackageName, PackageInstalledInfo res, int installReason) {
        int[] installedUsers;
        int[] allUsers;
        PackageSetting ps;
        PackageParser.Package oldPackage;
        boolean isInstantApp = (scanFlags & 0x20000) != 0;
        String pkgName = pkg.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String invalidPackageName;
            boolean newTargetsPreRelease;
            oldPackage = this.mPackages.get(pkgName);
            boolean oldTargetsPreRelease = oldPackage.applicationInfo.targetSdkVersion == 10000;
            boolean bl = newTargetsPreRelease = pkg.applicationInfo.targetSdkVersion == 10000;
            if (oldTargetsPreRelease && !newTargetsPreRelease && (policyFlags & 0x1000) == 0) {
                Slog.w(TAG, "Can't install package targeting released sdk");
                res.setReturnCode(-7);
                return;
            }
            ps = this.mSettings.mPackages.get(pkgName);
            if (this.shouldCheckUpgradeKeySetLP(ps, scanFlags)) {
                if (!this.checkUpgradeKeySetLP(ps, pkg)) {
                    res.setError(-7, "New package not signed by keys specified by upgrade-keysets: " + pkgName);
                    return;
                }
            } else if (PackageManagerService.compareSignatures(oldPackage.mSignatures, pkg.mSignatures) != 0) {
                res.setError(-7, "New package has a different signature: " + pkgName);
                return;
            }
            if (oldPackage.restrictUpdateHash != null && oldPackage.isSystemApp()) {
                byte[] digestBytes = null;
                try {
                    MessageDigest digest = MessageDigest.getInstance("SHA-512");
                    PackageManagerService.updateDigest(digest, new File(pkg.baseCodePath));
                    if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
                        String[] stringArray = pkg.splitCodePaths;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String path = stringArray[i];
                            PackageManagerService.updateDigest(digest, new File(path));
                        }
                    }
                    digestBytes = digest.digest();
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    res.setError(-2, "Could not compute hash: " + pkgName);
                    return;
                }
                if (!Arrays.equals(oldPackage.restrictUpdateHash, digestBytes)) {
                    res.setError(-2, "New package fails restrict-update check: " + pkgName);
                    return;
                }
                pkg.restrictUpdateHash = oldPackage.restrictUpdateHash;
            }
            if ((invalidPackageName = this.getParentOrChildPackageChangedSharedUser(oldPackage, pkg)) != null) {
                res.setError(-8, "Package " + invalidPackageName + " tried to change user " + oldPackage.mSharedUserId);
                return;
            }
            allUsers = sUserManager.getUserIds();
            installedUsers = ps.queryInstalledUsers(allUsers, true);
            if (isInstantApp) {
                if (user == null || user.getIdentifier() == -1) {
                    for (int currentUser : allUsers) {
                        if (ps.getInstantApp(currentUser)) continue;
                        Slog.w(TAG, "Can't replace full app with instant app: " + pkgName + " for user: " + currentUser);
                        res.setReturnCode(-116);
                        return;
                    }
                } else if (!ps.getInstantApp(user.getIdentifier())) {
                    Slog.w(TAG, "Can't replace full app with instant app: " + pkgName + " for user: " + user.getIdentifier());
                    res.setReturnCode(-116);
                    return;
                }
            }
        }
        res.removedInfo = new PackageRemovedInfo(this);
        res.removedInfo.uid = oldPackage.applicationInfo.uid;
        res.removedInfo.removedPackage = oldPackage.packageName;
        res.removedInfo.installerPackageName = ps.installerPackageName;
        res.removedInfo.isStaticSharedLib = pkg.staticSharedLibName != null;
        res.removedInfo.isUpdate = true;
        res.removedInfo.origUsers = installedUsers;
        res.removedInfo.installReasons = new SparseArray(installedUsers.length);
        for (int i = 0; i < installedUsers.length; ++i) {
            int userId = installedUsers[i];
            res.removedInfo.installReasons.put(userId, ps.getInstallReason(userId));
        }
        int childCount = oldPackage.childPackages != null ? oldPackage.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageInstalledInfo childRes;
            boolean childPackageUpdated = false;
            PackageParser.Package childPkg = oldPackage.childPackages.get(i);
            PackageSetting childPs = this.mSettings.getPackageLPr(childPkg.packageName);
            if (res.addedChildPackages != null && (childRes = res.addedChildPackages.get(childPkg.packageName)) != null) {
                childRes.removedInfo.uid = childPkg.applicationInfo.uid;
                childRes.removedInfo.removedPackage = childPkg.packageName;
                if (childPs != null) {
                    childRes.removedInfo.installerPackageName = childPs.installerPackageName;
                }
                childRes.removedInfo.isUpdate = true;
                childRes.removedInfo.installReasons = res.removedInfo.installReasons;
                childPackageUpdated = true;
            }
            if (childPackageUpdated) continue;
            PackageRemovedInfo childRemovedRes = new PackageRemovedInfo(this);
            childRemovedRes.removedPackage = childPkg.packageName;
            if (childPs != null) {
                childRemovedRes.installerPackageName = childPs.installerPackageName;
            }
            childRemovedRes.isUpdate = false;
            childRemovedRes.dataRemoved = true;
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                if (childPs != null) {
                    childRemovedRes.origUsers = childPs.queryInstalledUsers(allUsers, true);
                }
            }
            if (res.removedInfo.removedChildPackages == null) {
                res.removedInfo.removedChildPackages = new ArrayMap();
            }
            res.removedInfo.removedChildPackages.put(childPkg.packageName, childRemovedRes);
        }
        boolean sysPkg = PackageManagerService.isSystemApp(oldPackage);
        if (sysPkg) {
            boolean privileged = (oldPackage.applicationInfo.privateFlags & 8) != 0;
            int systemPolicyFlags = policyFlags | 1 | (privileged ? 128 : 0);
            this.replaceSystemPackageLIF(oldPackage, pkg, systemPolicyFlags, scanFlags, user, allUsers, installerPackageName, res, installReason);
        } else {
            this.replaceNonSystemPackageLIF(oldPackage, pkg, policyFlags, scanFlags, user, allUsers, installerPackageName, res, installReason);
        }
    }

    @Override
    public List<String> getPreviousCodePaths(String packageName) {
        int callingUid = Binder.getCallingUid();
        ArrayList<String> result = new ArrayList<String>();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return result;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null && ps.oldCodePaths != null && !this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
            result.addAll(ps.oldCodePaths);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceNonSystemPackageLIF(PackageParser.Package deletedPackage, PackageParser.Package pkg, int policyFlags, int scanFlags, UserHandle user, int[] allUsers, String installerPackageName, PackageInstalledInfo res, int installReason) {
        PackageSetting ps;
        long origUpdateTime;
        String pkgName = deletedPackage.packageName;
        boolean deletedPkg = true;
        boolean addedPkg = false;
        boolean updatedSettings = false;
        boolean killApp = (scanFlags & 0x4000) == 0;
        int deleteFlags = 1 | (killApp ? 0 : 8);
        long l = origUpdateTime = pkg.mExtras != null ? ((PackageSetting)pkg.mExtras).lastUpdateTime : 0L;
        if (!this.deletePackageLIF(pkgName, null, true, allUsers, deleteFlags, res.removedInfo, true, pkg)) {
            res.setError(-10, "replaceNonSystemPackageLI");
            deletedPkg = false;
        } else {
            if (deletedPackage.isForwardLocked() || PackageManagerService.isExternal(deletedPackage)) {
                int[] uidArray = new int[]{deletedPackage.applicationInfo.uid};
                ArrayList<String> pkgList = new ArrayList<String>(1);
                pkgList.add(deletedPackage.applicationInfo.packageName);
                this.sendResourcesChangedBroadcast(false, true, pkgList, uidArray, null);
            }
            this.clearAppDataLIF(pkg, -1, 515);
            this.clearAppProfilesLIF(deletedPackage, -1);
            try {
                PackageParser.Package newPackage = this.scanPackageTracedLI(pkg, policyFlags, scanFlags | 0x20, System.currentTimeMillis(), user);
                this.updateSettingsLI(newPackage, installerPackageName, allUsers, res, user, installReason);
                ps = this.mSettings.mPackages.get(pkgName);
                if (!killApp) {
                    if (ps.oldCodePaths == null) {
                        ps.oldCodePaths = new ArraySet();
                    }
                    Collections.addAll(ps.oldCodePaths, deletedPackage.baseCodePath);
                    if (deletedPackage.splitCodePaths != null) {
                        Collections.addAll(ps.oldCodePaths, deletedPackage.splitCodePaths);
                    }
                } else {
                    ps.oldCodePaths = null;
                }
                if (ps.childPackageNames != null) {
                    for (int i = ps.childPackageNames.size() - 1; i >= 0; --i) {
                        String childPkgName = (String)ps.childPackageNames.get(i);
                        PackageSetting childPs = this.mSettings.mPackages.get(childPkgName);
                        childPs.oldCodePaths = ps.oldCodePaths;
                    }
                }
                boolean instantApp = (scanFlags & 0x20000) != 0;
                boolean fullApp = (scanFlags & 0x40000) != 0;
                this.setInstantAppForUser(ps, user.getIdentifier(), instantApp, fullApp);
                this.prepareAppDataAfterInstallLIF(newPackage);
                addedPkg = true;
                this.mDexManager.notifyPackageUpdated(newPackage.packageName, newPackage.baseCodePath, newPackage.splitCodePaths);
            }
            catch (PackageManagerException e) {
                res.setError("Package couldn't be installed in " + pkg.codePath, e);
            }
        }
        if (res.returnCode != 1) {
            if (addedPkg) {
                this.deletePackageLIF(pkgName, null, true, allUsers, deleteFlags, res.removedInfo, true, null);
            }
            if (deletedPkg) {
                File restoreFile = new File(deletedPackage.codePath);
                boolean oldExternal = PackageManagerService.isExternal(deletedPackage);
                int oldParseFlags = this.mDefParseFlags | 2 | (deletedPackage.isForwardLocked() ? 16 : 0) | (oldExternal ? 32 : 0);
                int oldScanFlags = 40;
                try {
                    this.scanPackageTracedLI(restoreFile, oldParseFlags, oldScanFlags, origUpdateTime, null);
                }
                catch (PackageManagerException e) {
                    Slog.e(TAG, "Failed to restore package : " + pkgName + " after failed upgrade: " + e.getMessage());
                    return;
                }
                ArrayMap<String, PackageParser.Package> e = this.mPackages;
                synchronized (e) {
                    this.setInstallerPackageNameLPw(deletedPackage, installerPackageName);
                    this.updatePermissionsLPw(deletedPackage, 1);
                    this.mSettings.writeLPr();
                }
                Slog.i(TAG, "Successfully restored package : " + pkgName + " after failed upgrade");
            }
        } else {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                ps = this.mSettings.getPackageLPr(pkg.packageName);
                if (ps != null) {
                    boolean bl = res.removedInfo.removedForAllUsers = this.mPackages.get(ps.name) == null;
                    if (res.removedInfo.removedChildPackages != null) {
                        int childCount = res.removedInfo.removedChildPackages.size();
                        for (int i = childCount - 1; i >= 0; --i) {
                            String childPackageName = res.removedInfo.removedChildPackages.keyAt(i);
                            if (res.addedChildPackages.containsKey(childPackageName)) {
                                res.removedInfo.removedChildPackages.removeAt(i);
                                continue;
                            }
                            PackageRemovedInfo childInfo = res.removedInfo.removedChildPackages.valueAt(i);
                            childInfo.removedForAllUsers = this.mPackages.get(childInfo.removedPackage) == null;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSystemPackageLIF(PackageParser.Package deletedPackage, PackageParser.Package pkg, int policyFlags, int scanFlags, UserHandle user, int[] allUsers, String installerPackageName, PackageInstalledInfo res, int installReason) {
        boolean disabledSystem;
        this.removePackageLI(deletedPackage, true);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            disabledSystem = this.disableSystemPackageLPw(deletedPackage, pkg);
        }
        res.removedInfo.args = !disabledSystem ? this.createInstallArgsForExisting(0, deletedPackage.applicationInfo.getCodePath(), deletedPackage.applicationInfo.getResourcePath(), InstructionSets.getAppDexInstructionSets(deletedPackage.applicationInfo)) : null;
        this.clearAppDataLIF(pkg, -1, 515);
        this.clearAppProfilesLIF(deletedPackage, -1);
        res.setReturnCode(1);
        pkg.setApplicationInfoFlags(128, 128);
        PackageParser.Package newPackage = null;
        try {
            newPackage = this.scanPackageTracedLI(pkg, policyFlags, scanFlags, 0L, user);
            PackageSetting deletedPkgSetting = (PackageSetting)deletedPackage.mExtras;
            this.setInstallAndUpdateTime(newPackage, deletedPkgSetting.firstInstallTime, System.currentTimeMillis());
            if (res.returnCode == 1) {
                int deletedChildCount = deletedPackage.childPackages != null ? deletedPackage.childPackages.size() : 0;
                int newChildCount = newPackage.childPackages != null ? newPackage.childPackages.size() : 0;
                for (int i = 0; i < deletedChildCount; ++i) {
                    PackageSetting ps;
                    PackageParser.Package deletedChildPkg = deletedPackage.childPackages.get(i);
                    boolean childPackageDeleted = true;
                    for (int j = 0; j < newChildCount; ++j) {
                        PackageParser.Package newChildPkg = newPackage.childPackages.get(j);
                        if (!deletedChildPkg.packageName.equals(newChildPkg.packageName)) continue;
                        childPackageDeleted = false;
                        break;
                    }
                    if (!childPackageDeleted || (ps = this.mSettings.getDisabledSystemPkgLPr(deletedChildPkg.packageName)) == null || res.removedInfo.removedChildPackages == null) continue;
                    PackageRemovedInfo removedChildRes = res.removedInfo.removedChildPackages.get(deletedChildPkg.packageName);
                    this.removePackageDataLIF(ps, allUsers, removedChildRes, 0, false);
                    removedChildRes.removedForAllUsers = this.mPackages.get(ps.name) == null;
                }
                this.updateSettingsLI(newPackage, installerPackageName, allUsers, res, user, installReason);
                this.prepareAppDataAfterInstallLIF(newPackage);
                this.mDexManager.notifyPackageUpdated(newPackage.packageName, newPackage.baseCodePath, newPackage.splitCodePaths);
            }
        }
        catch (PackageManagerException e) {
            res.setReturnCode(-110);
            res.setError("Package couldn't be installed in " + pkg.codePath, e);
        }
        if (res.returnCode != 1) {
            if (newPackage != null) {
                this.removeInstalledPackageLI(newPackage, true);
            }
            try {
                this.scanPackageTracedLI(deletedPackage, policyFlags, 8, 0L, user);
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "Failed to restore original package: " + e.getMessage());
            }
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                if (disabledSystem) {
                    this.enableSystemPackageLPw(deletedPackage);
                }
                this.setInstallerPackageNameLPw(deletedPackage, installerPackageName);
                this.updatePermissionsLPw(deletedPackage, 1);
                this.mSettings.writeLPr();
            }
            Slog.i(TAG, "Successfully restored package : " + deletedPackage.packageName + " after failed upgrade");
        }
    }

    private String getParentOrChildPackageChangedSharedUser(PackageParser.Package oldPkg, PackageParser.Package newPkg) {
        if (!Objects.equals(oldPkg.mSharedUserId, newPkg.mSharedUserId)) {
            return newPkg.packageName;
        }
        int oldChildCount = oldPkg.childPackages != null ? oldPkg.childPackages.size() : 0;
        int newChildCount = newPkg.childPackages != null ? newPkg.childPackages.size() : 0;
        for (int i = 0; i < newChildCount; ++i) {
            PackageParser.Package newChildPkg = newPkg.childPackages.get(i);
            for (int j = 0; j < oldChildCount; ++j) {
                PackageParser.Package oldChildPkg = oldPkg.childPackages.get(j);
                if (!newChildPkg.packageName.equals(oldChildPkg.packageName) || Objects.equals(newChildPkg.mSharedUserId, oldChildPkg.mSharedUserId)) continue;
                return newChildPkg.packageName;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNativeBinariesLI(PackageSetting ps) {
        if (ps != null) {
            NativeLibraryHelper.removeNativeBinariesLI(ps.legacyNativeLibraryPathString);
            int childCount = ps.childPackageNames != null ? ps.childPackageNames.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageSetting childPs = null;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    childPs = this.mSettings.getPackageLPr((String)ps.childPackageNames.get(i));
                }
                if (childPs == null) continue;
                NativeLibraryHelper.removeNativeBinariesLI(childPs.legacyNativeLibraryPathString);
            }
        }
    }

    private void enableSystemPackageLPw(PackageParser.Package pkg) {
        this.mSettings.enableSystemPackageLPw(pkg.packageName);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            this.mSettings.enableSystemPackageLPw(childPkg.packageName);
        }
    }

    private boolean disableSystemPackageLPw(PackageParser.Package oldPkg, PackageParser.Package newPkg) {
        boolean disabled = this.mSettings.disableSystemPackageLPw(oldPkg.packageName, true);
        int childCount = oldPkg.childPackages != null ? oldPkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = oldPkg.childPackages.get(i);
            boolean replace = newPkg.hasChildPackage(childPkg.packageName);
            disabled |= this.mSettings.disableSystemPackageLPw(childPkg.packageName, replace);
        }
        return disabled;
    }

    private void setInstallerPackageNameLPw(PackageParser.Package pkg, String installerPackageName) {
        this.mSettings.setInstallerPackageName(pkg.packageName, installerPackageName);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            this.mSettings.setInstallerPackageName(childPkg.packageName, installerPackageName);
        }
    }

    private int[] revokeUnusedSharedUserPermissionsLPw(SharedUserSetting su, int[] allUserIds) {
        BasePermission bp;
        ArraySet<String> usedPermissions = new ArraySet<String>();
        int packageCount = su.packages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageSetting ps = su.packages.valueAt(i);
            if (ps.pkg == null) continue;
            int requestedPermCount = ps.pkg.requestedPermissions.size();
            for (int j = 0; j < requestedPermCount; ++j) {
                String permission2 = ps.pkg.requestedPermissions.get(j);
                bp = this.mSettings.mPermissions.get(permission2);
                if (bp == null) continue;
                usedPermissions.add(permission2);
            }
        }
        PermissionsState permissionsState = su.getPermissionsState();
        List<PermissionsState.PermissionState> installPermStates = permissionsState.getInstallPermissionStates();
        int installPermCount = installPermStates.size();
        for (int i = installPermCount - 1; i >= 0; --i) {
            PermissionsState.PermissionState permissionState = installPermStates.get(i);
            if (usedPermissions.contains(permissionState.getName()) || (bp = this.mSettings.mPermissions.get(permissionState.getName())) == null) continue;
            permissionsState.revokeInstallPermission(bp);
            permissionsState.updatePermissionFlags(bp, -1, 255, 0);
        }
        int[] runtimePermissionChangedUserIds = EmptyArray.INT;
        for (int userId : allUserIds) {
            List<PermissionsState.PermissionState> runtimePermStates = permissionsState.getRuntimePermissionStates(userId);
            int runtimePermCount = runtimePermStates.size();
            for (int i = runtimePermCount - 1; i >= 0; --i) {
                BasePermission bp2;
                PermissionsState.PermissionState permissionState = runtimePermStates.get(i);
                if (usedPermissions.contains(permissionState.getName()) || (bp2 = this.mSettings.mPermissions.get(permissionState.getName())) == null) continue;
                permissionsState.revokeRuntimePermission(bp2, userId);
                permissionsState.updatePermissionFlags(bp2, userId, 255, 0);
                runtimePermissionChangedUserIds = ArrayUtils.appendInt(runtimePermissionChangedUserIds, userId);
            }
        }
        return runtimePermissionChangedUserIds;
    }

    private void updateSettingsLI(PackageParser.Package newPackage, String installerPackageName, int[] allUsers, PackageInstalledInfo res, UserHandle user, int installReason) {
        this.updateSettingsInternalLI(newPackage, installerPackageName, allUsers, res.origUsers, res, user, installReason);
        int childCount = newPackage.childPackages != null ? newPackage.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPackage = newPackage.childPackages.get(i);
            PackageInstalledInfo childRes = res.addedChildPackages.get(childPackage.packageName);
            this.updateSettingsInternalLI(childPackage, installerPackageName, allUsers, childRes.origUsers, childRes, user, installReason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettingsInternalLI(PackageParser.Package newPackage, String installerPackageName, int[] allUsers, int[] installedForUsers, PackageInstalledInfo res, UserHandle user, int installReason) {
        Trace.traceBegin(262144L, "updateSettings");
        String pkgName = newPackage.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.setInstallStatus(pkgName, 0);
            Trace.traceBegin(262144L, "writeSettings");
            this.mSettings.writeLPr();
            Trace.traceEnd(262144L);
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.updatePermissionsLPw(newPackage.packageName, newPackage, 2 | (newPackage.permissions.size() > 0 ? 1 : 0));
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            int userId = user.getIdentifier();
            if (ps != null) {
                if (PackageManagerService.isSystemApp(newPackage)) {
                    if (res.origUsers != null) {
                        for (int origUserId : res.origUsers) {
                            if (userId != -1 && userId != origUserId) continue;
                            ps.setEnabled(0, origUserId, installerPackageName);
                        }
                    }
                    if (allUsers != null && installedForUsers != null) {
                        for (int currentUserId : allUsers) {
                            boolean installed = ArrayUtils.contains(installedForUsers, currentUserId);
                            ps.setInstalled(installed, currentUserId);
                        }
                    }
                }
                if (userId != -1) {
                    ps.setInstalled(true, userId);
                    ps.setEnabled(0, userId, installerPackageName);
                }
                ArraySet<Integer> previousUserIds = new ArraySet<Integer>();
                if (res.removedInfo != null && res.removedInfo.installReasons != null) {
                    int installReasonCount = res.removedInfo.installReasons.size();
                    for (int i = 0; i < installReasonCount; ++i) {
                        int previousUserId = res.removedInfo.installReasons.keyAt(i);
                        int previousInstallReason = res.removedInfo.installReasons.valueAt(i);
                        ps.setInstallReason(previousInstallReason, previousUserId);
                        previousUserIds.add(previousUserId);
                    }
                }
                if (userId == -1) {
                    for (int currentUserId : sUserManager.getUserIds()) {
                        if (previousUserIds.contains(currentUserId)) continue;
                        ps.setInstallReason(installReason, currentUserId);
                    }
                } else if (!previousUserIds.contains(userId)) {
                    ps.setInstallReason(installReason, userId);
                }
                this.mSettings.writeKernelMappingLPr(ps);
            }
            res.name = pkgName;
            res.uid = newPackage.applicationInfo.uid;
            res.pkg = newPackage;
            this.mSettings.setInstallStatus(pkgName, 1);
            this.mSettings.setInstallerPackageName(pkgName, installerPackageName);
            res.setReturnCode(1);
            Trace.traceBegin(262144L, "writeSettings");
            this.mSettings.writeLPr();
            Trace.traceEnd(262144L);
        }
        Trace.traceEnd(262144L);
    }

    private void installPackageTracedLI(InstallArgs args, PackageInstalledInfo res) {
        try {
            Trace.traceBegin(262144L, "installPackage");
            this.installPackageLI(args, res);
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPackageLI(InstallArgs args, PackageInstalledInfo res) {
        int i;
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> childPkg;
        PackageParser.Package pkg;
        int installFlags = args.installFlags;
        String installerPackageName = args.installerPackageName;
        String volumeUuid = args.volumeUuid;
        File tmpPackageFile = new File(args.getCodePath());
        boolean forwardLocked = (installFlags & 1) != 0;
        boolean onExternal = (installFlags & 8) != 0 || args.volumeUuid != null;
        boolean instantApp = (installFlags & 0x800) != 0;
        boolean fullApp = (installFlags & 0x4000) != 0;
        boolean forceSdk = (installFlags & 0x2000) != 0;
        boolean replace = false;
        int scanFlags = 24;
        if (args.move != null) {
            scanFlags |= 0x1000;
        }
        if ((installFlags & 0x1000) != 0) {
            scanFlags |= 0x4000;
        }
        if (instantApp) {
            scanFlags |= 0x20000;
        }
        if (fullApp) {
            scanFlags |= 0x40000;
        }
        res.setReturnCode(1);
        if (instantApp && (forwardLocked || onExternal)) {
            Slog.i(TAG, "Incompatible ephemeral install; fwdLocked=" + forwardLocked + " external=" + onExternal);
            res.setReturnCode(-116);
            return;
        }
        int parseFlags = this.mDefParseFlags | 2 | 0x400 | (forwardLocked ? 16 : 0) | (onExternal ? 32 : 0) | (instantApp ? 2048 : 0) | (forceSdk ? 4096 : 0);
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setDisplayMetrics(this.mMetrics);
        pp.setCallback(this.mPackageParserCallback);
        Trace.traceBegin(262144L, "parsePackage");
        try {
            pkg = pp.parsePackage(tmpPackageFile, parseFlags);
        }
        catch (PackageParser.PackageParserException e) {
            res.setError("Failed parse during installPackageLI", e);
            return;
        }
        finally {
            Trace.traceEnd(262144L);
        }
        if (instantApp && pkg.applicationInfo.targetSdkVersion <= 25) {
            Slog.w(TAG, "Instant app package " + pkg.packageName + " does not target O");
            res.setError(-27, "Instant app package must target O");
            return;
        }
        if (instantApp && pkg.applicationInfo.targetSandboxVersion != 2) {
            Slog.w(TAG, "Instant app package " + pkg.packageName + " does not target targetSandboxVersion 2");
            res.setError(-27, "Instant app package must use targetSanboxVersion 2");
            return;
        }
        if (pkg.applicationInfo.isStaticSharedLibrary()) {
            this.renameStaticSharedLibraryPackage(pkg);
            if (onExternal) {
                Slog.i(TAG, "Static shared libs can only be installed on internal storage.");
                res.setError(-19, "Packages declaring static-shared libs cannot be updated");
                return;
            }
        }
        if (pkg.childPackages != null) {
            ArrayMap<String, PackageParser.Package> e = this.mPackages;
            synchronized (e) {
                int childCount = pkg.childPackages.size();
                for (int i2 = 0; i2 < childCount; ++i2) {
                    childPkg = pkg.childPackages.get(i2);
                    PackageInstalledInfo childRes = new PackageInstalledInfo();
                    childRes.setReturnCode(1);
                    childRes.pkg = childPkg;
                    childRes.name = ((PackageParser.Package)((Object)childPkg)).packageName;
                    PackageSetting childPs = this.mSettings.getPackageLPr(((PackageParser.Package)((Object)childPkg)).packageName);
                    if (childPs != null) {
                        childRes.origUsers = childPs.queryInstalledUsers(sUserManager.getUserIds(), true);
                    }
                    if (this.mPackages.containsKey(((PackageParser.Package)((Object)childPkg)).packageName)) {
                        childRes.removedInfo = new PackageRemovedInfo(this);
                        childRes.removedInfo.removedPackage = ((PackageParser.Package)((Object)childPkg)).packageName;
                        childRes.removedInfo.installerPackageName = childPs.installerPackageName;
                    }
                    if (res.addedChildPackages == null) {
                        res.addedChildPackages = new ArrayMap();
                    }
                    res.addedChildPackages.put(((PackageParser.Package)((Object)childPkg)).packageName, childRes);
                }
            }
        }
        if (TextUtils.isEmpty(pkg.cpuAbiOverride)) {
            pkg.cpuAbiOverride = args.abiOverride;
        }
        String pkgName = res.name = pkg.packageName;
        if ((pkg.applicationInfo.flags & 0x100) != 0 && (installFlags & 4) == 0) {
            res.setError(-15, "installPackageLI");
            return;
        }
        try {
            if (args.certificates != null) {
                try {
                    PackageParser.populateCertificates(pkg, args.certificates);
                }
                catch (PackageParser.PackageParserException e) {
                    PackageParser.collectCertificates(pkg, parseFlags);
                }
            } else {
                PackageParser.collectCertificates(pkg, parseFlags);
            }
        }
        catch (PackageParser.PackageParserException e) {
            res.setError("Failed collect during installPackageLI", e);
            return;
        }
        pp = null;
        String oldCodePath = null;
        boolean systemApp = false;
        childPkg = this.mPackages;
        synchronized (childPkg) {
            if ((installFlags & 2) != 0) {
                String oldName = this.mSettings.getRenamedPackageLPr(pkgName);
                if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName) && this.mPackages.containsKey(oldName)) {
                    pkg.setPackageName(oldName);
                    pkgName = pkg.packageName;
                    replace = true;
                } else if (this.mPackages.containsKey(pkgName)) {
                    replace = true;
                }
                if (pkg.parentPackage != null) {
                    res.setError(-106, "Package " + pkg.packageName + " is child of package " + pkg.parentPackage.parentPackage + ". Child packages " + "can be updated only through the parent package.");
                    return;
                }
                if (replace) {
                    PackageParser.Package oldPackage = this.mPackages.get(pkgName);
                    int oldTargetSdk = oldPackage.applicationInfo.targetSdkVersion;
                    int newTargetSdk = pkg.applicationInfo.targetSdkVersion;
                    if (oldTargetSdk > 22 && newTargetSdk <= 22) {
                        res.setError(-26, "Package " + pkg.packageName + " new target SDK " + newTargetSdk + " doesn't support runtime permissions but the old" + " target SDK " + oldTargetSdk + " does.");
                        return;
                    }
                    int oldTargetSandbox = oldPackage.applicationInfo.targetSandboxVersion;
                    int newTargetSandbox = pkg.applicationInfo.targetSandboxVersion;
                    if (oldTargetSandbox == 2 && newTargetSandbox != 2) {
                        res.setError(-27, "Package " + pkg.packageName + " new target sandbox " + newTargetSandbox + " is incompatible with the previous value of" + oldTargetSandbox + ".");
                        return;
                    }
                    if (oldPackage.parentPackage != null) {
                        res.setError(-106, "Package " + pkg.packageName + " is child of package " + oldPackage.parentPackage + ". Child packages " + "can be updated only through the parent package.");
                        return;
                    }
                }
            }
            if ((ps = this.mSettings.mPackages.get(pkgName)) != null) {
                SharedLibraryEntry libraryEntry;
                PackageSetting signatureCheckPs = ps;
                if (pkg.applicationInfo.isStaticSharedLibrary() && (libraryEntry = this.getLatestSharedLibraVersionLPr(pkg)) != null) {
                    signatureCheckPs = this.mSettings.getPackageLPr(libraryEntry.apk);
                }
                if (this.shouldCheckUpgradeKeySetLP(signatureCheckPs, scanFlags)) {
                    if (!this.checkUpgradeKeySetLP(signatureCheckPs, pkg)) {
                        res.setError(-7, "Package " + pkg.packageName + " upgrade keys do not match the " + "previously installed version");
                        return;
                    }
                } else {
                    try {
                        this.verifySignaturesLP(signatureCheckPs, pkg);
                    }
                    catch (PackageManagerException e) {
                        res.setError(e.error, e.getMessage());
                        return;
                    }
                }
                oldCodePath = this.mSettings.mPackages.get((Object)pkgName).codePathString;
                if (ps.pkg != null && ps.pkg.applicationInfo != null) {
                    systemApp = (ps.pkg.applicationInfo.flags & 1) != 0;
                }
                res.origUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
            int N = pkg.permissions.size();
            for (i = N - 1; i >= 0; --i) {
                boolean sigsOk;
                PackageParser.Permission perm = pkg.permissions.get(i);
                BasePermission bp = this.mSettings.mPermissions.get(perm.info.name);
                if ((perm.info.protectionLevel & 0x1000) != 0 && !systemApp) {
                    Slog.w(TAG, "Non-System package " + pkg.packageName + " attempting to delcare ephemeral permission " + perm.info.name + "; Removing ephemeral.");
                    perm.info.protectionLevel &= 0xFFFFEFFF;
                }
                if (bp == null) continue;
                if (bp.sourcePackage.equals(pkg.packageName) && bp.packageSetting instanceof PackageSetting && this.shouldCheckUpgradeKeySetLP((PackageSetting)bp.packageSetting, scanFlags)) {
                    sigsOk = this.checkUpgradeKeySetLP((PackageSetting)bp.packageSetting, pkg);
                } else {
                    boolean bl = sigsOk = PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0;
                }
                if (!sigsOk) {
                    if (!bp.sourcePackage.equals(PLATFORM_PACKAGE_NAME)) {
                        res.setError(-112, "Package " + pkg.packageName + " attempting to redeclare permission " + perm.info.name + " already owned by " + bp.sourcePackage);
                        res.origPermission = perm.info.name;
                        res.origPackage = bp.sourcePackage;
                        return;
                    }
                    Slog.w(TAG, "Package " + pkg.packageName + " attempting to redeclare system permission " + perm.info.name + "; ignoring new declaration");
                    pkg.permissions.remove(i);
                    continue;
                }
                if (PLATFORM_PACKAGE_NAME.equals(pkg.packageName) || (perm.info.protectionLevel & 0xF) != 1 || bp == null || bp.isRuntime()) continue;
                Slog.w(TAG, "Package " + pkg.packageName + " trying to change a " + "non-runtime permission " + perm.info.name + " to runtime; keeping old protection level");
                perm.info.protectionLevel = bp.protectionLevel;
            }
        }
        if (systemApp) {
            if (onExternal) {
                res.setError(-19, "Cannot install updates to system apps on sdcard");
                return;
            }
            if (instantApp) {
                res.setError(-116, "Cannot update a system app with an instant app");
                return;
            }
        }
        if (args.move != null) {
            scanFlags |= 2;
            scanFlags |= 0x800;
            childPkg = this.mPackages;
            synchronized (childPkg) {
                ps = this.mSettings.mPackages.get(pkgName);
                if (ps == null) {
                    res.setError(-110, "Missing settings for moved package " + pkgName);
                }
                pkg.applicationInfo.primaryCpuAbi = ps.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = ps.secondaryCpuAbiString;
            }
        }
        if (!forwardLocked && !pkg.applicationInfo.isExternalAsec()) {
            scanFlags |= 2;
            try {
                String abiOverride = TextUtils.isEmpty(pkg.cpuAbiOverride) ? args.abiOverride : pkg.cpuAbiOverride;
                boolean extractNativeLibs = !pkg.isLibrary();
                PackageManagerService.derivePackageAbi(pkg, new File(pkg.codePath), abiOverride, extractNativeLibs, this.mAppLib32InstallDir);
            }
            catch (PackageManagerException pme) {
                Slog.e(TAG, "Error deriving application ABI", pme);
                res.setError(-110, "Error deriving application ABI");
                return;
            }
            ArrayMap<String, PackageParser.Package> pme = this.mPackages;
            synchronized (pme) {
                try {
                    this.updateSharedLibrariesLPr(pkg, null);
                }
                catch (PackageManagerException e) {
                    Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
                }
            }
            if (!instantApp || Settings.Global.getInt(this.mContext.getContentResolver(), "instant_app_dexopt_enabled", 0) != 0) {
                Trace.traceBegin(262144L, "dexopt");
                this.mPackageDexOptimizer.performDexOpt(pkg, pkg.usesLibraryFiles, null, false, PackageManagerServiceCompilerMapping.getCompilerFilterForReason(2), this.getOrCreateCompilerPackageStats(pkg), this.mDexManager.isUsedByOtherApps(pkg.packageName));
                Trace.traceEnd(262144L);
            }
            BackgroundDexOptService.notifyPackageChanged(pkg.packageName);
        }
        if (!args.doRename(res.returnCode, pkg, oldCodePath)) {
            res.setError(-4, "Failed rename");
            return;
        }
        this.startIntentFilterVerifications(args.user.getIdentifier(), replace, pkg);
        try (PackageFreezer freezer = this.freezePackageForInstall(pkgName, installFlags, "installPackageLI");){
            if (replace) {
                PackageParser.Package existingPkg;
                if (pkg.applicationInfo.isStaticSharedLibrary() && (existingPkg = this.mPackages.get(pkg.packageName)) != null && existingPkg.mVersionCode != pkg.mVersionCode) {
                    res.setError(-5, "Packages declaring static-shared libs cannot be updated");
                    return;
                }
                this.replacePackageLIF(pkg, parseFlags, scanFlags | 0x200, args.user, installerPackageName, res, args.installReason);
            } else {
                this.installNewPackageLIF(pkg, parseFlags, scanFlags | 0x100, args.user, installerPackageName, volumeUuid, res, args.installReason);
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps2 = this.mSettings.mPackages.get(pkgName);
            if (ps2 != null) {
                res.newUsers = ps2.queryInstalledUsers(sUserManager.getUserIds(), true);
                ps2.setUpdateAvailable(false);
            }
            int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
            for (i = 0; i < childCount; ++i) {
                PackageParser.Package childPkg2 = pkg.childPackages.get(i);
                PackageInstalledInfo childRes = res.addedChildPackages.get(childPkg2.packageName);
                PackageSetting childPs = this.mSettings.getPackageLPr(childPkg2.packageName);
                if (childPs == null) continue;
                childRes.newUsers = childPs.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
            if (res.returnCode == 1) {
                this.updateSequenceNumberLP(ps2, res.newUsers);
                this.updateInstantAppInstallerLocked(pkgName);
            }
        }
    }

    private void startIntentFilterVerifications(int userId, boolean replacing, PackageParser.Package pkg) {
        if (this.mIntentFilterVerifierComponent == null) {
            Slog.w(TAG, "No IntentFilter verification will not be done as there is no IntentFilterVerifier available!");
            return;
        }
        int verifierUid = this.getPackageUid(this.mIntentFilterVerifierComponent.getPackageName(), 0x10000000, userId == -1 ? 0 : userId);
        Message msg = this.mHandler.obtainMessage(17);
        msg.obj = new IFVerificationParams(pkg, replacing, userId, verifierUid);
        this.mHandler.sendMessage(msg);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageParser.Package childPkg = pkg.childPackages.get(i);
            msg = this.mHandler.obtainMessage(17);
            msg.obj = new IFVerificationParams(childPkg, replacing, userId, verifierUid);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIntentFiltersIfNeeded(int userId, int verifierUid, boolean replacing, PackageParser.Package pkg) {
        int size = pkg.activities.size();
        if (size == 0) {
            return;
        }
        boolean hasDomainURLs = PackageManagerService.hasDomainURLs(pkg);
        if (!hasDomainURLs) {
            return;
        }
        int count = 0;
        String packageName = pkg.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            IntentFilterVerificationInfo ivi;
            if (!replacing && (ivi = this.mSettings.getIntentFilterVerificationLPr(packageName)) != null) {
                return;
            }
            boolean needToVerify = false;
            block3: for (PackageParser.Activity a : pkg.activities) {
                for (PackageParser.ActivityIntentInfo filter : a.intents) {
                    if (!filter.needsVerification() || !this.needsNetworkVerificationLPr(filter)) continue;
                    needToVerify = true;
                    continue block3;
                }
            }
            if (needToVerify) {
                int verificationId = this.mIntentFilterVerificationToken++;
                for (PackageParser.Activity a : pkg.activities) {
                    for (PackageParser.ActivityIntentInfo filter : a.intents) {
                        if (!filter.handlesWebUris(true) || !this.needsNetworkVerificationLPr(filter)) continue;
                        this.mIntentFilterVerifier.addOneIntentFilterVerification(verifierUid, userId, verificationId, filter, packageName);
                        ++count;
                    }
                }
            }
        }
        if (count > 0) {
            this.mIntentFilterVerifier.startVerifications(userId);
        }
    }

    private boolean needsNetworkVerificationLPr(PackageParser.ActivityIntentInfo filter) {
        ComponentName cn = filter.activity.getComponentName();
        String packageName = cn.getPackageName();
        IntentFilterVerificationInfo ivi = this.mSettings.getIntentFilterVerificationLPr(packageName);
        if (ivi == null) {
            return true;
        }
        int status = ivi.getStatus();
        switch (status) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    private static boolean isMultiArch(ApplicationInfo info) {
        return (info.flags & Integer.MIN_VALUE) != 0;
    }

    private static boolean isExternal(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000) != 0;
    }

    private static boolean isExternal(PackageSetting ps) {
        return (ps.pkgFlags & 0x40000) != 0;
    }

    private static boolean isSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 1) != 0;
    }

    private static boolean isPrivilegedApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 8) != 0;
    }

    private static boolean hasDomainURLs(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x10) != 0;
    }

    private static boolean isSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 1) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 0x80) != 0;
    }

    private int packageFlagsToInstallFlags(PackageSetting ps) {
        int installFlags = 0;
        if (PackageManagerService.isExternal(ps) && TextUtils.isEmpty(ps.volumeUuid)) {
            installFlags |= 8;
        }
        if (ps.isForwardLocked()) {
            installFlags |= 1;
        }
        return installFlags;
    }

    private String getVolumeUuidForPackage(PackageParser.Package pkg) {
        if (PackageManagerService.isExternal(pkg)) {
            if (TextUtils.isEmpty(pkg.volumeUuid)) {
                return "primary_physical";
            }
            return pkg.volumeUuid;
        }
        return StorageManager.UUID_PRIVATE_INTERNAL;
    }

    private Settings.VersionInfo getSettingsVersionForPackage(PackageParser.Package pkg) {
        if (PackageManagerService.isExternal(pkg)) {
            if (TextUtils.isEmpty(pkg.volumeUuid)) {
                return this.mSettings.getExternalVersion();
            }
            return this.mSettings.findOrCreateVersion(pkg.volumeUuid);
        }
        return this.mSettings.getInternalVersion();
    }

    private void deleteTempPackageFiles() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("vmdl") && name.endsWith(".tmp");
            }
        };
        for (File file : this.mDrmAppPrivateInstallDir.listFiles(filter)) {
            file.delete();
        }
    }

    @Override
    public void deletePackageAsUser(String packageName, int versionCode, IPackageDeleteObserver observer, int userId, int flags) {
        this.deletePackageVersioned(new VersionedPackage(packageName, versionCode), new PackageManager.LegacyPackageDeleteObserver(observer).getBinder(), userId, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePackageVersioned(VersionedPackage versionedPackage, final IPackageDeleteObserver2 observer, final int userId, final int deleteFlags) {
        int[] nArray;
        boolean deleteAllUsers;
        String internalPackageName;
        final int callingUid = Binder.getCallingUid();
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        final boolean canViewInstantApps = this.canViewInstantApps(callingUid, userId);
        Preconditions.checkNotNull(versionedPackage);
        Preconditions.checkNotNull(observer);
        Preconditions.checkArgumentInRange(versionedPackage.getVersionCode(), -1, Integer.MAX_VALUE, "versionCode must be >= -1");
        final String packageName = versionedPackage.getPackageName();
        final int versionCode = versionedPackage.getVersionCode();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            internalPackageName = this.resolveInternalPackageNameLPr(versionedPackage.getPackageName(), versionedPackage.getVersionCode());
        }
        int uid = Binder.getCallingUid();
        if (!this.isOrphaned(internalPackageName) && !this.isCallerAllowedToSilentlyUninstall(uid, internalPackageName)) {
            try {
                Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
                intent.setData(Uri.fromParts(PACKAGE_SCHEME, packageName, null));
                intent.putExtra("android.content.pm.extra.CALLBACK", observer.asBinder());
                observer.onUserActionRequired(intent);
            }
            catch (RemoteException intent) {
                // empty catch block
            }
            return;
        }
        boolean bl = deleteAllUsers = (deleteFlags & 2) != 0;
        if (deleteAllUsers) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        final int[] users = nArray;
        if (UserHandle.getUserId(uid) != userId || deleteAllUsers && users.length > 1) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "deletePackage for user " + userId);
        }
        if (this.isUserRestricted(userId, "no_uninstall_apps")) {
            try {
                observer.onPackageDeleted(packageName, -3, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        if (!deleteAllUsers && this.getBlockUninstallForUser(internalPackageName, userId)) {
            try {
                observer.onPackageDeleted(packageName, -4, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                int returnCode;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(internalPackageName);
                boolean doDeletePackage = true;
                if (ps != null) {
                    boolean targetIsInstantApp = ps.getInstantApp(UserHandle.getUserId(callingUid));
                    boolean bl = doDeletePackage = !targetIsInstantApp || canViewInstantApps;
                }
                if (doDeletePackage) {
                    if (!deleteAllUsers) {
                        returnCode = PackageManagerService.this.deletePackageX(internalPackageName, versionCode, userId, deleteFlags);
                    } else {
                        int[] blockUninstallUserIds = PackageManagerService.this.getBlockUninstallForUsers(internalPackageName, users);
                        if (ArrayUtils.isEmpty(blockUninstallUserIds)) {
                            returnCode = PackageManagerService.this.deletePackageX(internalPackageName, versionCode, userId, deleteFlags);
                        } else {
                            int userFlags = deleteFlags & 0xFFFFFFFD;
                            for (int userId2 : users) {
                                if (ArrayUtils.contains(blockUninstallUserIds, userId2) || (returnCode = PackageManagerService.this.deletePackageX(internalPackageName, versionCode, userId2, userFlags)) == 1) continue;
                                Slog.w(PackageManagerService.TAG, "Package delete failed for user " + userId2 + ", returnCode " + returnCode);
                            }
                            returnCode = -4;
                        }
                    }
                } else {
                    returnCode = -1;
                }
                try {
                    observer.onPackageDeleted(packageName, returnCode, null);
                }
                catch (RemoteException e) {
                    Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                }
            }
        });
    }

    private String resolveExternalPackageNameLPr(PackageParser.Package pkg) {
        if (pkg.staticSharedLibName != null) {
            return pkg.manifestPackageName;
        }
        return pkg.packageName;
    }

    private String resolveInternalPackageNameLPr(String packageName, int versionCode) {
        String normalizedPackageName = this.mSettings.getRenamedPackageLPr(packageName);
        SparseArray<SharedLibraryEntry> versionedLib = this.mStaticLibsByDeclaringPackage.get(packageName = normalizedPackageName != null ? normalizedPackageName : packageName);
        if (versionedLib == null || versionedLib.size() <= 0) {
            return packageName;
        }
        SparseIntArray versionsCallerCanSee = null;
        int callingAppId = UserHandle.getAppId(Binder.getCallingUid());
        if (callingAppId != 1000 && callingAppId != 2000 && callingAppId != 0) {
            versionsCallerCanSee = new SparseIntArray();
            String libName = versionedLib.valueAt((int)0).info.getName();
            String[] uidPackages = this.getPackagesForUid(Binder.getCallingUid());
            if (uidPackages != null) {
                for (String uidPackage : uidPackages) {
                    PackageSetting ps = this.mSettings.getPackageLPr(uidPackage);
                    int libIdx = ArrayUtils.indexOf(ps.usesStaticLibraries, libName);
                    if (libIdx < 0) continue;
                    int libVersion = ps.usesStaticLibrariesVersions[libIdx];
                    versionsCallerCanSee.append(libVersion, libVersion);
                }
            }
        }
        if (versionsCallerCanSee != null && versionsCallerCanSee.size() <= 0) {
            return packageName;
        }
        SharedLibraryEntry highestVersion = null;
        int versionCount = versionedLib.size();
        for (int i = 0; i < versionCount; ++i) {
            SharedLibraryEntry libEntry = versionedLib.valueAt(i);
            if (versionsCallerCanSee != null && versionsCallerCanSee.indexOfKey(libEntry.info.getVersion()) < 0) continue;
            int libVersionCode = libEntry.info.getDeclaringPackage().getVersionCode();
            if (versionCode != -1) {
                if (libVersionCode != versionCode) continue;
                return libEntry.apk;
            }
            if (highestVersion == null) {
                highestVersion = libEntry;
                continue;
            }
            if (libVersionCode <= highestVersion.info.getDeclaringPackage().getVersionCode()) continue;
            highestVersion = libEntry;
        }
        if (highestVersion != null) {
            return highestVersion.apk;
        }
        return packageName;
    }

    private boolean isCallerAllowedToSilentlyUninstall(int callingUid, String pkgName) {
        if (callingUid == 2000 || callingUid == 0 || UserHandle.getAppId(callingUid) == 1000) {
            return true;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUid == this.getPackageUid(this.getInstallerPackageName(pkgName), 0, callingUserId)) {
            return true;
        }
        if (this.mRequiredVerifierPackage != null && callingUid == this.getPackageUid(this.mRequiredVerifierPackage, 0, callingUserId)) {
            return true;
        }
        if (this.mRequiredUninstallerPackage != null && callingUid == this.getPackageUid(this.mRequiredUninstallerPackage, 0, callingUserId)) {
            return true;
        }
        return this.mStorageManagerPackage != null && callingUid == this.getPackageUid(this.mStorageManagerPackage, 0, callingUserId);
    }

    private int[] getBlockUninstallForUsers(String packageName, int[] userIds) {
        int[] result = EMPTY_INT_ARRAY;
        for (int userId : userIds) {
            if (!this.getBlockUninstallForUser(packageName, userId)) continue;
            result = ArrayUtils.appendInt(result, userId);
        }
        return result;
    }

    @Override
    public boolean isPackageDeviceAdminOnAnyUser(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null && !this.isCallerSameApp(packageName, callingUid)) {
            return false;
        }
        return this.isPackageDeviceAdmin(packageName, -1);
    }

    private boolean isPackageDeviceAdmin(String packageName, int userId) {
        IDevicePolicyManager dpm = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
        try {
            if (dpm != null) {
                String deviceOwnerPackageName;
                ComponentName deviceOwnerComponentName = dpm.getDeviceOwnerComponent(false);
                String string2 = deviceOwnerPackageName = deviceOwnerComponentName == null ? null : deviceOwnerComponentName.getPackageName();
                if (packageName.equals(deviceOwnerPackageName)) {
                    return true;
                }
                int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
                for (int i = 0; i < users.length; ++i) {
                    if (!dpm.packageHasActiveAdmins(packageName, users[i])) continue;
                    return true;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private boolean shouldKeepUninstalledPackageLPr(String packageName) {
        return this.mKeepUninstalledPackages != null && this.mKeepUninstalledPackages.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deletePackageX(String packageName, int versionCode, int userId, int deleteFlags) {
        boolean res;
        Object libEntry;
        int[] allUsers;
        int removeUser;
        PackageRemovedInfo info = new PackageRemovedInfo(this);
        int n = removeUser = (deleteFlags & 2) != 0 ? -1 : userId;
        if (this.isPackageDeviceAdmin(packageName, removeUser)) {
            Slog.w(TAG, "Not removing package " + packageName + ": has active device admin");
            return -2;
        }
        PackageSetting uninstalledPs = null;
        PackageParser.Package pkg = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            uninstalledPs = this.mSettings.mPackages.get(packageName);
            if (uninstalledPs == null) {
                Slog.w(TAG, "Not removing non-existent package " + packageName);
                return -1;
            }
            if (versionCode != -1 && uninstalledPs.versionCode != versionCode) {
                Slog.w(TAG, "Not removing package " + packageName + " with versionCode " + uninstalledPs.versionCode + " != " + versionCode);
                return -1;
            }
            pkg = this.mPackages.get(packageName);
            allUsers = sUserManager.getUserIds();
            if (pkg != null && pkg.staticSharedLibName != null && (libEntry = this.getSharedLibraryEntryLPr(pkg.staticSharedLibName, pkg.staticSharedLibVersion)) != null) {
                for (int currUserId : allUsers) {
                    List<VersionedPackage> libClientPackages;
                    if (removeUser != -1 && removeUser != currUserId || ArrayUtils.isEmpty(libClientPackages = this.getPackagesUsingSharedLibraryLPr(((SharedLibraryEntry)libEntry).info, 0, currUserId))) continue;
                    Slog.w(TAG, "Not removing package " + pkg.manifestPackageName + " hosting lib " + ((SharedLibraryEntry)libEntry).info.getName() + " version " + ((SharedLibraryEntry)libEntry).info.getVersion() + " used by " + libClientPackages + " for user " + currUserId);
                    return -6;
                }
            }
            info.origUsers = uninstalledPs.queryInstalledUsers(allUsers, true);
        }
        int freezeUser = PackageManagerService.isUpdatedSystemApp(uninstalledPs) && (deleteFlags & 4) == 0 ? -1 : removeUser;
        libEntry = this.mInstallLock;
        synchronized (libEntry) {
            try (PackageFreezer packageFreezer = this.freezePackageForDelete(packageName, freezeUser, deleteFlags, "deletePackageX");){
                res = this.deletePackageLIF(packageName, UserHandle.of(removeUser), true, allUsers, deleteFlags | Integer.MIN_VALUE, info, true, null);
            }
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                if (res) {
                    if (pkg != null) {
                        this.mInstantAppRegistry.onPackageUninstalledLPw(pkg, info.removedUsers);
                    }
                    this.updateSequenceNumberLP(uninstalledPs, info.removedUsers);
                    this.updateInstantAppInstallerLocked(packageName);
                }
            }
        }
        if (res) {
            boolean killApp = (deleteFlags & 8) == 0;
            info.sendPackageRemovedBroadcasts(killApp);
            info.sendSystemPackageUpdatedBroadcasts();
            info.sendSystemPackageAppearedBroadcasts();
        }
        Runtime.getRuntime().gc();
        if (info.args != null) {
            Object object = this.mInstallLock;
            synchronized (object) {
                info.args.doPostDeleteLI(true);
            }
        }
        return res ? 1 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageDataLIF(PackageSetting ps, int[] allUserHandles, PackageRemovedInfo outInfo, int flags, boolean writeSettings) {
        PackageSetting deletedPs;
        PackageParser.Package deletedPkg;
        String packageName = ps.name;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            deletedPkg = this.mPackages.get(packageName);
            deletedPs = this.mSettings.mPackages.get(packageName);
            if (outInfo != null) {
                outInfo.removedPackage = packageName;
                outInfo.installerPackageName = ps.installerPackageName;
                outInfo.isStaticSharedLib = deletedPkg != null && deletedPkg.staticSharedLibName != null;
                outInfo.populateUsers(deletedPs == null ? null : deletedPs.queryInstalledUsers(sUserManager.getUserIds(), true), deletedPs);
            }
        }
        this.removePackageLI(ps, (flags & Integer.MIN_VALUE) != 0);
        if ((flags & 1) == 0) {
            PackageParser.Package resolvedPkg;
            if (deletedPkg != null) {
                resolvedPkg = deletedPkg;
            } else {
                resolvedPkg = new PackageParser.Package(ps.name);
                resolvedPkg.setVolumeUuid(ps.volumeUuid);
            }
            this.destroyAppDataLIF(resolvedPkg, -1, 3);
            this.destroyAppProfilesLIF(resolvedPkg, -1);
            if (outInfo != null) {
                outInfo.dataRemoved = true;
            }
            this.schedulePackageCleaning(packageName, -1, true);
        }
        int removedAppId = -1;
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            boolean installedStateChanged = false;
            if (deletedPs != null) {
                if ((flags & 1) == 0) {
                    this.clearIntentFilterVerificationsLPw(deletedPs.name, -1);
                    this.clearDefaultBrowserIfNeeded(packageName);
                    this.mSettings.mKeySetManagerService.removeAppKeySetDataLPw(packageName);
                    removedAppId = this.mSettings.removePackageLPw(packageName);
                    if (outInfo != null) {
                        outInfo.removedAppId = removedAppId;
                    }
                    this.updatePermissionsLPw(deletedPs.name, null, 0);
                    if (deletedPs.sharedUser != null) {
                        for (int userId : UserManagerService.getInstance().getUserIds()) {
                            int userIdToKill = this.mSettings.updateSharedUserPermsLPw(deletedPs, userId);
                            if (userIdToKill != -1 && userIdToKill < 0) continue;
                            this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    PackageManagerService.this.killApplication(deletedPs.name, deletedPs.appId, PackageManagerService.KILL_APP_REASON_GIDS_CHANGED);
                                }
                            });
                            break;
                        }
                    }
                    this.clearPackagePreferredActivitiesLPw(deletedPs.name, -1);
                }
                if (allUserHandles != null && outInfo != null && outInfo.origUsers != null) {
                    for (int userId : allUserHandles) {
                        boolean installed = ArrayUtils.contains(outInfo.origUsers, userId);
                        if (installed != ps.getInstalled(userId)) {
                            installedStateChanged = true;
                        }
                        ps.setInstalled(installed, userId);
                    }
                }
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
            if (installedStateChanged) {
                this.mSettings.writeKernelMappingLPr(ps);
            }
        }
        if (removedAppId != -1) {
            PackageManagerService.removeKeystoreDataIfNeeded(-1, removedAppId);
        }
    }

    static boolean locationIsPrivileged(File path) {
        try {
            String privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app").getCanonicalPath();
            return path.getCanonicalPath().startsWith(privilegedAppDir);
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSystemPackageLIF(PackageParser.Package deletedPkg, PackageSetting deletedPs, int[] allUserHandles, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageParser.Package newPkg;
        PackageSetting disabledPs;
        if (deletedPs.parentPackageName != null) {
            Slog.w(TAG, "Attempt to delete child system package " + deletedPkg.packageName);
            return false;
        }
        boolean applyUserRestrictions = allUserHandles != null && outInfo.origUsers != null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            disabledPs = this.mSettings.getDisabledSystemPkgLPr(deletedPs.name);
        }
        if (disabledPs == null) {
            Slog.w(TAG, "Attempt to delete unknown system package " + deletedPkg.packageName);
            return false;
        }
        outInfo.isRemovedPackageSystemUpdate = true;
        if (outInfo.removedChildPackages != null) {
            int childCount = deletedPs.childPackageNames != null ? deletedPs.childPackageNames.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageRemovedInfo childInfo;
                String childPackageName = (String)deletedPs.childPackageNames.get(i);
                if (disabledPs.childPackageNames == null || !disabledPs.childPackageNames.contains(childPackageName) || (childInfo = outInfo.removedChildPackages.get(childPackageName)) == null) continue;
                childInfo.isRemovedPackageSystemUpdate = true;
            }
        }
        flags = disabledPs.versionCode < deletedPs.versionCode ? (flags &= 0xFFFFFFFE) : (flags |= 1);
        boolean ret = this.deleteInstalledPackageLIF(deletedPs, true, flags, allUserHandles, outInfo, writeSettings, disabledPs.pkg);
        if (!ret) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> i = this.mPackages;
        synchronized (i) {
            this.enableSystemPackageLPw(disabledPs.pkg);
            this.removeNativeBinariesLI(deletedPs);
        }
        int parseFlags = this.mDefParseFlags | 4 | 1 | 0x40;
        if (PackageManagerService.locationIsPrivileged(disabledPs.codePath)) {
            parseFlags |= 0x80;
        }
        try {
            newPkg = this.scanPackageTracedLI(disabledPs.codePath, parseFlags, 0, 0L, null);
        }
        catch (PackageManagerException e) {
            Slog.w(TAG, "Failed to restore system package:" + deletedPkg.packageName + ": " + e.getMessage());
            return false;
        }
        try {
            this.updateSharedLibrariesLPr(newPkg, null);
        }
        catch (PackageManagerException e) {
            Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
        }
        this.prepareAppDataAfterInstallLIF(newPkg);
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            PackageSetting ps = this.mSettings.mPackages.get(newPkg.packageName);
            ps.getPermissionsState().copyFrom(deletedPs.getPermissionsState());
            this.updatePermissionsLPw(newPkg.packageName, newPkg, 3);
            if (applyUserRestrictions) {
                boolean installedStateChanged = false;
                for (int userId : allUserHandles) {
                    boolean installed = ArrayUtils.contains(outInfo.origUsers, userId);
                    if (installed != ps.getInstalled(userId)) {
                        installedStateChanged = true;
                    }
                    ps.setInstalled(installed, userId);
                    this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
                }
                this.mSettings.writeAllUsersPackageRestrictionsLPr();
                if (installedStateChanged) {
                    this.mSettings.writeKernelMappingLPr(ps);
                }
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteInstalledPackageLIF(PackageSetting ps, boolean deleteCodeAndResources, int flags, int[] allUserHandles, PackageRemovedInfo outInfo, boolean writeSettings, PackageParser.Package replacingPackage) {
        Object childPackageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (outInfo != null) {
                outInfo.uid = ps.appId;
            }
            if (outInfo != null && outInfo.removedChildPackages != null) {
                int childCount = ps.childPackageNames != null ? ps.childPackageNames.size() : 0;
                for (int i = 0; i < childCount; ++i) {
                    childPackageName = (String)ps.childPackageNames.get(i);
                    PackageSetting childPs = this.mSettings.mPackages.get(childPackageName);
                    if (childPs == null) {
                        return false;
                    }
                    PackageRemovedInfo childInfo = outInfo.removedChildPackages.get(childPackageName);
                    if (childInfo == null) continue;
                    childInfo.uid = childPs.appId;
                }
            }
        }
        this.removePackageDataLIF(ps, allUserHandles, outInfo, flags, writeSettings);
        int childCount = ps.childPackageNames != null ? ps.childPackageNames.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            PackageSetting childPs;
            childPackageName = this.mPackages;
            synchronized (childPackageName) {
                childPs = this.mSettings.getPackageLPr((String)ps.childPackageNames.get(i));
            }
            if (childPs == null) continue;
            PackageRemovedInfo childOutInfo = outInfo != null && outInfo.removedChildPackages != null ? outInfo.removedChildPackages.get(childPs.name) : null;
            int deleteFlags = (flags & 1) != 0 && replacingPackage != null && !replacingPackage.hasChildPackage(childPs.name) ? flags & 0xFFFFFFFE : flags;
            this.removePackageDataLIF(childPs, allUserHandles, childOutInfo, deleteFlags, writeSettings);
        }
        if (ps.parentPackageName == null && deleteCodeAndResources && outInfo != null) {
            outInfo.args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, InstructionSets.getAppDexInstructionSets(ps));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockUninstallForUser(String packageName, boolean blockUninstall, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg != null && pkg.staticSharedLibName != null) {
                Slog.w(TAG, "Cannot block uninstall of package: " + packageName + " providing static shared library: " + pkg.staticSharedLibName);
                return false;
            }
            this.mSettings.setBlockUninstallLPw(userId, packageName, blockUninstall);
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBlockUninstallForUser(String packageName, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || this.filterAppAccessLPr(ps, Binder.getCallingUid(), userId)) {
                return false;
            }
            return this.mSettings.getBlockUninstallLPr(userId, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setRequiredForSystemUser(String packageName, boolean systemUserApp) {
        PackageManagerService.enforceSystemOrRoot("setRequiredForSystemUser can only be run by the system or root");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Log.w(TAG, "Package doesn't exist: " + packageName);
                return false;
            }
            ps.pkgPrivateFlags = systemUserApp ? (ps.pkgPrivateFlags |= 0x200) : (ps.pkgPrivateFlags &= 0xFFFFFDFF);
            this.mSettings.writeLPr();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePackageLIF(String packageName, UserHandle user, boolean deleteCodeAndResources, int[] allUserHandles, int flags, PackageRemovedInfo outInfo, boolean writeSettings, PackageParser.Package replacingPackage) {
        PackageRemovedInfo childInfo;
        PackageSetting ps;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                return false;
            }
            if (!(ps.parentPackageName == null || PackageManagerService.isSystemApp(ps) && (flags & 4) == 0)) {
                int removedUserId;
                int n = removedUserId = user != null ? user.getIdentifier() : -1;
                if (!this.clearPackageStateForUserLIF(ps, removedUserId, outInfo)) {
                    return false;
                }
                this.markPackageUninstalledForUserLPw(ps, user);
                this.scheduleWritePackageRestrictionsLocked(user);
                return true;
            }
        }
        if (!(PackageManagerService.isSystemApp(ps) && (flags & 4) == 0 || user == null || user.getIdentifier() == -1)) {
            this.markPackageUninstalledForUserLPw(ps, user);
            if (!PackageManagerService.isSystemApp(ps)) {
                boolean keepUninstalledPackage = this.shouldKeepUninstalledPackageLPr(packageName);
                if (ps.isAnyInstalled(sUserManager.getUserIds()) || keepUninstalledPackage) {
                    if (!this.clearPackageStateForUserLIF(ps, user.getIdentifier(), outInfo)) {
                        return false;
                    }
                    this.scheduleWritePackageRestrictionsLocked(user);
                    return true;
                }
                ps.setInstalled(true, user.getIdentifier());
                this.mSettings.writeKernelMappingLPr(ps);
            } else {
                if (!this.clearPackageStateForUserLIF(ps, user.getIdentifier(), outInfo)) {
                    return false;
                }
                this.scheduleWritePackageRestrictionsLocked(user);
                return true;
            }
        }
        if (ps.childPackageNames != null && outInfo != null) {
            ArrayMap<String, PackageParser.Package> keepUninstalledPackage = this.mPackages;
            synchronized (keepUninstalledPackage) {
                int childCount = ps.childPackageNames.size();
                outInfo.removedChildPackages = new ArrayMap(childCount);
                for (int i = 0; i < childCount; ++i) {
                    String childPackageName = (String)ps.childPackageNames.get(i);
                    childInfo = new PackageRemovedInfo(this);
                    childInfo.removedPackage = childPackageName;
                    childInfo.installerPackageName = ps.installerPackageName;
                    outInfo.removedChildPackages.put(childPackageName, childInfo);
                    PackageSetting childPs = this.mSettings.getPackageLPr(childPackageName);
                    if (childPs == null) continue;
                    childInfo.origUsers = childPs.queryInstalledUsers(allUserHandles, true);
                }
            }
        }
        boolean ret = false;
        ret = PackageManagerService.isSystemApp(ps) ? this.deleteSystemPackageLIF(ps.pkg, ps, allUserHandles, flags, outInfo, writeSettings) : this.deleteInstalledPackageLIF(ps, deleteCodeAndResources, flags, allUserHandles, outInfo, writeSettings, replacingPackage);
        if (outInfo != null) {
            boolean bl = outInfo.removedForAllUsers = this.mPackages.get(ps.name) == null;
            if (outInfo.removedChildPackages != null) {
                ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
                synchronized (arrayMap2) {
                    int childCount = outInfo.removedChildPackages.size();
                    for (int i = 0; i < childCount; ++i) {
                        childInfo = outInfo.removedChildPackages.valueAt(i);
                        if (childInfo == null) continue;
                        childInfo.removedForAllUsers = this.mPackages.get(childInfo.removedPackage) == null;
                    }
                }
            }
            if (PackageManagerService.isSystemApp(ps)) {
                ArrayMap<String, PackageParser.Package> arrayMap3 = this.mPackages;
                synchronized (arrayMap3) {
                    PackageSetting updatedPs = this.mSettings.getPackageLPr(ps.name);
                    int childCount = updatedPs.childPackageNames != null ? updatedPs.childPackageNames.size() : 0;
                    for (int i = 0; i < childCount; ++i) {
                        PackageSetting childPs;
                        String childPackageName = (String)updatedPs.childPackageNames.get(i);
                        if (outInfo.removedChildPackages != null && outInfo.removedChildPackages.indexOfKey(childPackageName) >= 0 || (childPs = this.mSettings.getPackageLPr(childPackageName)) == null) continue;
                        PackageInstalledInfo installRes = new PackageInstalledInfo();
                        installRes.name = childPackageName;
                        installRes.newUsers = childPs.queryInstalledUsers(allUserHandles, true);
                        installRes.pkg = this.mPackages.get(childPackageName);
                        installRes.uid = childPs.pkg.applicationInfo.uid;
                        if (outInfo.appearedChildPackages == null) {
                            outInfo.appearedChildPackages = new ArrayMap();
                        }
                        outInfo.appearedChildPackages.put(childPackageName, installRes);
                    }
                }
            }
        }
        return ret;
    }

    private void markPackageUninstalledForUserLPw(PackageSetting ps, UserHandle user) {
        int[] userIds;
        int[] nArray;
        if (user == null || user.getIdentifier() == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = user.getIdentifier();
        }
        for (int nextUserId : userIds = nArray) {
            ps.setUserState(nextUserId, 0L, 0, false, true, true, false, false, false, null, null, null, ps.readUserState((int)nextUserId).domainVerificationStatus, 0, 0);
        }
        this.mSettings.writeKernelMappingLPr(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearPackageStateForUserLIF(PackageSetting ps, int userId, PackageRemovedInfo outInfo) {
        int[] userIds;
        int[] nArray;
        PackageParser.Package pkg;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(ps.name);
        }
        if (userId == -1) {
            nArray = sUserManager.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        for (int nextUserId : userIds = nArray) {
            this.destroyAppDataLIF(pkg, userId, 3);
            this.destroyAppProfilesLIF(pkg, userId);
            this.clearDefaultBrowserIfNeededForUser(ps.name, userId);
            PackageManagerService.removeKeystoreDataIfNeeded(nextUserId, ps.appId);
            this.schedulePackageCleaning(ps.name, nextUserId, false);
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                if (this.clearPackagePreferredActivitiesLPw(ps.name, nextUserId)) {
                    this.scheduleWritePackageRestrictionsLocked(nextUserId);
                }
                this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, nextUserId);
            }
        }
        if (outInfo != null) {
            outInfo.removedPackage = ps.name;
            outInfo.installerPackageName = ps.installerPackageName;
            outInfo.isStaticSharedLib = pkg != null && pkg.staticSharedLibName != null;
            outInfo.removedAppId = ps.appId;
            outInfo.removedUsers = userIds;
            outInfo.broadcastUsers = userIds;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExternalStorageDataSync(String packageName, int userId, boolean allData) {
        boolean mounted;
        if (DEFAULT_CONTAINER_PACKAGE.equals(packageName)) {
            return;
        }
        if (Environment.isExternalStorageEmulated()) {
            mounted = true;
        } else {
            String status = Environment.getExternalStorageState();
            boolean bl = mounted = status.equals("mounted") || status.equals("mounted_ro");
        }
        if (!mounted) {
            return;
        }
        Intent containerIntent = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
        int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
        ClearStorageConnection conn = new ClearStorageConnection();
        if (this.mContext.bindServiceAsUser(containerIntent, conn, 1, UserHandle.SYSTEM)) {
            try {
                for (int curUser : users) {
                    long timeout = SystemClock.uptimeMillis() + 5000L;
                    ClearStorageConnection clearStorageConnection = conn;
                    synchronized (clearStorageConnection) {
                        long now;
                        while (conn.mContainerService == null && (now = SystemClock.uptimeMillis()) < timeout) {
                            try {
                                conn.wait(timeout - now);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (conn.mContainerService == null) {
                        return;
                    }
                    Environment.UserEnvironment userEnv = new Environment.UserEnvironment(curUser);
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppCacheDirs(packageName));
                    if (!allData) continue;
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppDataDirs(packageName));
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppMediaDirs(packageName));
                }
            }
            finally {
                this.mContext.unbindService(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearApplicationProfileData(String packageName) {
        PackageParser.Package pkg;
        PackageManagerService.enforceSystemOrRoot("Only the system can clear all profile data");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
        }
        try (PackageFreezer freezer = this.freezePackage(packageName, "clearApplicationProfileData");){
            Object object = this.mInstallLock;
            synchronized (object) {
                this.clearAppProfilesLIF(pkg, -1);
            }
        }
    }

    @Override
    public void clearApplicationUserData(final String packageName, final IPackageDataObserver observer, final int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_USER_DATA", null);
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "clear application data");
        PackageSetting ps = this.mSettings.getPackageLPr(packageName);
        if (ps != null && this.filterAppAccessLPr(ps, callingUid, userId)) {
            return;
        }
        if (this.mProtectedPackages.isPackageDataProtected(userId, packageName)) {
            throw new SecurityException("Cannot clear data for a protected package: " + packageName);
        }
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DeviceStorageMonitorInternal dsm;
                boolean succeeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                try (PackageFreezer freezer = PackageManagerService.this.freezePackage(packageName, "clearApplicationUserData");){
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mInstallLock;
                    synchronized (arrayMap) {
                        succeeded = PackageManagerService.this.clearApplicationUserDataLIF(packageName, userId);
                    }
                    PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, true);
                    arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.mInstantAppRegistry.deleteInstantApplicationMetadataLPw(packageName, userId);
                    }
                }
                if (succeeded && (dsm = LocalServices.getService(DeviceStorageMonitorInternal.class)) != null) {
                    dsm.checkMemory();
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearApplicationUserDataLIF(String packageName, int userId) {
        PackageParser.Package pkg;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            pkg = this.mPackages.get(packageName);
            if (pkg == null && (ps = this.mSettings.mPackages.get(packageName)) != null) {
                pkg = ps.pkg;
            }
            if (pkg == null) {
                Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                return false;
            }
            ps = (PackageSetting)pkg.mExtras;
            this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
        }
        this.clearAppDataLIF(pkg, userId, 3);
        int appId = UserHandle.getAppId(pkg.applicationInfo.uid);
        PackageManagerService.removeKeystoreDataIfNeeded(userId, appId);
        UserManagerInternal umInternal = this.getUserManagerInternal();
        int flags = umInternal.isUserUnlockingOrUnlocked(userId) ? 3 : (umInternal.isUserRunning(userId) ? 1 : 0);
        this.prepareAppDataContentsLIF(pkg, userId, flags);
        return true;
    }

    private void resetUserChangesToRuntimePermissionsAndFlagsLPw(int userId) {
        int packageCount = this.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageParser.Package pkg = this.mPackages.valueAt(i);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
        }
    }

    private void resetNetworkPolicies(int userId) {
        LocalServices.getService(NetworkPolicyManagerInternal.class).resetUserState(userId);
    }

    private void resetUserChangesToRuntimePermissionsAndFlagsLPw(PackageSetting ps, final int userId) {
        if (ps.pkg == null) {
            return;
        }
        int userSettableMask = 75;
        int policyOrSystemFlags = 20;
        boolean writeInstallPermissions = false;
        boolean writeRuntimePermissions = false;
        int permissionCount = ps.pkg.requestedPermissions.size();
        for (int i = 0; i < permissionCount; ++i) {
            String permission2 = ps.pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(permission2);
            if (bp == null) continue;
            if (ps.sharedUser != null) {
                boolean used = false;
                int packageCount = ps.sharedUser.packages.size();
                for (int j = 0; j < packageCount; ++j) {
                    PackageSetting pkg = ps.sharedUser.packages.valueAt(j);
                    if (pkg.pkg == null || pkg.pkg.packageName.equals(ps.pkg.packageName) || !pkg.pkg.requestedPermissions.contains(permission2)) continue;
                    used = true;
                    break;
                }
                if (used) continue;
            }
            PermissionsState permissionsState = ps.getPermissionsState();
            int oldFlags = permissionsState.getPermissionFlags(bp.name, userId);
            boolean hasInstallState = permissionsState.getInstallPermissionState(bp.name) != null;
            int flags = 0;
            if (this.mPermissionReviewRequired && ps.pkg.applicationInfo.targetSdkVersion < 23) {
                flags |= 0x40;
            }
            if (permissionsState.updatePermissionFlags(bp, userId, 75, flags)) {
                if (hasInstallState) {
                    writeInstallPermissions = true;
                } else {
                    writeRuntimePermissions = true;
                }
            }
            if (!bp.isRuntime() || (oldFlags & 0x14) != 0) continue;
            if ((oldFlags & 0x20) != 0) {
                if (permissionsState.grantRuntimePermission(bp, userId) == -1) continue;
                writeRuntimePermissions = true;
                continue;
            }
            if ((flags & 0x40) != 0) continue;
            int revokeResult = permissionsState.revokeRuntimePermission(bp, userId);
            switch (revokeResult) {
                case 0: 
                case 1: {
                    writeRuntimePermissions = true;
                    final int appId = ps.appId;
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PackageManagerService.this.killUid(appId, userId, PackageManagerService.KILL_APP_REASON_PERMISSIONS_REVOKED);
                        }
                    });
                }
            }
        }
        if (writeRuntimePermissions) {
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, true);
        }
        if (writeInstallPermissions) {
            this.mSettings.writeLPr();
        }
    }

    private static void removeKeystoreDataIfNeeded(int userId, int appId) {
        if (appId < 0) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance();
        if (keyStore != null) {
            if (userId == -1) {
                for (int individual : sUserManager.getUserIds()) {
                    keyStore.clearUid(UserHandle.getUid(individual, appId));
                }
            } else {
                keyStore.clearUid(UserHandle.getUid(userId, appId));
            }
        } else {
            Slog.w(TAG, "Could not contact keystore to clear entries for app id " + appId);
        }
    }

    @Override
    public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
        int userId = UserHandle.getCallingUserId();
        this.deleteApplicationCacheFilesAsUser(packageName, userId, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplicationCacheFilesAsUser(final String packageName, final int userId, final IPackageDataObserver observer) {
        PackageParser.Package pkg;
        final int callingUid = Binder.getCallingUid();
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_CACHE_FILES", null);
        this.enforceCrossUserPermission(callingUid, userId, true, false, "delete application cache files");
        final int hasAccessInstantApps = this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkg = this.mPackages.get(packageName);
        }
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PackageSetting ps = pkg == null ? null : (PackageSetting)pkg.mExtras;
                boolean doClearData = true;
                if (ps != null) {
                    boolean targetIsInstantApp = ps.getInstantApp(UserHandle.getUserId(callingUid));
                    boolean bl = doClearData = !targetIsInstantApp || hasAccessInstantApps == 0;
                }
                if (doClearData) {
                    Object targetIsInstantApp = PackageManagerService.this.mInstallLock;
                    synchronized (targetIsInstantApp) {
                        int flags = 3;
                        PackageManagerService.this.clearAppDataLIF(pkg, userId, 259);
                        PackageManagerService.this.clearAppDataLIF(pkg, userId, 515);
                    }
                    PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, false);
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, true);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    @Override
    public void getPackageSizeInfo(String packageName, int userHandle, IPackageStatsObserver observer) {
        throw new UnsupportedOperationException("Shame on you for calling the hidden API getPackageSizeInfo(). Shame!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPackageSizeInfoLI(String packageName, int userId, PackageStats stats) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Slog.w(TAG, "Failed to find settings for " + packageName);
                return false;
            }
        }
        String[] packageNames = new String[]{packageName};
        long[] ceDataInodes = new long[]{ps.getCeDataInode(userId)};
        String[] codePaths = new String[]{ps.codePathString};
        try {
            this.mInstaller.getAppSize(ps.volumeUuid, packageNames, userId, 0, ps.appId, ceDataInodes, codePaths, stats);
            if (PackageManagerService.isSystemApp(ps) && !PackageManagerService.isUpdatedSystemApp(ps)) {
                stats.codeSize = 0L;
            }
            stats.dataSize -= stats.cacheSize;
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, String.valueOf(e));
            return false;
        }
        return true;
    }

    private int getUidTargetSdkVersionLockedLPr(int uid) {
        Object obj = this.mSettings.getUserIdLPr(uid);
        if (obj instanceof SharedUserSetting) {
            SharedUserSetting sus = (SharedUserSetting)obj;
            int vers = 10000;
            for (PackageSetting ps : sus.packages) {
                int v;
                if (ps.pkg == null || (v = ps.pkg.applicationInfo.targetSdkVersion) >= vers) continue;
                vers = v;
            }
            return vers;
        }
        if (obj instanceof PackageSetting) {
            PackageSetting ps = (PackageSetting)obj;
            if (ps.pkg != null) {
                return ps.pkg.applicationInfo.targetSdkVersion;
            }
        }
        return 10000;
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Adding preferred");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreferredActivityInternal(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, boolean always, int userId, String opname) {
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "add preferred activity");
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring addPreferredActivity() from uid " + callingUid);
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            PreferredIntentResolver pir = this.mSettings.editPreferredActivitiesLPw(userId);
            Slog.i(TAG, opname + " activity " + activity.flattenToShortString() + " for user " + userId + ":");
            filter.dump(new LogPrinter(4, TAG), "  ");
            pir.addFilter(new PreferredActivity(filter, match, set, activity, always));
            this.scheduleWritePackageRestrictionsLocked(userId);
            this.postPreferredActivityChangedBroadcast(userId);
        }
    }

    private void postPreferredActivityChangedBroadcast(int userId) {
        this.mHandler.post(() -> {
            IActivityManager am = ActivityManager.getService();
            if (am == null) {
                return;
            }
            Intent intent = new Intent("android.intent.action.ACTION_PREFERRED_ACTIVITY_CHANGED");
            intent.putExtra("android.intent.extra.user_handle", userId);
            try {
                am.broadcastIntent(null, intent, null, null, 0, null, null, null, -1, null, false, false, userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        if (filter.countActions() != 1) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have only 1 action.");
        }
        if (filter.countDataAuthorities() != 0 || filter.countDataPaths() != 0 || filter.countDataSchemes() > 1 || filter.countDataTypes() != 0) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have no data authorities, paths, or types; and at most one scheme.");
        }
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "replace preferred activity");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PreferredIntentResolver pir;
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring replacePreferredActivity() from uid " + Binder.getCallingUid());
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if ((pir = this.mSettings.mPreferredActivities.get(userId)) != null) {
                ArrayList existing = pir.findFilters(filter);
                if (existing != null && existing.size() == 1) {
                    PreferredActivity cur = (PreferredActivity)existing.get(0);
                    if (cur.mPref.mAlways && cur.mPref.mComponent.equals(activity) && cur.mPref.mMatch == (match & 0xFFF0000) && cur.mPref.sameSet(set)) {
                        return;
                    }
                }
                if (existing != null) {
                    for (int i = 0; i < existing.size(); ++i) {
                        PreferredActivity pa = (PreferredActivity)existing.get(i);
                        pir.removeFilter(pa);
                    }
                }
            }
            this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Replacing preferred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePreferredActivities(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if ((pkg == null || pkg.applicationInfo.uid != callingUid) && this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring clearPackagePreferredActivities() from uid " + callingUid);
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if ((ps = this.mSettings.getPackageLPr(packageName)) != null && this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return;
            }
            int user = UserHandle.getCallingUserId();
            if (this.clearPackagePreferredActivitiesLPw(packageName, user)) {
                this.scheduleWritePackageRestrictionsLocked(user);
            }
        }
    }

    boolean clearPackagePreferredActivitiesLPw(String packageName, int userId) {
        ArrayList<PreferredActivity> removed = null;
        boolean changed = false;
        for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
            int thisUserId = this.mSettings.mPreferredActivities.keyAt(i);
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
            if (userId != -1 && userId != thisUserId) continue;
            Iterator it = pir.filterIterator();
            while (it.hasNext()) {
                PreferredActivity pa = (PreferredActivity)it.next();
                if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                if (removed == null) {
                    removed = new ArrayList<PreferredActivity>();
                }
                removed.add(pa);
            }
            if (removed == null) continue;
            for (int j = 0; j < removed.size(); ++j) {
                PreferredActivity pa = (PreferredActivity)removed.get(j);
                pir.removeFilter(pa);
            }
            changed = true;
        }
        if (changed) {
            this.postPreferredActivityChangedBroadcast(userId);
        }
        return changed;
    }

    private void clearIntentFilterVerificationsLPw(int userId) {
        int packageCount = this.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageParser.Package pkg = this.mPackages.valueAt(i);
            this.clearIntentFilterVerificationsLPw(pkg.packageName, userId);
        }
    }

    void clearIntentFilterVerificationsLPw(String packageName, int userId) {
        if (userId == -1) {
            if (this.mSettings.removeIntentFilterVerificationLPw(packageName, sUserManager.getUserIds())) {
                for (int oneUserId : sUserManager.getUserIds()) {
                    this.scheduleWritePackageRestrictionsLocked(oneUserId);
                }
            }
        } else if (this.mSettings.removeIntentFilterVerificationLPw(packageName, userId)) {
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
    }

    void clearDefaultBrowserIfNeeded(String packageName) {
        for (int oneUserId : sUserManager.getUserIds()) {
            this.clearDefaultBrowserIfNeededForUser(packageName, oneUserId);
        }
    }

    private void clearDefaultBrowserIfNeededForUser(String packageName, int userId) {
        String defaultBrowserPackageName = this.getDefaultBrowserPackageName(userId);
        if (!TextUtils.isEmpty(defaultBrowserPackageName) && packageName.equals(defaultBrowserPackageName)) {
            this.setDefaultBrowserPackageName(null, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetApplicationPreferences(int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        long identity = Binder.clearCallingIdentity();
        try {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.clearPackagePreferredActivitiesLPw(null, userId);
                this.mSettings.applyDefaultPreferredAppsLPw(this, userId);
                this.applyFactoryDefaultBrowserLPw(userId);
                this.clearIntentFilterVerificationsLPw(userId);
                this.primeDomainVerificationsLPw(userId);
                this.resetUserChangesToRuntimePermissionsAndFlagsLPw(userId);
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
            this.resetNetworkPolicies(userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return 0;
        }
        int num = 0;
        int userId = UserHandle.getCallingUserId();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(userId);
            if (pir != null) {
                Iterator it = pir.filterIterator();
                while (it.hasNext()) {
                    PreferredActivity pa = (PreferredActivity)it.next();
                    if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                    if (outFilters != null) {
                        outFilters.add(new IntentFilter(pa));
                    }
                    if (outActivities == null) continue;
                    outActivities.add(pa.mPref.mComponent);
                }
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistentPreferredActivity(IntentFilter filter, ComponentName activity, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("addPersistentPreferredActivity can only be run by the system");
        }
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Slog.i(TAG, "Adding persistent preferred activity " + activity + " for user " + userId + ":");
            filter.dump(new LogPrinter(4, TAG), "  ");
            this.mSettings.editPersistentPreferredActivitiesLPw(userId).addFilter(new PersistentPreferredActivity(filter, activity));
            this.scheduleWritePackageRestrictionsLocked(userId);
            this.postPreferredActivityChangedBroadcast(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePersistentPreferredActivities(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("clearPackagePersistentPreferredActivities can only be run by the system");
        }
        ArrayList<PersistentPreferredActivity> removed = null;
        boolean changed = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mSettings.mPersistentPreferredActivities.size(); ++i) {
                int thisUserId = this.mSettings.mPersistentPreferredActivities.keyAt(i);
                PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.valueAt(i);
                if (userId != thisUserId) continue;
                Iterator it = ppir.filterIterator();
                while (it.hasNext()) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)it.next();
                    if (!ppa.mComponent.getPackageName().equals(packageName)) continue;
                    if (removed == null) {
                        removed = new ArrayList<PersistentPreferredActivity>();
                    }
                    removed.add(ppa);
                }
                if (removed == null) continue;
                for (int j = 0; j < removed.size(); ++j) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)removed.get(j);
                    ppir.removeFilter(ppa);
                }
                changed = true;
            }
            if (changed) {
                this.scheduleWritePackageRestrictionsLocked(userId);
                this.postPreferredActivityChangedBroadcast(userId);
            }
        }
    }

    private void restoreFromXml(XmlPullParser parser, int userId, String expectedStartTag, BlobXmlRestorer functor) throws IOException, XmlPullParserException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            return;
        }
        Slog.v(TAG, ":: restoreFromXml() : got to tag " + parser.getName());
        if (!expectedStartTag.equals(parser.getName())) {
            return;
        }
        while ((type = parser.next()) == 4) {
        }
        Slog.v(TAG, ":: stepped forward, applying functor at tag " + parser.getName());
        functor.apply(parser, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPreferredActivityBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getPreferredActivityBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_PREFERRED_BACKUP);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writePreferredActivitiesLPr(serializer, userId, true);
            }
            serializer.endTag(null, TAG_PREFERRED_BACKUP);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restorePreferredActivities(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restorePreferredActivities()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_PREFERRED_BACKUP, new BlobXmlRestorer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.mSettings.readPreferredActivitiesLPw(parser, userId);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getDefaultAppsBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getDefaultAppsBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_DEFAULT_APPS);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writeDefaultAppsLPr(serializer, userId);
            }
            serializer.endTag(null, TAG_DEFAULT_APPS);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restoreDefaultApps(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restoreDefaultApps()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_DEFAULT_APPS, new BlobXmlRestorer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.mSettings.readDefaultAppsLPw(parser, userId);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getIntentFilterVerificationBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getIntentFilterVerificationBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_INTENT_FILTER_VERIFICATION);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writeAllDomainVerificationsLPr(serializer, userId);
            }
            serializer.endTag(null, TAG_INTENT_FILTER_VERIFICATION);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restoreIntentFilterVerification(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restorePreferredActivities()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_INTENT_FILTER_VERIFICATION, new BlobXmlRestorer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.mSettings.readAllDomainVerificationsLPr(parser, userId);
                        PackageManagerService.this.mSettings.writeLPr();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPermissionGrantBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getPermissionGrantBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_PERMISSION_BACKUP);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.serializeRuntimePermissionGrantsLPr(serializer, userId);
            }
            serializer.endTag(null, TAG_PERMISSION_BACKUP);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restorePermissionGrants(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restorePermissionGrants()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_PERMISSION_BACKUP, new BlobXmlRestorer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.processRestoredPermissionGrantsLPr(parser, userId);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void serializeRuntimePermissionGrantsLPr(XmlSerializer serializer, int userId) throws IOException {
        serializer.startTag(null, TAG_ALL_GRANTS);
        int N = this.mSettings.mPackages.size();
        for (int i = 0; i < N; ++i) {
            PackageSetting ps = this.mSettings.mPackages.valueAt(i);
            boolean pkgGrantsKnown = false;
            PermissionsState packagePerms = ps.getPermissionsState();
            for (PermissionsState.PermissionState state : packagePerms.getRuntimePermissionStates(userId)) {
                boolean isGranted;
                int grantFlags = state.getFlags();
                if ((grantFlags & 0x34) != 0 || !(isGranted = state.isGranted()) && (grantFlags & 0xB) == 0) continue;
                String packageName = this.mSettings.mPackages.keyAt(i);
                if (!pkgGrantsKnown) {
                    serializer.startTag(null, TAG_GRANT);
                    serializer.attribute(null, ATTR_PACKAGE_NAME, packageName);
                    pkgGrantsKnown = true;
                }
                boolean userSet = (grantFlags & 1) != 0;
                boolean userFixed = (grantFlags & 2) != 0;
                boolean revoke = (grantFlags & 8) != 0;
                serializer.startTag(null, TAG_PERMISSION);
                serializer.attribute(null, ATTR_PERMISSION_NAME, state.getName());
                if (isGranted) {
                    serializer.attribute(null, ATTR_IS_GRANTED, "true");
                }
                if (userSet) {
                    serializer.attribute(null, ATTR_USER_SET, "true");
                }
                if (userFixed) {
                    serializer.attribute(null, ATTR_USER_FIXED, "true");
                }
                if (revoke) {
                    serializer.attribute(null, ATTR_REVOKE_ON_UPGRADE, "true");
                }
                serializer.endTag(null, TAG_PERMISSION);
            }
            if (!pkgGrantsKnown) continue;
            serializer.endTag(null, TAG_GRANT);
        }
        serializer.endTag(null, TAG_ALL_GRANTS);
    }

    private void processRestoredPermissionGrantsLPr(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        String pkgName = null;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_GRANT)) {
                pkgName = parser.getAttributeValue(null, ATTR_PACKAGE_NAME);
                continue;
            }
            if (tagName.equals(TAG_PERMISSION)) {
                PackageSetting ps;
                boolean isGranted = "true".equals(parser.getAttributeValue(null, ATTR_IS_GRANTED));
                String permName = parser.getAttributeValue(null, ATTR_PERMISSION_NAME);
                int newFlagSet = 0;
                if ("true".equals(parser.getAttributeValue(null, ATTR_USER_SET))) {
                    newFlagSet |= 1;
                }
                if ("true".equals(parser.getAttributeValue(null, ATTR_USER_FIXED))) {
                    newFlagSet |= 2;
                }
                if ("true".equals(parser.getAttributeValue(null, ATTR_REVOKE_ON_UPGRADE))) {
                    newFlagSet |= 8;
                }
                if ((ps = this.mSettings.mPackages.get(pkgName)) != null) {
                    PermissionsState perms = ps.getPermissionsState();
                    BasePermission bp = this.mSettings.mPermissions.get(permName);
                    if (bp == null) continue;
                    if (isGranted) {
                        perms.grantRuntimePermission(bp, userId);
                    }
                    if (newFlagSet == 0) continue;
                    perms.updatePermissionFlags(bp, userId, 11, newFlagSet);
                    continue;
                }
                this.mSettings.processRestoredPermissionGrantLPr(pkgName, permName, isGranted, newFlagSet, userId);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <perm-grant-backup>: " + tagName);
            XmlUtils.skipCurrentTag(parser);
        }
        this.scheduleWriteSettingsLocked();
        this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrossProfileIntentFilter(IntentFilter intentFilter, String ownerPackage, int sourceUserId, int targetUserId, int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, callingUid);
        this.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        if (intentFilter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a crossProfile intent filter with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            CrossProfileIntentFilter newFilter = new CrossProfileIntentFilter(intentFilter, ownerPackage, targetUserId, flags);
            CrossProfileIntentResolver resolver = this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId);
            ArrayList existing = resolver.findFilters(intentFilter);
            if (existing != null) {
                int size = existing.size();
                for (int i = 0; i < size; ++i) {
                    if (!newFilter.equalsIgnoreFilter((CrossProfileIntentFilter)existing.get(i))) continue;
                    return;
                }
            }
            resolver.addFilter(newFilter);
            this.scheduleWritePackageRestrictionsLocked(sourceUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCrossProfileIntentFilters(int sourceUserId, String ownerPackage) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, callingUid);
        this.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            CrossProfileIntentResolver resolver = this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId);
            ArraySet set = new ArraySet(resolver.filterSet());
            for (CrossProfileIntentFilter filter : set) {
                if (!filter.getOwnerPackage().equals(ownerPackage)) continue;
                resolver.removeFilter(filter);
            }
            this.scheduleWritePackageRestrictionsLocked(sourceUserId);
        }
    }

    private void enforceOwnerRights(String pkg, int callingUid) {
        if (UserHandle.getAppId(callingUid) == 1000) {
            return;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        PackageInfo pi = this.getPackageInfo(pkg, 0, callingUserId);
        if (pi == null) {
            throw new IllegalArgumentException("Unknown package " + pkg + " on user " + callingUserId);
        }
        if (!UserHandle.isSameApp(pi.applicationInfo.uid, callingUid)) {
            throw new SecurityException("Calling uid " + callingUid + " does not own package " + pkg);
        }
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> allHomeCandidates) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        return this.getHomeActivitiesAsUser(allHomeCandidates, UserHandle.getCallingUserId());
    }

    public void sendSessionCommitBroadcast(PackageInstaller.SessionInfo sessionInfo, int userId) {
        UserInfo parent;
        int launcherUid;
        ComponentName launcherComponent;
        UserManagerService ums = UserManagerService.getInstance();
        if (ums != null && (launcherComponent = this.getDefaultHomeActivity(launcherUid = (parent = ums.getProfileParent(userId)) != null ? parent.id : userId)) != null) {
            Intent launcherIntent = new Intent("android.content.pm.action.SESSION_COMMITTED").putExtra("android.content.pm.extra.SESSION", sessionInfo).putExtra("android.intent.extra.USER", UserHandle.of(userId)).setPackage(launcherComponent.getPackageName());
            this.mContext.sendBroadcastAsUser(launcherIntent, UserHandle.of(launcherUid));
        }
    }

    private ComponentName getDefaultHomeActivity(int userId) {
        ArrayList<ResolveInfo> allHomeCandidates = new ArrayList<ResolveInfo>();
        ComponentName cn = this.getHomeActivitiesAsUser(allHomeCandidates, userId);
        if (cn != null) {
            return cn;
        }
        int lastPriority = Integer.MIN_VALUE;
        ComponentName lastComponent = null;
        int size = allHomeCandidates.size();
        for (int i = 0; i < size; ++i) {
            ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
            if (ri.priority > lastPriority) {
                lastComponent = ri.activityInfo.getComponentName();
                lastPriority = ri.priority;
                continue;
            }
            if (ri.priority != lastPriority) continue;
            lastComponent = null;
        }
        return lastComponent;
    }

    private Intent getHomeIntent() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.addCategory("android.intent.category.DEFAULT");
        return intent;
    }

    private IntentFilter getHomeFilter() {
        IntentFilter filter = new IntentFilter("android.intent.action.MAIN");
        filter.addCategory("android.intent.category.HOME");
        filter.addCategory("android.intent.category.DEFAULT");
        return filter;
    }

    ComponentName getHomeActivitiesAsUser(List<ResolveInfo> allHomeCandidates, int userId) {
        Intent intent = this.getHomeIntent();
        List<ResolveInfo> list = this.queryIntentActivitiesInternal(intent, null, 128, userId);
        ResolveInfo preferred = this.findPreferredActivity(intent, null, 0, list, 0, true, false, false, userId);
        allHomeCandidates.clear();
        if (list != null) {
            for (ResolveInfo ri : list) {
                allHomeCandidates.add(ri);
            }
        }
        return preferred == null || preferred.activityInfo == null ? null : new ComponentName(preferred.activityInfo.packageName, preferred.activityInfo.name);
    }

    @Override
    public void setHomeActivity(ComponentName comp, int userId) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        ArrayList<ResolveInfo> homeActivities = new ArrayList<ResolveInfo>();
        this.getHomeActivitiesAsUser(homeActivities, userId);
        boolean found = false;
        int size = homeActivities.size();
        ComponentName[] set = new ComponentName[size];
        for (int i = 0; i < size; ++i) {
            ComponentName activityName;
            ResolveInfo candidate = homeActivities.get(i);
            ActivityInfo info = candidate.activityInfo;
            set[i] = activityName = new ComponentName(info.packageName, info.name);
            if (found || !activityName.equals(comp)) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Component " + comp + " cannot be home on user " + userId);
        }
        this.replacePreferredActivity(this.getHomeFilter(), 0x100000, set, comp, userId);
    }

    private String getSetupWizardPackageName() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.SETUP_WIZARD");
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, null, 1835520, UserHandle.myUserId());
        if (matches.size() == 1) {
            return matches.get((int)0).getComponentInfo().packageName;
        }
        Slog.e(TAG, "There should probably be exactly one setup wizard; found " + matches.size() + ": matches=" + matches);
        return null;
    }

    private String getStorageManagerPackageName() {
        Intent intent = new Intent("android.os.storage.action.MANAGE_STORAGE");
        List<ResolveInfo> matches = this.queryIntentActivitiesInternal(intent, null, 1835520, UserHandle.myUserId());
        if (matches.size() == 1) {
            return matches.get((int)0).getComponentInfo().packageName;
        }
        Slog.e(TAG, "There should probably be exactly one storage manager; found " + matches.size() + ": matches=" + matches);
        return null;
    }

    @Override
    public void setApplicationEnabledSetting(String appPackageName, int newState, int flags, int userId, String callingPackage) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        if (callingPackage == null) {
            callingPackage = Integer.toString(Binder.getCallingUid());
        }
        this.setEnabledSetting(appPackageName, null, newState, flags, userId, callingPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUpdateAvailable(String packageName, boolean updateAvailable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting != null) {
                pkgSetting.setUpdateAvailable(updateAvailable);
            }
        }
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.setEnabledSetting(componentName.getPackageName(), componentName.getClassName(), newState, flags, userId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledSetting(String packageName, String className, int newState, int flags, int userId, String callingPackage) {
        ArrayList<String> components;
        PackageSetting pkgSetting;
        if (newState != 0 && newState != 1 && newState != 2 && newState != 3 && newState != 4) {
            throw new IllegalArgumentException("Invalid new component state: " + newState);
        }
        int callingUid = Binder.getCallingUid();
        int permission2 = callingUid == 1000 ? 0 : this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        this.enforceCrossUserPermission(callingUid, userId, false, true, "set enabled");
        boolean allowedByPermission = permission2 == 0;
        boolean sendNow = false;
        boolean isApp = className == null;
        boolean isCallerInstantApp = this.getInstantAppPackageName(callingUid) != null;
        String componentName = isApp ? packageName : className;
        int packageUid = -1;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                if (!isCallerInstantApp) {
                    if (className == null) {
                        throw new IllegalArgumentException("Unknown package: " + packageName);
                    }
                    throw new IllegalArgumentException("Unknown component: " + packageName + "/" + className);
                }
                throw new SecurityException("Attempt to change component state; pid=" + Binder.getCallingPid() + ", uid=" + callingUid + (className == null ? ", package=" + packageName : ", component=" + packageName + "/" + className));
            }
        }
        if (!UserHandle.isSameApp(callingUid, pkgSetting.appId)) {
            if (!allowedByPermission || this.filterAppAccessLPr(pkgSetting, callingUid, userId)) {
                throw new SecurityException("Attempt to change component state; pid=" + Binder.getCallingPid() + ", uid=" + callingUid + (className == null ? ", package=" + packageName : ", component=" + packageName + "/" + className));
            }
            if (this.mProtectedPackages.isPackageStateProtected(userId, packageName)) {
                throw new SecurityException("Cannot disable a protected package: " + packageName);
            }
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean newPackage;
            if (callingUid == 2000 && (pkgSetting.pkgFlags & 0x100) == 0) {
                int oldState = pkgSetting.getEnabled(userId);
                if (className != null || oldState != 3 && oldState != 0 && oldState != 1 || newState != 3 && newState != 0 && newState != 1) {
                    throw new SecurityException("Shell cannot change component state for " + packageName + "/" + className + " to " + newState);
                }
            }
            if (className == null) {
                if (pkgSetting.getEnabled(userId) == newState) {
                    return;
                }
                if (newState == 0 || newState == 1) {
                    callingPackage = null;
                }
                pkgSetting.setEnabled(newState, userId, callingPackage);
            } else {
                PackageParser.Package pkg = pkgSetting.pkg;
                if (pkg == null || !pkg.hasComponentClassName(className)) {
                    if (pkg != null && pkg.applicationInfo.targetSdkVersion >= 16) {
                        throw new IllegalArgumentException("Component class " + className + " does not exist in " + packageName);
                    }
                    Slog.w(TAG, "Failed setComponentEnabledSetting: component class " + className + " does not exist in " + packageName);
                }
                switch (newState) {
                    case 1: {
                        if (pkgSetting.enableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 2: {
                        if (pkgSetting.disableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 0: {
                        if (pkgSetting.restoreComponentLPw(className, userId)) break;
                        return;
                    }
                    default: {
                        Slog.e(TAG, "Invalid new component state: " + newState);
                        return;
                    }
                }
            }
            this.scheduleWritePackageRestrictionsLocked(userId);
            this.updateSequenceNumberLP(pkgSetting, new int[]{userId});
            long callingId = Binder.clearCallingIdentity();
            try {
                this.updateInstantAppInstallerLocked(packageName);
            }
            finally {
                Binder.restoreCallingIdentity(callingId);
            }
            components = this.mPendingBroadcasts.get(userId, packageName);
            boolean bl = newPackage = components == null;
            if (newPackage) {
                components = new ArrayList();
            }
            if (!components.contains(componentName)) {
                components.add(componentName);
            }
            if ((flags & 1) == 0) {
                sendNow = true;
                this.mPendingBroadcasts.remove(userId, packageName);
            } else {
                if (newPackage) {
                    this.mPendingBroadcasts.put(userId, packageName, components);
                }
                if (!this.mHandler.hasMessages(1)) {
                    this.mHandler.sendEmptyMessageDelayed(1, 10000L);
                }
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            if (sendNow) {
                packageUid = UserHandle.getUid(userId, pkgSetting.appId);
                this.sendPackageChangedBroadcast(packageName, (flags & 1) != 0, components, packageUid);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushPackageRestrictionsAsUser(int userId) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "flushPackageRestrictions");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.writePackageRestrictionsLPr(userId);
            this.mDirtyUsers.remove(userId);
            if (this.mDirtyUsers.isEmpty()) {
                this.mHandler.removeMessages(14);
            }
        }
    }

    private void sendPackageChangedBroadcast(String packageName, boolean killFlag, ArrayList<String> componentNames, int packageUid) {
        Bundle extras = new Bundle(4);
        extras.putString("android.intent.extra.changed_component_name", componentNames.get(0));
        String[] nameList = new String[componentNames.size()];
        componentNames.toArray(nameList);
        extras.putStringArray("android.intent.extra.changed_component_name_list", nameList);
        extras.putBoolean("android.intent.extra.DONT_KILL_APP", killFlag);
        extras.putInt("android.intent.extra.UID", packageUid);
        int flags = !componentNames.contains(packageName) ? 0x40000000 : 0;
        this.sendPackageBroadcast("android.intent.action.PACKAGE_CHANGED", packageName, extras, flags, null, null, new int[]{UserHandle.getUserId(packageUid)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageStoppedState(String packageName, boolean stopped, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return;
        }
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        boolean allowedByPermission = permission2 == 0;
        this.enforceCrossUserPermission(callingUid, userId, true, true, "stop package");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (!this.filterAppAccessLPr(ps, callingUid, userId) && this.mSettings.setPackageStoppedStateLPw(this, packageName, stopped, allowedByPermission, callingUid, userId)) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstallerPackageName(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, callingUid, UserHandle.getUserId(callingUid))) {
                return null;
            }
            return this.mSettings.getInstallerPackageNameLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOrphaned(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.isOrphaned(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getApplicationEnabledSetting(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, false, false, "get enabled");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.filterAppAccessLPr(this.mSettings.getPackageLPr(packageName), callingUid, userId)) {
                return 2;
            }
            return this.mSettings.getApplicationEnabledSettingLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getComponentEnabledSetting(ComponentName component, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, false, false, "getComponentEnabled");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.filterAppAccessLPr(this.mSettings.getPackageLPr(component.getPackageName()), callingUid, component, 0, userId)) {
                return 2;
            }
            return this.mSettings.getComponentEnabledSettingLPr(component, userId);
        }
    }

    @Override
    public void enterSafeMode() {
        PackageManagerService.enforceSystemOrRoot("Only the system can request entering safe mode");
        if (!this.mSystemReady) {
            this.mSafeMode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        PackageManagerService.enforceSystemOrRoot("Only the system can claim the system is ready");
        this.mSystemReady = true;
        final ContentResolver resolver = this.mContext.getContentResolver();
        ContentObserver co = new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange) {
                PackageManagerService.this.mEphemeralAppsDisabled = Settings.Global.getInt(resolver, "enable_ephemeral_feature", 1) == 0 || Settings.Secure.getInt(resolver, "instant_apps_enabled", 1) == 0;
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("enable_ephemeral_feature"), false, co, 0);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("instant_apps_enabled"), false, co, 0);
        co.onChange(true);
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(this.mContext.getOpPackageName(), this, this.mContext.getContentResolver(), 0);
        boolean compatibilityModeEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "compatibility_mode", 1) == 1;
        PackageParser.setCompatibilityModeEnabled(compatibilityModeEnabled);
        int[] grantPermissionsUserIds = EMPTY_INT_ARRAY;
        Iterator<Message> iterator = this.mPackages;
        synchronized (iterator) {
            ArrayList<PreferredActivity> removed = new ArrayList<PreferredActivity>();
            for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                removed.clear();
                for (PreferredActivity pa : pir.filterSet()) {
                    if (this.mActivities.mActivities.get(pa.mPref.mComponent) != null) continue;
                    removed.add(pa);
                }
                if (removed.size() <= 0) continue;
                for (int r = 0; r < removed.size(); ++r) {
                    PreferredActivity pa;
                    pa = (PreferredActivity)removed.get(r);
                    Slog.w(TAG, "Removing dangling preferred activity: " + pa.mPref.mComponent);
                    pir.removeFilter(pa);
                }
                this.mSettings.writePackageRestrictionsLPr(this.mSettings.mPreferredActivities.keyAt(i));
            }
            for (int userId : UserManagerService.getInstance().getUserIds()) {
                if (this.mSettings.areDefaultRuntimePermissionsGrantedLPr(userId)) continue;
                grantPermissionsUserIds = ArrayUtils.appendInt(grantPermissionsUserIds, userId);
            }
        }
        sUserManager.systemReady();
        for (Object userId : (Iterator<Message>)grantPermissionsUserIds) {
            this.mDefaultPermissionPolicy.grantDefaultPermissions((int)userId);
        }
        if (grantPermissionsUserIds == EMPTY_INT_ARRAY) {
            this.mDefaultPermissionPolicy.scheduleReadDefaultPermissionExceptions();
        }
        if (this.mPostSystemReadyMessages != null) {
            for (Message msg : this.mPostSystemReadyMessages) {
                msg.sendToTarget();
            }
            this.mPostSystemReadyMessages = null;
        }
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        storage.registerListener(this.mStorageListener);
        this.mInstallerService.systemReady();
        this.mPackageDexOptimizer.systemReady();
        StorageManagerInternal StorageManagerInternal2 = LocalServices.getService(StorageManagerInternal.class);
        StorageManagerInternal2.addExternalStoragePolicy(new StorageManagerInternal.ExternalStorageMountPolicy(){

            @Override
            public int getMountMode(int uid, String packageName) {
                if (Process.isIsolated(uid)) {
                    return 0;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.WRITE_MEDIA_STORAGE", uid) == 0) {
                    return 1;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.READ_EXTERNAL_STORAGE", uid) == -1) {
                    return 1;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.WRITE_EXTERNAL_STORAGE", uid) == -1) {
                    return 2;
                }
                return 3;
            }

            @Override
            public boolean hasExternalStorage(int uid, String packageName) {
                return true;
            }
        });
        sUserManager.reconcileUsers(StorageManager.UUID_PRIVATE_INTERNAL);
        this.reconcileApps(StorageManager.UUID_PRIVATE_INTERNAL);
        if (this.mPrivappPermissionsViolations != null) {
            Slog.wtf(TAG, "Signature|privileged permissions not in privapp-permissions whitelist: " + this.mPrivappPermissionsViolations);
            this.mPrivappPermissionsViolations = null;
        }
    }

    public void waitForAppDataPrepared() {
        if (this.mPrepareAppDataFuture == null) {
            return;
        }
        ConcurrentUtils.waitForFutureNoInterrupt(this.mPrepareAppDataFuture, "wait for prepareAppData");
        this.mPrepareAppDataFuture = null;
    }

    @Override
    public boolean isSafeMode() {
        return this.mSafeMode;
    }

    @Override
    public boolean hasSystemUidErrors() {
        return this.mHasSystemUidErrors;
    }

    static String arrayToString(int[] array2) {
        StringBuffer buf = new StringBuffer(128);
        buf.append('[');
        if (array2 != null) {
            for (int i = 0; i < array2.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(array2[i]);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new PackageManagerShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        DumpState dumpState = new DumpState();
        boolean fullPreferred = false;
        boolean checkin = false;
        String packageName = null;
        ArraySet<String> permissionNames = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) continue;
            if ("-h".equals(opt)) {
                pw.println("Package manager dump options:");
                pw.println("  [-h] [-f] [--checkin] [cmd] ...");
                pw.println("    --checkin: dump for a checkin");
                pw.println("    -f: print details of intent filters");
                pw.println("    -h: print this help");
                pw.println("  cmd may be one of:");
                pw.println("    l[ibraries]: list known shared libraries");
                pw.println("    f[eatures]: list device features");
                pw.println("    k[eysets]: print known keysets");
                pw.println("    r[esolvers] [activity|service|receiver|content]: dump intent resolvers");
                pw.println("    perm[issions]: dump permissions");
                pw.println("    permission [name ...]: dump declaration and use of given permission");
                pw.println("    pref[erred]: print preferred package settings");
                pw.println("    preferred-xml [--full]: print preferred package settings as xml");
                pw.println("    prov[iders]: dump content providers");
                pw.println("    p[ackages]: dump installed packages");
                pw.println("    s[hared-users]: dump shared user IDs");
                pw.println("    m[essages]: print collected runtime messages");
                pw.println("    v[erifiers]: print package verifier info");
                pw.println("    d[omain-preferred-apps]: print domains preferred apps");
                pw.println("    i[ntent-filter-verifiers]|ifv: print intent filter verifier info");
                pw.println("    version: print database version info");
                pw.println("    write: write current settings now");
                pw.println("    installs: details about install sessions");
                pw.println("    check-permission <permission> <package> [<user>]: does pkg hold perm?");
                pw.println("    dexopt: dump dexopt state");
                pw.println("    compiler-stats: dump compiler statistics");
                pw.println("    enabled-overlays: dump list of enabled overlay packages");
                pw.println("    <package.name>: info about given package");
                return;
            }
            if ("--checkin".equals(opt)) {
                checkin = true;
                continue;
            }
            if ("-f".equals(opt)) {
                dumpState.setOptionEnabled(1);
                continue;
            }
            if ("--proto".equals(opt)) {
                this.dumpProto(fd);
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if (PLATFORM_PACKAGE_NAME.equals(cmd) || cmd.contains(".")) {
                packageName = cmd;
                dumpState.setOptionEnabled(1);
            } else {
                if ("check-permission".equals(cmd)) {
                    if (opti >= args.length) {
                        pw.println("Error: check-permission missing permission argument");
                        return;
                    }
                    String perm = args[opti];
                    if (++opti >= args.length) {
                        pw.println("Error: check-permission missing package argument");
                        return;
                    }
                    String pkg = args[opti];
                    int user = UserHandle.getUserId(Binder.getCallingUid());
                    if (++opti < args.length) {
                        try {
                            user = Integer.parseInt(args[opti]);
                        }
                        catch (NumberFormatException e) {
                            pw.println("Error: check-permission user argument is not a number: " + args[opti]);
                            return;
                        }
                    }
                    pkg = this.resolveInternalPackageNameLPr(pkg, -1);
                    pw.println(this.checkPermission(perm, pkg, user));
                    return;
                }
                if ("l".equals(cmd) || "libraries".equals(cmd)) {
                    dumpState.setDump(1);
                } else if ("f".equals(cmd) || "features".equals(cmd)) {
                    dumpState.setDump(2);
                } else if ("r".equals(cmd) || "resolvers".equals(cmd)) {
                    if (opti >= args.length) {
                        dumpState.setDump(60);
                    } else {
                        while (opti < args.length) {
                            String name = args[opti];
                            if ("a".equals(name) || "activity".equals(name)) {
                                dumpState.setDump(4);
                            } else if ("s".equals(name) || "service".equals(name)) {
                                dumpState.setDump(8);
                            } else if ("r".equals(name) || "receiver".equals(name)) {
                                dumpState.setDump(16);
                            } else if ("c".equals(name) || "content".equals(name)) {
                                dumpState.setDump(32);
                            } else {
                                pw.println("Error: unknown resolver table type: " + name);
                                return;
                            }
                            ++opti;
                        }
                    }
                } else if (TAG_PERMISSION.equals(cmd) || "permissions".equals(cmd)) {
                    dumpState.setDump(64);
                } else if ("permission".equals(cmd)) {
                    if (opti >= args.length) {
                        pw.println("Error: permission requires permission name");
                        return;
                    }
                    permissionNames = new ArraySet<String>();
                    while (opti < args.length) {
                        permissionNames.add(args[opti]);
                        ++opti;
                    }
                    dumpState.setDump(448);
                } else if ("pref".equals(cmd) || "preferred".equals(cmd)) {
                    dumpState.setDump(4096);
                } else if ("preferred-xml".equals(cmd)) {
                    dumpState.setDump(8192);
                    if (opti < args.length && "--full".equals(args[opti])) {
                        fullPreferred = true;
                        ++opti;
                    }
                } else if ("d".equals(cmd) || "domain-preferred-apps".equals(cmd)) {
                    dumpState.setDump(262144);
                } else if ("p".equals(cmd) || "packages".equals(cmd)) {
                    dumpState.setDump(128);
                } else if ("s".equals(cmd) || "shared-users".equals(cmd)) {
                    dumpState.setDump(256);
                } else if ("prov".equals(cmd) || "providers".equals(cmd)) {
                    dumpState.setDump(1024);
                } else if ("m".equals(cmd) || "messages".equals(cmd)) {
                    dumpState.setDump(512);
                } else if ("v".equals(cmd) || "verifiers".equals(cmd)) {
                    dumpState.setDump(2048);
                } else if ("i".equals(cmd) || "ifv".equals(cmd) || "intent-filter-verifiers".equals(cmd)) {
                    dumpState.setDump(131072);
                } else if ("version".equals(cmd)) {
                    dumpState.setDump(32768);
                } else if ("k".equals(cmd) || "keysets".equals(cmd)) {
                    dumpState.setDump(16384);
                } else if ("installs".equals(cmd)) {
                    dumpState.setDump(65536);
                } else if ("frozen".equals(cmd)) {
                    dumpState.setDump(524288);
                } else if ("dexopt".equals(cmd)) {
                    dumpState.setDump(0x100000);
                } else if ("compiler-stats".equals(cmd)) {
                    dumpState.setDump(0x200000);
                } else if ("changes".equals(cmd)) {
                    dumpState.setDump(0x400000);
                } else if ("write".equals(cmd)) {
                    ArrayMap<String, PackageParser.Package> name = this.mPackages;
                    synchronized (name) {
                        this.mSettings.writeLPr();
                        pw.println("Settings written.");
                        return;
                    }
                }
            }
        }
        if (checkin) {
            pw.println("vers,1");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (dumpState.isDumping(32768) && packageName == null && !checkin) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Database versions:");
                this.mSettings.dumpVersionLPr(new IndentingPrintWriter((Writer)pw, "  "));
            }
            if (dumpState.isDumping(2048) && packageName == null) {
                if (!checkin) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Verifiers:");
                    pw.print("  Required: ");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(" (uid=");
                    pw.print(this.getPackageUid(this.mRequiredVerifierPackage, 0x10000000, 0));
                    pw.println(")");
                } else if (this.mRequiredVerifierPackage != null) {
                    pw.print("vrfy,");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(",");
                    pw.println(this.getPackageUid(this.mRequiredVerifierPackage, 0x10000000, 0));
                }
            }
            if (dumpState.isDumping(131072) && packageName == null) {
                if (this.mIntentFilterVerifierComponent != null) {
                    String verifierPackageName = this.mIntentFilterVerifierComponent.getPackageName();
                    if (!checkin) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Intent Filter Verifier:");
                        pw.print("  Using: ");
                        pw.print(verifierPackageName);
                        pw.print(" (uid=");
                        pw.print(this.getPackageUid(verifierPackageName, 0x10000000, 0));
                        pw.println(")");
                    } else if (verifierPackageName != null) {
                        pw.print("ifv,");
                        pw.print(verifierPackageName);
                        pw.print(",");
                        pw.println(this.getPackageUid(verifierPackageName, 0x10000000, 0));
                    }
                } else {
                    pw.println();
                    pw.println("No Intent Filter Verifier available!");
                }
            }
            if (dumpState.isDumping(1) && packageName == null) {
                boolean printedHeader = false;
                for (String libName : this.mSharedLibraries.keySet()) {
                    SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.get(libName);
                    if (versionedLib == null) continue;
                    int versionCount = versionedLib.size();
                    for (int i = 0; i < versionCount; ++i) {
                        SharedLibraryEntry libEntry = versionedLib.valueAt(i);
                        if (!checkin) {
                            if (!printedHeader) {
                                if (dumpState.onTitlePrinted()) {
                                    pw.println();
                                }
                                pw.println("Libraries:");
                                printedHeader = true;
                            }
                            pw.print("  ");
                        } else {
                            pw.print("lib,");
                        }
                        pw.print(libEntry.info.getName());
                        if (libEntry.info.isStatic()) {
                            pw.print(" version=" + libEntry.info.getVersion());
                        }
                        if (!checkin) {
                            pw.print(" -> ");
                        }
                        if (libEntry.path != null) {
                            pw.print(" (jar) ");
                            pw.print(libEntry.path);
                        } else {
                            pw.print(" (apk) ");
                            pw.print(libEntry.apk);
                        }
                        pw.println();
                    }
                }
            }
            if (dumpState.isDumping(2) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                if (!checkin) {
                    pw.println("Features:");
                }
                ArrayMap<String, FeatureInfo> printedHeader = this.mAvailableFeatures;
                synchronized (printedHeader) {
                    for (FeatureInfo feat : this.mAvailableFeatures.values()) {
                        if (checkin) {
                            pw.print("feat,");
                            pw.print(feat.name);
                            pw.print(",");
                            pw.println(feat.version);
                            continue;
                        }
                        pw.print("  ");
                        pw.print(feat.name);
                        if (feat.version > 0) {
                            pw.print(" version=");
                            pw.print(feat.version);
                        }
                        pw.println();
                    }
                }
            }
            if (!checkin && dumpState.isDumping(4) && this.mActivities.dump(pw, dumpState.getTitlePrinted() ? "\nActivity Resolver Table:" : "Activity Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                dumpState.setTitlePrinted(true);
            }
            if (!checkin && dumpState.isDumping(16) && this.mReceivers.dump(pw, dumpState.getTitlePrinted() ? "\nReceiver Resolver Table:" : "Receiver Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                dumpState.setTitlePrinted(true);
            }
            if (!checkin && dumpState.isDumping(8) && this.mServices.dump(pw, dumpState.getTitlePrinted() ? "\nService Resolver Table:" : "Service Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                dumpState.setTitlePrinted(true);
            }
            if (!checkin && dumpState.isDumping(32) && this.mProviders.dump(pw, dumpState.getTitlePrinted() ? "\nProvider Resolver Table:" : "Provider Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                dumpState.setTitlePrinted(true);
            }
            if (!checkin && dumpState.isDumping(4096)) {
                for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                    PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                    int user = this.mSettings.mPreferredActivities.keyAt(i);
                    if (!pir.dump(pw, dumpState.getTitlePrinted() ? "\nPreferred Activities User " + user + ":" : "Preferred Activities User " + user + ":", "  ", packageName, true, false)) continue;
                    dumpState.setTitlePrinted(true);
                }
            }
            if (!checkin && dumpState.isDumping(8192)) {
                pw.flush();
                FileOutputStream fout = new FileOutputStream(fd);
                BufferedOutputStream str = new BufferedOutputStream(fout);
                FastXmlSerializer serializer = new FastXmlSerializer();
                try {
                    serializer.setOutput(str, StandardCharsets.UTF_8.name());
                    serializer.startDocument(null, true);
                    serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    this.mSettings.writePreferredActivitiesLPr(serializer, 0, fullPreferred);
                    serializer.endDocument();
                    serializer.flush();
                }
                catch (IllegalArgumentException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IllegalStateException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IOException e) {
                    pw.println("Failed writing: " + e);
                }
            }
            if (!checkin && dumpState.isDumping(262144) && packageName == null) {
                pw.println();
                int count = this.mSettings.mPackages.size();
                if (count == 0) {
                    pw.println("No applications!");
                    pw.println();
                } else {
                    String prefix = "  ";
                    Collection<PackageSetting> allPackageSettings = this.mSettings.mPackages.values();
                    if (allPackageSettings.size() == 0) {
                        pw.println("No domain preferred apps!");
                        pw.println();
                    } else {
                        pw.println("App verification status:");
                        pw.println();
                        count = 0;
                        for (PackageSetting ps : allPackageSettings) {
                            IntentFilterVerificationInfo ivi = ps.getIntentFilterVerificationInfo();
                            if (ivi == null || ivi.getPackageName() == null) continue;
                            pw.println("  Package: " + ivi.getPackageName());
                            pw.println("  Domains: " + ivi.getDomainsString());
                            pw.println("  Status:  " + ivi.getStatusString());
                            pw.println();
                            ++count;
                        }
                        if (count == 0) {
                            pw.println("  No app verification established.");
                            pw.println();
                        }
                        for (Object userId : (Object)sUserManager.getUserIds()) {
                            pw.println("App linkages for user " + (int)userId + ":");
                            pw.println();
                            count = 0;
                            for (PackageSetting ps : allPackageSettings) {
                                long status = ps.getDomainVerificationStatusForUser((int)userId);
                                if (status >> 32 == 0L) continue;
                                pw.println("  Package: " + ps.name);
                                pw.println("  Domains: " + this.dumpDomainString(ps.name));
                                String statusStr = IntentFilterVerificationInfo.getStatusStringFromValue(status);
                                pw.println("  Status:  " + statusStr);
                                pw.println();
                                ++count;
                            }
                            if (count != 0) continue;
                            pw.println("  No configured app linkages.");
                            pw.println();
                        }
                    }
                }
            }
            if (!checkin && dumpState.isDumping(64)) {
                this.mSettings.dumpPermissionsLPr(pw, packageName, permissionNames, dumpState);
                if (packageName == null && permissionNames == null) {
                    for (int iperm = 0; iperm < this.mAppOpPermissionPackages.size(); ++iperm) {
                        if (iperm == 0) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("AppOp Permissions:");
                        }
                        pw.print("  AppOp Permission ");
                        pw.print(this.mAppOpPermissionPackages.keyAt(iperm));
                        pw.println(":");
                        ArraySet<String> pkgs = this.mAppOpPermissionPackages.valueAt(iperm);
                        for (int ipkg = 0; ipkg < pkgs.size(); ++ipkg) {
                            pw.print("    ");
                            pw.println((String)pkgs.valueAt(ipkg));
                        }
                    }
                }
            }
            if (!checkin && dumpState.isDumping(1024)) {
                boolean printedSomething = false;
                for (PackageParser.Provider p : this.mProviders.mProviders.values()) {
                    if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Registered ContentProviders:");
                        printedSomething = true;
                    }
                    pw.print("  ");
                    p.printComponentShortName(pw);
                    pw.println(":");
                    pw.print("    ");
                    pw.println(p.toString());
                }
                printedSomething = false;
                for (Map.Entry entry : this.mProvidersByAuthority.entrySet()) {
                    PackageParser.Provider p = (PackageParser.Provider)entry.getValue();
                    if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("ContentProvider Authorities:");
                        printedSomething = true;
                    }
                    pw.print("  [");
                    pw.print((String)entry.getKey());
                    pw.println("]:");
                    pw.print("    ");
                    pw.println(p.toString());
                    if (p.info == null || p.info.applicationInfo == null) continue;
                    String appInfo = p.info.applicationInfo.toString();
                    pw.print("      applicationInfo=");
                    pw.println(appInfo);
                }
            }
            if (!checkin && dumpState.isDumping(16384)) {
                this.mSettings.mKeySetManagerService.dumpLPr(pw, packageName, dumpState);
            }
            if (dumpState.isDumping(128)) {
                this.mSettings.dumpPackagesLPr(pw, packageName, permissionNames, dumpState, checkin);
            }
            if (dumpState.isDumping(256)) {
                this.mSettings.dumpSharedUsersLPr(pw, packageName, permissionNames, dumpState, checkin);
            }
            if (dumpState.isDumping(0x400000)) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Package Changes:");
                pw.print("  Sequence number=");
                pw.println(this.mChangedPackagesSequenceNumber);
                int K = this.mChangedPackages.size();
                for (int i = 0; i < K; ++i) {
                    SparseArray<String> changes = this.mChangedPackages.valueAt(i);
                    pw.print("  User ");
                    pw.print(this.mChangedPackages.keyAt(i));
                    pw.println(":");
                    int N = changes.size();
                    if (N == 0) {
                        pw.print("    ");
                        pw.println("No packages changed");
                        continue;
                    }
                    for (int j = 0; j < N; ++j) {
                        String pkgName = changes.valueAt(j);
                        int sequenceNumber = changes.keyAt(j);
                        pw.print("    ");
                        pw.print("seq=");
                        pw.print(sequenceNumber);
                        pw.print(", package=");
                        pw.println(pkgName);
                    }
                }
            }
            if (!checkin && dumpState.isDumping(64) && packageName == null) {
                this.mSettings.dumpRestoredPermissionGrantsLPr(pw, dumpState);
            }
            if (!checkin && dumpState.isDumping(524288) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                IndentingPrintWriter ipw = new IndentingPrintWriter(pw, "  ", 120);
                ipw.println();
                ipw.println("Frozen packages:");
                ipw.increaseIndent();
                if (this.mFrozenPackages.size() == 0) {
                    ipw.println("(none)");
                } else {
                    for (int i = 0; i < this.mFrozenPackages.size(); ++i) {
                        ipw.println(this.mFrozenPackages.valueAt(i));
                    }
                }
                ipw.decreaseIndent();
            }
            if (!checkin && dumpState.isDumping(0x100000)) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.dumpDexoptStateLPr(pw, packageName);
            }
            if (!checkin && dumpState.isDumping(0x200000)) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.dumpCompilerStatsLPr(pw, packageName);
            }
            if (!checkin && dumpState.isDumping(512) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.mSettings.dumpReadMessagesLPr(pw, dumpState);
                pw.println();
                pw.println("Package warning messages:");
                BufferedReader in = null;
                String line = null;
                try {
                    in = new BufferedReader(new FileReader(PackageManagerService.getSettingsProblemFile()));
                    while ((line = in.readLine()) != null) {
                        if (line.contains("ignored: updated version")) continue;
                        pw.println(line);
                    }
                }
                catch (IOException iOException) {
                    IoUtils.closeQuietly(in);
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(in);
            }
            if (checkin && dumpState.isDumping(512)) {
                BufferedReader in = null;
                String line = null;
                try {
                    in = new BufferedReader(new FileReader(PackageManagerService.getSettingsProblemFile()));
                    while ((line = in.readLine()) != null) {
                        if (line.contains("ignored: updated version")) continue;
                        pw.print("msg,");
                        pw.println(line);
                    }
                }
                catch (IOException iOException) {
                    IoUtils.closeQuietly(in);
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(in);
            }
        }
        if (!checkin && dumpState.isDumping(65536) && packageName == null) {
            if (dumpState.onTitlePrinted()) {
                pw.println();
            }
            this.mInstallerService.dump(new IndentingPrintWriter(pw, "  ", 120));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long requiredVerifierPackageToken = proto.start(0x11100000001L);
            proto.write(0x10E00000001L, this.mRequiredVerifierPackage);
            proto.write(1112396529666L, this.getPackageUid(this.mRequiredVerifierPackage, 0x10000000, 0));
            proto.end(requiredVerifierPackageToken);
            if (this.mIntentFilterVerifierComponent != null) {
                String verifierPackageName = this.mIntentFilterVerifierComponent.getPackageName();
                long verifierPackageToken = proto.start(0x11100000002L);
                proto.write(0x10E00000001L, verifierPackageName);
                proto.write(1112396529666L, this.getPackageUid(verifierPackageName, 0x10000000, 0));
                proto.end(verifierPackageToken);
            }
            this.dumpSharedLibrariesProto(proto);
            this.dumpFeaturesProto(proto);
            this.mSettings.dumpPackagesProto(proto);
            this.mSettings.dumpSharedUsersProto(proto);
            this.dumpMessagesProto(proto);
        }
        proto.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpMessagesProto(ProtoOutputStream proto) {
        BufferedReader in = null;
        String line = null;
        try {
            in = new BufferedReader(new FileReader(PackageManagerService.getSettingsProblemFile()));
            while ((line = in.readLine()) != null) {
                if (line.contains("ignored: updated version")) continue;
                proto.write(2259152797703L, line);
            }
        }
        catch (IOException iOException) {
            IoUtils.closeQuietly(in);
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFeaturesProto(ProtoOutputStream proto) {
        ArrayMap<String, FeatureInfo> arrayMap = this.mAvailableFeatures;
        synchronized (arrayMap) {
            int count = this.mAvailableFeatures.size();
            for (int i = 0; i < count; ++i) {
                FeatureInfo feat = this.mAvailableFeatures.valueAt(i);
                long featureToken = proto.start(2272037699588L);
                proto.write(0x10E00000001L, feat.name);
                proto.write(1112396529666L, feat.version);
                proto.end(featureToken);
            }
        }
    }

    private void dumpSharedLibrariesProto(ProtoOutputStream proto) {
        int count = this.mSharedLibraries.size();
        for (int i = 0; i < count; ++i) {
            String libName = this.mSharedLibraries.keyAt(i);
            SparseArray<SharedLibraryEntry> versionedLib = this.mSharedLibraries.get(libName);
            if (versionedLib == null) continue;
            int versionCount = versionedLib.size();
            for (int j = 0; j < versionCount; ++j) {
                SharedLibraryEntry libEntry = versionedLib.valueAt(j);
                long sharedLibraryToken = proto.start(2272037699587L);
                proto.write(0x10E00000001L, libEntry.info.getName());
                boolean isJar = libEntry.path != null;
                proto.write(1155346202626L, isJar);
                if (isJar) {
                    proto.write(1159641169923L, libEntry.path);
                } else {
                    proto.write(1159641169924L, libEntry.apk);
                }
                proto.end(sharedLibraryToken);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dumpDexoptStateLPr(PrintWriter pw, String packageName) {
        IndentingPrintWriter ipw = new IndentingPrintWriter(pw, "  ", 120);
        ipw.println();
        ipw.println("Dexopt state:");
        ipw.increaseIndent();
        Collection<PackageParser.Package> packages = null;
        if (packageName != null) {
            PackageParser.Package targetPackage = this.mPackages.get(packageName);
            if (targetPackage == null) {
                ipw.println("Unable to find package: " + packageName);
                return;
            }
            packages = Collections.singletonList(targetPackage);
        } else {
            packages = this.mPackages.values();
        }
        Iterator<PackageParser.Package> iterator = packages.iterator();
        while (iterator.hasNext()) {
            PackageParser.Package pkg = iterator.next();
            ipw.println("[" + pkg.packageName + "]");
            ipw.increaseIndent();
            this.mPackageDexOptimizer.dumpDexoptState(ipw, pkg);
            ipw.decreaseIndent();
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dumpCompilerStatsLPr(PrintWriter pw, String packageName) {
        IndentingPrintWriter ipw = new IndentingPrintWriter(pw, "  ", 120);
        ipw.println();
        ipw.println("Compiler stats:");
        ipw.increaseIndent();
        Collection<PackageParser.Package> packages = null;
        if (packageName != null) {
            PackageParser.Package targetPackage = this.mPackages.get(packageName);
            if (targetPackage == null) {
                ipw.println("Unable to find package: " + packageName);
                return;
            }
            packages = Collections.singletonList(targetPackage);
        } else {
            packages = this.mPackages.values();
        }
        Iterator<PackageParser.Package> iterator = packages.iterator();
        while (iterator.hasNext()) {
            PackageParser.Package pkg = iterator.next();
            ipw.println("[" + pkg.packageName + "]");
            ipw.increaseIndent();
            CompilerStats.PackageStats stats = this.getCompilerPackageStats(pkg.packageName);
            if (stats == null) {
                ipw.println("(No recorded stats)");
            } else {
                stats.dump(ipw);
            }
            ipw.decreaseIndent();
        }
        return;
    }

    private String dumpDomainString(String packageName) {
        List iviList = this.getIntentFilterVerifications(packageName).getList();
        List filters = this.getAllIntentFilters(packageName).getList();
        ArraySet<String> result = new ArraySet<String>();
        if (iviList.size() > 0) {
            for (IntentFilterVerificationInfo ivi : iviList) {
                for (String host : ivi.getDomains()) {
                    result.add(host);
                }
            }
        }
        if (filters != null && filters.size() > 0) {
            for (IntentFilter filter : filters) {
                if (!filter.hasCategory("android.intent.category.BROWSABLE") || !filter.hasDataScheme("http") && !filter.hasDataScheme("https")) continue;
                result.addAll(filter.getHostsList());
            }
        }
        StringBuilder sb = new StringBuilder(result.size() * 16);
        for (String domain : result) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(domain);
        }
        return sb.toString();
    }

    static String getEncryptKey() {
        try {
            String sdEncKey = SystemKeyStore.getInstance().retrieveKeyHexString(SD_ENCRYPTION_KEYSTORE_NAME);
            if (sdEncKey == null && (sdEncKey = SystemKeyStore.getInstance().generateNewKeyHexString(128, SD_ENCRYPTION_ALGORITHM, SD_ENCRYPTION_KEYSTORE_NAME)) == null) {
                Slog.e(TAG, "Failed to create encryption keys");
                return null;
            }
            return sdEncKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            Slog.e(TAG, "Failed to create encryption keys with exception: " + nsae);
            return null;
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Failed to retrieve encryption keys with exception: " + ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExternalMediaStatus(final boolean mediaStatus, final boolean reportStatus) {
        PackageManagerService.enforceSystemOrRoot("Media status can only be updated by the system");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Log.i(TAG, "Updating external media status from " + (this.mMediaMounted ? "mounted" : "unmounted") + " to " + (mediaStatus ? "mounted" : "unmounted"));
            if (mediaStatus == this.mMediaMounted) {
                Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1);
                this.mHandler.sendMessage(msg);
                return;
            }
            this.mMediaMounted = mediaStatus;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageManagerService.this.updateExternalMediaStatusInner(mediaStatus, reportStatus, true);
            }
        });
    }

    public void scanAvailableAsecs() {
        this.updateExternalMediaStatusInner(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalMediaStatusInner(boolean isMounted, boolean reportStatus, boolean externalStorage) {
        ArrayMap<AsecInstallArgs, String> processCids = new ArrayMap<AsecInstallArgs, String>();
        int[] uidArr = EmptyArray.INT;
        String[] list = PackageHelper.getSecureContainerList();
        if (ArrayUtils.isEmpty(list)) {
            Log.i(TAG, "No secure containers found");
        } else {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                for (String cid : list) {
                    if (PackageInstallerService.isStageName(cid)) continue;
                    String pkgName = PackageManagerService.getAsecPackageName(cid);
                    if (pkgName == null) {
                        Slog.i(TAG, "Found stale container " + cid + " with no package name");
                        continue;
                    }
                    PackageSetting ps = this.mSettings.mPackages.get(pkgName);
                    if (ps == null) {
                        Slog.i(TAG, "Found stale container " + cid + " with no matching settings");
                        continue;
                    }
                    if (externalStorage && !isMounted && !PackageManagerService.isExternal(ps)) continue;
                    AsecInstallArgs args = new AsecInstallArgs(cid, InstructionSets.getAppDexInstructionSets(ps), ps.isForwardLocked());
                    if (ps.codePathString != null && ps.codePathString.startsWith(args.getCodePath())) {
                        processCids.put(args, ps.codePathString);
                        int uid = ps.appId;
                        if (uid == -1) continue;
                        uidArr = ArrayUtils.appendInt(uidArr, uid);
                        continue;
                    }
                    Slog.i(TAG, "Found stale container " + cid + ": expected codePath=" + ps.codePathString);
                }
            }
            Arrays.sort(uidArr);
        }
        if (isMounted) {
            this.loadMediaPackages(processCids, uidArr, externalStorage);
            this.startCleaningPackages();
            this.mInstallerService.onSecureContainersAvailable();
        } else {
            this.unloadMediaPackages(processCids, uidArr, reportStatus);
        }
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<ApplicationInfo> infos, IIntentReceiver finishedReceiver) {
        int size = infos.size();
        String[] packageNames = new String[size];
        int[] packageUids = new int[size];
        for (int i = 0; i < size; ++i) {
            ApplicationInfo info = infos.get(i);
            packageNames[i] = info.packageName;
            packageUids[i] = info.uid;
        }
        this.sendResourcesChangedBroadcast(mediaStatus, replacing, packageNames, packageUids, finishedReceiver);
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<String> pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        this.sendResourcesChangedBroadcast(mediaStatus, replacing, pkgList.toArray(new String[pkgList.size()]), uidArr, finishedReceiver);
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, String[] pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        int size = pkgList.length;
        if (size > 0) {
            Bundle extras = new Bundle();
            extras.putStringArray("android.intent.extra.changed_package_list", pkgList);
            if (uidArr != null) {
                extras.putIntArray("android.intent.extra.changed_uid_list", uidArr);
            }
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", replacing);
            }
            String action = mediaStatus ? "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE" : "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
            this.sendPackageBroadcast(action, null, extras, 0, null, finishedReceiver, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMediaPackages(ArrayMap<AsecInstallArgs, String> processCids, int[] uidArr, boolean externalStorage) {
        ArrayList<String> pkgList = new ArrayList<String>();
        Set<AsecInstallArgs> keys = processCids.keySet();
        for (AsecInstallArgs args : keys) {
            String codePath = processCids.get(args);
            int retCode = -18;
            try {
                if (args.doPreInstall(1) != 1) {
                    Slog.e(TAG, "Failed to mount cid : " + args.cid + " when installing from sdcard");
                    continue;
                }
                if (codePath == null || !codePath.startsWith(args.getCodePath())) {
                    Slog.e(TAG, "Container " + args.cid + " cachepath " + args.getCodePath() + " does not match one in settings " + codePath);
                    continue;
                }
                int parseFlags = this.mDefParseFlags;
                if (args.isExternalAsec()) {
                    parseFlags |= 0x20;
                }
                if (args.isFwdLocked()) {
                    parseFlags |= 0x10;
                }
                Object object = this.mInstallLock;
                synchronized (object) {
                    PackageParser.Package pkg = null;
                    try {
                        pkg = this.scanPackageTracedLI(new File(codePath), parseFlags, 32768, 0L, null);
                    }
                    catch (PackageManagerException e) {
                        Slog.w(TAG, "Failed to scan " + codePath + ": " + e.getMessage());
                    }
                    if (pkg != null) {
                        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                        synchronized (arrayMap) {
                            retCode = 1;
                            pkgList.add(pkg.packageName);
                            args.doPostInstall(1, pkg.applicationInfo.uid);
                        }
                    } else {
                        Slog.i(TAG, "Failed to install pkg from  " + codePath + " from sdcard");
                    }
                }
            }
            finally {
                if (retCode == 1) continue;
                Log.w(TAG, "Container " + args.cid + " is stale, retCode=" + retCode);
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Settings.VersionInfo ver = externalStorage ? this.mSettings.getExternalVersion() : this.mSettings.getInternalVersion();
            String volumeUuid = externalStorage ? "primary_physical" : StorageManager.UUID_PRIVATE_INTERNAL;
            int updateFlags = 1;
            if (ver.sdkVersion != this.mSdkVersion) {
                PackageManagerService.logCriticalInfo(4, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for external");
                updateFlags |= 6;
            }
            this.updatePermissionsLPw(null, null, volumeUuid, updateFlags);
            ver.forceCurrent();
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(true, false, pkgList, uidArr, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllContainers(Set<AsecInstallArgs> cidArgs) {
        for (AsecInstallArgs arg : cidArgs) {
            Object object = this.mInstallLock;
            synchronized (object) {
                arg.doPostDeleteLI(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadMediaPackages(ArrayMap<AsecInstallArgs, String> processCids, int[] uidArr, final boolean reportStatus) {
        ArrayList<String> pkgList = new ArrayList<String>();
        ArrayList<AsecInstallArgs> failedList = new ArrayList<AsecInstallArgs>();
        final Set<AsecInstallArgs> keys = processCids.keySet();
        for (AsecInstallArgs args : keys) {
            String pkgName = args.getPackageName();
            PackageRemovedInfo outInfo = new PackageRemovedInfo(this);
            Object object = this.mInstallLock;
            synchronized (object) {
                boolean res;
                boolean deleteFlags = true;
                try (PackageFreezer freezer = this.freezePackageForDelete(pkgName, 1, "unloadMediaPackages");){
                    res = this.deletePackageLIF(pkgName, null, false, null, 1, outInfo, false, null);
                }
                if (res) {
                    pkgList.add(pkgName);
                } else {
                    Slog.e(TAG, "Failed to delete pkg from sdcard : " + pkgName);
                    failedList.add(args);
                }
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(false, false, pkgList, uidArr, (IIntentReceiver)new IIntentReceiver.Stub(){

                @Override
                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, 1, keys);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            });
        } else {
            Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1, keys);
            this.mHandler.sendMessage(msg);
        }
    }

    private void loadPrivatePackages(final VolumeInfo vol) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageManagerService.this.loadPrivatePackagesInner(vol);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void loadPrivatePackagesInner(VolumeInfo vol) {
        List<PackageSetting> packages;
        Settings.VersionInfo ver;
        String volumeUuid = vol.fsUuid;
        if (TextUtils.isEmpty(volumeUuid)) {
            Slog.e(TAG, "Loading internal storage is probably a mistake; ignoring");
            return;
        }
        ArrayList<PackageFreezer> freezers = new ArrayList<PackageFreezer>();
        ArrayList<ApplicationInfo> loaded = new ArrayList<ApplicationInfo>();
        int parseFlags = this.mDefParseFlags | 0x20;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ver = this.mSettings.findOrCreateVersion(volumeUuid);
            packages = this.mSettings.getVolumePackagesLPr(volumeUuid);
        }
        for (PackageSetting ps : packages) {
            freezers.add(this.freezePackage(ps.name, "loadPrivatePackagesInner"));
            Object object = this.mInstallLock;
            synchronized (object) {
                try {
                    PackageParser.Package pkg = this.scanPackageTracedLI(ps.codePath, parseFlags, 4096, 0L, null);
                    loaded.add(pkg.applicationInfo);
                }
                catch (PackageManagerException e) {
                    Slog.w(TAG, "Failed to scan " + ps.codePath + ": " + e.getMessage());
                }
                if (!Build.FINGERPRINT.equals(ver.fingerprint)) {
                    this.clearAppDataLIF(ps.pkg, -1, 515);
                }
            }
        }
        StorageManager sm = this.mContext.getSystemService(StorageManager.class);
        UserManager um = this.mContext.getSystemService(UserManager.class);
        UserManagerInternal umInternal = this.getUserManagerInternal();
        for (UserInfo user : um.getUsers()) {
            int flags;
            if (umInternal.isUserUnlockingOrUnlocked(user.id)) {
                flags = 3;
            } else {
                if (!umInternal.isUserRunning(user.id)) continue;
                flags = 1;
            }
            try {
                void var13_18;
                sm.prepareUserStorage(volumeUuid, user.id, user.serialNumber, (int)var13_18);
                Object object = this.mInstallLock;
                synchronized (object) {
                    this.reconcileAppsDataLI(volumeUuid, user.id, (int)var13_18, true);
                }
            }
            catch (IllegalStateException e) {
                Slog.w(TAG, "Failed to prepare storage: " + e);
            }
        }
        Iterator iterator = this.mPackages;
        synchronized (iterator) {
            int updateFlags = 1;
            if (ver.sdkVersion != this.mSdkVersion) {
                PackageManagerService.logCriticalInfo(4, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for " + volumeUuid);
                updateFlags |= 6;
            }
            this.updatePermissionsLPw(null, null, volumeUuid, updateFlags);
            ver.forceCurrent();
            this.mSettings.writeLPr();
        }
        for (PackageFreezer freezer : freezers) {
            freezer.close();
        }
        this.sendResourcesChangedBroadcast(true, false, loaded, null);
    }

    private void unloadPrivatePackages(final VolumeInfo vol) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageManagerService.this.unloadPrivatePackagesInner(vol);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadPrivatePackagesInner(VolumeInfo vol) {
        String volumeUuid = vol.fsUuid;
        if (TextUtils.isEmpty(volumeUuid)) {
            Slog.e(TAG, "Unloading internal storage is probably a mistake; ignoring");
            return;
        }
        ArrayList<ApplicationInfo> unloaded = new ArrayList<ApplicationInfo>();
        Object object = this.mInstallLock;
        synchronized (object) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                List<PackageSetting> packages = this.mSettings.getVolumePackagesLPr(volumeUuid);
                for (PackageSetting ps : packages) {
                    if (ps.pkg == null) continue;
                    ApplicationInfo info = ps.pkg.applicationInfo;
                    boolean deleteFlags = true;
                    PackageRemovedInfo outInfo = new PackageRemovedInfo(this);
                    try (PackageFreezer freezer = this.freezePackageForDelete(ps.name, 1, "unloadPrivatePackagesInner");){
                        if (this.deletePackageLIF(ps.name, null, false, null, 1, outInfo, false, null)) {
                            unloaded.add(info);
                        } else {
                            Slog.w(TAG, "Failed to unload " + ps.codePath);
                        }
                    }
                    AttributeCache.instance().removePackage(ps.name);
                }
                this.mSettings.writeLPr();
            }
        }
        this.sendResourcesChangedBroadcast(false, false, unloaded, null);
        ResourcesManager.getInstance().invalidatePath(vol.getPath().getAbsolutePath());
        for (int i = 0; i < 3; ++i) {
            System.gc();
            System.runFinalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPackageKnown(String volumeUuid, String packageName) throws PackageManagerException {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            packageName = this.normalizePackageNameLPr(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                throw new PackageManagerException("Package " + packageName + " is unknown");
            }
            if (!TextUtils.equals(volumeUuid, ps.volumeUuid)) {
                throw new PackageManagerException("Package " + packageName + " found on unknown volume " + volumeUuid + "; expected volume " + ps.volumeUuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPackageKnownAndInstalled(String volumeUuid, String packageName, int userId) throws PackageManagerException {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            packageName = this.normalizePackageNameLPr(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                throw new PackageManagerException("Package " + packageName + " is unknown");
            }
            if (!TextUtils.equals(volumeUuid, ps.volumeUuid)) {
                throw new PackageManagerException("Package " + packageName + " found on unknown volume " + volumeUuid + "; expected volume " + ps.volumeUuid);
            }
            if (!ps.getInstalled(userId)) {
                throw new PackageManagerException("Package " + packageName + " not installed for user " + userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> collectAbsoluteCodePaths() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<String> codePaths = new ArrayList<String>();
            int packageCount = this.mSettings.mPackages.size();
            for (int i = 0; i < packageCount; ++i) {
                PackageSetting ps = this.mSettings.mPackages.valueAt(i);
                codePaths.add(ps.codePath.getAbsolutePath());
            }
            return codePaths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileApps(String volumeUuid) {
        File[] files;
        List<String> absoluteCodePaths = this.collectAbsoluteCodePaths();
        ArrayList<File> filesToDelete = null;
        for (File file : files = FileUtils.listFilesOrEmpty(Environment.getDataAppDirectory(volumeUuid))) {
            boolean isPackage;
            boolean bl = isPackage = (PackageParser.isApkFile(file) || file.isDirectory()) && !PackageInstallerService.isStageName(file.getName());
            if (!isPackage) continue;
            String absolutePath = file.getAbsolutePath();
            boolean pathValid = false;
            int absoluteCodePathCount = absoluteCodePaths.size();
            for (int i = 0; i < absoluteCodePathCount; ++i) {
                String absoluteCodePath = absoluteCodePaths.get(i);
                if (!absolutePath.startsWith(absoluteCodePath)) continue;
                pathValid = true;
                break;
            }
            if (pathValid) continue;
            if (filesToDelete == null) {
                filesToDelete = new ArrayList<File>();
            }
            filesToDelete.add(file);
        }
        if (filesToDelete != null) {
            int fileToDeleteCount = filesToDelete.size();
            for (int i = 0; i < fileToDeleteCount; ++i) {
                File fileToDelete = (File)filesToDelete.get(i);
                PackageManagerService.logCriticalInfo(5, "Destroying orphaned" + fileToDelete);
                Object object = this.mInstallLock;
                synchronized (object) {
                    this.removeCodePathLI(fileToDelete);
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconcileAppsData(int userId, int flags, boolean migrateAppsData) {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        for (VolumeInfo vol : storage.getWritablePrivateVolumes()) {
            String volumeUuid = vol.getFsUuid();
            Object object = this.mInstallLock;
            synchronized (object) {
                this.reconcileAppsDataLI(volumeUuid, userId, flags, migrateAppsData);
            }
        }
    }

    private void reconcileAppsDataLI(String volumeUuid, int userId, int flags, boolean migrateAppData) {
        this.reconcileAppsDataLI(volumeUuid, userId, flags, migrateAppData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<String> reconcileAppsDataLI(String volumeUuid, int userId, int flags, boolean migrateAppData, boolean onlyCoreApps) {
        void var10_15;
        List<PackageSetting> packages;
        String packageName;
        File[] files;
        Slog.v(TAG, "reconcileAppsData for " + volumeUuid + " u" + userId + " 0x" + Integer.toHexString(flags) + " migrateAppData=" + migrateAppData);
        ArrayList<String> result = onlyCoreApps ? new ArrayList<String>() : null;
        File ceDir = Environment.getDataUserCeDirectory(volumeUuid, userId);
        File deDir = Environment.getDataUserDeDirectory(volumeUuid, userId);
        if ((flags & 2) != 0) {
            if (StorageManager.isFileEncryptedNativeOrEmulated() && !StorageManager.isUserKeyUnlocked(userId)) {
                throw new RuntimeException("Yikes, someone asked us to reconcile CE storage while " + userId + " was still locked; this would have caused massive data loss!");
            }
            for (File file : files = FileUtils.listFilesOrEmpty(ceDir)) {
                packageName = file.getName();
                try {
                    this.assertPackageKnownAndInstalled(volumeUuid, packageName, userId);
                }
                catch (PackageManagerException e) {
                    PackageManagerService.logCriticalInfo(5, "Destroying " + file + " due to: " + e);
                    try {
                        this.mInstaller.destroyAppData(volumeUuid, packageName, userId, 2, 0L);
                    }
                    catch (Installer.InstallerException e2) {
                        PackageManagerService.logCriticalInfo(5, "Failed to destroy: " + e2);
                    }
                }
            }
        }
        if ((flags & 1) != 0) {
            for (File file : files = FileUtils.listFilesOrEmpty(deDir)) {
                packageName = file.getName();
                try {
                    this.assertPackageKnownAndInstalled(volumeUuid, packageName, userId);
                }
                catch (PackageManagerException e) {
                    PackageManagerService.logCriticalInfo(5, "Destroying " + file + " due to: " + e);
                    try {
                        this.mInstaller.destroyAppData(volumeUuid, packageName, userId, 1, 0L);
                    }
                    catch (Installer.InstallerException e2) {
                        PackageManagerService.logCriticalInfo(5, "Failed to destroy: " + e2);
                    }
                }
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            packages = this.mSettings.getVolumePackagesLPr(volumeUuid);
        }
        boolean bl = false;
        for (PackageSetting ps : packages) {
            String packageName2 = ps.name;
            if (ps.pkg == null) {
                Slog.w(TAG, "Odd, missing scanned package " + packageName2);
                continue;
            }
            if (onlyCoreApps && !ps.pkg.coreApp) {
                result.add(packageName2);
                continue;
            }
            if (!ps.getInstalled(userId)) continue;
            this.prepareAppDataAndMigrateLIF(ps.pkg, userId, flags, migrateAppData);
            ++var10_15;
        }
        Slog.v(TAG, "reconcileAppsData finished " + (int)var10_15 + " packages");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void prepareAppDataAfterInstallLIF(PackageParser.Package pkg) {
        PackageSetting ps;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(pkg.packageName);
            this.mSettings.writeKernelMappingLPr(ps);
        }
        UserManager um = this.mContext.getSystemService(UserManager.class);
        UserManagerInternal umInternal = this.getUserManagerInternal();
        for (UserInfo user : um.getUsers()) {
            void var7_8;
            int flags;
            if (umInternal.isUserUnlockingOrUnlocked(user.id)) {
                flags = 3;
            } else {
                if (!umInternal.isUserRunning(user.id)) continue;
                flags = 1;
            }
            if (!ps.getInstalled(user.id)) continue;
            this.prepareAppDataLIF(pkg, user.id, (int)var7_8);
        }
    }

    private void prepareAppDataLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.prepareAppDataLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.prepareAppDataLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
    }

    private void prepareAppDataAndMigrateLIF(PackageParser.Package pkg, int userId, int flags, boolean maybeMigrateAppData) {
        this.prepareAppDataLIF(pkg, userId, flags);
        if (maybeMigrateAppData && this.maybeMigrateAppDataLIF(pkg, userId)) {
            this.prepareAppDataLIF(pkg, userId, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAppDataLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        String volumeUuid = pkg.volumeUuid;
        String packageName = pkg.packageName;
        ApplicationInfo app = pkg.applicationInfo;
        int appId = UserHandle.getAppId(app.uid);
        Preconditions.checkNotNull(app.seInfo);
        long ceDataInode = -1L;
        try {
            ceDataInode = this.mInstaller.createAppData(volumeUuid, packageName, userId, flags, appId, app.seInfo, app.targetSdkVersion);
        }
        catch (Installer.InstallerException e) {
            if (app.isSystemApp()) {
                PackageManagerService.logCriticalInfo(6, "Failed to create app data for " + packageName + ", but trying to recover: " + e);
                this.destroyAppDataLeafLIF(pkg, userId, flags);
                try {
                    ceDataInode = this.mInstaller.createAppData(volumeUuid, packageName, userId, flags, appId, app.seInfo, app.targetSdkVersion);
                    PackageManagerService.logCriticalInfo(3, "Recovery succeeded!");
                }
                catch (Installer.InstallerException e2) {
                    PackageManagerService.logCriticalInfo(3, "Recovery failed!");
                }
            }
            Slog.e(TAG, "Failed to create app data for " + packageName + ": " + e);
        }
        if ((flags & 2) != 0 && ceDataInode != -1L) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps != null) {
                    ps.setCeDataInode(ceDataInode, userId);
                }
            }
        }
        this.prepareAppDataContentsLeafLIF(pkg, userId, flags);
    }

    private void prepareAppDataContentsLIF(PackageParser.Package pkg, int userId, int flags) {
        if (pkg == null) {
            Slog.wtf(TAG, "Package was null!", new Throwable());
            return;
        }
        this.prepareAppDataContentsLeafLIF(pkg, userId, flags);
        int childCount = pkg.childPackages != null ? pkg.childPackages.size() : 0;
        for (int i = 0; i < childCount; ++i) {
            this.prepareAppDataContentsLeafLIF(pkg.childPackages.get(i), userId, flags);
        }
    }

    private void prepareAppDataContentsLeafLIF(PackageParser.Package pkg, int userId, int flags) {
        String volumeUuid = pkg.volumeUuid;
        String packageName = pkg.packageName;
        ApplicationInfo app = pkg.applicationInfo;
        if ((flags & 2) != 0 && app.primaryCpuAbi != null && !VMRuntime.is64BitAbi(app.primaryCpuAbi)) {
            String nativeLibPath = app.nativeLibraryDir;
            try {
                this.mInstaller.linkNativeLibraryDirectory(volumeUuid, packageName, nativeLibPath, userId);
            }
            catch (Installer.InstallerException e) {
                Slog.e(TAG, "Failed to link native for " + packageName + ": " + e);
            }
        }
    }

    private boolean maybeMigrateAppDataLIF(PackageParser.Package pkg, int userId) {
        if (pkg.isSystemApp() && !StorageManager.isFileEncryptedNativeOrEmulated()) {
            int storageTarget = pkg.applicationInfo.isDefaultToDeviceProtectedStorage() ? 1 : 2;
            try {
                this.mInstaller.migrateAppData(pkg.volumeUuid, pkg.packageName, userId, storageTarget);
            }
            catch (Installer.InstallerException e) {
                PackageManagerService.logCriticalInfo(5, "Failed to migrate " + pkg.packageName + ": " + e.getMessage());
            }
            return true;
        }
        return false;
    }

    public PackageFreezer freezePackage(String packageName, String killReason) {
        return this.freezePackage(packageName, -1, killReason);
    }

    public PackageFreezer freezePackage(String packageName, int userId, String killReason) {
        return new PackageFreezer(packageName, userId, killReason);
    }

    public PackageFreezer freezePackageForInstall(String packageName, int installFlags, String killReason) {
        return this.freezePackageForInstall(packageName, -1, installFlags, killReason);
    }

    public PackageFreezer freezePackageForInstall(String packageName, int userId, int installFlags, String killReason) {
        if ((installFlags & 0x1000) != 0) {
            return new PackageFreezer();
        }
        return this.freezePackage(packageName, userId, killReason);
    }

    public PackageFreezer freezePackageForDelete(String packageName, int deleteFlags, String killReason) {
        return this.freezePackageForDelete(packageName, -1, deleteFlags, killReason);
    }

    public PackageFreezer freezePackageForDelete(String packageName, int userId, int deleteFlags, String killReason) {
        if ((deleteFlags & 8) != 0) {
            return new PackageFreezer();
        }
        return this.freezePackage(packageName, userId, killReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPackageFrozen(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (!this.mFrozenPackages.contains(packageName)) {
                Slog.wtf(TAG, "Expected " + packageName + " to be frozen!", new Throwable());
            }
        }
    }

    @Override
    public int movePackage(final String packageName, final String volumeUuid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        final int callingUid = Binder.getCallingUid();
        final UserHandle user = new UserHandle(UserHandle.getUserId(callingUid));
        final int moveId = this.mNextMoveId.getAndIncrement();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    PackageManagerService.this.movePackageInternal(packageName, volumeUuid, moveId, callingUid, user);
                }
                catch (PackageManagerException e) {
                    Slog.w(PackageManagerService.TAG, "Failed to move " + packageName, e);
                    PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -6);
                }
            }
        });
        return moveId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePackageInternal(String packageName, String volumeUuid, final int moveId, int callingUid, UserHandle user) throws PackageManagerException {
        MoveInfo move;
        File measurePath;
        boolean moveCompleteApp;
        int installFlags;
        int[] installedUserIds;
        PackageFreezer freezer;
        int targetSdkVersion;
        String label;
        String seinfo;
        int appId;
        String packageAbiOverride;
        String installerPackageName;
        File codeFile;
        String currentVolumeUuid;
        boolean currentAsec;
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        PackageManager pm = this.mContext.getPackageManager();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (pkg == null || ps == null || this.filterAppAccessLPr(ps, callingUid, user.getIdentifier())) {
                throw new PackageManagerException(-2, "Missing package");
            }
            if (pkg.applicationInfo.isSystemApp()) {
                throw new PackageManagerException(-3, "Cannot move system application");
            }
            boolean isInternalStorage = "private".equals(volumeUuid);
            boolean allow3rdPartyOnInternal = this.mContext.getResources().getBoolean(17956869);
            if (isInternalStorage && !allow3rdPartyOnInternal) {
                throw new PackageManagerException(-9, "3rd party apps are not allowed on internal storage");
            }
            if (pkg.applicationInfo.isExternalAsec()) {
                currentAsec = true;
                currentVolumeUuid = "primary_physical";
            } else if (pkg.applicationInfo.isForwardLocked()) {
                currentAsec = true;
                currentVolumeUuid = "forward_locked";
            } else {
                currentAsec = false;
                currentVolumeUuid = ps.volumeUuid;
                File probe = new File(pkg.codePath);
                File probeOat = new File(probe, "oat");
                if (!probe.isDirectory() || !probeOat.isDirectory()) {
                    throw new PackageManagerException(-6, "Move only supported for modern cluster style installs");
                }
            }
            if (Objects.equals(currentVolumeUuid, volumeUuid)) {
                throw new PackageManagerException(-6, "Package already moved to " + volumeUuid);
            }
            if (pkg.applicationInfo.isInternal() && this.isPackageDeviceAdminOnAnyUser(packageName)) {
                throw new PackageManagerException(-8, "Device admin cannot be moved");
            }
            if (this.mFrozenPackages.contains(packageName)) {
                throw new PackageManagerException(-7, "Failed to move already frozen package");
            }
            codeFile = new File(pkg.codePath);
            installerPackageName = ps.installerPackageName;
            packageAbiOverride = ps.cpuAbiOverrideString;
            appId = UserHandle.getAppId(pkg.applicationInfo.uid);
            seinfo = pkg.applicationInfo.seInfo;
            label = String.valueOf(pm.getApplicationLabel(pkg.applicationInfo));
            targetSdkVersion = pkg.applicationInfo.targetSdkVersion;
            freezer = this.freezePackage(packageName, "movePackageInternal");
            installedUserIds = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
        }
        Bundle extras = new Bundle();
        extras.putString("android.intent.extra.PACKAGE_NAME", packageName);
        extras.putString("android.intent.extra.TITLE", label);
        this.mMoveCallbacks.notifyCreated(moveId, extras);
        if (Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, volumeUuid)) {
            installFlags = 16;
            moveCompleteApp = !currentAsec;
            measurePath = Environment.getDataAppDirectory(volumeUuid);
        } else if (Objects.equals("primary_physical", volumeUuid)) {
            installFlags = 8;
            moveCompleteApp = false;
            measurePath = storage.getPrimaryPhysicalVolume().getPath();
        } else {
            VolumeInfo volume = storage.findVolumeByUuid(volumeUuid);
            if (volume == null || volume.getType() != 1 || !volume.isMountedWritable()) {
                freezer.close();
                throw new PackageManagerException(-6, "Move location not mounted private volume");
            }
            Preconditions.checkState(!currentAsec);
            installFlags = 16;
            moveCompleteApp = true;
            measurePath = Environment.getDataAppDirectory(volumeUuid);
        }
        PackageStats stats = new PackageStats(null, -1);
        Installer installer = this.mInstaller;
        synchronized (installer) {
            for (int userId : installedUserIds) {
                if (this.getPackageSizeInfoLI(packageName, userId, stats)) continue;
                freezer.close();
                throw new PackageManagerException(-6, "Failed to measure package size");
            }
        }
        final long startFreeBytes = measurePath.getUsableSpace();
        final long sizeBytes = moveCompleteApp ? stats.codeSize + stats.dataSize : stats.codeSize;
        if (sizeBytes > storage.getStorageBytesUntilLow(measurePath)) {
            freezer.close();
            throw new PackageManagerException(-6, "Not enough free space to move");
        }
        this.mMoveCallbacks.notifyStatusChanged(moveId, 10);
        final CountDownLatch installedLatch = new CountDownLatch(1);
        IPackageInstallObserver2.Stub installObserver = new IPackageInstallObserver2.Stub(){

            @Override
            public void onUserActionRequired(Intent intent) throws RemoteException {
                throw new IllegalStateException();
            }

            @Override
            public void onPackageInstalled(String basePackageName, int returnCode, String msg, Bundle extras) throws RemoteException {
                installedLatch.countDown();
                freezer.close();
                int status = PackageManager.installStatusToPublicStatus(returnCode);
                switch (status) {
                    case 0: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -100);
                        break;
                    }
                    case 6: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -1);
                        break;
                    }
                    default: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -6);
                    }
                }
            }
        };
        if (moveCompleteApp) {
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            if (installedLatch.await(1L, TimeUnit.SECONDS)) {
                                break;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        long deltaFreeBytes = startFreeBytes - measurePath.getUsableSpace();
                        int progress = 10 + (int)MathUtils.constrain(deltaFreeBytes * 80L / sizeBytes, 0L, 80L);
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, progress);
                    }
                }
            }.start();
            String dataAppName = codeFile.getName();
            move = new MoveInfo(moveId, currentVolumeUuid, volumeUuid, packageName, dataAppName, appId, seinfo, targetSdkVersion);
        } else {
            move = null;
        }
        Message msg = this.mHandler.obtainMessage(5);
        OriginInfo origin = OriginInfo.fromExistingFile(codeFile);
        InstallParams params = new InstallParams(origin, move, installObserver, installFlags |= 2, installerPackageName, volumeUuid, null, user, packageAbiOverride, null, null, 0);
        params.setTraceMethod("movePackage").setTraceCookie(System.identityHashCode(params));
        msg.obj = params;
        Trace.asyncTraceBegin(262144L, "movePackage", System.identityHashCode(msg.obj));
        Trace.asyncTraceBegin(262144L, "queueInstall", System.identityHashCode(msg.obj));
        this.mHandler.sendMessage(msg);
    }

    @Override
    public int movePrimaryStorage(String volumeUuid) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        final int realMoveId = this.mNextMoveId.getAndIncrement();
        Bundle extras = new Bundle();
        extras.putString("android.os.storage.extra.FS_UUID", volumeUuid);
        this.mMoveCallbacks.notifyCreated(realMoveId, extras);
        IPackageMoveObserver.Stub callback = new IPackageMoveObserver.Stub(){

            @Override
            public void onCreated(int moveId, Bundle extras) {
            }

            @Override
            public void onStatusChanged(int moveId, int status, long estMillis) {
                PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(realMoveId, status, estMillis);
            }
        };
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        storage.setPrimaryStorageUuid(volumeUuid, callback);
        return realMoveId;
    }

    @Override
    public int getMoveStatus(int moveId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        return this.mMoveCallbacks.mLastStatus.get(moveId);
    }

    @Override
    public void registerMoveCallback(IPackageMoveObserver callback) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        this.mMoveCallbacks.register(callback);
    }

    @Override
    public void unregisterMoveCallback(IPackageMoveObserver callback) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        this.mMoveCallbacks.unregister(callback);
    }

    @Override
    public boolean setInstallLocation(int loc) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
        if (this.getInstallLocation() == loc) {
            return true;
        }
        if (loc == 0 || loc == 1 || loc == 2) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "default_install_location", loc);
            return true;
        }
        return false;
    }

    @Override
    public int getInstallLocation() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "default_install_location", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpUser(UserManagerService userManager, int userHandle) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mDirtyUsers.remove(userHandle);
            this.mUserNeedsBadging.delete(userHandle);
            this.mSettings.removeUserLPw(userHandle);
            this.mPendingBroadcasts.remove(userHandle);
            this.mInstantAppRegistry.onUserRemovedLPw(userHandle);
            this.removeUnusedPackagesLPw(userManager, userHandle);
        }
    }

    private void removeUnusedPackagesLPw(UserManagerService userManager, final int userHandle) {
        boolean DEBUG_CLEAN_APKS = false;
        int[] users = userManager.getUserIds();
        for (PackageSetting ps : this.mSettings.mPackages.values()) {
            if (ps.pkg == null) continue;
            final String packageName = ps.pkg.packageName;
            if ((ps.pkgFlags & 1) != 0) continue;
            boolean keep = this.shouldKeepUninstalledPackageLPr(packageName);
            if (!keep) {
                for (int i = 0; i < users.length; ++i) {
                    if (users[i] == userHandle || !ps.getInstalled(users[i])) continue;
                    keep = true;
                    break;
                }
            }
            if (keep) continue;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PackageManagerService.this.deletePackageX(packageName, -1, userHandle, 0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewUser(int userId, String[] disallowedPackages) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mInstallLock;
        synchronized (arrayMap) {
            this.mSettings.createNewUserLI(this, this.mInstaller, userId, disallowedPackages);
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.scheduleWritePackageRestrictionsLocked(userId);
            this.scheduleWritePackageListLocked(userId);
            this.applyFactoryDefaultBrowserLPw(userId);
            this.primeDomainVerificationsLPw(userId);
        }
    }

    void onNewUserCreated(int userId) {
        this.mDefaultPermissionPolicy.grantDefaultPermissions(userId);
        if (this.mPermissionReviewRequired) {
            this.updatePermissionsLPw(null, null, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can read the verifier device identity");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getVerifierDeviceIdentityLPw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionEnforced(String permission2, boolean enforced) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", "setPermissionEnforced");
        if ("android.permission.READ_EXTERNAL_STORAGE".equals(permission2)) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if (this.mSettings.mReadExternalStorageEnforced == null || this.mSettings.mReadExternalStorageEnforced != enforced) {
                    this.mSettings.mReadExternalStorageEnforced = enforced;
                    this.mSettings.writeLPr();
                }
            }
            IActivityManager am = ActivityManager.getService();
            if (am != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    am.killProcessesBelowForeground("setPermissionEnforcement");
                }
                catch (RemoteException remoteException) {
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        } else {
            throw new IllegalArgumentException("No selective enforcement for " + permission2);
        }
    }

    @Override
    @Deprecated
    public boolean isPermissionEnforced(String permission2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStorageLow() {
        long token = Binder.clearCallingIdentity();
        try {
            DeviceStorageMonitorInternal dsm = LocalServices.getService(DeviceStorageMonitorInternal.class);
            if (dsm != null) {
                boolean bl = dsm.isMemoryLow();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public IPackageInstaller getPackageInstaller() {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        return this.mInstallerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userNeedsBadging(int userId) {
        int index = this.mUserNeedsBadging.indexOfKey(userId);
        if (index < 0) {
            UserInfo userInfo;
            long token = Binder.clearCallingIdentity();
            try {
                userInfo = sUserManager.getUserInfo(userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            boolean b = userInfo != null && userInfo.isManagedProfile();
            this.mUserNeedsBadging.put(userId, b);
            return b;
        }
        return this.mUserNeedsBadging.valueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getKeySetByAlias(String packageName, String alias) {
        if (packageName == null || alias == null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (this.filterAppAccessLPr(ps, Binder.getCallingUid(), UserHandle.getCallingUserId())) {
                Slog.w(TAG, "KeySet requested for filtered package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getKeySetByAliasAndPackageNameLPr(packageName, alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getSigningKeySet(String packageName) {
        if (packageName == null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int callingUid = Binder.getCallingUid();
            int callingUserId = UserHandle.getUserId(callingUid);
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (this.filterAppAccessLPr(ps, callingUid, callingUserId)) {
                Slog.w(TAG, "KeySet requested for filtered package: " + packageName + ", uid:" + callingUid);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            if (pkg.applicationInfo.uid != callingUid && 1000 != callingUid) {
                throw new SecurityException("May not access signing KeySet of other apps.");
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getSigningKeySetByPackageNameLPr(packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySet(String packageName, KeySet ks) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return false;
        }
        if (packageName == null || ks == null) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null || this.filterAppAccessLPr((PackageSetting)pkg.mExtras, callingUid, UserHandle.getUserId(callingUid))) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySetExactly(String packageName, KeySet ks) {
        int callingUid = Binder.getCallingUid();
        if (this.getInstantAppPackageName(callingUid) != null) {
            return false;
        }
        if (packageName == null || ks == null) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null || this.filterAppAccessLPr((PackageSetting)pkg.mExtras, callingUid, UserHandle.getUserId(callingUid))) {
                Slog.w(TAG, "KeySet requested for unknown package: " + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByExactlyLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    private void deletePackageIfUnusedLPr(final String packageName) {
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps == null) {
            return;
        }
        if (!ps.isAnyInstalled(sUserManager.getUserIds())) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PackageManagerService.this.deletePackageX(packageName, -1, 0, 2);
                }
            });
        }
    }

    private static void checkDowngrade(PackageParser.Package before, PackageInfoLite after) throws PackageManagerException {
        if (after.versionCode < before.mVersionCode) {
            throw new PackageManagerException(-25, "Update version code " + after.versionCode + " is older than current " + before.mVersionCode);
        }
        if (after.versionCode == before.mVersionCode) {
            if (after.baseRevisionCode < before.baseRevisionCode) {
                throw new PackageManagerException(-25, "Update base revision code " + after.baseRevisionCode + " is older than current " + before.baseRevisionCode);
            }
            if (!ArrayUtils.isEmpty(after.splitNames)) {
                for (int i = 0; i < after.splitNames.length; ++i) {
                    String splitName = after.splitNames[i];
                    int j = ArrayUtils.indexOf(before.splitNames, splitName);
                    if (j == -1 || after.splitRevisionCodes[i] >= before.splitRevisionCodes[j]) continue;
                    throw new PackageManagerException(-25, "Update split " + splitName + " revision code " + after.splitRevisionCodes[i] + " is older than current " + before.splitRevisionCodes[j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("grantPermissionsToEnabledCarrierApps");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToEnabledCarrierAppsLPr(packageNames, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDefaultPermissionsToEnabledImsServices(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("grantDefaultPermissionsToEnabledImsServices");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToEnabledImsServicesLPr(packageNames, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static void enforceSystemOrPhoneCaller(String tag) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1001 && callingUid != 1000) {
            throw new SecurityException("Cannot call " + tag + " from UID " + callingUid);
        }
    }

    boolean isHistoricalPackageUsageAvailable() {
        return this.mPackageUsage.isHistoricalPackageUsageAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<PackageParser.Package> getPackages() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return new ArrayList<PackageParser.Package>(this.mPackages.values());
        }
    }

    @Override
    public void logAppProcessStartIfNeeded(String processName, int uid, String seinfo, String apkFile, int pid) {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return;
        }
        if (!SecurityLog.isLoggingEnabled()) {
            return;
        }
        Bundle data = new Bundle();
        data.putLong("startTimestamp", System.currentTimeMillis());
        data.putString("processName", processName);
        data.putInt("uid", uid);
        data.putString("seinfo", seinfo);
        data.putString("apkFile", apkFile);
        data.putInt("pid", pid);
        Message msg = this.mProcessLoggingHandler.obtainMessage(1);
        msg.setData(data);
        this.mProcessLoggingHandler.sendMessage(msg);
    }

    public CompilerStats.PackageStats getCompilerPackageStats(String pkgName) {
        return this.mCompilerStats.getPackageStats(pkgName);
    }

    public CompilerStats.PackageStats getOrCreateCompilerPackageStats(PackageParser.Package pkg) {
        return this.getOrCreateCompilerPackageStats(pkg.packageName);
    }

    public CompilerStats.PackageStats getOrCreateCompilerPackageStats(String pkgName) {
        return this.mCompilerStats.getOrCreatePackageStats(pkgName);
    }

    public void deleteCompilerPackageStats(String pkgName) {
        this.mCompilerStats.deletePackageStats(pkgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInstallReason(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "get install reason");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (this.filterAppAccessLPr(ps, callingUid, userId)) {
                return 0;
            }
            if (ps != null) {
                return ps.getInstallReason(userId);
            }
        }
        return 0;
    }

    @Override
    public boolean canRequestPackageInstalls(String packageName, int userId) {
        return this.canRequestPackageInstallsInternal(packageName, 0, userId, true);
    }

    private boolean canRequestPackageInstallsInternal(String packageName, int flags, int userId, boolean throwIfPermNotDeclared) {
        int isTrusted;
        int uid;
        int callingUid = Binder.getCallingUid();
        if (callingUid != (uid = this.getPackageUid(packageName, 0, userId)) && callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("Caller uid " + callingUid + " does not own package " + packageName);
        }
        ApplicationInfo info = this.getApplicationInfo(packageName, flags, userId);
        if (info == null) {
            return false;
        }
        if (info.targetSdkVersion < 26) {
            return false;
        }
        String appOpPermission = "android.permission.REQUEST_INSTALL_PACKAGES";
        String[] packagesDeclaringPermission = this.getAppOpPermissionPackages(appOpPermission);
        if (!ArrayUtils.contains(packagesDeclaringPermission, packageName)) {
            if (throwIfPermNotDeclared) {
                throw new SecurityException("Need to declare " + appOpPermission + " to call this api");
            }
            Slog.e(TAG, "Need to declare " + appOpPermission + " to call this api");
            return false;
        }
        if (sUserManager.hasUserRestriction("no_install_unknown_sources", userId)) {
            return false;
        }
        if (this.mExternalSourcesPolicy != null && (isTrusted = this.mExternalSourcesPolicy.getPackageTrustedToInstallApps(packageName, uid)) != 2) {
            return isTrusted == 0;
        }
        return this.checkUidPermission(appOpPermission, uid) == 0;
    }

    @Override
    public ComponentName getInstantAppResolverSettingsComponent() {
        return this.mInstantAppResolverSettingsComponent;
    }

    @Override
    public ComponentName getInstantAppInstallerComponent() {
        if (this.getInstantAppPackageName(Binder.getCallingUid()) != null) {
            return null;
        }
        return this.mInstantAppInstallerActivity == null ? null : this.mInstantAppInstallerActivity.getComponentName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstantAppAndroidId(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_INSTANT_APPS", "getInstantAppAndroidId");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getInstantAppAndroidId");
        if (!this.isInstantApp(packageName, userId)) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mInstantAppRegistry.getInstantAppAndroidIdLPw(packageName, userId);
        }
    }

    static {
        sBrowserIntent.setAction("android.intent.action.VIEW");
        sBrowserIntent.addCategory("android.intent.category.BROWSABLE");
        sBrowserIntent.setData(Uri.parse("http:"));
        PROTECTED_ACTIONS = new ArraySet<String>();
        PROTECTED_ACTIONS.add("android.intent.action.SEND");
        PROTECTED_ACTIONS.add("android.intent.action.SENDTO");
        PROTECTED_ACTIONS.add("android.intent.action.SEND_MULTIPLE");
        PROTECTED_ACTIONS.add("android.intent.action.VIEW");
        ALL_DANGEROUS_PERMISSIONS = Arrays.asList("android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR", "android.permission.CAMERA", "android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS", "android.permission.GET_ACCOUNTS", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.RECORD_AUDIO", "android.permission.READ_PHONE_STATE", "android.permission.CALL_PHONE", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.USE_SIP", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.READ_CELL_BROADCASTS", "android.permission.BODY_SENSORS", "android.permission.SEND_SMS", "android.permission.RECEIVE_SMS", "android.permission.READ_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECEIVE_MMS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_NUMBERS", "android.permission.ANSWER_PHONE_CALLS");
        mResolvePrioritySorter = new Comparator<ResolveInfo>(){

            @Override
            public int compare(ResolveInfo r1, ResolveInfo r2) {
                int v1 = r1.priority;
                int v2 = r2.priority;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                v1 = r1.preferredOrder;
                v2 = r2.preferredOrder;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.isDefault != r2.isDefault) {
                    return r1.isDefault ? -1 : 1;
                }
                v1 = r1.match;
                v2 = r2.match;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.system != r2.system) {
                    return r1.system ? -1 : 1;
                }
                if (r1.activityInfo != null) {
                    return r1.activityInfo.packageName.compareTo(r2.activityInfo.packageName);
                }
                if (r1.serviceInfo != null) {
                    return r1.serviceInfo.packageName.compareTo(r2.serviceInfo.packageName);
                }
                if (r1.providerInfo != null) {
                    return r1.providerInfo.packageName.compareTo(r2.providerInfo.packageName);
                }
                return 0;
            }
        };
        mProviderInitOrderSorter = new Comparator<ProviderInfo>(){

            @Override
            public int compare(ProviderInfo p1, ProviderInfo p2) {
                int v1 = p1.initOrder;
                int v2 = p2.initOrder;
                return v1 > v2 ? -1 : (v1 < v2 ? 1 : 0);
            }
        };
    }

    private class PackageManagerInternalImpl
    extends PackageManagerInternal {
        private PackageManagerInternalImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLocationPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setLocationPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVoiceInteractionPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setVoiceInteractionPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSmsAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setSmsAppPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDialerAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setDialerAppPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSimCallManagerPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setSimCallManagerPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSyncAdapterPackagesprovider(PackageManagerInternal.SyncAdapterPackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setSyncAdapterPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantDefaultPermissionsToDefaultSmsApp(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultSmsAppLPr(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantDefaultPermissionsToDefaultDialerApp(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mSettings.setDefaultDialerPackageNameLPw(packageName, userId);
                PackageManagerService.this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultDialerAppLPr(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantDefaultPermissionsToDefaultSimCallManager(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultSimCallManagerLPr(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setKeepUninstalledPackages(List<String> packageList) {
            Preconditions.checkNotNull(packageList);
            ArrayList<String> removedFromList = null;
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                int i;
                if (PackageManagerService.this.mKeepUninstalledPackages != null) {
                    int packagesCount = PackageManagerService.this.mKeepUninstalledPackages.size();
                    for (i = 0; i < packagesCount; ++i) {
                        String oldPackage = (String)PackageManagerService.this.mKeepUninstalledPackages.get(i);
                        if (packageList != null && packageList.contains(oldPackage)) continue;
                        if (removedFromList == null) {
                            removedFromList = new ArrayList<String>();
                        }
                        removedFromList.add(oldPackage);
                    }
                }
                PackageManagerService.this.mKeepUninstalledPackages = new ArrayList<String>(packageList);
                if (removedFromList != null) {
                    int removedCount = removedFromList.size();
                    for (i = 0; i < removedCount; ++i) {
                        PackageManagerService.this.deletePackageIfUnusedLPr((String)removedFromList.get(i));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPermissionsReviewRequired(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                if (!PackageManagerService.this.mPermissionReviewRequired) {
                    return false;
                }
                PackageSetting packageSetting = PackageManagerService.this.mSettings.mPackages.get(packageName);
                if (packageSetting == null) {
                    return false;
                }
                if (packageSetting.pkg.applicationInfo.targetSdkVersion >= 23) {
                    return false;
                }
                PermissionsState permissionsState = packageSetting.getPermissionsState();
                return permissionsState.isPermissionReviewRequired(userId);
            }
        }

        @Override
        public PackageInfo getPackageInfo(String packageName, int flags, int filterCallingUid, int userId) {
            return PackageManagerService.this.getPackageInfoInternal(packageName, -1, flags, filterCallingUid, userId);
        }

        @Override
        public ApplicationInfo getApplicationInfo(String packageName, int flags, int filterCallingUid, int userId) {
            return PackageManagerService.this.getApplicationInfoInternal(packageName, flags, filterCallingUid, userId);
        }

        @Override
        public ActivityInfo getActivityInfo(ComponentName component, int flags, int filterCallingUid, int userId) {
            return PackageManagerService.this.getActivityInfoInternal(component, flags, filterCallingUid, userId);
        }

        @Override
        public List<ResolveInfo> queryIntentActivities(Intent intent, int flags, int filterCallingUid, int userId) {
            String resolvedType = intent.resolveTypeIfNeeded(PackageManagerService.this.mContext.getContentResolver());
            return PackageManagerService.this.queryIntentActivitiesInternal(intent, resolvedType, flags, filterCallingUid, userId, false);
        }

        @Override
        public ComponentName getHomeActivitiesAsUser(List<ResolveInfo> allHomeCandidates, int userId) {
            return PackageManagerService.this.getHomeActivitiesAsUser(allHomeCandidates, userId);
        }

        @Override
        public void setDeviceAndProfileOwnerPackages(int deviceOwnerUserId, String deviceOwnerPackage, SparseArray<String> profileOwnerPackages) {
            PackageManagerService.this.mProtectedPackages.setDeviceAndProfileOwnerPackages(deviceOwnerUserId, deviceOwnerPackage, profileOwnerPackages);
        }

        @Override
        public boolean isPackageDataProtected(int userId, String packageName) {
            return PackageManagerService.this.mProtectedPackages.isPackageDataProtected(userId, packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPackageEphemeral(int userId, String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(packageName);
                return ps != null ? ps.getInstantApp(userId) : false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean wasPackageEverLaunched(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mSettings.wasPackageEverLaunchedLPr(packageName, userId);
            }
        }

        @Override
        public void grantRuntimePermission(String packageName, String name, int userId, boolean overridePolicy) {
            PackageManagerService.this.grantRuntimePermission(packageName, name, userId, overridePolicy);
        }

        @Override
        public void revokeRuntimePermission(String packageName, String name, int userId, boolean overridePolicy) {
            PackageManagerService.this.revokeRuntimePermission(packageName, name, userId, overridePolicy);
        }

        @Override
        public String getNameForUid(int uid) {
            return PackageManagerService.this.getNameForUid(uid);
        }

        @Override
        public void requestInstantAppResolutionPhaseTwo(AuxiliaryResolveInfo responseObj, Intent origIntent, String resolvedType, String callingPackage, Bundle verificationBundle, int userId) {
            PackageManagerService.this.requestInstantAppResolutionPhaseTwo(responseObj, origIntent, resolvedType, callingPackage, verificationBundle, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantEphemeralAccess(int userId, Intent intent, int targetAppId, int ephemeralAppId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mInstantAppRegistry.grantInstantAccessLPw(userId, intent, targetAppId, ephemeralAppId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInstantAppInstallerComponent(ComponentName component) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.mInstantAppInstallerActivity != null && PackageManagerService.this.mInstantAppInstallerActivity.getComponentName().equals(component);
            }
        }

        @Override
        public void pruneInstantApps() {
            PackageManagerService.this.mInstantAppRegistry.pruneInstantApps();
        }

        @Override
        public String getSetupWizardPackageName() {
            return PackageManagerService.this.mSetupWizardPackage;
        }

        @Override
        public void setExternalSourcesPolicy(PackageManagerInternal.ExternalSourcesPolicy policy) {
            if (policy != null) {
                PackageManagerService.this.mExternalSourcesPolicy = policy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPackagePersistent(String packageName) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                return pkg != null ? (pkg.applicationInfo.flags & 9) == 9 : false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PackageInfo> getOverlayPackages(int userId) {
            ArrayList<PackageInfo> overlayPackages = new ArrayList<PackageInfo>();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                for (PackageParser.Package p : PackageManagerService.this.mPackages.values()) {
                    PackageInfo pkg;
                    if (p.mOverlayTarget == null || (pkg = PackageManagerService.this.generatePackageInfo((PackageSetting)p.mExtras, 0, userId)) == null) continue;
                    overlayPackages.add(pkg);
                }
            }
            return overlayPackages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getTargetPackageNames(int userId) {
            ArrayList<String> targetPackages = new ArrayList<String>();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                for (PackageParser.Package p : PackageManagerService.this.mPackages.values()) {
                    if (p.mOverlayTarget != null) continue;
                    targetPackages.add(p.packageName);
                }
            }
            return targetPackages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setEnabledOverlayPackages(int userId, String targetPackageName, List<String> overlayPackageNames) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                if (targetPackageName == null || PackageManagerService.this.mPackages.get(targetPackageName) == null) {
                    Slog.e(PackageManagerService.TAG, "failed to find package " + targetPackageName);
                    return false;
                }
                ArrayList<String> overlayPaths = null;
                if (overlayPackageNames != null && overlayPackageNames.size() > 0) {
                    int N = overlayPackageNames.size();
                    overlayPaths = new ArrayList<String>(N);
                    for (int i = 0; i < N; ++i) {
                        String packageName = overlayPackageNames.get(i);
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                        if (pkg == null) {
                            Slog.e(PackageManagerService.TAG, "failed to find package " + packageName);
                            return false;
                        }
                        overlayPaths.add(pkg.baseCodePath);
                    }
                }
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(targetPackageName);
                ps.setOverlayPaths(overlayPaths, userId);
                return true;
            }
        }

        @Override
        public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) {
            return PackageManagerService.this.resolveIntentInternal(intent, resolvedType, flags, userId, true);
        }

        @Override
        public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId, int callingUid) {
            return PackageManagerService.this.resolveServiceInternal(intent, resolvedType, flags, userId, callingUid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addIsolatedUid(int isolatedUid, int ownerUid) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mIsolatedOwners.put(isolatedUid, ownerUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeIsolatedUid(int isolatedUid) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mIsolatedOwners.delete(isolatedUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getUidTargetSdkVersion(int uid) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return PackageManagerService.this.getUidTargetSdkVersionLockedLPr(uid);
            }
        }

        @Override
        public boolean canAccessInstantApps(int callingUid, int userId) {
            return PackageManagerService.this.canViewInstantApps(callingUid, userId);
        }
    }

    private static final class OnPermissionChangeListeners
    extends Handler {
        private static final int MSG_ON_PERMISSIONS_CHANGED = 1;
        private final RemoteCallbackList<IOnPermissionsChangeListener> mPermissionListeners = new RemoteCallbackList();

        public OnPermissionChangeListeners(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    this.handleOnPermissionsChanged(uid);
                }
            }
        }

        public void addListenerLocked(IOnPermissionsChangeListener listener) {
            this.mPermissionListeners.register(listener);
        }

        public void removeListenerLocked(IOnPermissionsChangeListener listener) {
            this.mPermissionListeners.unregister(listener);
        }

        public void onPermissionsChanged(int uid) {
            if (this.mPermissionListeners.getRegisteredCallbackCount() > 0) {
                this.obtainMessage(1, uid, 0).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOnPermissionsChanged(int uid) {
            int count = this.mPermissionListeners.beginBroadcast();
            try {
                for (int i = 0; i < count; ++i) {
                    IOnPermissionsChangeListener callback = this.mPermissionListeners.getBroadcastItem(i);
                    try {
                        callback.onPermissionsChanged(uid);
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.e(PackageManagerService.TAG, "Permission listener is dead", e);
                    }
                }
            }
            finally {
                this.mPermissionListeners.finishBroadcast();
            }
        }
    }

    private static class MoveCallbacks
    extends Handler {
        private static final int MSG_CREATED = 1;
        private static final int MSG_STATUS_CHANGED = 2;
        private final RemoteCallbackList<IPackageMoveObserver> mCallbacks = new RemoteCallbackList();
        private final SparseIntArray mLastStatus = new SparseIntArray();

        public MoveCallbacks(Looper looper) {
            super(looper);
        }

        public void register(IPackageMoveObserver callback) {
            this.mCallbacks.register(callback);
        }

        public void unregister(IPackageMoveObserver callback) {
            this.mCallbacks.unregister(callback);
        }

        @Override
        public void handleMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            int n = this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                IPackageMoveObserver callback = this.mCallbacks.getBroadcastItem(i);
                try {
                    this.invokeCallback(callback, msg.what, args);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mCallbacks.finishBroadcast();
            args.recycle();
        }

        private void invokeCallback(IPackageMoveObserver callback, int what, SomeArgs args) throws RemoteException {
            switch (what) {
                case 1: {
                    callback.onCreated(args.argi1, (Bundle)args.arg2);
                    break;
                }
                case 2: {
                    callback.onStatusChanged(args.argi1, args.argi2, (Long)args.arg3);
                }
            }
        }

        private void notifyCreated(int moveId, Bundle extras) {
            Slog.v(PackageManagerService.TAG, "Move " + moveId + " created " + extras.toString());
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.arg2 = extras;
            this.obtainMessage(1, args).sendToTarget();
        }

        private void notifyStatusChanged(int moveId, int status) {
            this.notifyStatusChanged(moveId, status, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyStatusChanged(int moveId, int status, long estMillis) {
            Slog.v(PackageManagerService.TAG, "Move " + moveId + " status " + status);
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.argi2 = status;
            args.arg3 = estMillis;
            this.obtainMessage(2, args).sendToTarget();
            SparseIntArray sparseIntArray = this.mLastStatus;
            synchronized (sparseIntArray) {
                this.mLastStatus.put(moveId, status);
            }
        }
    }

    private class PackageFreezer
    implements AutoCloseable {
        private final String mPackageName;
        private final PackageFreezer[] mChildren;
        private final boolean mWeFroze;
        private final AtomicBoolean mClosed = new AtomicBoolean();
        private final CloseGuard mCloseGuard = CloseGuard.get();

        public PackageFreezer() {
            this.mPackageName = null;
            this.mChildren = null;
            this.mWeFroze = false;
            this.mCloseGuard.open("close");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PackageFreezer(String packageName, int userId, String killReason) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package p;
                this.mPackageName = packageName;
                this.mWeFroze = PackageManagerService.this.mFrozenPackages.add(this.mPackageName);
                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(this.mPackageName);
                if (ps != null) {
                    PackageManagerService.this.killApplication(ps.name, ps.appId, userId, killReason);
                }
                if ((p = PackageManagerService.this.mPackages.get(packageName)) != null && p.childPackages != null) {
                    int N = p.childPackages.size();
                    this.mChildren = new PackageFreezer[N];
                    for (int i = 0; i < N; ++i) {
                        this.mChildren[i] = new PackageFreezer(p.childPackages.get((int)i).packageName, userId, killReason);
                    }
                } else {
                    this.mChildren = null;
                }
            }
            this.mCloseGuard.open("close");
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.mCloseGuard.close();
            if (this.mClosed.compareAndSet(false, true)) {
                ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                synchronized (arrayMap) {
                    if (this.mWeFroze) {
                        PackageManagerService.this.mFrozenPackages.remove(this.mPackageName);
                    }
                    if (this.mChildren != null) {
                        for (PackageFreezer freezer : this.mChildren) {
                            freezer.close();
                        }
                    }
                }
            }
        }
    }

    static class DumpState {
        public static final int DUMP_LIBS = 1;
        public static final int DUMP_FEATURES = 2;
        public static final int DUMP_ACTIVITY_RESOLVERS = 4;
        public static final int DUMP_SERVICE_RESOLVERS = 8;
        public static final int DUMP_RECEIVER_RESOLVERS = 16;
        public static final int DUMP_CONTENT_RESOLVERS = 32;
        public static final int DUMP_PERMISSIONS = 64;
        public static final int DUMP_PACKAGES = 128;
        public static final int DUMP_SHARED_USERS = 256;
        public static final int DUMP_MESSAGES = 512;
        public static final int DUMP_PROVIDERS = 1024;
        public static final int DUMP_VERIFIERS = 2048;
        public static final int DUMP_PREFERRED = 4096;
        public static final int DUMP_PREFERRED_XML = 8192;
        public static final int DUMP_KEYSETS = 16384;
        public static final int DUMP_VERSION = 32768;
        public static final int DUMP_INSTALLS = 65536;
        public static final int DUMP_INTENT_FILTER_VERIFIERS = 131072;
        public static final int DUMP_DOMAIN_PREFERRED = 262144;
        public static final int DUMP_FROZEN = 524288;
        public static final int DUMP_DEXOPT = 0x100000;
        public static final int DUMP_COMPILER_STATS = 0x200000;
        public static final int DUMP_CHANGES = 0x400000;
        public static final int OPTION_SHOW_FILTERS = 1;
        private int mTypes;
        private int mOptions;
        private boolean mTitlePrinted;
        private SharedUserSetting mSharedUser;

        DumpState() {
        }

        public boolean isDumping(int type) {
            if (this.mTypes == 0 && type != 8192) {
                return true;
            }
            return (this.mTypes & type) != 0;
        }

        public void setDump(int type) {
            this.mTypes |= type;
        }

        public boolean isOptionEnabled(int option) {
            return (this.mOptions & option) != 0;
        }

        public void setOptionEnabled(int option) {
            this.mOptions |= option;
        }

        public boolean onTitlePrinted() {
            boolean printed = this.mTitlePrinted;
            this.mTitlePrinted = true;
            return printed;
        }

        public boolean getTitlePrinted() {
            return this.mTitlePrinted;
        }

        public void setTitlePrinted(boolean enabled) {
            this.mTitlePrinted = enabled;
        }

        public SharedUserSetting getSharedUser() {
            return this.mSharedUser;
        }

        public void setSharedUser(SharedUserSetting user) {
            this.mSharedUser = user;
        }
    }

    private static interface BlobXmlRestorer {
        public void apply(XmlPullParser var1, int var2) throws IOException, XmlPullParserException;
    }

    private final class ClearStorageConnection
    implements ServiceConnection {
        IMediaContainerService mContainerService;

        private ClearStorageConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            ClearStorageConnection clearStorageConnection = this;
            synchronized (clearStorageConnection) {
                this.mContainerService = IMediaContainerService.Stub.asInterface(Binder.allowBlocking(service));
                this.notifyAll();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    static class PackageRemovedInfo {
        final PackageSender packageSender;
        String removedPackage;
        String installerPackageName;
        int uid = -1;
        int removedAppId = -1;
        int[] origUsers;
        int[] removedUsers = null;
        int[] broadcastUsers = null;
        SparseArray<Integer> installReasons;
        boolean isRemovedPackageSystemUpdate = false;
        boolean isUpdate;
        boolean dataRemoved;
        boolean removedForAllUsers;
        boolean isStaticSharedLib;
        InstallArgs args = null;
        ArrayMap<String, PackageRemovedInfo> removedChildPackages;
        ArrayMap<String, PackageInstalledInfo> appearedChildPackages;

        PackageRemovedInfo(PackageSender packageSender) {
            this.packageSender = packageSender;
        }

        void sendPackageRemovedBroadcasts(boolean killApp) {
            this.sendPackageRemovedBroadcastInternal(killApp);
            int childCount = this.removedChildPackages != null ? this.removedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                PackageRemovedInfo childInfo = this.removedChildPackages.valueAt(i);
                childInfo.sendPackageRemovedBroadcastInternal(killApp);
            }
        }

        void sendSystemPackageUpdatedBroadcasts() {
            if (this.isRemovedPackageSystemUpdate) {
                this.sendSystemPackageUpdatedBroadcastsInternal();
                int childCount = this.removedChildPackages != null ? this.removedChildPackages.size() : 0;
                for (int i = 0; i < childCount; ++i) {
                    PackageRemovedInfo childInfo = this.removedChildPackages.valueAt(i);
                    if (!childInfo.isRemovedPackageSystemUpdate) continue;
                    childInfo.sendSystemPackageUpdatedBroadcastsInternal();
                }
            }
        }

        void sendSystemPackageAppearedBroadcasts() {
            int packageCount = this.appearedChildPackages != null ? this.appearedChildPackages.size() : 0;
            for (int i = 0; i < packageCount; ++i) {
                PackageInstalledInfo installedInfo = this.appearedChildPackages.valueAt(i);
                this.packageSender.sendPackageAddedForNewUsers(installedInfo.name, true, UserHandle.getAppId(installedInfo.uid), installedInfo.newUsers);
            }
        }

        private void sendSystemPackageUpdatedBroadcastsInternal() {
            Bundle extras = new Bundle(2);
            extras.putInt("android.intent.extra.UID", this.removedAppId >= 0 ? this.removedAppId : this.uid);
            extras.putBoolean("android.intent.extra.REPLACING", true);
            this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", this.removedPackage, extras, 0, null, null, null);
            this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", this.removedPackage, extras, 0, null, null, null);
            this.packageSender.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, 0, this.removedPackage, null, null);
            if (this.installerPackageName != null) {
                this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", this.removedPackage, extras, 0, this.installerPackageName, null, null);
                this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", this.removedPackage, extras, 0, this.installerPackageName, null, null);
            }
        }

        private void sendPackageRemovedBroadcastInternal(boolean killApp) {
            if (this.isStaticSharedLib) {
                return;
            }
            Bundle extras = new Bundle(2);
            extras.putInt("android.intent.extra.UID", this.removedAppId >= 0 ? this.removedAppId : this.uid);
            extras.putBoolean("android.intent.extra.DATA_REMOVED", this.dataRemoved);
            extras.putBoolean("android.intent.extra.DONT_KILL_APP", !killApp);
            if (this.isUpdate || this.isRemovedPackageSystemUpdate) {
                extras.putBoolean("android.intent.extra.REPLACING", true);
            }
            extras.putBoolean("android.intent.extra.REMOVED_FOR_ALL_USERS", this.removedForAllUsers);
            if (this.removedPackage != null) {
                this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, 0, null, null, this.broadcastUsers);
                if (this.installerPackageName != null) {
                    this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, 0, this.installerPackageName, null, this.broadcastUsers);
                }
                if (this.dataRemoved && !this.isRemovedPackageSystemUpdate) {
                    this.packageSender.sendPackageBroadcast("android.intent.action.PACKAGE_FULLY_REMOVED", this.removedPackage, extras, 0x1000000, null, null, this.broadcastUsers);
                }
            }
            if (this.removedAppId >= 0) {
                this.packageSender.sendPackageBroadcast("android.intent.action.UID_REMOVED", null, extras, 0x1000000, null, null, this.broadcastUsers);
            }
        }

        void populateUsers(int[] userIds, PackageSetting deletedPackageSetting) {
            this.removedUsers = userIds;
            if (this.removedUsers == null) {
                this.broadcastUsers = null;
                return;
            }
            this.broadcastUsers = EMPTY_INT_ARRAY;
            for (int i = userIds.length - 1; i >= 0; --i) {
                int userId = userIds[i];
                if (deletedPackageSetting.getInstantApp(userId)) continue;
                this.broadcastUsers = ArrayUtils.appendInt(this.broadcastUsers, userId);
            }
        }
    }

    static class PackageInstalledInfo {
        String name;
        int uid;
        int[] origUsers;
        int[] newUsers;
        PackageParser.Package pkg;
        int returnCode;
        String returnMsg;
        PackageRemovedInfo removedInfo;
        ArrayMap<String, PackageInstalledInfo> addedChildPackages;
        String origPackage;
        String origPermission;

        PackageInstalledInfo() {
        }

        public void setError(int code, String msg) {
            this.setReturnCode(code);
            this.setReturnMessage(msg);
            Slog.w(PackageManagerService.TAG, msg);
        }

        public void setError(String msg, PackageParser.PackageParserException e) {
            this.setReturnCode(e.error);
            this.setReturnMessage(ExceptionUtils.getCompleteMessage(msg, e));
            Slog.w(PackageManagerService.TAG, msg, e);
        }

        public void setError(String msg, PackageManagerException e) {
            this.returnCode = e.error;
            this.setReturnMessage(ExceptionUtils.getCompleteMessage(msg, e));
            Slog.w(PackageManagerService.TAG, msg, e);
        }

        public void setReturnCode(int returnCode) {
            this.returnCode = returnCode;
            int childCount = this.addedChildPackages != null ? this.addedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                this.addedChildPackages.valueAt((int)i).returnCode = returnCode;
            }
        }

        private void setReturnMessage(String returnMsg) {
            this.returnMsg = returnMsg;
            int childCount = this.addedChildPackages != null ? this.addedChildPackages.size() : 0;
            for (int i = 0; i < childCount; ++i) {
                this.addedChildPackages.valueAt((int)i).returnMsg = returnMsg;
            }
        }
    }

    class MoveInstallArgs
    extends InstallArgs {
        private File codeFile;
        private File resourceFile;

        MoveInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions, params.traceMethod, params.traceCookie, params.certificates, params.installReason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) {
            Installer installer = PackageManagerService.this.mInstaller;
            synchronized (installer) {
                try {
                    PackageManagerService.this.mInstaller.moveCompleteApp(this.move.fromUuid, this.move.toUuid, this.move.packageName, this.move.dataAppName, this.move.appId, this.move.seinfo, this.move.targetSdkVersion);
                }
                catch (Installer.InstallerException e) {
                    Slog.w(PackageManagerService.TAG, "Failed to move app", e);
                    return -110;
                }
            }
            this.resourceFile = this.codeFile = new File(Environment.getDataAppDirectory(this.move.toUuid), this.move.dataAppName);
            return 1;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp(this.move.toUuid);
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            if (status != 1) {
                this.cleanUp(this.move.toUuid);
                return false;
            }
            pkg.setApplicationVolumeUuid(pkg.volumeUuid);
            pkg.setApplicationInfoCodePath(pkg.codePath);
            pkg.setApplicationInfoBaseCodePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitCodePaths(pkg.splitCodePaths);
            pkg.setApplicationInfoResourcePath(pkg.codePath);
            pkg.setApplicationInfoBaseResourcePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status == 1) {
                this.cleanUp(this.move.fromUuid);
            } else {
                this.cleanUp(this.move.toUuid);
            }
            return status;
        }

        @Override
        String getCodePath() {
            return this.codeFile != null ? this.codeFile.getAbsolutePath() : null;
        }

        @Override
        String getResourcePath() {
            return this.resourceFile != null ? this.resourceFile.getAbsolutePath() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cleanUp(String volumeUuid) {
            File codeFile = new File(Environment.getDataAppDirectory(volumeUuid), this.move.dataAppName);
            Slog.d(PackageManagerService.TAG, "Cleaning up " + this.move.packageName + " on " + volumeUuid);
            int[] userIds = sUserManager.getUserIds();
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                for (int userId : userIds) {
                    try {
                        PackageManagerService.this.mInstaller.destroyAppData(volumeUuid, this.move.packageName, userId, 3, 0L);
                    }
                    catch (Installer.InstallerException e) {
                        Slog.w(PackageManagerService.TAG, String.valueOf(e));
                    }
                }
                PackageManagerService.this.removeCodePathLI(codeFile);
            }
            return true;
        }

        @Override
        void cleanUpResourcesLI() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            throw new UnsupportedOperationException();
        }
    }

    class AsecInstallArgs
    extends InstallArgs {
        static final String RES_FILE_NAME = "pkg.apk";
        static final String PUBLIC_RES_FILE_NAME = "res.zip";
        String cid;
        String packagePath;
        String resourcePath;

        AsecInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions, params.traceMethod, params.traceCookie, params.certificates, params.installReason);
        }

        AsecInstallArgs(String fullCodePath, String[] instructionSets, boolean isExternal, boolean isForwardLocked) {
            super(OriginInfo.fromNothing(), null, null, (isExternal ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null, instructionSets, null, null, null, 0, null, 0);
            if (!fullCodePath.endsWith(RES_FILE_NAME)) {
                fullCodePath = new File(fullCodePath, RES_FILE_NAME).getAbsolutePath();
            }
            int eidx = fullCodePath.lastIndexOf("/");
            String subStr1 = fullCodePath.substring(0, eidx);
            int sidx = subStr1.lastIndexOf("/");
            this.cid = subStr1.substring(sidx + 1, eidx);
            this.setMountPath(subStr1);
        }

        AsecInstallArgs(String cid, String[] instructionSets, boolean isForwardLocked) {
            super(OriginInfo.fromNothing(), null, null, (PackageManagerService.this.isAsecExternal(cid) ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null, instructionSets, null, null, null, 0, null, 0);
            this.cid = cid;
            this.setMountPath(PackageHelper.getSdDir(cid));
        }

        void createCopyFile() {
            this.cid = PackageManagerService.this.mInstallerService.allocateExternalStageCidLegacy();
        }

        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            if (this.origin.staged && this.origin.cid != null) {
                this.cid = this.origin.cid;
                this.setMountPath(PackageHelper.getSdDir(this.cid));
                return 1;
            }
            if (temp) {
                this.createCopyFile();
            } else {
                PackageHelper.destroySdDir(this.cid);
            }
            String newMountPath = imcs.copyPackageToContainer(this.origin.file.getAbsolutePath(), this.cid, PackageManagerService.getEncryptKey(), this.isExternalAsec(), this.isFwdLocked(), PackageManagerService.deriveAbiOverride(this.abiOverride, null));
            if (newMountPath != null) {
                this.setMountPath(newMountPath);
                return 1;
            }
            return -18;
        }

        @Override
        String getCodePath() {
            return this.packagePath;
        }

        @Override
        String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                PackageHelper.destroySdDir(this.cid);
            } else {
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    String newMountPath = PackageHelper.mountSdDir(this.cid, PackageManagerService.getEncryptKey(), 1000);
                    if (newMountPath != null) {
                        this.setMountPath(newMountPath);
                    } else {
                        return -18;
                    }
                }
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            String newCacheId = PackageManagerService.getNextCodePath(oldCodePath, pkg.packageName, "/pkg.apk");
            String newMountPath = null;
            if (PackageHelper.isContainerMounted(this.cid) && !PackageHelper.unMountSdDir(this.cid)) {
                Slog.i(PackageManagerService.TAG, "Failed to unmount " + this.cid + " before renaming");
                return false;
            }
            if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " which might be stale. Will try to clean up.");
                if (!PackageHelper.destroySdDir(newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Very strange. Cannot clean up stale container " + newCacheId);
                    return false;
                }
                if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " inspite of cleaning it up.");
                    return false;
                }
            }
            if (!PackageHelper.isContainerMounted(newCacheId)) {
                Slog.w(PackageManagerService.TAG, "Mounting container " + newCacheId);
                newMountPath = PackageHelper.mountSdDir(newCacheId, PackageManagerService.getEncryptKey(), 1000);
            } else {
                newMountPath = PackageHelper.getSdDir(newCacheId);
            }
            if (newMountPath == null) {
                Slog.w(PackageManagerService.TAG, "Failed to get cache path for  " + newCacheId);
                return false;
            }
            Log.i(PackageManagerService.TAG, "Succesfully renamed " + this.cid + " to " + newCacheId + " at new path: " + newMountPath);
            this.cid = newCacheId;
            File beforeCodeFile = new File(this.packagePath);
            this.setMountPath(newMountPath);
            File afterCodeFile = new File(this.packagePath);
            pkg.setCodePath(afterCodeFile.getAbsolutePath());
            pkg.setBaseCodePath(FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.baseCodePath));
            pkg.setSplitCodePaths(FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.splitCodePaths));
            pkg.setApplicationVolumeUuid(pkg.volumeUuid);
            pkg.setApplicationInfoCodePath(pkg.codePath);
            pkg.setApplicationInfoBaseCodePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitCodePaths(pkg.splitCodePaths);
            pkg.setApplicationInfoResourcePath(pkg.codePath);
            pkg.setApplicationInfoBaseResourcePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        private void setMountPath(String mountPath) {
            File mountFile = new File(mountPath);
            File monolithicFile = new File(mountFile, RES_FILE_NAME);
            if (monolithicFile.exists()) {
                this.packagePath = monolithicFile.getAbsolutePath();
                this.resourcePath = this.isFwdLocked() ? new File(mountFile, PUBLIC_RES_FILE_NAME).getAbsolutePath() : this.packagePath;
            } else {
                this.resourcePath = this.packagePath = mountFile.getAbsolutePath();
            }
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            } else {
                String protectedFile;
                int groupOwner;
                if (this.isFwdLocked()) {
                    groupOwner = UserHandle.getSharedAppGid(uid);
                    protectedFile = RES_FILE_NAME;
                } else {
                    groupOwner = -1;
                    protectedFile = null;
                }
                if (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, groupOwner, protectedFile)) {
                    Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                    PackageHelper.destroySdDir(this.cid);
                    return -18;
                }
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    PackageHelper.mountSdDir(this.cid, PackageManagerService.getEncryptKey(), Process.myUid());
                }
            }
            return status;
        }

        private void cleanUp() {
            PackageHelper.destroySdDir(this.cid);
        }

        private List<String> getAllCodePaths() {
            File codeFile = new File(this.getCodePath());
            if (codeFile != null && codeFile.exists()) {
                try {
                    PackageParser.PackageLite pkg = PackageParser.parsePackageLite(codeFile, 0);
                    return pkg.getAllCodePaths();
                }
                catch (PackageParser.PackageParserException packageParserException) {
                    // empty catch block
                }
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        void cleanUpResourcesLI() {
            this.cleanUpResourcesLI(this.getAllCodePaths());
        }

        private void cleanUpResourcesLI(List<String> allCodePaths) {
            this.cleanUp();
            PackageManagerService.this.removeDexFiles(allCodePaths, this.instructionSets);
        }

        String getPackageName() {
            return PackageManagerService.getAsecPackageName(this.cid);
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            List<String> allCodePaths = this.getAllCodePaths();
            boolean mounted = PackageHelper.isContainerMounted(this.cid);
            if (mounted && PackageHelper.unMountSdDir(this.cid)) {
                mounted = false;
            }
            if (!mounted && delete) {
                this.cleanUpResourcesLI(allCodePaths);
            }
            return !mounted;
        }

        @Override
        int doPreCopy() {
            if (this.isFwdLocked() && !PackageHelper.fixSdPermissions(this.cid, PackageManagerService.this.getPackageUid(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, 0x100000, 0), RES_FILE_NAME)) {
                return -18;
            }
            return 1;
        }

        @Override
        int doPostCopy(int uid) {
            if (this.isFwdLocked() && (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, UserHandle.getSharedAppGid(uid), RES_FILE_NAME))) {
                Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                PackageHelper.destroySdDir(this.cid);
                return -18;
            }
            return 1;
        }
    }

    class FileInstallArgs
    extends InstallArgs {
        private File codeFile;
        private File resourceFile;

        FileInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions, params.traceMethod, params.traceCookie, params.certificates, params.installReason);
            if (this.isFwdLocked()) {
                throw new IllegalArgumentException("Forward locking only supported in ASEC");
            }
        }

        FileInstallArgs(String codePath, String resourcePath, String[] instructionSets) {
            super(OriginInfo.fromNothing(), null, null, 0, null, null, null, instructionSets, null, null, null, 0, null, 0);
            this.codeFile = codePath != null ? new File(codePath) : null;
            this.resourceFile = resourcePath != null ? new File(resourcePath) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            Trace.traceBegin(262144L, "copyApk");
            try {
                int n = this.doCopyApk(imcs, temp);
                return n;
            }
            finally {
                Trace.traceEnd(262144L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int doCopyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            if (this.origin.staged) {
                this.codeFile = this.origin.file;
                this.resourceFile = this.origin.file;
                return 1;
            }
            try {
                File tempDir;
                boolean isEphemeral = (this.installFlags & 0x800) != 0;
                this.codeFile = tempDir = PackageManagerService.this.mInstallerService.allocateStageDirLegacy(this.volumeUuid, isEphemeral);
                this.resourceFile = tempDir;
            }
            catch (IOException e) {
                Slog.w(PackageManagerService.TAG, "Failed to create copy file: " + e);
                return -4;
            }
            IParcelFileDescriptorFactory.Stub target = new IParcelFileDescriptorFactory.Stub(){

                @Override
                public ParcelFileDescriptor open(String name, int mode) throws RemoteException {
                    if (!FileUtils.isValidExtFilename(name)) {
                        throw new IllegalArgumentException("Invalid filename: " + name);
                    }
                    try {
                        File file = new File(FileInstallArgs.this.codeFile, name);
                        FileDescriptor fd = Os.open(file.getAbsolutePath(), OsConstants.O_RDWR | OsConstants.O_CREAT, 420);
                        Os.chmod(file.getAbsolutePath(), 420);
                        return new ParcelFileDescriptor(fd);
                    }
                    catch (ErrnoException e) {
                        throw new RemoteException("Failed to open: " + e.getMessage());
                    }
                }
            };
            int ret = 1;
            ret = imcs.copyPackage(this.origin.file.getAbsolutePath(), target);
            if (ret != 1) {
                Slog.e(PackageManagerService.TAG, "Failed to copy package");
                return ret;
            }
            File libraryRoot = new File(this.codeFile, "lib");
            NativeLibraryHelper.Handle handle = null;
            try {
                handle = NativeLibraryHelper.Handle.create(this.codeFile);
                ret = NativeLibraryHelper.copyNativeBinariesWithOverride(handle, libraryRoot, this.abiOverride);
            }
            catch (IOException e) {
                Slog.e(PackageManagerService.TAG, "Copying native libraries failed", e);
                ret = -110;
            }
            finally {
                IoUtils.closeQuietly(handle);
            }
            return ret;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            if (status != 1) {
                this.cleanUp();
                return false;
            }
            File targetDir = this.codeFile.getParentFile();
            File beforeCodeFile = this.codeFile;
            File afterCodeFile = PackageManagerService.this.getNextCodePath(targetDir, pkg.packageName);
            try {
                Os.rename(beforeCodeFile.getAbsolutePath(), afterCodeFile.getAbsolutePath());
            }
            catch (ErrnoException e) {
                Slog.w(PackageManagerService.TAG, "Failed to rename", e);
                return false;
            }
            if (!SELinux.restoreconRecursive(afterCodeFile)) {
                Slog.w(PackageManagerService.TAG, "Failed to restorecon");
                return false;
            }
            this.codeFile = afterCodeFile;
            this.resourceFile = afterCodeFile;
            pkg.setCodePath(afterCodeFile.getAbsolutePath());
            pkg.setBaseCodePath(FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.baseCodePath));
            pkg.setSplitCodePaths(FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.splitCodePaths));
            pkg.setApplicationVolumeUuid(pkg.volumeUuid);
            pkg.setApplicationInfoCodePath(pkg.codePath);
            pkg.setApplicationInfoBaseCodePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitCodePaths(pkg.splitCodePaths);
            pkg.setApplicationInfoResourcePath(pkg.codePath);
            pkg.setApplicationInfoBaseResourcePath(pkg.baseCodePath);
            pkg.setApplicationInfoSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        String getCodePath() {
            return this.codeFile != null ? this.codeFile.getAbsolutePath() : null;
        }

        @Override
        String getResourcePath() {
            return this.resourceFile != null ? this.resourceFile.getAbsolutePath() : null;
        }

        private boolean cleanUp() {
            if (this.codeFile == null || !this.codeFile.exists()) {
                return false;
            }
            PackageManagerService.this.removeCodePathLI(this.codeFile);
            if (this.resourceFile != null && !FileUtils.contains(this.codeFile, this.resourceFile)) {
                this.resourceFile.delete();
            }
            return true;
        }

        @Override
        void cleanUpResourcesLI() {
            List<String> allCodePaths = Collections.EMPTY_LIST;
            if (this.codeFile != null && this.codeFile.exists()) {
                try {
                    PackageParser.PackageLite pkg = PackageParser.parsePackageLite(this.codeFile, 0);
                    allCodePaths = pkg.getAllCodePaths();
                }
                catch (PackageParser.PackageParserException packageParserException) {
                    // empty catch block
                }
            }
            this.cleanUp();
            PackageManagerService.this.removeDexFiles(allCodePaths, this.instructionSets);
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            this.cleanUpResourcesLI();
            return true;
        }
    }

    static abstract class InstallArgs {
        final OriginInfo origin;
        final MoveInfo move;
        final IPackageInstallObserver2 observer;
        final int installFlags;
        final String installerPackageName;
        final String volumeUuid;
        final UserHandle user;
        final String abiOverride;
        final String[] installGrantPermissions;
        final String traceMethod;
        final int traceCookie;
        final Certificate[][] certificates;
        final int installReason;
        String[] instructionSets;

        InstallArgs(OriginInfo origin, MoveInfo move, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, String volumeUuid, UserHandle user, String[] instructionSets, String abiOverride, String[] installGrantPermissions, String traceMethod, int traceCookie, Certificate[][] certificates, int installReason) {
            this.origin = origin;
            this.move = move;
            this.installFlags = installFlags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.volumeUuid = volumeUuid;
            this.user = user;
            this.instructionSets = instructionSets;
            this.abiOverride = abiOverride;
            this.installGrantPermissions = installGrantPermissions;
            this.traceMethod = traceMethod;
            this.traceCookie = traceCookie;
            this.certificates = certificates;
            this.installReason = installReason;
        }

        abstract int copyApk(IMediaContainerService var1, boolean var2) throws RemoteException;

        abstract int doPreInstall(int var1);

        abstract boolean doRename(int var1, PackageParser.Package var2, String var3);

        abstract int doPostInstall(int var1, int var2);

        abstract String getCodePath();

        abstract String getResourcePath();

        abstract void cleanUpResourcesLI();

        abstract boolean doPostDeleteLI(boolean var1);

        int doPreCopy() {
            return 1;
        }

        int doPostCopy(int uid) {
            return 1;
        }

        protected boolean isFwdLocked() {
            return (this.installFlags & 1) != 0;
        }

        protected boolean isExternalAsec() {
            return (this.installFlags & 8) != 0;
        }

        protected boolean isEphemeral() {
            return (this.installFlags & 0x800) != 0;
        }

        UserHandle getUser() {
            return this.user;
        }
    }

    class InstallParams
    extends HandlerParams {
        final OriginInfo origin;
        final MoveInfo move;
        final IPackageInstallObserver2 observer;
        int installFlags;
        final String installerPackageName;
        final String volumeUuid;
        private InstallArgs mArgs;
        private int mRet;
        final String packageAbiOverride;
        final String[] grantedRuntimePermissions;
        final VerificationInfo verificationInfo;
        final Certificate[][] certificates;
        final int installReason;

        InstallParams(OriginInfo origin, MoveInfo move, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, String volumeUuid, VerificationInfo verificationInfo, UserHandle user, String packageAbiOverride, String[] grantedPermissions, Certificate[][] certificates, int installReason) {
            super(user);
            this.origin = origin;
            this.move = move;
            this.observer = observer;
            this.installFlags = installFlags;
            this.installerPackageName = installerPackageName;
            this.volumeUuid = volumeUuid;
            this.verificationInfo = verificationInfo;
            this.packageAbiOverride = packageAbiOverride;
            this.grantedRuntimePermissions = grantedPermissions;
            this.certificates = certificates;
            this.installReason = installReason;
        }

        public String toString() {
            return "InstallParams{" + Integer.toHexString(System.identityHashCode(this)) + " file=" + this.origin.file + " cid=" + this.origin.cid + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int installLocationPolicy(PackageInfoLite pkgLite) {
            String packageName = pkgLite.packageName;
            int installLocation = pkgLite.installLocation;
            boolean onSd = (this.installFlags & 8) != 0;
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageSetting ps;
                PackageParser.Package installedPkg;
                PackageParser.Package dataOwnerPkg = installedPkg = PackageManagerService.this.mPackages.get(packageName);
                if (dataOwnerPkg == null && (ps = PackageManagerService.this.mSettings.mPackages.get(packageName)) != null) {
                    dataOwnerPkg = ps.pkg;
                }
                if (dataOwnerPkg != null) {
                    boolean downgradePermitted;
                    boolean downgradeRequested = (this.installFlags & 0x80) != 0;
                    boolean packageDebuggable = (dataOwnerPkg.applicationInfo.flags & 2) != 0;
                    boolean bl = downgradePermitted = downgradeRequested && (Build.IS_DEBUGGABLE || packageDebuggable);
                    if (!downgradePermitted) {
                        try {
                            PackageManagerService.checkDowngrade(dataOwnerPkg, pkgLite);
                        }
                        catch (PackageManagerException e) {
                            Slog.w(PackageManagerService.TAG, "Downgrade detected: " + e.getMessage());
                            return -7;
                        }
                    }
                }
                if (installedPkg != null) {
                    if ((this.installFlags & 2) != 0) {
                        if ((installedPkg.applicationInfo.flags & 1) != 0) {
                            if (onSd) {
                                Slog.w(PackageManagerService.TAG, "Cannot install update to system app on sdcard");
                                return -3;
                            }
                            return 1;
                        }
                        if (onSd) {
                            return 2;
                        }
                        if (installLocation == 1) {
                            return 1;
                        }
                        if (installLocation != 2) {
                            if (PackageManagerService.isExternal(installedPkg)) {
                                return 2;
                            }
                            return 1;
                        }
                    } else {
                        return -4;
                    }
                }
            }
            if (onSd) {
                return 2;
            }
            return pkgLite.recommendedInstallLocation;
        }

        @Override
        public void handleStartCopy() throws RemoteException {
            InstallArgs args;
            int ret = 1;
            if (this.origin.staged) {
                if (this.origin.file != null) {
                    this.installFlags |= 0x10;
                    this.installFlags &= 0xFFFFFFF7;
                } else if (this.origin.cid != null) {
                    this.installFlags |= 8;
                    this.installFlags &= 0xFFFFFFEF;
                } else {
                    throw new IllegalStateException("Invalid stage location");
                }
            }
            boolean onSd = (this.installFlags & 8) != 0;
            boolean onInt = (this.installFlags & 0x10) != 0;
            boolean ephemeral = (this.installFlags & 0x800) != 0;
            PackageInfoLite pkgLite = null;
            if (onInt && onSd) {
                Slog.w(PackageManagerService.TAG, "Conflicting flags specified for installing on both internal and external");
                ret = -19;
            } else if (onSd && ephemeral) {
                Slog.w(PackageManagerService.TAG, "Conflicting flags specified for installing ephemeral on external");
                ret = -19;
            } else {
                pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
                if (DEBUG_EPHEMERAL && ephemeral) {
                    Slog.v(PackageManagerService.TAG, "pkgLite for install: " + pkgLite);
                }
                if (!this.origin.staged && pkgLite.recommendedInstallLocation == -1) {
                    StorageManager storage = StorageManager.from(PackageManagerService.this.mContext);
                    long lowThreshold = storage.getStorageLowBytes(Environment.getDataDirectory());
                    long sizeBytes = PackageManagerService.this.mContainerService.calculateInstalledSize(this.origin.resolvedPath, this.isForwardLocked(), this.packageAbiOverride);
                    try {
                        PackageManagerService.this.mInstaller.freeCache(null, sizeBytes + lowThreshold, 0L, 0);
                        pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
                    }
                    catch (Installer.InstallerException e) {
                        Slog.w(PackageManagerService.TAG, "Failed to free cache", e);
                    }
                    if (pkgLite.recommendedInstallLocation == -6) {
                        pkgLite.recommendedInstallLocation = -1;
                    }
                }
            }
            if (ret == 1) {
                int loc = pkgLite.recommendedInstallLocation;
                if (loc == -3) {
                    ret = -19;
                } else if (loc == -4) {
                    ret = -1;
                } else if (loc == -1) {
                    ret = -4;
                } else if (loc == -2) {
                    ret = -2;
                } else if (loc == -6) {
                    ret = -3;
                } else if (loc == -5) {
                    ret = -20;
                } else {
                    loc = this.installLocationPolicy(pkgLite);
                    if (loc == -7) {
                        ret = -25;
                    } else if (!onSd && !onInt) {
                        if (loc == 2) {
                            this.installFlags |= 8;
                            this.installFlags &= 0xFFFFFFEF;
                        } else if (loc == 3) {
                            if (DEBUG_EPHEMERAL) {
                                Slog.v(PackageManagerService.TAG, "...setting INSTALL_EPHEMERAL install flag");
                            }
                            this.installFlags |= 0x800;
                            this.installFlags &= 0xFFFFFFE7;
                        } else {
                            this.installFlags |= 0x10;
                            this.installFlags &= 0xFFFFFFF7;
                        }
                    }
                }
            }
            this.mArgs = args = PackageManagerService.this.createInstallArgs(this);
            if (ret == 1) {
                int installerUid;
                UserHandle verifierUser = this.getUser();
                if (verifierUser == UserHandle.ALL) {
                    verifierUser = UserHandle.SYSTEM;
                }
                int requiredUid = PackageManagerService.this.mRequiredVerifierPackage == null ? -1 : PackageManagerService.this.getPackageUid(PackageManagerService.this.mRequiredVerifierPackage, 0x10000000, verifierUser.getIdentifier());
                int n = installerUid = this.verificationInfo == null ? -1 : this.verificationInfo.installerUid;
                if (!this.origin.existing && requiredUid != -1 && PackageManagerService.this.isVerificationEnabled(verifierUser.getIdentifier(), this.installFlags, installerUid)) {
                    Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
                    verification.addFlags(0x10000000);
                    verification.setDataAndType(Uri.fromFile(new File(this.origin.resolvedPath)), PackageManagerService.PACKAGE_MIME_TYPE);
                    verification.addFlags(1);
                    List receivers = PackageManagerService.this.queryIntentReceiversInternal(verification, PackageManagerService.PACKAGE_MIME_TYPE, 0, verifierUser.getIdentifier());
                    final int verificationId = PackageManagerService.this.mPendingVerificationToken++;
                    verification.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_PACKAGE", this.installerPackageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALL_FLAGS", this.installFlags);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_PACKAGE_NAME", pkgLite.packageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_VERSION_CODE", pkgLite.versionCode);
                    if (this.verificationInfo != null) {
                        if (this.verificationInfo.originatingUri != null) {
                            verification.putExtra("android.intent.extra.ORIGINATING_URI", this.verificationInfo.originatingUri);
                        }
                        if (this.verificationInfo.referrer != null) {
                            verification.putExtra("android.intent.extra.REFERRER", this.verificationInfo.referrer);
                        }
                        if (this.verificationInfo.originatingUid >= 0) {
                            verification.putExtra("android.intent.extra.ORIGINATING_UID", this.verificationInfo.originatingUid);
                        }
                        if (this.verificationInfo.installerUid >= 0) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_UID", this.verificationInfo.installerUid);
                        }
                    }
                    PackageVerificationState verificationState = new PackageVerificationState(requiredUid, args);
                    PackageManagerService.this.mPendingVerification.append(verificationId, verificationState);
                    List sufficientVerifiers = PackageManagerService.this.matchVerifiers(pkgLite, receivers, verificationState);
                    DeviceIdleController.LocalService idleController = PackageManagerService.this.getDeviceIdleController();
                    long idleDuration = PackageManagerService.this.getVerificationTimeout();
                    if (sufficientVerifiers != null) {
                        int N = sufficientVerifiers.size();
                        if (N == 0) {
                            Slog.i(PackageManagerService.TAG, "Additional verifiers required, but none installed.");
                            ret = -22;
                        } else {
                            for (int i = 0; i < N; ++i) {
                                ComponentName verifierComponent = (ComponentName)sufficientVerifiers.get(i);
                                idleController.addPowerSaveTempWhitelistApp(Process.myUid(), verifierComponent.getPackageName(), idleDuration, verifierUser.getIdentifier(), false, "package verifier");
                                Intent sufficientIntent = new Intent(verification);
                                sufficientIntent.setComponent(verifierComponent);
                                PackageManagerService.this.mContext.sendBroadcastAsUser(sufficientIntent, verifierUser);
                            }
                        }
                    }
                    ComponentName requiredVerifierComponent = PackageManagerService.this.matchComponentForVerifier(PackageManagerService.this.mRequiredVerifierPackage, receivers);
                    if (ret == 1 && PackageManagerService.this.mRequiredVerifierPackage != null) {
                        Trace.asyncTraceBegin(262144L, "verification", verificationId);
                        verification.setComponent(requiredVerifierComponent);
                        idleController.addPowerSaveTempWhitelistApp(Process.myUid(), PackageManagerService.this.mRequiredVerifierPackage, idleDuration, verifierUser.getIdentifier(), false, "package verifier");
                        PackageManagerService.this.mContext.sendOrderedBroadcastAsUser(verification, verifierUser, "android.permission.PACKAGE_VERIFICATION_AGENT", new BroadcastReceiver(){

                            @Override
                            public void onReceive(Context context, Intent intent) {
                                Message msg = PackageManagerService.this.mHandler.obtainMessage(16);
                                msg.arg1 = verificationId;
                                PackageManagerService.this.mHandler.sendMessageDelayed(msg, PackageManagerService.this.getVerificationTimeout());
                            }
                        }, null, 0, null, null);
                        this.mArgs = null;
                    }
                } else {
                    ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                }
            }
            this.mRet = ret;
        }

        @Override
        void handleReturnCode() {
            if (this.mArgs != null) {
                PackageManagerService.this.processPendingInstall(this.mArgs, this.mRet);
            }
        }

        @Override
        void handleServiceError() {
            this.mArgs = PackageManagerService.this.createInstallArgs(this);
            this.mRet = -110;
        }

        public boolean isForwardLocked() {
            return (this.installFlags & 1) != 0;
        }
    }

    static class VerificationInfo {
        public static final int NO_UID = -1;
        final Uri originatingUri;
        final Uri referrer;
        final int originatingUid;
        final int installerUid;

        VerificationInfo(Uri originatingUri, Uri referrer, int originatingUid, int installerUid) {
            this.originatingUri = originatingUri;
            this.referrer = referrer;
            this.originatingUid = originatingUid;
            this.installerUid = installerUid;
        }
    }

    static class MoveInfo {
        final int moveId;
        final String fromUuid;
        final String toUuid;
        final String packageName;
        final String dataAppName;
        final int appId;
        final String seinfo;
        final int targetSdkVersion;

        public MoveInfo(int moveId, String fromUuid, String toUuid, String packageName, String dataAppName, int appId, String seinfo, int targetSdkVersion) {
            this.moveId = moveId;
            this.fromUuid = fromUuid;
            this.toUuid = toUuid;
            this.packageName = packageName;
            this.dataAppName = dataAppName;
            this.appId = appId;
            this.seinfo = seinfo;
            this.targetSdkVersion = targetSdkVersion;
        }
    }

    static class OriginInfo {
        final File file;
        final String cid;
        final boolean staged;
        final boolean existing;
        final String resolvedPath;
        final File resolvedFile;

        static OriginInfo fromNothing() {
            return new OriginInfo(null, null, false, false);
        }

        static OriginInfo fromUntrustedFile(File file) {
            return new OriginInfo(file, null, false, false);
        }

        static OriginInfo fromExistingFile(File file) {
            return new OriginInfo(file, null, false, true);
        }

        static OriginInfo fromStagedFile(File file) {
            return new OriginInfo(file, null, true, false);
        }

        static OriginInfo fromStagedContainer(String cid) {
            return new OriginInfo(null, cid, true, false);
        }

        private OriginInfo(File file, String cid, boolean staged, boolean existing) {
            this.file = file;
            this.cid = cid;
            this.staged = staged;
            this.existing = existing;
            if (cid != null) {
                this.resolvedPath = PackageHelper.getSdDir(cid);
                this.resolvedFile = new File(this.resolvedPath);
            } else if (file != null) {
                this.resolvedPath = file.getAbsolutePath();
                this.resolvedFile = file;
            } else {
                this.resolvedPath = null;
                this.resolvedFile = null;
            }
        }
    }

    private abstract class HandlerParams {
        private static final int MAX_RETRIES = 4;
        private int mRetries = 0;
        private final UserHandle mUser;
        String traceMethod;
        int traceCookie;

        HandlerParams(UserHandle user) {
            this.mUser = user;
        }

        UserHandle getUser() {
            return this.mUser;
        }

        HandlerParams setTraceMethod(String traceMethod) {
            this.traceMethod = traceMethod;
            return this;
        }

        HandlerParams setTraceCookie(int traceCookie) {
            this.traceCookie = traceCookie;
            return this;
        }

        final boolean startCopy() {
            boolean res;
            try {
                if (++this.mRetries > 4) {
                    Slog.w(PackageManagerService.TAG, "Failed to invoke remote methods on default container service. Giving up");
                    PackageManagerService.this.mHandler.sendEmptyMessage(11);
                    this.handleServiceError();
                    return false;
                }
                this.handleStartCopy();
                res = true;
            }
            catch (RemoteException e) {
                PackageManagerService.this.mHandler.sendEmptyMessage(10);
                res = false;
            }
            this.handleReturnCode();
            return res;
        }

        final void serviceError() {
            this.handleServiceError();
            this.handleReturnCode();
        }

        abstract void handleStartCopy() throws RemoteException;

        abstract void handleServiceError();

        abstract void handleReturnCode();
    }

    static final class EphemeralIntentResolver
    extends IntentResolver<AuxiliaryResolveInfo, AuxiliaryResolveInfo> {
        final ArrayMap<String, Pair<Integer, InstantAppResolveInfo>> mOrderResult = new ArrayMap();

        EphemeralIntentResolver() {
        }

        protected AuxiliaryResolveInfo[] newArray(int size) {
            return new AuxiliaryResolveInfo[size];
        }

        @Override
        protected boolean isPackageForFilter(String packageName, AuxiliaryResolveInfo responseObj) {
            return true;
        }

        @Override
        protected AuxiliaryResolveInfo newResult(AuxiliaryResolveInfo responseObj, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            String packageName = responseObj.resolveInfo.getPackageName();
            Integer order = responseObj.getOrder();
            Pair<Integer, InstantAppResolveInfo> lastOrderResult = this.mOrderResult.get(packageName);
            if (lastOrderResult != null && (Integer)lastOrderResult.first >= order) {
                return null;
            }
            InstantAppResolveInfo res = responseObj.resolveInfo;
            if (order > 0) {
                this.mOrderResult.put(packageName, new Pair<Integer, InstantAppResolveInfo>(order, res));
            }
            return responseObj;
        }

        @Override
        protected void filterResults(List<AuxiliaryResolveInfo> results) {
            if (this.mOrderResult.size() == 0) {
                return;
            }
            int resultSize = results.size();
            for (int i = 0; i < resultSize; ++i) {
                InstantAppResolveInfo info = results.get((int)i).resolveInfo;
                String packageName = info.getPackageName();
                Pair<Integer, InstantAppResolveInfo> savedInfo = this.mOrderResult.get(packageName);
                if (savedInfo == null) continue;
                if (savedInfo.second == info) {
                    this.mOrderResult.remove(savedInfo);
                    if (this.mOrderResult.size() != 0) continue;
                    break;
                }
                results.remove(i);
                --resultSize;
                --i;
            }
        }
    }

    private final class ProviderIntentResolver
    extends IntentResolver<PackageParser.ProviderIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Provider> mProviders = new ArrayMap();
        private int mFlags;

        private ProviderIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Provider> packageProviders, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageProviders == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageProviders.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageProviders.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ProviderIntentInfo[] array2 = new PackageParser.ProviderIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addProvider(PackageParser.Provider p) {
            if (this.mProviders.containsKey(p.getComponentName())) {
                Slog.w(PackageManagerService.TAG, "Provider " + p.getComponentName() + " already defined; ignoring");
                return;
            }
            this.mProviders.put(p.getComponentName(), p);
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Provider " + p.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeProvider(PackageParser.Provider p) {
            this.mProviders.remove(p.getComponentName());
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ProviderIntentInfo filter, List<ResolveInfo> dest) {
            ProviderInfo filterPi = filter.provider.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ProviderInfo destPi = dest.get((int)i).providerInfo;
                if (destPi.name != filterPi.name || destPi.packageName != filterPi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ProviderIntentInfo[] newArray(int size) {
            return new PackageParser.ProviderIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ProviderIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.provider.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ProviderIntentInfo info) {
            return packageName.equals(info.provider.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ProviderIntentInfo filter, int match, int userId) {
            boolean isInstantApp;
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ProviderIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledAndMatchLPr(info.provider.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Provider provider = info.provider;
            PackageSetting ps = (PackageSetting)provider.owner.mExtras;
            if (ps == null) {
                return null;
            }
            PackageUserState userState = ps.readUserState(userId);
            boolean matchVisibleToInstantApp = (this.mFlags & 0x1000000) != 0;
            boolean bl = isInstantApp = (this.mFlags & 0x800000) != 0;
            if (matchVisibleToInstantApp && !info.isVisibleToInstantApp() && !userState.instantApp) {
                return null;
            }
            if (!isInstantApp && userState.instantApp) {
                return null;
            }
            if (userState.instantApp && ps.isUpdateAvailable()) {
                return null;
            }
            ProviderInfo pi = PackageParser.generateProviderInfo(provider, this.mFlags, userState, userId);
            if (pi == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.providerInfo = pi;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = provider.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = res.providerInfo.applicationInfo.isSystemApp();
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ProviderIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.provider)));
            out.print(' ');
            filter.provider.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ProviderIntentInfo filter) {
            return filter.provider;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Provider provider = (PackageParser.Provider)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(provider)));
            out.print(' ');
            provider.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }

    private final class ServiceIntentResolver
    extends IntentResolver<PackageParser.ServiceIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Service> mServices = new ArrayMap();
        private int mFlags;

        private ServiceIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Service> packageServices, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageServices == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageServices.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageServices.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ServiceIntentInfo[] array2 = new PackageParser.ServiceIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addService(PackageParser.Service s) {
            this.mServices.put(s.getComponentName(), s);
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Service " + s.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeService(PackageParser.Service s) {
            this.mServices.remove(s.getComponentName());
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ServiceIntentInfo filter, List<ResolveInfo> dest) {
            ServiceInfo filterSi = filter.service.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ServiceInfo destAi = dest.get((int)i).serviceInfo;
                if (destAi.name != filterSi.name || destAi.packageName != filterSi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ServiceIntentInfo[] newArray(int size) {
            return new PackageParser.ServiceIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ServiceIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.service.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ServiceIntentInfo info) {
            return packageName.equals(info.service.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ServiceIntentInfo filter, int match, int userId) {
            boolean isInstantApp;
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ServiceIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledAndMatchLPr(info.service.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Service service = info.service;
            PackageSetting ps = (PackageSetting)service.owner.mExtras;
            if (ps == null) {
                return null;
            }
            PackageUserState userState = ps.readUserState(userId);
            ServiceInfo si = PackageParser.generateServiceInfo(service, this.mFlags, userState, userId);
            if (si == null) {
                return null;
            }
            boolean matchVisibleToInstantApp = (this.mFlags & 0x1000000) != 0;
            boolean bl = isInstantApp = (this.mFlags & 0x800000) != 0;
            if (matchVisibleToInstantApp && !info.isVisibleToInstantApp() && !userState.instantApp) {
                return null;
            }
            if (!isInstantApp && userState.instantApp) {
                return null;
            }
            if (userState.instantApp && ps.isUpdateAvailable()) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.serviceInfo = si;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = service.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = res.serviceInfo.applicationInfo.isSystemApp();
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ServiceIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.service)));
            out.print(' ');
            filter.service.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ServiceIntentInfo filter) {
            return filter.service;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Service service = (PackageParser.Service)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(service)));
            out.print(' ');
            service.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }

    final class ActivityIntentResolver
    extends IntentResolver<PackageParser.ActivityIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Activity> mActivities = new ArrayMap();
        private int mFlags;

        ActivityIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Activity> packageActivities, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageActivities == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageActivities.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageActivities.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ActivityIntentInfo[] array2 = new PackageParser.ActivityIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        private PackageParser.Activity findMatchingActivity(List<PackageParser.Activity> activityList, ActivityInfo activityInfo) {
            for (PackageParser.Activity sysActivity : activityList) {
                if (sysActivity.info.name.equals(activityInfo.name)) {
                    return sysActivity;
                }
                if (sysActivity.info.name.equals(activityInfo.targetActivity)) {
                    return sysActivity;
                }
                if (sysActivity.info.targetActivity == null) continue;
                if (sysActivity.info.targetActivity.equals(activityInfo.name)) {
                    return sysActivity;
                }
                if (!sysActivity.info.targetActivity.equals(activityInfo.targetActivity)) continue;
                return sysActivity;
            }
            return null;
        }

        private <T> void getIntentListSubset(List<PackageParser.ActivityIntentInfo> intentList, IterGenerator<T> generator, Iterator<T> searchIterator) {
            while (searchIterator.hasNext() && intentList.size() != 0) {
                T searchAction = searchIterator.next();
                Iterator<PackageParser.ActivityIntentInfo> intentIter = intentList.iterator();
                while (intentIter.hasNext()) {
                    PackageParser.ActivityIntentInfo intentInfo = intentIter.next();
                    boolean selectionFound = false;
                    Iterator<T> intentSelectionIter = generator.generate(intentInfo);
                    while (intentSelectionIter != null && intentSelectionIter.hasNext()) {
                        T intentSelection = intentSelectionIter.next();
                        if (intentSelection == null || !intentSelection.equals(searchAction)) continue;
                        selectionFound = true;
                        break;
                    }
                    if (selectionFound) continue;
                    intentIter.remove();
                }
            }
        }

        private boolean isProtectedAction(PackageParser.ActivityIntentInfo filter) {
            Iterator<String> actionsIter = filter.actionsIterator();
            while (actionsIter != null && actionsIter.hasNext()) {
                String filterAction = actionsIter.next();
                if (!PROTECTED_ACTIONS.contains(filterAction)) continue;
                return true;
            }
            return false;
        }

        private void adjustPriority(List<PackageParser.Activity> systemActivities, PackageParser.ActivityIntentInfo intent) {
            Iterator<IntentFilter.AuthorityEntry> authoritiesIterator;
            Iterator<String> schemesIterator;
            Iterator<String> categoriesIterator;
            boolean privilegedApp;
            if (intent.getPriority() <= 0) {
                return;
            }
            ActivityInfo activityInfo = intent.activity.info;
            ApplicationInfo applicationInfo = activityInfo.applicationInfo;
            boolean bl = privilegedApp = (applicationInfo.privateFlags & 8) != 0;
            if (!privilegedApp) {
                intent.setPriority(0);
                return;
            }
            if (systemActivities == null) {
                if (this.isProtectedAction(intent)) {
                    if (PackageManagerService.this.mDeferProtectedFilters) {
                        PackageManagerService.this.mProtectedFilters.add(intent);
                        return;
                    }
                    if (intent.activity.info.packageName.equals(PackageManagerService.this.mSetupWizardPackage)) {
                        return;
                    }
                    intent.setPriority(0);
                    return;
                }
                return;
            }
            PackageParser.Activity foundActivity = this.findMatchingActivity(systemActivities, activityInfo);
            if (foundActivity == null) {
                intent.setPriority(0);
                return;
            }
            ArrayList<PackageParser.ActivityIntentInfo> intentListCopy = new ArrayList<PackageParser.ActivityIntentInfo>(foundActivity.intents);
            ArrayList foundFilters = this.findFilters(intent);
            Iterator<String> actionsIterator = intent.actionsIterator();
            if (actionsIterator != null) {
                this.getIntentListSubset(intentListCopy, new ActionIterGenerator(), actionsIterator);
                if (intentListCopy.size() == 0) {
                    intent.setPriority(0);
                    return;
                }
            }
            if ((categoriesIterator = intent.categoriesIterator()) != null) {
                this.getIntentListSubset(intentListCopy, new CategoriesIterGenerator(), categoriesIterator);
                if (intentListCopy.size() == 0) {
                    intent.setPriority(0);
                    return;
                }
            }
            if ((schemesIterator = intent.schemesIterator()) != null) {
                this.getIntentListSubset(intentListCopy, new SchemesIterGenerator(), schemesIterator);
                if (intentListCopy.size() == 0) {
                    intent.setPriority(0);
                    return;
                }
            }
            if ((authoritiesIterator = intent.authoritiesIterator()) != null) {
                this.getIntentListSubset(intentListCopy, new AuthoritiesIterGenerator(), authoritiesIterator);
                if (intentListCopy.size() == 0) {
                    intent.setPriority(0);
                    return;
                }
            }
            int cappedPriority = 0;
            for (int i = intentListCopy.size() - 1; i >= 0; --i) {
                cappedPriority = Math.max(cappedPriority, ((PackageParser.ActivityIntentInfo)intentListCopy.get(i)).getPriority());
            }
            if (intent.getPriority() > cappedPriority) {
                intent.setPriority(cappedPriority);
                return;
            }
        }

        public final void addActivity(PackageParser.Activity a, String type) {
            this.mActivities.put(a.getComponentName(), a);
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                if ("activity".equals(type)) {
                    PackageSetting ps = PackageManagerService.this.mSettings.getDisabledSystemPkgLPr(intent.activity.info.packageName);
                    ArrayList<PackageParser.Activity> systemActivities = ps != null && ps.pkg != null ? ps.pkg.activities : null;
                    this.adjustPriority(systemActivities, intent);
                }
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Activity " + a.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeActivity(PackageParser.Activity a, String type) {
            this.mActivities.remove(a.getComponentName());
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ActivityIntentInfo filter, List<ResolveInfo> dest) {
            ActivityInfo filterAi = filter.activity.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ActivityInfo destAi = dest.get((int)i).activityInfo;
                if (destAi.name != filterAi.name || destAi.packageName != filterAi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ActivityIntentInfo[] newArray(int size) {
            return new PackageParser.ActivityIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ActivityIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.activity.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ActivityIntentInfo info) {
            return packageName.equals(info.activity.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ActivityIntentInfo info, int match, int userId) {
            boolean matchInstantApp;
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (!PackageManagerService.this.mSettings.isEnabledAndMatchLPr(info.activity.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Activity activity = info.activity;
            PackageSetting ps = (PackageSetting)activity.owner.mExtras;
            if (ps == null) {
                return null;
            }
            PackageUserState userState = ps.readUserState(userId);
            ActivityInfo ai = PackageParser.generateActivityInfo(activity, this.mFlags, userState, userId);
            if (ai == null) {
                return null;
            }
            boolean matchExplicitlyVisibleOnly = (this.mFlags & 0x2000000) != 0;
            boolean matchVisibleToInstantApp = (this.mFlags & 0x1000000) != 0;
            boolean componentVisible = matchVisibleToInstantApp && info.isVisibleToInstantApp() && (!matchExplicitlyVisibleOnly || info.isExplicitlyVisibleToInstantApp());
            boolean bl = matchInstantApp = (this.mFlags & 0x800000) != 0;
            if (matchVisibleToInstantApp && !componentVisible && !userState.instantApp) {
                return null;
            }
            if (!matchInstantApp && userState.instantApp) {
                return null;
            }
            if (userState.instantApp && ps.isUpdateAvailable()) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.activityInfo = ai;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = info;
            }
            if (info != null) {
                res.handleAllWebDataURI = info.handleAllWebDataURI();
            }
            res.priority = info.getPriority();
            res.preferredOrder = activity.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            if (PackageManagerService.this.userNeedsBadging(userId)) {
                res.noResourceId = true;
            } else {
                res.icon = info.icon;
            }
            res.iconResourceId = info.icon;
            res.system = res.activityInfo.applicationInfo.isSystemApp();
            res.isInstantAppAvailable = userState.instantApp;
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ActivityIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.activity)));
            out.print(' ');
            filter.activity.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ActivityIntentInfo filter) {
            return filter.activity;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Activity activity = (PackageParser.Activity)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(activity)));
            out.print(' ');
            activity.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }

        public class AuthoritiesIterGenerator
        extends IterGenerator<IntentFilter.AuthorityEntry> {
            @Override
            public Iterator<IntentFilter.AuthorityEntry> generate(PackageParser.ActivityIntentInfo info) {
                return info.authoritiesIterator();
            }
        }

        public class SchemesIterGenerator
        extends IterGenerator<String> {
            @Override
            public Iterator<String> generate(PackageParser.ActivityIntentInfo info) {
                return info.schemesIterator();
            }
        }

        public class CategoriesIterGenerator
        extends IterGenerator<String> {
            @Override
            public Iterator<String> generate(PackageParser.ActivityIntentInfo info) {
                return info.categoriesIterator();
            }
        }

        public class ActionIterGenerator
        extends IterGenerator<String> {
            @Override
            public Iterator<String> generate(PackageParser.ActivityIntentInfo info) {
                return info.actionsIterator();
            }
        }

        public class IterGenerator<E> {
            public Iterator<E> generate(PackageParser.ActivityIntentInfo info) {
                return null;
            }
        }
    }

    private static class CrossProfileDomainInfo {
        ResolveInfo resolveInfo;
        int bestDomainVerificationStatus;

        private CrossProfileDomainInfo() {
        }
    }

    class PackageHandler
    extends Handler {
        private boolean mBound;
        final ArrayList<HandlerParams> mPendingInstalls;

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            Process.setThreadPriority(0);
            if (PackageManagerService.this.mContext.bindServiceAsUser(service, PackageManagerService.this.mDefContainerConn, 1, UserHandle.SYSTEM)) {
                Process.setThreadPriority(10);
                this.mBound = true;
                return true;
            }
            Process.setThreadPriority(10);
            return false;
        }

        private void disconnectService() {
            PackageManagerService.this.mContainerService = null;
            this.mBound = false;
            Process.setThreadPriority(0);
            PackageManagerService.this.mContext.unbindService(PackageManagerService.this.mDefContainerConn);
            Process.setThreadPriority(10);
        }

        PackageHandler(Looper looper) {
            super(looper);
            this.mBound = false;
            this.mPendingInstalls = new ArrayList();
        }

        @Override
        public void handleMessage(Message msg) {
            try {
                this.doHandleMessage(msg);
            }
            finally {
                Process.setThreadPriority(10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doHandleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    HandlerParams params = (HandlerParams)msg.obj;
                    int idx = this.mPendingInstalls.size();
                    if (!this.mBound) {
                        Trace.asyncTraceBegin(262144L, "bindingMCS", System.identityHashCode(PackageManagerService.this.mHandler));
                        if (!this.connectToService()) {
                            Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                            params.serviceError();
                            Trace.asyncTraceEnd(262144L, "bindingMCS", System.identityHashCode(PackageManagerService.this.mHandler));
                            if (params.traceMethod != null) {
                                Trace.asyncTraceEnd(262144L, params.traceMethod, params.traceCookie);
                            }
                            return;
                        }
                        this.mPendingInstalls.add(idx, params);
                        break;
                    }
                    this.mPendingInstalls.add(idx, params);
                    if (idx != 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 3: {
                    if (msg.obj != null) {
                        PackageManagerService.this.mContainerService = (IMediaContainerService)msg.obj;
                        Trace.asyncTraceEnd(262144L, "bindingMCS", System.identityHashCode(PackageManagerService.this.mHandler));
                    }
                    if (PackageManagerService.this.mContainerService == null) {
                        if (!this.mBound) {
                            Slog.e(PackageManagerService.TAG, "Cannot bind to media container service");
                            Iterator<HandlerParams> params = this.mPendingInstalls.iterator();
                            if (params.hasNext()) {
                                HandlerParams params2 = params.next();
                                params2.serviceError();
                                Trace.asyncTraceEnd(262144L, "queueInstall", System.identityHashCode(params2));
                                if (params2.traceMethod != null) {
                                    Trace.asyncTraceEnd(262144L, params2.traceMethod, params2.traceCookie);
                                }
                                return;
                            }
                            this.mPendingInstalls.clear();
                            break;
                        }
                        Slog.w(PackageManagerService.TAG, "Waiting to connect to media container service");
                        break;
                    }
                    if (this.mPendingInstalls.size() > 0) {
                        HandlerParams params = this.mPendingInstalls.get(0);
                        if (params == null) break;
                        Trace.asyncTraceEnd(262144L, "queueInstall", System.identityHashCode(params));
                        Trace.traceBegin(262144L, "startCopy");
                        if (params.startCopy()) {
                            if (this.mPendingInstalls.size() > 0) {
                                this.mPendingInstalls.remove(0);
                            }
                            if (this.mPendingInstalls.size() == 0) {
                                if (this.mBound) {
                                    this.removeMessages(6);
                                    Message ubmsg = this.obtainMessage(6);
                                    this.sendMessageDelayed(ubmsg, 10000L);
                                }
                            } else {
                                PackageManagerService.this.mHandler.sendEmptyMessage(3);
                            }
                        }
                        Trace.traceEnd(262144L);
                        break;
                    }
                    Slog.w(PackageManagerService.TAG, "Empty queue");
                    break;
                }
                case 10: {
                    if (this.mPendingInstalls.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                    for (HandlerParams params : this.mPendingInstalls) {
                        params.serviceError();
                        Trace.asyncTraceEnd(262144L, "queueInstall", System.identityHashCode(params));
                    }
                    this.mPendingInstalls.clear();
                    break;
                }
                case 6: {
                    if (this.mPendingInstalls.size() == 0 && PackageManagerService.this.mPendingVerification.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    if (this.mPendingInstalls.size() <= 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 11: {
                    HandlerParams params = this.mPendingInstalls.remove(0);
                    Trace.asyncTraceEnd(262144L, "queueInstall", System.identityHashCode(params));
                    break;
                }
                case 1: {
                    int[] uids;
                    ArrayList[] components;
                    String[] packages;
                    int size = 0;
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        if (PackageManagerService.this.mPendingBroadcasts == null) {
                            return;
                        }
                        size = PackageManagerService.this.mPendingBroadcasts.size();
                        if (size <= 0) {
                            return;
                        }
                        packages = new String[size];
                        components = new ArrayList[size];
                        uids = new int[size];
                        int i = 0;
                        for (int n = 0; n < PackageManagerService.this.mPendingBroadcasts.userIdCount(); ++n) {
                            int packageUserId = PackageManagerService.this.mPendingBroadcasts.userIdAt(n);
                            Iterator<Map.Entry<String, ArrayList<String>>> it = PackageManagerService.this.mPendingBroadcasts.packagesForUserId(packageUserId).entrySet().iterator();
                            while (it.hasNext() && i < size) {
                                Map.Entry<String, ArrayList<String>> ent = it.next();
                                packages[i] = ent.getKey();
                                components[i] = ent.getValue();
                                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(ent.getKey());
                                uids[i] = ps != null ? UserHandle.getUid(packageUserId, ps.appId) : -1;
                                ++i;
                            }
                        }
                        size = i;
                        PackageManagerService.this.mPendingBroadcasts.clear();
                    }
                    for (int i = 0; i < size; ++i) {
                        PackageManagerService.this.sendPackageChangedBroadcast(packages[i], true, components[i], uids[i]);
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 7: {
                    Process.setThreadPriority(0);
                    String packageName = (String)msg.obj;
                    int userId = msg.arg1;
                    boolean andCode = msg.arg2 != 0;
                    ArrayMap<String, PackageParser.Package> uids = PackageManagerService.this.mPackages;
                    synchronized (uids) {
                        if (userId == -1) {
                            int[] users;
                            for (int user : users = sUserManager.getUserIds()) {
                                PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(user, packageName, andCode));
                            }
                        } else {
                            PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(userId, packageName, andCode));
                        }
                    }
                    Process.setThreadPriority(10);
                    PackageManagerService.this.startCleaningPackages();
                    break;
                }
                case 9: {
                    PostInstallData data = PackageManagerService.this.mRunningInstalls.get(msg.arg1);
                    boolean didRestore = msg.arg2 != 0;
                    PackageManagerService.this.mRunningInstalls.delete(msg.arg1);
                    if (data != null) {
                        InstallArgs args = data.args;
                        PackageInstalledInfo parentRes = data.res;
                        boolean grantPermissions = (args.installFlags & 0x100) != 0;
                        boolean killApp = (args.installFlags & 0x1000) == 0;
                        String[] grantedPermissions = args.installGrantPermissions;
                        PackageManagerService.this.handlePackagePostInstall(parentRes, grantPermissions, killApp, grantedPermissions, didRestore, args.installerPackageName, args.observer);
                        int childCount = parentRes.addedChildPackages != null ? parentRes.addedChildPackages.size() : 0;
                        for (int i = 0; i < childCount; ++i) {
                            PackageInstalledInfo childRes = parentRes.addedChildPackages.valueAt(i);
                            PackageManagerService.this.handlePackagePostInstall(childRes, grantPermissions, killApp, grantedPermissions, false, args.installerPackageName, args.observer);
                        }
                        if (args.traceMethod != null) {
                            Trace.asyncTraceEnd(262144L, args.traceMethod, args.traceCookie);
                        }
                    } else {
                        Slog.e(PackageManagerService.TAG, "Bogus post-install token " + msg.arg1);
                    }
                    Trace.asyncTraceEnd(262144L, "postInstall", msg.arg1);
                    break;
                }
                case 12: {
                    boolean doGc;
                    boolean reportStatus = msg.arg1 == 1;
                    boolean bl = doGc = msg.arg2 == 1;
                    if (doGc) {
                        Runtime.getRuntime().gc();
                    }
                    if (msg.obj != null) {
                        Set args = (Set)msg.obj;
                        PackageManagerService.this.unloadAllContainers(args);
                    }
                    if (!reportStatus) break;
                    try {
                        PackageHelper.getStorageManager().finishMediaUpdate();
                    }
                    catch (RemoteException e) {
                        Log.e(PackageManagerService.TAG, "StorageManagerService not running?");
                    }
                    break;
                }
                case 13: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(13);
                        this.removeMessages(14);
                        PackageManagerService.this.mSettings.writeLPr();
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 14: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(14);
                        Iterator doGc = PackageManagerService.this.mDirtyUsers.iterator();
                        while (doGc.hasNext()) {
                            int userId = (Integer)doGc.next();
                            PackageManagerService.this.mSettings.writePackageRestrictionsLPr(userId);
                        }
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 19: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(19);
                        PackageManagerService.this.mSettings.writePackageListLPr(msg.arg1);
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 16: {
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null || state.timeoutExtended()) break;
                    InstallArgs args = state.getInstallArgs();
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    Slog.i(PackageManagerService.TAG, "Verification timed out for " + originUri);
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    int ret = -22;
                    UserHandle user = args.getUser();
                    if (PackageManagerService.this.getDefaultVerificationResponse(user) == 1) {
                        Slog.i(PackageManagerService.TAG, "Continuing with installation of " + originUri);
                        state.setVerifierResponse(Binder.getCallingUid(), 2);
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, 1, user);
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, -1, user);
                    }
                    Trace.asyncTraceEnd(262144L, "verification", verificationId);
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
                case 15: {
                    int ret;
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid verification token " + verificationId + " received");
                        break;
                    }
                    PackageVerificationResponse response = (PackageVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    InstallArgs args = state.getInstallArgs();
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    if (state.isInstallAllowed()) {
                        ret = -110;
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, response.code, state.getInstallArgs().getUser());
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        ret = -22;
                    }
                    Trace.asyncTraceEnd(262144L, "verification", verificationId);
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
                case 17: {
                    IFVerificationParams params = (IFVerificationParams)msg.obj;
                    PackageManagerService.this.verifyIntentFiltersIfNeeded(params.userId, params.verifierUid, params.replacing, params.pkg);
                    break;
                }
                case 18: {
                    int verificationId = msg.arg1;
                    IntentFilterVerificationState state = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid IntentFilter verification token " + verificationId + " received");
                        break;
                    }
                    int userId = state.getUserId();
                    IntentFilterVerificationResponse response = (IntentFilterVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (response.code == -1) {
                        // empty if block
                    }
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mIntentFilterVerifier.receiveVerificationResponse(verificationId);
                    break;
                }
                case 20: {
                    InstantAppResolver.doInstantAppResolutionPhaseTwo(PackageManagerService.this.mContext, PackageManagerService.this.mInstantAppResolverConnection, (InstantAppRequest)msg.obj, PackageManagerService.this.mInstantAppInstallerActivity, PackageManagerService.this.mHandler);
                }
            }
        }
    }

    static class PostInstallData {
        public InstallArgs args;
        public PackageInstalledInfo res;

        PostInstallData(InstallArgs _a, PackageInstalledInfo _r) {
            this.args = _a;
            this.res = _r;
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface(Binder.allowBlocking(service));
            PackageManagerService.this.mHandler.sendMessage(PackageManagerService.this.mHandler.obtainMessage(3, imcs));
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    static class PendingPackageBroadcasts {
        final SparseArray<ArrayMap<String, ArrayList<String>>> mUidMap = new SparseArray(2);

        public ArrayList<String> get(int userId, String packageName) {
            ArrayMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            return packages.get(packageName);
        }

        public void put(int userId, String packageName, ArrayList<String> components) {
            ArrayMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            packages.put(packageName, components);
        }

        public void remove(int userId, String packageName) {
            ArrayMap<String, ArrayList<String>> packages = this.mUidMap.get(userId);
            if (packages != null) {
                packages.remove(packageName);
            }
        }

        public void remove(int userId) {
            this.mUidMap.remove(userId);
        }

        public int userIdCount() {
            return this.mUidMap.size();
        }

        public int userIdAt(int n) {
            return this.mUidMap.keyAt(n);
        }

        public ArrayMap<String, ArrayList<String>> packagesForUserId(int userId) {
            return this.mUidMap.get(userId);
        }

        public int size() {
            int num = 0;
            for (int i = 0; i < this.mUidMap.size(); ++i) {
                num += this.mUidMap.valueAt(i).size();
            }
            return num;
        }

        public void clear() {
            this.mUidMap.clear();
        }

        private ArrayMap<String, ArrayList<String>> getOrAllocate(int userId) {
            ArrayMap<String, ArrayList<String>> map = this.mUidMap.get(userId);
            if (map == null) {
                map = new ArrayMap();
                this.mUidMap.put(userId, map);
            }
            return map;
        }
    }

    private class IntentVerifierProxy
    implements IntentFilterVerifier<PackageParser.ActivityIntentInfo> {
        private Context mContext;
        private ComponentName mIntentFilterVerifierComponent;
        private ArrayList<Integer> mCurrentIntentFilterVerifications = new ArrayList();

        public IntentVerifierProxy(Context context, ComponentName verifierComponent) {
            this.mContext = context;
            this.mIntentFilterVerifierComponent = verifierComponent;
        }

        private String getDefaultScheme() {
            return "https";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startVerifications(int userId) {
            int count = this.mCurrentIntentFilterVerifications.size();
            for (int n = 0; n < count; ++n) {
                int verificationId = this.mCurrentIntentFilterVerifications.get(n);
                IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
                String packageName = ivs.getPackageName();
                ArrayList<PackageParser.ActivityIntentInfo> filters = ivs.getFilters();
                int filterCount = filters.size();
                ArraySet<String> domainsSet = new ArraySet<String>();
                for (int m = 0; m < filterCount; ++m) {
                    PackageParser.ActivityIntentInfo filter = filters.get(m);
                    domainsSet.addAll(filter.getHostsList());
                }
                ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                synchronized (arrayMap) {
                    if (PackageManagerService.this.mSettings.createIntentFilterVerificationIfNeededLPw(packageName, domainsSet) != null) {
                        PackageManagerService.this.scheduleWriteSettingsLocked();
                    }
                }
                this.sendVerificationRequest(userId, verificationId, ivs);
            }
            this.mCurrentIntentFilterVerifications.clear();
        }

        private void sendVerificationRequest(int userId, int verificationId, IntentFilterVerificationState ivs) {
            Intent verificationIntent = new Intent("android.intent.action.INTENT_FILTER_NEEDS_VERIFICATION");
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_ID", verificationId);
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_URI_SCHEME", this.getDefaultScheme());
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_HOSTS", ivs.getHostsString());
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_PACKAGE_NAME", ivs.getPackageName());
            verificationIntent.setComponent(this.mIntentFilterVerifierComponent);
            verificationIntent.addFlags(0x10000000);
            DeviceIdleController.LocalService idleController = PackageManagerService.this.getDeviceIdleController();
            idleController.addPowerSaveTempWhitelistApp(Process.myUid(), this.mIntentFilterVerifierComponent.getPackageName(), PackageManagerService.this.getVerificationTimeout(), userId, false, "intent filter verifier");
            UserHandle user = new UserHandle(userId);
            this.mContext.sendBroadcastAsUser(verificationIntent, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveVerificationResponse(int verificationId) {
            IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
            boolean verified = ivs.isVerified();
            ArrayList<PackageParser.ActivityIntentInfo> filters = ivs.getFilters();
            int count = filters.size();
            for (int n = 0; n < count; ++n) {
                PackageParser.ActivityIntentInfo filter = filters.get(n);
                filter.setVerified(verified);
            }
            PackageManagerService.this.mIntentFilterVerificationStates.remove(verificationId);
            String packageName = ivs.getPackageName();
            IntentFilterVerificationInfo ivi = null;
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                ivi = PackageManagerService.this.mSettings.getIntentFilterVerificationLPr(packageName);
            }
            if (ivi == null) {
                Slog.w(PackageManagerService.TAG, "IntentFilterVerificationInfo not found for verificationId:" + verificationId + " packageName:" + packageName);
                return;
            }
            arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                if (verified) {
                    ivi.setStatus(2);
                } else {
                    ivi.setStatus(1);
                }
                PackageManagerService.this.scheduleWriteSettingsLocked();
                int userId = ivs.getUserId();
                if (userId != -1) {
                    int userStatus = PackageManagerService.this.mSettings.getIntentFilterVerificationStatusLPr(packageName, userId);
                    int updatedStatus = 0;
                    boolean needUpdate = false;
                    switch (userStatus) {
                        case 0: {
                            updatedStatus = verified ? 2 : 1;
                            needUpdate = true;
                            break;
                        }
                        case 1: {
                            if (!verified) break;
                            updatedStatus = 2;
                            needUpdate = true;
                            break;
                        }
                    }
                    if (needUpdate) {
                        PackageManagerService.this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, updatedStatus, userId);
                        PackageManagerService.this.scheduleWritePackageRestrictionsLocked(userId);
                    }
                }
            }
        }

        @Override
        public boolean addOneIntentFilterVerification(int verifierUid, int userId, int verificationId, PackageParser.ActivityIntentInfo filter, String packageName) {
            if (!PackageManagerService.hasValidDomains(filter)) {
                return false;
            }
            IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
            if (ivs == null) {
                ivs = this.createDomainVerificationState(verifierUid, userId, verificationId, packageName);
            }
            ivs.addFilter(filter);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IntentFilterVerificationState createDomainVerificationState(int verifierUid, int userId, int verificationId, String packageName) {
            IntentFilterVerificationState ivs = new IntentFilterVerificationState(verifierUid, userId, packageName);
            ivs.setPendingState();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mIntentFilterVerificationStates.append(verificationId, ivs);
                this.mCurrentIntentFilterVerifications.add(verificationId);
            }
            return ivs;
        }
    }

    private static interface IntentFilterVerifier<T extends IntentFilter> {
        public boolean addOneIntentFilterVerification(int var1, int var2, int var3, T var4, String var5);

        public void startVerifications(int var1);

        public void receiveVerificationResponse(int var1);
    }

    private static class IFVerificationParams {
        PackageParser.Package pkg;
        boolean replacing;
        int userId;
        int verifierUid;

        public IFVerificationParams(PackageParser.Package _pkg, boolean _replacing, int _userId, int _verifierUid) {
            this.pkg = _pkg;
            this.replacing = _replacing;
            this.userId = _userId;
            this.replacing = _replacing;
            this.verifierUid = _verifierUid;
        }
    }

    public static final class SharedLibraryEntry {
        public final String path;
        public final String apk;
        public final SharedLibraryInfo info;

        SharedLibraryEntry(String _path, String _apk, String name, int version, int type, String declaringPackageName, int declaringPackageVersionCode) {
            this.path = _path;
            this.apk = _apk;
            this.info = new SharedLibraryInfo(name, version, type, new VersionedPackage(declaringPackageName, declaringPackageVersionCode), null);
        }
    }

    class ParallelPackageParserCallback
    extends PackageParserCallback {
        List<PackageParser.Package> mOverlayPackages;

        ParallelPackageParserCallback() {
            this.mOverlayPackages = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void findStaticOverlayPackages() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                for (PackageParser.Package p : PackageManagerService.this.mPackages.values()) {
                    if (!p.mIsStaticOverlay) continue;
                    if (this.mOverlayPackages == null) {
                        this.mOverlayPackages = new ArrayList<PackageParser.Package>();
                    }
                    this.mOverlayPackages.add(p);
                }
            }
        }

        @Override
        synchronized String[] getStaticOverlayPaths(String targetPackageName, String targetPath) {
            return this.mOverlayPackages == null ? null : this.getStaticOverlayPathsLocked(this.mOverlayPackages, targetPackageName, targetPath);
        }
    }

    class PackageParserCallback
    implements PackageParser.Callback {
        PackageParserCallback() {
        }

        @Override
        public final boolean hasFeature(String feature) {
            return PackageManagerService.this.hasSystemFeature(feature, 0);
        }

        final List<PackageParser.Package> getStaticOverlayPackagesLocked(Collection<PackageParser.Package> allPackages, String targetPackageName) {
            ArrayList<PackageParser.Package> overlayPackages = null;
            for (PackageParser.Package p : allPackages) {
                if (!targetPackageName.equals(p.mOverlayTarget) || !p.mIsStaticOverlay) continue;
                if (overlayPackages == null) {
                    overlayPackages = new ArrayList<PackageParser.Package>();
                }
                overlayPackages.add(p);
            }
            if (overlayPackages != null) {
                Comparator<PackageParser.Package> cmp = new Comparator<PackageParser.Package>(){

                    @Override
                    public int compare(PackageParser.Package p1, PackageParser.Package p2) {
                        return p1.mOverlayPriority - p2.mOverlayPriority;
                    }
                };
                Collections.sort(overlayPackages, cmp);
            }
            return overlayPackages;
        }

        final String[] getStaticOverlayPathsLocked(Collection<PackageParser.Package> allPackages, String targetPackageName, String targetPath) {
            if (PackageManagerService.PLATFORM_PACKAGE_NAME.equals(targetPackageName)) {
                return null;
            }
            List<PackageParser.Package> overlayPackages = this.getStaticOverlayPackagesLocked(allPackages, targetPackageName);
            if (overlayPackages == null || overlayPackages.isEmpty()) {
                return null;
            }
            ArrayList<String> overlayPathList = null;
            for (PackageParser.Package overlayPackage : overlayPackages) {
                if (targetPath == null) {
                    if (overlayPathList == null) {
                        overlayPathList = new ArrayList<String>();
                    }
                    overlayPathList.add(overlayPackage.baseCodePath);
                    continue;
                }
                try {
                    PackageManagerService.this.mInstaller.idmap(targetPath, overlayPackage.baseCodePath, UserHandle.getSharedAppGid(UserHandle.getUserGid(0)));
                    if (overlayPathList == null) {
                        overlayPathList = new ArrayList();
                    }
                    overlayPathList.add(overlayPackage.baseCodePath);
                }
                catch (Installer.InstallerException e) {
                    Slog.e(PackageManagerService.TAG, "Failed to generate idmap for " + targetPath + " and " + overlayPackage.baseCodePath);
                }
            }
            return overlayPathList == null ? null : overlayPathList.toArray(new String[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getStaticOverlayPaths(String targetPackageName, String targetPath) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                return this.getStaticOverlayPathsLocked(PackageManagerService.this.mPackages.values(), targetPackageName, targetPath);
            }
        }

        @Override
        public final String[] getOverlayApks(String targetPackageName) {
            return this.getStaticOverlayPaths(targetPackageName, null);
        }

        @Override
        public final String[] getOverlayPaths(String targetPackageName, String targetPath) {
            return this.getStaticOverlayPaths(targetPackageName, targetPath);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(prefix={"TYPE_"}, value={0L, 1L, 2L, 3L, 4L})
    public static @interface ComponentType {
    }
}

