/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.os.FileUtils;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.pm.Installer;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import com.android.server.pm.PackageManagerServiceUtils;
import com.android.server.pm.dex.PackageDexUsage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DexManager {
    private static final String TAG = "DexManager";
    private static final boolean DEBUG = false;
    @GuardedBy(value="mPackageCodeLocationsCache")
    private final Map<String, PackageCodeLocations> mPackageCodeLocationsCache = new HashMap<String, PackageCodeLocations>();
    private final PackageDexUsage mPackageDexUsage = new PackageDexUsage();
    private final IPackageManager mPackageManager;
    private final PackageDexOptimizer mPackageDexOptimizer;
    private final Object mInstallLock;
    @GuardedBy(value="mInstallLock")
    private final Installer mInstaller;
    private static int DEX_SEARCH_NOT_FOUND = 0;
    private static int DEX_SEARCH_FOUND_PRIMARY = 1;
    private static int DEX_SEARCH_FOUND_SPLIT = 2;
    private static int DEX_SEARCH_FOUND_SECONDARY = 3;

    public DexManager(IPackageManager pms, PackageDexOptimizer pdo, Installer installer, Object installLock) {
        this.mPackageManager = pms;
        this.mPackageDexOptimizer = pdo;
        this.mInstaller = installer;
        this.mInstallLock = installLock;
    }

    public void notifyDexLoad(ApplicationInfo loadingAppInfo, List<String> dexPaths, String loaderIsa, int loaderUserId) {
        try {
            this.notifyDexLoadInternal(loadingAppInfo, dexPaths, loaderIsa, loaderUserId);
        }
        catch (Exception e) {
            Slog.w(TAG, "Exception while notifying dex load for package " + loadingAppInfo.packageName, e);
        }
    }

    private void notifyDexLoadInternal(ApplicationInfo loadingAppInfo, List<String> dexPaths, String loaderIsa, int loaderUserId) {
        if (!PackageManagerServiceUtils.checkISA(loaderIsa)) {
            Slog.w(TAG, "Loading dex files " + dexPaths + " in unsupported ISA: " + loaderIsa + "?");
            return;
        }
        for (String dexPath : dexPaths) {
            boolean primaryOrSplit;
            DexSearchResult searchResult = this.getDexPackage(loadingAppInfo, dexPath, loaderUserId);
            if (searchResult.mOutcome == DEX_SEARCH_NOT_FOUND) continue;
            boolean isUsedByOtherApps = !loadingAppInfo.packageName.equals(searchResult.mOwningPackageName);
            boolean bl = primaryOrSplit = searchResult.mOutcome == DEX_SEARCH_FOUND_PRIMARY || searchResult.mOutcome == DEX_SEARCH_FOUND_SPLIT;
            if (primaryOrSplit && !isUsedByOtherApps || !this.mPackageDexUsage.record(searchResult.mOwningPackageName, dexPath, loaderUserId, loaderIsa, isUsedByOtherApps, primaryOrSplit)) continue;
            this.mPackageDexUsage.maybeWriteAsync();
        }
    }

    public void load(Map<Integer, List<PackageInfo>> existingPackages) {
        try {
            this.loadInternal(existingPackages);
        }
        catch (Exception e) {
            this.mPackageDexUsage.clear();
            Slog.w(TAG, "Exception while loading package dex usage. Starting with a fresh state.", e);
        }
    }

    public void notifyPackageInstalled(PackageInfo pi, int userId) {
        if (userId == -1) {
            throw new IllegalArgumentException("notifyPackageInstalled called with USER_ALL");
        }
        this.cachePackageInfo(pi, userId);
    }

    public void notifyPackageUpdated(String packageName, String baseCodePath, String[] splitCodePaths) {
        this.cachePackageCodeLocation(packageName, baseCodePath, splitCodePaths, null, -1);
        if (this.mPackageDexUsage.clearUsedByOtherApps(packageName)) {
            this.mPackageDexUsage.maybeWriteAsync();
        }
    }

    public void notifyPackageDataDestroyed(String packageName, int userId) {
        boolean updated;
        boolean bl = updated = userId == -1 ? this.mPackageDexUsage.removePackage(packageName) : this.mPackageDexUsage.removeUserPackage(packageName, userId);
        if (updated) {
            this.mPackageDexUsage.maybeWriteAsync();
        }
    }

    private void cachePackageInfo(PackageInfo pi, int userId) {
        ApplicationInfo ai = pi.applicationInfo;
        String[] dataDirs = new String[]{ai.dataDir, ai.deviceProtectedDataDir, ai.credentialProtectedDataDir};
        this.cachePackageCodeLocation(pi.packageName, ai.sourceDir, ai.splitSourceDirs, dataDirs, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePackageCodeLocation(String packageName, String baseCodePath, String[] splitCodePaths, String[] dataDirs, int userId) {
        Map<String, PackageCodeLocations> map = this.mPackageCodeLocationsCache;
        synchronized (map) {
            PackageCodeLocations pcl = DexManager.putIfAbsent(this.mPackageCodeLocationsCache, packageName, new PackageCodeLocations(packageName, baseCodePath, splitCodePaths));
            pcl.updateCodeLocation(baseCodePath, splitCodePaths);
            if (dataDirs != null) {
                for (String dataDir : dataDirs) {
                    if (dataDir == null) continue;
                    pcl.mergeAppDataDirs(dataDir, userId);
                }
            }
        }
    }

    private void loadInternal(Map<Integer, List<PackageInfo>> existingPackages) {
        HashMap<String, Set<Integer>> packageToUsersMap = new HashMap<String, Set<Integer>>();
        for (Map.Entry<Integer, List<PackageInfo>> entry : existingPackages.entrySet()) {
            List<PackageInfo> packageInfoList = entry.getValue();
            int userId = entry.getKey();
            for (PackageInfo pi : packageInfoList) {
                this.cachePackageInfo(pi, userId);
                Set users = DexManager.putIfAbsent(packageToUsersMap, pi.packageName, new HashSet());
                users.add(userId);
            }
        }
        this.mPackageDexUsage.read();
        this.mPackageDexUsage.syncData(packageToUsersMap);
    }

    public PackageDexUsage.PackageUseInfo getPackageUseInfo(String packageName) {
        return this.mPackageDexUsage.getPackageUseInfo(packageName);
    }

    public boolean dexoptSecondaryDex(String packageName, int compilerReason, boolean force) {
        return this.dexoptSecondaryDex(packageName, PackageManagerServiceCompilerMapping.getCompilerFilterForReason(compilerReason), force);
    }

    public boolean dexoptSecondaryDex(String packageName, String compilerFilter, boolean force) {
        PackageDexOptimizer pdo = force ? new PackageDexOptimizer.ForcedUpdatePackageDexOptimizer(this.mPackageDexOptimizer) : this.mPackageDexOptimizer;
        PackageDexUsage.PackageUseInfo useInfo = this.getPackageUseInfo(packageName);
        if (useInfo == null || useInfo.getDexUseInfoMap().isEmpty()) {
            return true;
        }
        boolean success = true;
        for (Map.Entry<String, PackageDexUsage.DexUseInfo> entry : useInfo.getDexUseInfoMap().entrySet()) {
            String dexPath = entry.getKey();
            PackageDexUsage.DexUseInfo dexUseInfo = entry.getValue();
            PackageInfo pkg = null;
            try {
                pkg = this.mPackageManager.getPackageInfo(packageName, 0, dexUseInfo.getOwnerUserId());
            }
            catch (RemoteException e) {
                throw new AssertionError((Object)e);
            }
            if (pkg == null) {
                Slog.d(TAG, "Could not find package when compiling secondary dex " + packageName + " for user " + dexUseInfo.getOwnerUserId());
                this.mPackageDexUsage.removeUserPackage(packageName, dexUseInfo.getOwnerUserId());
                continue;
            }
            int result = pdo.dexOptSecondaryDexPath(pkg.applicationInfo, dexPath, dexUseInfo.getLoaderIsas(), compilerFilter, dexUseInfo.isUsedByOtherApps());
            success = success && result != -1;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileSecondaryDexFiles(String packageName) {
        PackageDexUsage.PackageUseInfo useInfo = this.getPackageUseInfo(packageName);
        if (useInfo == null || useInfo.getDexUseInfoMap().isEmpty()) {
            return;
        }
        boolean updated = false;
        for (Map.Entry<String, PackageDexUsage.DexUseInfo> entry : useInfo.getDexUseInfoMap().entrySet()) {
            String dexPath = entry.getKey();
            PackageDexUsage.DexUseInfo dexUseInfo = entry.getValue();
            PackageInfo pkg = null;
            try {
                pkg = this.mPackageManager.getPackageInfo(packageName, 0, dexUseInfo.getOwnerUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (pkg == null) {
                Slog.d(TAG, "Could not find package when compiling secondary dex " + packageName + " for user " + dexUseInfo.getOwnerUserId());
                updated = this.mPackageDexUsage.removeUserPackage(packageName, dexUseInfo.getOwnerUserId()) || updated;
                continue;
            }
            ApplicationInfo info = pkg.applicationInfo;
            int flags = 0;
            if (info.deviceProtectedDataDir != null && FileUtils.contains(info.deviceProtectedDataDir, dexPath)) {
                flags |= 1;
            } else if (info.credentialProtectedDataDir != null && FileUtils.contains(info.credentialProtectedDataDir, dexPath)) {
                flags |= 2;
            } else {
                Slog.e(TAG, "Could not infer CE/DE storage for path " + dexPath);
                updated = this.mPackageDexUsage.removeDexFile(packageName, dexPath, dexUseInfo.getOwnerUserId()) || updated;
                continue;
            }
            boolean dexStillExists = true;
            Object object = this.mInstallLock;
            synchronized (object) {
                try {
                    String[] isas = dexUseInfo.getLoaderIsas().toArray(new String[0]);
                    dexStillExists = this.mInstaller.reconcileSecondaryDexFile(dexPath, packageName, pkg.applicationInfo.uid, isas, pkg.applicationInfo.volumeUuid, flags);
                }
                catch (Installer.InstallerException e) {
                    Slog.e(TAG, "Got InstallerException when reconciling dex " + dexPath + " : " + e.getMessage());
                }
            }
            if (dexStillExists) continue;
            updated = this.mPackageDexUsage.removeDexFile(packageName, dexPath, dexUseInfo.getOwnerUserId()) || updated;
        }
        if (updated) {
            this.mPackageDexUsage.maybeWriteAsync();
        }
    }

    public Set<String> getAllPackagesWithSecondaryDexFiles() {
        return this.mPackageDexUsage.getAllPackagesWithSecondaryDexFiles();
    }

    public boolean isUsedByOtherApps(String packageName) {
        PackageDexUsage.PackageUseInfo useInfo = this.getPackageUseInfo(packageName);
        if (useInfo == null) {
            return false;
        }
        return useInfo.isUsedByOtherApps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexSearchResult getDexPackage(ApplicationInfo loadingAppInfo, String dexPath, int userId) {
        if (dexPath.startsWith("/system/framework/")) {
            return new DexSearchResult("framework", DEX_SEARCH_NOT_FOUND);
        }
        PackageCodeLocations loadingPackageCodeLocations = new PackageCodeLocations(loadingAppInfo, userId);
        int outcome = loadingPackageCodeLocations.searchDex(dexPath, userId);
        if (outcome != DEX_SEARCH_NOT_FOUND) {
            return new DexSearchResult(loadingPackageCodeLocations.mPackageName, outcome);
        }
        Map<String, PackageCodeLocations> map = this.mPackageCodeLocationsCache;
        synchronized (map) {
            for (PackageCodeLocations pcl : this.mPackageCodeLocationsCache.values()) {
                outcome = pcl.searchDex(dexPath, userId);
                if (outcome == DEX_SEARCH_NOT_FOUND) continue;
                return new DexSearchResult(pcl.mPackageName, outcome);
            }
        }
        return new DexSearchResult(null, DEX_SEARCH_NOT_FOUND);
    }

    private static <K, V> V putIfAbsent(Map<K, V> map, K key, V newValue) {
        V existingValue = map.putIfAbsent(key, newValue);
        return existingValue == null ? newValue : existingValue;
    }

    private class DexSearchResult {
        private String mOwningPackageName;
        private int mOutcome;

        public DexSearchResult(String owningPackageName, int outcome) {
            this.mOwningPackageName = owningPackageName;
            this.mOutcome = outcome;
        }

        public String toString() {
            return this.mOwningPackageName + "-" + this.mOutcome;
        }
    }

    private static class PackageCodeLocations {
        private final String mPackageName;
        private String mBaseCodePath;
        private final Set<String> mSplitCodePaths;
        private final Map<Integer, Set<String>> mAppDataDirs;

        public PackageCodeLocations(ApplicationInfo ai, int userId) {
            this(ai.packageName, ai.sourceDir, ai.splitSourceDirs);
            this.mergeAppDataDirs(ai.dataDir, userId);
        }

        public PackageCodeLocations(String packageName, String baseCodePath, String[] splitCodePaths) {
            this.mPackageName = packageName;
            this.mSplitCodePaths = new HashSet<String>();
            this.mAppDataDirs = new HashMap<Integer, Set<String>>();
            this.updateCodeLocation(baseCodePath, splitCodePaths);
        }

        public void updateCodeLocation(String baseCodePath, String[] splitCodePaths) {
            this.mBaseCodePath = baseCodePath;
            this.mSplitCodePaths.clear();
            if (splitCodePaths != null) {
                for (String split : splitCodePaths) {
                    this.mSplitCodePaths.add(split);
                }
            }
        }

        public void mergeAppDataDirs(String dataDir, int userId) {
            Set dataDirs = (Set)DexManager.putIfAbsent(this.mAppDataDirs, userId, new HashSet());
            dataDirs.add(dataDir);
        }

        public int searchDex(String dexPath, int userId) {
            Set<String> userDataDirs = this.mAppDataDirs.get(userId);
            if (userDataDirs == null) {
                return DEX_SEARCH_NOT_FOUND;
            }
            if (this.mBaseCodePath.equals(dexPath)) {
                return DEX_SEARCH_FOUND_PRIMARY;
            }
            if (this.mSplitCodePaths.contains(dexPath)) {
                return DEX_SEARCH_FOUND_SPLIT;
            }
            for (String dataDir : userDataDirs) {
                if (!dexPath.startsWith(dataDir)) continue;
                return DEX_SEARCH_FOUND_SECONDARY;
            }
            return DEX_SEARCH_NOT_FOUND;
        }
    }
}

