/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.app.ActivityManager;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.dreams.IDreamManager;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerPolicy;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.AlertController;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.EmergencyAffordanceManager;
import com.android.internal.widget.LockPatternUtils;
import java.util.ArrayList;
import java.util.List;

class LegacyGlobalActions
implements DialogInterface.OnDismissListener,
DialogInterface.OnClickListener {
    private static final String TAG = "LegacyGlobalActions";
    private static final boolean SHOW_SILENT_TOGGLE = true;
    private static final String GLOBAL_ACTION_KEY_POWER = "power";
    private static final String GLOBAL_ACTION_KEY_AIRPLANE = "airplane";
    private static final String GLOBAL_ACTION_KEY_BUGREPORT = "bugreport";
    private static final String GLOBAL_ACTION_KEY_SILENT = "silent";
    private static final String GLOBAL_ACTION_KEY_USERS = "users";
    private static final String GLOBAL_ACTION_KEY_SETTINGS = "settings";
    private static final String GLOBAL_ACTION_KEY_LOCKDOWN = "lockdown";
    private static final String GLOBAL_ACTION_KEY_VOICEASSIST = "voiceassist";
    private static final String GLOBAL_ACTION_KEY_ASSIST = "assist";
    private static final String GLOBAL_ACTION_KEY_RESTART = "restart";
    private final Context mContext;
    private final WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    private final AudioManager mAudioManager;
    private final IDreamManager mDreamManager;
    private final Runnable mOnDismiss;
    private ArrayList<Action> mItems;
    private GlobalActionsDialog mDialog;
    private Action mSilentModeAction;
    private ToggleAction mAirplaneModeOn;
    private MyAdapter mAdapter;
    private boolean mKeyguardShowing = false;
    private boolean mDeviceProvisioned = false;
    private ToggleAction.State mAirplaneState = ToggleAction.State.Off;
    private boolean mIsWaitingForEcmExit = false;
    private boolean mHasTelephony;
    private boolean mHasVibrator;
    private final boolean mShowSilentToggle;
    private final EmergencyAffordanceManager mEmergencyAffordanceManager;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) || "android.intent.action.SCREEN_OFF".equals(action)) {
                String reason = intent.getStringExtra("reason");
                if (!"globalactions".equals(reason)) {
                    LegacyGlobalActions.this.mHandler.sendEmptyMessage(0);
                }
            } else if ("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED".equals(action) && !intent.getBooleanExtra("PHONE_IN_ECM_STATE", false) && LegacyGlobalActions.this.mIsWaitingForEcmExit) {
                LegacyGlobalActions.this.mIsWaitingForEcmExit = false;
                LegacyGlobalActions.this.changeAirplaneModeSystemSetting(true);
            }
        }
    };
    PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        @Override
        public void onServiceStateChanged(ServiceState serviceState) {
            if (!LegacyGlobalActions.this.mHasTelephony) {
                return;
            }
            boolean inAirplaneMode = serviceState.getState() == 3;
            LegacyGlobalActions.this.mAirplaneState = inAirplaneMode ? ToggleAction.State.On : ToggleAction.State.Off;
            LegacyGlobalActions.this.mAirplaneModeOn.updateState(LegacyGlobalActions.this.mAirplaneState);
            LegacyGlobalActions.this.mAdapter.notifyDataSetChanged();
        }
    };
    private BroadcastReceiver mRingerModeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.media.RINGER_MODE_CHANGED")) {
                LegacyGlobalActions.this.mHandler.sendEmptyMessage(1);
            }
        }
    };
    private ContentObserver mAirplaneModeObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            LegacyGlobalActions.this.onAirplaneModeChanged();
        }
    };
    private static final int MESSAGE_DISMISS = 0;
    private static final int MESSAGE_REFRESH = 1;
    private static final int MESSAGE_SHOW = 2;
    private static final int DIALOG_DISMISS_DELAY = 300;
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (LegacyGlobalActions.this.mDialog == null) break;
                    LegacyGlobalActions.this.mDialog.dismiss();
                    LegacyGlobalActions.this.mDialog = null;
                    break;
                }
                case 1: {
                    LegacyGlobalActions.this.refreshSilentMode();
                    LegacyGlobalActions.this.mAdapter.notifyDataSetChanged();
                    break;
                }
                case 2: {
                    LegacyGlobalActions.this.handleShow();
                }
            }
        }
    };

    public LegacyGlobalActions(Context context, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs, Runnable onDismiss) {
        this.mContext = context;
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mOnDismiss = onDismiss;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mDreamManager = IDreamManager.Stub.asInterface(ServiceManager.getService("dreams"));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        context.registerReceiver(this.mBroadcastReceiver, filter);
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.mHasTelephony = cm.isNetworkSupported(0);
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        telephonyManager.listen(this.mPhoneStateListener, 1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("airplane_mode_on"), true, this.mAirplaneModeObserver);
        Vibrator vibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        this.mHasVibrator = vibrator != null && vibrator.hasVibrator();
        this.mShowSilentToggle = !this.mContext.getResources().getBoolean(17957032);
        this.mEmergencyAffordanceManager = new EmergencyAffordanceManager(context);
    }

    public void showDialog(boolean keyguardShowing, boolean isDeviceProvisioned) {
        this.mKeyguardShowing = keyguardShowing;
        this.mDeviceProvisioned = isDeviceProvisioned;
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
            this.mHandler.sendEmptyMessage(2);
        } else {
            this.handleShow();
        }
    }

    private void awakenIfNecessary() {
        if (this.mDreamManager != null) {
            try {
                if (this.mDreamManager.isDreaming()) {
                    this.mDreamManager.awaken();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void handleShow() {
        this.awakenIfNecessary();
        this.mDialog = this.createDialog();
        this.prepareDialog();
        if (this.mAdapter.getCount() == 1 && this.mAdapter.getItem(0) instanceof SinglePressAction && !(this.mAdapter.getItem(0) instanceof LongPressAction)) {
            ((SinglePressAction)this.mAdapter.getItem(0)).onPress();
        } else {
            WindowManager.LayoutParams attrs = this.mDialog.getWindow().getAttributes();
            attrs.setTitle(TAG);
            this.mDialog.getWindow().setAttributes(attrs);
            this.mDialog.show();
            this.mDialog.getWindow().getDecorView().setSystemUiVisibility(65536);
        }
    }

    private GlobalActionsDialog createDialog() {
        this.mSilentModeAction = !this.mHasVibrator ? new SilentModeToggleAction() : new SilentModeTriStateAction(this.mContext, this.mAudioManager, this.mHandler);
        this.mAirplaneModeOn = new ToggleAction(17302396, 17302398, 17039923, 17039922, 17039921){

            @Override
            void onToggle(boolean on) {
                if (LegacyGlobalActions.this.mHasTelephony && Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"))) {
                    LegacyGlobalActions.this.mIsWaitingForEcmExit = true;
                    Intent ecmDialogIntent = new Intent("com.android.internal.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS", null);
                    ecmDialogIntent.addFlags(0x10000000);
                    LegacyGlobalActions.this.mContext.startActivity(ecmDialogIntent);
                } else {
                    LegacyGlobalActions.this.changeAirplaneModeSystemSetting(on);
                }
            }

            @Override
            protected void changeStateFromPress(boolean buttonOn) {
                if (!LegacyGlobalActions.this.mHasTelephony) {
                    return;
                }
                if (!Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"))) {
                    this.mState = buttonOn ? ToggleAction.State.TurningOn : ToggleAction.State.TurningOff;
                    LegacyGlobalActions.this.mAirplaneState = this.mState;
                }
            }

            @Override
            public boolean showDuringKeyguard() {
                return true;
            }

            @Override
            public boolean showBeforeProvisioning() {
                return false;
            }
        };
        this.onAirplaneModeChanged();
        this.mItems = new ArrayList();
        String[] defaultActions = this.mContext.getResources().getStringArray(17236006);
        ArraySet<String> addedKeys = new ArraySet<String>();
        for (int i = 0; i < defaultActions.length; ++i) {
            String actionKey = defaultActions[i];
            if (addedKeys.contains(actionKey)) continue;
            if (GLOBAL_ACTION_KEY_POWER.equals(actionKey)) {
                this.mItems.add(new PowerAction());
            } else if (GLOBAL_ACTION_KEY_AIRPLANE.equals(actionKey)) {
                this.mItems.add(this.mAirplaneModeOn);
            } else if (GLOBAL_ACTION_KEY_BUGREPORT.equals(actionKey)) {
                if (Settings.Global.getInt(this.mContext.getContentResolver(), "bugreport_in_power_menu", 0) != 0 && this.isCurrentUserOwner()) {
                    this.mItems.add(new BugReportAction());
                }
            } else if (GLOBAL_ACTION_KEY_SILENT.equals(actionKey)) {
                if (this.mShowSilentToggle) {
                    this.mItems.add(this.mSilentModeAction);
                }
            } else if (GLOBAL_ACTION_KEY_USERS.equals(actionKey)) {
                if (SystemProperties.getBoolean("fw.power_user_switcher", false)) {
                    this.addUsersToMenu(this.mItems);
                }
            } else if (GLOBAL_ACTION_KEY_SETTINGS.equals(actionKey)) {
                this.mItems.add(this.getSettingsAction());
            } else if (GLOBAL_ACTION_KEY_LOCKDOWN.equals(actionKey)) {
                this.mItems.add(this.getLockdownAction());
            } else if (GLOBAL_ACTION_KEY_VOICEASSIST.equals(actionKey)) {
                this.mItems.add(this.getVoiceAssistAction());
            } else if (GLOBAL_ACTION_KEY_ASSIST.equals(actionKey)) {
                this.mItems.add(this.getAssistAction());
            } else if (GLOBAL_ACTION_KEY_RESTART.equals(actionKey)) {
                this.mItems.add(new RestartAction());
            } else {
                Log.e(TAG, "Invalid global action key " + actionKey);
            }
            addedKeys.add(actionKey);
        }
        if (this.mEmergencyAffordanceManager.needsEmergencyAffordance()) {
            this.mItems.add(this.getEmergencyAction());
        }
        this.mAdapter = new MyAdapter();
        AlertController.AlertParams params = new AlertController.AlertParams(this.mContext);
        params.mAdapter = this.mAdapter;
        params.mOnClickListener = this;
        params.mForceInverseBackground = true;
        GlobalActionsDialog dialog = new GlobalActionsDialog(this.mContext, params);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getListView().setItemsCanFocus(true);
        dialog.getListView().setLongClickable(true);
        dialog.getListView().setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            @Override
            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                Action action = LegacyGlobalActions.this.mAdapter.getItem(position);
                if (action instanceof LongPressAction) {
                    return ((LongPressAction)action).onLongPress();
                }
                return false;
            }
        });
        dialog.getWindow().setType(2009);
        dialog.setOnDismissListener(this);
        return dialog;
    }

    private Action getSettingsAction() {
        return new SinglePressAction(17302596, 17039915){

            @Override
            public void onPress() {
                Intent intent = new Intent("android.settings.SETTINGS");
                intent.addFlags(0x14000000);
                LegacyGlobalActions.this.mContext.startActivity(intent);
            }

            @Override
            public boolean showDuringKeyguard() {
                return true;
            }

            @Override
            public boolean showBeforeProvisioning() {
                return true;
            }
        };
    }

    private Action getEmergencyAction() {
        return new SinglePressAction(17302177, 17039910){

            @Override
            public void onPress() {
                LegacyGlobalActions.this.mEmergencyAffordanceManager.performEmergencyCall();
            }

            @Override
            public boolean showDuringKeyguard() {
                return true;
            }

            @Override
            public boolean showBeforeProvisioning() {
                return true;
            }
        };
    }

    private Action getAssistAction() {
        return new SinglePressAction(17302256, 17039908){

            @Override
            public void onPress() {
                Intent intent = new Intent("android.intent.action.ASSIST");
                intent.addFlags(0x14000000);
                LegacyGlobalActions.this.mContext.startActivity(intent);
            }

            @Override
            public boolean showDuringKeyguard() {
                return true;
            }

            @Override
            public boolean showBeforeProvisioning() {
                return true;
            }
        };
    }

    private Action getVoiceAssistAction() {
        return new SinglePressAction(17302626, 17039919){

            @Override
            public void onPress() {
                Intent intent = new Intent("android.intent.action.VOICE_ASSIST");
                intent.addFlags(0x14000000);
                LegacyGlobalActions.this.mContext.startActivity(intent);
            }

            @Override
            public boolean showDuringKeyguard() {
                return true;
            }

            @Override
            public boolean showBeforeProvisioning() {
                return true;
            }
        };
    }

    private Action getLockdownAction() {
        return new SinglePressAction(17301551, 17039912){

            @Override
            public void onPress() {
                new LockPatternUtils(LegacyGlobalActions.this.mContext).requireCredentialEntry(-1);
                try {
                    WindowManagerGlobal.getWindowManagerService().lockNow(null);
                }
                catch (RemoteException e) {
                    Log.e(LegacyGlobalActions.TAG, "Error while trying to lock device.", e);
                }
            }

            @Override
            public boolean showDuringKeyguard() {
                return true;
            }

            @Override
            public boolean showBeforeProvisioning() {
                return false;
            }
        };
    }

    private UserInfo getCurrentUser() {
        try {
            return ActivityManager.getService().getCurrentUser();
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private boolean isCurrentUserOwner() {
        UserInfo currentUser = this.getCurrentUser();
        return currentUser == null || currentUser.isPrimary();
    }

    private void addUsersToMenu(ArrayList<Action> items) {
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        if (um.isUserSwitcherEnabled()) {
            List<UserInfo> users = um.getUsers();
            UserInfo currentUser = this.getCurrentUser();
            for (final UserInfo user : users) {
                if (!user.supportsSwitchToByUser()) continue;
                boolean isCurrentUser = currentUser == null ? user.id == 0 : currentUser.id == user.id;
                Drawable icon = user.iconPath != null ? Drawable.createFromPath(user.iconPath) : null;
                SinglePressAction switchToUser = new SinglePressAction(17302488, icon, (user.name != null ? user.name : "Primary") + (isCurrentUser ? " \u2714" : "")){

                    @Override
                    public void onPress() {
                        try {
                            ActivityManager.getService().switchUser(user.id);
                        }
                        catch (RemoteException re) {
                            Log.e(LegacyGlobalActions.TAG, "Couldn't switch user " + re);
                        }
                    }

                    @Override
                    public boolean showDuringKeyguard() {
                        return true;
                    }

                    @Override
                    public boolean showBeforeProvisioning() {
                        return false;
                    }
                };
                items.add(switchToUser);
            }
        }
    }

    private void prepareDialog() {
        this.refreshSilentMode();
        this.mAirplaneModeOn.updateState(this.mAirplaneState);
        this.mAdapter.notifyDataSetChanged();
        this.mDialog.getWindow().setType(2009);
        if (this.mShowSilentToggle) {
            IntentFilter filter = new IntentFilter("android.media.RINGER_MODE_CHANGED");
            this.mContext.registerReceiver(this.mRingerModeReceiver, filter);
        }
    }

    private void refreshSilentMode() {
        if (!this.mHasVibrator) {
            boolean silentModeOn = this.mAudioManager.getRingerMode() != 2;
            ((ToggleAction)this.mSilentModeAction).updateState(silentModeOn ? ToggleAction.State.On : ToggleAction.State.Off);
        }
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        if (this.mOnDismiss != null) {
            this.mOnDismiss.run();
        }
        if (this.mShowSilentToggle) {
            try {
                this.mContext.unregisterReceiver(this.mRingerModeReceiver);
            }
            catch (IllegalArgumentException ie) {
                Log.w(TAG, ie);
            }
        }
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (!(this.mAdapter.getItem(which) instanceof SilentModeTriStateAction)) {
            dialog.dismiss();
        }
        this.mAdapter.getItem(which).onPress();
    }

    private void onAirplaneModeChanged() {
        if (this.mHasTelephony) {
            return;
        }
        boolean airplaneModeOn = Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
        this.mAirplaneState = airplaneModeOn ? ToggleAction.State.On : ToggleAction.State.Off;
        this.mAirplaneModeOn.updateState(this.mAirplaneState);
    }

    private void changeAirplaneModeSystemSetting(boolean on) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "airplane_mode_on", on ? 1 : 0);
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.addFlags(0x20000000);
        intent.putExtra("state", on);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        if (!this.mHasTelephony) {
            this.mAirplaneState = on ? ToggleAction.State.On : ToggleAction.State.Off;
        }
    }

    private static final class GlobalActionsDialog
    extends Dialog
    implements DialogInterface {
        private final Context mContext = this.getContext();
        private final AlertController mAlert = AlertController.create(this.mContext, this, this.getWindow());
        private final MyAdapter mAdapter;

        public GlobalActionsDialog(Context context, AlertController.AlertParams params) {
            super(context, GlobalActionsDialog.getDialogTheme(context));
            this.mAdapter = (MyAdapter)params.mAdapter;
            params.apply(this.mAlert);
        }

        private static int getDialogTheme(Context context) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(16843529, outValue, true);
            return outValue.resourceId;
        }

        @Override
        protected void onStart() {
            super.setCanceledOnTouchOutside(true);
            super.onStart();
        }

        public ListView getListView() {
            return this.mAlert.getListView();
        }

        @Override
        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.mAlert.installContent();
        }

        @Override
        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
            if (event.getEventType() == 32) {
                for (int i = 0; i < this.mAdapter.getCount(); ++i) {
                    CharSequence label = this.mAdapter.getItem(i).getLabelForAccessibility(this.getContext());
                    if (label == null) continue;
                    event.getText().add(label);
                }
            }
            return super.dispatchPopulateAccessibilityEvent(event);
        }

        @Override
        public boolean onKeyDown(int keyCode, KeyEvent event) {
            if (this.mAlert.onKeyDown(keyCode, event)) {
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }

        @Override
        public boolean onKeyUp(int keyCode, KeyEvent event) {
            if (this.mAlert.onKeyUp(keyCode, event)) {
                return true;
            }
            return super.onKeyUp(keyCode, event);
        }
    }

    private static class SilentModeTriStateAction
    implements Action,
    View.OnClickListener {
        private final int[] ITEM_IDS = new int[]{16909115, 16909116, 16909117};
        private final AudioManager mAudioManager;
        private final Handler mHandler;
        private final Context mContext;

        SilentModeTriStateAction(Context context, AudioManager audioManager, Handler handler) {
            this.mAudioManager = audioManager;
            this.mHandler = handler;
            this.mContext = context;
        }

        private int ringerModeToIndex(int ringerMode) {
            return ringerMode;
        }

        private int indexToRingerMode(int index) {
            return index;
        }

        @Override
        public CharSequence getLabelForAccessibility(Context context) {
            return null;
        }

        @Override
        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367143, parent, false);
            int selectedIndex = this.ringerModeToIndex(this.mAudioManager.getRingerMode());
            for (int i = 0; i < 3; ++i) {
                Object itemView = v.findViewById(this.ITEM_IDS[i]);
                ((View)itemView).setSelected(selectedIndex == i);
                ((View)itemView).setTag(i);
                ((View)itemView).setOnClickListener(this);
            }
            return v;
        }

        @Override
        public void onPress() {
        }

        @Override
        public boolean showDuringKeyguard() {
            return true;
        }

        @Override
        public boolean showBeforeProvisioning() {
            return false;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        void willCreate() {
        }

        @Override
        public void onClick(View v) {
            if (!(v.getTag() instanceof Integer)) {
                return;
            }
            int index = (Integer)v.getTag();
            this.mAudioManager.setRingerMode(this.indexToRingerMode(index));
            this.mHandler.sendEmptyMessageDelayed(0, 300L);
        }
    }

    private class SilentModeToggleAction
    extends ToggleAction {
        public SilentModeToggleAction() {
            super(17302271, 17302270, 17039918, 17039917, 17039916);
        }

        @Override
        void onToggle(boolean on) {
            if (on) {
                LegacyGlobalActions.this.mAudioManager.setRingerMode(0);
            } else {
                LegacyGlobalActions.this.mAudioManager.setRingerMode(2);
            }
        }

        @Override
        public boolean showDuringKeyguard() {
            return true;
        }

        @Override
        public boolean showBeforeProvisioning() {
            return false;
        }
    }

    private static abstract class ToggleAction
    implements Action {
        protected State mState = State.Off;
        protected int mEnabledIconResId;
        protected int mDisabledIconResid;
        protected int mMessageResId;
        protected int mEnabledStatusMessageResId;
        protected int mDisabledStatusMessageResId;

        public ToggleAction(int enabledIconResId, int disabledIconResid, int message, int enabledStatusMessageResId, int disabledStatusMessageResId) {
            this.mEnabledIconResId = enabledIconResId;
            this.mDisabledIconResid = disabledIconResid;
            this.mMessageResId = message;
            this.mEnabledStatusMessageResId = enabledStatusMessageResId;
            this.mDisabledStatusMessageResId = disabledStatusMessageResId;
        }

        void willCreate() {
        }

        @Override
        public CharSequence getLabelForAccessibility(Context context) {
            return context.getString(this.mMessageResId);
        }

        @Override
        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            boolean on;
            this.willCreate();
            View v = inflater.inflate(17367142, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            TextView statusView = (TextView)v.findViewById(16909311);
            boolean enabled = this.isEnabled();
            if (messageView != null) {
                messageView.setText(this.mMessageResId);
                messageView.setEnabled(enabled);
            }
            boolean bl = on = this.mState == State.On || this.mState == State.TurningOn;
            if (icon != null) {
                icon.setImageDrawable(context.getDrawable(on ? this.mEnabledIconResId : this.mDisabledIconResid));
                icon.setEnabled(enabled);
            }
            if (statusView != null) {
                statusView.setText(on ? this.mEnabledStatusMessageResId : this.mDisabledStatusMessageResId);
                statusView.setVisibility(0);
                statusView.setEnabled(enabled);
            }
            v.setEnabled(enabled);
            return v;
        }

        @Override
        public final void onPress() {
            if (this.mState.inTransition()) {
                Log.w(LegacyGlobalActions.TAG, "shouldn't be able to toggle when in transition");
                return;
            }
            boolean nowOn = this.mState != State.On;
            this.onToggle(nowOn);
            this.changeStateFromPress(nowOn);
        }

        @Override
        public boolean isEnabled() {
            return !this.mState.inTransition();
        }

        protected void changeStateFromPress(boolean buttonOn) {
            this.mState = buttonOn ? State.On : State.Off;
        }

        abstract void onToggle(boolean var1);

        public void updateState(State state) {
            this.mState = state;
        }

        static enum State {
            Off(false),
            TurningOn(true),
            TurningOff(true),
            On(false);

            private final boolean inTransition;

            private State(boolean intermediate) {
                this.inTransition = intermediate;
            }

            public boolean inTransition() {
                return this.inTransition;
            }
        }
    }

    private static abstract class SinglePressAction
    implements Action {
        private final int mIconResId;
        private final Drawable mIcon;
        private final int mMessageResId;
        private final CharSequence mMessage;

        protected SinglePressAction(int iconResId, int messageResId) {
            this.mIconResId = iconResId;
            this.mMessageResId = messageResId;
            this.mMessage = null;
            this.mIcon = null;
        }

        protected SinglePressAction(int iconResId, Drawable icon, CharSequence message) {
            this.mIconResId = iconResId;
            this.mMessageResId = 0;
            this.mMessage = message;
            this.mIcon = icon;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        public String getStatus() {
            return null;
        }

        @Override
        public abstract void onPress();

        @Override
        public CharSequence getLabelForAccessibility(Context context) {
            if (this.mMessage != null) {
                return this.mMessage;
            }
            return context.getString(this.mMessageResId);
        }

        @Override
        public View create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367142, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            TextView statusView = (TextView)v.findViewById(16909311);
            String status = this.getStatus();
            if (!TextUtils.isEmpty(status)) {
                statusView.setText(status);
            } else {
                statusView.setVisibility(8);
            }
            if (this.mIcon != null) {
                icon.setImageDrawable(this.mIcon);
                icon.setScaleType(ImageView.ScaleType.CENTER_CROP);
            } else if (this.mIconResId != 0) {
                icon.setImageDrawable(context.getDrawable(this.mIconResId));
            }
            if (this.mMessage != null) {
                messageView.setText(this.mMessage);
            } else {
                messageView.setText(this.mMessageResId);
            }
            return v;
        }
    }

    private static interface LongPressAction
    extends Action {
        public boolean onLongPress();
    }

    private static interface Action {
        public CharSequence getLabelForAccessibility(Context var1);

        public View create(Context var1, View var2, ViewGroup var3, LayoutInflater var4);

        public void onPress();

        public boolean showDuringKeyguard();

        public boolean showBeforeProvisioning();

        public boolean isEnabled();
    }

    private class MyAdapter
    extends BaseAdapter {
        private MyAdapter() {
        }

        @Override
        public int getCount() {
            int count = 0;
            for (int i = 0; i < LegacyGlobalActions.this.mItems.size(); ++i) {
                Action action = (Action)LegacyGlobalActions.this.mItems.get(i);
                if (LegacyGlobalActions.this.mKeyguardShowing && !action.showDuringKeyguard() || !LegacyGlobalActions.this.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean isEnabled(int position) {
            return this.getItem(position).isEnabled();
        }

        @Override
        public boolean areAllItemsEnabled() {
            return false;
        }

        @Override
        public Action getItem(int position) {
            int filteredPos = 0;
            for (int i = 0; i < LegacyGlobalActions.this.mItems.size(); ++i) {
                Action action = (Action)LegacyGlobalActions.this.mItems.get(i);
                if (LegacyGlobalActions.this.mKeyguardShowing && !action.showDuringKeyguard() || !LegacyGlobalActions.this.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                if (filteredPos == position) {
                    return action;
                }
                ++filteredPos;
            }
            throw new IllegalArgumentException("position " + position + " out of range of showable actions" + ", filtered count=" + this.getCount() + ", keyguardshowing=" + LegacyGlobalActions.this.mKeyguardShowing + ", provisioned=" + LegacyGlobalActions.this.mDeviceProvisioned);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            Action action = this.getItem(position);
            return action.create(LegacyGlobalActions.this.mContext, convertView, parent, LayoutInflater.from(LegacyGlobalActions.this.mContext));
        }
    }

    private class BugReportAction
    extends SinglePressAction
    implements LongPressAction {
        public BugReportAction() {
            super(17302400, 17039578);
        }

        @Override
        public void onPress() {
            if (ActivityManager.isUserAMonkey()) {
                return;
            }
            LegacyGlobalActions.this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        MetricsLogger.action(LegacyGlobalActions.this.mContext, 292);
                        ActivityManager.getService().requestBugReport(1);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }, 500L);
        }

        @Override
        public boolean onLongPress() {
            if (ActivityManager.isUserAMonkey()) {
                return false;
            }
            try {
                MetricsLogger.action(LegacyGlobalActions.this.mContext, 293);
                ActivityManager.getService().requestBugReport(0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public boolean showDuringKeyguard() {
            return true;
        }

        @Override
        public boolean showBeforeProvisioning() {
            return false;
        }

        @Override
        public String getStatus() {
            return LegacyGlobalActions.this.mContext.getString(17039577, Build.VERSION.RELEASE, Build.ID);
        }
    }

    private final class RestartAction
    extends SinglePressAction
    implements LongPressAction {
        private RestartAction() {
            super(17302589, 17039914);
        }

        @Override
        public boolean onLongPress() {
            UserManager um = (UserManager)LegacyGlobalActions.this.mContext.getSystemService("user");
            if (!um.hasUserRestriction("no_safe_boot")) {
                LegacyGlobalActions.this.mWindowManagerFuncs.rebootSafeMode(true);
                return true;
            }
            return false;
        }

        @Override
        public boolean showDuringKeyguard() {
            return true;
        }

        @Override
        public boolean showBeforeProvisioning() {
            return true;
        }

        @Override
        public void onPress() {
            LegacyGlobalActions.this.mWindowManagerFuncs.reboot(false);
        }
    }

    private final class PowerAction
    extends SinglePressAction
    implements LongPressAction {
        private PowerAction() {
            super(17301552, 17039913);
        }

        @Override
        public boolean onLongPress() {
            UserManager um = (UserManager)LegacyGlobalActions.this.mContext.getSystemService("user");
            if (!um.hasUserRestriction("no_safe_boot")) {
                LegacyGlobalActions.this.mWindowManagerFuncs.rebootSafeMode(true);
                return true;
            }
            return false;
        }

        @Override
        public boolean showDuringKeyguard() {
            return true;
        }

        @Override
        public boolean showBeforeProvisioning() {
            return true;
        }

        @Override
        public void onPress() {
            LegacyGlobalActions.this.mWindowManagerFuncs.shutdown(false);
        }
    }
}

