/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.Binder;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.SystemService;
import com.android.server.usb.UsbAlsaManager;
import com.android.server.usb.UsbDeviceManager;
import com.android.server.usb.UsbHostManager;
import com.android.server.usb.UsbPortManager;
import com.android.server.usb.UsbProfileGroupSettingsManager;
import com.android.server.usb.UsbSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;

public class UsbService
extends IUsbManager.Stub {
    private static final String TAG = "UsbService";
    private final Context mContext;
    private final UserManager mUserManager;
    private UsbDeviceManager mDeviceManager;
    private UsbHostManager mHostManager;
    private UsbPortManager mPortManager;
    private final UsbAlsaManager mAlsaManager;
    private final UsbSettingsManager mSettingsManager;
    @GuardedBy(value="mLock")
    private int mCurrentUserId;
    private final Object mLock = new Object();
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED".equals(action) && UsbService.this.mDeviceManager != null) {
                UsbService.this.mDeviceManager.updateUserRestrictions();
            }
        }
    };

    private UsbUserSettingsManager getSettingsForUser(int userIdInt) {
        return this.mSettingsManager.getSettingsForUser(userIdInt);
    }

    public UsbService(Context context) {
        this.mContext = context;
        this.mUserManager = context.getSystemService(UserManager.class);
        this.mSettingsManager = new UsbSettingsManager(context);
        this.mAlsaManager = new UsbAlsaManager(context);
        PackageManager pm = this.mContext.getPackageManager();
        if (pm.hasSystemFeature("android.hardware.usb.host")) {
            this.mHostManager = new UsbHostManager(context, this.mAlsaManager, this.mSettingsManager);
        }
        if (new File("/sys/class/android_usb").exists()) {
            this.mDeviceManager = new UsbDeviceManager(context, this.mAlsaManager, this.mSettingsManager);
        }
        if (this.mHostManager != null || this.mDeviceManager != null) {
            this.mPortManager = new UsbPortManager(context);
        }
        this.onSwitchUser(0);
        IntentFilter filter = new IntentFilter();
        filter.setPriority(1000);
        filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, filter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSwitchUser(int newUserId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentUserId = newUserId;
            UsbProfileGroupSettingsManager settings = this.mSettingsManager.getSettingsForProfileGroup(UserHandle.of(newUserId));
            if (this.mHostManager != null) {
                this.mHostManager.setCurrentUserSettings(settings);
            }
            if (this.mDeviceManager != null) {
                this.mDeviceManager.setCurrentUser(newUserId, settings);
            }
        }
    }

    private void onStopUser(UserHandle stoppedUser) {
        this.mSettingsManager.remove(stoppedUser);
    }

    public void systemReady() {
        this.mAlsaManager.systemReady();
        if (this.mDeviceManager != null) {
            this.mDeviceManager.systemReady();
        }
        if (this.mHostManager != null) {
            this.mHostManager.systemReady();
        }
        if (this.mPortManager != null) {
            this.mPortManager.systemReady();
        }
    }

    public void bootCompleted() {
        if (this.mDeviceManager != null) {
            this.mDeviceManager.bootCompleted();
        }
    }

    @Override
    public void getDeviceList(Bundle devices) {
        if (this.mHostManager != null) {
            this.mHostManager.getDeviceList(devices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCallerInCurrentUserProfileGroupLocked() {
        int userIdInt = UserHandle.getCallingUserId();
        long ident = UsbService.clearCallingIdentity();
        try {
            boolean bl = this.mUserManager.isSameProfileGroup(userIdInt, this.mCurrentUserId);
            return bl;
        }
        finally {
            UsbService.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openDevice(String deviceName) {
        ParcelFileDescriptor fd = null;
        if (this.mHostManager != null) {
            Object object = this.mLock;
            synchronized (object) {
                if (deviceName != null) {
                    int userIdInt = UserHandle.getCallingUserId();
                    boolean isCurrentUser = this.isCallerInCurrentUserProfileGroupLocked();
                    if (isCurrentUser) {
                        fd = this.mHostManager.openDevice(deviceName, this.getSettingsForUser(userIdInt));
                    } else {
                        Slog.w(TAG, "Cannot open " + deviceName + " for user " + userIdInt + " as user is not active.");
                    }
                }
            }
        }
        return fd;
    }

    @Override
    public UsbAccessory getCurrentAccessory() {
        if (this.mDeviceManager != null) {
            return this.mDeviceManager.getCurrentAccessory();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        if (this.mDeviceManager != null) {
            int userIdInt = UserHandle.getCallingUserId();
            Object object = this.mLock;
            synchronized (object) {
                boolean isCurrentUser = this.isCallerInCurrentUserProfileGroupLocked();
                if (isCurrentUser) {
                    return this.mDeviceManager.openAccessory(accessory, this.getSettingsForUser(userIdInt));
                }
                Slog.w(TAG, "Cannot open " + accessory + " for user " + userIdInt + " as user is not active.");
            }
        }
        return null;
    }

    @Override
    public void setDevicePackage(UsbDevice device, String packageName, int userId) {
        device = Preconditions.checkNotNull(device);
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        UserHandle user = UserHandle.of(userId);
        this.mSettingsManager.getSettingsForProfileGroup(user).setDevicePackage(device, packageName, user);
    }

    @Override
    public void setAccessoryPackage(UsbAccessory accessory, String packageName, int userId) {
        accessory = Preconditions.checkNotNull(accessory);
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        UserHandle user = UserHandle.of(userId);
        this.mSettingsManager.getSettingsForProfileGroup(user).setAccessoryPackage(accessory, packageName, user);
    }

    @Override
    public boolean hasDevicePermission(UsbDevice device) {
        int userId = UserHandle.getCallingUserId();
        return this.getSettingsForUser(userId).hasPermission(device);
    }

    @Override
    public boolean hasAccessoryPermission(UsbAccessory accessory) {
        int userId = UserHandle.getCallingUserId();
        return this.getSettingsForUser(userId).hasPermission(accessory);
    }

    @Override
    public void requestDevicePermission(UsbDevice device, String packageName, PendingIntent pi) {
        int userId = UserHandle.getCallingUserId();
        this.getSettingsForUser(userId).requestPermission(device, packageName, pi);
    }

    @Override
    public void requestAccessoryPermission(UsbAccessory accessory, String packageName, PendingIntent pi) {
        int userId = UserHandle.getCallingUserId();
        this.getSettingsForUser(userId).requestPermission(accessory, packageName, pi);
    }

    @Override
    public void grantDevicePermission(UsbDevice device, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        int userId = UserHandle.getUserId(uid);
        this.getSettingsForUser(userId).grantDevicePermission(device, uid);
    }

    @Override
    public void grantAccessoryPermission(UsbAccessory accessory, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        int userId = UserHandle.getUserId(uid);
        this.getSettingsForUser(userId).grantAccessoryPermission(accessory, uid);
    }

    @Override
    public boolean hasDefaults(String packageName, int userId) {
        packageName = Preconditions.checkStringNotEmpty(packageName);
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        UserHandle user = UserHandle.of(userId);
        return this.mSettingsManager.getSettingsForProfileGroup(user).hasDefaults(packageName, user);
    }

    @Override
    public void clearDefaults(String packageName, int userId) {
        packageName = Preconditions.checkStringNotEmpty(packageName);
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        UserHandle user = UserHandle.of(userId);
        this.mSettingsManager.getSettingsForProfileGroup(user).clearDefaults(packageName, user);
    }

    @Override
    public boolean isFunctionEnabled(String function) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        return this.mDeviceManager != null && this.mDeviceManager.isFunctionEnabled(function);
    }

    @Override
    public void setCurrentFunction(String function, boolean usbDataUnlocked) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        if (!UsbService.isSupportedCurrentFunction(function)) {
            Slog.w(TAG, "Caller of setCurrentFunction() requested unsupported USB function: " + function);
            function = "none";
        }
        if (this.mDeviceManager == null) {
            throw new IllegalStateException("USB device mode not supported");
        }
        this.mDeviceManager.setCurrentFunctions(function, usbDataUnlocked);
    }

    private static boolean isSupportedCurrentFunction(String function) {
        if (function == null) {
            return true;
        }
        switch (function) {
            case "none": 
            case "audio_source": 
            case "midi": 
            case "mtp": 
            case "ptp": 
            case "rndis": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void allowUsbDebugging(boolean alwaysAllow, String publicKey) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mDeviceManager.allowUsbDebugging(alwaysAllow, publicKey);
    }

    @Override
    public void denyUsbDebugging() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mDeviceManager.denyUsbDebugging();
    }

    @Override
    public void clearUsbDebuggingKeys() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        this.mDeviceManager.clearUsbDebuggingKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsbPort[] getPorts() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        long ident = Binder.clearCallingIdentity();
        try {
            UsbPort[] usbPortArray = this.mPortManager != null ? this.mPortManager.getPorts() : null;
            return usbPortArray;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsbPortStatus getPortStatus(String portId) {
        Preconditions.checkNotNull(portId, "portId must not be null");
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        long ident = Binder.clearCallingIdentity();
        try {
            UsbPortStatus usbPortStatus = this.mPortManager != null ? this.mPortManager.getPortStatus(portId) : null;
            return usbPortStatus;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPortRoles(String portId, int powerRole, int dataRole) {
        Preconditions.checkNotNull(portId, "portId must not be null");
        UsbPort.checkRoles(powerRole, dataRole);
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        long ident = Binder.clearCallingIdentity();
        try {
            if (this.mPortManager != null) {
                this.mPortManager.setPortRoles(portId, powerRole, dataRole, null);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsbDeviceConnectionHandler(ComponentName usbDeviceConnectionHandler) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USB", null);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentUserId == UserHandle.getCallingUserId()) {
                if (this.mHostManager != null) {
                    this.mHostManager.setUsbDeviceConnectionHandler(usbDeviceConnectionHandler);
                }
            } else {
                throw new IllegalArgumentException("Only the current user can register a usb connection handler");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        long ident = Binder.clearCallingIdentity();
        try {
            if (args == null || args.length == 0 || "-a".equals(args[0])) {
                pw.println("USB Manager State:");
                pw.increaseIndent();
                if (this.mDeviceManager != null) {
                    this.mDeviceManager.dump(pw);
                }
                if (this.mHostManager != null) {
                    this.mHostManager.dump(pw);
                }
                if (this.mPortManager != null) {
                    this.mPortManager.dump(pw);
                }
                this.mAlsaManager.dump(pw);
                this.mSettingsManager.dump(pw);
            } else if (args.length == 4 && "set-port-roles".equals(args[0])) {
                int dataRole;
                int powerRole;
                String portId = args[1];
                switch (args[2]) {
                    case "source": {
                        powerRole = 1;
                        break;
                    }
                    case "sink": {
                        powerRole = 2;
                        break;
                    }
                    case "no-power": {
                        powerRole = 0;
                        break;
                    }
                    default: {
                        pw.println("Invalid power role: " + args[2]);
                        return;
                    }
                }
                switch (args[3]) {
                    case "host": {
                        dataRole = 1;
                        break;
                    }
                    case "device": {
                        dataRole = 2;
                        break;
                    }
                    case "no-data": {
                        dataRole = 0;
                        break;
                    }
                    default: {
                        pw.println("Invalid data role: " + args[3]);
                        return;
                    }
                }
                if (this.mPortManager != null) {
                    this.mPortManager.setPortRoles(portId, powerRole, dataRole, pw);
                    pw.println();
                    this.mPortManager.dump(pw);
                }
            } else if (args.length == 3 && "add-port".equals(args[0])) {
                int supportedModes;
                String portId = args[1];
                switch (args[2]) {
                    case "ufp": {
                        supportedModes = 1;
                        break;
                    }
                    case "dfp": {
                        supportedModes = 2;
                        break;
                    }
                    case "dual": {
                        supportedModes = 3;
                        break;
                    }
                    case "none": {
                        supportedModes = 0;
                        break;
                    }
                    default: {
                        pw.println("Invalid mode: " + args[2]);
                        return;
                    }
                }
                if (this.mPortManager != null) {
                    this.mPortManager.addSimulatedPort(portId, supportedModes, pw);
                    pw.println();
                    this.mPortManager.dump(pw);
                }
            } else if (args.length == 5 && "connect-port".equals(args[0])) {
                int dataRole;
                int powerRole;
                int mode;
                String portId = args[1];
                boolean canChangeMode = args[2].endsWith("?");
                switch (canChangeMode ? UsbService.removeLastChar(args[2]) : args[2]) {
                    case "ufp": {
                        mode = 1;
                        break;
                    }
                    case "dfp": {
                        mode = 2;
                        break;
                    }
                    default: {
                        pw.println("Invalid mode: " + args[2]);
                        return;
                    }
                }
                boolean canChangePowerRole = args[3].endsWith("?");
                switch (canChangePowerRole ? UsbService.removeLastChar(args[3]) : args[3]) {
                    case "source": {
                        powerRole = 1;
                        break;
                    }
                    case "sink": {
                        powerRole = 2;
                        break;
                    }
                    default: {
                        pw.println("Invalid power role: " + args[3]);
                        return;
                    }
                }
                boolean canChangeDataRole = args[4].endsWith("?");
                switch (canChangeDataRole ? UsbService.removeLastChar(args[4]) : args[4]) {
                    case "host": {
                        dataRole = 1;
                        break;
                    }
                    case "device": {
                        dataRole = 2;
                        break;
                    }
                    default: {
                        pw.println("Invalid data role: " + args[4]);
                        return;
                    }
                }
                if (this.mPortManager != null) {
                    this.mPortManager.connectSimulatedPort(portId, mode, canChangeMode, powerRole, canChangePowerRole, dataRole, canChangeDataRole, pw);
                    pw.println();
                    this.mPortManager.dump(pw);
                }
            } else if (args.length == 2 && "disconnect-port".equals(args[0])) {
                String portId = args[1];
                if (this.mPortManager != null) {
                    this.mPortManager.disconnectSimulatedPort(portId, pw);
                    pw.println();
                    this.mPortManager.dump(pw);
                }
            } else if (args.length == 2 && "remove-port".equals(args[0])) {
                String portId = args[1];
                if (this.mPortManager != null) {
                    this.mPortManager.removeSimulatedPort(portId, pw);
                    pw.println();
                    this.mPortManager.dump(pw);
                }
            } else if (args.length == 1 && "reset".equals(args[0])) {
                if (this.mPortManager != null) {
                    this.mPortManager.resetSimulation(pw);
                    pw.println();
                    this.mPortManager.dump(pw);
                }
            } else if (args.length == 1 && "ports".equals(args[0])) {
                if (this.mPortManager != null) {
                    this.mPortManager.dump(pw);
                }
            } else {
                pw.println("Dump current USB state or issue command:");
                pw.println("  ports");
                pw.println("  set-port-roles <id> <source|sink|no-power> <host|device|no-data>");
                pw.println("  add-port <id> <ufp|dfp|dual|none>");
                pw.println("  connect-port <id> <ufp|dfp><?> <source|sink><?> <host|device><?>");
                pw.println("    (add ? suffix if mode, power role, or data role can be changed)");
                pw.println("  disconnect-port <id>");
                pw.println("  remove-port <id>");
                pw.println("  reset");
                pw.println();
                pw.println("Example USB type C port role switch:");
                pw.println("  dumpsys usb set-port-roles \"default\" source device");
                pw.println();
                pw.println("Example USB type C port simulation with full capabilities:");
                pw.println("  dumpsys usb add-port \"matrix\" dual");
                pw.println("  dumpsys usb connect-port \"matrix\" ufp? sink? device?");
                pw.println("  dumpsys usb ports");
                pw.println("  dumpsys usb disconnect-port \"matrix\"");
                pw.println("  dumpsys usb remove-port \"matrix\"");
                pw.println("  dumpsys usb reset");
                pw.println();
                pw.println("Example USB type C port where only power role can be changed:");
                pw.println("  dumpsys usb add-port \"matrix\" dual");
                pw.println("  dumpsys usb connect-port \"matrix\" dfp source? host");
                pw.println("  dumpsys usb reset");
                pw.println();
                pw.println("Example USB OTG port where id pin determines function:");
                pw.println("  dumpsys usb add-port \"matrix\" dual");
                pw.println("  dumpsys usb connect-port \"matrix\" dfp source host");
                pw.println("  dumpsys usb reset");
                pw.println();
                pw.println("Example USB device-only port:");
                pw.println("  dumpsys usb add-port \"matrix\" ufp");
                pw.println("  dumpsys usb connect-port \"matrix\" ufp sink device");
                pw.println("  dumpsys usb reset");
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static final String removeLastChar(String value) {
        return value.substring(0, value.length() - 1);
    }

    public static class Lifecycle
    extends SystemService {
        private UsbService mUsbService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mUsbService = new UsbService(this.getContext());
            this.publishBinderService("usb", this.mUsbService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mUsbService.systemReady();
            } else if (phase == 1000) {
                this.mUsbService.bootCompleted();
            }
        }

        @Override
        public void onSwitchUser(int newUserId) {
            this.mUsbService.onSwitchUser(newUserId);
        }

        @Override
        public void onStopUser(int userHandle) {
            this.mUsbService.onStopUser(UserHandle.of(userHandle));
        }
    }
}

