/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ClipData;
import android.content.ClipDescription;
import android.graphics.Point;
import android.hardware.input.InputManager;
import android.os.IBinder;
import android.os.IUserManager;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Slog;
import android.view.Display;
import android.view.DragEvent;
import android.view.InputChannel;
import android.view.SurfaceControl;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;
import com.android.internal.view.IDragAndDropPermissions;
import com.android.server.input.InputApplicationHandle;
import com.android.server.input.InputWindowHandle;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DragAndDropPermissionsHandler;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.ArrayList;

class DragState {
    private static final long MIN_ANIMATION_DURATION_MS = 195L;
    private static final long MAX_ANIMATION_DURATION_MS = 375L;
    private static final int DRAG_FLAGS_URI_ACCESS = 3;
    private static final int DRAG_FLAGS_URI_PERMISSIONS = 195;
    final WindowManagerService mService;
    IBinder mToken;
    SurfaceControl mSurfaceControl;
    int mFlags;
    IBinder mLocalWin;
    int mPid;
    int mUid;
    int mSourceUserId;
    boolean mCrossProfileCopyAllowed;
    ClipData mData;
    ClipDescription mDataDescription;
    int mTouchSource;
    boolean mDragResult;
    float mOriginalAlpha;
    float mOriginalX;
    float mOriginalY;
    float mCurrentX;
    float mCurrentY;
    float mThumbOffsetX;
    float mThumbOffsetY;
    InputInterceptor mInputInterceptor;
    WindowState mTargetWindow;
    ArrayList<WindowState> mNotifiedWindows;
    boolean mDragInProgress;
    DisplayContent mDisplayContent;
    private Animation mAnimation;
    final Transformation mTransformation = new Transformation();
    private final Interpolator mCubicEaseOutInterpolator = new DecelerateInterpolator(1.5f);
    private Point mDisplaySize = new Point();

    DragState(WindowManagerService service, IBinder token, SurfaceControl surface, int flags, IBinder localWin) {
        this.mService = service;
        this.mToken = token;
        this.mSurfaceControl = surface;
        this.mFlags = flags;
        this.mLocalWin = localWin;
        this.mNotifiedWindows = new ArrayList();
    }

    void reset() {
        if (this.mSurfaceControl != null) {
            this.mSurfaceControl.destroy();
        }
        this.mSurfaceControl = null;
        this.mFlags = 0;
        this.mLocalWin = null;
        this.mToken = null;
        this.mData = null;
        this.mThumbOffsetY = 0.0f;
        this.mThumbOffsetX = 0.0f;
        this.mNotifiedWindows = null;
    }

    InputChannel getInputChannel() {
        return this.mInputInterceptor == null ? null : this.mInputInterceptor.mServerChannel;
    }

    InputWindowHandle getInputWindowHandle() {
        return this.mInputInterceptor == null ? null : this.mInputInterceptor.mDragWindowHandle;
    }

    void register(Display display) {
        display.getRealSize(this.mDisplaySize);
        if (this.mInputInterceptor != null) {
            Slog.e("WindowManager", "Duplicate register of drag input channel");
        } else {
            this.mInputInterceptor = new InputInterceptor(display);
            this.mService.mInputMonitor.updateInputWindowsLw(true);
        }
    }

    void unregister() {
        if (this.mInputInterceptor == null) {
            Slog.e("WindowManager", "Unregister of nonexistent drag input channel");
        } else {
            this.mService.mH.obtainMessage(44, this.mInputInterceptor).sendToTarget();
            this.mInputInterceptor = null;
            this.mService.mInputMonitor.updateInputWindowsLw(true);
        }
    }

    int getDragLayerLw() {
        return this.mService.mPolicy.getWindowLayerFromTypeLw(2016) * 10000 + 1000;
    }

    void broadcastDragStartedLw(float touchX, float touchY) {
        this.mOriginalX = this.mCurrentX = touchX;
        this.mOriginalY = this.mCurrentY = touchY;
        this.mDataDescription = this.mData != null ? this.mData.getDescription() : null;
        this.mNotifiedWindows.clear();
        this.mDragInProgress = true;
        this.mSourceUserId = UserHandle.getUserId(this.mUid);
        IUserManager userManager = (IUserManager)((Object)ServiceManager.getService("user"));
        try {
            this.mCrossProfileCopyAllowed = !userManager.getUserRestrictions(this.mSourceUserId).getBoolean("no_cross_profile_copy_paste");
        }
        catch (RemoteException e) {
            Slog.e("WindowManager", "Remote Exception calling UserManager: " + e);
            this.mCrossProfileCopyAllowed = false;
        }
        this.mDisplayContent.forAllWindows(w -> this.sendDragStartedLw((WindowState)w, touchX, touchY, this.mDataDescription), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDragStartedLw(WindowState newWin, float touchX, float touchY, ClipDescription desc) {
        if (this.mDragInProgress && this.isValidDropTarget(newWin)) {
            DragEvent event = DragState.obtainDragEvent(newWin, 1, touchX, touchY, null, desc, null, null, false);
            try {
                newWin.mClient.dispatchDragEvent(event);
                this.mNotifiedWindows.add(newWin);
            }
            catch (RemoteException e) {
                Slog.w("WindowManager", "Unable to drag-start window " + newWin);
            }
            finally {
                if (Process.myPid() != newWin.mSession.mPid) {
                    event.recycle();
                }
            }
        }
    }

    private boolean isValidDropTarget(WindowState targetWin) {
        if (targetWin == null) {
            return false;
        }
        if (!targetWin.isPotentialDragTarget()) {
            return false;
        }
        if (!((this.mFlags & 0x100) != 0 && this.targetWindowSupportsGlobalDrag(targetWin) || this.mLocalWin == targetWin.mClient.asBinder())) {
            return false;
        }
        return this.mCrossProfileCopyAllowed || this.mSourceUserId == UserHandle.getUserId(targetWin.getOwningUid());
    }

    private boolean targetWindowSupportsGlobalDrag(WindowState targetWin) {
        return targetWin.mAppToken == null || targetWin.mAppToken.mTargetSdk >= 24;
    }

    void sendDragStartedIfNeededLw(WindowState newWin) {
        if (this.mDragInProgress) {
            if (this.isWindowNotified(newWin)) {
                return;
            }
            this.sendDragStartedLw(newWin, this.mCurrentX, this.mCurrentY, this.mDataDescription);
        }
    }

    private boolean isWindowNotified(WindowState newWin) {
        for (WindowState ws : this.mNotifiedWindows) {
            if (ws != newWin) continue;
            return true;
        }
        return false;
    }

    private void broadcastDragEndedLw() {
        int myPid = Process.myPid();
        for (WindowState ws : this.mNotifiedWindows) {
            float x = 0.0f;
            float y = 0.0f;
            if (!this.mDragResult && ws.mSession.mPid == this.mPid) {
                x = this.mCurrentX;
                y = this.mCurrentY;
            }
            DragEvent evt = DragEvent.obtain(4, x, y, null, null, null, null, this.mDragResult);
            try {
                ws.mClient.dispatchDragEvent(evt);
            }
            catch (RemoteException e) {
                Slog.w("WindowManager", "Unable to drag-end window " + ws);
            }
            if (myPid == ws.mSession.mPid) continue;
            evt.recycle();
        }
        this.mNotifiedWindows.clear();
        this.mDragInProgress = false;
    }

    void endDragLw() {
        if (this.mAnimation != null) {
            return;
        }
        if (!this.mDragResult) {
            this.mAnimation = this.createReturnAnimationLocked();
            this.mService.scheduleAnimationLocked();
            return;
        }
        this.cleanUpDragLw();
    }

    void cancelDragLw() {
        if (this.mAnimation != null) {
            return;
        }
        this.mAnimation = this.createCancelAnimationLocked();
        this.mService.scheduleAnimationLocked();
    }

    private void cleanUpDragLw() {
        this.broadcastDragEndedLw();
        if (this.isFromSource(8194)) {
            this.mService.restorePointerIconLocked(this.mDisplayContent, this.mCurrentX, this.mCurrentY);
        }
        this.unregister();
        this.reset();
        this.mService.mDragState = null;
    }

    void notifyMoveLw(float x, float y) {
        if (this.mAnimation != null) {
            return;
        }
        this.mCurrentX = x;
        this.mCurrentY = y;
        this.mService.openSurfaceTransaction();
        try {
            this.mSurfaceControl.setPosition(x - this.mThumbOffsetX, y - this.mThumbOffsetY);
        }
        finally {
            this.mService.closeSurfaceTransaction();
        }
        this.notifyLocationLw(x, y);
    }

    void notifyLocationLw(float x, float y) {
        WindowState touchedWin = this.mDisplayContent.getTouchableWinAtPointLocked(x, y);
        if (touchedWin != null && !this.isWindowNotified(touchedWin)) {
            touchedWin = null;
        }
        try {
            DragEvent evt;
            int myPid = Process.myPid();
            if (touchedWin != this.mTargetWindow && this.mTargetWindow != null) {
                evt = DragState.obtainDragEvent(this.mTargetWindow, 6, 0.0f, 0.0f, null, null, null, null, false);
                this.mTargetWindow.mClient.dispatchDragEvent(evt);
                if (myPid != this.mTargetWindow.mSession.mPid) {
                    evt.recycle();
                }
            }
            if (touchedWin != null) {
                evt = DragState.obtainDragEvent(touchedWin, 2, x, y, null, null, null, null, false);
                touchedWin.mClient.dispatchDragEvent(evt);
                if (myPid != touchedWin.mSession.mPid) {
                    evt.recycle();
                }
            }
        }
        catch (RemoteException e) {
            Slog.w("WindowManager", "can't send drag notification to windows");
        }
        this.mTargetWindow = touchedWin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyDropLw(float x, float y) {
        if (this.mAnimation != null) {
            return false;
        }
        this.mCurrentX = x;
        this.mCurrentY = y;
        WindowState touchedWin = this.mDisplayContent.getTouchableWinAtPointLocked(x, y);
        if (!this.isWindowNotified(touchedWin)) {
            this.mDragResult = false;
            return true;
        }
        int targetUserId = UserHandle.getUserId(touchedWin.getOwningUid());
        DragAndDropPermissionsHandler dragAndDropPermissions = null;
        if ((this.mFlags & 0x100) != 0 && (this.mFlags & 3) != 0) {
            dragAndDropPermissions = new DragAndDropPermissionsHandler(this.mData, this.mUid, touchedWin.getOwningPackage(), this.mFlags & 0xC3, this.mSourceUserId, targetUserId);
        }
        if (this.mSourceUserId != targetUserId) {
            this.mData.fixUris(this.mSourceUserId);
        }
        int myPid = Process.myPid();
        IBinder token = touchedWin.mClient.asBinder();
        DragEvent evt = DragState.obtainDragEvent(touchedWin, 3, x, y, null, null, this.mData, dragAndDropPermissions, false);
        try {
            touchedWin.mClient.dispatchDragEvent(evt);
            this.mService.mH.removeMessages(21, token);
            Message msg = this.mService.mH.obtainMessage(21, token);
            this.mService.mH.sendMessageDelayed(msg, 5000L);
        }
        catch (RemoteException e) {
            Slog.w("WindowManager", "can't send drop notification to win " + touchedWin);
            boolean bl = true;
            return bl;
        }
        finally {
            if (myPid != touchedWin.mSession.mPid) {
                evt.recycle();
            }
        }
        this.mToken = token;
        return false;
    }

    private static DragEvent obtainDragEvent(WindowState win, int action, float x, float y, Object localState, ClipDescription description, ClipData data, IDragAndDropPermissions dragAndDropPermissions, boolean result) {
        float winX = win.translateToWindowX(x);
        float winY = win.translateToWindowY(y);
        return DragEvent.obtain(action, winX, winY, localState, description, data, dragAndDropPermissions, result);
    }

    boolean stepAnimationLocked(long currentTimeMs) {
        if (this.mAnimation == null) {
            return false;
        }
        this.mTransformation.clear();
        if (!this.mAnimation.getTransformation(currentTimeMs, this.mTransformation)) {
            this.cleanUpDragLw();
            return false;
        }
        this.mTransformation.getMatrix().postTranslate(this.mCurrentX - this.mThumbOffsetX, this.mCurrentY - this.mThumbOffsetY);
        float[] tmpFloats = this.mService.mTmpFloats;
        this.mTransformation.getMatrix().getValues(tmpFloats);
        this.mSurfaceControl.setPosition(tmpFloats[2], tmpFloats[5]);
        this.mSurfaceControl.setAlpha(this.mTransformation.getAlpha());
        this.mSurfaceControl.setMatrix(tmpFloats[0], tmpFloats[3], tmpFloats[1], tmpFloats[4]);
        return true;
    }

    private Animation createReturnAnimationLocked() {
        AnimationSet set = new AnimationSet(false);
        float translateX = this.mOriginalX - this.mCurrentX;
        float translateY = this.mOriginalY - this.mCurrentY;
        set.addAnimation(new TranslateAnimation(0.0f, translateX, 0.0f, translateY));
        set.addAnimation(new AlphaAnimation(this.mOriginalAlpha, this.mOriginalAlpha / 2.0f));
        double travelDistance = Math.sqrt(translateX * translateX + translateY * translateY);
        double displayDiagonal = Math.sqrt(this.mDisplaySize.x * this.mDisplaySize.x + this.mDisplaySize.y * this.mDisplaySize.y);
        long duration = 195L + (long)(travelDistance / displayDiagonal * 180.0);
        set.setDuration(duration);
        set.setInterpolator(this.mCubicEaseOutInterpolator);
        set.initialize(0, 0, 0, 0);
        set.start();
        return set;
    }

    private Animation createCancelAnimationLocked() {
        AnimationSet set = new AnimationSet(false);
        set.addAnimation(new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, this.mThumbOffsetX, this.mThumbOffsetY));
        set.addAnimation(new AlphaAnimation(this.mOriginalAlpha, 0.0f));
        set.setDuration(195L);
        set.setInterpolator(this.mCubicEaseOutInterpolator);
        set.initialize(0, 0, 0, 0);
        set.start();
        return set;
    }

    private boolean isFromSource(int source) {
        return (this.mTouchSource & source) == source;
    }

    void overridePointerIconLw(int touchSource) {
        this.mTouchSource = touchSource;
        if (this.isFromSource(8194)) {
            InputManager.getInstance().setPointerIconType(1021);
        }
    }

    class InputInterceptor {
        InputChannel mServerChannel;
        InputChannel mClientChannel;
        WindowManagerService.DragInputEventReceiver mInputEventReceiver;
        InputApplicationHandle mDragApplicationHandle;
        InputWindowHandle mDragWindowHandle;

        InputInterceptor(Display display) {
            InputChannel[] channels = InputChannel.openInputChannelPair("drag");
            this.mServerChannel = channels[0];
            this.mClientChannel = channels[1];
            DragState.this.mService.mInputManager.registerInputChannel(this.mServerChannel, null);
            WindowManagerService windowManagerService = DragState.this.mService;
            windowManagerService.getClass();
            this.mInputEventReceiver = windowManagerService.new WindowManagerService.DragInputEventReceiver(this.mClientChannel, DragState.this.mService.mH.getLooper());
            this.mDragApplicationHandle = new InputApplicationHandle(null);
            this.mDragApplicationHandle.name = "drag";
            this.mDragApplicationHandle.dispatchingTimeoutNanos = 5000000000L;
            this.mDragWindowHandle = new InputWindowHandle(this.mDragApplicationHandle, null, null, display.getDisplayId());
            this.mDragWindowHandle.name = "drag";
            this.mDragWindowHandle.inputChannel = this.mServerChannel;
            this.mDragWindowHandle.layer = DragState.this.getDragLayerLw();
            this.mDragWindowHandle.layoutParamsFlags = 0;
            this.mDragWindowHandle.layoutParamsType = 2016;
            this.mDragWindowHandle.dispatchingTimeoutNanos = 5000000000L;
            this.mDragWindowHandle.visible = true;
            this.mDragWindowHandle.canReceiveKeys = false;
            this.mDragWindowHandle.hasFocus = true;
            this.mDragWindowHandle.hasWallpaper = false;
            this.mDragWindowHandle.paused = false;
            this.mDragWindowHandle.ownerPid = Process.myPid();
            this.mDragWindowHandle.ownerUid = Process.myUid();
            this.mDragWindowHandle.inputFeatures = 0;
            this.mDragWindowHandle.scaleFactor = 1.0f;
            this.mDragWindowHandle.touchableRegion.setEmpty();
            this.mDragWindowHandle.frameLeft = 0;
            this.mDragWindowHandle.frameTop = 0;
            this.mDragWindowHandle.frameRight = ((DragState)DragState.this).mDisplaySize.x;
            this.mDragWindowHandle.frameBottom = ((DragState)DragState.this).mDisplaySize.y;
            DragState.this.mService.pauseRotationLocked();
        }

        void tearDown() {
            DragState.this.mService.mInputManager.unregisterInputChannel(this.mServerChannel);
            this.mInputEventReceiver.dispose();
            this.mInputEventReceiver = null;
            this.mClientChannel.dispose();
            this.mServerChannel.dispose();
            this.mClientChannel = null;
            this.mServerChannel = null;
            this.mDragWindowHandle = null;
            this.mDragApplicationHandle = null;
            DragState.this.mService.resumeRotationLocked();
        }
    }
}

