/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;

class EmulatorDisplayOverlay {
    private static final String TAG = "WindowManager";
    private Point mScreenSize;
    private final SurfaceControl mSurfaceControl;
    private final Surface mSurface = new Surface();
    private int mLastDW;
    private int mLastDH;
    private boolean mDrawNeeded;
    private Drawable mOverlay;
    private int mRotation;
    private boolean mVisible;

    public EmulatorDisplayOverlay(Context context, Display display, SurfaceSession session, int zOrder) {
        this.mScreenSize = new Point();
        display.getSize(this.mScreenSize);
        SurfaceControl ctrl = null;
        try {
            ctrl = new SurfaceControl(session, "EmulatorDisplayOverlay", this.mScreenSize.x, this.mScreenSize.y, -3, 4);
            ctrl.setLayerStack(display.getLayerStack());
            ctrl.setLayer(zOrder);
            ctrl.setPosition(0.0f, 0.0f);
            ctrl.show();
            this.mSurface.copyFrom(ctrl);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            // empty catch block
        }
        this.mSurfaceControl = ctrl;
        this.mDrawNeeded = true;
        this.mOverlay = context.getDrawable(17302195);
    }

    private void drawIfNeeded() {
        if (!this.mDrawNeeded || !this.mVisible) {
            return;
        }
        this.mDrawNeeded = false;
        Rect dirty = new Rect(0, 0, this.mScreenSize.x, this.mScreenSize.y);
        Canvas c = null;
        try {
            c = this.mSurface.lockCanvas(dirty);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            // empty catch block
        }
        if (c == null) {
            return;
        }
        c.drawColor(0, PorterDuff.Mode.SRC);
        this.mSurfaceControl.setPosition(0.0f, 0.0f);
        int size = Math.max(this.mScreenSize.x, this.mScreenSize.y);
        this.mOverlay.setBounds(0, 0, size, size);
        this.mOverlay.draw(c);
        this.mSurface.unlockCanvasAndPost(c);
    }

    public void setVisibility(boolean on) {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.mVisible = on;
        this.drawIfNeeded();
        if (on) {
            this.mSurfaceControl.show();
        } else {
            this.mSurfaceControl.hide();
        }
    }

    void positionSurface(int dw, int dh, int rotation) {
        if (this.mLastDW == dw && this.mLastDH == dh && this.mRotation == rotation) {
            return;
        }
        this.mLastDW = dw;
        this.mLastDH = dh;
        this.mDrawNeeded = true;
        this.mRotation = rotation;
        this.drawIfNeeded();
    }
}

