/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteException;
import android.drm.DrmManagerClient;
import android.net.Uri;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.mms.ContentType;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.AcknowledgeInd;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.NotifyRespInd;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.ReadOrigInd;
import com.google.android.mms.pdu.ReadRecInd;
import com.google.android.mms.pdu.RetrieveConf;
import com.google.android.mms.pdu.SendReq;
import com.google.android.mms.util.DownloadDrmHelper;
import com.google.android.mms.util.DrmConvertSession;
import com.google.android.mms.util.PduCache;
import com.google.android.mms.util.PduCacheEntry;
import com.google.android.mms.util.SqliteWrapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PduPersister {
    private static final String TAG = "PduPersister";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final long DUMMY_THREAD_ID = Long.MAX_VALUE;
    public static final String TEMPORARY_DRM_OBJECT_URI = "content://mms/9223372036854775807/part";
    public static final int PROC_STATUS_TRANSIENT_FAILURE = 1;
    public static final int PROC_STATUS_PERMANENTLY_FAILURE = 2;
    public static final int PROC_STATUS_COMPLETED = 3;
    private static PduPersister sPersister;
    private static final PduCache PDU_CACHE_INSTANCE;
    private static final int[] ADDRESS_FIELDS;
    private static final String[] PDU_PROJECTION;
    private static final int PDU_COLUMN_ID = 0;
    private static final int PDU_COLUMN_MESSAGE_BOX = 1;
    private static final int PDU_COLUMN_THREAD_ID = 2;
    private static final int PDU_COLUMN_RETRIEVE_TEXT = 3;
    private static final int PDU_COLUMN_SUBJECT = 4;
    private static final int PDU_COLUMN_CONTENT_LOCATION = 5;
    private static final int PDU_COLUMN_CONTENT_TYPE = 6;
    private static final int PDU_COLUMN_MESSAGE_CLASS = 7;
    private static final int PDU_COLUMN_MESSAGE_ID = 8;
    private static final int PDU_COLUMN_RESPONSE_TEXT = 9;
    private static final int PDU_COLUMN_TRANSACTION_ID = 10;
    private static final int PDU_COLUMN_CONTENT_CLASS = 11;
    private static final int PDU_COLUMN_DELIVERY_REPORT = 12;
    private static final int PDU_COLUMN_MESSAGE_TYPE = 13;
    private static final int PDU_COLUMN_MMS_VERSION = 14;
    private static final int PDU_COLUMN_PRIORITY = 15;
    private static final int PDU_COLUMN_READ_REPORT = 16;
    private static final int PDU_COLUMN_READ_STATUS = 17;
    private static final int PDU_COLUMN_REPORT_ALLOWED = 18;
    private static final int PDU_COLUMN_RETRIEVE_STATUS = 19;
    private static final int PDU_COLUMN_STATUS = 20;
    private static final int PDU_COLUMN_DATE = 21;
    private static final int PDU_COLUMN_DELIVERY_TIME = 22;
    private static final int PDU_COLUMN_EXPIRY = 23;
    private static final int PDU_COLUMN_MESSAGE_SIZE = 24;
    private static final int PDU_COLUMN_SUBJECT_CHARSET = 25;
    private static final int PDU_COLUMN_RETRIEVE_TEXT_CHARSET = 26;
    private static final String[] PART_PROJECTION;
    private static final int PART_COLUMN_ID = 0;
    private static final int PART_COLUMN_CHARSET = 1;
    private static final int PART_COLUMN_CONTENT_DISPOSITION = 2;
    private static final int PART_COLUMN_CONTENT_ID = 3;
    private static final int PART_COLUMN_CONTENT_LOCATION = 4;
    private static final int PART_COLUMN_CONTENT_TYPE = 5;
    private static final int PART_COLUMN_FILENAME = 6;
    private static final int PART_COLUMN_NAME = 7;
    private static final int PART_COLUMN_TEXT = 8;
    private static final HashMap<Uri, Integer> MESSAGE_BOX_MAP;
    private static final HashMap<Integer, Integer> CHARSET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> ENCODED_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> TEXT_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> OCTET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> LONG_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> CHARSET_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> ENCODED_STRING_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> TEXT_STRING_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> OCTET_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> LONG_COLUMN_NAME_MAP;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final DrmManagerClient mDrmManagerClient;
    private final TelephonyManager mTelephonyManager;

    private PduPersister(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mDrmManagerClient = new DrmManagerClient(context);
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
    }

    public static PduPersister getPduPersister(Context context) {
        if (sPersister == null) {
            sPersister = new PduPersister(context);
        } else if (!context.equals(PduPersister.sPersister.mContext)) {
            sPersister.release();
            sPersister = new PduPersister(context);
        }
        return sPersister;
    }

    private void setEncodedStringValueToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) {
        String s = c.getString(columnIndex);
        if (s != null && s.length() > 0) {
            int charsetColumnIndex = CHARSET_COLUMN_INDEX_MAP.get(mapColumn);
            int charset = c.getInt(charsetColumnIndex);
            EncodedStringValue value = new EncodedStringValue(charset, PduPersister.getBytes(s));
            headers.setEncodedStringValue(value, mapColumn);
        }
    }

    private void setTextStringToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) {
        String s = c.getString(columnIndex);
        if (s != null) {
            headers.setTextString(PduPersister.getBytes(s), mapColumn);
        }
    }

    private void setOctetToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) throws InvalidHeaderValueException {
        if (!c.isNull(columnIndex)) {
            int b = c.getInt(columnIndex);
            headers.setOctet(b, mapColumn);
        }
    }

    private void setLongToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) {
        if (!c.isNull(columnIndex)) {
            long l = c.getLong(columnIndex);
            headers.setLongInteger(l, mapColumn);
        }
    }

    private Integer getIntegerFromPartColumn(Cursor c, int columnIndex) {
        if (!c.isNull(columnIndex)) {
            return c.getInt(columnIndex);
        }
        return null;
    }

    private byte[] getByteArrayFromPartColumn(Cursor c, int columnIndex) {
        if (!c.isNull(columnIndex)) {
            return PduPersister.getBytes(c.getString(columnIndex));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PduPart[] loadParts(long msgId) throws MmsException {
        PduPart[] parts = null;
        try (Cursor c = SqliteWrapper.query(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + msgId + "/part"), PART_PROJECTION, null, null, null);){
            if (c == null || c.getCount() == 0) {
                PduPart[] pduPartArray = null;
                return pduPartArray;
            }
            int partCount = c.getCount();
            int partIdx = 0;
            parts = new PduPart[partCount];
            while (c.moveToNext()) {
                byte[] name;
                byte[] contentType;
                byte[] contentLocation;
                byte[] contentId;
                byte[] contentDisposition;
                PduPart part = new PduPart();
                Integer charset = this.getIntegerFromPartColumn(c, 1);
                if (charset != null) {
                    part.setCharset(charset);
                }
                if ((contentDisposition = this.getByteArrayFromPartColumn(c, 2)) != null) {
                    part.setContentDisposition(contentDisposition);
                }
                if ((contentId = this.getByteArrayFromPartColumn(c, 3)) != null) {
                    part.setContentId(contentId);
                }
                if ((contentLocation = this.getByteArrayFromPartColumn(c, 4)) != null) {
                    part.setContentLocation(contentLocation);
                }
                if ((contentType = this.getByteArrayFromPartColumn(c, 5)) == null) {
                    throw new MmsException("Content-Type must be set.");
                }
                part.setContentType(contentType);
                byte[] fileName = this.getByteArrayFromPartColumn(c, 6);
                if (fileName != null) {
                    part.setFilename(fileName);
                }
                if ((name = this.getByteArrayFromPartColumn(c, 7)) != null) {
                    part.setName(name);
                }
                long partId = c.getLong(0);
                Uri partURI = Uri.parse("content://mms/part/" + partId);
                part.setDataUri(partURI);
                String type = PduPersister.toIsoString(contentType);
                if (!(ContentType.isImageType(type) || ContentType.isAudioType(type) || ContentType.isVideoType(type))) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream is = null;
                    if ("text/plain".equals(type) || "application/smil".equals(type) || "text/html".equals(type)) {
                        String text = c.getString(8);
                        byte[] blob = new EncodedStringValue(text != null ? text : "").getTextString();
                        baos.write(blob, 0, blob.length);
                    } else {
                        try {
                            is = this.mContentResolver.openInputStream(partURI);
                            byte[] buffer = new byte[256];
                            int len = is.read(buffer);
                            while (len >= 0) {
                                baos.write(buffer, 0, len);
                                len = is.read(buffer);
                            }
                        }
                        catch (IOException e) {
                            Log.e(TAG, "Failed to load part data", e);
                            c.close();
                            throw new MmsException(e);
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    Log.e(TAG, "Failed to close stream", e);
                                }
                            }
                        }
                    }
                    part.setData(baos.toByteArray());
                }
                parts[partIdx++] = part;
            }
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAddress(long msgId, PduHeaders headers) {
        Cursor c = SqliteWrapper.query(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + msgId + "/addr"), new String[]{"address", "charset", "type"}, null, null, null);
        if (c == null) return;
        try {
            block7: while (c.moveToNext()) {
                String addr = c.getString(0);
                if (TextUtils.isEmpty(addr)) continue;
                int addrType = c.getInt(2);
                switch (addrType) {
                    case 137: {
                        headers.setEncodedStringValue(new EncodedStringValue(c.getInt(1), PduPersister.getBytes(addr)), addrType);
                        continue block7;
                    }
                    case 129: 
                    case 130: 
                    case 151: {
                        headers.appendEncodedStringValue(new EncodedStringValue(c.getInt(1), PduPersister.getBytes(addr)), addrType);
                        continue block7;
                    }
                }
                Log.e(TAG, "Unknown address type: " + addrType);
            }
            return;
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public GenericPdu load(Uri uri) throws MmsException {
        void var2_11;
        PduCache pduCache;
        long threadId;
        int msgBox;
        PduCacheEntry cacheEntry;
        GenericPdu genericPdu;
        block43: {
            genericPdu = null;
            cacheEntry = null;
            msgBox = 0;
            threadId = -1L;
            pduCache = PDU_CACHE_INSTANCE;
            // MONITORENTER : pduCache
            if (!PDU_CACHE_INSTANCE.isUpdating(uri)) break block43;
            try {
                PDU_CACHE_INSTANCE.wait();
            }
            catch (InterruptedException e) {
                Log.e(TAG, "load: ", e);
            }
            cacheEntry = (PduCacheEntry)PDU_CACHE_INSTANCE.get(uri);
            if (cacheEntry == null) break block43;
            GenericPdu e = cacheEntry.getPdu();
            // MONITOREXIT : pduCache
            PduCache pduCache2 = PDU_CACHE_INSTANCE;
            // MONITORENTER : pduCache2
            if (genericPdu != null) {
                assert (PDU_CACHE_INSTANCE.get(uri) == null);
                cacheEntry = new PduCacheEntry(genericPdu, msgBox, threadId);
                PDU_CACHE_INSTANCE.put(uri, cacheEntry);
            }
            PDU_CACHE_INSTANCE.setUpdating(uri, false);
            PDU_CACHE_INSTANCE.notifyAll();
            // MONITOREXIT : pduCache2
            return e;
        }
        try {
            PduPart[] parts;
            PDU_CACHE_INSTANCE.setUpdating(uri, true);
            // MONITOREXIT : pduCache
            Cursor c = SqliteWrapper.query(this.mContext, this.mContentResolver, uri, PDU_PROJECTION, null, null, null);
            PduHeaders headers = new PduHeaders();
            long msgId = ContentUris.parseId(uri);
            try {
                if (c == null) throw new MmsException("Bad uri: " + uri);
                if (c.getCount() != 1) throw new MmsException("Bad uri: " + uri);
                if (!c.moveToFirst()) {
                    throw new MmsException("Bad uri: " + uri);
                }
                msgBox = c.getInt(1);
                threadId = c.getLong(2);
                Set<Map.Entry<Integer, Integer>> set = ENCODED_STRING_COLUMN_INDEX_MAP.entrySet();
                for (Map.Entry<Integer, Integer> e : set) {
                    this.setEncodedStringValueToHeaders(c, e.getValue(), headers, e.getKey());
                }
                set = TEXT_STRING_COLUMN_INDEX_MAP.entrySet();
                for (Map.Entry<Integer, Integer> e : set) {
                    this.setTextStringToHeaders(c, e.getValue(), headers, e.getKey());
                }
                set = OCTET_COLUMN_INDEX_MAP.entrySet();
                for (Map.Entry<Integer, Integer> e : set) {
                    this.setOctetToHeaders(c, e.getValue(), headers, e.getKey());
                }
                set = LONG_COLUMN_INDEX_MAP.entrySet();
                for (Map.Entry<Integer, Integer> e : set) {
                    this.setLongToHeaders(c, e.getValue(), headers, e.getKey());
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            if (msgId == -1L) {
                throw new MmsException("Error! ID of the message: -1.");
            }
            this.loadAddress(msgId, headers);
            int msgType = headers.getOctet(140);
            PduBody body = new PduBody();
            if ((msgType == 132 || msgType == 128) && (parts = this.loadParts(msgId)) != null) {
                int partsNum = parts.length;
                for (int i = 0; i < partsNum; ++i) {
                    body.addPart(parts[i]);
                }
            }
            switch (msgType) {
                case 130: {
                    NotificationInd notificationInd = new NotificationInd(headers);
                    break;
                }
                case 134: {
                    DeliveryInd deliveryInd = new DeliveryInd(headers);
                    break;
                }
                case 136: {
                    ReadOrigInd readOrigInd = new ReadOrigInd(headers);
                    break;
                }
                case 132: {
                    RetrieveConf retrieveConf = new RetrieveConf(headers, body);
                    break;
                }
                case 128: {
                    SendReq sendReq = new SendReq(headers, body);
                    break;
                }
                case 133: {
                    AcknowledgeInd acknowledgeInd = new AcknowledgeInd(headers);
                    break;
                }
                case 131: {
                    NotifyRespInd notifyRespInd = new NotifyRespInd(headers);
                    break;
                }
                case 135: {
                    ReadRecInd readRecInd = new ReadRecInd(headers);
                    break;
                }
                case 129: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: {
                    throw new MmsException("Unsupported PDU type: " + Integer.toHexString(msgType));
                }
                default: {
                    throw new MmsException("Unrecognized PDU type: " + Integer.toHexString(msgType));
                }
            }
            pduCache = PDU_CACHE_INSTANCE;
        }
        catch (Throwable throwable) {
            PduCache pduCache3 = PDU_CACHE_INSTANCE;
            // MONITORENTER : pduCache3
            if (genericPdu != null) {
                assert (PDU_CACHE_INSTANCE.get(uri) == null);
                cacheEntry = new PduCacheEntry(genericPdu, msgBox, threadId);
                PDU_CACHE_INSTANCE.put(uri, cacheEntry);
            }
            PDU_CACHE_INSTANCE.setUpdating(uri, false);
            PDU_CACHE_INSTANCE.notifyAll();
            // MONITOREXIT : pduCache3
            throw throwable;
        }
        if (var2_11 != null) {
            assert (PDU_CACHE_INSTANCE.get(uri) == null);
            cacheEntry = new PduCacheEntry((GenericPdu)var2_11, msgBox, threadId);
            PDU_CACHE_INSTANCE.put(uri, cacheEntry);
        }
        PDU_CACHE_INSTANCE.setUpdating(uri, false);
        PDU_CACHE_INSTANCE.notifyAll();
        // MONITOREXIT : pduCache
        return var2_11;
    }

    private void persistAddress(long msgId, int type, EncodedStringValue[] array2) {
        ContentValues values = new ContentValues(3);
        for (EncodedStringValue addr : array2) {
            values.clear();
            values.put("address", PduPersister.toIsoString(addr.getTextString()));
            values.put("charset", addr.getCharacterSet());
            values.put("type", type);
            Uri uri = Uri.parse("content://mms/" + msgId + "/addr");
            SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, values);
        }
    }

    private static String getPartContentType(PduPart part) {
        return part.getContentType() == null ? null : PduPersister.toIsoString(part.getContentType());
    }

    public Uri persistPart(PduPart part, long msgId, HashMap<Uri, InputStream> preOpenedFiles) throws MmsException {
        Uri res;
        String contentType;
        Uri uri = Uri.parse("content://mms/" + msgId + "/part");
        ContentValues values = new ContentValues(8);
        int charset = part.getCharset();
        if (charset != 0) {
            values.put("chset", charset);
        }
        if ((contentType = PduPersister.getPartContentType(part)) != null) {
            if ("image/jpg".equals(contentType)) {
                contentType = "image/jpeg";
            }
            values.put("ct", contentType);
            if ("application/smil".equals(contentType)) {
                values.put("seq", -1);
            }
        } else {
            throw new MmsException("MIME type of the part must be set.");
        }
        if (part.getFilename() != null) {
            String fileName = new String(part.getFilename());
            values.put("fn", fileName);
        }
        if (part.getName() != null) {
            String name = new String(part.getName());
            values.put("name", name);
        }
        String value = null;
        if (part.getContentDisposition() != null) {
            value = PduPersister.toIsoString(part.getContentDisposition());
            values.put("cd", value);
        }
        if (part.getContentId() != null) {
            value = PduPersister.toIsoString(part.getContentId());
            values.put("cid", value);
        }
        if (part.getContentLocation() != null) {
            value = PduPersister.toIsoString(part.getContentLocation());
            values.put("cl", value);
        }
        if ((res = SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, values)) == null) {
            throw new MmsException("Failed to persist part, return null.");
        }
        this.persistData(part, res, contentType, preOpenedFiles);
        part.setDataUri(res);
        return res;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persistData(PduPart part, Uri uri, String contentType, HashMap<Uri, InputStream> preOpenedFiles) throws MmsException {
        block42: {
            block43: {
                block44: {
                    block45: {
                        block41: {
                            os = null;
                            is = null;
                            drmConvertSession = null;
                            dataUri = null;
                            path = null;
                            try {
                                data = part.getData();
                                if ("text/plain".equals(contentType) || "application/smil".equals(contentType) || "text/html".equals(contentType)) {
                                    cv = new ContentValues();
                                    if (data == null) {
                                        data = new String("").getBytes("utf-8");
                                    }
                                    cv.put("text", new EncodedStringValue(data).getString());
                                    if (this.mContentResolver.update(uri, cv, null, null) != 1) {
                                        throw new MmsException("unable to update " + uri.toString());
                                    }
                                    break block41;
                                }
                                isDrm = DownloadDrmHelper.isDrmConvertNeeded(contentType);
                                if (!isDrm) break block42;
                                if (uri == null) break block43;
                                try {
                                    path = PduPersister.convertUriToPath(this.mContext, uri);
                                    f = new File(path);
                                    len = f.length();
                                    if (len <= 0L) break block43;
                                    if (os == null) break block44;
                                    break block45;
                                }
                                catch (Exception e) {
                                    Log.e("PduPersister", "Can't get file info for: " + part.getDataUri(), e);
                                    break block43;
                                }
                            }
                            catch (FileNotFoundException e) {
                                try {
                                    Log.e("PduPersister", "Failed to open Input/Output stream.", e);
                                    throw new MmsException(e);
                                    catch (IOException e) {
                                        Log.e("PduPersister", "Failed to read/write data.", e);
                                        throw new MmsException(e);
                                    }
                                }
                                catch (Throwable var19_29) {
                                    if (os != null) {
                                        try {
                                            os.close();
                                        }
                                        catch (IOException e) {
                                            Log.e("PduPersister", "IOException while closing: " + os, e);
                                        }
                                    }
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (IOException e) {
                                            Log.e("PduPersister", "IOException while closing: " + is, e);
                                        }
                                    }
                                    if (drmConvertSession == null) throw var19_29;
                                    drmConvertSession.close(path);
                                    f = new File(path);
                                    values = new ContentValues(0);
                                    SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.parse("content://mms/resetFilePerm/" + f.getName()), values, null, null);
                                    throw var19_29;
                                }
                            }
                        }
lbl31:
                        // 4 sources

                        while (true) {
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException e) {
                                    Log.e("PduPersister", "IOException while closing: " + os, e);
                                }
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    Log.e("PduPersister", "IOException while closing: " + is, e);
                                }
                            }
                            if (drmConvertSession == null) return;
                            drmConvertSession.close(path);
                            f = new File(path);
                            values = new ContentValues(0);
                            SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.parse("content://mms/resetFilePerm/" + f.getName()), values, null, null);
                            return;
                        }
                    }
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        Log.e("PduPersister", "IOException while closing: " + os, e);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Log.e("PduPersister", "IOException while closing: " + is, e);
                    }
                }
                if (drmConvertSession == null) return;
                drmConvertSession.close(path);
                f = new File(path);
                values = new ContentValues(0);
                SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.parse("content://mms/resetFilePerm/" + f.getName()), values, null, null);
                return;
            }
            if ((drmConvertSession = DrmConvertSession.open(this.mContext, contentType)) == null) {
                throw new MmsException("Mimetype " + contentType + " can not be converted.");
            }
        }
        os = this.mContentResolver.openOutputStream(uri);
        if (data != null) ** GOTO lbl156
        dataUri = part.getDataUri();
        if (dataUri != null && !dataUri.equals(uri)) ** GOTO lbl-1000
        Log.w("PduPersister", "Can't find data for this part.");
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                Log.e("PduPersister", "IOException while closing: " + os, e);
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e("PduPersister", "IOException while closing: " + is, e);
            }
        }
        if (drmConvertSession == null) return;
        drmConvertSession.close(path);
        f = new File(path);
        values = new ContentValues(0);
        SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.parse("content://mms/resetFilePerm/" + f.getName()), values, null, null);
        return;
lbl-1000:
        // 1 sources

        {
            block46: {
                if (preOpenedFiles != null && preOpenedFiles.containsKey(dataUri)) {
                    is = preOpenedFiles.get(dataUri);
                }
                if (is == null) {
                    is = this.mContentResolver.openInputStream(dataUri);
                }
                buffer = new byte[8192];
                len = 0;
                while (true) {
                    if ((len = is.read(buffer)) == -1) ** GOTO lbl31
                    if (!isDrm) {
                        os.write(buffer, 0, len);
                        continue;
                    }
                    convertedData = drmConvertSession.convert(buffer, len);
                    if (convertedData == null) throw new MmsException("Error converting drm data.");
                    os.write(convertedData, 0, convertedData.length);
                }
lbl156:
                // 1 sources

                if (isDrm) break block46;
                os.write(data);
                ** GOTO lbl31
            }
            dataUri = uri;
            convertedData = drmConvertSession.convert(data, data.length);
            if (convertedData == null) throw new MmsException("Error converting drm data.");
            os.write(convertedData, 0, convertedData.length);
            ** continue;
        }
    }

    public static String convertUriToPath(Context context, Uri uri) {
        String path = null;
        if (null != uri) {
            String scheme = uri.getScheme();
            if (null == scheme || scheme.equals("") || scheme.equals("file")) {
                path = uri.getPath();
            } else if (scheme.equals("http")) {
                path = uri.toString();
            } else if (scheme.equals("content")) {
                String[] projection = new String[]{"_data"};
                Cursor cursor = null;
                try {
                    cursor = context.getContentResolver().query(uri, projection, null, null, null);
                    if (null == cursor || 0 == cursor.getCount() || !cursor.moveToFirst()) {
                        throw new IllegalArgumentException("Given Uri could not be found in media store");
                    }
                    int pathIndex = cursor.getColumnIndexOrThrow("_data");
                    path = cursor.getString(pathIndex);
                }
                catch (SQLiteException e) {
                    throw new IllegalArgumentException("Given Uri is not formatted in a way so that it can be found in media store.");
                }
                finally {
                    if (null != cursor) {
                        cursor.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("Given Uri scheme is not supported");
            }
        }
        return path;
    }

    private void updateAddress(long msgId, int type, EncodedStringValue[] array2) {
        SqliteWrapper.delete(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + msgId + "/addr"), "type=" + type, null);
        this.persistAddress(msgId, type, array2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHeaders(Uri uri, SendReq sendReq) {
        EncodedStringValue subject;
        byte[] transId;
        int readReport;
        int priority;
        byte[] msgClass;
        long expiry;
        int deliveryReport;
        long date;
        PduCache pduCache = PDU_CACHE_INSTANCE;
        synchronized (pduCache) {
            if (PDU_CACHE_INSTANCE.isUpdating(uri)) {
                try {
                    PDU_CACHE_INSTANCE.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "updateHeaders: ", e);
                }
            }
        }
        PDU_CACHE_INSTANCE.purge(uri);
        ContentValues values = new ContentValues(10);
        byte[] contentType = sendReq.getContentType();
        if (contentType != null) {
            values.put("ct_t", PduPersister.toIsoString(contentType));
        }
        if ((date = sendReq.getDate()) != -1L) {
            values.put("date", date);
        }
        if ((deliveryReport = sendReq.getDeliveryReport()) != 0) {
            values.put("d_rpt", deliveryReport);
        }
        if ((expiry = sendReq.getExpiry()) != -1L) {
            values.put("exp", expiry);
        }
        if ((msgClass = sendReq.getMessageClass()) != null) {
            values.put("m_cls", PduPersister.toIsoString(msgClass));
        }
        if ((priority = sendReq.getPriority()) != 0) {
            values.put("pri", priority);
        }
        if ((readReport = sendReq.getReadReport()) != 0) {
            values.put("rr", readReport);
        }
        if ((transId = sendReq.getTransactionId()) != null) {
            values.put("tr_id", PduPersister.toIsoString(transId));
        }
        if ((subject = sendReq.getSubject()) != null) {
            values.put("sub", PduPersister.toIsoString(subject.getTextString()));
            values.put("sub_cs", subject.getCharacterSet());
        } else {
            values.put("sub", "");
        }
        long messageSize = sendReq.getMessageSize();
        if (messageSize > 0L) {
            values.put("m_size", messageSize);
        }
        PduHeaders headers = sendReq.getPduHeaders();
        HashSet<String> recipients = new HashSet<String>();
        for (int addrType : ADDRESS_FIELDS) {
            EncodedStringValue[] array2 = null;
            if (addrType == 137) {
                EncodedStringValue v = headers.getEncodedStringValue(addrType);
                if (v != null) {
                    array2 = new EncodedStringValue[]{v};
                }
            } else {
                array2 = headers.getEncodedStringValues(addrType);
            }
            if (array2 == null) continue;
            long msgId = ContentUris.parseId(uri);
            this.updateAddress(msgId, addrType, array2);
            if (addrType != 151) continue;
            for (EncodedStringValue v : array2) {
                if (v == null) continue;
                recipients.add(v.getString());
            }
        }
        if (!recipients.isEmpty()) {
            long threadId = Telephony.Threads.getOrCreateThreadId(this.mContext, recipients);
            values.put("thread_id", threadId);
        }
        SqliteWrapper.update(this.mContext, this.mContentResolver, uri, values, null, null);
    }

    private void updatePart(Uri uri, PduPart part, HashMap<Uri, InputStream> preOpenedFiles) throws MmsException {
        ContentValues values = new ContentValues(7);
        int charset = part.getCharset();
        if (charset != 0) {
            values.put("chset", charset);
        }
        String contentType = null;
        if (part.getContentType() == null) {
            throw new MmsException("MIME type of the part must be set.");
        }
        contentType = PduPersister.toIsoString(part.getContentType());
        values.put("ct", contentType);
        if (part.getFilename() != null) {
            String fileName = new String(part.getFilename());
            values.put("fn", fileName);
        }
        if (part.getName() != null) {
            String name = new String(part.getName());
            values.put("name", name);
        }
        String value = null;
        if (part.getContentDisposition() != null) {
            value = PduPersister.toIsoString(part.getContentDisposition());
            values.put("cd", value);
        }
        if (part.getContentId() != null) {
            value = PduPersister.toIsoString(part.getContentId());
            values.put("cid", value);
        }
        if (part.getContentLocation() != null) {
            value = PduPersister.toIsoString(part.getContentLocation());
            values.put("cl", value);
        }
        SqliteWrapper.update(this.mContext, this.mContentResolver, uri, values, null, null);
        if (part.getData() != null || !uri.equals(part.getDataUri())) {
            this.persistData(part, uri, contentType, preOpenedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateParts(Uri uri, PduBody body, HashMap<Uri, InputStream> preOpenedFiles) throws MmsException {
        try {
            PduCache pduCache = PDU_CACHE_INSTANCE;
            synchronized (pduCache) {
                if (PDU_CACHE_INSTANCE.isUpdating(uri)) {
                    try {
                        PDU_CACHE_INSTANCE.wait();
                    }
                    catch (InterruptedException e) {
                        Log.e(TAG, "updateParts: ", e);
                    }
                    PduCacheEntry cacheEntry = (PduCacheEntry)PDU_CACHE_INSTANCE.get(uri);
                    if (cacheEntry != null) {
                        ((MultimediaMessagePdu)cacheEntry.getPdu()).setBody(body);
                    }
                }
                PDU_CACHE_INSTANCE.setUpdating(uri, true);
            }
            ArrayList<PduPart> toBeCreated = new ArrayList<PduPart>();
            HashMap<Uri, PduPart> toBeUpdated = new HashMap<Uri, PduPart>();
            int partsNum = body.getPartsNum();
            StringBuilder filter = new StringBuilder().append('(');
            for (int i = 0; i < partsNum; ++i) {
                PduPart part = body.getPart(i);
                Uri partUri = part.getDataUri();
                if (partUri == null || TextUtils.isEmpty(partUri.getAuthority()) || !partUri.getAuthority().startsWith("mms")) {
                    toBeCreated.add(part);
                    continue;
                }
                toBeUpdated.put(partUri, part);
                if (filter.length() > 1) {
                    filter.append(" AND ");
                }
                filter.append("_id");
                filter.append("!=");
                DatabaseUtils.appendEscapedSQLString(filter, partUri.getLastPathSegment());
            }
            filter.append(')');
            long msgId = ContentUris.parseId(uri);
            SqliteWrapper.delete(this.mContext, this.mContentResolver, Uri.parse(Telephony.Mms.CONTENT_URI + "/" + msgId + "/part"), filter.length() > 2 ? filter.toString() : null, null);
            for (PduPart pduPart : toBeCreated) {
                this.persistPart(pduPart, msgId, preOpenedFiles);
            }
            for (Map.Entry entry : toBeUpdated.entrySet()) {
                this.updatePart((Uri)entry.getKey(), (PduPart)entry.getValue(), preOpenedFiles);
            }
        }
        finally {
            PduCache pduCache = PDU_CACHE_INSTANCE;
            synchronized (pduCache) {
                PDU_CACHE_INSTANCE.setUpdating(uri, false);
                PDU_CACHE_INSTANCE.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri persist(GenericPdu pdu, Uri uri, boolean createThreadId, boolean groupMmsEnabled, HashMap<Uri, InputStream> preOpenedFiles) throws MmsException {
        boolean existingUri;
        if (uri == null) {
            throw new MmsException("Uri may not be null.");
        }
        long msgId = -1L;
        try {
            msgId = ContentUris.parseId(uri);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bl = existingUri = msgId != -1L;
        if (!existingUri && MESSAGE_BOX_MAP.get(uri) == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        PduCache pduCache = PDU_CACHE_INSTANCE;
        synchronized (pduCache) {
            if (PDU_CACHE_INSTANCE.isUpdating(uri)) {
                try {
                    PDU_CACHE_INSTANCE.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "persist1: ", e);
                }
            }
        }
        PDU_CACHE_INSTANCE.purge(uri);
        PduHeaders header = pdu.getPduHeaders();
        PduBody body = null;
        ContentValues values = new ContentValues();
        Set<Map.Entry<Integer, String>> set = ENCODED_STRING_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            int field = e.getKey();
            EncodedStringValue encodedString = header.getEncodedStringValue(field);
            if (encodedString == null) continue;
            String charsetColumn = CHARSET_COLUMN_NAME_MAP.get(field);
            values.put(e.getValue(), PduPersister.toIsoString(encodedString.getTextString()));
            values.put(charsetColumn, encodedString.getCharacterSet());
        }
        set = TEXT_STRING_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            byte[] text = header.getTextString(e.getKey());
            if (text == null) continue;
            values.put(e.getValue(), PduPersister.toIsoString(text));
        }
        set = OCTET_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            int b = header.getOctet(e.getKey());
            if (b == 0) continue;
            values.put(e.getValue(), b);
        }
        set = LONG_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            long l = header.getLongInteger(e.getKey());
            if (l == -1L) continue;
            values.put((String)e.getValue(), l);
        }
        HashMap<Integer, EncodedStringValue[]> addressMap = new HashMap<Integer, EncodedStringValue[]>(ADDRESS_FIELDS.length);
        for (Object addrType : (Map.Entry<Integer, String>)ADDRESS_FIELDS) {
            EncodedStringValue[] array2 = null;
            if (addrType == 137) {
                EncodedStringValue v = header.getEncodedStringValue((int)addrType);
                if (v != null) {
                    array2 = new EncodedStringValue[]{v};
                }
            } else {
                array2 = header.getEncodedStringValues((int)addrType);
            }
            addressMap.put((int)addrType, array2);
        }
        HashSet<String> recipients = new HashSet<String>();
        int msgType = pdu.getMessageType();
        if (msgType == 130 || msgType == 132 || msgType == 128) {
            switch (msgType) {
                case 130: 
                case 132: {
                    this.loadRecipients(137, recipients, addressMap, false);
                    if (!groupMmsEnabled) break;
                    this.loadRecipients(151, recipients, addressMap, true);
                    this.loadRecipients(130, recipients, addressMap, true);
                    break;
                }
                case 128: {
                    this.loadRecipients(151, recipients, addressMap, false);
                }
            }
            long threadId = 0L;
            if (createThreadId && !recipients.isEmpty()) {
                threadId = Telephony.Threads.getOrCreateThreadId(this.mContext, recipients);
            }
            values.put("thread_id", threadId);
        }
        long dummyId = System.currentTimeMillis();
        boolean textOnly = true;
        int messageSize = 0;
        if (pdu instanceof MultimediaMessagePdu && (body = ((MultimediaMessagePdu)pdu).getBody()) != null) {
            int partsNum = body.getPartsNum();
            if (partsNum > 2) {
                textOnly = false;
            }
            for (int i = 0; i < partsNum; ++i) {
                PduPart part = body.getPart(i);
                messageSize += part.getDataLength();
                this.persistPart(part, dummyId, preOpenedFiles);
                String contentType = PduPersister.getPartContentType(part);
                if (contentType == null || "application/smil".equals(contentType) || "text/plain".equals(contentType)) continue;
                textOnly = false;
            }
        }
        values.put("text_only", textOnly ? 1 : 0);
        if (values.getAsInteger("m_size") == null) {
            values.put("m_size", messageSize);
        }
        Uri res = null;
        if (existingUri) {
            res = uri;
            SqliteWrapper.update(this.mContext, this.mContentResolver, res, values, null, null);
        } else {
            res = SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, values);
            if (res == null) {
                throw new MmsException("persist() failed: return null.");
            }
            msgId = ContentUris.parseId(res);
        }
        values = new ContentValues(1);
        values.put("mid", msgId);
        SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + dummyId + "/part"), values, null, null);
        if (!existingUri) {
            res = Uri.parse(uri + "/" + msgId);
        }
        for (int addrType : ADDRESS_FIELDS) {
            EncodedStringValue[] array3 = addressMap.get(addrType);
            if (array3 == null) continue;
            this.persistAddress(msgId, addrType, array3);
        }
        return res;
    }

    private void loadRecipients(int addressType, HashSet<String> recipients, HashMap<Integer, EncodedStringValue[]> addressMap, boolean excludeMyNumber) {
        EncodedStringValue[] array2 = addressMap.get(addressType);
        if (array2 == null) {
            return;
        }
        if (excludeMyNumber && array2.length == 1) {
            return;
        }
        SubscriptionManager subscriptionManager = SubscriptionManager.from(this.mContext);
        HashSet<String> myPhoneNumbers = new HashSet<String>();
        if (excludeMyNumber) {
            for (int subid : subscriptionManager.getActiveSubscriptionIdList()) {
                String myNumber = this.mTelephonyManager.getLine1Number(subid);
                if (myNumber == null) continue;
                myPhoneNumbers.add(myNumber);
            }
        }
        block1: for (EncodedStringValue v : array2) {
            if (v == null) continue;
            String number = v.getString();
            if (excludeMyNumber) {
                for (String myNumber : myPhoneNumbers) {
                    if (PhoneNumberUtils.compare(number, myNumber) || recipients.contains(number)) continue;
                    recipients.add(number);
                    continue block1;
                }
                continue;
            }
            if (recipients.contains(number)) continue;
            recipients.add(number);
        }
    }

    public Uri move(Uri from, Uri to) throws MmsException {
        long msgId = ContentUris.parseId(from);
        if (msgId == -1L) {
            throw new MmsException("Error! ID of the message: -1.");
        }
        Integer msgBox = MESSAGE_BOX_MAP.get(to);
        if (msgBox == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        ContentValues values = new ContentValues(1);
        values.put("msg_box", msgBox);
        SqliteWrapper.update(this.mContext, this.mContentResolver, from, values, null, null);
        return ContentUris.withAppendedId(to, msgId);
    }

    public static String toIsoString(byte[] bytes) {
        try {
            return new String(bytes, "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "ISO_8859_1 must be supported!", e);
            return "";
        }
    }

    public static byte[] getBytes(String data) {
        try {
            return data.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "ISO_8859_1 must be supported!", e);
            return new byte[0];
        }
    }

    public void release() {
        Uri uri = Uri.parse(TEMPORARY_DRM_OBJECT_URI);
        SqliteWrapper.delete(this.mContext, this.mContentResolver, uri, null, null);
    }

    public Cursor getPendingMessages(long dueTime) {
        Uri.Builder uriBuilder = Telephony.MmsSms.PendingMessages.CONTENT_URI.buildUpon();
        uriBuilder.appendQueryParameter("protocol", "mms");
        String selection = "err_type < ? AND due_time <= ?";
        String[] selectionArgs = new String[]{String.valueOf(10), String.valueOf(dueTime)};
        return SqliteWrapper.query(this.mContext, this.mContentResolver, uriBuilder.build(), null, selection, selectionArgs, "due_time");
    }

    static {
        ADDRESS_FIELDS = new int[]{129, 130, 137, 151};
        PDU_PROJECTION = new String[]{"_id", "msg_box", "thread_id", "retr_txt", "sub", "ct_l", "ct_t", "m_cls", "m_id", "resp_txt", "tr_id", "ct_cls", "d_rpt", "m_type", "v", "pri", "rr", "read_status", "rpt_a", "retr_st", "st", "date", "d_tm", "exp", "m_size", "sub_cs", "retr_txt_cs"};
        PART_PROJECTION = new String[]{"_id", "chset", "cd", "cid", "cl", "ct", "fn", "name", "text"};
        MESSAGE_BOX_MAP = new HashMap();
        MESSAGE_BOX_MAP.put(Telephony.Mms.Inbox.CONTENT_URI, 1);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Sent.CONTENT_URI, 2);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Draft.CONTENT_URI, 3);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Outbox.CONTENT_URI, 4);
        CHARSET_COLUMN_INDEX_MAP = new HashMap();
        CHARSET_COLUMN_INDEX_MAP.put(150, 25);
        CHARSET_COLUMN_INDEX_MAP.put(154, 26);
        CHARSET_COLUMN_NAME_MAP = new HashMap();
        CHARSET_COLUMN_NAME_MAP.put(150, "sub_cs");
        CHARSET_COLUMN_NAME_MAP.put(154, "retr_txt_cs");
        ENCODED_STRING_COLUMN_INDEX_MAP = new HashMap();
        ENCODED_STRING_COLUMN_INDEX_MAP.put(154, 3);
        ENCODED_STRING_COLUMN_INDEX_MAP.put(150, 4);
        ENCODED_STRING_COLUMN_NAME_MAP = new HashMap();
        ENCODED_STRING_COLUMN_NAME_MAP.put(154, "retr_txt");
        ENCODED_STRING_COLUMN_NAME_MAP.put(150, "sub");
        TEXT_STRING_COLUMN_INDEX_MAP = new HashMap();
        TEXT_STRING_COLUMN_INDEX_MAP.put(131, 5);
        TEXT_STRING_COLUMN_INDEX_MAP.put(132, 6);
        TEXT_STRING_COLUMN_INDEX_MAP.put(138, 7);
        TEXT_STRING_COLUMN_INDEX_MAP.put(139, 8);
        TEXT_STRING_COLUMN_INDEX_MAP.put(147, 9);
        TEXT_STRING_COLUMN_INDEX_MAP.put(152, 10);
        TEXT_STRING_COLUMN_NAME_MAP = new HashMap();
        TEXT_STRING_COLUMN_NAME_MAP.put(131, "ct_l");
        TEXT_STRING_COLUMN_NAME_MAP.put(132, "ct_t");
        TEXT_STRING_COLUMN_NAME_MAP.put(138, "m_cls");
        TEXT_STRING_COLUMN_NAME_MAP.put(139, "m_id");
        TEXT_STRING_COLUMN_NAME_MAP.put(147, "resp_txt");
        TEXT_STRING_COLUMN_NAME_MAP.put(152, "tr_id");
        OCTET_COLUMN_INDEX_MAP = new HashMap();
        OCTET_COLUMN_INDEX_MAP.put(186, 11);
        OCTET_COLUMN_INDEX_MAP.put(134, 12);
        OCTET_COLUMN_INDEX_MAP.put(140, 13);
        OCTET_COLUMN_INDEX_MAP.put(141, 14);
        OCTET_COLUMN_INDEX_MAP.put(143, 15);
        OCTET_COLUMN_INDEX_MAP.put(144, 16);
        OCTET_COLUMN_INDEX_MAP.put(155, 17);
        OCTET_COLUMN_INDEX_MAP.put(145, 18);
        OCTET_COLUMN_INDEX_MAP.put(153, 19);
        OCTET_COLUMN_INDEX_MAP.put(149, 20);
        OCTET_COLUMN_NAME_MAP = new HashMap();
        OCTET_COLUMN_NAME_MAP.put(186, "ct_cls");
        OCTET_COLUMN_NAME_MAP.put(134, "d_rpt");
        OCTET_COLUMN_NAME_MAP.put(140, "m_type");
        OCTET_COLUMN_NAME_MAP.put(141, "v");
        OCTET_COLUMN_NAME_MAP.put(143, "pri");
        OCTET_COLUMN_NAME_MAP.put(144, "rr");
        OCTET_COLUMN_NAME_MAP.put(155, "read_status");
        OCTET_COLUMN_NAME_MAP.put(145, "rpt_a");
        OCTET_COLUMN_NAME_MAP.put(153, "retr_st");
        OCTET_COLUMN_NAME_MAP.put(149, "st");
        LONG_COLUMN_INDEX_MAP = new HashMap();
        LONG_COLUMN_INDEX_MAP.put(133, 21);
        LONG_COLUMN_INDEX_MAP.put(135, 22);
        LONG_COLUMN_INDEX_MAP.put(136, 23);
        LONG_COLUMN_INDEX_MAP.put(142, 24);
        LONG_COLUMN_NAME_MAP = new HashMap();
        LONG_COLUMN_NAME_MAP.put(133, "date");
        LONG_COLUMN_NAME_MAP.put(135, "d_tm");
        LONG_COLUMN_NAME_MAP.put(136, "exp");
        LONG_COLUMN_NAME_MAP.put(142, "m_size");
        PDU_CACHE_INSTANCE = PduCache.getInstance();
    }
}

