/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

public final class CloseGuard {
    private static final CloseGuard NOOP = new CloseGuard();
    private static volatile boolean ENABLED = true;
    private static volatile Reporter REPORTER = new DefaultReporter();
    private static final DefaultTracker DEFAULT_TRACKER = new DefaultTracker();
    private static volatile Tracker currentTracker = DEFAULT_TRACKER;
    private Throwable allocationSite;

    public static CloseGuard get() {
        if (!ENABLED) {
            return NOOP;
        }
        return new CloseGuard();
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static void setReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter == null");
        }
        REPORTER = reporter;
    }

    public static Reporter getReporter() {
        return REPORTER;
    }

    public static void setTracker(Tracker tracker) {
        if (tracker == null) {
            throw new NullPointerException("tracker == null");
        }
        currentTracker = tracker;
    }

    public static Tracker getTracker() {
        return currentTracker;
    }

    private CloseGuard() {
    }

    public void open(String closer) {
        if (closer == null) {
            throw new NullPointerException("closer == null");
        }
        if (this == NOOP || !ENABLED) {
            return;
        }
        String message = "Explicit termination method '" + closer + "' not called";
        this.allocationSite = new Throwable(message);
        currentTracker.open(this.allocationSite);
    }

    public void close() {
        currentTracker.close(this.allocationSite);
        this.allocationSite = null;
    }

    public void warnIfOpen() {
        if (this.allocationSite == null || !ENABLED) {
            return;
        }
        String message = "A resource was acquired at attached stack trace but never released. See java.io.Closeable for information on avoiding resource leaks.";
        REPORTER.report(message, this.allocationSite);
    }

    private static final class DefaultReporter
    implements Reporter {
        private DefaultReporter() {
        }

        @Override
        public void report(String message, Throwable allocationSite) {
            System.logW((String)message, (Throwable)allocationSite);
        }
    }

    public static interface Reporter {
        public void report(String var1, Throwable var2);
    }

    private static final class DefaultTracker
    implements Tracker {
        private DefaultTracker() {
        }

        @Override
        public void open(Throwable allocationSite) {
        }

        @Override
        public void close(Throwable allocationSite) {
        }
    }

    public static interface Tracker {
        public void open(Throwable var1);

        public void close(Throwable var1);
    }
}

