/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import dalvik.system.profiler.AsciiHprofWriter;
import dalvik.system.profiler.BinaryHprof;
import dalvik.system.profiler.BinaryHprofReader;
import dalvik.system.profiler.HprofData;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class HprofBinaryToAscii {
    public static void main(String[] args) {
        System.exit(HprofBinaryToAscii.convert(args) ? 0 : 1);
    }

    private static boolean convert(String[] args) {
        HprofData hprofData;
        if (args.length != 1) {
            HprofBinaryToAscii.usage("binary hprof file argument expected");
            return false;
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            HprofBinaryToAscii.usage("file " + file + " does not exist");
            return false;
        }
        if (HprofBinaryToAscii.startsWithMagic(file)) {
            HprofData hprofData2;
            try {
                hprofData2 = HprofBinaryToAscii.readHprof(file);
            }
            catch (IOException e) {
                System.out.println("Problem reading binary hprof data from " + file + ": " + e.getMessage());
                return false;
            }
            return HprofBinaryToAscii.write(hprofData2);
        }
        try {
            hprofData = HprofBinaryToAscii.readSnapshot(file);
        }
        catch (IOException e) {
            System.out.println("Problem reading snapshot containing binary hprof data from " + file + ": " + e.getMessage());
            return false;
        }
        return HprofBinaryToAscii.write(hprofData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean startsWithMagic(File file) {
        DataInputStream inputStream = null;
        try {
            inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            boolean bl = BinaryHprof.readMagic(inputStream) != null;
            HprofBinaryToAscii.closeQuietly(inputStream);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            HprofBinaryToAscii.closeQuietly(inputStream);
        }
    }

    private static HprofData readHprof(File file) throws IOException {
        HprofData hprofData;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            hprofData = HprofBinaryToAscii.read(inputStream);
        }
        catch (Throwable throwable) {
            HprofBinaryToAscii.closeQuietly(inputStream);
            throw throwable;
        }
        HprofBinaryToAscii.closeQuietly(inputStream);
        return hprofData;
    }

    private static HprofData readSnapshot(File file) throws IOException {
        HprofData hprofData;
        BufferedInputStream inputStream = null;
        try {
            int ch;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            while ((ch = ((InputStream)inputStream).read()) != -1) {
                if (ch != 10 || ((InputStream)inputStream).read() != 10) continue;
                hprofData = HprofBinaryToAscii.read(inputStream);
            }
        }
        catch (Throwable throwable) {
            HprofBinaryToAscii.closeQuietly(inputStream);
            throw throwable;
        }
        {
            HprofBinaryToAscii.closeQuietly(inputStream);
            return hprofData;
        }
        throw new EOFException("Could not find expected header");
    }

    private static HprofData read(InputStream inputStream) throws IOException {
        BinaryHprofReader reader = new BinaryHprofReader(inputStream);
        reader.setStrict(false);
        reader.read();
        return reader.getHprofData();
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean write(HprofData hprofData) {
        try {
            AsciiHprofWriter.write(hprofData, System.out);
        }
        catch (IOException e) {
            System.out.println("Problem writing ASCII hprof data: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static void usage(String error) {
        System.out.print("ERROR: ");
        System.out.println(error);
        System.out.println();
        System.out.println("usage: HprofBinaryToAscii <binary-hprof-file>");
        System.out.println();
        System.out.println("Reads a binary hprof file and print it in ASCII format");
    }
}

