/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import android.system.Os;
import android.system.OsConstants;
import dalvik.system.VMRuntime;
import java.lang.ref.FinalizerReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.util.EmptyArray;

public final class Daemons {
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final long MAX_FINALIZE_NANOS = 10000000000L;

    public static void start() {
        ReferenceQueueDaemon.INSTANCE.start();
        FinalizerDaemon.INSTANCE.start();
        FinalizerWatchdogDaemon.INSTANCE.start();
        HeapTaskDaemon.INSTANCE.start();
    }

    public static void startPostZygoteFork() {
        ReferenceQueueDaemon.INSTANCE.startPostZygoteFork();
        FinalizerDaemon.INSTANCE.startPostZygoteFork();
        FinalizerWatchdogDaemon.INSTANCE.startPostZygoteFork();
        HeapTaskDaemon.INSTANCE.startPostZygoteFork();
    }

    public static void stop() {
        HeapTaskDaemon.INSTANCE.stop();
        ReferenceQueueDaemon.INSTANCE.stop();
        FinalizerDaemon.INSTANCE.stop();
        FinalizerWatchdogDaemon.INSTANCE.stop();
    }

    public static void requestHeapTrim() {
        VMRuntime.getRuntime().requestHeapTrim();
    }

    public static void requestGC() {
        VMRuntime.getRuntime().requestConcurrentGC();
    }

    private static class HeapTaskDaemon
    extends Daemon {
        private static final HeapTaskDaemon INSTANCE = new HeapTaskDaemon();

        HeapTaskDaemon() {
            super("HeapTaskDaemon");
        }

        @Override
        public synchronized void interrupt(Thread thread) {
            VMRuntime.getRuntime().stopHeapTaskProcessor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInternal() {
            HeapTaskDaemon heapTaskDaemon = this;
            synchronized (heapTaskDaemon) {
                if (this.isRunning()) {
                    VMRuntime.getRuntime().startHeapTaskProcessor();
                }
            }
            VMRuntime.getRuntime().runHeapTasks();
        }
    }

    private static class FinalizerWatchdogDaemon
    extends Daemon {
        private static final FinalizerWatchdogDaemon INSTANCE = new FinalizerWatchdogDaemon();
        private boolean needToWork = true;

        FinalizerWatchdogDaemon() {
            super("FinalizerWatchdogDaemon");
        }

        @Override
        public void runInternal() {
            while (this.isRunning()) {
                Object finalizing;
                if (!this.sleepUntilNeeded() || (finalizing = this.waitForFinalization()) == null || VMRuntime.getRuntime().isDebuggerActive()) continue;
                FinalizerWatchdogDaemon.finalizerTimedOut(finalizing);
                break;
            }
        }

        private synchronized boolean sleepUntilNeeded() {
            while (!this.needToWork) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
                catch (OutOfMemoryError e) {
                    return false;
                }
            }
            return true;
        }

        private synchronized void goToSleep() {
            this.needToWork = false;
        }

        private synchronized void wakeUp() {
            this.needToWork = true;
            this.notify();
        }

        private synchronized boolean getNeedToWork() {
            return this.needToWork;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean sleepFor(long durationNanos) {
            long startNanos = System.nanoTime();
            long elapsedNanos;
            long sleepNanos;
            long sleepMills;
            while ((sleepMills = (sleepNanos = durationNanos - (elapsedNanos = System.nanoTime() - startNanos)) / 1000000L) > 0L) {
                try {
                    Thread.sleep(sleepMills);
                    continue;
                }
                catch (InterruptedException e) {
                    if (this.isRunning()) continue;
                    return false;
                }
                catch (OutOfMemoryError ignored) {
                    if (!this.isRunning()) return false;
                    continue;
                }
                break;
            }
            return true;
        }

        private Object waitForFinalization() {
            long startCount = FinalizerDaemon.INSTANCE.progressCounter.get();
            if (!this.sleepFor(10000000000L)) {
                return null;
            }
            if (this.getNeedToWork() && (long)FinalizerDaemon.INSTANCE.progressCounter.get() == startCount) {
                Object finalizing = FinalizerDaemon.INSTANCE.finalizingObject;
                this.sleepFor(500000000L);
                if (this.getNeedToWork() && (long)FinalizerDaemon.INSTANCE.progressCounter.get() == startCount) {
                    return finalizing;
                }
            }
            return null;
        }

        private static void finalizerTimedOut(Object object) {
            String message = object.getClass().getName() + ".finalize() timed out after " + 10L + " seconds";
            TimeoutException syntheticException = new TimeoutException(message);
            syntheticException.setStackTrace(FinalizerDaemon.INSTANCE.getStackTrace());
            Thread.UncaughtExceptionHandler h = Thread.getDefaultUncaughtExceptionHandler();
            try {
                Os.kill(Os.getpid(), OsConstants.SIGQUIT);
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                System.logE((String)"failed to send SIGQUIT", (Throwable)e);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            if (h == null) {
                System.logE((String)message, (Throwable)syntheticException);
                System.exit(2);
            }
            h.uncaughtException(Thread.currentThread(), syntheticException);
        }
    }

    private static class FinalizerDaemon
    extends Daemon {
        private static final FinalizerDaemon INSTANCE = new FinalizerDaemon();
        private final ReferenceQueue<Object> queue = FinalizerReference.queue;
        private final AtomicInteger progressCounter = new AtomicInteger(0);
        private Object finalizingObject = null;

        FinalizerDaemon() {
            super("FinalizerDaemon");
        }

        @Override
        public void runInternal() {
            int localProgressCounter = this.progressCounter.get();
            while (this.isRunning()) {
                try {
                    FinalizerReference finalizingReference = (FinalizerReference)this.queue.poll();
                    if (finalizingReference != null) {
                        this.finalizingObject = finalizingReference.get();
                        this.progressCounter.lazySet(++localProgressCounter);
                    } else {
                        this.finalizingObject = null;
                        this.progressCounter.lazySet(++localProgressCounter);
                        FinalizerWatchdogDaemon.INSTANCE.goToSleep();
                        finalizingReference = (FinalizerReference)this.queue.remove();
                        this.finalizingObject = finalizingReference.get();
                        this.progressCounter.set(++localProgressCounter);
                        FinalizerWatchdogDaemon.INSTANCE.wakeUp();
                    }
                    this.doFinalize(finalizingReference);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (OutOfMemoryError outOfMemoryError) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FindBugsSuppressWarnings(value={"FI_EXPLICIT_INVOCATION"})
        private void doFinalize(FinalizerReference<?> reference) {
            FinalizerReference.remove(reference);
            Object object = reference.get();
            reference.clear();
            try {
                object.finalize();
            }
            catch (Throwable ex) {
                System.logE((String)"Uncaught exception thrown by finalizer", (Throwable)ex);
            }
            finally {
                this.finalizingObject = null;
            }
        }
    }

    private static class ReferenceQueueDaemon
    extends Daemon {
        private static final ReferenceQueueDaemon INSTANCE = new ReferenceQueueDaemon();

        ReferenceQueueDaemon() {
            super("ReferenceQueueDaemon");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void runInternal() {
            while (this.isRunning()) {
                Reference list;
                try {
                    Class<ReferenceQueue> clazz = ReferenceQueue.class;
                    // MONITORENTER : java.lang.ref.ReferenceQueue.class
                    while (ReferenceQueue.unenqueued == null) {
                        ReferenceQueue.class.wait();
                    }
                    list = ReferenceQueue.unenqueued;
                    ReferenceQueue.unenqueued = null;
                    // MONITOREXIT : clazz
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (OutOfMemoryError e) {
                    continue;
                }
                ReferenceQueue.enqueuePending((Reference)list);
            }
        }
    }

    private static abstract class Daemon
    implements Runnable {
        private Thread thread;
        private String name;
        private boolean postZygoteFork;

        protected Daemon(String name) {
            this.name = name;
        }

        public synchronized void start() {
            this.startInternal();
        }

        public synchronized void startPostZygoteFork() {
            this.postZygoteFork = true;
            this.startInternal();
        }

        public void startInternal() {
            if (this.thread != null) {
                throw new IllegalStateException("already running");
            }
            this.thread = new Thread(ThreadGroup.systemThreadGroup, this, this.name);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        @Override
        public void run() {
            if (this.postZygoteFork) {
                VMRuntime.getRuntime();
                VMRuntime.setSystemDaemonThreadPriority();
            }
            this.runInternal();
        }

        public abstract void runInternal();

        protected synchronized boolean isRunning() {
            return this.thread != null;
        }

        public synchronized void interrupt() {
            this.interrupt(this.thread);
        }

        public synchronized void interrupt(Thread thread) {
            if (thread == null) {
                throw new IllegalStateException("not running");
            }
            thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Thread threadToStop;
            Daemon daemon = this;
            synchronized (daemon) {
                threadToStop = this.thread;
                this.thread = null;
            }
            if (threadToStop == null) {
                throw new IllegalStateException("not running");
            }
            this.interrupt(threadToStop);
            while (true) {
                try {
                    threadToStop.join();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    continue;
                }
                break;
            }
        }

        public synchronized StackTraceElement[] getStackTrace() {
            return this.thread != null ? this.thread.getStackTrace() : EmptyArray.STACK_TRACE_ELEMENT;
        }
    }
}

