/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.annotation.optimization.FastNative;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import libcore.util.CharsetUtils;
import libcore.util.EmptyArray;

public final class StringFactory {
    private static final char REPLACEMENT_CHAR = '\ufffd';

    public static String newEmptyString() {
        return StringFactory.newStringFromChars(EmptyArray.CHAR, 0, 0);
    }

    public static String newStringFromBytes(byte[] data) {
        return StringFactory.newStringFromBytes(data, 0, data.length);
    }

    public static String newStringFromBytes(byte[] data, int high) {
        return StringFactory.newStringFromBytes(data, high, 0, data.length);
    }

    public static String newStringFromBytes(byte[] data, int offset, int byteCount) {
        return StringFactory.newStringFromBytes(data, offset, byteCount, Charset.defaultCharset());
    }

    @FastNative
    public static native String newStringFromBytes(byte[] var0, int var1, int var2, int var3);

    public static String newStringFromBytes(byte[] data, int offset, int byteCount, String charsetName) throws UnsupportedEncodingException {
        return StringFactory.newStringFromBytes(data, offset, byteCount, Charset.forNameUEE((String)charsetName));
    }

    public static String newStringFromBytes(byte[] data, String charsetName) throws UnsupportedEncodingException {
        return StringFactory.newStringFromBytes(data, 0, data.length, Charset.forNameUEE((String)charsetName));
    }

    public static String newStringFromBytes(byte[] data, int offset, int byteCount, Charset charset) {
        int length;
        char[] value;
        if ((offset | byteCount) < 0 || byteCount > data.length - offset) {
            throw new StringIndexOutOfBoundsException(data.length, offset, byteCount);
        }
        String canonicalCharsetName = charset.name();
        if (canonicalCharsetName.equals("UTF-8")) {
            byte[] d = data;
            char[] v = new char[byteCount];
            int idx = offset;
            int last = offset + byteCount;
            int s = 0;
            block0: while (idx < last) {
                byte b0;
                if (((b0 = d[idx++]) & 0x80) == 0) {
                    int val = b0 & 0xFF;
                    v[s++] = (char)val;
                    continue;
                }
                if ((b0 & 0xE0) == 192 || (b0 & 0xF0) == 224 || (b0 & 0xF8) == 240 || (b0 & 0xFC) == 248 || (b0 & 0xFE) == 252) {
                    int utfCount = 1;
                    if ((b0 & 0xF0) == 224) {
                        utfCount = 2;
                    } else if ((b0 & 0xF8) == 240) {
                        utfCount = 3;
                    } else if ((b0 & 0xFC) == 248) {
                        utfCount = 4;
                    } else if ((b0 & 0xFE) == 252) {
                        utfCount = 5;
                    }
                    if (idx + utfCount > last) {
                        v[s++] = 65533;
                        continue;
                    }
                    int val = b0 & 31 >> utfCount - 1;
                    for (int i = 0; i < utfCount; ++i) {
                        byte b;
                        if (((b = d[idx++]) & 0xC0) != 128) {
                            v[s++] = 65533;
                            --idx;
                            continue block0;
                        }
                        val <<= 6;
                        val |= b & 0x3F;
                    }
                    if (utfCount != 2 && val >= 55296 && val <= 57343) {
                        v[s++] = 65533;
                        continue;
                    }
                    if (val > 0x10FFFF) {
                        v[s++] = 65533;
                        continue;
                    }
                    if (val < 65536) {
                        v[s++] = (char)val;
                        continue;
                    }
                    int x = val & 0xFFFF;
                    int u = val >> 16 & 0x1F;
                    int w = u - 1 & 0xFFFF;
                    int hi = 0xD800 | w << 6 | x >> 10;
                    int lo = 0xDC00 | x & 0x3FF;
                    v[s++] = (char)hi;
                    v[s++] = (char)lo;
                    continue;
                }
                v[s++] = 65533;
            }
            if (s == byteCount) {
                value = v;
                length = s;
            } else {
                value = new char[s];
                length = s;
                System.arraycopy((char[])v, (int)0, (char[])value, (int)0, (int)s);
            }
        } else if (canonicalCharsetName.equals("ISO-8859-1")) {
            value = new char[byteCount];
            length = byteCount;
            CharsetUtils.isoLatin1BytesToChars(data, offset, byteCount, value);
        } else if (canonicalCharsetName.equals("US-ASCII")) {
            value = new char[byteCount];
            length = byteCount;
            CharsetUtils.asciiBytesToChars(data, offset, byteCount, value);
        } else {
            CharBuffer cb = charset.decode(ByteBuffer.wrap(data, offset, byteCount));
            length = cb.length();
            if (length > 0) {
                value = new char[length];
                System.arraycopy((char[])cb.array(), (int)0, (char[])value, (int)0, (int)length);
            } else {
                value = EmptyArray.CHAR;
            }
        }
        return StringFactory.newStringFromChars(value, 0, length);
    }

    public static String newStringFromBytes(byte[] data, Charset charset) {
        return StringFactory.newStringFromBytes(data, 0, data.length, charset);
    }

    public static String newStringFromChars(char[] data) {
        return StringFactory.newStringFromChars(data, 0, data.length);
    }

    public static String newStringFromChars(char[] data, int offset, int charCount) {
        if ((offset | charCount) < 0 || charCount > data.length - offset) {
            throw new StringIndexOutOfBoundsException(data.length, offset, charCount);
        }
        return StringFactory.newStringFromChars(offset, charCount, data);
    }

    @FastNative
    static native String newStringFromChars(int var0, int var1, char[] var2);

    @FastNative
    public static native String newStringFromString(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String newStringFromStringBuffer(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            return StringFactory.newStringFromChars(stringBuffer.getValue(), 0, stringBuffer.length());
        }
    }

    public static String newStringFromCodePoints(int[] codePoints, int offset, int count) {
        if (codePoints == null) {
            throw new NullPointerException("codePoints == null");
        }
        if ((offset | count) < 0 || count > codePoints.length - offset) {
            throw new StringIndexOutOfBoundsException(codePoints.length, offset, count);
        }
        char[] value = new char[count * 2];
        int end = offset + count;
        int length = 0;
        for (int i = offset; i < end; ++i) {
            length += Character.toChars(codePoints[i], value, length);
        }
        return StringFactory.newStringFromChars(value, 0, length);
    }

    public static String newStringFromStringBuilder(StringBuilder stringBuilder) {
        return StringFactory.newStringFromChars(stringBuilder.getValue(), 0, stringBuilder.length());
    }
}

