/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.shared2;

import libcore.tzdata.shared2.DistroVersion;

public class StagedDistroOperation {
    private static final StagedDistroOperation UNINSTALL_STAGED = new StagedDistroOperation(true, null);
    public final boolean isUninstall;
    public final DistroVersion distroVersion;

    private StagedDistroOperation(boolean isUninstall, DistroVersion distroVersion) {
        this.isUninstall = isUninstall;
        this.distroVersion = distroVersion;
    }

    public static StagedDistroOperation install(DistroVersion distroVersion) {
        if (distroVersion == null) {
            throw new NullPointerException("distroVersion==null");
        }
        return new StagedDistroOperation(false, distroVersion);
    }

    public static StagedDistroOperation uninstall() {
        return UNINSTALL_STAGED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagedDistroOperation that = (StagedDistroOperation)o;
        if (this.isUninstall != that.isUninstall) {
            return false;
        }
        return this.distroVersion != null ? this.distroVersion.equals(that.distroVersion) : that.distroVersion == null;
    }

    public int hashCode() {
        int result = this.isUninstall ? 1 : 0;
        result = 31 * result + (this.distroVersion != null ? this.distroVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StagedDistroOperation{isUninstall=" + this.isUninstall + ", distroVersion=" + this.distroVersion + '}';
    }
}

