/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatResources;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.ResourcesKey;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import com.android.internal.util.ArrayUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Predicate;

public class ResourcesManager {
    static final String TAG = "ResourcesManager";
    private static final boolean DEBUG = false;
    private static ResourcesManager sResourcesManager;
    private static final Predicate<WeakReference<Resources>> sEmptyReferencePredicate;
    private CompatibilityInfo mResCompatibilityInfo;
    private final Configuration mResConfiguration = new Configuration();
    private final ArrayMap<ResourcesKey, WeakReference<ResourcesImpl>> mResourceImpls = new ArrayMap();
    private final ArrayList<WeakReference<Resources>> mResourceReferences = new ArrayList();
    private final WeakHashMap<IBinder, ActivityResources> mActivityResourceReferences = new WeakHashMap();
    private final ArrayMap<Pair<Integer, DisplayAdjustments>, WeakReference<Display>> mAdjustedDisplays = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourcesManager getInstance() {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            if (sResourcesManager == null) {
                sResourcesManager = new ResourcesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourcesManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePath(String path) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            int count = 0;
            int i = 0;
            while (i < this.mResourceImpls.size()) {
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                if (key.isPathReferenced(path)) {
                    this.cleanupResourceImpl(key);
                    ++count;
                    continue;
                }
                ++i;
            }
            Log.i(TAG, "Invalidated " + count + " asset managers that referenced " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            return this.mResConfiguration;
        }
    }

    DisplayMetrics getDisplayMetrics() {
        return this.getDisplayMetrics(0, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    protected DisplayMetrics getDisplayMetrics(int displayId, DisplayAdjustments da) {
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getAdjustedDisplay(displayId, da);
        if (display != null) {
            display.getMetrics(dm);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private static void applyNonDefaultDisplayMetricsToConfiguration(DisplayMetrics dm, Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = config.screenWidthDp;
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    public boolean applyCompatConfigurationLocked(int displayDensity, Configuration compatConfiguration) {
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Display getAdjustedDisplay(int displayId, DisplayAdjustments displayAdjustments) {
        DisplayAdjustments displayAdjustmentsCopy = displayAdjustments != null ? new DisplayAdjustments(displayAdjustments) : new DisplayAdjustments();
        Pair<Integer, DisplayAdjustments> key = Pair.create(displayId, displayAdjustmentsCopy);
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            Display display;
            WeakReference<Display> wd = this.mAdjustedDisplays.get(key);
            if (wd != null && (display = (Display)wd.get()) != null) {
                return display;
            }
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            Display display2 = dm.getCompatibleDisplay(displayId, (DisplayAdjustments)key.second);
            if (display2 != null) {
                this.mAdjustedDisplays.put(key, new WeakReference<Display>(display2));
            }
            return display2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display getAdjustedDisplay(int displayId, Resources resources) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            return dm.getCompatibleDisplay(displayId, resources);
        }
    }

    private void cleanupResourceImpl(ResourcesKey removedKey) {
        ResourcesImpl res = (ResourcesImpl)this.mResourceImpls.remove(removedKey).get();
        if (res != null) {
            res.flushLayoutCache();
        }
    }

    protected AssetManager createAssetManager(ResourcesKey key) {
        AssetManager assets = new AssetManager();
        if (key.mResDir != null && assets.addAssetPath(key.mResDir) == 0) {
            Log.e(TAG, "failed to add asset path " + key.mResDir);
            return null;
        }
        if (key.mSplitResDirs != null) {
            for (String splitResDir : key.mSplitResDirs) {
                if (assets.addAssetPath(splitResDir) != 0) continue;
                Log.e(TAG, "failed to add split asset path " + splitResDir);
                return null;
            }
        }
        if (key.mOverlayDirs != null) {
            for (String idmapPath : key.mOverlayDirs) {
                assets.addOverlayPath(idmapPath);
            }
        }
        if (key.mLibDirs != null) {
            for (String libDir : key.mLibDirs) {
                if (!libDir.endsWith(".apk") || assets.addAssetPathAsSharedLibrary(libDir) != 0) continue;
                Log.w(TAG, "Asset path '" + libDir + "' does not exist or contains no resources.");
            }
        }
        return assets;
    }

    private Configuration generateConfig(ResourcesKey key, DisplayMetrics dm) {
        Configuration config;
        boolean isDefaultDisplay = key.mDisplayId == 0;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (!isDefaultDisplay || hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            if (!isDefaultDisplay) {
                ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, config);
            }
            if (hasOverrideConfig) {
                config.updateFrom(key.mOverrideConfiguration);
            }
        } else {
            config = this.getConfiguration();
        }
        return config;
    }

    private ResourcesImpl createResourcesImpl(ResourcesKey key) {
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        AssetManager assets = this.createAssetManager(key);
        if (assets == null) {
            return null;
        }
        DisplayMetrics dm = this.getDisplayMetrics(key.mDisplayId, daj);
        Configuration config = this.generateConfig(key, dm);
        ResourcesImpl impl = new ResourcesImpl(assets, dm, config, daj);
        return impl;
    }

    private ResourcesImpl findResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl;
        WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.get(key);
        ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
        if (impl != null && impl.getAssets().isUpToDate()) {
            return impl;
        }
        return null;
    }

    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl = this.findResourcesImplForKeyLocked(key);
        if (impl == null && (impl = this.createResourcesImpl(key)) != null) {
            this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(impl));
        }
        return impl;
    }

    private ResourcesKey findKeyForResourceImplLocked(ResourcesImpl resourceImpl) {
        int refCount = this.mResourceImpls.size();
        for (int i = 0; i < refCount; ++i) {
            ResourcesImpl impl;
            WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
            ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
            if (impl == null || resourceImpl != impl) continue;
            return this.mResourceImpls.keyAt(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSameResourcesOverrideConfig(IBinder activityToken, Configuration overrideConfig) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ActivityResources activityResources;
            ActivityResources activityResources2 = activityResources = activityToken != null ? this.mActivityResourceReferences.get(activityToken) : null;
            if (activityResources == null) {
                return overrideConfig == null;
            }
            return Objects.equals(activityResources.overrideConfig, overrideConfig) || overrideConfig != null && activityResources.overrideConfig != null && 0 == overrideConfig.diffPublicOnly(activityResources.overrideConfig);
        }
    }

    private ActivityResources getOrCreateActivityResourcesStructLocked(IBinder activityToken) {
        ActivityResources activityResources = this.mActivityResourceReferences.get(activityToken);
        if (activityResources == null) {
            activityResources = new ActivityResources();
            this.mActivityResourceReferences.put(activityToken, activityResources);
        }
        return activityResources;
    }

    private Resources getOrCreateResourcesForActivityLocked(IBinder activityToken, ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
        int refCount = activityResources.activityResources.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<Resources> weakResourceRef = activityResources.activityResources.get(i);
            Resources resources = (Resources)weakResourceRef.get();
            if (resources == null || !Objects.equals(resources.getClassLoader(), classLoader) || resources.getImpl() != impl) continue;
            return resources;
        }
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        activityResources.activityResources.add(new WeakReference<Resources>(resources));
        return resources;
    }

    private Resources getOrCreateResourcesLocked(ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        int refCount = this.mResourceReferences.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<Resources> weakResourceRef = this.mResourceReferences.get(i);
            Resources resources = (Resources)weakResourceRef.get();
            if (resources == null || !Objects.equals(resources.getClassLoader(), classLoader) || resources.getImpl() != impl) continue;
            return resources;
        }
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        this.mResourceReferences.add(new WeakReference<Resources>(resources));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources createBaseActivityResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#createBaseActivityResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo);
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Object object = this;
            synchronized (object) {
                this.getOrCreateActivityResourcesStructLocked(activityToken);
            }
            this.updateResourcesForActivity(activityToken, overrideConfig, displayId, false);
            object = this.getOrCreateResources(activityToken, key, classLoader);
            return object;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resources getOrCreateResources(IBinder activityToken, ResourcesKey key, ClassLoader classLoader) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            if (activityToken != null) {
                ResourcesImpl resourcesImpl;
                ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                ArrayUtils.unstableRemoveIf(activityResources.activityResources, sEmptyReferencePredicate);
                if (key.hasOverrideConfiguration() && !activityResources.overrideConfig.equals(Configuration.EMPTY)) {
                    Configuration temp = new Configuration(activityResources.overrideConfig);
                    temp.updateFrom(key.mOverrideConfiguration);
                    key.mOverrideConfiguration.setTo(temp);
                }
                if ((resourcesImpl = this.findResourcesImplForKeyLocked(key)) != null) {
                    return this.getOrCreateResourcesForActivityLocked(activityToken, classLoader, resourcesImpl, key.mCompatInfo);
                }
            } else {
                ArrayUtils.unstableRemoveIf(this.mResourceReferences, sEmptyReferencePredicate);
                ResourcesImpl resourcesImpl = this.findResourcesImplForKeyLocked(key);
                if (resourcesImpl != null) {
                    return this.getOrCreateResourcesLocked(classLoader, resourcesImpl, key.mCompatInfo);
                }
            }
        }
        ResourcesImpl resourcesImpl = this.createResourcesImpl(key);
        if (resourcesImpl == null) {
            return null;
        }
        ResourcesManager resourcesManager2 = this;
        synchronized (resourcesManager2) {
            ResourcesImpl existingResourcesImpl = this.findResourcesImplForKeyLocked(key);
            if (existingResourcesImpl != null) {
                resourcesImpl.getAssets().close();
                resourcesImpl = existingResourcesImpl;
            } else {
                this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(resourcesImpl));
            }
            Resources resources = activityToken != null ? this.getOrCreateResourcesForActivityLocked(activityToken, classLoader, resourcesImpl, key.mCompatInfo) : this.getOrCreateResourcesLocked(classLoader, resourcesImpl, key.mCompatInfo);
            return resources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources getResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#getResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo);
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Resources resources = this.getOrCreateResources(activityToken, key, classLoader);
            return resources;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourcesForActivity(IBinder activityToken, Configuration overrideConfig, int displayId, boolean movedToDifferentDisplay) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#updateResourcesForActivity");
            ResourcesManager resourcesManager = this;
            synchronized (resourcesManager) {
                ActivityResources activityResources;
                block15: {
                    activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                    if (!Objects.equals(activityResources.overrideConfig, overrideConfig) || movedToDifferentDisplay) break block15;
                    return;
                }
                Configuration oldConfig = new Configuration(activityResources.overrideConfig);
                if (overrideConfig != null) {
                    activityResources.overrideConfig.setTo(overrideConfig);
                } else {
                    activityResources.overrideConfig.unset();
                }
                boolean activityHasOverrideConfig = !activityResources.overrideConfig.equals(Configuration.EMPTY);
                int refCount = activityResources.activityResources.size();
                for (int i = 0; i < refCount; ++i) {
                    ResourcesKey newKey;
                    ResourcesImpl resourcesImpl;
                    WeakReference<Resources> weakResRef = activityResources.activityResources.get(i);
                    Resources resources = (Resources)weakResRef.get();
                    if (resources == null) continue;
                    ResourcesKey oldKey = this.findKeyForResourceImplLocked(resources.getImpl());
                    if (oldKey == null) {
                        Slog.e(TAG, "can't find ResourcesKey for resources impl=" + resources.getImpl());
                        continue;
                    }
                    Configuration rebasedOverrideConfig = new Configuration();
                    if (overrideConfig != null) {
                        rebasedOverrideConfig.setTo(overrideConfig);
                    }
                    if (activityHasOverrideConfig && oldKey.hasOverrideConfiguration()) {
                        Configuration overrideOverrideConfig = Configuration.generateDelta(oldConfig, oldKey.mOverrideConfiguration);
                        rebasedOverrideConfig.updateFrom(overrideOverrideConfig);
                    }
                    if ((resourcesImpl = this.findResourcesImplForKeyLocked(newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayDirs, oldKey.mLibDirs, displayId, rebasedOverrideConfig, oldKey.mCompatInfo))) == null && (resourcesImpl = this.createResourcesImpl(newKey)) != null) {
                        this.mResourceImpls.put(newKey, new WeakReference<ResourcesImpl>(resourcesImpl));
                    }
                    if (resourcesImpl == null || resourcesImpl == resources.getImpl()) continue;
                    resources.setImpl(resourcesImpl);
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyConfigurationToResourcesLocked");
            if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
                boolean bl = false;
                return bl;
            }
            int changes = this.mResConfiguration.updateFrom(config);
            this.mAdjustedDisplays.clear();
            DisplayMetrics defaultDisplayMetrics = this.getDisplayMetrics();
            if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
                this.mResCompatibilityInfo = compat;
                changes |= 0xD00;
            }
            Resources.updateSystemConfiguration(config, defaultDisplayMetrics, compat);
            ApplicationPackageManager.configurationChanged();
            Configuration tmpConfig = null;
            for (int i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                ResourcesImpl r;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = r = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (r != null) {
                    int displayId = key.mDisplayId;
                    boolean isDefaultDisplay = displayId == 0;
                    DisplayMetrics dm = defaultDisplayMetrics;
                    boolean hasOverrideConfiguration = key.hasOverrideConfiguration();
                    if (!isDefaultDisplay || hasOverrideConfiguration) {
                        if (tmpConfig == null) {
                            tmpConfig = new Configuration();
                        }
                        tmpConfig.setTo(config);
                        DisplayAdjustments daj = r.getDisplayAdjustments();
                        if (compat != null) {
                            daj = new DisplayAdjustments(daj);
                            daj.setCompatibilityInfo(compat);
                        }
                        dm = this.getDisplayMetrics(displayId, daj);
                        if (!isDefaultDisplay) {
                            ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, tmpConfig);
                        }
                        if (hasOverrideConfiguration) {
                            tmpConfig.updateFrom(key.mOverrideConfiguration);
                        }
                        r.updateConfiguration(tmpConfig, dm, compat);
                        continue;
                    }
                    r.updateConfiguration(config, dm, compat);
                    continue;
                }
                this.mResourceImpls.removeAt(i);
            }
            boolean bl = changes != 0;
            return bl;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLibAssetForMainAssetPath(String assetPath, String libAsset) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || !Objects.equals(key.mResDir, assetPath) || ArrayUtils.contains(key.mLibDirs, libAsset)) continue;
                int newLibAssetCount = 1 + (key.mLibDirs != null ? key.mLibDirs.length : 0);
                String[] newLibAssets = new String[newLibAssetCount];
                if (key.mLibDirs != null) {
                    System.arraycopy(key.mLibDirs, 0, newLibAssets, 0, key.mLibDirs.length);
                }
                newLibAssets[newLibAssetCount - 1] = libAsset;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, key.mOverlayDirs, newLibAssets, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void applyNewResourceDirsLocked(String baseCodePath, String[] newResourceDirs) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyNewResourceDirsLocked");
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || key.mResDir != null && !key.mResDir.equals(baseCodePath)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, newResourceDirs, key.mLibDirs, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private void redirectResourcesToNewImplLocked(ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys) {
        if (updatedResourceKeys.isEmpty()) {
            return;
        }
        int resourcesCount = this.mResourceReferences.size();
        for (int i = 0; i < resourcesCount; ++i) {
            ResourcesKey key;
            Resources r;
            WeakReference<Resources> ref = this.mResourceReferences.get(i);
            Resources resources = r = ref != null ? (Resources)ref.get() : null;
            if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
            ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
            if (impl == null) {
                throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
            }
            r.setImpl(impl);
        }
        for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
            int resCount = activityResources.activityResources.size();
            for (int i = 0; i < resCount; ++i) {
                ResourcesKey key;
                Resources r;
                WeakReference<Resources> ref = activityResources.activityResources.get(i);
                Resources resources = r = ref != null ? (Resources)ref.get() : null;
                if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
                ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
                if (impl == null) {
                    throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
                }
                r.setImpl(impl);
            }
        }
    }

    static {
        sEmptyReferencePredicate = new Predicate<WeakReference<Resources>>(){

            @Override
            public boolean test(WeakReference<Resources> weakRef) {
                return weakRef == null || weakRef.get() == null;
            }
        };
    }

    private static class ActivityResources {
        public final Configuration overrideConfig = new Configuration();
        public final ArrayList<WeakReference<Resources>> activityResources = new ArrayList();

        private ActivityResources() {
        }
    }
}

