/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.ContextImpl;
import android.app.DownloadManager;
import android.app.IAlarmManager;
import android.app.JobSchedulerImpl;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.VrManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.app.admin.IDevicePolicyManager;
import android.app.job.IJobScheduler;
import android.app.job.JobScheduler;
import android.app.timezone.RulesManager;
import android.app.trust.TrustManager;
import android.app.usage.IStorageStatsManager;
import android.app.usage.IUsageStatsManager;
import android.app.usage.NetworkStatsManager;
import android.app.usage.StorageStatsManager;
import android.app.usage.UsageStatsManager;
import android.appwidget.AppWidgetManager;
import android.bluetooth.BluetoothManager;
import android.companion.CompanionDeviceManager;
import android.companion.ICompanionDeviceManager;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.IRestrictionsManager;
import android.content.RestrictionsManager;
import android.content.pm.IShortcutService;
import android.content.pm.LauncherApps;
import android.content.pm.ShortcutManager;
import android.content.res.Resources;
import android.hardware.ConsumerIrManager;
import android.hardware.ISerialManager;
import android.hardware.SensorManager;
import android.hardware.SerialManager;
import android.hardware.SystemSensorManager;
import android.hardware.camera2.CameraManager;
import android.hardware.display.DisplayManager;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.input.InputManager;
import android.hardware.location.ContextHubManager;
import android.hardware.radio.RadioManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbManager;
import android.location.CountryDetector;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.media.midi.IMidiManager;
import android.media.midi.MidiManager;
import android.media.projection.MediaProjectionManager;
import android.media.session.MediaSessionManager;
import android.media.soundtrigger.SoundTriggerManager;
import android.media.tv.ITvInputManager;
import android.media.tv.TvInputManager;
import android.net.ConnectivityManager;
import android.net.ConnectivityThread;
import android.net.EthernetManager;
import android.net.IConnectivityManager;
import android.net.IEthernetManager;
import android.net.IIpSecService;
import android.net.INetworkPolicyManager;
import android.net.IpSecManager;
import android.net.NetworkPolicyManager;
import android.net.NetworkScoreManager;
import android.net.lowpan.ILowpanManager;
import android.net.lowpan.LowpanManager;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdManager;
import android.net.wifi.IRttManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiScanner;
import android.net.wifi.RttManager;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.nfc.NfcManager;
import android.os.BatteryManager;
import android.os.DropBoxManager;
import android.os.HardwarePropertiesManager;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.IHardwarePropertiesManager;
import android.os.IPowerManager;
import android.os.IRecoverySystem;
import android.os.IUserManager;
import android.os.IncidentManager;
import android.os.PowerManager;
import android.os.Process;
import android.os.RecoverySystem;
import android.os.ServiceManager;
import android.os.SystemVibrator;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.os.health.SystemHealthManager;
import android.os.storage.StorageManager;
import android.print.IPrintManager;
import android.print.PrintManager;
import android.service.oemlock.IOemLockService;
import android.service.oemlock.OemLockManager;
import android.service.persistentdata.IPersistentDataBlockService;
import android.service.persistentdata.PersistentDataBlockManager;
import android.service.vr.IVrManager;
import android.telecom.TelecomManager;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.euicc.EuiccManager;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.CaptioningManager;
import android.view.autofill.AutofillManager;
import android.view.autofill.IAutoFillManager;
import android.view.inputmethod.InputMethodManager;
import android.view.textclassifier.TextClassificationManager;
import android.view.textservice.TextServicesManager;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.app.ISoundTriggerService;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PhoneLayoutInflater;
import java.util.HashMap;

final class SystemServiceRegistry {
    private static final String TAG = "SystemServiceRegistry";
    private static final HashMap<Class<?>, String> SYSTEM_SERVICE_NAMES = new HashMap();
    private static final HashMap<String, ServiceFetcher<?>> SYSTEM_SERVICE_FETCHERS = new HashMap();
    private static int sServiceCacheSize;

    private SystemServiceRegistry() {
    }

    public static Object[] createServiceCache() {
        return new Object[sServiceCacheSize];
    }

    public static Object getSystemService(ContextImpl ctx, String name) {
        ServiceFetcher<?> fetcher = SYSTEM_SERVICE_FETCHERS.get(name);
        return fetcher != null ? fetcher.getService(ctx) : null;
    }

    public static String getSystemServiceName(Class<?> serviceClass) {
        return SYSTEM_SERVICE_NAMES.get(serviceClass);
    }

    private static <T> void registerService(String serviceName, Class<T> serviceClass, ServiceFetcher<T> serviceFetcher) {
        SYSTEM_SERVICE_NAMES.put(serviceClass, serviceName);
        SYSTEM_SERVICE_FETCHERS.put(serviceName, serviceFetcher);
    }

    public static void onServiceNotFound(ServiceManager.ServiceNotFoundException e) {
        if (Process.myUid() < 10000) {
            Log.wtf(TAG, e.getMessage(), e);
        } else {
            Log.w(TAG, e.getMessage());
        }
    }

    static /* synthetic */ int access$008() {
        return sServiceCacheSize++;
    }

    static {
        SystemServiceRegistry.registerService("accessibility", AccessibilityManager.class, new CachedServiceFetcher<AccessibilityManager>(){

            @Override
            public AccessibilityManager createService(ContextImpl ctx) {
                return AccessibilityManager.getInstance(ctx);
            }
        });
        SystemServiceRegistry.registerService("captioning", CaptioningManager.class, new CachedServiceFetcher<CaptioningManager>(){

            @Override
            public CaptioningManager createService(ContextImpl ctx) {
                return new CaptioningManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("account", AccountManager.class, new CachedServiceFetcher<AccountManager>(){

            @Override
            public AccountManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("account");
                IAccountManager service = IAccountManager.Stub.asInterface(b);
                return new AccountManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("activity", ActivityManager.class, new CachedServiceFetcher<ActivityManager>(){

            @Override
            public ActivityManager createService(ContextImpl ctx) {
                return new ActivityManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("alarm", AlarmManager.class, new CachedServiceFetcher<AlarmManager>(){

            @Override
            public AlarmManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("alarm");
                IAlarmManager service = IAlarmManager.Stub.asInterface(b);
                return new AlarmManager(service, ctx);
            }
        });
        SystemServiceRegistry.registerService("audio", AudioManager.class, new CachedServiceFetcher<AudioManager>(){

            @Override
            public AudioManager createService(ContextImpl ctx) {
                return new AudioManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("media_router", MediaRouter.class, new CachedServiceFetcher<MediaRouter>(){

            @Override
            public MediaRouter createService(ContextImpl ctx) {
                return new MediaRouter(ctx);
            }
        });
        SystemServiceRegistry.registerService("bluetooth", BluetoothManager.class, new CachedServiceFetcher<BluetoothManager>(){

            @Override
            public BluetoothManager createService(ContextImpl ctx) {
                return new BluetoothManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("hdmi_control", HdmiControlManager.class, new StaticServiceFetcher<HdmiControlManager>(){

            @Override
            public HdmiControlManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("hdmi_control");
                return new HdmiControlManager(IHdmiControlService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("textclassification", TextClassificationManager.class, new CachedServiceFetcher<TextClassificationManager>(){

            @Override
            public TextClassificationManager createService(ContextImpl ctx) {
                return new TextClassificationManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("clipboard", ClipboardManager.class, new CachedServiceFetcher<ClipboardManager>(){

            @Override
            public ClipboardManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new ClipboardManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SYSTEM_SERVICE_NAMES.put(android.text.ClipboardManager.class, "clipboard");
        SystemServiceRegistry.registerService("connectivity", ConnectivityManager.class, new StaticApplicationContextServiceFetcher<ConnectivityManager>(){

            @Override
            public ConnectivityManager createService(Context context) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("connectivity");
                IConnectivityManager service = IConnectivityManager.Stub.asInterface(b);
                return new ConnectivityManager(context, service);
            }
        });
        SystemServiceRegistry.registerService("ipsec", IpSecManager.class, new StaticServiceFetcher<IpSecManager>(){

            @Override
            public IpSecManager createService() {
                IBinder b = ServiceManager.getService("ipsec");
                IIpSecService service = IIpSecService.Stub.asInterface(b);
                return new IpSecManager(service);
            }
        });
        SystemServiceRegistry.registerService("country_detector", CountryDetector.class, new StaticServiceFetcher<CountryDetector>(){

            @Override
            public CountryDetector createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("country_detector");
                return new CountryDetector(ICountryDetector.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("device_policy", DevicePolicyManager.class, new CachedServiceFetcher<DevicePolicyManager>(){

            @Override
            public DevicePolicyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("device_policy");
                return new DevicePolicyManager(ctx, IDevicePolicyManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("download", DownloadManager.class, new CachedServiceFetcher<DownloadManager>(){

            @Override
            public DownloadManager createService(ContextImpl ctx) {
                return new DownloadManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("batterymanager", BatteryManager.class, new StaticServiceFetcher<BatteryManager>(){

            @Override
            public BatteryManager createService() throws ServiceManager.ServiceNotFoundException {
                IBatteryStats stats = IBatteryStats.Stub.asInterface(ServiceManager.getServiceOrThrow("batterystats"));
                IBatteryPropertiesRegistrar registrar = IBatteryPropertiesRegistrar.Stub.asInterface(ServiceManager.getServiceOrThrow("batteryproperties"));
                return new BatteryManager(stats, registrar);
            }
        });
        SystemServiceRegistry.registerService("nfc", NfcManager.class, new CachedServiceFetcher<NfcManager>(){

            @Override
            public NfcManager createService(ContextImpl ctx) {
                return new NfcManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("dropbox", DropBoxManager.class, new CachedServiceFetcher<DropBoxManager>(){

            @Override
            public DropBoxManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("dropbox");
                IDropBoxManagerService service = IDropBoxManagerService.Stub.asInterface(b);
                return new DropBoxManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("input", InputManager.class, new StaticServiceFetcher<InputManager>(){

            @Override
            public InputManager createService() {
                return InputManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("display", DisplayManager.class, new CachedServiceFetcher<DisplayManager>(){

            @Override
            public DisplayManager createService(ContextImpl ctx) {
                return new DisplayManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("input_method", InputMethodManager.class, new StaticServiceFetcher<InputMethodManager>(){

            @Override
            public InputMethodManager createService() {
                return InputMethodManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("textservices", TextServicesManager.class, new StaticServiceFetcher<TextServicesManager>(){

            @Override
            public TextServicesManager createService() {
                return TextServicesManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("keyguard", KeyguardManager.class, new CachedServiceFetcher<KeyguardManager>(){

            @Override
            public KeyguardManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new KeyguardManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("layout_inflater", LayoutInflater.class, new CachedServiceFetcher<LayoutInflater>(){

            @Override
            public LayoutInflater createService(ContextImpl ctx) {
                return new PhoneLayoutInflater(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("location", LocationManager.class, new CachedServiceFetcher<LocationManager>(){

            @Override
            public LocationManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("location");
                return new LocationManager(ctx, ILocationManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("netpolicy", NetworkPolicyManager.class, new CachedServiceFetcher<NetworkPolicyManager>(){

            @Override
            public NetworkPolicyManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new NetworkPolicyManager(ctx, INetworkPolicyManager.Stub.asInterface(ServiceManager.getServiceOrThrow("netpolicy")));
            }
        });
        SystemServiceRegistry.registerService("notification", NotificationManager.class, new CachedServiceFetcher<NotificationManager>(){

            @Override
            public NotificationManager createService(ContextImpl ctx) {
                Context outerContext = ctx.getOuterContext();
                return new NotificationManager(new ContextThemeWrapper(outerContext, Resources.selectSystemTheme(0, outerContext.getApplicationInfo().targetSdkVersion, 16973835, 16973935, 16974126, 16974130)), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("servicediscovery", NsdManager.class, new CachedServiceFetcher<NsdManager>(){

            @Override
            public NsdManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("servicediscovery");
                INsdManager service = INsdManager.Stub.asInterface(b);
                return new NsdManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("power", PowerManager.class, new CachedServiceFetcher<PowerManager>(){

            @Override
            public PowerManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("power");
                IPowerManager service = IPowerManager.Stub.asInterface(b);
                return new PowerManager(ctx.getOuterContext(), service, ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("recovery", RecoverySystem.class, new CachedServiceFetcher<RecoverySystem>(){

            @Override
            public RecoverySystem createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("recovery");
                IRecoverySystem service = IRecoverySystem.Stub.asInterface(b);
                return new RecoverySystem(service);
            }
        });
        SystemServiceRegistry.registerService("search", SearchManager.class, new CachedServiceFetcher<SearchManager>(){

            @Override
            public SearchManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new SearchManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("sensor", SensorManager.class, new CachedServiceFetcher<SensorManager>(){

            @Override
            public SensorManager createService(ContextImpl ctx) {
                return new SystemSensorManager(ctx.getOuterContext(), ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("statusbar", StatusBarManager.class, new CachedServiceFetcher<StatusBarManager>(){

            @Override
            public StatusBarManager createService(ContextImpl ctx) {
                return new StatusBarManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("storage", StorageManager.class, new CachedServiceFetcher<StorageManager>(){

            @Override
            public StorageManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new StorageManager(ctx, ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("storagestats", StorageStatsManager.class, new CachedServiceFetcher<StorageStatsManager>(){

            @Override
            public StorageStatsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IStorageStatsManager service = IStorageStatsManager.Stub.asInterface(ServiceManager.getServiceOrThrow("storagestats"));
                return new StorageStatsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("phone", TelephonyManager.class, new CachedServiceFetcher<TelephonyManager>(){

            @Override
            public TelephonyManager createService(ContextImpl ctx) {
                return new TelephonyManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("telephony_subscription_service", SubscriptionManager.class, new CachedServiceFetcher<SubscriptionManager>(){

            @Override
            public SubscriptionManager createService(ContextImpl ctx) {
                return new SubscriptionManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("carrier_config", CarrierConfigManager.class, new CachedServiceFetcher<CarrierConfigManager>(){

            @Override
            public CarrierConfigManager createService(ContextImpl ctx) {
                return new CarrierConfigManager();
            }
        });
        SystemServiceRegistry.registerService("telecom", TelecomManager.class, new CachedServiceFetcher<TelecomManager>(){

            @Override
            public TelecomManager createService(ContextImpl ctx) {
                return new TelecomManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("euicc_service", EuiccManager.class, new CachedServiceFetcher<EuiccManager>(){

            @Override
            public EuiccManager createService(ContextImpl ctx) {
                return new EuiccManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("uimode", UiModeManager.class, new CachedServiceFetcher<UiModeManager>(){

            @Override
            public UiModeManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new UiModeManager();
            }
        });
        SystemServiceRegistry.registerService("usb", UsbManager.class, new CachedServiceFetcher<UsbManager>(){

            @Override
            public UsbManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("usb");
                return new UsbManager(ctx, IUsbManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("serial", SerialManager.class, new CachedServiceFetcher<SerialManager>(){

            @Override
            public SerialManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("serial");
                return new SerialManager(ctx, ISerialManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("vibrator", Vibrator.class, new CachedServiceFetcher<Vibrator>(){

            @Override
            public Vibrator createService(ContextImpl ctx) {
                return new SystemVibrator(ctx);
            }
        });
        SystemServiceRegistry.registerService("wallpaper", WallpaperManager.class, new CachedServiceFetcher<WallpaperManager>(){

            @Override
            public WallpaperManager createService(ContextImpl ctx) {
                return new WallpaperManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("lowpan", LowpanManager.class, new CachedServiceFetcher<LowpanManager>(){

            @Override
            public LowpanManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("lowpan");
                ILowpanManager service = ILowpanManager.Stub.asInterface(b);
                return new LowpanManager(ctx.getOuterContext(), service, ConnectivityThread.getInstanceLooper());
            }
        });
        SystemServiceRegistry.registerService("wifi", WifiManager.class, new CachedServiceFetcher<WifiManager>(){

            @Override
            public WifiManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("wifi");
                IWifiManager service = IWifiManager.Stub.asInterface(b);
                return new WifiManager(ctx.getOuterContext(), service, ConnectivityThread.getInstanceLooper());
            }
        });
        SystemServiceRegistry.registerService("wifip2p", WifiP2pManager.class, new StaticServiceFetcher<WifiP2pManager>(){

            @Override
            public WifiP2pManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("wifip2p");
                IWifiP2pManager service = IWifiP2pManager.Stub.asInterface(b);
                return new WifiP2pManager(service);
            }
        });
        SystemServiceRegistry.registerService("wifiaware", WifiAwareManager.class, new CachedServiceFetcher<WifiAwareManager>(){

            @Override
            public WifiAwareManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("wifiaware");
                IWifiAwareManager service = IWifiAwareManager.Stub.asInterface(b);
                if (service == null) {
                    return null;
                }
                return new WifiAwareManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("wifiscanner", WifiScanner.class, new CachedServiceFetcher<WifiScanner>(){

            @Override
            public WifiScanner createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("wifiscanner");
                IWifiScanner service = IWifiScanner.Stub.asInterface(b);
                return new WifiScanner(ctx.getOuterContext(), service, ConnectivityThread.getInstanceLooper());
            }
        });
        SystemServiceRegistry.registerService("rttmanager", RttManager.class, new CachedServiceFetcher<RttManager>(){

            @Override
            public RttManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("rttmanager");
                IRttManager service = IRttManager.Stub.asInterface(b);
                return new RttManager(ctx.getOuterContext(), service, ConnectivityThread.getInstanceLooper());
            }
        });
        SystemServiceRegistry.registerService("ethernet", EthernetManager.class, new CachedServiceFetcher<EthernetManager>(){

            @Override
            public EthernetManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("ethernet");
                IEthernetManager service = IEthernetManager.Stub.asInterface(b);
                return new EthernetManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("window", WindowManager.class, new CachedServiceFetcher<WindowManager>(){

            @Override
            public WindowManager createService(ContextImpl ctx) {
                return new WindowManagerImpl(ctx);
            }
        });
        SystemServiceRegistry.registerService("user", UserManager.class, new CachedServiceFetcher<UserManager>(){

            @Override
            public UserManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("user");
                IUserManager service = IUserManager.Stub.asInterface(b);
                return new UserManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("appops", AppOpsManager.class, new CachedServiceFetcher<AppOpsManager>(){

            @Override
            public AppOpsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("appops");
                IAppOpsService service = IAppOpsService.Stub.asInterface(b);
                return new AppOpsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("camera", CameraManager.class, new CachedServiceFetcher<CameraManager>(){

            @Override
            public CameraManager createService(ContextImpl ctx) {
                return new CameraManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("launcherapps", LauncherApps.class, new CachedServiceFetcher<LauncherApps>(){

            @Override
            public LauncherApps createService(ContextImpl ctx) {
                return new LauncherApps(ctx);
            }
        });
        SystemServiceRegistry.registerService("restrictions", RestrictionsManager.class, new CachedServiceFetcher<RestrictionsManager>(){

            @Override
            public RestrictionsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("restrictions");
                IRestrictionsManager service = IRestrictionsManager.Stub.asInterface(b);
                return new RestrictionsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("print", PrintManager.class, new CachedServiceFetcher<PrintManager>(){

            @Override
            public PrintManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IPrintManager service = null;
                if (ctx.getPackageManager().hasSystemFeature("android.software.print")) {
                    service = IPrintManager.Stub.asInterface(ServiceManager.getServiceOrThrow("print"));
                }
                return new PrintManager(ctx.getOuterContext(), service, UserHandle.myUserId(), UserHandle.getAppId(Process.myUid()));
            }
        });
        SystemServiceRegistry.registerService("companiondevice", CompanionDeviceManager.class, new CachedServiceFetcher<CompanionDeviceManager>(){

            @Override
            public CompanionDeviceManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                ICompanionDeviceManager service = null;
                if (ctx.getPackageManager().hasSystemFeature("android.software.companion_device_setup")) {
                    service = ICompanionDeviceManager.Stub.asInterface(ServiceManager.getServiceOrThrow("companiondevice"));
                }
                return new CompanionDeviceManager(service, ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("consumer_ir", ConsumerIrManager.class, new CachedServiceFetcher<ConsumerIrManager>(){

            @Override
            public ConsumerIrManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new ConsumerIrManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("media_session", MediaSessionManager.class, new CachedServiceFetcher<MediaSessionManager>(){

            @Override
            public MediaSessionManager createService(ContextImpl ctx) {
                return new MediaSessionManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("trust", TrustManager.class, new StaticServiceFetcher<TrustManager>(){

            @Override
            public TrustManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("trust");
                return new TrustManager(b);
            }
        });
        SystemServiceRegistry.registerService("fingerprint", FingerprintManager.class, new CachedServiceFetcher<FingerprintManager>(){

            @Override
            public FingerprintManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder binder = ctx.getApplicationInfo().targetSdkVersion >= 26 ? ServiceManager.getServiceOrThrow("fingerprint") : ServiceManager.getService("fingerprint");
                IFingerprintService service = IFingerprintService.Stub.asInterface(binder);
                return new FingerprintManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("tv_input", TvInputManager.class, new StaticServiceFetcher<TvInputManager>(){

            @Override
            public TvInputManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("tv_input");
                ITvInputManager service = ITvInputManager.Stub.asInterface(iBinder);
                return new TvInputManager(service, UserHandle.myUserId());
            }
        });
        SystemServiceRegistry.registerService("network_score", NetworkScoreManager.class, new CachedServiceFetcher<NetworkScoreManager>(){

            @Override
            public NetworkScoreManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new NetworkScoreManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("usagestats", UsageStatsManager.class, new CachedServiceFetcher<UsageStatsManager>(){

            @Override
            public UsageStatsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder iBinder = ServiceManager.getServiceOrThrow("usagestats");
                IUsageStatsManager service = IUsageStatsManager.Stub.asInterface(iBinder);
                return new UsageStatsManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("netstats", NetworkStatsManager.class, new CachedServiceFetcher<NetworkStatsManager>(){

            @Override
            public NetworkStatsManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new NetworkStatsManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("jobscheduler", JobScheduler.class, new StaticServiceFetcher<JobScheduler>(){

            @Override
            public JobScheduler createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("jobscheduler");
                return new JobSchedulerImpl(IJobScheduler.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("persistent_data_block", PersistentDataBlockManager.class, new StaticServiceFetcher<PersistentDataBlockManager>(){

            @Override
            public PersistentDataBlockManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("persistent_data_block");
                IPersistentDataBlockService persistentDataBlockService = IPersistentDataBlockService.Stub.asInterface(b);
                if (persistentDataBlockService != null) {
                    return new PersistentDataBlockManager(persistentDataBlockService);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("oem_lock", OemLockManager.class, new StaticServiceFetcher<OemLockManager>(){

            @Override
            public OemLockManager createService() throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("oem_lock");
                IOemLockService oemLockService = IOemLockService.Stub.asInterface(b);
                if (oemLockService != null) {
                    return new OemLockManager(oemLockService);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("media_projection", MediaProjectionManager.class, new CachedServiceFetcher<MediaProjectionManager>(){

            @Override
            public MediaProjectionManager createService(ContextImpl ctx) {
                return new MediaProjectionManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("appwidget", AppWidgetManager.class, new CachedServiceFetcher<AppWidgetManager>(){

            @Override
            public AppWidgetManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("appwidget");
                return new AppWidgetManager(ctx, IAppWidgetService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("midi", MidiManager.class, new CachedServiceFetcher<MidiManager>(){

            @Override
            public MidiManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("midi");
                return new MidiManager(IMidiManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("broadcastradio", RadioManager.class, new CachedServiceFetcher<RadioManager>(){

            @Override
            public RadioManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new RadioManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("hardware_properties", HardwarePropertiesManager.class, new CachedServiceFetcher<HardwarePropertiesManager>(){

            @Override
            public HardwarePropertiesManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("hardware_properties");
                IHardwarePropertiesManager service = IHardwarePropertiesManager.Stub.asInterface(b);
                return new HardwarePropertiesManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("soundtrigger", SoundTriggerManager.class, new CachedServiceFetcher<SoundTriggerManager>(){

            @Override
            public SoundTriggerManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("soundtrigger");
                return new SoundTriggerManager(ctx, ISoundTriggerService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("shortcut", ShortcutManager.class, new CachedServiceFetcher<ShortcutManager>(){

            @Override
            public ShortcutManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("shortcut");
                return new ShortcutManager(ctx, IShortcutService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("systemhealth", SystemHealthManager.class, new CachedServiceFetcher<SystemHealthManager>(){

            @Override
            public SystemHealthManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("batterystats");
                return new SystemHealthManager(IBatteryStats.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("contexthub", ContextHubManager.class, new CachedServiceFetcher<ContextHubManager>(){

            @Override
            public ContextHubManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new ContextHubManager(ctx.getOuterContext(), ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("incident", IncidentManager.class, new CachedServiceFetcher<IncidentManager>(){

            @Override
            public IncidentManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                return new IncidentManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("autofill", AutofillManager.class, new CachedServiceFetcher<AutofillManager>(){

            @Override
            public AutofillManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getService("autofill");
                IAutoFillManager service = IAutoFillManager.Stub.asInterface(b);
                return new AutofillManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("vrmanager", VrManager.class, new CachedServiceFetcher<VrManager>(){

            @Override
            public VrManager createService(ContextImpl ctx) throws ServiceManager.ServiceNotFoundException {
                IBinder b = ServiceManager.getServiceOrThrow("vrmanager");
                return new VrManager(IVrManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("timezone", RulesManager.class, new CachedServiceFetcher<RulesManager>(){

            @Override
            public RulesManager createService(ContextImpl ctx) {
                return new RulesManager(ctx.getOuterContext());
            }
        });
    }

    static abstract class StaticApplicationContextServiceFetcher<T>
    implements ServiceFetcher<T> {
        private T mCachedInstance;

        StaticApplicationContextServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T getService(ContextImpl ctx) {
            StaticApplicationContextServiceFetcher staticApplicationContextServiceFetcher = this;
            synchronized (staticApplicationContextServiceFetcher) {
                if (this.mCachedInstance == null) {
                    Context appContext = ctx.getApplicationContext();
                    try {
                        this.mCachedInstance = this.createService(appContext != null ? appContext : ctx);
                    }
                    catch (ServiceManager.ServiceNotFoundException e) {
                        SystemServiceRegistry.onServiceNotFound(e);
                    }
                }
                return this.mCachedInstance;
            }
        }

        public abstract T createService(Context var1) throws ServiceManager.ServiceNotFoundException;
    }

    static abstract class StaticServiceFetcher<T>
    implements ServiceFetcher<T> {
        private T mCachedInstance;

        StaticServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T getService(ContextImpl ctx) {
            StaticServiceFetcher staticServiceFetcher = this;
            synchronized (staticServiceFetcher) {
                if (this.mCachedInstance == null) {
                    try {
                        this.mCachedInstance = this.createService();
                    }
                    catch (ServiceManager.ServiceNotFoundException e) {
                        SystemServiceRegistry.onServiceNotFound(e);
                    }
                }
                return this.mCachedInstance;
            }
        }

        public abstract T createService() throws ServiceManager.ServiceNotFoundException;
    }

    static abstract class CachedServiceFetcher<T>
    implements ServiceFetcher<T> {
        private final int mCacheIndex = SystemServiceRegistry.access$008();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T getService(ContextImpl ctx) {
            Object[] cache;
            Object[] objectArray = cache = ctx.mServiceCache;
            synchronized (cache) {
                Object service = cache[this.mCacheIndex];
                if (service == null) {
                    try {
                        cache[this.mCacheIndex] = service = this.createService(ctx);
                    }
                    catch (ServiceManager.ServiceNotFoundException e) {
                        SystemServiceRegistry.onServiceNotFound(e);
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (T)service;
            }
        }

        public abstract T createService(ContextImpl var1) throws ServiceManager.ServiceNotFoundException;
    }

    static interface ServiceFetcher<T> {
        public T getService(ContextImpl var1);
    }
}

