/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.util.EventLog;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;

public class SecurityLog {
    private static final String PROPERTY_LOGGING_ENABLED = "persist.logd.security";
    public static final int TAG_ADB_SHELL_INTERACTIVE = 210001;
    public static final int TAG_ADB_SHELL_CMD = 210002;
    public static final int TAG_SYNC_RECV_FILE = 210003;
    public static final int TAG_SYNC_SEND_FILE = 210004;
    public static final int TAG_APP_PROCESS_START = 210005;
    public static final int TAG_KEYGUARD_DISMISSED = 210006;
    public static final int TAG_KEYGUARD_DISMISS_AUTH_ATTEMPT = 210007;
    public static final int TAG_KEYGUARD_SECURED = 210008;

    public static native boolean isLoggingEnabled();

    public static void setLoggingEnabledProperty(boolean enabled) {
        SystemProperties.set(PROPERTY_LOGGING_ENABLED, enabled ? "true" : "false");
    }

    public static boolean getLoggingEnabledProperty() {
        return SystemProperties.getBoolean(PROPERTY_LOGGING_ENABLED, false);
    }

    public static native void readEvents(Collection<SecurityEvent> var0) throws IOException;

    public static native void readEventsSince(long var0, Collection<SecurityEvent> var2) throws IOException;

    public static native void readPreviousEvents(Collection<SecurityEvent> var0) throws IOException;

    public static native void readEventsOnWrapping(long var0, Collection<SecurityEvent> var2) throws IOException;

    public static native int writeEvent(int var0, String var1);

    public static native int writeEvent(int var0, Object ... var1);

    public static final class SecurityEvent
    implements Parcelable {
        private EventLog.Event mEvent;
        public static final Parcelable.Creator<SecurityEvent> CREATOR = new Parcelable.Creator<SecurityEvent>(){

            @Override
            public SecurityEvent createFromParcel(Parcel source) {
                return new SecurityEvent(source.createByteArray());
            }

            public SecurityEvent[] newArray(int size) {
                return new SecurityEvent[size];
            }
        };

        SecurityEvent(byte[] data) {
            this.mEvent = EventLog.Event.fromBytes(data);
        }

        public long getTimeNanos() {
            return this.mEvent.getTimeNanos();
        }

        public int getTag() {
            return this.mEvent.getTag();
        }

        public Object getData() {
            return this.mEvent.getData();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByteArray(this.mEvent.getBytes());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecurityEvent other = (SecurityEvent)o;
            return this.mEvent.equals(other.mEvent);
        }

        public int hashCode() {
            return this.mEvent.hashCode();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SECURITY_LOG_TAG {
    }
}

