/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezone;

import android.app.timezone.DistroFormatVersion;
import android.app.timezone.DistroRulesVersion;
import android.app.timezone.Utils;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class RulesState
implements Parcelable {
    public static final int STAGED_OPERATION_UNKNOWN = 0;
    public static final int STAGED_OPERATION_NONE = 1;
    public static final int STAGED_OPERATION_UNINSTALL = 2;
    public static final int STAGED_OPERATION_INSTALL = 3;
    public static final int DISTRO_STATUS_UNKNOWN = 0;
    public static final int DISTRO_STATUS_NONE = 1;
    public static final int DISTRO_STATUS_INSTALLED = 2;
    private static final byte BYTE_FALSE = 0;
    private static final byte BYTE_TRUE = 1;
    private final String mSystemRulesVersion;
    private final DistroFormatVersion mDistroFormatVersionSupported;
    private final boolean mOperationInProgress;
    private final int mStagedOperationType;
    private final DistroRulesVersion mStagedDistroRulesVersion;
    private final int mDistroStatus;
    private final DistroRulesVersion mInstalledDistroRulesVersion;
    public static final Parcelable.Creator<RulesState> CREATOR = new Parcelable.Creator<RulesState>(){

        @Override
        public RulesState createFromParcel(Parcel in) {
            return RulesState.createFromParcel(in);
        }

        public RulesState[] newArray(int size) {
            return new RulesState[size];
        }
    };

    public RulesState(String systemRulesVersion, DistroFormatVersion distroFormatVersionSupported, boolean operationInProgress, int stagedOperationType, DistroRulesVersion stagedDistroRulesVersion, int distroStatus, DistroRulesVersion installedDistroRulesVersion) {
        this.mSystemRulesVersion = Utils.validateRulesVersion("systemRulesVersion", systemRulesVersion);
        this.mDistroFormatVersionSupported = Utils.validateNotNull("distroFormatVersionSupported", distroFormatVersionSupported);
        this.mOperationInProgress = operationInProgress;
        if (operationInProgress && stagedOperationType != 0) {
            throw new IllegalArgumentException("stagedOperationType != STAGED_OPERATION_UNKNOWN");
        }
        this.mStagedOperationType = RulesState.validateStagedOperation(stagedOperationType);
        this.mStagedDistroRulesVersion = Utils.validateConditionalNull(this.mStagedOperationType == 3, "stagedDistroRulesVersion", stagedDistroRulesVersion);
        if (operationInProgress && distroStatus != 0) {
            throw new IllegalArgumentException("distroInstalled != DISTRO_STATUS_UNKNOWN");
        }
        this.mDistroStatus = RulesState.validateDistroStatus(distroStatus);
        this.mInstalledDistroRulesVersion = Utils.validateConditionalNull(this.mDistroStatus == 2, "installedDistroRulesVersion", installedDistroRulesVersion);
    }

    public String getSystemRulesVersion() {
        return this.mSystemRulesVersion;
    }

    public boolean isOperationInProgress() {
        return this.mOperationInProgress;
    }

    public int getStagedOperationType() {
        return this.mStagedOperationType;
    }

    public DistroRulesVersion getStagedDistroRulesVersion() {
        return this.mStagedDistroRulesVersion;
    }

    public int getDistroStatus() {
        return this.mDistroStatus;
    }

    public DistroRulesVersion getInstalledDistroRulesVersion() {
        return this.mInstalledDistroRulesVersion;
    }

    public boolean isDistroFormatVersionSupported(DistroFormatVersion distroFormatVersion) {
        return this.mDistroFormatVersionSupported.supports(distroFormatVersion);
    }

    public boolean isSystemVersionNewerThan(DistroRulesVersion distroRulesVersion) {
        return this.mSystemRulesVersion.compareTo(distroRulesVersion.getRulesVersion()) > 0;
    }

    private static RulesState createFromParcel(Parcel in) {
        String systemRulesVersion = in.readString();
        DistroFormatVersion distroFormatVersionSupported = (DistroFormatVersion)in.readParcelable(null);
        boolean operationInProgress = in.readByte() == 1;
        byte distroStagedState = in.readByte();
        DistroRulesVersion stagedDistroRulesVersion = (DistroRulesVersion)in.readParcelable(null);
        byte installedDistroStatus = in.readByte();
        DistroRulesVersion installedDistroRulesVersion = (DistroRulesVersion)in.readParcelable(null);
        return new RulesState(systemRulesVersion, distroFormatVersionSupported, operationInProgress, distroStagedState, stagedDistroRulesVersion, installedDistroStatus, installedDistroRulesVersion);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mSystemRulesVersion);
        out.writeParcelable(this.mDistroFormatVersionSupported, 0);
        out.writeByte(this.mOperationInProgress ? (byte)1 : 0);
        out.writeByte((byte)this.mStagedOperationType);
        out.writeParcelable(this.mStagedDistroRulesVersion, 0);
        out.writeByte((byte)this.mDistroStatus);
        out.writeParcelable(this.mInstalledDistroRulesVersion, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RulesState that = (RulesState)o;
        if (this.mOperationInProgress != that.mOperationInProgress) {
            return false;
        }
        if (this.mStagedOperationType != that.mStagedOperationType) {
            return false;
        }
        if (this.mDistroStatus != that.mDistroStatus) {
            return false;
        }
        if (!this.mSystemRulesVersion.equals(that.mSystemRulesVersion)) {
            return false;
        }
        if (!this.mDistroFormatVersionSupported.equals(that.mDistroFormatVersionSupported)) {
            return false;
        }
        if (this.mStagedDistroRulesVersion != null ? !this.mStagedDistroRulesVersion.equals(that.mStagedDistroRulesVersion) : that.mStagedDistroRulesVersion != null) {
            return false;
        }
        return this.mInstalledDistroRulesVersion != null ? this.mInstalledDistroRulesVersion.equals(that.mInstalledDistroRulesVersion) : that.mInstalledDistroRulesVersion == null;
    }

    public int hashCode() {
        int result = this.mSystemRulesVersion.hashCode();
        result = 31 * result + this.mDistroFormatVersionSupported.hashCode();
        result = 31 * result + (this.mOperationInProgress ? 1 : 0);
        result = 31 * result + this.mStagedOperationType;
        result = 31 * result + (this.mStagedDistroRulesVersion != null ? this.mStagedDistroRulesVersion.hashCode() : 0);
        result = 31 * result + this.mDistroStatus;
        result = 31 * result + (this.mInstalledDistroRulesVersion != null ? this.mInstalledDistroRulesVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RulesState{mSystemRulesVersion='" + this.mSystemRulesVersion + '\'' + ", mDistroFormatVersionSupported=" + this.mDistroFormatVersionSupported + ", mOperationInProgress=" + this.mOperationInProgress + ", mStagedOperationType=" + this.mStagedOperationType + ", mStagedDistroRulesVersion=" + this.mStagedDistroRulesVersion + ", mDistroStatus=" + this.mDistroStatus + ", mInstalledDistroRulesVersion=" + this.mInstalledDistroRulesVersion + '}';
    }

    private static int validateStagedOperation(int stagedOperationType) {
        if (stagedOperationType < 0 || stagedOperationType > 3) {
            throw new IllegalArgumentException("Unknown operation type=" + stagedOperationType);
        }
        return stagedOperationType;
    }

    private static int validateDistroStatus(int distroStatus) {
        if (distroStatus < 0 || distroStatus > 2) {
            throw new IllegalArgumentException("Unknown distro status=" + distroStatus);
        }
        return distroStatus;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface DistroStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface StagedOperationType {
    }
}

