/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public final class BluetoothAvrcpPlayerSettings
implements Parcelable {
    public static final String TAG = "BluetoothAvrcpPlayerSettings";
    public static final int SETTING_EQUALIZER = 1;
    public static final int SETTING_REPEAT = 2;
    public static final int SETTING_SHUFFLE = 4;
    public static final int SETTING_SCAN = 8;
    public static final int STATE_INVALID = -1;
    public static final int STATE_OFF = 0;
    public static final int STATE_ON = 1;
    public static final int STATE_SINGLE_TRACK = 2;
    public static final int STATE_ALL_TRACK = 3;
    public static final int STATE_GROUP = 4;
    private int mSettings;
    private Map<Integer, Integer> mSettingsValue = new HashMap<Integer, Integer>();
    public static final Parcelable.Creator<BluetoothAvrcpPlayerSettings> CREATOR = new Parcelable.Creator<BluetoothAvrcpPlayerSettings>(){

        @Override
        public BluetoothAvrcpPlayerSettings createFromParcel(Parcel in) {
            return new BluetoothAvrcpPlayerSettings(in);
        }

        public BluetoothAvrcpPlayerSettings[] newArray(int size) {
            return new BluetoothAvrcpPlayerSettings[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mSettings);
        out.writeInt(this.mSettingsValue.size());
        for (int k : this.mSettingsValue.keySet()) {
            out.writeInt(k);
            out.writeInt(this.mSettingsValue.get(k));
        }
    }

    private BluetoothAvrcpPlayerSettings(Parcel in) {
        this.mSettings = in.readInt();
        int numSettings = in.readInt();
        for (int i = 0; i < numSettings; ++i) {
            this.mSettingsValue.put(in.readInt(), in.readInt());
        }
    }

    public BluetoothAvrcpPlayerSettings(int settings) {
        this.mSettings = settings;
    }

    public int getSettings() {
        return this.mSettings;
    }

    public void addSettingValue(int setting, int value) {
        if ((setting & this.mSettings) == 0) {
            Log.e(TAG, "Setting not supported: " + setting + " " + this.mSettings);
            throw new IllegalStateException("Setting not supported: " + setting);
        }
        this.mSettingsValue.put(setting, value);
    }

    public int getSettingValue(int setting) {
        if ((setting & this.mSettings) == 0) {
            Log.e(TAG, "Setting not supported: " + setting + " " + this.mSettings);
            throw new IllegalStateException("Setting not supported: " + setting);
        }
        Integer i = this.mSettingsValue.get(setting);
        if (i == null) {
            return -1;
        }
        return i;
    }
}

