/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothManager {
    private static final String TAG = "BluetoothManager";
    private static final boolean DBG = true;
    private static final boolean VDBG = true;
    private final BluetoothAdapter mAdapter;

    public BluetoothManager(Context context) {
        context = context.getApplicationContext();
        if (context == null) {
            throw new IllegalArgumentException("context not associated with any application (using a mock context?)");
        }
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public BluetoothAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getConnectionState(BluetoothDevice device, int profile) {
        Log.d(TAG, "getConnectionState()");
        List<BluetoothDevice> connectedDevices = this.getConnectedDevices(profile);
        for (BluetoothDevice connectedDevice : connectedDevices) {
            if (!device.equals(connectedDevice)) continue;
            return 2;
        }
        return 0;
    }

    public List<BluetoothDevice> getConnectedDevices(int profile) {
        Log.d(TAG, "getConnectedDevices");
        if (profile != 7 && profile != 8) {
            throw new IllegalArgumentException("Profile not supported: " + profile);
        }
        List<BluetoothDevice> connectedDevices = new ArrayList<BluetoothDevice>();
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return connectedDevices;
            }
            connectedDevices = iGatt.getDevicesMatchingConnectionStates(new int[]{2});
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return connectedDevices;
    }

    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int profile, int[] states) {
        Log.d(TAG, "getDevicesMatchingConnectionStates");
        if (profile != 7 && profile != 8) {
            throw new IllegalArgumentException("Profile not supported: " + profile);
        }
        List<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return devices;
            }
            devices = iGatt.getDevicesMatchingConnectionStates(states);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        return devices;
    }

    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback) {
        return this.openGattServer(context, callback, 0);
    }

    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback callback, int transport) {
        if (context == null || callback == null) {
            throw new IllegalArgumentException("null parameter: " + context + " " + callback);
        }
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                Log.e(TAG, "Fail to get GATT Server connection");
                return null;
            }
            BluetoothGattServer mGattServer = new BluetoothGattServer(iGatt, transport);
            Boolean regStatus = mGattServer.registerCallback(callback);
            return regStatus != false ? mGattServer : null;
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }
}

