/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.IPeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingCallback;
import android.bluetooth.le.PeriodicAdvertisingReport;
import android.bluetooth.le.ScanResult;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.util.IdentityHashMap;
import java.util.Map;

public final class PeriodicAdvertisingManager {
    private static final String TAG = "PeriodicAdvertisingManager";
    private static final int SKIP_MIN = 0;
    private static final int SKIP_MAX = 499;
    private static final int TIMEOUT_MIN = 10;
    private static final int TIMEOUT_MAX = 16384;
    private static final int SYNC_STARTING = -1;
    private final IBluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    Map<PeriodicAdvertisingCallback, IPeriodicAdvertisingCallback> callbackWrappers;

    public PeriodicAdvertisingManager(IBluetoothManager bluetoothManager) {
        this.mBluetoothManager = bluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.callbackWrappers = new IdentityHashMap<PeriodicAdvertisingCallback, IPeriodicAdvertisingCallback>();
    }

    public void registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback) {
        this.registerSync(scanResult, skip, timeout, callback, null);
    }

    public void registerSync(ScanResult scanResult, int skip, int timeout, PeriodicAdvertisingCallback callback, Handler handler) {
        IBluetoothGatt gatt;
        if (callback == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        if (scanResult == null) {
            throw new IllegalArgumentException("scanResult can't be null");
        }
        if (scanResult.getAdvertisingSid() == 255) {
            throw new IllegalArgumentException("scanResult must contain a valid sid");
        }
        if (skip < 0 || skip > 499) {
            throw new IllegalArgumentException("timeout must be between 10 and 16384");
        }
        if (timeout < 10 || timeout > 16384) {
            throw new IllegalArgumentException("timeout must be between 10 and 16384");
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            callback.onSyncEstablished(0, scanResult.getDevice(), scanResult.getAdvertisingSid(), skip, timeout, 2);
            return;
        }
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        IPeriodicAdvertisingCallback wrapped = this.wrap(callback, handler);
        this.callbackWrappers.put(callback, wrapped);
        try {
            gatt.registerSync(scanResult, skip, timeout, wrapped);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register sync - ", e);
            return;
        }
    }

    public void unregisterSync(PeriodicAdvertisingCallback callback) {
        IBluetoothGatt gatt;
        if (callback == null) {
            throw new IllegalArgumentException("callback can't be null");
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            return;
        }
        IPeriodicAdvertisingCallback wrapper = this.callbackWrappers.remove(callback);
        if (wrapper == null) {
            throw new IllegalArgumentException("callback was not properly registered");
        }
        try {
            gatt.unregisterSync(wrapper);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to cancel sync creation - ", e);
            return;
        }
    }

    private IPeriodicAdvertisingCallback wrap(final PeriodicAdvertisingCallback callback, final Handler handler) {
        return new IPeriodicAdvertisingCallback.Stub(){

            @Override
            public void onSyncEstablished(final int syncHandle, final BluetoothDevice device, final int advertisingSid, final int skip, final int timeout, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSyncEstablished(syncHandle, device, advertisingSid, skip, timeout, status);
                        if (status != 0) {
                            PeriodicAdvertisingManager.this.callbackWrappers.remove(callback);
                        }
                    }
                });
            }

            @Override
            public void onPeriodicAdvertisingReport(final PeriodicAdvertisingReport report) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onPeriodicAdvertisingReport(report);
                    }
                });
            }

            @Override
            public void onSyncLost(final int syncHandle) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSyncLost(syncHandle);
                        PeriodicAdvertisingManager.this.callbackWrappers.remove(callback);
                    }
                });
            }
        };
    }
}

