/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.os.Parcel;
import android.os.Parcelable;

public final class PeriodicAdvertisingParameters
implements Parcelable {
    private static final int INTERVAL_MIN = 80;
    private static final int INTERVAL_MAX = 65519;
    private final boolean includeTxPower;
    private final int interval;
    public static final Parcelable.Creator<PeriodicAdvertisingParameters> CREATOR = new Parcelable.Creator<PeriodicAdvertisingParameters>(){

        public PeriodicAdvertisingParameters[] newArray(int size) {
            return new PeriodicAdvertisingParameters[size];
        }

        @Override
        public PeriodicAdvertisingParameters createFromParcel(Parcel in) {
            return new PeriodicAdvertisingParameters(in);
        }
    };

    private PeriodicAdvertisingParameters(boolean includeTxPower, int interval) {
        this.includeTxPower = includeTxPower;
        this.interval = interval;
    }

    private PeriodicAdvertisingParameters(Parcel in) {
        this.includeTxPower = in.readInt() != 0;
        this.interval = in.readInt();
    }

    public boolean getIncludeTxPower() {
        return this.includeTxPower;
    }

    public int getInterval() {
        return this.interval;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.includeTxPower ? 1 : 0);
        dest.writeInt(this.interval);
    }

    public static final class Builder {
        private boolean includeTxPower = false;
        private int interval = 65519;

        public Builder setIncludeTxPower(boolean includeTxPower) {
            this.includeTxPower = includeTxPower;
            return this;
        }

        public Builder setInterval(int interval) {
            if (interval < 80 || interval > 65519) {
                throw new IllegalArgumentException("Invalid interval (must be 80-65519)");
            }
            this.interval = interval;
            return this;
        }

        public PeriodicAdvertisingParameters build() {
            return new PeriodicAdvertisingParameters(this.includeTxPower, this.interval);
        }
    }
}

