/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.le.ScanRecord;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public final class PeriodicAdvertisingReport
implements Parcelable {
    public static final int DATA_COMPLETE = 0;
    public static final int DATA_INCOMPLETE_TRUNCATED = 2;
    private int syncHandle;
    private int txPower;
    private int rssi;
    private int dataStatus;
    private ScanRecord data;
    private long timestampNanos;
    public static final Parcelable.Creator<PeriodicAdvertisingReport> CREATOR = new Parcelable.Creator<PeriodicAdvertisingReport>(){

        @Override
        public PeriodicAdvertisingReport createFromParcel(Parcel source) {
            return new PeriodicAdvertisingReport(source);
        }

        public PeriodicAdvertisingReport[] newArray(int size) {
            return new PeriodicAdvertisingReport[size];
        }
    };

    public PeriodicAdvertisingReport(int syncHandle, int txPower, int rssi, int dataStatus, ScanRecord data) {
        this.syncHandle = syncHandle;
        this.txPower = txPower;
        this.rssi = rssi;
        this.dataStatus = dataStatus;
        this.data = data;
    }

    private PeriodicAdvertisingReport(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.syncHandle);
        dest.writeLong(this.txPower);
        dest.writeInt(this.rssi);
        dest.writeInt(this.dataStatus);
        if (this.data != null) {
            dest.writeInt(1);
            dest.writeByteArray(this.data.getBytes());
        } else {
            dest.writeInt(0);
        }
    }

    private void readFromParcel(Parcel in) {
        this.syncHandle = in.readInt();
        this.txPower = in.readInt();
        this.rssi = in.readInt();
        this.dataStatus = in.readInt();
        if (in.readInt() == 1) {
            this.data = ScanRecord.parseFromBytes(in.createByteArray());
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getSyncHandle() {
        return this.syncHandle;
    }

    public int getTxPower() {
        return this.txPower;
    }

    public int getRssi() {
        return this.rssi;
    }

    public int getDataStatus() {
        return this.dataStatus;
    }

    public ScanRecord getData() {
        return this.data;
    }

    public long getTimestampNanos() {
        return this.timestampNanos;
    }

    public int hashCode() {
        return Objects.hash(this.syncHandle, this.txPower, this.rssi, this.dataStatus, this.data, this.timestampNanos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PeriodicAdvertisingReport other = (PeriodicAdvertisingReport)obj;
        return this.syncHandle == other.syncHandle && this.txPower == other.txPower && this.rssi == other.rssi && this.dataStatus == other.dataStatus && Objects.equals(this.data, other.data) && this.timestampNanos == other.timestampNanos;
    }

    public String toString() {
        return "PeriodicAdvertisingReport{syncHandle=" + this.syncHandle + ", txPower=" + this.txPower + ", rssi=" + this.rssi + ", dataStatus=" + this.dataStatus + ", data=" + Objects.toString(this.data) + ", timestampNanos=" + this.timestampNanos + '}';
    }
}

