/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.companion.AssociationRequest;
import android.companion.ICompanionDeviceManager;
import android.companion.IFindDeviceCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import com.android.internal.util.Preconditions;
import java.util.Collections;
import java.util.List;

public final class CompanionDeviceManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "CompanionDeviceManager";
    public static final String EXTRA_DEVICE = "android.companion.extra.DEVICE";
    public static final String COMPANION_DEVICE_DISCOVERY_PACKAGE_NAME = "com.android.companiondevicemanager";
    private final ICompanionDeviceManager mService;
    private final Context mContext;

    public CompanionDeviceManager(ICompanionDeviceManager service, Context context) {
        this.mService = service;
        this.mContext = context;
    }

    public void associate(AssociationRequest request, Callback callback, Handler handler) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Preconditions.checkNotNull(request, "Request cannot be null");
        Preconditions.checkNotNull(callback, "Callback cannot be null");
        try {
            this.mService.associate(request, new CallbackProxy(request, callback, Handler.mainIfNull(handler)), this.getCallingPackage());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAssociations(this.getCallingPackage(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disassociate(String deviceMacAddress) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.disassociate(deviceMacAddress, this.getCallingPackage());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            IntentSender intentSender = this.mService.requestNotificationAccess(component).getIntentSender();
            this.mContext.startIntentSender(intentSender, null, 0, 0, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IntentSender.SendIntentException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        try {
            return this.mService.hasNotificationAccess(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean checkFeaturePresent() {
        boolean featurePresent;
        boolean bl = featurePresent = this.mService != null;
        if (!featurePresent) {
            // empty if block
        }
        return featurePresent;
    }

    private Activity getActivity() {
        return (Activity)this.mContext;
    }

    private String getCallingPackage() {
        return this.mContext.getPackageName();
    }

    private class CallbackProxy
    extends IFindDeviceCallback.Stub
    implements Application.ActivityLifecycleCallbacks {
        private Callback mCallback;
        private Handler mHandler;
        private AssociationRequest mRequest;

        private CallbackProxy(AssociationRequest request, Callback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
            this.mRequest = request;
            CompanionDeviceManager.this.getActivity().getApplication().registerActivityLifecycleCallbacks(this);
        }

        @Override
        public void onSuccess(PendingIntent launcher) {
            Handler handler = this.mHandler;
            if (handler == null) {
                return;
            }
            handler.post(() -> {
                Callback callback = this.mCallback;
                if (callback == null) {
                    return;
                }
                callback.onDeviceFound(launcher.getIntentSender());
            });
        }

        @Override
        public void onFailure(CharSequence reason) {
            Handler handler = this.mHandler;
            if (handler == null) {
                return;
            }
            handler.post(() -> {
                Callback callback = this.mCallback;
                if (callback == null) {
                    return;
                }
                callback.onFailure(reason);
            });
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            if (activity != CompanionDeviceManager.this.getActivity()) {
                return;
            }
            try {
                CompanionDeviceManager.this.mService.stopScan(this.mRequest, this, CompanionDeviceManager.this.getCallingPackage());
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
            CompanionDeviceManager.this.getActivity().getApplication().unregisterActivityLifecycleCallbacks(this);
            this.mCallback = null;
            this.mHandler = null;
            this.mRequest = null;
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        @Override
        public void onActivityStarted(Activity activity) {
        }

        @Override
        public void onActivityResumed(Activity activity) {
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onActivityStopped(Activity activity) {
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    public static abstract class Callback {
        public abstract void onDeviceFound(IntentSender var1);

        public abstract void onFailure(CharSequence var1);
    }
}

