/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterPort;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.OutputPort;

public abstract class InputPort
extends FilterPort {
    protected OutputPort mSourcePort;

    public InputPort(Filter filter, String name) {
        super(filter, name);
    }

    public void setSourcePort(OutputPort source) {
        if (this.mSourcePort != null) {
            throw new RuntimeException(this + " already connected to " + this.mSourcePort + "!");
        }
        this.mSourcePort = source;
    }

    public boolean isConnected() {
        return this.mSourcePort != null;
    }

    @Override
    public void open() {
        super.open();
        if (this.mSourcePort != null && !this.mSourcePort.isOpen()) {
            this.mSourcePort.open();
        }
    }

    @Override
    public void close() {
        if (this.mSourcePort != null && this.mSourcePort.isOpen()) {
            this.mSourcePort.close();
        }
        super.close();
    }

    public OutputPort getSourcePort() {
        return this.mSourcePort;
    }

    public Filter getSourceFilter() {
        return this.mSourcePort == null ? null : this.mSourcePort.getFilter();
    }

    public FrameFormat getSourceFormat() {
        return this.mSourcePort != null ? this.mSourcePort.getPortFormat() : this.getPortFormat();
    }

    public Object getTarget() {
        return null;
    }

    @Override
    public boolean filterMustClose() {
        return !this.isOpen() && this.isBlocking() && !this.hasFrame();
    }

    @Override
    public boolean isReady() {
        return this.hasFrame() || !this.isBlocking();
    }

    public boolean acceptsFrame() {
        return !this.hasFrame();
    }

    public abstract void transfer(FilterContext var1);
}

