/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.os.SystemClock;
import android.util.Log;

class StopWatch {
    private int STOP_WATCH_LOGGING_PERIOD = 200;
    private String TAG = "MFF";
    private String mName;
    private long mStartTime;
    private long mTotalTime;
    private int mNumCalls;

    public StopWatch(String name) {
        this.mName = name;
        this.mStartTime = -1L;
        this.mTotalTime = 0L;
        this.mNumCalls = 0;
    }

    public void start() {
        if (this.mStartTime != -1L) {
            throw new RuntimeException("Calling start with StopWatch already running");
        }
        this.mStartTime = SystemClock.elapsedRealtime();
    }

    public void stop() {
        if (this.mStartTime == -1L) {
            throw new RuntimeException("Calling stop with StopWatch already stopped");
        }
        long stopTime = SystemClock.elapsedRealtime();
        this.mTotalTime += stopTime - this.mStartTime;
        ++this.mNumCalls;
        this.mStartTime = -1L;
        if (this.mNumCalls % this.STOP_WATCH_LOGGING_PERIOD == 0) {
            Log.i(this.TAG, "AVG ms/call " + this.mName + ": " + String.format("%.1f", Float.valueOf((float)this.mTotalTime * 1.0f / (float)this.mNumCalls)));
            this.mTotalTime = 0L;
            this.mNumCalls = 0;
        }
    }
}

