/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.io;

import android.content.Context;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.KeyValueMap;
import android.filterfw.io.GraphIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public abstract class GraphReader {
    protected KeyValueMap mReferences = new KeyValueMap();

    public abstract FilterGraph readGraphString(String var1) throws GraphIOException;

    public abstract KeyValueMap readKeyValueAssignments(String var1) throws GraphIOException;

    public FilterGraph readGraphResource(Context context, int resourceId) throws GraphIOException {
        InputStream inputStream = context.getResources().openRawResource(resourceId);
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int bytesRead;
            while ((bytesRead = reader.read(buffer, 0, 1024)) > 0) {
                writer.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read specified resource file!");
        }
        return this.readGraphString(writer.toString());
    }

    public void addReference(String name, Object object) {
        this.mReferences.put(name, object);
    }

    public void addReferencesByMap(KeyValueMap refs) {
        this.mReferences.putAll(refs);
    }

    public void addReferencesByKeysAndValues(Object ... references) {
        this.mReferences.setKeyValues(references);
    }
}

