/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.fonts.FontVariationAxis;
import android.util.Log;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class FontFamily {
    private static String TAG = "FontFamily";
    public long mNativePtr;
    private long mBuilderPtr;

    public FontFamily() {
        this.mBuilderPtr = FontFamily.nInitBuilder(null, 0);
    }

    public FontFamily(String lang, int variant) {
        this.mBuilderPtr = FontFamily.nInitBuilder(lang, variant);
    }

    public boolean freeze() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen");
        }
        this.mNativePtr = FontFamily.nCreateFamily(this.mBuilderPtr);
        this.mBuilderPtr = 0L;
        return this.mNativePtr != 0L;
    }

    public void abortCreation() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen or abandoned");
        }
        FontFamily.nAbort(this.mBuilderPtr);
        this.mBuilderPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0L) {
                FontFamily.nUnrefFamily(this.mNativePtr);
            }
            if (this.mBuilderPtr != 0L) {
                FontFamily.nAbort(this.mBuilderPtr);
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addFont(String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFont after freezing.");
        }
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            boolean bl = FontFamily.nAddFont(this.mBuilderPtr, fontBuffer, ttcIndex, weight, italic);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    public boolean addFontFromBuffer(ByteBuffer font, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontWeightStyle after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontWeightStyle(this.mBuilderPtr, font, ttcIndex, weight, italic);
    }

    public boolean addFontFromAssetManager(AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic, FontVariationAxis[] axes) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontFromAsset after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontFromAssetManager(this.mBuilderPtr, mgr, path, cookie, isAsset, ttcIndex, weight, isItalic);
    }

    public void allowUnsupportedFont() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to allow unsupported font.");
        }
        FontFamily.nAllowUnsupportedFont(this.mBuilderPtr);
    }

    private static boolean nAddFont(long builderPtr, ByteBuffer font, int ttcIndex) {
        return FontFamily.nAddFont(builderPtr, font, ttcIndex, -1, -1);
    }

    private static native long nInitBuilder(String var0, int var1);

    @CriticalNative
    private static native long nCreateFamily(long var0);

    @CriticalNative
    private static native void nAllowUnsupportedFont(long var0);

    @CriticalNative
    private static native void nAbort(long var0);

    @CriticalNative
    private static native void nUnrefFamily(long var0);

    private static native boolean nAddFont(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static native boolean nAddFontWeightStyle(long var0, ByteBuffer var2, int var3, int var4, int var5);

    private static native boolean nAddFontFromAssetManager(long var0, AssetManager var2, String var3, int var4, boolean var5, int var6, int var7, int var8);

    @CriticalNative
    private static native void nAddAxisValue(long var0, int var2, float var3);
}

