/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.FontResourcesParser;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import android.provider.FontRequest;
import android.provider.FontsContract;
import android.text.FontConfig;
import android.util.Base64;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface {
    private static String TAG = "Typeface";
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static final LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    @GuardedBy(value="sLock")
    private static final LruCache<String, Typeface> sDynamicTypefaceCache;
    static Typeface sDefaultTypeface;
    static Map<String, Typeface> sSystemFontMap;
    static FontFamily[] sFallbackFonts;
    private static final Object sLock;
    static final String FONTS_CONFIG = "fonts.xml";
    public long native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    private int mStyle = 0;
    private int mWeight = 0;
    public static final int RESOLVE_BY_FONT_TABLE = -1;
    private static final int STYLE_NORMAL = 0;
    private static final int STYLE_ITALIC = 1;
    private int[] mSupportedAxes;
    private static final int[] EMPTY_AXES;

    private static void setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    public int getStyle() {
        return this.mStyle;
    }

    public final boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public final boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(AssetManager mgr, String path, int cookie) {
        if (sFallbackFonts != null) {
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
                Typeface typeface = sDynamicTypefaceCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
                FontFamily fontFamily = new FontFamily();
                if (fontFamily.addFontFromAssetManager(mgr, path, cookie, false, 0, -1, -1, null)) {
                    if (!fontFamily.freeze()) {
                        return null;
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, -1, -1);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(FontResourcesParser.FamilyResourceEntry entry, AssetManager mgr, String path) {
        if (sFallbackFonts != null) {
            if (entry instanceof FontResourcesParser.ProviderResourceEntry) {
                FontRequest request;
                Typeface typeface;
                FontResourcesParser.ProviderResourceEntry providerEntry = (FontResourcesParser.ProviderResourceEntry)entry;
                List<List<String>> givenCerts = providerEntry.getCerts();
                ArrayList<List<byte[]>> certs = new ArrayList<List<byte[]>>();
                if (givenCerts != null) {
                    for (int i = 0; i < givenCerts.size(); ++i) {
                        List<String> certSet = givenCerts.get(i);
                        ArrayList<byte[]> byteArraySet = new ArrayList<byte[]>();
                        for (int j = 0; j < certSet.size(); ++j) {
                            byteArraySet.add(Base64.decode(certSet.get(j), 0));
                        }
                        certs.add(byteArraySet);
                    }
                }
                return (typeface = FontsContract.getFontSync(request = new FontRequest(providerEntry.getAuthority(), providerEntry.getPackage(), providerEntry.getQuery(), certs))) == null ? DEFAULT : typeface;
            }
            Typeface typeface = Typeface.findFromCache(mgr, path);
            if (typeface != null) {
                return typeface;
            }
            FontResourcesParser.FontFamilyFilesResourceEntry filesEntry = (FontResourcesParser.FontFamilyFilesResourceEntry)entry;
            FontFamily fontFamily = new FontFamily();
            for (FontResourcesParser.FontFileResourceEntry fontFile : filesEntry.getEntries()) {
                if (fontFamily.addFontFromAssetManager(mgr, fontFile.getFileName(), 0, false, 0, fontFile.getWeight(), fontFile.getItalic(), null)) continue;
                return null;
            }
            if (!fontFamily.freeze()) {
                return null;
            }
            FontFamily[] familyChain = new FontFamily[]{fontFamily};
            typeface = Typeface.createFromFamiliesWithDefault(familyChain, -1, -1);
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
                sDynamicTypefaceCache.put(key, typeface);
            }
            return typeface;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface findFromCache(AssetManager mgr, String path) {
        LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    public static Typeface create(String familyName, int style2) {
        if (sSystemFontMap != null) {
            return Typeface.create(sSystemFontMap.get(familyName), style2);
        }
        return null;
    }

    public static Typeface create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        if (style2 < 0 || style2 > 3) {
            style2 = 0;
        }
        long ni = 0L;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    public static Typeface createFromTypefaceWithVariation(Typeface family, List<FontVariationAxis> axes) {
        long ni = family == null ? 0L : family.native_instance;
        return new Typeface(Typeface.nativeCreateFromTypefaceWithVariation(ni, axes));
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromAsset(AssetManager mgr, String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (sFallbackFonts != null) {
            Object object = sLock;
            synchronized (object) {
                Typeface typeface = new Builder(mgr, path).build();
                if (typeface != null) {
                    return typeface;
                }
                String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1);
                typeface = sDynamicTypefaceCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
                FontFamily fontFamily = new FontFamily();
                if (fontFamily.addFontFromAssetManager(mgr, path, 0, true, 0, -1, -1, null)) {
                    fontFamily.allowUnsupportedFont();
                    fontFamily.freeze();
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, -1, -1);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
                fontFamily.abortCreation();
            }
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    private static String createProviderUid(String authority, String query) {
        StringBuilder builder = new StringBuilder();
        builder.append("provider:");
        builder.append(authority);
        builder.append("-");
        builder.append(query);
        return builder.toString();
    }

    public static Typeface createFromFile(File path) {
        return Typeface.createFromFile(path.getAbsolutePath());
    }

    public static Typeface createFromFile(String path) {
        if (sFallbackFonts != null) {
            FontFamily fontFamily = new FontFamily();
            if (fontFamily.addFont(path, 0, null, -1, -1)) {
                fontFamily.allowUnsupportedFont();
                fontFamily.freeze();
                FontFamily[] families = new FontFamily[]{fontFamily};
                return Typeface.createFromFamiliesWithDefault(families, -1, -1);
            }
            fontFamily.abortCreation();
        }
        throw new RuntimeException("Font not found " + path);
    }

    private static Typeface createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1));
    }

    private static Typeface createFromFamiliesWithDefault(FontFamily[] families, int weight, int italic) {
        int i;
        long[] ptrArray = new long[families.length + sFallbackFonts.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < sFallbackFonts.length; ++i) {
            ptrArray[i + families.length] = Typeface.sFallbackFonts[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, weight, italic));
    }

    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
        this.mWeight = Typeface.nativeGetWeight(ni);
    }

    private static FontFamily makeFamilyFromParsed(FontConfig.Family family, Map<String, ByteBuffer> bufferForPath) {
        FontFamily fontFamily = new FontFamily(family.getLanguage(), family.getVariant());
        for (FontConfig.Font font : family.getFonts()) {
            String fullPathName = "/system/fonts/" + font.getFontName();
            ByteBuffer fontBuffer = bufferForPath.get(fullPathName);
            if (fontBuffer == null) {
                try (FileInputStream file = new FileInputStream(fullPathName);){
                    FileChannel fileChannel = file.getChannel();
                    long fontSize = fileChannel.size();
                    fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
                    bufferForPath.put(fullPathName, fontBuffer);
                }
                catch (IOException e) {
                    Log.e(TAG, "Error mapping font file " + fullPathName);
                    continue;
                }
            }
            if (fontFamily.addFontFromBuffer(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0)) continue;
            Log.e(TAG, "Error creating font " + fullPathName + "#" + font.getTtcIndex());
        }
        if (!fontFamily.freeze()) {
            Log.e(TAG, "Unable to load Family: " + family.getName() + ":" + family.getLanguage());
            return null;
        }
        return fontFamily;
    }

    private static void init() {
        File systemFontConfigLocation = Typeface.getSystemFontConfigLocation();
        File configFilename = new File(systemFontConfigLocation, FONTS_CONFIG);
        try {
            FileInputStream fontsIn = new FileInputStream(configFilename);
            FontConfig fontConfig = FontListParser.parse(fontsIn);
            HashMap<String, ByteBuffer> bufferForPath = new HashMap<String, ByteBuffer>();
            ArrayList<FontFamily> familyList = new ArrayList<FontFamily>();
            for (int i = 0; i < fontConfig.getFamilies().length; ++i) {
                FontFamily family;
                FontConfig.Family f = fontConfig.getFamilies()[i];
                if (i != 0 && f.getName() != null || (family = Typeface.makeFamilyFromParsed(f, bufferForPath)) == null) continue;
                familyList.add(family);
            }
            sFallbackFonts = familyList.toArray(new FontFamily[familyList.size()]);
            Typeface.setDefault(Typeface.createFromFamilies(sFallbackFonts));
            HashMap<String, Typeface> systemFonts = new HashMap<String, Typeface>();
            for (int i = 0; i < fontConfig.getFamilies().length; ++i) {
                Typeface typeface;
                FontConfig.Family f = fontConfig.getFamilies()[i];
                if (f.getName() == null) continue;
                if (i == 0) {
                    typeface = sDefaultTypeface;
                } else {
                    FontFamily fontFamily = Typeface.makeFamilyFromParsed(f, bufferForPath);
                    if (fontFamily == null) continue;
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, -1, -1);
                }
                systemFonts.put(f.getName(), typeface);
            }
            for (FontConfig.Alias alias : fontConfig.getAliases()) {
                Typeface base;
                Typeface newFace = base = (Typeface)systemFonts.get(alias.getToName());
                int weight = alias.getWeight();
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                systemFonts.put(alias.getName(), newFace);
            }
            sSystemFontMap = systemFonts;
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + configFilename, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + configFilename, e);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + configFilename, e);
        }
    }

    private static File getSystemFontConfigLocation() {
        return new File("/system/etc/");
    }

    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
            this.native_instance = 0L;
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedAxes(int axis) {
        if (this.mSupportedAxes == null) {
            Typeface typeface = this;
            synchronized (typeface) {
                if (this.mSupportedAxes == null) {
                    this.mSupportedAxes = Typeface.nativeGetSupportedAxes(this.native_instance);
                    if (this.mSupportedAxes == null) {
                        this.mSupportedAxes = EMPTY_AXES;
                    }
                }
            }
        }
        return Arrays.binarySearch(this.mSupportedAxes, axis) >= 0;
    }

    private static native long nativeCreateFromTypeface(long var0, int var2);

    private static native long nativeCreateFromTypefaceWithExactStyle(long var0, int var2, boolean var3);

    private static native long nativeCreateFromTypefaceWithVariation(long var0, List<FontVariationAxis> var2);

    private static native long nativeCreateWeightAlias(long var0, int var2);

    private static native void nativeUnref(long var0);

    private static native int nativeGetStyle(long var0);

    private static native int nativeGetWeight(long var0);

    private static native long nativeCreateFromArray(long[] var0, int var1, int var2);

    private static native void nativeSetDefault(long var0);

    private static native int[] nativeGetSupportedAxes(long var0);

    static {
        sTypefaceCache = new LongSparseArray(3);
        sDynamicTypefaceCache = new LruCache(16);
        sLock = new Object();
        EMPTY_AXES = new int[0];
        Typeface.init();
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }

    public static final class Builder {
        public static final int NORMAL_WEIGHT = 400;
        public static final int BOLD_WEIGHT = 700;
        private int mTtcIndex;
        private FontVariationAxis[] mAxes;
        private AssetManager mAssetManager;
        private String mPath;
        private FileDescriptor mFd;
        private FontsContract.FontInfo[] mFonts;
        private Map<Uri, ByteBuffer> mFontBuffers;
        private String mFallbackFamilyName;
        private int mWeight = -1;
        private int mItalic = -1;
        private static final Object sLock = new Object();
        @GuardedBy(value="sLock")
        private static final LongSparseArray<SparseArray<Typeface>> sTypefaceCache = new LongSparseArray(3);

        public Builder(File path) {
            this.mPath = path.getAbsolutePath();
        }

        public Builder(FileDescriptor fd) {
            this.mFd = fd;
        }

        public Builder(String path) {
            this.mPath = path;
        }

        public Builder(AssetManager assetManager, String path) {
            this.mAssetManager = Preconditions.checkNotNull(assetManager);
            this.mPath = Preconditions.checkStringNotEmpty(path);
        }

        public Builder(FontsContract.FontInfo[] fonts, Map<Uri, ByteBuffer> buffers) {
            this.mFonts = fonts;
            this.mFontBuffers = buffers;
        }

        public Builder setWeight(int weight) {
            this.mWeight = weight;
            return this;
        }

        public Builder setItalic(boolean italic) {
            this.mItalic = italic ? 1 : 0;
            return this;
        }

        public Builder setTtcIndex(int ttcIndex) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("TTC index can not be specified for FontResult source.");
            }
            this.mTtcIndex = ttcIndex;
            return this;
        }

        public Builder setFontVariationSettings(String variationSettings) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = FontVariationAxis.fromFontVariationSettings(variationSettings);
            return this;
        }

        public Builder setFontVariationSettings(FontVariationAxis[] axes) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = axes;
            return this;
        }

        public Builder setFallback(String familyName) {
            this.mFallbackFamilyName = familyName;
            return this;
        }

        private static String createAssetUid(AssetManager mgr, String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
            SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
            StringBuilder builder = new StringBuilder();
            int size = pkgs.size();
            for (int i = 0; i < size; ++i) {
                builder.append(pkgs.valueAt(i));
                builder.append("-");
            }
            builder.append(path);
            builder.append("-");
            builder.append(Integer.toString(ttcIndex));
            builder.append("-");
            builder.append(Integer.toString(weight));
            builder.append("-");
            builder.append(Integer.toString(italic));
            builder.append("-");
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    builder.append(axis.getTag());
                    builder.append("-");
                    builder.append(Float.toString(axis.getStyleValue()));
                }
            }
            return builder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Typeface resolveFallbackTypeface() {
            Typeface typeface;
            int weight;
            if (this.mFallbackFamilyName == null) {
                return null;
            }
            Typeface base = sSystemFontMap.get(this.mFallbackFamilyName);
            if (base == null) {
                base = sDefaultTypeface;
            }
            if (this.mWeight == -1 && this.mItalic == -1) {
                return base;
            }
            int n = weight = this.mWeight == -1 ? base.mWeight : this.mWeight;
            boolean italic = this.mItalic == -1 ? (base.mStyle & 2) != 0 : this.mItalic == 1;
            int key = weight << 1 | (italic ? 1 : 0);
            Object object = sLock;
            synchronized (object) {
                SparseArray<Typeface> innerCache = sTypefaceCache.get(base.native_instance);
                if (innerCache != null && (typeface = innerCache.get(key)) != null) {
                    return typeface;
                }
                typeface = new Typeface(Typeface.nativeCreateFromTypefaceWithExactStyle(base.native_instance, weight, italic));
                if (innerCache == null) {
                    innerCache = new SparseArray(4);
                    sTypefaceCache.put(base.native_instance, innerCache);
                }
                innerCache.put(key, typeface);
            }
            return typeface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Typeface build() {
            if (this.mFd != null) {
                try (FileInputStream fis = new FileInputStream(this.mFd);){
                    FileChannel channel = fis.getChannel();
                    long size = channel.size();
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromBuffer(buffer, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                        fontFamily.abortCreation();
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    if (!fontFamily.freeze()) {
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    Typeface typeface = Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
                    return typeface;
                }
                catch (IOException e) {
                    return this.resolveFallbackTypeface();
                }
            }
            if (this.mAssetManager != null) {
                String key = Builder.createAssetUid(this.mAssetManager, this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic);
                Object object = sLock;
                synchronized (object) {
                    Typeface typeface = (Typeface)sDynamicTypefaceCache.get(key);
                    if (typeface != null) {
                        return typeface;
                    }
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromAssetManager(this.mAssetManager, this.mPath, this.mTtcIndex, true, this.mTtcIndex, this.mWeight, this.mItalic, this.mAxes)) {
                        fontFamily.abortCreation();
                        return this.resolveFallbackTypeface();
                    }
                    if (!fontFamily.freeze()) {
                        return this.resolveFallbackTypeface();
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
            if (this.mPath != null) {
                FontFamily fontFamily = new FontFamily();
                if (!fontFamily.addFont(this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                    fontFamily.abortCreation();
                    return this.resolveFallbackTypeface();
                }
                if (!fontFamily.freeze()) {
                    return this.resolveFallbackTypeface();
                }
                FontFamily[] families = new FontFamily[]{fontFamily};
                return Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
            }
            if (this.mFonts == null) throw new IllegalArgumentException("No source was set.");
            FontFamily fontFamily = new FontFamily();
            boolean atLeastOneFont = false;
            for (FontsContract.FontInfo font : this.mFonts) {
                ByteBuffer fontBuffer = this.mFontBuffers.get(font.getUri());
                if (fontBuffer == null) continue;
                boolean success = fontFamily.addFontFromBuffer(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0);
                if (!success) {
                    fontFamily.abortCreation();
                    return null;
                }
                atLeastOneFont = true;
            }
            if (!atLeastOneFont) {
                fontFamily.abortCreation();
                return null;
            }
            fontFamily.freeze();
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families, this.mWeight, this.mItalic);
        }
    }
}

