/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.app.IInputForwarder;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.ITabletModeChangedListener;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.PointerIcon;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;

public interface IInputManager
extends IInterface {
    public InputDevice getInputDevice(int var1) throws RemoteException;

    public int[] getInputDeviceIds() throws RemoteException;

    public boolean isInputDeviceEnabled(int var1) throws RemoteException;

    public void enableInputDevice(int var1) throws RemoteException;

    public void disableInputDevice(int var1) throws RemoteException;

    public boolean hasKeys(int var1, int var2, int[] var3, boolean[] var4) throws RemoteException;

    public void tryPointerSpeed(int var1) throws RemoteException;

    public boolean injectInputEvent(InputEvent var1, int var2) throws RemoteException;

    public TouchCalibration getTouchCalibrationForInputDevice(String var1, int var2) throws RemoteException;

    public void setTouchCalibrationForInputDevice(String var1, int var2, TouchCalibration var3) throws RemoteException;

    public KeyboardLayout[] getKeyboardLayouts() throws RemoteException;

    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier var1) throws RemoteException;

    public KeyboardLayout getKeyboardLayout(String var1) throws RemoteException;

    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier var1) throws RemoteException;

    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, String var2) throws RemoteException;

    public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier var1) throws RemoteException;

    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, String var2) throws RemoteException;

    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, String var2) throws RemoteException;

    public KeyboardLayout getKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, InputMethodInfo var2, InputMethodSubtype var3) throws RemoteException;

    public void setKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, InputMethodInfo var2, InputMethodSubtype var3, String var4) throws RemoteException;

    public void registerInputDevicesChangedListener(IInputDevicesChangedListener var1) throws RemoteException;

    public int isInTabletMode() throws RemoteException;

    public void registerTabletModeChangedListener(ITabletModeChangedListener var1) throws RemoteException;

    public void vibrate(int var1, long[] var2, int var3, IBinder var4) throws RemoteException;

    public void cancelVibrate(int var1, IBinder var2) throws RemoteException;

    public void setPointerIconType(int var1) throws RemoteException;

    public void setCustomPointerIcon(PointerIcon var1) throws RemoteException;

    public void requestPointerCapture(IBinder var1, boolean var2) throws RemoteException;

    public IInputForwarder createInputForwarder(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputManager {
        private static final String DESCRIPTOR = "android.hardware.input.IInputManager";
        static final int TRANSACTION_getInputDevice = 1;
        static final int TRANSACTION_getInputDeviceIds = 2;
        static final int TRANSACTION_isInputDeviceEnabled = 3;
        static final int TRANSACTION_enableInputDevice = 4;
        static final int TRANSACTION_disableInputDevice = 5;
        static final int TRANSACTION_hasKeys = 6;
        static final int TRANSACTION_tryPointerSpeed = 7;
        static final int TRANSACTION_injectInputEvent = 8;
        static final int TRANSACTION_getTouchCalibrationForInputDevice = 9;
        static final int TRANSACTION_setTouchCalibrationForInputDevice = 10;
        static final int TRANSACTION_getKeyboardLayouts = 11;
        static final int TRANSACTION_getKeyboardLayoutsForInputDevice = 12;
        static final int TRANSACTION_getKeyboardLayout = 13;
        static final int TRANSACTION_getCurrentKeyboardLayoutForInputDevice = 14;
        static final int TRANSACTION_setCurrentKeyboardLayoutForInputDevice = 15;
        static final int TRANSACTION_getEnabledKeyboardLayoutsForInputDevice = 16;
        static final int TRANSACTION_addKeyboardLayoutForInputDevice = 17;
        static final int TRANSACTION_removeKeyboardLayoutForInputDevice = 18;
        static final int TRANSACTION_getKeyboardLayoutForInputDevice = 19;
        static final int TRANSACTION_setKeyboardLayoutForInputDevice = 20;
        static final int TRANSACTION_registerInputDevicesChangedListener = 21;
        static final int TRANSACTION_isInTabletMode = 22;
        static final int TRANSACTION_registerTabletModeChangedListener = 23;
        static final int TRANSACTION_vibrate = 24;
        static final int TRANSACTION_cancelVibrate = 25;
        static final int TRANSACTION_setPointerIconType = 26;
        static final int TRANSACTION_setCustomPointerIcon = 27;
        static final int TRANSACTION_requestPointerCapture = 28;
        static final int TRANSACTION_createInputForwarder = 29;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputManager) {
                return (IInputManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    InputDevice _result = this.getInputDevice(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int[] _result = this.getInputDeviceIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _result = this.isInputDeviceEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.enableInputDevice(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.disableInputDevice(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    int _arg3_length = data.readInt();
                    boolean[] _arg3 = _arg3_length < 0 ? null : new boolean[_arg3_length];
                    boolean _result = this.hasKeys(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    reply.writeBooleanArray(_arg3);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.tryPointerSpeed(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    InputEvent _arg0 = 0 != data.readInt() ? InputEvent.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    boolean _result = this.injectInputEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    TouchCalibration _result = this.getTouchCalibrationForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    TouchCalibration _arg2 = 0 != data.readInt() ? TouchCalibration.CREATOR.createFromParcel(data) : null;
                    this.setTouchCalibrationForInputDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    Parcelable[] _result = this.getKeyboardLayouts();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    Parcelable[] _result = this.getKeyboardLayoutsForInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    KeyboardLayout _result = this.getKeyboardLayout(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    String _result = this.getCurrentKeyboardLayoutForInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.setCurrentKeyboardLayoutForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    String[] _result = this.getEnabledKeyboardLayoutsForInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.addKeyboardLayoutForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    this.removeKeyboardLayoutForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    InputMethodInfo _arg1 = 0 != data.readInt() ? InputMethodInfo.CREATOR.createFromParcel(data) : null;
                    InputMethodSubtype _arg2 = 0 != data.readInt() ? InputMethodSubtype.CREATOR.createFromParcel(data) : null;
                    KeyboardLayout _result = this.getKeyboardLayoutForInputDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    InputDeviceIdentifier _arg0 = 0 != data.readInt() ? InputDeviceIdentifier.CREATOR.createFromParcel(data) : null;
                    InputMethodInfo _arg1 = 0 != data.readInt() ? InputMethodInfo.CREATOR.createFromParcel(data) : null;
                    InputMethodSubtype _arg2 = 0 != data.readInt() ? InputMethodSubtype.CREATOR.createFromParcel(data) : null;
                    String _arg3 = data.readString();
                    this.setKeyboardLayoutForInputDevice(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    IInputDevicesChangedListener _arg0 = IInputDevicesChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.registerInputDevicesChangedListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.isInTabletMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    ITabletModeChangedListener _arg0 = ITabletModeChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.registerTabletModeChangedListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    long[] _arg1 = data.createLongArray();
                    int _arg2 = data.readInt();
                    IBinder _arg3 = data.readStrongBinder();
                    this.vibrate(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    this.cancelVibrate(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.setPointerIconType(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    PointerIcon _arg0 = 0 != data.readInt() ? PointerIcon.CREATOR.createFromParcel(data) : null;
                    this.setCustomPointerIcon(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    this.requestPointerCapture(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    IInputForwarder _result = this.createInputForwarder(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IInputManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputDevice getInputDevice(int deviceId) throws RemoteException {
                InputDevice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? InputDevice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getInputDeviceIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInputDeviceEnabled(int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableInputDevice(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableInputDevice(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasKeys(int deviceId, int sourceMask, int[] keyCodes, boolean[] keyExists) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sourceMask);
                    _data.writeIntArray(keyCodes);
                    if (keyExists == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(keyExists.length);
                    }
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    _reply.readBooleanArray(keyExists);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tryPointerSpeed(int speed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(speed);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean injectInputEvent(InputEvent ev, int mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (ev != null) {
                        _data.writeInt(1);
                        ev.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(mode);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TouchCalibration getTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation) throws RemoteException {
                TouchCalibration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    _data.writeInt(rotation);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? TouchCalibration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation, TouchCalibration calibration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    _data.writeInt(rotation);
                    if (calibration != null) {
                        _data.writeInt(1);
                        calibration.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout[] getKeyboardLayouts() throws RemoteException {
                KeyboardLayout[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
                KeyboardLayout[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) throws RemoteException {
                KeyboardLayout _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(keyboardLayoutDescriptor);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeyboardLayout.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(keyboardLayoutDescriptor);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(keyboardLayoutDescriptor);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(keyboardLayoutDescriptor);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout getKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype) throws RemoteException {
                KeyboardLayout _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (imeInfo != null) {
                        _data.writeInt(1);
                        imeInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (imeSubtype != null) {
                        _data.writeInt(1);
                        imeSubtype.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeyboardLayout.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (identifier != null) {
                        _data.writeInt(1);
                        identifier.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (imeInfo != null) {
                        _data.writeInt(1);
                        imeInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (imeSubtype != null) {
                        _data.writeInt(1);
                        imeSubtype.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(keyboardLayoutDescriptor);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerInputDevicesChangedListener(IInputDevicesChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isInTabletMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTabletModeChangedListener(ITabletModeChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrate(int deviceId, long[] pattern, int repeat, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeLongArray(pattern);
                    _data.writeInt(repeat);
                    _data.writeStrongBinder(token);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelVibrate(int deviceId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongBinder(token);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPointerIconType(int typeId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(typeId);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCustomPointerIcon(PointerIcon icon) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (icon != null) {
                        _data.writeInt(1);
                        icon.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestPointerCapture(IBinder windowToken, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(enabled ? 1 : 0);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IInputForwarder createInputForwarder(int displayId) throws RemoteException {
                IInputForwarder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = IInputForwarder.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

