/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.hardware.location.NanoAppInstanceInfo;
import android.os.Parcel;
import android.os.Parcelable;

public class NanoAppFilter {
    private static final String TAG = "NanoAppFilter";
    private long mAppId;
    private int mAppVersion;
    private int mVersionRestrictionMask;
    private long mAppIdVendorMask;
    private int mContextHubId = -1;
    public static final int FLAGS_VERSION_ANY = -1;
    public static final int FLAGS_VERSION_GREAT_THAN = 2;
    public static final int FLAGS_VERSION_LESS_THAN = 4;
    public static final int FLAGS_VERSION_STRICTLY_EQUAL = 8;
    public static final int APP_ANY = -1;
    public static final int VENDOR_ANY = -1;
    public static final int HUB_ANY = -1;
    public static final Parcelable.Creator<NanoAppFilter> CREATOR = new Parcelable.Creator<NanoAppFilter>(){

        @Override
        public NanoAppFilter createFromParcel(Parcel in) {
            return new NanoAppFilter(in);
        }

        public NanoAppFilter[] newArray(int size) {
            return new NanoAppFilter[size];
        }
    };

    private NanoAppFilter(Parcel in) {
        this.mAppId = in.readLong();
        this.mAppVersion = in.readInt();
        this.mVersionRestrictionMask = in.readInt();
        this.mAppIdVendorMask = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mAppId);
        out.writeInt(this.mAppVersion);
        out.writeInt(this.mVersionRestrictionMask);
        out.writeLong(this.mAppIdVendorMask);
    }

    public NanoAppFilter(long appId, int appVersion, int versionMask, long vendorMask) {
        this.mAppId = appId;
        this.mAppVersion = appVersion;
        this.mVersionRestrictionMask = versionMask;
        this.mAppIdVendorMask = vendorMask;
    }

    private boolean versionsMatch(int versionRestrictionMask, int expected, int actual) {
        return true;
    }

    public boolean testMatch(NanoAppInstanceInfo info) {
        return !(this.mContextHubId != -1 && info.getContexthubId() != this.mContextHubId || this.mAppId != -1L && info.getAppId() != this.mAppId || !this.versionsMatch(this.mVersionRestrictionMask, this.mAppVersion, info.getAppVersion()));
    }
}

