/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.graphics.Bitmap;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioTuner;
import android.os.RemoteException;
import android.util.Log;
import java.util.List;
import java.util.Map;

class TunerAdapter
extends RadioTuner {
    private static final String TAG = "BroadcastRadio.TunerAdapter";
    private final ITuner mTuner;
    private boolean mIsClosed = false;
    private int mBand;

    TunerAdapter(ITuner tuner, int band) {
        if (tuner == null) {
            throw new NullPointerException();
        }
        this.mTuner = tuner;
        this.mBand = band;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ITuner iTuner = this.mTuner;
        synchronized (iTuner) {
            if (this.mIsClosed) {
                Log.v(TAG, "Tuner is already closed");
                return;
            }
            this.mIsClosed = true;
        }
        try {
            this.mTuner.close();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception trying to close tuner", e);
        }
    }

    @Override
    public int setConfiguration(RadioManager.BandConfig config) {
        try {
            this.mTuner.setConfiguration(config);
            this.mBand = config.getType();
            return 0;
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Can't set configuration", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
    }

    @Override
    public int getConfiguration(RadioManager.BandConfig[] config) {
        if (config == null || config.length != 1) {
            throw new IllegalArgumentException("The argument must be an array of length 1");
        }
        try {
            config[0] = this.mTuner.getConfiguration();
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
    }

    @Override
    public int setMute(boolean mute) {
        try {
            this.mTuner.setMuted(mute);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't set muted", e);
            return Integer.MIN_VALUE;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public boolean getMute() {
        try {
            return this.mTuner.isMuted();
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return true;
        }
    }

    @Override
    public int step(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.step(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't step", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public int scan(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.scan(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't scan", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public int tune(int channel, int subChannel) {
        try {
            this.mTuner.tune(ProgramSelector.createAmFmSelector(this.mBand, channel, subChannel));
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't tune", e);
            return -38;
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Can't tune", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public void tune(ProgramSelector selector) {
        try {
            this.mTuner.tune(selector);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public int cancel() {
        try {
            this.mTuner.cancel();
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't cancel", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public void cancelAnnouncement() {
        try {
            this.mTuner.cancelAnnouncement();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public int getProgramInformation(RadioManager.ProgramInfo[] info) {
        if (info == null || info.length != 1) {
            throw new IllegalArgumentException("The argument must be an array of length 1");
        }
        try {
            info[0] = this.mTuner.getProgramInformation();
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "service died", e);
            return -32;
        }
    }

    @Override
    public Bitmap getMetadataImage(int id2) {
        try {
            return this.mTuner.getImage(id2);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public boolean startBackgroundScan() {
        try {
            return this.mTuner.startBackgroundScan();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public List<RadioManager.ProgramInfo> getProgramList(Map<String, String> vendorFilter) {
        try {
            return this.mTuner.getProgramList(vendorFilter);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public boolean isAnalogForced() {
        try {
            return this.mTuner.isAnalogForced();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public void setAnalogForced(boolean isForced) {
        try {
            this.mTuner.setAnalogForced(isForced);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public boolean isAntennaConnected() {
        try {
            return this.mTuner.isAntennaConnected();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    @Override
    public boolean hasControl() {
        try {
            return !this.mTuner.isClosed();
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

