/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import java.nio.BufferOverflowException;
import java.util.Arrays;

public final class Edits {
    private static final int MAX_UNCHANGED_LENGTH = 4096;
    private static final int MAX_UNCHANGED = 4095;
    private static final int MAX_SHORT_WIDTH = 6;
    private static final int MAX_SHORT_CHANGE_LENGTH = 4095;
    private static final int MAX_SHORT_CHANGE = 28671;
    private static final int LENGTH_IN_1TRAIL = 61;
    private static final int LENGTH_IN_2TRAIL = 62;
    private static final int STACK_CAPACITY = 100;
    private char[] array = new char[100];
    private int length;
    private int delta;

    public void reset() {
        this.delta = 0;
        this.length = 0;
    }

    private void setLastUnit(int last) {
        this.array[this.length - 1] = (char)last;
    }

    private int lastUnit() {
        return this.length > 0 ? this.array[this.length - 1] : 65535;
    }

    public void addUnchanged(int unchangedLength) {
        if (unchangedLength < 0) {
            throw new IllegalArgumentException("addUnchanged(" + unchangedLength + "): length must not be negative");
        }
        int last = this.lastUnit();
        if (last < 4095) {
            int remaining = 4095 - last;
            if (remaining >= unchangedLength) {
                this.setLastUnit(last + unchangedLength);
                return;
            }
            this.setLastUnit(4095);
            unchangedLength -= remaining;
        }
        while (unchangedLength >= 4096) {
            this.append(4095);
            unchangedLength -= 4096;
        }
        if (unchangedLength > 0) {
            this.append(unchangedLength - 1);
        }
    }

    public void addReplace(int oldLength, int newLength) {
        if (oldLength == newLength && 0 < oldLength && oldLength <= 6) {
            int last = this.lastUnit();
            if (4095 < last && last < 28671 && last >> 12 == oldLength && (last & 0xFFF) < 4095) {
                this.setLastUnit(last + 1);
                return;
            }
            this.append(oldLength << 12);
            return;
        }
        if (oldLength < 0 || newLength < 0) {
            throw new IllegalArgumentException("addReplace(" + oldLength + ", " + newLength + "): both lengths must be non-negative");
        }
        if (oldLength == 0 && newLength == 0) {
            return;
        }
        int newDelta = newLength - oldLength;
        if (newDelta != 0) {
            if (newDelta > 0 && this.delta >= 0 && newDelta > Integer.MAX_VALUE - this.delta || newDelta < 0 && this.delta < 0 && newDelta < Integer.MIN_VALUE - this.delta) {
                throw new IndexOutOfBoundsException();
            }
            this.delta += newDelta;
        }
        int head = 28672;
        if (oldLength < 61 && newLength < 61) {
            head |= oldLength << 6;
            this.append(head |= newLength);
        } else if (this.array.length - this.length >= 5 || this.growArray()) {
            int limit = this.length + 1;
            if (oldLength < 61) {
                head |= oldLength << 6;
            } else if (oldLength <= Short.MAX_VALUE) {
                head |= 0xF40;
                this.array[limit++] = (char)(0x8000 | oldLength);
            } else {
                head |= 62 + (oldLength >> 30) << 6;
                this.array[limit++] = (char)(0x8000 | oldLength >> 15);
                this.array[limit++] = (char)(0x8000 | oldLength);
            }
            if (newLength < 61) {
                head |= newLength;
            } else if (newLength <= Short.MAX_VALUE) {
                head |= 0x3D;
                this.array[limit++] = (char)(0x8000 | newLength);
            } else {
                head |= 62 + (newLength >> 30);
                this.array[limit++] = (char)(0x8000 | newLength >> 15);
                this.array[limit++] = (char)(0x8000 | newLength);
            }
            this.array[this.length] = (char)head;
            this.length = limit;
        }
    }

    private void append(int r) {
        if (this.length < this.array.length || this.growArray()) {
            this.array[this.length++] = (char)r;
        }
    }

    private boolean growArray() {
        int newCapacity;
        if (this.array.length == 100) {
            newCapacity = 2000;
        } else {
            if (this.array.length == Integer.MAX_VALUE) {
                throw new BufferOverflowException();
            }
            newCapacity = this.array.length >= 0x3FFFFFFF ? Integer.MAX_VALUE : 2 * this.array.length;
        }
        if (newCapacity - this.array.length < 5) {
            throw new BufferOverflowException();
        }
        this.array = Arrays.copyOf(this.array, newCapacity);
        return true;
    }

    public int lengthDelta() {
        return this.delta;
    }

    public boolean hasChanges() {
        if (this.delta != 0) {
            return true;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.array[i] <= '\u0fff') continue;
            return true;
        }
        return false;
    }

    public Iterator getCoarseChangesIterator() {
        return new Iterator(this.array, this.length, true, true);
    }

    public Iterator getCoarseIterator() {
        return new Iterator(this.array, this.length, false, true);
    }

    public Iterator getFineChangesIterator() {
        return new Iterator(this.array, this.length, true, false);
    }

    public Iterator getFineIterator() {
        return new Iterator(this.array, this.length, false, false);
    }

    public static final class Iterator {
        private final char[] array;
        private int index;
        private final int length;
        private int remaining;
        private final boolean onlyChanges_;
        private final boolean coarse;
        private boolean changed;
        private int oldLength_;
        private int newLength_;
        private int srcIndex;
        private int replIndex;
        private int destIndex;

        private Iterator(char[] a, int len, boolean oc, boolean crs) {
            this.array = a;
            this.length = len;
            this.onlyChanges_ = oc;
            this.coarse = crs;
        }

        private int readLength(int head) {
            if (head < 61) {
                return head;
            }
            if (head < 62) {
                assert (this.index < this.length);
                assert (this.array[this.index] >= '\u8000');
                return this.array[this.index++] & Short.MAX_VALUE;
            }
            assert (this.index + 2 <= this.length);
            assert (this.array[this.index] >= '\u8000');
            assert (this.array[this.index + 1] >= '\u8000');
            int len = (head & 1) << 30 | (this.array[this.index] & Short.MAX_VALUE) << 15 | this.array[this.index + 1] & Short.MAX_VALUE;
            this.index += 2;
            return len;
        }

        private void updateIndexes() {
            this.srcIndex += this.oldLength_;
            if (this.changed) {
                this.replIndex += this.newLength_;
            }
            this.destIndex += this.newLength_;
        }

        private boolean noNext() {
            this.changed = false;
            this.newLength_ = 0;
            this.oldLength_ = 0;
            return false;
        }

        public boolean next() {
            return this.next(this.onlyChanges_);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean next(boolean onlyChanges) {
            int len;
            int w;
            char u;
            this.updateIndexes();
            if (this.remaining > 0) {
                --this.remaining;
                return true;
            }
            if (this.index >= this.length) {
                return this.noNext();
            }
            if ((u = this.array[this.index++]) <= '\u0fff') {
                this.changed = false;
                this.oldLength_ = u + '\u0001';
                while (this.index < this.length && (u = this.array[this.index]) <= '\u0fff') {
                    ++this.index;
                    this.oldLength_ += u + '\u0001';
                }
                this.newLength_ = this.oldLength_;
                if (!onlyChanges) {
                    return true;
                }
                this.updateIndexes();
                if (this.index >= this.length) {
                    return this.noNext();
                }
                ++this.index;
            }
            this.changed = true;
            if (u <= '\u6fff') {
                if (!this.coarse) {
                    this.oldLength_ = this.newLength_ = u >> 12;
                    this.remaining = u & 0xFFF;
                    return true;
                }
                w = u >> 12;
                len = (u & 0xFFF) + 1;
                this.oldLength_ = this.newLength_ = len * w;
            } else {
                assert (u <= Short.MAX_VALUE);
                this.oldLength_ = this.readLength(u >> 6 & 0x3F);
                this.newLength_ = this.readLength(u & 0x3F);
                if (!this.coarse) {
                    return true;
                }
            }
            while (this.index < this.length && (u = this.array[this.index]) > '\u0fff') {
                ++this.index;
                if (u <= '\u6fff') {
                    w = u >> 12;
                    len = (u & 0xFFF) + 1;
                    this.oldLength_ += (len *= w);
                    this.newLength_ += len;
                    continue;
                }
                assert (u <= Short.MAX_VALUE);
                int oldLen = this.readLength(u >> 6 & 0x3F);
                int newLen = this.readLength(u & 0x3F);
                this.oldLength_ += oldLen;
                this.newLength_ += newLen;
            }
            return true;
        }

        public boolean findSourceIndex(int i) {
            if (i < 0) {
                return false;
            }
            if (i < this.srcIndex) {
                this.destIndex = 0;
                this.replIndex = 0;
                this.srcIndex = 0;
                this.newLength_ = 0;
                this.oldLength_ = 0;
                this.remaining = 0;
                this.index = 0;
            } else if (i < this.srcIndex + this.oldLength_) {
                return true;
            }
            while (this.next(false)) {
                if (i < this.srcIndex + this.oldLength_) {
                    return true;
                }
                if (this.remaining <= 0) continue;
                int len = (this.remaining + 1) * this.oldLength_;
                if (i < this.srcIndex + len) {
                    int n = (i - this.srcIndex) / this.oldLength_;
                    len = n * this.oldLength_;
                    this.srcIndex += len;
                    this.replIndex += len;
                    this.destIndex += len;
                    this.remaining -= n;
                    return true;
                }
                this.oldLength_ = this.newLength_ = len;
                this.remaining = 0;
            }
            return false;
        }

        public boolean hasChange() {
            return this.changed;
        }

        public int oldLength() {
            return this.oldLength_;
        }

        public int newLength() {
            return this.newLength_;
        }

        public int sourceIndex() {
            return this.srcIndex;
        }

        public int replacementIndex() {
            return this.replIndex;
        }

        public int destinationIndex() {
            return this.destIndex;
        }
    }
}

