/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.content.Context;
import android.location.BatchedLocationCallback;
import android.location.IBatchedLocationCallback;
import android.location.ILocationManager;
import android.location.LocalListenerHelper;
import android.location.Location;
import android.os.RemoteException;
import java.util.List;

class BatchedLocationCallbackTransport
extends LocalListenerHelper<BatchedLocationCallback> {
    private final ILocationManager mLocationManager;
    private final IBatchedLocationCallback mCallbackTransport = new CallbackTransport();

    public BatchedLocationCallbackTransport(Context context, ILocationManager locationManager) {
        super(context, "BatchedLocationCallbackTransport");
        this.mLocationManager = locationManager;
    }

    @Override
    protected boolean registerWithServer() throws RemoteException {
        return this.mLocationManager.addGnssBatchingCallback(this.mCallbackTransport, this.getContext().getPackageName());
    }

    @Override
    protected void unregisterFromServer() throws RemoteException {
        this.mLocationManager.removeGnssBatchingCallback();
    }

    private class CallbackTransport
    extends IBatchedLocationCallback.Stub {
        private CallbackTransport() {
        }

        @Override
        public void onLocationBatch(final List<Location> locations) {
            LocalListenerHelper.ListenerOperation<BatchedLocationCallback> operation = new LocalListenerHelper.ListenerOperation<BatchedLocationCallback>(){

                @Override
                public void execute(BatchedLocationCallback callback) throws RemoteException {
                    callback.onLocationBatch(locations);
                }
            };
            BatchedLocationCallbackTransport.this.foreach(operation);
        }
    }
}

