/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

abstract class LocalListenerHelper<TListener> {
    private final HashMap<TListener, Handler> mListeners = new HashMap();
    private final String mTag;
    private final Context mContext;

    protected LocalListenerHelper(Context context, String name) {
        Preconditions.checkNotNull(name);
        this.mContext = context;
        this.mTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(TListener listener, Handler handler) {
        Preconditions.checkNotNull(listener);
        HashMap<TListener, Handler> hashMap = this.mListeners;
        synchronized (hashMap) {
            if (this.mListeners.isEmpty()) {
                boolean registeredWithService;
                try {
                    registeredWithService = this.registerWithServer();
                }
                catch (RemoteException e) {
                    Log.e(this.mTag, "Error handling first listener.", e);
                    return false;
                }
                if (!registeredWithService) {
                    Log.e(this.mTag, "Unable to register listener transport.");
                    return false;
                }
            }
            if (this.mListeners.containsKey(listener)) {
                return true;
            }
            this.mListeners.put(listener, handler);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TListener listener) {
        Preconditions.checkNotNull(listener);
        HashMap<TListener, Handler> hashMap = this.mListeners;
        synchronized (hashMap) {
            boolean isLastRemoved;
            boolean removed = this.mListeners.containsKey(listener);
            this.mListeners.remove(listener);
            boolean bl = isLastRemoved = removed && this.mListeners.isEmpty();
            if (isLastRemoved) {
                try {
                    this.unregisterFromServer();
                }
                catch (RemoteException e) {
                    Log.v(this.mTag, "Error handling last listener removal", e);
                }
            }
        }
    }

    protected abstract boolean registerWithServer() throws RemoteException;

    protected abstract void unregisterFromServer() throws RemoteException;

    protected Context getContext() {
        return this.mContext;
    }

    private void executeOperation(ListenerOperation<TListener> operation, TListener listener) {
        try {
            operation.execute(listener);
        }
        catch (RemoteException e) {
            Log.e(this.mTag, "Error in monitored listener.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foreach(final ListenerOperation<TListener> operation) {
        ArrayList<Map.Entry<TListener, Handler>> listeners;
        HashMap<TListener, Handler> hashMap = this.mListeners;
        synchronized (hashMap) {
            listeners = new ArrayList<Map.Entry<TListener, Handler>>(this.mListeners.entrySet());
        }
        for (final Map.Entry entry : listeners) {
            if (entry.getValue() == null) {
                this.executeOperation(operation, entry.getKey());
                continue;
            }
            ((Handler)entry.getValue()).post(new Runnable(){

                @Override
                public void run() {
                    LocalListenerHelper.this.executeOperation(operation, entry.getKey());
                }
            });
        }
    }

    protected static interface ListenerOperation<TListener> {
        public void execute(TListener var1) throws RemoteException;
    }
}

