/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.PlayerBase;
import android.media.VolumeShaper;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SoundPool
extends PlayerBase {
    private static final int SAMPLE_LOADED = 1;
    private static final String TAG = "SoundPool";
    private static final boolean DEBUG;
    private long mNativeContext;
    private EventHandler mEventHandler;
    private OnLoadCompleteListener mOnLoadCompleteListener;
    private boolean mHasAppOpsPlayAudio;
    private final Object mLock;
    private final AudioAttributes mAttributes;

    public SoundPool(int maxStreams, int streamType, int srcQuality) {
        this(maxStreams, new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build());
        PlayerBase.deprecateStreamTypeForPlayback(streamType, TAG, "SoundPool()");
    }

    private SoundPool(int maxStreams, AudioAttributes attributes) {
        super(attributes, 3);
        if (this.native_setup(new WeakReference<SoundPool>(this), maxStreams, attributes) != 0) {
            throw new RuntimeException("Native setup failed");
        }
        this.mLock = new Object();
        this.mAttributes = attributes;
        this.baseRegisterPlayer();
    }

    public final void release() {
        this.baseRelease();
        this.native_release();
    }

    private final native void native_release();

    protected void finalize() {
        this.release();
    }

    public int load(String path, int priority) {
        int id2 = 0;
        try {
            File f = new File(path);
            ParcelFileDescriptor fd = ParcelFileDescriptor.open(f, 0x10000000);
            if (fd != null) {
                id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                fd.close();
            }
        }
        catch (IOException e) {
            Log.e(TAG, "error loading " + path);
        }
        return id2;
    }

    public int load(Context context, int resId, int priority) {
        AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
        int id2 = 0;
        if (afd != null) {
            id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
            try {
                afd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return id2;
    }

    public int load(AssetFileDescriptor afd, int priority) {
        if (afd != null) {
            long len = afd.getLength();
            if (len < 0L) {
                throw new AndroidRuntimeException("no length for fd");
            }
            return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
        }
        return 0;
    }

    public int load(FileDescriptor fd, long offset, long length, int priority) {
        return this._load(fd, offset, length, priority);
    }

    public final native boolean unload(int var1);

    public final int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        this.baseStart();
        return this._play(soundID, leftVolume, rightVolume, priority, loop, rate);
    }

    public final native void pause(int var1);

    public final native void resume(int var1);

    public final native void autoPause();

    public final native void autoResume();

    public final native void stop(int var1);

    public final void setVolume(int streamID, float leftVolume, float rightVolume) {
        this._setVolume(streamID, leftVolume, rightVolume);
    }

    @Override
    int playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return -1;
    }

    @Override
    VolumeShaper.State playerGetVolumeShaperState(int id2) {
        return null;
    }

    @Override
    void playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
        this._mute(muting);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean muting, float level) {
        return 0;
    }

    @Override
    void playerStart() {
    }

    @Override
    void playerPause() {
    }

    @Override
    void playerStop() {
    }

    public void setVolume(int streamID, float volume) {
        this.setVolume(streamID, volume, volume);
    }

    public final native void setPriority(int var1, int var2);

    public final native void setLoop(int var1, int var2);

    public final native void setRate(int var1, float var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Looper looper;
            this.mEventHandler = listener != null ? ((looper = Looper.myLooper()) != null ? new EventHandler(looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(looper) : null)) : null;
            this.mOnLoadCompleteListener = listener;
        }
    }

    private final native int _load(FileDescriptor var1, long var2, long var4, int var6);

    private final native int native_setup(Object var1, int var2, Object var3);

    private final native int _play(int var1, float var2, float var3, int var4, int var5, float var6);

    private final native void _setVolume(int var1, float var2, float var3);

    private final native void _mute(boolean var1);

    private static void postEventFromNative(Object ref, int msg, int arg1, int arg2, Object obj) {
        SoundPool soundPool = (SoundPool)((WeakReference)ref).get();
        if (soundPool == null) {
            return;
        }
        if (soundPool.mEventHandler != null) {
            Message m = soundPool.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
            soundPool.mEventHandler.sendMessage(m);
        }
    }

    static {
        System.loadLibrary("soundpool");
        DEBUG = Log.isLoggable(TAG, 3);
    }

    public static class Builder {
        private int mMaxStreams = 1;
        private AudioAttributes mAudioAttributes;

        public Builder setMaxStreams(int maxStreams) throws IllegalArgumentException {
            if (maxStreams <= 0) {
                throw new IllegalArgumentException("Strictly positive value required for the maximum number of streams");
            }
            this.mMaxStreams = maxStreams;
            return this;
        }

        public Builder setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Invalid null AudioAttributes");
            }
            this.mAudioAttributes = attributes;
            return this;
        }

        public SoundPool build() {
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new SoundPool(this.mMaxStreams, this.mAudioAttributes);
        }
    }

    private final class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (DEBUG) {
                        Log.d(SoundPool.TAG, "Sample " + msg.arg1 + " loaded");
                    }
                    Object object = SoundPool.this.mLock;
                    synchronized (object) {
                        if (SoundPool.this.mOnLoadCompleteListener != null) {
                            SoundPool.this.mOnLoadCompleteListener.onLoadComplete(SoundPool.this, msg.arg1, msg.arg2);
                        }
                        break;
                    }
                }
                default: {
                    Log.e(SoundPool.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }
}

