/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;

public class AutomaticGainControl
extends AudioEffect {
    private static final String TAG = "AutomaticGainControl";

    public static boolean isAvailable() {
        return AudioEffect.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AGC);
    }

    public static AutomaticGainControl create(int audioSession) {
        AutomaticGainControl agc = null;
        try {
            agc = new AutomaticGainControl(audioSession);
        }
        catch (IllegalArgumentException e) {
            Log.w(TAG, "not implemented on this device " + agc);
        }
        catch (UnsupportedOperationException e) {
            Log.w(TAG, "not enough resources");
        }
        catch (RuntimeException e) {
            Log.w(TAG, "not enough memory");
        }
        return agc;
    }

    private AutomaticGainControl(int audioSession) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_AGC, EFFECT_TYPE_NULL, 0, audioSession);
    }
}

