/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import java.util.StringTokenizer;

public class EnvironmentalReverb
extends AudioEffect {
    private static final String TAG = "EnvironmentalReverb";
    public static final int PARAM_ROOM_LEVEL = 0;
    public static final int PARAM_ROOM_HF_LEVEL = 1;
    public static final int PARAM_DECAY_TIME = 2;
    public static final int PARAM_DECAY_HF_RATIO = 3;
    public static final int PARAM_REFLECTIONS_LEVEL = 4;
    public static final int PARAM_REFLECTIONS_DELAY = 5;
    public static final int PARAM_REVERB_LEVEL = 6;
    public static final int PARAM_REVERB_DELAY = 7;
    public static final int PARAM_DIFFUSION = 8;
    public static final int PARAM_DENSITY = 9;
    private static final int PARAM_PROPERTIES = 10;
    private OnParameterChangeListener mParamListener = null;
    private BaseParameterListener mBaseParamListener = null;
    private final Object mParamListenerLock = new Object();
    private static int PROPERTY_SIZE = 26;

    public EnvironmentalReverb(int priority, int audioSession) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_ENV_REVERB, EFFECT_TYPE_NULL, priority, audioSession);
    }

    public void setRoomLevel(short room) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.shortToByteArray(room);
        this.checkStatus(this.setParameter(0, param));
    }

    public short getRoomLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[2];
        this.checkStatus(this.getParameter(0, param));
        return EnvironmentalReverb.byteArrayToShort(param);
    }

    public void setRoomHFLevel(short roomHF) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.shortToByteArray(roomHF);
        this.checkStatus(this.setParameter(1, param));
    }

    public short getRoomHFLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[2];
        this.checkStatus(this.getParameter(1, param));
        return EnvironmentalReverb.byteArrayToShort(param);
    }

    public void setDecayTime(int decayTime) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.intToByteArray(decayTime);
        this.checkStatus(this.setParameter(2, param));
    }

    public int getDecayTime() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[4];
        this.checkStatus(this.getParameter(2, param));
        return EnvironmentalReverb.byteArrayToInt(param);
    }

    public void setDecayHFRatio(short decayHFRatio) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.shortToByteArray(decayHFRatio);
        this.checkStatus(this.setParameter(3, param));
    }

    public short getDecayHFRatio() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[2];
        this.checkStatus(this.getParameter(3, param));
        return EnvironmentalReverb.byteArrayToShort(param);
    }

    public void setReflectionsLevel(short reflectionsLevel) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.shortToByteArray(reflectionsLevel);
        this.checkStatus(this.setParameter(4, param));
    }

    public short getReflectionsLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[2];
        this.checkStatus(this.getParameter(4, param));
        return EnvironmentalReverb.byteArrayToShort(param);
    }

    public void setReflectionsDelay(int reflectionsDelay) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.intToByteArray(reflectionsDelay);
        this.checkStatus(this.setParameter(5, param));
    }

    public int getReflectionsDelay() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[4];
        this.checkStatus(this.getParameter(5, param));
        return EnvironmentalReverb.byteArrayToInt(param);
    }

    public void setReverbLevel(short reverbLevel) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.shortToByteArray(reverbLevel);
        this.checkStatus(this.setParameter(6, param));
    }

    public short getReverbLevel() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[2];
        this.checkStatus(this.getParameter(6, param));
        return EnvironmentalReverb.byteArrayToShort(param);
    }

    public void setReverbDelay(int reverbDelay) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.intToByteArray(reverbDelay);
        this.checkStatus(this.setParameter(7, param));
    }

    public int getReverbDelay() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[4];
        this.checkStatus(this.getParameter(7, param));
        return EnvironmentalReverb.byteArrayToInt(param);
    }

    public void setDiffusion(short diffusion) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.shortToByteArray(diffusion);
        this.checkStatus(this.setParameter(8, param));
    }

    public short getDiffusion() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[2];
        this.checkStatus(this.getParameter(8, param));
        return EnvironmentalReverb.byteArrayToShort(param);
    }

    public void setDensity(short density) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.shortToByteArray(density);
        this.checkStatus(this.setParameter(9, param));
    }

    public short getDensity() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[2];
        this.checkStatus(this.getParameter(9, param));
        return EnvironmentalReverb.byteArrayToShort(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = listener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
        }
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = new byte[PROPERTY_SIZE];
        this.checkStatus(this.getParameter(10, param));
        Settings settings = new Settings();
        settings.roomLevel = EnvironmentalReverb.byteArrayToShort(param, 0);
        settings.roomHFLevel = EnvironmentalReverb.byteArrayToShort(param, 2);
        settings.decayTime = EnvironmentalReverb.byteArrayToInt(param, 4);
        settings.decayHFRatio = EnvironmentalReverb.byteArrayToShort(param, 8);
        settings.reflectionsLevel = EnvironmentalReverb.byteArrayToShort(param, 10);
        settings.reflectionsDelay = EnvironmentalReverb.byteArrayToInt(param, 12);
        settings.reverbLevel = EnvironmentalReverb.byteArrayToShort(param, 16);
        settings.reverbDelay = EnvironmentalReverb.byteArrayToInt(param, 18);
        settings.diffusion = EnvironmentalReverb.byteArrayToShort(param, 22);
        settings.density = EnvironmentalReverb.byteArrayToShort(param, 24);
        return settings;
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        byte[] param = EnvironmentalReverb.concatArrays(EnvironmentalReverb.shortToByteArray(settings.roomLevel), EnvironmentalReverb.shortToByteArray(settings.roomHFLevel), EnvironmentalReverb.intToByteArray(settings.decayTime), EnvironmentalReverb.shortToByteArray(settings.decayHFRatio), EnvironmentalReverb.shortToByteArray(settings.reflectionsLevel), EnvironmentalReverb.intToByteArray(settings.reflectionsDelay), EnvironmentalReverb.shortToByteArray(settings.reverbLevel), EnvironmentalReverb.intToByteArray(settings.reverbDelay), EnvironmentalReverb.shortToByteArray(settings.diffusion), EnvironmentalReverb.shortToByteArray(settings.density));
        this.checkStatus(this.setParameter(10, param));
    }

    public static class Settings {
        public short roomLevel;
        public short roomHFLevel;
        public int decayTime;
        public short decayHFRatio;
        public short reflectionsLevel;
        public int reflectionsDelay;
        public short reverbLevel;
        public int reverbDelay;
        public short diffusion;
        public short density;

        public Settings() {
        }

        public Settings(String settings) {
            StringTokenizer st = new StringTokenizer(settings, "=;");
            int tokens = st.countTokens();
            if (st.countTokens() != 21) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals(EnvironmentalReverb.TAG)) {
                throw new IllegalArgumentException("invalid settings for EnvironmentalReverb: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("roomLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.roomLevel = Short.parseShort(st.nextToken());
                key = st.nextToken();
                if (!key.equals("roomHFLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.roomHFLevel = Short.parseShort(st.nextToken());
                key = st.nextToken();
                if (!key.equals("decayTime")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.decayTime = Integer.parseInt(st.nextToken());
                key = st.nextToken();
                if (!key.equals("decayHFRatio")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.decayHFRatio = Short.parseShort(st.nextToken());
                key = st.nextToken();
                if (!key.equals("reflectionsLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.reflectionsLevel = Short.parseShort(st.nextToken());
                key = st.nextToken();
                if (!key.equals("reflectionsDelay")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.reflectionsDelay = Integer.parseInt(st.nextToken());
                key = st.nextToken();
                if (!key.equals("reverbLevel")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.reverbLevel = Short.parseShort(st.nextToken());
                key = st.nextToken();
                if (!key.equals("reverbDelay")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.reverbDelay = Integer.parseInt(st.nextToken());
                key = st.nextToken();
                if (!key.equals("diffusion")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.diffusion = Short.parseShort(st.nextToken());
                key = st.nextToken();
                if (!key.equals("density")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.density = Short.parseShort(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        public String toString() {
            return new String("EnvironmentalReverb;roomLevel=" + Short.toString(this.roomLevel) + ";roomHFLevel=" + Short.toString(this.roomHFLevel) + ";decayTime=" + Integer.toString(this.decayTime) + ";decayHFRatio=" + Short.toString(this.decayHFRatio) + ";reflectionsLevel=" + Short.toString(this.reflectionsLevel) + ";reflectionsDelay=" + Integer.toString(this.reflectionsDelay) + ";reverbLevel=" + Short.toString(this.reverbLevel) + ";reverbDelay=" + Integer.toString(this.reverbDelay) + ";diffusion=" + Short.toString(this.diffusion) + ";density=" + Short.toString(this.density));
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            OnParameterChangeListener l = null;
            Object object = EnvironmentalReverb.this.mParamListenerLock;
            synchronized (object) {
                if (EnvironmentalReverb.this.mParamListener != null) {
                    l = EnvironmentalReverb.this.mParamListener;
                }
            }
            if (l != null) {
                int p = -1;
                int v = -1;
                if (param.length == 4) {
                    p = AudioEffect.byteArrayToInt(param, 0);
                }
                if (value.length == 2) {
                    v = AudioEffect.byteArrayToShort(value, 0);
                } else if (value.length == 4) {
                    v = AudioEffect.byteArrayToInt(value, 0);
                }
                if (p != -1 && v != -1) {
                    l.onParameterChange(EnvironmentalReverb.this, status, p, v);
                }
            }
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(EnvironmentalReverb var1, int var2, int var3, int var4);
    }
}

