/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

class MidiPortImpl {
    private static final String TAG = "MidiPort";
    public static final int PACKET_TYPE_DATA = 1;
    public static final int PACKET_TYPE_FLUSH = 2;
    public static final int MAX_PACKET_SIZE = 1024;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int DATA_PACKET_OVERHEAD = 9;
    public static final int MAX_PACKET_DATA_SIZE = 1015;

    MidiPortImpl() {
    }

    public static int packData(byte[] message, int offset, int size, long timestamp, byte[] dest) {
        if (size > 1015) {
            size = 1015;
        }
        int length = 0;
        dest[length++] = 1;
        System.arraycopy((byte[])message, (int)offset, (byte[])dest, (int)length, (int)size);
        length += size;
        for (int i = 0; i < 8; ++i) {
            dest[length++] = (byte)timestamp;
            timestamp >>= 8;
        }
        return length;
    }

    public static int packFlush(byte[] dest) {
        dest[0] = 2;
        return 1;
    }

    public static int getPacketType(byte[] buffer, int bufferLength) {
        return buffer[0];
    }

    public static int getDataOffset(byte[] buffer, int bufferLength) {
        return 1;
    }

    public static int getDataSize(byte[] buffer, int bufferLength) {
        return bufferLength - 9;
    }

    public static long getPacketTimestamp(byte[] buffer, int bufferLength) {
        int offset = bufferLength;
        long timestamp = 0L;
        for (int i = 0; i < 8; ++i) {
            int b = buffer[--offset] & 0xFF;
            timestamp = timestamp << 8 | (long)b;
        }
        return timestamp;
    }
}

