/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.content.Context;
import android.net.DhcpResults;
import android.net.NetworkUtils;
import android.net.TrafficStats;
import android.net.dhcp.DhcpAckPacket;
import android.net.dhcp.DhcpNakPacket;
import android.net.dhcp.DhcpOfferPacket;
import android.net.dhcp.DhcpPacket;
import android.net.metrics.DhcpClientEvent;
import android.net.metrics.DhcpErrorEvent;
import android.net.metrics.IpConnectivityLog;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.util.HexDump;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.internal.util.WakeupMessage;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import libcore.io.IoBridge;

public class DhcpClient
extends StateMachine {
    private static final String TAG = "DhcpClient";
    private static final boolean DBG = true;
    private static final boolean STATE_DBG = false;
    private static final boolean MSG_DBG = false;
    private static final boolean PACKET_DBG = false;
    private static final int SECONDS = 1000;
    private static final int FIRST_TIMEOUT_MS = 2000;
    private static final int MAX_TIMEOUT_MS = 128000;
    private static final int DHCP_TIMEOUT_MS = 36000;
    private static final int PUBLIC_BASE = 196608;
    public static final int CMD_START_DHCP = 196609;
    public static final int CMD_STOP_DHCP = 196610;
    public static final int CMD_PRE_DHCP_ACTION = 196611;
    public static final int CMD_POST_DHCP_ACTION = 196612;
    public static final int CMD_ON_QUIT = 196613;
    public static final int CMD_PRE_DHCP_ACTION_COMPLETE = 196614;
    public static final int CMD_CLEAR_LINKADDRESS = 196615;
    public static final int CMD_CONFIGURE_LINKADDRESS = 196616;
    public static final int EVENT_LINKADDRESS_CONFIGURED = 196617;
    public static final int DHCP_SUCCESS = 1;
    public static final int DHCP_FAILURE = 2;
    private static final int PRIVATE_BASE = 196708;
    private static final int CMD_KICK = 196709;
    private static final int CMD_RECEIVED_PACKET = 196710;
    private static final int CMD_TIMEOUT = 196711;
    private static final int CMD_RENEW_DHCP = 196712;
    private static final int CMD_REBIND_DHCP = 196713;
    private static final int CMD_EXPIRE_DHCP = 196714;
    private static final Class[] sMessageClasses = new Class[]{DhcpClient.class};
    private static final SparseArray<String> sMessageNames = MessageUtils.findMessageNames(sMessageClasses);
    static final byte[] REQUESTED_PARAMS = new byte[]{1, 3, 6, 15, 26, 28, 51, 58, 59, 43};
    private static final boolean DO_UNICAST = false;
    private final Context mContext;
    private final Random mRandom;
    private final IpConnectivityLog mMetricsLog = new IpConnectivityLog();
    private FileDescriptor mPacketSock;
    private FileDescriptor mUdpSock;
    private ReceiveThread mReceiveThread;
    private final StateMachine mController;
    private final WakeupMessage mKickAlarm;
    private final WakeupMessage mTimeoutAlarm;
    private final WakeupMessage mRenewAlarm;
    private final WakeupMessage mRebindAlarm;
    private final WakeupMessage mExpiryAlarm;
    private final String mIfaceName;
    private boolean mRegisteredForPreDhcpNotification;
    private NetworkInterface mIface;
    private byte[] mHwAddr;
    private PacketSocketAddress mInterfaceBroadcastAddr;
    private int mTransactionId;
    private long mTransactionStartMillis;
    private DhcpResults mDhcpLease;
    private long mDhcpLeaseExpiry;
    private DhcpResults mOffer;
    private long mLastInitEnterTime;
    private long mLastBoundExitTime;
    private State mStoppedState = new StoppedState();
    private State mDhcpState = new DhcpState();
    private State mDhcpInitState = new DhcpInitState();
    private State mDhcpSelectingState = new DhcpSelectingState();
    private State mDhcpRequestingState = new DhcpRequestingState();
    private State mDhcpHaveLeaseState = new DhcpHaveLeaseState();
    private State mConfiguringInterfaceState = new ConfiguringInterfaceState();
    private State mDhcpBoundState = new DhcpBoundState();
    private State mDhcpRenewingState = new DhcpRenewingState();
    private State mDhcpRebindingState = new DhcpRebindingState();
    private State mDhcpInitRebootState = new DhcpInitRebootState();
    private State mDhcpRebootingState = new DhcpRebootingState();
    private State mWaitBeforeStartState = new WaitBeforeStartState(this.mDhcpInitState);
    private State mWaitBeforeRenewalState = new WaitBeforeRenewalState(this.mDhcpRenewingState);

    private WakeupMessage makeWakeupMessage(String cmdName, int cmd) {
        cmdName = DhcpClient.class.getSimpleName() + "." + this.mIfaceName + "." + cmdName;
        return new WakeupMessage(this.mContext, this.getHandler(), cmdName, cmd);
    }

    private DhcpClient(Context context, StateMachine controller, String iface) {
        super(TAG);
        this.mContext = context;
        this.mController = controller;
        this.mIfaceName = iface;
        this.addState(this.mStoppedState);
        this.addState(this.mDhcpState);
        this.addState(this.mDhcpInitState, this.mDhcpState);
        this.addState(this.mWaitBeforeStartState, this.mDhcpState);
        this.addState(this.mDhcpSelectingState, this.mDhcpState);
        this.addState(this.mDhcpRequestingState, this.mDhcpState);
        this.addState(this.mDhcpHaveLeaseState, this.mDhcpState);
        this.addState(this.mConfiguringInterfaceState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpBoundState, this.mDhcpHaveLeaseState);
        this.addState(this.mWaitBeforeRenewalState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpRenewingState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpRebindingState, this.mDhcpHaveLeaseState);
        this.addState(this.mDhcpInitRebootState, this.mDhcpState);
        this.addState(this.mDhcpRebootingState, this.mDhcpState);
        this.setInitialState(this.mStoppedState);
        this.mRandom = new Random();
        this.mKickAlarm = this.makeWakeupMessage("KICK", 196709);
        this.mTimeoutAlarm = this.makeWakeupMessage("TIMEOUT", 196711);
        this.mRenewAlarm = this.makeWakeupMessage("RENEW", 196712);
        this.mRebindAlarm = this.makeWakeupMessage("REBIND", 196713);
        this.mExpiryAlarm = this.makeWakeupMessage("EXPIRY", 196714);
    }

    public void registerForPreDhcpNotification() {
        this.mRegisteredForPreDhcpNotification = true;
    }

    public static DhcpClient makeDhcpClient(Context context, StateMachine controller, String intf) {
        DhcpClient client = new DhcpClient(context, controller, intf);
        client.start();
        return client;
    }

    private boolean initInterface() {
        try {
            this.mIface = NetworkInterface.getByName(this.mIfaceName);
            this.mHwAddr = this.mIface.getHardwareAddress();
            this.mInterfaceBroadcastAddr = new PacketSocketAddress(this.mIface.getIndex(), DhcpPacket.ETHER_BROADCAST);
            return true;
        }
        catch (NullPointerException | SocketException e) {
            Log.e(TAG, "Can't determine ifindex or MAC address for " + this.mIfaceName, e);
            return false;
        }
    }

    private void startNewTransaction() {
        this.mTransactionId = this.mRandom.nextInt();
        this.mTransactionStartMillis = SystemClock.elapsedRealtime();
    }

    private boolean initSockets() {
        return this.initPacketSocket() && this.initUdpSocket();
    }

    private boolean initPacketSocket() {
        try {
            this.mPacketSock = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, OsConstants.ETH_P_IP);
            PacketSocketAddress addr = new PacketSocketAddress((short)OsConstants.ETH_P_IP, this.mIface.getIndex());
            Os.bind(this.mPacketSock, addr);
            NetworkUtils.attachDhcpFilter(this.mPacketSock);
        }
        catch (ErrnoException | SocketException e) {
            Log.e(TAG, "Error creating packet socket", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initUdpSocket() {
        int oldTag = TrafficStats.getAndSetThreadStatsTag(-192);
        try {
            this.mUdpSock = Os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_REUSEADDR, 1);
            Os.setsockoptIfreq(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_BINDTODEVICE, this.mIfaceName);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_BROADCAST, 1);
            Os.setsockoptInt(this.mUdpSock, OsConstants.SOL_SOCKET, OsConstants.SO_RCVBUF, 0);
            Os.bind(this.mUdpSock, Inet4Address.ANY, 68);
            NetworkUtils.protectFromVpn(this.mUdpSock);
        }
        catch (ErrnoException | SocketException e) {
            Log.e(TAG, "Error creating UDP socket", e);
            boolean bl = false;
            return bl;
        }
        finally {
            TrafficStats.setThreadStatsTag(oldTag);
        }
        return true;
    }

    private boolean connectUdpSock(Inet4Address to) {
        try {
            Os.connect(this.mUdpSock, to, 67);
            return true;
        }
        catch (ErrnoException | SocketException e) {
            Log.e(TAG, "Error connecting UDP socket", e);
            return false;
        }
    }

    private static void closeQuietly(FileDescriptor fd) {
        try {
            IoBridge.closeAndSignalBlockedThreads(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeSockets() {
        DhcpClient.closeQuietly(this.mUdpSock);
        DhcpClient.closeQuietly(this.mPacketSock);
    }

    private short getSecs() {
        return (short)((SystemClock.elapsedRealtime() - this.mTransactionStartMillis) / 1000L);
    }

    private boolean transmitPacket(ByteBuffer buf, String description, int encap, Inet4Address to) {
        try {
            if (encap == 0) {
                Log.d(TAG, "Broadcasting " + description);
                Os.sendto(this.mPacketSock, buf.array(), 0, buf.limit(), 0, this.mInterfaceBroadcastAddr);
            } else if (encap == 2 && to.equals(DhcpPacket.INADDR_BROADCAST)) {
                Log.d(TAG, "Broadcasting " + description);
                Os.sendto(this.mUdpSock, buf, 0, to, 67);
            } else {
                Log.d(TAG, String.format("Unicasting %s to %s", description, Os.getpeername(this.mUdpSock)));
                Os.write(this.mUdpSock, buf);
            }
        }
        catch (ErrnoException | IOException e) {
            Log.e(TAG, "Can't send packet: ", e);
            return false;
        }
        return true;
    }

    private boolean sendDiscoverPacket() {
        ByteBuffer packet = DhcpPacket.buildDiscoverPacket(0, this.mTransactionId, this.getSecs(), this.mHwAddr, false, REQUESTED_PARAMS);
        return this.transmitPacket(packet, "DHCPDISCOVER", 0, DhcpPacket.INADDR_BROADCAST);
    }

    private boolean sendRequestPacket(Inet4Address clientAddress, Inet4Address requestedAddress, Inet4Address serverAddress, Inet4Address to) {
        int encap = DhcpPacket.INADDR_ANY.equals(clientAddress) ? 0 : 2;
        ByteBuffer packet = DhcpPacket.buildRequestPacket(encap, this.mTransactionId, this.getSecs(), clientAddress, false, this.mHwAddr, requestedAddress, serverAddress, REQUESTED_PARAMS, null);
        String serverStr = serverAddress != null ? serverAddress.getHostAddress() : null;
        String description = "DHCPREQUEST ciaddr=" + clientAddress.getHostAddress() + " request=" + requestedAddress.getHostAddress() + " serverid=" + serverStr;
        return this.transmitPacket(packet, description, encap, to);
    }

    private void scheduleLeaseTimers() {
        if (this.mDhcpLeaseExpiry == 0L) {
            Log.d(TAG, "Infinite lease, no timer scheduling needed");
            return;
        }
        long now = SystemClock.elapsedRealtime();
        long remainingDelay = this.mDhcpLeaseExpiry - now;
        long renewDelay = remainingDelay / 2L;
        long rebindDelay = remainingDelay * 7L / 8L;
        this.mRenewAlarm.schedule(now + renewDelay);
        this.mRebindAlarm.schedule(now + rebindDelay);
        this.mExpiryAlarm.schedule(now + remainingDelay);
        Log.d(TAG, "Scheduling renewal in " + renewDelay / 1000L + "s");
        Log.d(TAG, "Scheduling rebind in " + rebindDelay / 1000L + "s");
        Log.d(TAG, "Scheduling expiry in " + remainingDelay / 1000L + "s");
    }

    private void notifySuccess() {
        this.mController.sendMessage(196612, 1, 0, new DhcpResults(this.mDhcpLease));
    }

    private void notifyFailure() {
        this.mController.sendMessage(196612, 2, 0, null);
    }

    private void acceptDhcpResults(DhcpResults results, String msg) {
        this.mDhcpLease = results;
        this.mOffer = null;
        Log.d(TAG, msg + " lease: " + this.mDhcpLease);
        this.notifySuccess();
    }

    private void clearDhcpState() {
        this.mDhcpLease = null;
        this.mDhcpLeaseExpiry = 0L;
        this.mOffer = null;
    }

    public void doQuit() {
        Log.d(TAG, "doQuit");
        this.quit();
    }

    @Override
    protected void onQuitting() {
        Log.d(TAG, "onQuitting");
        this.mController.sendMessage(196613);
    }

    public boolean isValidPacket(DhcpPacket packet) {
        int xid = packet.getTransactionId();
        if (xid != this.mTransactionId) {
            Log.d(TAG, "Unexpected transaction ID " + xid + ", expected " + this.mTransactionId);
            return false;
        }
        if (!Arrays.equals(packet.getClientMac(), this.mHwAddr)) {
            Log.d(TAG, "MAC addr mismatch: got " + HexDump.toHexString(packet.getClientMac()) + ", expected " + HexDump.toHexString(packet.getClientMac()));
            return false;
        }
        return true;
    }

    public void setDhcpLeaseExpiry(DhcpPacket packet) {
        long leaseTimeMillis = packet.getLeaseTimeMillis();
        this.mDhcpLeaseExpiry = leaseTimeMillis > 0L ? SystemClock.elapsedRealtime() + leaseTimeMillis : 0L;
    }

    private void logError(int errorCode) {
        this.mMetricsLog.log(this.mIfaceName, (Parcelable)new DhcpErrorEvent(errorCode));
    }

    private void logState(String name, int durationMs) {
        this.mMetricsLog.log(this.mIfaceName, (Parcelable)new DhcpClientEvent(name, durationMs));
    }

    class DhcpRebootingState
    extends LoggingState {
        DhcpRebootingState() {
        }
    }

    class DhcpInitRebootState
    extends LoggingState {
        DhcpInitRebootState() {
        }
    }

    class DhcpRebindingState
    extends DhcpReacquiringState {
        public DhcpRebindingState() {
            this.mLeaseMsg = "Rebound";
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.closeQuietly(DhcpClient.this.mUdpSock);
            if (!DhcpClient.this.initUdpSocket()) {
                Log.e(DhcpClient.TAG, "Failed to recreate UDP socket");
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
            }
        }

        @Override
        protected Inet4Address packetDestination() {
            return DhcpPacket.INADDR_BROADCAST;
        }
    }

    class DhcpRenewingState
    extends DhcpReacquiringState {
        public DhcpRenewingState() {
            this.mLeaseMsg = "Renewed";
        }

        @Override
        public boolean processMessage(Message message) {
            if (super.processMessage(message)) {
                return true;
            }
            switch (message.what) {
                case 196713: {
                    DhcpClient.this.transitionTo(DhcpClient.this.mDhcpRebindingState);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected Inet4Address packetDestination() {
            return ((DhcpClient)DhcpClient.this).mDhcpLease.serverAddress != null ? ((DhcpClient)DhcpClient.this).mDhcpLease.serverAddress : DhcpPacket.INADDR_BROADCAST;
        }
    }

    abstract class DhcpReacquiringState
    extends PacketRetransmittingState {
        protected String mLeaseMsg;

        DhcpReacquiringState() {
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.startNewTransaction();
        }

        protected abstract Inet4Address packetDestination();

        @Override
        protected boolean sendPacket() {
            return DhcpClient.this.sendRequestPacket((Inet4Address)((DhcpClient)DhcpClient.this).mDhcpLease.ipAddress.getAddress(), DhcpPacket.INADDR_ANY, null, this.packetDestination());
        }

        @Override
        protected void receivePacket(DhcpPacket packet) {
            if (!DhcpClient.this.isValidPacket(packet)) {
                return;
            }
            if (packet instanceof DhcpAckPacket) {
                DhcpResults results = packet.toDhcpResults();
                if (results != null) {
                    if (!((DhcpClient)DhcpClient.this).mDhcpLease.ipAddress.equals(results.ipAddress)) {
                        Log.d(DhcpClient.TAG, "Renewed lease not for our current IP address!");
                        DhcpClient.this.notifyFailure();
                        DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
                    }
                    DhcpClient.this.setDhcpLeaseExpiry(packet);
                    DhcpClient.this.acceptDhcpResults(results, this.mLeaseMsg);
                    DhcpClient.this.transitionTo(DhcpClient.this.mDhcpBoundState);
                }
            } else if (packet instanceof DhcpNakPacket) {
                Log.d(DhcpClient.TAG, "Received NAK, returning to INIT");
                DhcpClient.this.notifyFailure();
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
            }
        }
    }

    class DhcpBoundState
    extends LoggingState {
        DhcpBoundState() {
        }

        @Override
        public void enter() {
            super.enter();
            if (((DhcpClient)DhcpClient.this).mDhcpLease.serverAddress != null && !DhcpClient.this.connectUdpSock(((DhcpClient)DhcpClient.this).mDhcpLease.serverAddress)) {
                DhcpClient.this.notifyFailure();
                DhcpClient.this.transitionTo(DhcpClient.this.mStoppedState);
            }
            DhcpClient.this.scheduleLeaseTimers();
            this.logTimeToBoundState();
        }

        @Override
        public void exit() {
            super.exit();
            DhcpClient.this.mLastBoundExitTime = SystemClock.elapsedRealtime();
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196712: {
                    if (DhcpClient.this.mRegisteredForPreDhcpNotification) {
                        DhcpClient.this.transitionTo(DhcpClient.this.mWaitBeforeRenewalState);
                    } else {
                        DhcpClient.this.transitionTo(DhcpClient.this.mDhcpRenewingState);
                    }
                    return true;
                }
            }
            return false;
        }

        private void logTimeToBoundState() {
            long now = SystemClock.elapsedRealtime();
            if (DhcpClient.this.mLastBoundExitTime > DhcpClient.this.mLastInitEnterTime) {
                DhcpClient.this.logState("RenewingBoundState", (int)(now - DhcpClient.this.mLastBoundExitTime));
            } else {
                DhcpClient.this.logState("InitialBoundState", (int)(now - DhcpClient.this.mLastInitEnterTime));
            }
        }
    }

    class ConfiguringInterfaceState
    extends LoggingState {
        ConfiguringInterfaceState() {
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.mController.sendMessage(196616, ((DhcpClient)DhcpClient.this).mDhcpLease.ipAddress);
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196617: {
                    DhcpClient.this.transitionTo(DhcpClient.this.mDhcpBoundState);
                    return true;
                }
            }
            return false;
        }
    }

    class DhcpHaveLeaseState
    extends State {
        DhcpHaveLeaseState() {
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 196714: {
                    Log.d(DhcpClient.TAG, "Lease expired!");
                    DhcpClient.this.notifyFailure();
                    DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            DhcpClient.this.mRenewAlarm.cancel();
            DhcpClient.this.mRebindAlarm.cancel();
            DhcpClient.this.mExpiryAlarm.cancel();
            DhcpClient.this.clearDhcpState();
            DhcpClient.this.mController.sendMessage(196615);
        }
    }

    class DhcpRequestingState
    extends PacketRetransmittingState {
        public DhcpRequestingState() {
            this.mTimeout = 18000;
        }

        @Override
        protected boolean sendPacket() {
            return DhcpClient.this.sendRequestPacket(DhcpPacket.INADDR_ANY, (Inet4Address)((DhcpClient)DhcpClient.this).mOffer.ipAddress.getAddress(), ((DhcpClient)DhcpClient.this).mOffer.serverAddress, DhcpPacket.INADDR_BROADCAST);
        }

        @Override
        protected void receivePacket(DhcpPacket packet) {
            if (!DhcpClient.this.isValidPacket(packet)) {
                return;
            }
            if (packet instanceof DhcpAckPacket) {
                DhcpResults results = packet.toDhcpResults();
                if (results != null) {
                    DhcpClient.this.setDhcpLeaseExpiry(packet);
                    DhcpClient.this.acceptDhcpResults(results, "Confirmed");
                    DhcpClient.this.transitionTo(DhcpClient.this.mConfiguringInterfaceState);
                }
            } else if (packet instanceof DhcpNakPacket) {
                Log.d(DhcpClient.TAG, "Received NAK, returning to INIT");
                DhcpClient.this.mOffer = null;
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
            }
        }

        @Override
        protected void timeout() {
            DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
        }
    }

    class DhcpSelectingState
    extends LoggingState {
        DhcpSelectingState() {
        }
    }

    class DhcpInitState
    extends PacketRetransmittingState {
        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.startNewTransaction();
            DhcpClient.this.mLastInitEnterTime = SystemClock.elapsedRealtime();
        }

        @Override
        protected boolean sendPacket() {
            return DhcpClient.this.sendDiscoverPacket();
        }

        @Override
        protected void receivePacket(DhcpPacket packet) {
            if (!DhcpClient.this.isValidPacket(packet)) {
                return;
            }
            if (!(packet instanceof DhcpOfferPacket)) {
                return;
            }
            DhcpClient.this.mOffer = packet.toDhcpResults();
            if (DhcpClient.this.mOffer != null) {
                Log.d(DhcpClient.TAG, "Got pending lease: " + DhcpClient.this.mOffer);
                DhcpClient.this.transitionTo(DhcpClient.this.mDhcpRequestingState);
            }
        }
    }

    abstract class PacketRetransmittingState
    extends LoggingState {
        private int mTimer;
        protected int mTimeout;

        PacketRetransmittingState() {
            this.mTimeout = 0;
        }

        @Override
        public void enter() {
            super.enter();
            this.initTimer();
            this.maybeInitTimeout();
            DhcpClient.this.sendMessage(196709);
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196709: {
                    this.sendPacket();
                    this.scheduleKick();
                    return true;
                }
                case 196710: {
                    this.receivePacket((DhcpPacket)message.obj);
                    return true;
                }
                case 196711: {
                    this.timeout();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            super.exit();
            DhcpClient.this.mKickAlarm.cancel();
            DhcpClient.this.mTimeoutAlarm.cancel();
        }

        protected abstract boolean sendPacket();

        protected abstract void receivePacket(DhcpPacket var1);

        protected void timeout() {
        }

        protected void initTimer() {
            this.mTimer = 2000;
        }

        protected int jitterTimer(int baseTimer) {
            int maxJitter = baseTimer / 10;
            int jitter = DhcpClient.this.mRandom.nextInt(2 * maxJitter) - maxJitter;
            return baseTimer + jitter;
        }

        protected void scheduleKick() {
            long now = SystemClock.elapsedRealtime();
            long timeout = this.jitterTimer(this.mTimer);
            long alarmTime = now + timeout;
            DhcpClient.this.mKickAlarm.schedule(alarmTime);
            this.mTimer *= 2;
            if (this.mTimer > 128000) {
                this.mTimer = 128000;
            }
        }

        protected void maybeInitTimeout() {
            if (this.mTimeout > 0) {
                long alarmTime = SystemClock.elapsedRealtime() + (long)this.mTimeout;
                DhcpClient.this.mTimeoutAlarm.schedule(alarmTime);
            }
        }
    }

    class DhcpState
    extends State {
        DhcpState() {
        }

        @Override
        public void enter() {
            DhcpClient.this.clearDhcpState();
            if (DhcpClient.this.initInterface() && DhcpClient.this.initSockets()) {
                DhcpClient.this.mReceiveThread = new ReceiveThread();
                DhcpClient.this.mReceiveThread.start();
            } else {
                DhcpClient.this.notifyFailure();
                DhcpClient.this.transitionTo(DhcpClient.this.mStoppedState);
            }
        }

        @Override
        public void exit() {
            if (DhcpClient.this.mReceiveThread != null) {
                DhcpClient.this.mReceiveThread.halt();
                DhcpClient.this.mReceiveThread = null;
            }
            DhcpClient.this.clearDhcpState();
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196610: {
                    DhcpClient.this.transitionTo(DhcpClient.this.mStoppedState);
                    return true;
                }
            }
            return false;
        }
    }

    class WaitBeforeRenewalState
    extends WaitBeforeOtherState {
        public WaitBeforeRenewalState(State otherState) {
            this.mOtherState = otherState;
        }
    }

    class WaitBeforeStartState
    extends WaitBeforeOtherState {
        public WaitBeforeStartState(State otherState) {
            this.mOtherState = otherState;
        }
    }

    class StoppedState
    extends State {
        StoppedState() {
        }

        @Override
        public boolean processMessage(Message message) {
            switch (message.what) {
                case 196609: {
                    if (DhcpClient.this.mRegisteredForPreDhcpNotification) {
                        DhcpClient.this.transitionTo(DhcpClient.this.mWaitBeforeStartState);
                    } else {
                        DhcpClient.this.transitionTo(DhcpClient.this.mDhcpInitState);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    abstract class WaitBeforeOtherState
    extends LoggingState {
        protected State mOtherState;

        WaitBeforeOtherState() {
        }

        @Override
        public void enter() {
            super.enter();
            DhcpClient.this.mController.sendMessage(196611);
        }

        @Override
        public boolean processMessage(Message message) {
            super.processMessage(message);
            switch (message.what) {
                case 196614: {
                    DhcpClient.this.transitionTo(this.mOtherState);
                    return true;
                }
            }
            return false;
        }
    }

    abstract class LoggingState
    extends State {
        private long mEnterTimeMs;

        LoggingState() {
        }

        @Override
        public void enter() {
            this.mEnterTimeMs = SystemClock.elapsedRealtime();
        }

        @Override
        public void exit() {
            long durationMs = SystemClock.elapsedRealtime() - this.mEnterTimeMs;
            DhcpClient.this.logState(this.getName(), (int)durationMs);
        }

        private String messageName(int what) {
            return sMessageNames.get(what, Integer.toString(what));
        }

        private String messageToString(Message message) {
            long now = SystemClock.uptimeMillis();
            StringBuilder b = new StringBuilder(" ");
            TimeUtils.formatDuration(message.getWhen() - now, b);
            b.append(" ").append(this.messageName(message.what)).append(" ").append(message.arg1).append(" ").append(message.arg2).append(" ").append(message.obj);
            return b.toString();
        }

        @Override
        public boolean processMessage(Message message) {
            return false;
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName();
        }
    }

    class ReceiveThread
    extends Thread {
        private final byte[] mPacket = new byte[1500];
        private volatile boolean mStopped = false;

        ReceiveThread() {
        }

        public void halt() {
            this.mStopped = true;
            DhcpClient.this.closeSockets();
        }

        @Override
        public void run() {
            Log.d(DhcpClient.TAG, "Receive thread started");
            while (!this.mStopped) {
                int length = 0;
                try {
                    length = Os.read(DhcpClient.this.mPacketSock, this.mPacket, 0, this.mPacket.length);
                    DhcpPacket packet = null;
                    packet = DhcpPacket.decodeFullPacket(this.mPacket, length, 0);
                    Log.d(DhcpClient.TAG, "Received packet: " + packet);
                    DhcpClient.this.sendMessage(196710, packet);
                }
                catch (ErrnoException | IOException e) {
                    if (this.mStopped) continue;
                    Log.e(DhcpClient.TAG, "Read error", e);
                    DhcpClient.this.logError(DhcpErrorEvent.RECEIVE_ERROR);
                }
                catch (DhcpPacket.ParseException e) {
                    Log.e(DhcpClient.TAG, "Can't parse packet: " + e.getMessage());
                    if (e.errorCode == DhcpErrorEvent.DHCP_NO_COOKIE) {
                        int snetTagId = 1397638484;
                        String bugId = "31850211";
                        int uid = -1;
                        String data = DhcpPacket.ParseException.class.getName();
                        EventLog.writeEvent(snetTagId, bugId, uid, data);
                    }
                    DhcpClient.this.logError(e.errorCode);
                }
            }
            Log.d(DhcpClient.TAG, "Receive thread stopped");
        }
    }
}

